#include "systray.h"

#ifdef _WIN32_

#define SYSTRAY_MSG WM_APP

LRESULT CALLBACK wndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{ 
 switch (message) 
 {
	case SYSTRAY_MSG:

		switch (lParam) 
		{
        		case WM_RBUTTONDOWN:
				tray_menu();
				break;
        		case WM_LBUTTONDBLCLK: 
				if (status) 
				{
					xchat_command(ph,"gui hide");
					status=0;
				}
				else 
				{ 
					xchat_command(ph,"gui show");
					select_event_tab(TRUE);
					status=1;
				}
				break;
			case WM_MBUTTONDOWN: 
				if (status) 
				{
					xchat_command(ph,"gui hide");
					status=0;
				}
				else 
				{ 
					xchat_command(ph,"gui show");
					status=1;
				}
				break;
			case WM_LBUTTONDOWN:
				select_event_tab(FALSE);
				break;
			 
			default:
				return 1;
		}
		break;
		
	default:
		return DefWindowProc(hwnd, message, wParam, lParam); 
 }
}
#endif

void update_tray(MYICON newicon, char* newtooltip) 
{
	if (newicon!=NULL || newtooltip!="")
	{
#ifdef _WIN32_
		ZeroMemory(&tray_icon,sizeof(tray_icon));
		tray_icon.cbSize=sizeof(NOTIFYICONDATA);
		tray_icon.hWnd=hidden_win;
		tray_icon.uID=0;
		tray_icon.uFlags=0;
		tray_icon.uCallbackMessage = SYSTRAY_MSG;
	
		if (newicon!=NULL) 
		{
			tray_icon.hIcon=newicon;
			tray_icon.uFlags |= NIF_ICON;
		}
		
        	if (newtooltip!="") 
		{
			lstrcpy(tray_icon.szTip, newtooltip);
			g_free(newtooltip);
			newtooltip=NULL;
			tray_icon.uFlags |= NIF_TIP;
		}
		
		Shell_NotifyIcon(NIM_MODIFY,&tray_icon);

		
#else
		if ( newicon!=NULL ) 
		{
			gtk_image_set_from_pixbuf(GTK_IMAGE(tray_icon_image), newicon);
			newicon=NULL;
			
		}	
		if ( newtooltip!="") 
		{
			gtk_tooltips_set_tip (tray_icon_tooltip, GTK_WIDGET (tray_icon), newtooltip , NULL);
			newtooltip=NULL;
		}
#endif
	}

}

//INIZIALIZATION OF PLUGIN AND TRAY ICON

void initialize_shared_vars()
{
	flash_id=0;
	status=1;
	onExit=1;
#ifndef _WIN32_
	KDE=FALSE;
#endif
	flash_interval=500;
	global_away=FALSE;
	global_away_temp=FALSE;
	edit=TRUE;
	go_change=TRUE;
	go_identify=TRUE;
	strcpy(imagepath,xchat_get_info(ph, "xchatdir"));

}
// events handling
 void tray_init_xchat(void)
{
	initialize_shared_vars();
	//show warning if version is too old
	const char *str;
	int i;
	if (xchat_get_prefs (ph, "away_size_max", &str, &i) == 0)
	version_warning();

	focus_ctx = xchat_get_context(ph);
	xchat_hook_print(ph, "Focus Tab", XCHAT_PRI_NORM, noti_focus_cb, 0);
	xchat_hook_print(ph, "Channel Action Hilight", XCHAT_PRI_NORM, noti_hilight_cb, 0);
	xchat_hook_print(ph, "Channel Msg Hilight", XCHAT_PRI_NORM, noti_hilight_cb, 0);
	xchat_hook_print(ph, "Private Message", XCHAT_PRI_NORM, query_cb, NULL);
	xchat_hook_print(ph, "Private Message to Dialog", XCHAT_PRI_NORM, query_cb, 0);
	xchat_hook_print(ph, "Disconnected", XCHAT_PRI_NORM, disconnect_cb, 0);
	xchat_hook_print(ph, "You kicked", XCHAT_PRI_NORM, kicked_cb, 0);
	xchat_hook_print(ph, "Killed", XCHAT_PRI_NORM, killed_cb, 0);
	xchat_hook_print(ph, "DCC CHAT Offer", XCHAT_PRI_NORM, chatreq_cb, 0);
	xchat_hook_print(ph, "DCC CHAT Reoffer", XCHAT_PRI_NORM, chatreq_cb, 0);
	xchat_hook_print(ph, "DCC SEND offer", XCHAT_PRI_NORM, dcc_cb, 0);
	xchat_hook_print(ph, "Invited", XCHAT_PRI_NORM, invited_cb, 0);
	xchat_hook_print(ph, "Notify Offline", XCHAT_PRI_NORM, notout_cb, 0);
	xchat_hook_print(ph, "Notify Online", XCHAT_PRI_NORM, notin_cb, 0);
	xchat_printf(ph, "SysTray Integration Plugin Version %s successfully loaded",version);
	xchat_printf(ph, "Patrizio Bassi - hetfield666@virgilio.it - http://www.blight.tk");

	//set apps variables, only on start
	get_info( TRUE,TRUE );
	servers_names = g_hash_table_new( NULL,NULL );
#ifndef _WIN32_
	window_manager_modified=KDE;
#endif

}

#ifndef _WIN32_
//used for set different options for kde like win manager
//prevents errors, destroy events etc...
void desktopSetup()
{
	GdkWindow* window=tray_icon->window;
	glong data[1];

	GdkAtom kwm_dockwindow_atom;
	GdkAtom kde_net_system_tray_window_for_atom;

	kwm_dockwindow_atom = gdk_atom_intern("KWM_DOCKWINDOW", FALSE);
	kde_net_system_tray_window_for_atom = gdk_atom_intern("_KDE_NET_WM_SYSTEM_TRAY_WINDOW_FOR", FALSE);

	/* This is the old KDE 1.0 and GNOME 1.2 way... */
	data[0] = TRUE;
	gdk_property_change(window, kwm_dockwindow_atom, kwm_dockwindow_atom, 32, GDK_PROP_MODE_REPLACE, (guchar *)&data, 1);

	/* This is needed to support KDE 2.x & 3.x*/
	data[0] = 0;
	gdk_property_change(window, kde_net_system_tray_window_for_atom, (GdkAtom)XA_WINDOW, 32, GDK_PROP_MODE_REPLACE, (guchar *)&data, 1);

}
#endif



MYICON loadicons(char* filename,char* type) 
{
	MYICON tempbuffer=NULL;
	char temp[200];
	if (filename && type) 
	{
		if (imagepath) sprintf(temp,"%s/%s/%s", imagepath ,type,filename);
		else sprintf(temp,"%s/%s/%s", xchat_get_info(ph, "xchatdir"),type,filename);
#ifdef _WIN32_			
		tempbuffer= ((HICON)LoadImage( tray_inst, temp, IMAGE_ICON, 16, 16, LR_LOADFROMFILE ));
#else	
		tempbuffer= gdk_pixbuf_new_from_file(temp,NULL);
#endif
		return tempbuffer;
	}
	else return NULL;

}

#ifdef _WIN32_
void tray_init_gui_win32() 
{
	WNDCLASSEX winclassex;
	
	winclassex.cbSize 		= sizeof(WNDCLASSEX);
	winclassex.style	        = 0;
	winclassex.lpfnWndProc 		= wndProc;
	winclassex.cbClsExtra		= 0;
	winclassex.cbWndExtra		= 0;
	winclassex.hInstance		= tray_inst;
	winclassex.hIcon		= pix_xchat;
	winclassex.hCursor		= NULL,
	winclassex.hbrBackground	= NULL;
	winclassex.lpszMenuName		= NULL;
	winclassex.lpszClassName	= "SysTrayWinClass";
	winclassex.hIconSm		= pix_xchat;
		
	RegisterClassEx(&winclassex);
	
	// Create the hidden window
	hidden_win=CreateWindow("SysTrayWinClass", "", 0, 0, 0, 0, 0, GetDesktopWindow(), NULL, tray_inst, 0);
	
	pix_xchat=loadicons("xchat.ico","Win32Tray");
	pix_xchat_red = loadicons("xchatred.ico","Win32Tray");
	pix_xchat_blue = loadicons("xchatblue.ico","Win32Tray");
	pix_xchat_dcc = loadicons("dccalert.ico","Win32Tray");
	pix_xchat_disc = loadicons("disconnected.ico","Win32Tray");
	pix_xchat_inv = loadicons("invited.ico","Win32Tray");
	pix_xchat_notin = loadicons("notifyin.ico","Win32Tray");
	pix_xchat_notout = loadicons("notifyout.ico","Win32Tray");
	pix_xchat_away = loadicons("goaway.ico","Win32Tray");
	
	if (pix_xchat) icontype = pix_xchat;
	
	if (!pix_xchat || !pix_xchat_red || !pix_xchat_blue || !pix_xchat_dcc || !pix_xchat_disc ||!pix_xchat_inv
	|| !pix_xchat_notin ||!pix_xchat_notout ||!pix_xchat_away ||!icontype ) 
	{
		xchat_printf(ph,"Icon load failed. Please enter the right path in the setting tab, check if filenames are not wrong and reload plugin");
	}
	
	ZeroMemory(&tray_icon,sizeof(tray_icon));
	tray_icon.cbSize=sizeof(NOTIFYICONDATA);
	tray_icon.hWnd=hidden_win;
	tray_icon.uID=0;
	tray_icon.uFlags=NIF_ICON | NIF_MESSAGE | NIF_TIP;
	tray_icon.uCallbackMessage = SYSTRAY_MSG;
	tray_icon.hIcon=pix_xchat;
	
	strcpy(tray_icon.szTip, "XChat2 - Nothing Particular");
	Shell_NotifyIcon(NIM_ADD,&tray_icon);

}
#else
// gui start and icon setting
void tray_init_gui_gtk (void)
{
	GtkWidget *eventbox;

	//set the pics
	pix_xchat = loadicons("xchat.png","GTKTray");
	pix_xchat_red = loadicons("xchatred.png","GTKTray");
	pix_xchat_blue = loadicons("xchatblue.png","GTKTray");
	pix_xchat_dcc = loadicons("dccalert.png","GTKTray");
	pix_xchat_disc = loadicons("disconnected.png","GTKTray");
	pix_xchat_inv = loadicons("invited.png","GTKTray");
	pix_xchat_notin = loadicons("notifyin.png","GTKTray");
	pix_xchat_notout = loadicons("notifyout.png","GTKTray");
	pix_xchat_away = loadicons("goaway.png","GTKTray");
	icontype = pix_xchat;
	
	//kde
	if ( KDE )
	{
		tray_icon=gtk_window_new( GTK_WINDOW_TOPLEVEL );
		gtk_window_set_title( GTK_WINDOW(tray_icon), "XChat SysTray Plugin Integration" );
		gtk_window_set_wmclass( GTK_WINDOW(tray_icon),"xchat_tray","xchat" );
	}
	//not kde
	else
	{
		tray_icon = GTK_WIDGET( egg_tray_icon_new( "XChat SysTray Plugin Integration") );
		if ( tray_icon == NULL )
		{
			xchat_printf( ph,"Unable to create SysTray. Plugin will be unloaded.\n" );
			unload_plugin();
			return;
		}
		
	}
	gtk_widget_set_usize( tray_icon,22,22);
	gtk_widget_realize ( tray_icon );
		
	tray_icon_image = gtk_image_new_from_pixbuf ( pix_xchat );

	eventbox = gtk_event_box_new ();
	
	
	gtk_container_add ( GTK_CONTAINER ( eventbox ), tray_icon_image );
	gtk_container_add ( GTK_CONTAINER ( tray_icon ), eventbox );
	
	g_signal_connect ( G_OBJECT ( eventbox), "button_press_event" , G_CALLBACK ( tray_clicked ), NULL );
	g_signal_connect ( GTK_OBJECT( tray_icon), "destroy" , GTK_SIGNAL_FUNC( gtk_widget_destroyed ),&tray_icon );
	g_signal_connect ( G_OBJECT ( tray_icon), "destroy" , GTK_SIGNAL_FUNC( gtk_widget_destroyed ), NULL );

	if ( KDE ) desktopSetup ();

	//finalize
	gtk_widget_show ( GTK_WIDGET ( tray_icon ) );
	gtk_widget_show ( eventbox );
	gtk_widget_show ( GTK_WIDGET (tray_icon_image));
	
	//tooltip
	tray_icon_tooltip = gtk_tooltips_new ();
	gtk_tooltips_set_tip ( tray_icon_tooltip, GTK_WIDGET ( tray_icon ), "XChat2 - Nothing Particular" , NULL );
	gtk_tooltips_set_delay ( tray_icon_tooltip, 1000 );

}
#endif

//start gui and plugin
void tray_init(void)
{
#ifndef _WIN32_
	//fix seg. fault on xchat-text, the XChat version without GTK
    	if ( !gdk_display ) 
	{
		xchat_printf( ph,"SysTray Integration Plugin Version %s NOT loaded!\nYou are not using a GUI version of XChat2.\n",version );
              return;
	}
#endif
	tray_init_xchat();
#ifndef _WIN32_
	tray_init_gui_gtk();
#else
	tray_init_gui_win32();
#endif
}

void clean_up()
{
	if (servers_names) 
	{
		g_hash_table_destroy(servers_names);
		servers_names=NULL;
	}
	
#ifndef _WIN32_

	if (tray_icon) 
	{
		gtk_widget_destroy (GTK_WIDGET (tray_icon));
		tray_icon=NULL;
	}
	icontype = NULL;
	pix_xchat = NULL;
	pix_xchat_red = NULL;
	pix_xchat_blue = NULL;
	pix_xchat_dcc = NULL;
	pix_xchat_disc = NULL;
	pix_xchat_inv = NULL;
	pix_xchat_notin = NULL;
	pix_xchat_notout = NULL;
	pix_xchat_away = NULL;
	
	if (tray_icon_tooltip) tray_icon_tooltip=NULL;

#else

	Shell_NotifyIcon( NIM_DELETE, &tray_icon );
	if ( hidden_win ) 
	{
		DestroyWindow( hidden_win );
		hidden_win=NULL;
	}
	if ( tray_inst )  tray_inst = NULL;
	if ( pix_xchat ) 
	{
		DestroyIcon( pix_xchat );
		pix_xchat=NULL;
	}
	if ( pix_xchat_red ) 
	{
		DestroyIcon( pix_xchat_red );
		pix_xchat_red=NULL;
	}
	if ( pix_xchat_blue ) 
	{
		DestroyIcon( pix_xchat_blue );
		pix_xchat_blue=NULL;
	}
	if ( pix_xchat_dcc ) 
	{
		DestroyIcon( pix_xchat_dcc );
		pix_xchat_dcc=NULL;
	}
	if ( pix_xchat_disc ) 
	{
		DestroyIcon( pix_xchat_disc );
		pix_xchat_disc=NULL;
	}	
	if ( pix_xchat_inv ) 
	{
		DestroyIcon( pix_xchat_inv );
		pix_xchat_inv=NULL;
	}
	if ( pix_xchat_notin ) 
	{
		DestroyIcon( pix_xchat_notin );
		pix_xchat_notin=NULL;
	}
	if ( pix_xchat_notout ) 
	{
		DestroyIcon( pix_xchat_notout );
		pix_xchat_notout=NULL;
	}
	if ( pix_xchat_away ) 
	{
		DestroyIcon( pix_xchat_away );
		pix_xchat_away=NULL;
	}
	UnregisterClass("SysTrayWinClass", NULL);
#endif

}

//unloading function
int xchat_plugin_deinit(xchat_plugin *plugin_handle)
{
#ifndef _WIN32_

	if( gdk_display )
	{
		if ( onExit==1 ) 
		{
			clean_up();
			xchat_print( ph, "SysTray Integration Plugin unloaded\n");
		}
	}

#else

	if ( onExit == 1 )
	{
		clean_up();
		xchat_print( ph, "SysTray Integration Plugin unloaded\n" );
	}

#endif
	return 1;
}

//bootstrap
int xchat_plugin_init(
				xchat_plugin *plugin_handle,
				char **plugin_name,
				char **plugin_desc,
				char **plugin_version,
				char *arg)
{
	ph = plugin_handle;

	*plugin_name = "SysTray";
	*plugin_desc = "SysTray Integration Plugin";
	*plugin_version = "2.4.5";

	version = *plugin_version;
	tray_init ();

	return 1;
}


