 /*
 *  file      : popup_systray.c
 *  project   : xcfa
 *  with      : Gtk-2
 *
 *  copyright : (C) 2003 - 2012 by Claude Bulin
 *
 *  xcfa - GTK+ implementation of the GNU shell command
 *  GNU General Public License
 *
 *  This file is part of XCFA.
 * 
 *  XCFA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  at your option) any later version.
 * 
 *  XCFA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with XCFA.  If not, see <http://www.gnu.org/licenses/>.
 */



#ifdef HAVE_CONFIG_H
	#include "../config.h"
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <glib.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "configuser.h"
#include "popup_systray.h"



// 
// 
// SYSTRAY: CREATION DE L'ICONE DE STATUS + INFO-BULLE
// 
// 
typedef struct {
	GtkStatusIcon	*p_status_icon;			// 
	gboolean	 BoolMainShow;			// 
	gboolean	 BoolMainAction;		// TRUE = Action ELSE FALSE
} VAR_POPUP_SYSTRAY;

VAR_POPUP_SYSTRAY	VarPopupSystray = {
			NULL,		// p_status_icon
			TRUE,		// BoolMainShow
			FALSE		// BoolMainAction
			};


void on_quitter1_activate (GtkMenuItem *menuitem, gpointer user_data);



// 
// 
void PopupSystray_set_BoolMainAction (gboolean p_BoolMainAction)
{
	VarPopupSystray.BoolMainAction = p_BoolMainAction;
}
// 
// 
void PopupSystray_show_hide (void)
{
	static GdkScreen *screen;

	if( GTK_WIDGET_FLAGS(WindMain) & GTK_VISIBLE ){
		gtk_window_get_position( GTK_WINDOW(WindMain), &Config.WinPos_X, &Config.WinPos_Y);
		screen = gtk_window_get_screen( GTK_WINDOW(WindMain) );
		gtk_widget_hide( GTK_WIDGET(WindMain) );
		VarPopupSystray.BoolMainShow = FALSE;
	} else {
		gtk_window_set_screen( GTK_WINDOW(WindMain), screen);
		gtk_window_move( GTK_WINDOW(WindMain), Config.WinPos_X, Config.WinPos_Y);
		gtk_widget_show( GTK_WIDGET (WindMain) );
		gtk_window_present( GTK_WINDOW(WindMain) );
		gtk_window_deiconify( GTK_WINDOW(WindMain) );
		VarPopupSystray.BoolMainShow = TRUE;
	}
}
// 
// 
void PopupSystray_for_action (GtkMenuItem *menuitem, gpointer user_data)
{
	gint channel = GPOINTER_TO_INT(user_data);
	
	if (0 == channel) {
		PopupSystray_show_hide ();
	}
	else if (2 == channel) {
		on_quitter1_activate (NULL, NULL);
	}
}
// 
// 
void PopupSystray_function (GtkStatusIcon *status_icon, guint button, guint activate_time,  gpointer  user_data)
{
	GtkWidget	*menu_systray;
	GtkWidget	*menu_systray_hide;
	GtkWidget	*menu_systray_quit;
	GtkWidget	*sep;
	GtkWidget	*Image = NULL;
	GtkWidget	*ImageQuit = NULL;
	
	menu_systray = gtk_menu_new ();
	gtk_widget_set_extension_events (menu_systray, GDK_EXTENSION_EVENTS_ALL);
	
	if (TRUE == VarPopupSystray.BoolMainShow) {
		menu_systray_hide = gtk_image_menu_item_new_with_mnemonic (_(" Cacher Xcfa "));
	}
	else {
		menu_systray_hide = gtk_image_menu_item_new_with_mnemonic (_(" Montrer Xcfa "));
	}	
	gtk_widget_show (menu_systray_hide);
	gtk_container_add (GTK_CONTAINER (menu_systray), menu_systray_hide);
	
	// STOCK ITEMS
	//
	// http://gtk.developpez.com/doc/fr/gtk/gtk-Stock-Items.html
	//
	
	// Image = gtk_image_new_from_pixbuf ( libutils_init_pixbufs ("xcfa/dbfs-no.png"));
	// Image = gtk_image_new_from_pixbuf ( libutils_init_pixbufs ("xcfa.png"));
	Image = gtk_image_new_from_stock (GTK_STOCK_REFRESH, GTK_ICON_SIZE_MENU);
	gtk_widget_show (Image);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (menu_systray_hide), Image);
		
	sep = gtk_separator_menu_item_new ();
	gtk_widget_show (sep);
	gtk_container_add (GTK_CONTAINER (menu_systray), sep);

	menu_systray_quit = gtk_image_menu_item_new_with_mnemonic (_(" Quitter Xcfa "));
	gtk_widget_show (menu_systray_quit);
	gtk_container_add (GTK_CONTAINER (menu_systray), menu_systray_quit);
	
	ImageQuit = gtk_image_new_from_stock (GTK_STOCK_QUIT, GTK_ICON_SIZE_MENU);
	gtk_widget_show (ImageQuit);
	gtk_image_menu_item_set_image (GTK_IMAGE_MENU_ITEM (menu_systray_quit), ImageQuit);
	
	// FALSE:
	// 	SI UNE ACTION EST EN COURS
	// TRUE:
	//	SINON
	// gtk_widget_set_sensitive (menu_systray_quit, FALSE | TRUE);
	gtk_widget_set_sensitive( menu_systray_quit, VarPopupSystray.BoolMainAction == TRUE ? FALSE : TRUE );

	g_signal_connect ((gpointer) menu_systray_hide, "activate", G_CALLBACK (PopupSystray_for_action), (gpointer)0);
	g_signal_connect ((gpointer) menu_systray_quit, "activate", G_CALLBACK (PopupSystray_for_action), (gpointer)2);
	
	// GLADE_HOOKUP_OBJECT_NO_REF (menu_systray, menu_systray, "menu_systray");
	// GLADE_HOOKUP_OBJECT (menu_systray, menu_systray_hide, _(" Cacher Xcfa "));
	// GLADE_HOOKUP_OBJECT (menu_systray, menu_systray_hide, _(" Montrer Xcfa "));
	// GLADE_HOOKUP_OBJECT (menu_systray, menu_systray_quit, _(" Quitter Xcfa "));
	gtk_widget_show_all (menu_systray);
	
	gtk_menu_popup (
		GTK_MENU (menu_systray),
		NULL,
		NULL,
		gtk_status_icon_position_menu,	// Menu sous la barre
		VarPopupSystray.p_status_icon,
		button,
		activate_time);
}
// 
// 
void PopupSystray_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	PopupSystray_show_hide ();
}
// 
// 
void PopupSystray_init (void)
{
	gchar		*Path = NULL;
	GtkStatusIcon	*tray_icon = NULL;
	
	tray_icon = gtk_status_icon_new ();
	gtk_status_icon_set_visible(tray_icon, TRUE);
	Path = libutils_get_pathname_pixmaps ("xcfa.png");
	VarPopupSystray.p_status_icon = gtk_status_icon_new_from_file (Path);
	g_free (Path);	Path = NULL;
	gtk_status_icon_set_tooltip (GTK_STATUS_ICON (VarPopupSystray.p_status_icon), _("XCFA\nProgramme pour convertir les fichiers audio."));
	g_signal_connect (G_OBJECT (VarPopupSystray.p_status_icon), "popup-menu",G_CALLBACK (PopupSystray_function), WindMain);
	g_signal_connect (G_OBJECT (VarPopupSystray.p_status_icon), "activate",G_CALLBACK (PopupSystray_activate), WindMain);
}

