 /*
 *  file      : win_reader.c
 *  project   : xcfa
 *  with      : Gtk-2
 *
 *  copyright : (C) 2003 - 2011 by Claude Bulin
 *
 *  xcfa - GTK+ implementation of the GNU shell command
 *  GNU General Public License
 *
 *  This file is part of XCFA.
 * 
 *  XCFA is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  at your option) any later version.
 * 
 *  XCFA is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 * 
 *  You should have received a copy of the GNU General Public License
 *  along with XCFA.  If not, see <http://www.gnu.org/licenses/>.
 */
 
 
#ifdef HAVE_CONFIG_H
	#include "../config.h"
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "global.h"
#include "mplayer.h"
#include "popup_systray.h"
#include "win_reader.h"



typedef struct {

	GtkWidget	*AdrWin;
	GtkWidget	*AdrScale;
	GtkObject	*AdrAdjust;
	GtkWidget	*AdrHscale;
	gboolean	IsShow;
	gboolean	BoolValueChange;
	
} VAR_WINDREADER;

VAR_WINDREADER VarWindReader = {
	NULL,
	NULL,
	NULL,
	NULL,
	FALSE,
	FALSE
};





void WinReader_set_value (gdouble p_value)
{
	if (TRUE == VarWindReader.IsShow) {
		gtk_adjustment_set_value (GTK_ADJUSTMENT (VarWindReader.AdrAdjust), p_value);
	}
}
// HSCALE VALUR-CHANGE
// 
gboolean WinReader_value_change (GtkRange *range, GtkScrollType scroll, gdouble value, gpointer user_data)
{
	if (value < 0.0) value = 0.0;
	if (value > 100.0) value = 100.0;

	if (GDK_BUTTON_RELEASE == VarMplayer.Button) {
		mplayer_fifo_seek_with_hundr (value);
		VarMplayer.Button = -1;
	}
	VarMplayer.PercentTempsActuel = value;
	VarWindReader.BoolValueChange = TRUE;
	
	WinReader_set_value (value);
	
	return FALSE;
}
// HSCALE EVENT
// 
gboolean WinReader_event (GtkWidget *treeview, GdkEvent *event, gpointer user_data)
{
	if (GDK_BUTTON_PRESS == event->type) {
		VarMplayer.Button = GDK_BUTTON_PRESS;
	}
	if (GDK_BUTTON_RELEASE == event->type) {
		VarMplayer.Button = GDK_BUTTON_RELEASE;
	}
	return (FALSE);
}
// HSCALE REALISE
// 
void on_hbox_WindReader_realize (GtkWidget *widget, gpointer user_data)
{
	VarWindReader.AdrAdjust = gtk_adjustment_new (0, 0, 100.0, 0.001, 1, 0);
	VarWindReader.AdrHscale = gtk_hscale_new (GTK_ADJUSTMENT (VarWindReader.AdrAdjust));
	gtk_widget_show (VarWindReader.AdrHscale);
	gtk_scale_set_draw_value (GTK_SCALE (VarWindReader.AdrHscale), FALSE);
	gtk_box_pack_start (GTK_BOX (widget), VarWindReader.AdrHscale, TRUE, TRUE, 0);
	GTK_WIDGET_UNSET_FLAGS (widget, GTK_CAN_FOCUS);
	gtk_scale_set_value_pos (GTK_SCALE (VarWindReader.AdrHscale), GTK_POS_LEFT);
	g_signal_connect ((gpointer) VarWindReader.AdrHscale, "change_value", G_CALLBACK (WinReader_value_change), NULL);
	g_signal_connect ((gpointer) VarWindReader.AdrHscale, "event",G_CALLBACK (WinReader_event), NULL);
}
// DELETE EVENT
// 
gboolean on_WindReader_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	mplayer_fifo_quit ();
	VarWindReader.IsShow = FALSE;
	gtk_widget_hide (VarWindReader.AdrWin);
	PopupSystray_set_BoolMainAction (FALSE);
	return TRUE;
}
// DESTROY EVENT
// 
gboolean on_WindReader_destroy_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	mplayer_fifo_quit ();
	VarWindReader.IsShow = FALSE;
	gtk_widget_hide (VarWindReader.AdrWin);
	PopupSystray_set_BoolMainAction (FALSE);
	return TRUE;
}
// PAUSE
// 
void on_button_pause_WindReader_clicked (GtkButton *button, gpointer user_data)
{
	mplayer_fifo_pause ();
	WinReader_set_lecture ();
}
// LECTURE
// 
void on_button_lecture_WindReader_clicked (GtkButton *button, gpointer user_data)
{
	if (TRUE == VarWindReader.BoolValueChange) {
		VarMplayer.Button = -1;
		VarWindReader.BoolValueChange = FALSE;
		mplayer_fifo_seek_with_hundr (VarMplayer.PercentTempsActuel);
	}
	else {
		mplayer_fifo_seek (VarMplayer.PercentTempsActuel);
	}
	WinReader_set_pause ();
}
// QUITTER
// 
void on_button_quitter_WindReader_clicked (GtkButton *button, gpointer user_data)
{
	VarMplayer.BoolIsPause = FALSE;
	mplayer_fifo_seek (VarMplayer.PercentTempsActuel);
	mplayer_fifo_quit ();
	VarWindReader.IsShow = FALSE;
	gtk_widget_hide (VarWindReader.AdrWin);
	PopupSystray_set_BoolMainAction (FALSE);
}
// WIN-READER OPEN
// 
void WinReader_open (gchar *title)
{
	if (TRUE == VarWindReader.IsShow) {
		gdk_window_raise (VarWindReader.AdrWin->window);
	}
	else {		
		if (NULL == VarWindReader.AdrWin) {
			VarWindReader.AdrWin = GTK_WIDGET (GLADE_GET_OBJECT("WindReader"));
			gtk_builder_connect_signals (GtkXcfaProjet, NULL);
		}
		gtk_window_set_transient_for (GTK_WINDOW(VarWindReader.AdrWin), GTK_WINDOW(WindMain));
		gtk_window_set_modal (GTK_WINDOW (VarWindReader.AdrWin), TRUE);
		libutils_set_default_icone_to_win (VarWindReader.AdrWin);

		gtk_widget_show (VarWindReader.AdrWin);
	}
	VarWindReader.IsShow = TRUE;
	VarWindReader.BoolValueChange = FALSE;
	if (NULL != title) gtk_window_set_title (GTK_WINDOW (VarWindReader.AdrWin), title);
	
	if (LIST_MPLAYER_FROM_DVD == VarMplayer.ListPlayFrom) {
		gtk_widget_hide (GTK_WIDGET (GLADE_GET_OBJECT("hbox_WindReader")));
	}
	else {
		gtk_widget_show (GTK_WIDGET (GLADE_GET_OBJECT("hbox_WindReader")));
	}
	PopupSystray_set_BoolMainAction (TRUE);
}
// WIN-READER SET-TITLE
// 
void WinReader_set_title (gchar *title)
{
	if (TRUE == VarWindReader.IsShow && NULL != title) gtk_window_set_title (GTK_WINDOW (VarWindReader.AdrWin), title);
}
// WIN-READER SHOW-PAUSE & HIDE-LECTURE
// 
void WinReader_set_pause (void)
{
	if (TRUE == VarWindReader.IsShow) {
		gtk_widget_hide (GTK_WIDGET (GLADE_GET_OBJECT("button_lecture_WindReader")));
		gtk_widget_show (GTK_WIDGET (GLADE_GET_OBJECT("button_pause_WindReader")));
	}
}
// WIN-READER HIDE-PAUSE & SHOW-LECTURE
// 
void WinReader_set_lecture (void)
{
	if (TRUE == VarWindReader.IsShow)  {
		gtk_widget_hide (GTK_WIDGET (GLADE_GET_OBJECT("button_pause_WindReader")));
		gtk_widget_show (GTK_WIDGET (GLADE_GET_OBJECT("button_lecture_WindReader")));
	}
}
// WIN-READER CLOSE
// 
void WinReader_close (void)
{
	if (TRUE == VarWindReader.IsShow) {
		WinReader_set_lecture ();
		VarWindReader.IsShow = FALSE;
		gtk_widget_hide (VarWindReader.AdrWin);
		PopupSystray_set_BoolMainAction (FALSE);
	}
}
// WIN-READER IS OK
// 
gboolean WinReader_is_close (void)
{
	return (VarWindReader.IsShow ? FALSE : TRUE);
}















