 /*
 * file      : main.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2011 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#ifdef ENABLE_NLS
	#include <libintl.h>
	#define _(String) gettext (String)
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <glib.h>
#include <glib/gstdio.h>
#include <stdio.h>
#include <stdlib.h>
#include <getopt.h>
#include <unistd.h>
#include <sys/types.h>

#ifdef ENABLE_STATIC_LIBRARY
	#include "../lib/lib.h"
#endif

#include "options.h"
#include "configuser.h"
#include "file.h"
#include "notify_send.h"
#include "parse.h"
#include "prg_init.h"
#include "scan.h"
#include "cd_audio.h"
#include "dvd.h"
#include "web.h"
#include "poche.h"
#include "treeview.h"
#include "get_info.h"
#include "mplayer.h"
#include "win_about.h"
#include "process.h"
#include "split.h"
#include "alsa_play.h"
#include "win_info.h"
#include "global.h"


/*
GStaticMutex cmd_queue_lock;
g_static_mutex_init(&ad.cmd_queue_lock);
    
int give_me_next_number ()

{

	static int current_number = 0;

	int ret_val;

	static GStaticMutex mutex = G_STATIC_MUTEX_INIT;
	
	g_static_mutex_lock (&mutex);

	ret_val = current_number++;

	g_static_mutex_unlock (&mutex);

	return ret_val;

}   
   */ 

GtkBuilder	*GtkXcfaProjet = NULL;
GtkWidget	*WindMain = NULL;
HOST_CONF	 HostConf;
GtkWidget	*AdrLabelStatusbarGlobal = NULL;

KEYS keys = {
	GDK_NOTHING,	/* eventkey		*/
	0,		/* type			*/
	0,		/* state		*/
	0,		/* keyval		*/
	0,		/* hardware_keycode	*/
	"",		/* str			*/
	FALSE,		/* BoolGDK_KP_Add	*/
	FALSE,		/* BoolGDK_KP_Subtract	*/
	FALSE,		/* BoolGDK_plus		*/
	FALSE,		/* BoolGDK_minus	*/
	FALSE,		/* BoolGDK_Control_L	*/
	FALSE,		/* BoolGDK_Control_R	*/
	FALSE,		/* BoolGDK_Shift_L	*/
	FALSE,		/* BoolGDK_Shift_R	*/
	FALSE,		/* BoolGDK_Left		*/
	FALSE,		/* BoolGDK_Right	*/
	FALSE		/* BoolGDK_Control_A	*/
};


static GList *pixmaps_directories = NULL;

// This is an internally used function to find pixmap files.
// 
static gchar *find_pixmap_file (const gchar *filename)
{
	GList *elem;

	/* We step through each of the pixmaps directory to find it. */
	elem = pixmaps_directories;
	while (elem)
	{
		gchar *pathname = g_strdup_printf ("%s%s%s", (gchar*)elem->data, G_DIR_SEPARATOR_S, filename);
		if (g_file_test (pathname, G_FILE_TEST_EXISTS)) return pathname;
		g_free (pathname);
		elem = elem->next;
	}
	return NULL;
}

// This is an internally used function to create pixmaps.
// 
GtkWidget *create_pixmap (GtkWidget *widget, const gchar *filename)
{
	gchar *pathname = NULL;
	GtkWidget *pixmap;

	if (!filename || !filename[0]) return gtk_image_new ();

	pathname = find_pixmap_file (filename);

	if (!pathname)
	{
		g_warning (_("Couldn't find pixmap file: %s"), filename);
		return gtk_image_new ();
	}

	pixmap = gtk_image_new_from_file (pathname);
	g_free (pathname);
	return pixmap;
}
// 
// 
void main_puts_statusbar_global (gchar *mess_label_status)
{
	static	gboolean Bool_puts_statusbar_global = FALSE;
	
	if (NULL != AdrLabelStatusbarGlobal && FALSE == Bool_puts_statusbar_global) {
		
		// NO ACESS IN PROC
		Bool_puts_statusbar_global = TRUE;
		
		gchar *New_Str = NULL;
		gchar *NewName = g_strnfill (strlen(mess_label_status) * 4, '\0');
		gchar *NewPtr = NewName;
		gchar *ptr = mess_label_status;
		
		while (*ptr) {
			if (*ptr == '&') {
				*NewPtr ++ = *ptr ++;
				*NewPtr ++ = 'a';
				*NewPtr ++ = 'm';
				*NewPtr ++ = 'p';
				*NewPtr ++ = ';';
			}
			else {
				*NewPtr ++ = *ptr ++;
			}
		}
		
		// New_Str = g_strdup_printf ("<span font_desc=\"sans %d\"><span color=\"black\"><b>%s</b></span></span>", 9, NewName);
		New_Str = g_strdup_printf ("<span color=\"black\"><b>%s</b></span>", NewName);
		
		gtk_label_set_justify (GTK_LABEL (AdrLabelStatusbarGlobal), GTK_JUSTIFY_CENTER);
		
		// TODO : @Tetsumaki  http://forum.ubuntu-fr.org/viewtopic.php?pid=3889380#p3889380
		// TODO : bug avec: while ...
		// while (gtk_events_pending()) gtk_main_iteration(); 
		
		gtk_label_set_use_markup (GTK_LABEL (AdrLabelStatusbarGlobal), TRUE);
		gtk_label_set_markup (GTK_LABEL (AdrLabelStatusbarGlobal), New_Str);

		g_free (New_Str);
		New_Str = NULL;
		g_free (NewName);
		NewName = NULL;
		
		// ACESS IN PROC IS OK
		Bool_puts_statusbar_global = FALSE;
	}
}
// 
// 
void on_label_statusbar_global_realize (GtkWidget *widget, gpointer user_data)
{
	AdrLabelStatusbarGlobal = widget;
}
// -RECUPERATION DES DATAS
// -SAUVEGARDE DES DATAS
// 
void remove_memory_apply (void)
{
	static gboolean BoolDoEnterRemove = FALSE;
	
	if (TRUE == BoolDoEnterRemove) return;
	BoolDoEnterRemove = TRUE;
	
	g_print ("\n--------------------------------------------------\n");
	PRINT_FUNC_LF();
	g_print ("--------------------------------------------------\n");
	
	g_print ("AlsaPlay_stop ()\n");
	AlsaPlay_stop ();
	
	g_print ("split_set_stop ()\n");
	split_set_stop ();
	
	g_print ("Recuperation position et taille de la fenetre\n");
	gdk_window_get_root_origin (WindMain->window, &Config.WinPos_X, &Config.WinPos_Y);
	gdk_window_get_size (WindMain->window, &Config.WinWidth, &Config.WinHeight);	
	
	g_print ("Sauvegarde l'etat de l'expander CD\n");
	Config.BoolEtatExpanderCd = gtk_expander_get_expanded (GTK_EXPANDER (var_cd.Adr_Expander));
	
	g_print ("Sauvegarde de la configuration\n");
	config_save ();
	
	g_print ("config_remove ()\n");
	config_remove ();
	
	g_print ("fileanalyze_remove_entetefile ()\n");
	fileanalyze_remove_entetefile ();

	g_print ("dvdaudio_remove_GtkTree ()\n");
	dvd_remove_GtkTree ();
	g_print ("dvdread_remove_list ()\n");
	dvdread_remove_list ();

	g_print ("cdaudio_deallocate_glist ()\n");
	cdaudio_deallocate_glist ();

	g_print ("NotifySend_remove ()\n");
	NotifySend_remove ();
	
	g_print ("prginit_remove_comment ()\n");
	prginit_remove_comment ();
	
	g_print ("Parse_remove (PARSE_TYPE_STOCKAGE_CD)\n");
	Parse_remove (PARSE_TYPE_STOCKAGE_CD);
	g_print ("Parse_remove (PARSE_TYPE_TITLE_CD)\n");
	Parse_remove (PARSE_TYPE_TITLE_CD);
	
	g_print ("pocheevnt_remove ()\n");
	pocheevnt_remove ();

	g_print ("libcombo_remove ()\n");
	libcombo_remove ();

	g_print ("scan_remove_glist_media ()\n");
	scan_remove_glist_media ();

	g_print ("web_remove_temporary_rep ()\n");
	web_remove_temporary_rep ();

	g_print ("mplayer_remove_list_args ()\n");
	mplayer_remove_list_args ();
	
	g_print ("SplitSpectre_remove ()\n");
	SplitSpectre_remove ();
	
	g_print ("AlsaPlay_remove ()\n");
	AlsaPlay_remove ();
		
	if (TRUE == libutils_test_file_exist (XCFA_FILE_LOAD)) {
		g_print ("g_unlink (%s)\n", XCFA_FILE_LOAD);
		g_unlink (XCFA_FILE_LOAD);
	}
	if (TRUE == libutils_test_file_exist (SPLIT_FILE_TMP_WAV)) {
		g_print ("g_unlink (%s)\n", SPLIT_FILE_TMP_WAV);
		g_unlink (SPLIT_FILE_TMP_WAV);
	}

	g_print ("\n");
}
// 
// 
void on_notebook_general_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data)
{
	if (TRUE == Config.BoolConfigOk) {
		Config.NotebookGeneral = page_num;
		
		if (NOTEBOOK_SPLIT == Config.NotebookGeneral) {
			split_set_name_file ();
		}
		else {
			main_puts_statusbar_global ("");
		}
	}
}
// 
// 
void on_notebook_expander_cd_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data)
{
	if (TRUE == Config.BoolConfigOk)
		Config.NotebookExpanderCd = page_num;
}
// 
// 
void on_notebook_in_file_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data)
{
	if (TRUE == Config.BoolConfigOk) {
		Config.NotebookFile = page_num;
		switch (Config.NotebookFile) {
		case NOTEBOOK_FICHIERS_CONVERSION :
			gtk_combo_box_remove_text (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), 2);
			gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), Config.PathDestinationFileAll);
			gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), Config.TabIndiceComboDestFile[ NOTEBOOK_FICHIERS_CONVERSION ]);
			break;
		case NOTEBOOK_FICHIERS_WAV :
			gtk_combo_box_remove_text (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), 2);
			gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), Config.PathDestinationFileWav);
			gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), Config.TabIndiceComboDestFile[ NOTEBOOK_FICHIERS_WAV ]);
			break;
		case NOTEBOOK_FICHIERS_MP3OGG :
			gtk_combo_box_remove_text (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), 2);
			gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), Config.PathDestinationFileMp3Ogg);
			gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), Config.TabIndiceComboDestFile[ NOTEBOOK_FICHIERS_MP3OGG ]);
			break;
		case NOTEBOOK_FICHIERS_TAGS :
			gtk_combo_box_remove_text (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), 2);
			gtk_combo_box_append_text (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), Config.PathDestinationFileTags);
			gtk_combo_box_set_active (GTK_COMBO_BOX (var_file.Adr_combobox_DestFile), Config.TabIndiceComboDestFile[ NOTEBOOK_FICHIERS_TAGS ]);
			break;
		}
	}
}
// 
// 
void on_notebook_options_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data)
{
	if (TRUE == Config.BoolConfigOk)
		Config.NotebookOptions = page_num;
}
// 
// 
void on_notebook_app_externes_switch_page (GtkNotebook *notebook, GtkNotebookPage *page, guint page_num, gpointer user_data)
{
	if (TRUE == Config.BoolConfigOk)
		Config.NotebookAppExterns = page_num;
}
// 
// 
gboolean on_wind_main_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	// PRINT_FUNC_LF();
	if (event->type == GDK_LEAVE_NOTIFY) {
		// utils_puts_statusbar_global ("");
	}
	else if (event->type == GDK_CONFIGURE) {
		// Apply_New_Size_Tree_View_Audio (wind_main->allocation.width);
		// Apply_New_Size_Tree_View_File (wind_main->allocation.width);
	}
	else if (event->type == GDK_KEY_PRESS) {
		keys.eventkey           = GDK_KEY_PRESS;
		keys.type               = event->type;
		keys.state              = event->key.state;
		keys.keyval             = event->key.keyval;
		keys.hardware_keycode   = event->key.hardware_keycode;

		if (event->key.keyval == GDK_Control_L) {
			keys.BoolGDK_Control_L = TRUE;
		}
		else if (event->key.keyval == GDK_Control_R) {
			keys.BoolGDK_Control_R = TRUE;
		}
		else if (event->key.keyval == GDK_Shift_L) {
			keys.BoolGDK_Shift_L = TRUE;
		}
		else if (event->key.keyval == GDK_Shift_R) {
			keys.BoolGDK_Shift_R = TRUE;
		}
		else if (event->key.keyval == GDK_Left) {
			keys.BoolGDK_Left = TRUE;
		}
		else if (event->key.keyval == GDK_Right) {
			keys.BoolGDK_Right = TRUE;
		}
		else if (event->key.keyval == GDK_KP_Add) {
			keys.BoolGDK_KP_Add = TRUE;
		}
		else if (event->key.keyval == GDK_KP_Subtract) {
			keys.BoolGDK_KP_Subtract = TRUE;
		}
		else if (event->key.keyval == GDK_plus) {
			keys.BoolGDK_plus = TRUE;
		}
		else if (event->key.keyval == GDK_minus) {
			keys.BoolGDK_minus = TRUE;
		}
		// CTRL_A  ?
		else if (event->key.state == 20 || event->key.state == 21) {
			if (event->key.keyval == 65 || event->key.keyval == 97) {
				keys.BoolGDK_Control_A = TRUE;
			}
		}
		else if (event->key.keyval == GDK_space) {
			keys.BoolGDK_space = TRUE;
		}

		if (keys.keyval == GDK_Control_L || keys.keyval == GDK_Control_R) {

			// utils_puts_statusbar_global (_("Touche CTRL + Click gauche = selection verticale"));
			// cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, _("Touche CTRL + Click gauche = selection verticale"));
			// dvdaudio_puts_label_statusbar (_STATUSBAR_SAVE_, _("Touche CTRL inadaptee !"));
		}
		else if (keys.keyval == GDK_Shift_L || keys.keyval == GDK_Shift_R) {

			// utils_puts_statusbar_global (_("Touche SHIFT + Click gauche = selection horizontale"));
			// cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, _("Touche SHIFT + Click gauche = selection horizontale"));
			// dvdaudio_puts_label_statusbar (_STATUSBAR_SAVE_, _("Touche SHIFT inadaptee !"));
		}
		else {
			// utils_puts_statusbar_global ("");
			// cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, "");
			// dvdaudio_puts_label_statusbar (_STATUSBAR_RESTITUE_, "");
		}
	}
	else if (event->type == GDK_KEY_RELEASE) {
		keys.eventkey           = GDK_KEY_RELEASE;
		keys.type               = event->type;
		keys.state              = 0;
		keys.keyval             = 0;
		keys.hardware_keycode   = 0;

		if (event->key.keyval == GDK_Control_L) {
			keys.BoolGDK_Control_L = FALSE;
		}
		else if (event->key.keyval == GDK_Control_R) {
			keys.BoolGDK_Control_R = FALSE;
		}
		else if (event->key.keyval == GDK_Shift_L) {
			keys.BoolGDK_Shift_L = FALSE;
		}
		else if (event->key.keyval == GDK_Shift_R) {
			keys.BoolGDK_Shift_R = FALSE;
		}
		else if (event->key.keyval == GDK_Left) {
			keys.BoolGDK_Left = FALSE;
		}
		else if (event->key.keyval == GDK_Right) {
			keys.BoolGDK_Right = FALSE;
		}
		else if (event->key.keyval == GDK_KP_Add) {
			keys.BoolGDK_KP_Add = FALSE;
		}
		else if (event->key.keyval == GDK_KP_Subtract) {
			keys.BoolGDK_KP_Subtract = FALSE;
		}
		else if (event->key.keyval == GDK_plus) {
			keys.BoolGDK_plus = FALSE;
		}
		else if (event->key.keyval == GDK_minus) {
			keys.BoolGDK_minus = FALSE;
		}
		keys.BoolGDK_space = FALSE;
		keys.BoolGDK_Control_A = FALSE;

		// utils_puts_statusbar_global ("");
		// cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, "");
		// dvdaudio_puts_label_statusbar (_STATUSBAR_RESTITUE_, "");
	}
	else if (keys.eventkey == GDK_KEY_RELEASE) {
		keys.eventkey           = GDK_NOTHING;
		keys.type               = event->type;
		keys.state              = 0;
		keys.keyval             = 0;
		keys.hardware_keycode   = 0;

		// utils_puts_statusbar_global ("");
		// cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, "");
		// dvdaudio_puts_label_statusbar (_STATUSBAR_RESTITUE_, "");

	}
	if (NOTEBOOK_SPLIT == Config.NotebookGeneral) {
		if (GDK_KEY_PRESS == keys.eventkey) {
			if (event->key.keyval == GDK_Delete) {
				SplitSelector_cut ();
			}
			else if (event->key.keyval == GDK_space) {
				// Une action sur la barre espace agit sur sur le play/pause
				split_play ();
			}
		}
	}
	return FALSE;
}
// 
// 
gboolean on_wind_main_delete_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	remove_memory_apply ();
	gtk_main_quit ();
	return FALSE;
}
// 
// 
gboolean on_wind_main_destroy_event (GtkWidget *widget, GdkEvent *event, gpointer user_data)
{
	remove_memory_apply ();
	gtk_main_quit ();
	return FALSE;
}
// 
// 
void on_quitter1_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	remove_memory_apply ();
	gtk_main_quit ();
}
// 
// 
void on_a_propos1_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	gchar	*StrAboutXcfa = g_strdup_printf ("About XCFA  -  %s", VERSION);
	WinAbout_open (StrAboutXcfa);
	g_free (StrAboutXcfa);
	StrAboutXcfa = NULL;
}
// 
// 
void on_show_fields_activate (GtkMenuItem *menuitem, gpointer user_data)
{
	treeview_open_window ();
}
/* Install un 'handler' sur une mauvaise allocation memoire
*  --
*  entree : int sig :
*  retour : -
*/
void segfault_handler(int sig)
{
	g_unlink (XCFA_FILE_LOAD);
	remove_memory_apply ();
	
	g_print ("\n=========================================================\n");
	g_print ("=  Segmentation fault\n");
	g_print (_("=  Adressage memoire invalide\n"));
	g_print ("=-------------------------------------------------------=\n");
	g_print ("=      You've probably found a bug in XCFA\n");
	g_print (_("=      Vous avez probablement trouve un bug dans XCFA\n"));
	g_print ("=========================================================\n\n");
		
	exit (EXIT_FAILURE);
}
// 
// 
void AnalyseCommandLine_set_argv (int argc, gchar *argv[])
{
	gint	 i;
	gchar	*str_current_dir = NULL;
	FILE	*fp = NULL;
	
	if (optind < argc) {
		str_current_dir = g_get_current_dir ();
		fp = fopen (XCFA_FILE_LOAD, "a");
		for (i = optind; i < argc; i++)
		{
			if (argv[i][0] == '/') {

				fprintf (fp, "%s\n", argv[ i ]);
			}
			else {
				gchar *str = NULL;
				
				str = g_strdup_printf ("%s/%s", str_current_dir, argv[i]);
				fprintf (fp, "%s\n", str);
				g_free (str);
				str = NULL;
			}
		}
		fclose (fp);
	}
	g_free (str_current_dir);
	str_current_dir = NULL;
}
/* gint main (gint argc, gchar *argv[], gchar **envp)
 *
 * argc  designe le nombre d'arguments transmis au moment du lancement de l'executable
 * argv  designe le vecteur contenant les differents arguments
 * envp  designe le vecteur contenant les informations sur l'environnement
 */
gint main (gint argc, gchar *argv[], gchar **envp)
{
	GError	*p_err = NULL;
	gchar	*CurrentDir = g_get_current_dir ();
	gchar	*PathCurrentDir = NULL;
	gchar	*PathShareProjet = NULL;
	gchar	*Path = NULL;
	gchar	*PackageVersion = NULL;
	
	// g_mem_set_vtable (glib_mem_profiler_table);
	
	if (TRUE == process_exist_file ()) {
		
		AnalyseCommandLine_set_argv (argc, &argv[0]);		// Get and save param-file
		// gtk_window_present (GTK_WINDOW (WindMain));
		// gdk_notify_startup_complete ();
		return (EXIT_SUCCESS);					// Quit process with success
	}
	else {
		g_unlink (XCFA_FILE_LOAD);				// Del paramter file if exist
		AnalyseCommandLine_set_argv (argc, &argv[0]);		// Get and save param-file
		
		// PLACER CET APPEL JUSTE AVANT: gtk_main ();
		// 
		// process_goto_timeout ();
	}
	
	
	g_print ("%s :: %s (line = %d)\n", __FILE__, __FUNCTION__, __LINE__);
	g_print ("\n");
	g_print ("***************************\n");
	g_print ("%s %s\n", PACKAGE, VERSION);
	g_print ("***************************\n");
	g_print ("%s %s compiled at %s %s\n", PACKAGE_NAME, VERSION, __DATE__, __TIME__);
	g_print ("Compiler: gcc %s\n", __VERSION__);
	g_print ("***************************\n");
	g_print ("Gtk version  = %d.%d.%d\n", GTK_MAJOR_VERSION, GTK_MICRO_VERSION, GTK_MINOR_VERSION);
	g_print ("Glib version = %d.%d.%d\n", GLIB_MAJOR_VERSION, GLIB_MICRO_VERSION, GLIB_MINOR_VERSION);
	g_print ("***************************\n\n");
#ifdef ENABLE_NLS
	g_print ("ENABLE_NLS OK\n");
	g_print ("\tGETTEXT_PACKAGE    = %s\n", GETTEXT_PACKAGE);
	g_print ("\tLOCALE_DIR         = %s\n", LOCALE_DIR);

	setlocale (LC_ALL, "");
	bindtextdomain (GETTEXT_PACKAGE, LOCALE_DIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#else
	// g_error ("ENABLE_NLS IS NOT OK\n\n");
#endif
	GetInfo_cpu_print ();
	g_print ("\n");
	g_print ("HostConf.NbCpu   = %d CPU\n", HostConf.NbCpu);
	g_print ("HostConf.TypeCpu = %d Bits\n", HostConf.TypeCpu);
	g_print ("HostConf.Machine = %s\n", HostConf.Machine);
	g_print ("\n");
	
	/* IF Segmentation fault */
	signal (SIGSEGV, segfault_handler);
	
	config_read();
	
	gtk_set_locale ();
	gtk_init (&argc, &argv);
	gdk_threads_enter ();
	
	if (NULL == (GtkXcfaProjet = gtk_builder_new ())) {
		return (EXIT_FAILURE);
	}
	gtk_builder_set_translation_domain (GtkXcfaProjet, NULL);

	PathCurrentDir = g_strdup_printf ("%s/glade/%s", CurrentDir, PACKAGE_NAME_GLADE);
	g_free (CurrentDir);
	CurrentDir = NULL;
	PathShareProjet = g_strdup_printf ("%s/%s/glade/%s", DATA_DIR, PACKAGE_NAME, PACKAGE_NAME_GLADE);

	if (FALSE == g_file_test (PathCurrentDir, G_FILE_TEST_EXISTS) && FALSE == g_file_test (PathShareProjet, G_FILE_TEST_EXISTS)) {
		g_print("!---------------------------------------------------------------------------------------------------\n");
		g_print("! LE FICHIER XML: [ %s ] N'EXISTE PAS !!!\n", PathCurrentDir);
		g_print("!---------------------------------------------------------------------------------------------------\n");
		g_print("! LE FICHIER XML: [ %s ] N'EXISTE PAS !!!\n", PathShareProjet);
		g_print("!---------------------------------------------------------------------------------------------------\n");

		g_free (PathCurrentDir);
		PathCurrentDir = NULL;
		g_free (PathShareProjet);
		PathShareProjet = NULL;

		gdk_threads_leave ();
		return (EXIT_FAILURE);
	}
	else if (TRUE == g_file_test (PathCurrentDir, G_FILE_TEST_EXISTS)) {

		Path = PathCurrentDir;
	}
	else if (TRUE == g_file_test (PathShareProjet, G_FILE_TEST_EXISTS)) {

		Path = PathShareProjet;
	}
	g_print("\nPATHNAME FILE %s: %s\n\n", PACKAGE_NAME_GLADE, Path);
	if (gtk_builder_add_from_file (GtkXcfaProjet, Path, &p_err) <= 0) {
		g_warning ("Couldn't load builder file: %s", p_err->message);
		g_error_free (p_err);

		g_free (PathCurrentDir);
		PathCurrentDir = NULL;
		g_free (PathShareProjet);
		PathShareProjet = NULL;
		Path = NULL;

		gdk_threads_leave ();
		return (EXIT_FAILURE);
	}
	g_free (PathCurrentDir);
	PathCurrentDir = NULL;
	g_free (PathShareProjet);
	PathShareProjet = NULL;
	Path = NULL;

	gtk_builder_set_translation_domain  (GtkXcfaProjet, gtk_set_locale ());
	gtk_builder_connect_signals (GtkXcfaProjet, NULL);
	WindMain = GTK_WIDGET (GLADE_GET_OBJECT("wind_main"));
	
	// REDIMENSIONNER LA FENETRE
	gtk_window_resize(GTK_WINDOW(WindMain), Config.WinWidth, Config.WinHeight);
	// PLACER LA FENETRE
	gtk_window_move(GTK_WINDOW(WindMain), Config.WinPos_X, Config.WinPos_Y);
	
	PackageVersion = g_strdup_printf ("X Convert File Audio  -  %s", VERSION);
	gtk_window_set_title (GTK_WINDOW (WindMain), PackageVersion);
	g_free (PackageVersion);
	PackageVersion = NULL;
	
	libutils_set_default_icone_to_win (WindMain);
	
	gtk_widget_show (WindMain);
	
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_general")), NOTEBOOK_PRGEXTERNES);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_app_externes")), NOTEBOOK_OPTIONS_EXTRA);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_app_externes")), NOTEBOOK_OPTIONS_PRGEXTERNES);
		
	// OPTIONS
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_general")), NOTEBOOK_OPTIONS);
		
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), NOTEBOOK_OPTIONS_EXPORT_TAGS);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), NOTEBOOK_OPTIONS_AACPLUSENC);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), NOTEBOOK_OPTIONS_FAAC);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), NOTEBOOK_OPTIONS_MUSEPACK);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), NOTEBOOK_OPTIONS_WAVPACK);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), NOTEBOOK_OPTIONS_MAC);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), NOTEBOOK_OPTIONS_FLAC);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), NOTEBOOK_OPTIONS_OGGENC);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), NOTEBOOK_OPTIONS_LAME);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), NOTEBOOK_OPTIONS_CD_AUDIO);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), NOTEBOOK_OPTIONS_GENERAL);

	// POCHETTE
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_general")), NOTEBOOK_POCHETTE);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_pochette")), NOTEBOOK_POCHETTE_TEXTE);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_pochette")), NOTEBOOK_POCHETTE_TITRE);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_pochette")), NOTEBOOK_POCHETTE_IMAGE);

	// NOTEBOOK_SPLIT
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_general")), NOTEBOOK_SPLIT);

	// FICHIERS
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_general")), NOTEBOOK_FICHIERS);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_in_file")), NOTEBOOK_FICHIERS_TAGS);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_in_file")), NOTEBOOK_FICHIERS_MP3OGG);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_in_file")), NOTEBOOK_FICHIERS_WAV);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_in_file")), NOTEBOOK_FICHIERS_CONVERSION);

	// CD-AUDIO
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_general")), NOTEBOOK_CD_AUDIO);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_expander_cd")), NOTEBOOK_CD_AUDIO_CUE);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_expander_cd")), NOTEBOOK_CD_AUDIO_TITRE_CD);
		gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_expander_cd")), NOTEBOOK_CD_AUDIO_TAGS);

	// DVD-AUDIO
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_general")), NOTEBOOK_DVD_AUDIO);
	
	var_options.ColorLineCommand = COLOR_INIT;
	options_set_all_interne ();
	var_options.ColorLineCommand = COLOR_NONE;
	
	Config.BoolConfigOk = TRUE;
	
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_general")), Config.NotebookGeneral);
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_expander_cd")), Config.NotebookExpanderCd);
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_in_file")), Config.NotebookFile);
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_pochette")), Config.NotebookPochette);
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_options")), Config.NotebookOptions);
	gtk_notebook_set_current_page (GTK_NOTEBOOK (GLADE_GET_OBJECT("notebook_app_externes")), Config.NotebookAppExterns);
	if (NOTEBOOK_SPLIT == Config.NotebookGeneral) {
		split_set_name_file ();
	}
	
	cdaudio_set_flag_buttons ();
	file_set_flag_buttons ();
	FileWav_set_flag_buttons ();
	FileMp3Ogg_set_flag_buttons ();
	FileTags_set_flag_buttons ();
	gtk_widget_set_sensitive (GTK_WIDGET (var_file_tags.Adr_table_tag), FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("button_tag_appliquer")), FALSE);
	pocheevnt_init ();
	pochetimer_enable ();
	
	treeview_set_etat_fields ();
	treeview_radiobutton_set_PosFieldsName ();
	
	filetrash_test_trash_is_ok ();
	
	// INHIBER LE JOURNAL DE LOGS
	gtk_widget_set_sensitive (GTK_WIDGET (GLADE_GET_OBJECT("frame_journal")), FALSE);
		
	// SI CHARGEMENT DE FICHIERS DEPUIS LE BUREAU AVEC LE MENU CONTEXTUEL
	process_goto_timeout ();
	
	// ADMINISTRATOR MOD ?
	if (0 == getuid()) {
		wininfo_create (
			_("MODE ADMINISTRATEUR"),
			_("Vous ne devriez pas utiliser XCFA sous ROOT !"),
			"");
	}
	
	gtk_main ();
	gdk_threads_leave ();
	
	// g_mem_profile ();

	exit(EXIT_SUCCESS);
}


