 /*
 * file    : tags.h
 * project : xcfa
 * with    : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */



#ifndef __tags_h__
#define __tags_h__ 1


#include "file.h"


typedef struct {				//    SIZE    COMMENT
						//    ----    ----------------------------------------------------
	guchar		IdRiff [ 4 ];		//	4     "RIFF" [52h 49h 46h 46h] identifiant le format
	guint32		Size;			//	4     CALCUL ET ECRITURE DE LA TAILLE TOTAL DU FICHIER
	guchar		IdWaveFmt [ 8 ];	//	8     "WAVEfmt "  [57h 41h 56h 45h 66h 6dh 74h 20h]
	guint32		BitPerSample;		//	4     TAILLE DE LA fmt: 8 | 16 | 24 | 32 | 64 ...
	guint16		Encodage;		//	2     TYPE D'ENCODAGE AUDIO (1 pour mono ou 2 pour stereo)
	guint16		Channels;		//	2     NOMBRE DE CANAUX
	guint32		Frequence;		//	4     FREQUENCE D ECHANTILLONAGE EN HERTZ
	guint32		Bitrate;		//	4     ECRITURE DU BITRATE
	guint16		NbrOctets;		//	2     ECRITURE DU NOMBRE D OCTETS PAR BLOCK
	guint16		NbrBytes;		//	2     NOMBRE DE BITS PAR ECHANTILLON: 8, 16, 24, ...

} NEW_HEADER_WAV;
void TagsWavGetHearder (gchar *NameFile, NEW_HEADER_WAV *HeaderWav);

/*
*---------------------------------------------------------------------------
* TAGS.C
*---------------------------------------------------------------------------
*/

TAGS     *tags_alloc (gboolean bool_tag_cd);
TAGS     *tags_remove (TAGS *tags);
TAGS     *tags_set (gchar *filename, TAGS *tags);
void      tags_set_flag_modification (TAGS *tags, gboolean p_flag);
gboolean  tags_is_modified (TAGS *tags);
gchar    *tags_get_time (gchar *namefile);
gchar    *tags_get_time_wav (gchar *namefile);

/*
*---------------------------------------------------------------------------
* TAGS_WAV.C
*---------------------------------------------------------------------------
*/
INFO_WAV *tagswav_remove_info (INFO_WAV *info);
INFO_WAV *tagswav_get_info (DETAIL *detail, gchar *namefile);
gboolean  tagswav_file_is_wav (gchar *namefile);
gboolean  tagswav_file_is_mono (gchar *namefile);
gboolean  tagswav_file_ChangeBitrate (gchar *namefile, gint *Channels, gint *Hertz, gint *Bits);

/*
*---------------------------------------------------------------------------
* TAGS_FLAC.C
*---------------------------------------------------------------------------
*/
INFO_FLAC *tagsflac_remove_info (INFO_FLAC *info);
INFO_FLAC *tagsflac_get_info (DETAIL *detail, gchar *namefile);
gboolean   tagsflac_file_is_flac (gchar *namefile);

/*
*---------------------------------------------------------------------------
* TAGS_MP3.C
*---------------------------------------------------------------------------
*/
INFO_MP3 *tagsmp3_remove_info (INFO_MP3 *info);
INFO_MP3 *tagsmp3_get_info (DETAIL *detail, gchar *namefile);
gboolean  tagsmp3_file_is_mp3 (gchar *namefile);

/*
*---------------------------------------------------------------------------
* TAGS_OGG.C
*---------------------------------------------------------------------------
*/
INFO_OGG *tagsogg_remove_info (INFO_OGG *info);
INFO_OGG *tagsogg_get_info (DETAIL *detail, gchar *namefile);
gboolean  tagsogg_file_is_ogg (gchar *namefile);

/*
*---------------------------------------------------------------------------
* TAGS_M4A_.C
*---------------------------------------------------------------------------
*/
INFO_M4A *tagsm4a_remove_info (INFO_M4A *info);
INFO_M4A *tagsm4a_get_info (DETAIL *detail, gchar *namefile);


/*
*---------------------------------------------------------------------------
* TAGS_AAC_.C
*---------------------------------------------------------------------------
*/
INFO_AAC *tagsaac_remove_info (INFO_AAC *info);

/*
*---------------------------------------------------------------------------
* TAGS_SHN.C
*---------------------------------------------------------------------------
*/
gboolean  tagsshn_file_is_shn (gchar *namefile);
INFO_SHN *tagsshn_remove_info (INFO_SHN *info);
INFO_SHN *tagsshn_get_info (gchar *namefile);

/*
*---------------------------------------------------------------------------
* TAGS_WMA.C
*---------------------------------------------------------------------------
*/
INFO_WMA *tagswma_remove_info (INFO_WMA *info);
INFO_WMA *tagswma_get_info (gchar *namefile);

/*
*---------------------------------------------------------------------------
* TAGS_MPC.C
*---------------------------------------------------------------------------
*/
gboolean  tagsmpc_file_is_mpc (gchar *namefile);
INFO_MPC *tagsmpc_remove_info (INFO_MPC *info);
INFO_MPC *tagsmpc_get_info (gchar *namefile);

/*
*---------------------------------------------------------------------------
* TAGS_APE.C
*---------------------------------------------------------------------------
*/
gboolean  tagsape_file_is_ape (gchar *namefile);
INFO_APE *tagsape_remove_info (INFO_APE *info);
INFO_APE *tagsape_get_info (gchar *namefile);

/*
*---------------------------------------------------------------------------
* TAGS_WAVPACK.C
*---------------------------------------------------------------------------
*/
gboolean      tagswavpack_file_is_wavpack (gchar *namefile);
INFO_WAVPACK *tagswavpack_remove_info (INFO_WAVPACK *info);
INFO_WAVPACK *tagswavpack_get_info (DETAIL *detail, gchar *namefile);

/*
*---------------------------------------------------------------------------
* TAGS_RM.C
*---------------------------------------------------------------------------
*/
gboolean tagsrm_file_is_rm (gchar *namefile);
INFO_RM *tagsrm_remove_info (INFO_RM *info);
INFO_RM *tagsrm_get_info (gchar *namefile);

/*
*---------------------------------------------------------------------------
* TAGS_DTS.C
*---------------------------------------------------------------------------
*/
INFO_DTS *tagsdts_remove_info (INFO_DTS *info);
INFO_DTS *tagsdts_get_info (gchar *namefile);


/*
*---------------------------------------------------------------------------
* TAGS_AIFF.C
*---------------------------------------------------------------------------
*/
gboolean tagsaiff_file_is_aiff (gchar *namefile);
INFO_AIFF *tagsaiff_remove_info (INFO_AIFF *info);
INFO_AIFF *tagsaiff_get_info (gchar *namefile);

#endif


