/*
 * file      : split.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <string.h>
#include <stdlib.h>

#include "global.h"
#include "config_user.h"
#include "fileselect.h"
#include "utils.h"
#include "options.h"
#include "file.h"
#include "dragNdrop.h"
#include "prg_init.h"
#include "split.h"
#include "win_info.h"
#include "split_shuttle.h"
#include "cursor.h"
#include "mplayer.h"



/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

extern gint		 n_drag_types;			/* Drag And Drop	*/
VAR_SPLIT		 VarSplit;			/* Declaration		*/
VAR_SPLIT_ALLOC		*VarSplitAlloc = NULL;		/* Declaration		*/


gboolean BoolSplitValueChangedEnable = TRUE;
gboolean BoolSplitSetEnable          = TRUE;


/*
*---------------------------------------------------------------------------
* VARIABLES SPLIT
*---------------------------------------------------------------------------
*/

enum
{
	NUM_TREE_NAMEFILE = 0,
	NUM_TREE_BEGIN,
	NUM_TREE_END,
	NUM_TREE_TIME,
	NUM_TREE_ALL_COLUMN
};
enum
{
	SPLIT_FILE_NAME = 0,
	SPLIT_FILE_EDITABLE,
	SPLIT_DECOUPE_FILE_BEGIN,
	SPLIT_DECOUPE_FILE_END,
	SPLIT_DECOUPE_TIME,
	SPLIT_POINTER_STRUCT_DETAIL,
	SPLIT_POINTER_STRUCT_FICSPLIT,
	SPLIT_NUM_COLUMNS
};
typedef struct
{
	gchar		*NbrCoupe;		/* Total fichiers en decoupes		*/
	gchar		*Type;			/* wav, ogg ou mp3			*/
	gchar		*Time;			/* Duree				*/
	gchar		*Name;			/* Le nom du fichier			*/

} ARTICLES_SPLIT_FILE;

GArray *ArticlesSplitFile = NULL;






DETAIL *split_get_pointeur_detail_from_line_sel (void)
{
	if (VarSplit.BoolLineSelected == FALSE) return ((DETAIL *)NULL);
	return ((DETAIL *)VarSplit.Detail);
}


FIC_SPLIT *split_get_pointeur_ficsplit_from_line_sel (void)
{
	if (VarSplit.BoolLineSelected == FALSE) return ((FIC_SPLIT *)NULL);
	return ((FIC_SPLIT *)VarSplit.FicSplit);
}


void split_button_ajouter_tache_clicked (void)
{
	FIC_SPLIT	*FicSplit = NULL;
	FIC_SPLIT	*NewFicSplit = NULL;
	
	if (VarSplit.Detail == NULL && VarSplit.FicSplit == NULL) return;
			
	if ((FicSplit = VarSplit.Detail->fic_split) == NULL) return;
	
	NewFicSplit = (FIC_SPLIT *)g_malloc0 (sizeof(FIC_SPLIT));
	NewFicSplit->SplitType        = SPLIT_CUTTING;
	NewFicSplit->ListDecoupes     = NULL;
	NewFicSplit->Name             = g_strdup (VarSplit.Detail->nametreeview);
	NewFicSplit->GUINT_TempsTotal = file_get_time_in_secondes (VarSplit.Detail);
	NewFicSplit->AdrValueMarkA    = splitshuttle_get_percent_begin ();
	NewFicSplit->AdrValueMarkB    = splitshuttle_get_percent_end ();
	
	FicSplit->ListDecoupes = g_list_append (FicSplit->ListDecoupes, NewFicSplit);
	
	split_affiche_glist ();
}



void split_button_importer_split_clicked (void)
{
	fileselect_create (_PATH_IMPORT_FILE_SPLIT_, NULL);
}

// RECUP. DU TEMPS EN LECTURE
// 
void split_with_mplayer (gdouble percent)
{
	splitshuttle_set_ActivePlayPercent (percent);
}
void split_set_flag_buttons_audio (void)
{
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_importer_split")), TRUE);
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("eventbox_combobox_dest_split")), TRUE);

	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_remove_file_split")), VarSplit.BoolLineSelected);
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_nettoyer_tout_split")), VarSplit.BoolLineSelected);
	
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("checkbutton_contour_split")), VarSplit.BoolLineSelected);

	// TEMPS DEBUT
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("spinbutton_secondes_mark_A_split")), VarSplit.BoolLineSelected);
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("spinbutton_centiemes_mark_A_split")), VarSplit.BoolLineSelected);

	// TEMPS FIN
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("spinbutton_secondes_mark_B_split")), VarSplit.BoolLineSelected);
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("spinbutton_centiemes_mark_B_split")), VarSplit.BoolLineSelected);

	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_stop_lecture_split")), splitshuttle_if_play() );
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_lecture_split")), splitshuttle_if_play () );

	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_ajouter_tache_split")), VarSplit.BoolLineSelected);
	
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_action_split")), split_get_elements () > 0 ? TRUE : FALSE);
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("hbox_splitshuttle")), VarSplit.BoolLineSelected);
}

void split_set_combobox_dest (GtkWidget *widget)
{
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));
	
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Conversion(s) vers la source"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("Choix d'une nouvelle destination"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), Config_User.Path_Destination_split);
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.Value_choice_split);
}
void split_combobox_dest_split_realize (GtkWidget *widget)
{
	split_set_combobox_dest (widget);
	VarSplit.AdrComboboxDest = GTK_COMBO_BOX (widget);
}
void split_import_file (gchar *path)
{
	if (options_verif_dossier_is_ok (path) == TRUE) {
		if (utils_test_write (path) == TRUE) {
			g_free (Config_User.Path_Destination_split);
			Config_User.Path_Destination_split = NULL;
			Config_User.Path_Destination_split = g_strdup (path);

			split_set_combobox_dest (GTK_WIDGET(VarSplit.AdrComboboxDest));

			Config_User.Value_choice_split = 0;
			gtk_combo_box_set_active (GTK_COMBO_BOX (VarSplit.AdrComboboxDest), Config_User.Value_choice_split);

			Config_User.Value_choice_split = 2;
			gtk_combo_box_set_active (GTK_COMBO_BOX (VarSplit.AdrComboboxDest), Config_User.Value_choice_split);
		}
	}
}
void split_combobox_dest_split_changed (void)
{
	if (VarSplit.AdrComboboxDest) {
		switch (gtk_combo_box_get_active (VarSplit.AdrComboboxDest)) {
		case 0 :
			Config_User.Value_choice_split = 0;
			break;
		case 1 :
			gtk_combo_box_set_active (GTK_COMBO_BOX (VarSplit.AdrComboboxDest), Config_User.Value_choice_split);
			fileselect_create (_PATH_DESTINATION_SPLIT_, split_import_file);
			break;
		case 2 :
			Config_User.Value_choice_split = 2;
			break;
		}
	}
}

/* AFFICHAGE
*/
gboolean split_is_dupply (gchar *namefile)
{
	GtkTreeIter	 iter;
	DETAIL		*detail = NULL;
	gboolean	 valid;

	if (VarSplit.Adr_Tree_Model == NULL) return (FALSE);

	valid = gtk_tree_model_get_iter_first (VarSplit.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (VarSplit.Adr_Tree_Model, &iter, SPLIT_POINTER_STRUCT_DETAIL, &detail, -1);
		if (detail != NULL) {
			if (strcmp (namefile, detail->namefile) == 0) return (TRUE);
		}
		valid = gtk_tree_model_iter_next (VarSplit.Adr_Tree_Model, &iter);
	}
	return (FALSE);
}

gboolean split_foreach_sel_line (GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer user_data)
{
	FIC_SPLIT *FicSplit = NULL;
	
	// PRINT_FUNC_LF();
	
	gtk_tree_model_get (model, iter, SPLIT_POINTER_STRUCT_FICSPLIT, &FicSplit, -1);
	if (FicSplit == VarSplit.OldSelectedFicSplit) {
		gtk_tree_selection_select_iter (VarSplit.Adr_Line_Selected, iter);
	}
	// continuer à parcourir l'arbre
	return FALSE;
}

void split_affiche_glist (void)
{
	GtkAdjustment		*Adj = NULL;
	DETAIL			*detail = NULL;
	FIC_SPLIT		*FicSplit = NULL;
	FIC_SPLIT		*DecoupesFicSplit = NULL;
	FIC_MP3OGG		*FicMp3Ogg = NULL;
	FIC_WAV			*FicWav = NULL;
	FIC			*Fic = NULL;
	GList			*list = NULL;
	GList			*ListDecoupe = NULL;
	gdouble			 AdjValue;
	GtkTreeIter		 piter0 = {0,NULL,NULL,NULL};
	GtkTreeIter		 piter1 = {0,NULL,NULL,NULL};
	GtkTreeStore		*model = (GtkTreeStore *)VarSplit.Adr_Tree_Model;
	gchar			*Str = NULL;

	// PRINT_FUNC_LF();
		
	gtk_tree_store_clear ((GtkTreeStore *)VarSplit.Adr_Tree_Model);

	/* Reajustement de la liste */
	Adj = gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW (VarSplit.Adr_scroll));
	AdjValue = gtk_adjustment_get_value (Adj);
	gtk_adjustment_set_value (Adj, AdjValue);
	gtk_scrolled_window_set_vadjustment (GTK_SCROLLED_WINDOW (VarSplit.Adr_scroll), Adj);

	list = g_list_first (entetefile);
	while (list) {
		if (!(detail = (DETAIL *)list->data)) {
			list = g_list_next(list);
			continue;
		}

		switch (detail->choice_treeview) {
		case _TREEVIEW_ALL_ :
			list = g_list_next(list);
			continue;
			break;
		case _TREEVIEW_SPLIT_ :
		case _TREEVIEW_SPLIT_ALL_ :
			break;
		}

		FicSplit  = (FIC_SPLIT *)detail->fic_split;
		FicMp3Ogg = (FIC_MP3OGG *)detail->fic_mp3ogg;
		FicWav    = (FIC_WAV *)detail->fic_wav;
		Fic       = (FIC *)detail->fic;

		if (Fic == NULL && FicWav == NULL && FicMp3Ogg == NULL) {
			list = g_list_next(list);
			continue;
		}
		if (FicSplit == NULL) {
			list = g_list_next(list);
			continue;
		}

		if (split_is_dupply (detail->namefile) == TRUE) {
			list = g_list_next(list);
			continue;
		}
					//<b>%s%s</b>   <span color=\"blue\"><b>%s</b></span>   <b><i>%s</i></b>",
		Str = g_strdup_printf ("<span color=\"black\"><b>%s%s</b>   <b>%s</b>   <b><i>%s</i></b></span>",
					detail->BoolCueFile == TRUE ? "Cue/" : "", 
					infosong_get_str_type_file_is (detail->type_infosong_file_is),
					file_get_time_file (detail),
					fileanalyze_get_name_without_path_ext (detail->namefile, FALSE)
					);
		
		DecoupesFicSplit = detail->fic_split;
		DecoupesFicSplit->SplitType = SPLIT_MASTER;
		gtk_tree_store_append (model, &piter0, NULL);
		gtk_tree_store_set (model, &piter0,
				SPLIT_FILE_NAME,		Str,
				SPLIT_FILE_EDITABLE,		FALSE,
				SPLIT_DECOUPE_FILE_BEGIN,	"",
				SPLIT_DECOUPE_FILE_END,		"",
				SPLIT_DECOUPE_TIME,		"",
				SPLIT_POINTER_STRUCT_DETAIL,	detail,
				SPLIT_POINTER_STRUCT_FICSPLIT,	DecoupesFicSplit,
				-1);
				
		splitshuttle_set_TimeSongSec (file_get_time_in_secondes (detail));
		
		if (FicSplit->ListDecoupes != NULL) {
			ListDecoupe = g_list_first (FicSplit->ListDecoupes);
			while (ListDecoupe) {
				if ((DecoupesFicSplit = (FIC_SPLIT *)ListDecoupe->data) != NULL) {
					DecoupesFicSplit->SplitType = SPLIT_CUTTING;
					gtk_tree_store_append (model, &piter1, &piter0);	
					gtk_tree_store_set (model, &piter1,
							SPLIT_FILE_NAME,		DecoupesFicSplit->Name,
							SPLIT_FILE_EDITABLE,		TRUE,
							SPLIT_DECOUPE_FILE_BEGIN,	splitshuttle_get_time (DecoupesFicSplit->AdrValueMarkA, FALSE, FALSE, FALSE, FALSE),
							SPLIT_DECOUPE_FILE_END,		splitshuttle_get_time (DecoupesFicSplit->AdrValueMarkB, FALSE, FALSE, FALSE, FALSE),
							SPLIT_DECOUPE_TIME,		splitshuttle_get_time (DecoupesFicSplit->AdrValueMarkB - DecoupesFicSplit->AdrValueMarkA, FALSE, FALSE, FALSE, FALSE),
							SPLIT_POINTER_STRUCT_DETAIL,	detail,
							SPLIT_POINTER_STRUCT_FICSPLIT,	DecoupesFicSplit,
							-1);
				}
				
				ListDecoupe = g_list_next(ListDecoupe);
			}
		}
		
		g_free (Str);
		Str = NULL;

		list = g_list_next(list);
	}

	gtk_tree_view_expand_all ( (GtkTreeView *)VarSplit.Adr_TreeView);
	split_set_flag_buttons_audio ();
	if (VarSplit.OldSelectedFicSplit == NULL) {
		if (gtk_tree_model_get_iter_first (VarSplit.Adr_Tree_Model, &piter0))
			gtk_tree_selection_select_iter (VarSplit.Adr_Line_Selected, &piter0);
	}
	else {
		gtk_tree_model_foreach (GTK_TREE_MODEL(VarSplit.Adr_Tree_Model), split_foreach_sel_line, NULL);
	}
}


static void split_drag_data_received_file (GtkWidget	   *widget,
					GdkDragContext     *drag_context,
					gint                x,
					gint                y,
					GtkSelectionData   *data,
					guint               info,
					guint               time)
{
	if (gtk_drag_get_source_widget(drag_context) != widget) {
		dragndrop_list_drag_data (widget, (gchar *)data->data);
	}
}

gboolean split_test_prg_extern (void)
{
	if (PrgInit.bool_mp3splt == FALSE && PrgInit.bool_mplayer == FALSE) {
		utils_puts_statusbar_global (_("mplayer + mp3splt ABSENT"));
		return (FALSE);
	}
	else if (PrgInit.bool_mp3splt == FALSE) {
		utils_puts_statusbar_global (_("mp3splt ABSENT"));
		return (FALSE);
	}
	else if (PrgInit.bool_mplayer == FALSE) {
		utils_puts_statusbar_global (_("mplayer ABSENT"));
		return (FALSE);
	}
	utils_puts_statusbar_global ("");
	return (TRUE);
}

static void split_drag_data_drop_file (GtkWidget *widget,
					GdkDragContext *dc,
					GtkSelectionData *selection_data,
					guint info,
					guint t,
					gpointer data)
{
	GtkTreeIter       iter;
	GtkTreeModel     *model = NULL;
	GList            *begin_list = NULL;
	GList            *list = NULL;
	GtkTreePath      *path;
	DETAIL           *detail = NULL;
	gchar            *text = NULL;

	if (split_test_prg_extern () == FALSE) return;

	model = gtk_tree_view_get_model (GTK_TREE_VIEW(widget));
	begin_list = gtk_tree_selection_get_selected_rows (VarSplit.Adr_Line_Selected, &model);
	list = g_list_first (begin_list);
	while (list) {
		if ((path = list->data)) {
			gtk_tree_model_get_iter (model, &iter, path);
			gtk_tree_model_get (VarSplit.Adr_Tree_Model, &iter, SPLIT_POINTER_STRUCT_DETAIL, &detail, -1);
			if (detail == NULL) {
				list = g_list_next (list);
				continue;
			}
			text = g_strdup (detail->namefile);
			gtk_selection_data_set (selection_data,
						GDK_SELECTION_TYPE_STRING,
						8,
						(const guchar *)text,
						strlen(text)
						);
			g_free (text);
			text = NULL;
		}
		list = g_list_next (list);
	}
}

void split_button_remove_file_split_clicked (void)
{
	if (VarSplit.BoolLineSelected == FALSE) return;
	
	if (VarSplit.FicSplit != NULL && VarSplit.Detail != NULL) {
		
		// SI FICHIER COMPLET
		
		// if (splitshuttle_if_play () == TRUE) {
			splitshuttle_set_percent_begin (25.0);
			splitshuttle_set_percent_end (75.0);
			splitshuttle_remove_data ();
			splitshuttle_reset_play ();
		// }
		
		if (VarSplit.FicSplit->SplitType == SPLIT_MASTER) {
						
			// CHERCHER LA PROCHANE LIGNE POUR: VarSplit.OldSelectedFicSplit
			
			GList		*Prev = NULL;
			GList		*List = NULL;
			GList		*Next = NULL;
			DETAIL		*Detail = NULL;
			FIC_SPLIT	*FicSplit = NULL;
			
			// g_print("VarSplit.FicSplit->SplitType == SPLIT_MASTER\n");
			
			// VALIDER LA FUTURE LIGNE DE SELECTION

			VarSplit.OldSelectedFicSplit = NULL;

			// CHERCHER LA LIGNE ACTUELLE
			
			List = g_list_first (entetefile);
			while (List) {
				if ((Detail = (DETAIL *)List->data) != NULL) {
					if (Detail == VarSplit.Detail) {
						Prev = g_list_previous (List);
						Next = g_list_next (List);
						break;
					}
				}
				List = g_list_next (List);
			}
			
			// CHERCHER LA LIGNE SUIVANTE
			
			while (Next) {
				if ((Detail = (DETAIL *)Next->data) != NULL) {
					if ((FicSplit = Detail->fic_split) != NULL) {
						if (FicSplit->SplitType == SPLIT_MASTER) {
							VarSplit.OldSelectedFicSplit = FicSplit;
							break;
						}
					}
				}
				Next = g_list_next (Next);
			}

			// CHERCHER LA LIGNE PRECEDANTE
			
			if (VarSplit.OldSelectedFicSplit == NULL) {
				while (Prev) {
					if ((Detail = (DETAIL *)Prev->data) != NULL) {
						if ((FicSplit = Detail->fic_split) != NULL) {
							if (FicSplit->SplitType == SPLIT_MASTER) {
								VarSplit.OldSelectedFicSplit = FicSplit;
								break;
							}
						}
					}
					Prev = g_list_previous (Prev);
				}
			}
			
			// SUPRESSION DE LA LIGNE ACTUELLE
			
			VarSplit.Detail->remove = STRUCT_FIC_REMOVE_SPLIT;
			fileanalyze_modify_glist_entetefile ();
		}
		
		// SI DECOUPE DE FICHIER
		
		else if (VarSplit.FicSplit->SplitType == SPLIT_CUTTING) {
			
			// CHERCHER LA PROCHANE LIGNE POUR: VarSplit.OldSelectedFicSplit
			
			GList		*Prev = NULL;
			GList		*List = NULL;
			GList		*ListD = NULL;
			GList		*Next = NULL;
			DETAIL		*Detail = NULL;
			FIC_SPLIT	*FicSplit = NULL;
			FIC_SPLIT	*PtrFicSplit = NULL;
			
			// g_print("(VarSplit.FicSplit->SplitType == SPLIT_CUTTING\n");
			
			// VALIDER LA FUTURE LIGNE DE SELECTION

			VarSplit.OldSelectedFicSplit = NULL;

			// CHERCHER LA LIGNE ACTUELLE
			
			Detail   = VarSplit.Detail;
			FicSplit = Detail->fic_split;
			
			List = g_list_first (FicSplit->ListDecoupes);
			while (List) {
				if ((PtrFicSplit = (FIC_SPLIT *)List->data) != NULL) {
					if (PtrFicSplit == VarSplit.FicSplit) {
						Prev = g_list_previous (List);
						Next = g_list_next (List);
						break;
					}
				}
				List = g_list_next (List);
			}
			ListD = List;
			
			// CHERCHER LA LIGNE SUIVANTE
			
			while (Next) {
				if ((PtrFicSplit = (FIC_SPLIT *)Next->data) != NULL) {
					if (PtrFicSplit->SplitType == SPLIT_CUTTING) {
						VarSplit.OldSelectedFicSplit = PtrFicSplit;
						break;
					}
				}
				List = g_list_next (List);
			}
			
			// CHERCHER LA LIGNE PRECEDANTE
			
			if (VarSplit.OldSelectedFicSplit == NULL) {
				while (Prev) {
					if ((PtrFicSplit = (FIC_SPLIT *)Prev->data) != NULL) {
						if (PtrFicSplit->SplitType == SPLIT_CUTTING) {
							VarSplit.OldSelectedFicSplit = PtrFicSplit;
							break;
						}
					}
					List = g_list_previous (List);
				}
			}
						
			// LES LIGNES PRECEDANTE ET SUIVANTE DANS LE GLIST DE DECOUPE SONT ABSENTES
			
			if (VarSplit.OldSelectedFicSplit == NULL) {
				
				// LE GLIST EST VIDE
				
				FicSplit->ListDecoupes = NULL;
				
				// CHERCHER LA LIGNE ACTUELLE
				
				List = g_list_first (entetefile);
				while (List) {
					if ((Detail = (DETAIL *)List->data) != NULL) {
						if (Detail == VarSplit.Detail) {
							// Prev = g_list_previous (List);
							Prev = List;
							Next = g_list_next (List);
							break;
						}
					}
					List = g_list_next (List);
				}
				
				// CHERCHER LA LIGNE PRECEDANTE
				
				while (Prev) {
					if ((Detail = (DETAIL *)Prev->data) != NULL) {
						if ((FicSplit = Detail->fic_split) != NULL) {
							if (FicSplit->SplitType == SPLIT_MASTER) {
								VarSplit.OldSelectedFicSplit = FicSplit;
								break;
							}
						}
					}
					Prev = g_list_previous (Prev);
				}

				// CHERCHER LA LIGNE SUIVANTE
				
				if (VarSplit.OldSelectedFicSplit == NULL) {
					while (Next) {
						if ((Detail = (DETAIL *)Next->data) != NULL) {
							if ((FicSplit = Detail->fic_split) != NULL) {
								if (FicSplit->SplitType == SPLIT_MASTER) {
									VarSplit.OldSelectedFicSplit = FicSplit;
									break;
								}
							}
						}
						Next = g_list_next (Next);
					}
				}
			}
			
			// LA LIGNE DANS LE GLIST DE DECOUPE EST PRESENTE
			
			FicSplit = (FIC_SPLIT *)ListD->data;
			if (FicSplit->Name != NULL) {
				g_free (FicSplit->Name);
				FicSplit->Name = NULL;
			} 
			
			if (VarSplit.OldSelectedFicSplit != NULL) {
			
				GList		*freeglist = NULL;
				
				freeglist = ListD;
				freeglist->data = NULL;
				ListD = g_list_next (ListD);
				FicSplit->ListDecoupes = g_list_remove_link (FicSplit->ListDecoupes, freeglist);
				ListD = g_list_first (FicSplit->ListDecoupes);
				split_affiche_glist ();
			}
			else {
				g_list_free (FicSplit->ListDecoupes);
				FicSplit->ListDecoupes = NULL;
				split_affiche_glist ();
			}
			
		}
	}
}

void split_button_remove_all_file_split_clicked (void)
{
	GList		*List = NULL;
	gboolean	 BoolRemove = FALSE;
	DETAIL		*Detail = NULL;
	
	// SI FICHIER COMPLET
		
	// if (splitshuttle_if_play () == TRUE) {
		splitshuttle_set_percent_begin (25.0);
		splitshuttle_set_percent_end (75.0);
		splitshuttle_remove_data ();
		splitshuttle_reset_play ();
	// }
	
	List = g_list_first (entetefile);
	while (List) {
		if ((Detail = (DETAIL *)List->data) != NULL) {
			if ((FIC_SPLIT *)Detail->fic_split != NULL) {
				BoolRemove = TRUE;
				Detail->remove = STRUCT_FIC_REMOVE_SPLIT;
			}
		}
		List = g_list_next (List);
	}
	if (BoolRemove == TRUE) {
		fileanalyze_modify_glist_entetefile ();
	}
}

gboolean split_key_press_event (GtkWidget *widget, GdkEventKey *event, gpointer user_data)
{
	if (event->keyval == GDK_Delete) {

		split_button_remove_file_split_clicked ();
		
	}
	else {

		g_print("OTHER KEY PRESSED\n");
		
	}
	return (TRUE);
}

gboolean split_event (GtkWidget *treeview, GdkEvent *event, gpointer user_data)
{
	/*
	gint                x, y;
	GdkModifierType     state;
	GtkTreeIter         iter;
	gint                Pos_X = 0, Pos_Y = 0;
	GtkTreePath        *path;
	GtkTreeViewColumn  *column;
	GtkTreeModel       *model = (GtkTreeModel *)user_data;
	
	gdk_window_get_pointer (((GdkEventButton*)event)->window, &x, &y, &state);
	if (!gtk_tree_view_get_path_at_pos (GTK_TREE_VIEW(treeview),
					   x, y,
					   &path, &column, &Pos_X, &Pos_Y)) {

		return (FALSE);
	}
PRINT_FUNC_LF();

	gtk_tree_model_get_iter (model, &iter, path);
	VarSplit.Detail   = NULL;
	VarSplit.FicSplit = NULL;
	gtk_tree_model_get (model, &iter, SPLIT_POINTER_STRUCT_DETAIL, &VarSplit.Detail, -1);
	gtk_tree_model_get (model, &iter, SPLIT_POINTER_STRUCT_FICSPLIT, &VarSplit.FicSplit, -1);
g_print("\tSELECTION DE: %s\n", VarSplit.Detail->namefile);
	*/
	return (FALSE);
}

gboolean split_event_click_mouse (GtkWidget *treeview, GdkEventButton *event, gpointer data)
{
	gint			 Pos_X = 0, Pos_Y = 0;
	GtkTreePath		*path;
	GtkTreeViewColumn 	*column;
	GtkTreeViewColumn	*ColumnDum;
	gint			 i;
	// guint			 button;
	GtkTreeModel		*model = (GtkTreeModel *)data;
	GtkTreeIter		 iter;
	gboolean		 bool_key_Control = (keys.keyval == GDK_Control_L || keys.keyval == GDK_Control_R);
	gboolean		 bool_key_Shift   = (keys.keyval == GDK_Shift_L || keys.keyval == GDK_Shift_R);
	gboolean		 bool_key_Release = (bool_key_Control == FALSE &&  bool_key_Shift == FALSE);
	// gboolean		 bool_click_gauche = (event->button == 1);
	// gboolean		 bool_click_droit = (event->button == 3);

	gboolean		 BoolSelectColNAMEFILE = FALSE;
	gboolean		 BoolSelectColBEGIN = FALSE;
	gboolean		 BoolSelectColEND = FALSE;
	// FIC_SPLIT         	*FicSplit = NULL;
	
	/* Mise a jour du scroll vertical
	*/
	GtkAdjustment   *Adj = NULL;

	Adj = gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW (VarSplit.Adr_scroll));
	gtk_adjustment_set_value (Adj, Adj->value);
	gtk_scrolled_window_set_vadjustment (GTK_SCROLLED_WINDOW (VarSplit.Adr_scroll), Adj);

	/* Single clicks only */
	if (event->type != GDK_BUTTON_PRESS) return (FALSE);

	/*if (bool_key_Release == FALSE || bool_click_gauche == FALSE) return (FALSE);*/
	if (bool_key_Release == FALSE) return (FALSE);

	/* Si pas de selection a cet endroit retour */
	if (!gtk_tree_view_get_path_at_pos (GTK_TREE_VIEW(treeview),
					  (gint)event->x, (gint)event->y,
					   &path, &column, &Pos_X, &Pos_Y)) return (FALSE);
	/*
	NUM_TREE_NAMEFILE
	NUM_TREE_BEGIN
	NUM_TREE_END
	NUM_TREE_ALL_COLUMN
	*/
	for (i = 0; i < NUM_TREE_ALL_COLUMN; i ++) {
		ColumnDum = gtk_tree_view_get_column (GTK_TREE_VIEW(treeview), i);
		if (ColumnDum == column) {
			/* g_print ("\tNUM IS: %d\n", i); */
			switch ( i ) {
			case NUM_TREE_NAMEFILE :	BoolSelectColNAMEFILE		= TRUE;	break;
			case NUM_TREE_BEGIN :		BoolSelectColBEGIN		= TRUE;	break;
			case NUM_TREE_END :		BoolSelectColEND		= TRUE;	break;
			case NUM_TREE_TIME :							break;
			default: return (FALSE);
			}
			/* La colonne est trouvee ... sortie de la boucle */
			break;
		}
	}
	
	gtk_tree_model_get_iter (model, &iter, path);
	VarSplit.Detail   = NULL;
	VarSplit.FicSplit = NULL;
	gtk_tree_model_get (model, &iter, SPLIT_POINTER_STRUCT_DETAIL, &VarSplit.Detail, -1);
	gtk_tree_model_get (model, &iter, SPLIT_POINTER_STRUCT_FICSPLIT, &VarSplit.FicSplit, -1);
	
	/*if (VarSplit.Detail) {
		g_print("\tVarSplit.Detail = %p\n", VarSplit.Detail);
		FicSplit = VarSplit.Detail->fic_split;
		
		splitshuttle_set_TimeSongSec (FicSplit->GUINT_TempsTotal);
		splitshuttle_set_percent_begin (FicSplit->AdrValueMarkA);
		splitshuttle_set_percent_end (FicSplit->AdrValueMarkB);
		
		g_print("FicSplit->GUINT_TempsTotal = %d\n", FicSplit->GUINT_TempsTotal);
		g_print("FicSplit->AdrValueMarkA    = %f\n", FicSplit->AdrValueMarkA);
		g_print("FicSplit->AdrValueMarkB    = %f\n", FicSplit->AdrValueMarkB);
	}*/
	
	if (VarSplit.FicSplit) {
		
		splitshuttle_set_TimeSongSec (VarSplit.FicSplit->GUINT_TempsTotal);
		splitshuttle_set_percent_begin (VarSplit.FicSplit->AdrValueMarkA);
		splitshuttle_set_percent_end (VarSplit.FicSplit->AdrValueMarkB);
		
	}
	split_set_flag_buttons_audio ();
	
	return (FALSE);
}

void split_changed_selection_row (GtkTreeSelection *selection, GtkTreeModel *model)
{
	GtkTreePath		*path;
	GtkTreeIter		 iter;
	GList			*List = NULL;
	
	// PRINT_FUNC_LF();

	VarSplit.Adr_Line_Selected = selection;
	
	split_NEW_StopPlay ();
	
	// TEST SI LIGNE EN SELECTION
	List = gtk_tree_selection_get_selected_rows (VarSplit.Adr_Line_Selected, &model);
	VarSplit.BoolLineSelected = (List != NULL) ? TRUE : FALSE;
	
	// ADAPTATION DES WIDGETS AU CONTEXTE
	split_set_flag_buttons_audio ();
	
	if (VarSplit.BoolLineSelected == FALSE) return;
	VarSplit.OldSelectedFicSplit = VarSplit.FicSplit;
	VarSplit.Detail   = NULL;
	VarSplit.FicSplit = NULL;
			
	cursor_set_watch ();
	
	List = g_list_first (List);
	if ((path = (GtkTreePath *)List->data) != NULL) {
		gtk_tree_model_get_iter (model, &iter, path);
		gtk_tree_model_get (model, &iter, SPLIT_POINTER_STRUCT_DETAIL, &VarSplit.Detail, -1);
		gtk_tree_model_get (model, &iter, SPLIT_POINTER_STRUCT_FICSPLIT, &VarSplit.FicSplit, -1);
	}

	if (VarSplit.FicSplit != NULL) {
		splitshuttle_set_TimeSongSec (VarSplit.FicSplit->GUINT_TempsTotal);
		splitshuttle_set_percent_begin (VarSplit.FicSplit->AdrValueMarkA);
		splitshuttle_set_percent_end (VarSplit.FicSplit->AdrValueMarkB);
	}
	
	if (VarSplit.Detail != NULL) {
		// gboolean split_event (GtkWidget *treeview, GdkEvent *event, gpointer user_data)
		// g_print("SELECTION DE: %s\n", VarSplit.Detail->namefile);
		
		splitshuttle_read_file_spectre (VarSplit.Detail);
		
		// g_print("VarSplit.Detail->type_infosong_file_is = %d\n", VarSplit.Detail->type_infosong_file_is);
	}

	splitshuttle_reset_play ();
	
	// ADAPTATION DES WIDGETS AU CONTEXTE
	split_set_flag_buttons_audio ();
	// gboolean split_event (GtkWidget *treeview, GdkEvent *event, gpointer user_data)
	// g_print("--SELECTION DE: %s\n", VarSplit.Detail->namefile);
	
	cursor_set_old ();
}

static void split_cell_edited_namefile (GtkCellRendererText *cell,
                                            gchar       *path_string,
                                            gchar       *new_text,
                                            gpointer     data)
{
	FIC_SPLIT	*FicSplit = NULL;
	GtkTreeModel	*model = (GtkTreeModel *)data;
	GtkTreePath	*path = gtk_tree_path_new_from_string (path_string);
	GtkTreeIter	 iter;
	gint		 column = GPOINTER_TO_INT (g_object_get_data (G_OBJECT (cell), "column"));

	// PRINT_FUNC_LF();

	gtk_tree_model_get_iter (model, &iter, path);

	if (column == SPLIT_FILE_NAME) {
	
		gchar   *old_text;

		gtk_tree_model_get (model, &iter, SPLIT_FILE_NAME, &old_text, -1);
		g_free (old_text);
		old_text = NULL;

		gtk_tree_model_get (model, &iter, SPLIT_POINTER_STRUCT_FICSPLIT, &FicSplit, -1);
		g_free (FicSplit->Name);
		FicSplit->Name = NULL;

		FicSplit->Name = g_strdup (new_text);

		/* actualise le nom */
		gtk_tree_store_set (GTK_TREE_STORE (model), &iter, column, new_text, -1);

	}
	gtk_tree_path_free (path);
}


/* Construction SPLIT
*/
static void split_add_columns_scrolledwindow_file (GtkTreeView *treeview)
{
	gint               col_offset;
	GtkCellRenderer   *renderer;
	GtkTreeViewColumn *column;
	GtkTreeModel      *model = gtk_tree_view_get_model (treeview);

	/* SIGNAL 'key-press-event'
	*/
	g_signal_connect(G_OBJECT(treeview),
			 "key-press-event",
                    	 (GCallback) split_key_press_event,
			 model);
	
	/* SIGNAL : 'event'
	*/
	// g_signal_connect(G_OBJECT(treeview), "event", (GCallback) split_event, model);

	/* SIGNAL : 'button-press-event'
	*/
	g_signal_connect(G_OBJECT(treeview), "button-press-event", (GCallback) split_event_click_mouse, model);
	
	/* Ligne actuellement selectionnee
	*/
	VarSplit.Adr_Line_Selected = gtk_tree_view_get_selection (GTK_TREE_VIEW(treeview));
	g_signal_connect(G_OBJECT(VarSplit.Adr_Line_Selected),
			 "changed",
                   	 G_CALLBACK(split_changed_selection_row),
                   	 model);

	/* Drag and drop support
	*  SIGNAL : 'drag-data-received'
	*/
	gtk_drag_dest_set (GTK_WIDGET (treeview),
			   GTK_DEST_DEFAULT_MOTION |
			   GTK_DEST_DEFAULT_DROP,
			   drag_types, n_drag_types,
			   GDK_ACTION_COPY| GDK_ACTION_MOVE );
	g_signal_connect(G_OBJECT(treeview),
			 "drag-data-received",
			 G_CALLBACK(split_drag_data_received_file),
			 NULL);

	gtk_drag_source_set(
			GTK_WIDGET(treeview),
			GDK_BUTTON1_MASK | GDK_BUTTON2_MASK | GTK_DEST_DEFAULT_MOTION | GTK_DEST_DEFAULT_DROP,
			drag_types, n_drag_types,
			GDK_ACTION_MOVE | GDK_ACTION_COPY | GDK_ACTION_DEFAULT
			);

	g_signal_connect(G_OBJECT(treeview),
      			"drag-data-get",
			 G_CALLBACK(split_drag_data_drop_file),
			 treeview);

	/* SPLIT_FILE_NAME
	*/
	// VarSplit.renderer =
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.0, NULL);
	// VarSplit.Adr_ColumnSplitName =
	g_object_set_data (G_OBJECT (renderer), "column", (gint *)SPLIT_FILE_NAME);
	g_signal_connect (renderer, "edited", G_CALLBACK (split_cell_edited_namefile), model);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
							-1,
							_("PLAGE"),	renderer,
							"markup",	SPLIT_FILE_NAME,
							 "editable", 	SPLIT_FILE_EDITABLE,
							NULL);
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (treeview), col_offset - 1);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	
	/* SPLIT_DECOUPE_FILE_BEGIN
	*/
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
							-1,
							_("DEBUT"),	renderer,
							"markup",	SPLIT_DECOUPE_FILE_BEGIN,
							NULL);
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (treeview), col_offset - 1);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column), GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 150);
	
	/* SPLIT_DECOUPE_FILE_END
	*/
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
							-1,
							_("FIN"),	renderer,
							"markup",	SPLIT_DECOUPE_FILE_END,
							NULL);
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (treeview), col_offset - 1);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column), GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 150);
	
	/* SPLIT_DECOUPE_TIME
	*/
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.0, NULL);
	col_offset = gtk_tree_view_insert_column_with_attributes (GTK_TREE_VIEW (treeview),
							-1,
							_("TEMPS"),	renderer,
							"markup",	SPLIT_DECOUPE_TIME,
							NULL);
	column = gtk_tree_view_get_column (GTK_TREE_VIEW (treeview), col_offset - 1);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	
	
	/* SPLIT_POINTER_STRUCT_DETAIL
	*/

}
void split_scrolledwindow_file_split_realize (GtkWidget *widget)
{
	
	// INIT
	VarSplit.FicSplit            = NULL;
	VarSplit.OldSelectedFicSplit = NULL;
	VarSplit.Detail              = NULL;

	VarSplit.Adr_scroll = widget;

	VarSplit.Adr_Tree_Model =
	(GtkTreeModel *) gtk_tree_store_new (SPLIT_NUM_COLUMNS,
					     G_TYPE_STRING,		/* SPLIT_FILE_NAME			*/
					     G_TYPE_BOOLEAN,		/* SPLIT_FILE_EDITABLE			*/
					     G_TYPE_STRING,		/* SPLIT_DECOUPE_FILE_BEGIN		*/
					     G_TYPE_STRING,		/* SPLIT_DECOUPE_FILE_END		*/
					     G_TYPE_STRING,		/* SPLIT_DECOUPE_TIME			*/
					     G_TYPE_POINTER,		/* SPLIT_POINTER_STRUCT_DETAIL		*/
					     G_TYPE_POINTER		/* SPLIT_POINTER_STRUCT_FICSPLIT	*/
					     );
	VarSplit.Adr_TreeView = gtk_tree_view_new_with_model (VarSplit.Adr_Tree_Model);
	gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (VarSplit.Adr_TreeView), TRUE);
	split_add_columns_scrolledwindow_file (GTK_TREE_VIEW (VarSplit.Adr_TreeView));
	gtk_container_add (GTK_CONTAINER (widget), VarSplit.Adr_TreeView);
	gtk_widget_show_all (widget);
}

void split_button_lecture_split_clicked (void)
{

	gdouble		 PercentBegin = splitshuttle_get_percent_play_begin ();
	gdouble		 PercentEnd   = splitshuttle_get_percent_play_end ();
	gint		 sec;
	GList		*List = NULL;	

	gtk_widget_hide (GTK_WIDGET (VarSplit.AdrButtonPlay));
	gtk_widget_show (GTK_WIDGET (VarSplit.AdrButtonStop));
	gtk_widget_set_sensitive (GTK_WIDGET (VarSplit.AdrButtonPlay), TRUE);
	gtk_widget_set_sensitive (GTK_WIDGET (VarSplit.AdrButtonStop), TRUE);

	// PlayAlsa_song (VarSplit.Detail->namefile,
	// 		splitshuttle_get_percent_play_begin (),
	// 		splitshuttle_get_percent_play_end ()
	// 		);
	
	// PRINT_FUNC_LF();
	//g_print("\tBEGIN = %f\n\tEND   = %f\n", PercentBegin, PercentEnd);
		
	sec = (gint) ((splitshuttle_get_TimeSongSec () * PercentBegin) / 100.0);
	List = g_list_append (List, g_strdup ("-ss"));
	List = g_list_append (List, g_strdup_printf ("%d", sec));
	List = g_list_append (List, g_strdup (VarSplit.Detail->namefile));
		
	mplayer_set_list (LIST_MPLAYER_FROM_SPLIT, PercentEnd, splitshuttle_get_TimeSongSec (), List);
	splitshuttle_set_BoolActivePlayPercent ();
	
	List = utils_clear_list (List);

	splitshuttle_set_BoolActivePlayPercent ();
}

void split_button_stop_lecture_split_clicked (void)
{
	gtk_widget_show (GTK_WIDGET (VarSplit.AdrButtonPlay));
	gtk_widget_hide (GTK_WIDGET (VarSplit.AdrButtonStop));
	
	// PlayAlsa_stop ();
	split_NEW_StopPlay ();
	
	splitshuttle_set_BoolStopPlayPercent ();
}


/*
*---------------------------------------------------------------------------
* NEW NEW NEW NEW  NEW  NEW  NEW  NEW  NEW  NEW  NEW 
*---------------------------------------------------------------------------
*/

void split_xcfa_event (GdkEvent *event)
{
	/*
	gint ValueEvent;
	return;
	if ((ValueEvent = splitshuttle_get_event ()) > splitshuttle_EVENT_NONE_EVENT) {
		switch (ValueEvent) {
		case splitshuttle_EVENT_NONE_EVENT:			g_print("splitshuttle_EVENT_NONE_EVENT\n");			break;
		case splitshuttle_EVENT_MARKER_BEGIN_VALUE_CHANGED:	g_print("splitshuttle_EVENT_MARKER_BEGIN_VALUE_CHANGED\n");	break;
		case splitshuttle_EVENT_MARKER_END_VALUE_CHANGED:	g_print("splitshuttle_EVENT_MARKER_END_VALUE_CHANGED\n");	break;
		case splitshuttle_EVENT_WAIT_TO_PLAY:			g_print("splitshuttle_EVENT_WAIT_TO_PLAY\n");			break;
		case splitshuttle_EVENT_STOP_TO_PLAY:			g_print("splitshuttle_EVENT_STOP_TO_PLAY\n");			break;
		}
	}
	*/
}

// MISE A JOUR DU TEMPS
//
gboolean split_foreach_affiche_time (GtkTreeModel *model, GtkTreePath *path, GtkTreeIter *iter, gpointer user_data)
{
	FIC_SPLIT	*FicSplit = NULL;
	DETAIL		*Detail   = NULL;
	gint		 Field = GPOINTER_TO_INT (user_data);
	gchar		*Ptr = NULL;
	gchar		*PtrTime = NULL;
	gchar		*OldTxt = NULL;
	gdouble		 Value = 0.0;
	
	gtk_tree_model_get (model, iter, SPLIT_POINTER_STRUCT_FICSPLIT, &FicSplit, -1);
	gtk_tree_model_get (model, iter, SPLIT_POINTER_STRUCT_DETAIL, &Detail, -1);
	
	if (Detail != NULL && FicSplit == VarSplit.FicSplit) {
				
		if (FicSplit->SplitType != SPLIT_CUTTING) return FALSE;
		
		// CHAMPS DEBUT ou FIN ?
		
		if (Field == SPLIT_DECOUPE_FILE_BEGIN)
			Ptr = splitshuttle_get_time (VarSplit.FicSplit->AdrValueMarkA, FALSE, FALSE, FALSE, FALSE);
		else if (Field == SPLIT_DECOUPE_FILE_END)
			Ptr = splitshuttle_get_time (VarSplit.FicSplit->AdrValueMarkB, FALSE, FALSE, FALSE, FALSE);
		else	return FALSE;
		
		// LIBERER L'ANCIEN TEXT DE LA RAM
		
		gtk_tree_model_get (model, iter, Field, &OldTxt, -1);
		g_free (OldTxt);
		OldTxt = NULL;
		
		// AFFICHAGE CHAMPS DEBUT ou FIN
		
		gtk_tree_store_set (
			GTK_TREE_STORE (model),
			iter,
			Field,
			Ptr,
			-1
			);
		
		// LIBERER L'ANCIEN TEXT DE LA RAM
		
		gtk_tree_model_get (model, iter, SPLIT_DECOUPE_TIME, &OldTxt, -1);
		g_free (OldTxt);
		OldTxt = NULL;
		
		// AFFICHAGE CHAMPS TIME
		
		if ((Value = (VarSplit.FicSplit->AdrValueMarkB - VarSplit.FicSplit->AdrValueMarkA)) < 0.0) Value = 0.0;
		PtrTime = splitshuttle_get_time (Value, FALSE, FALSE, FALSE, FALSE);
	
		gtk_tree_store_set (
			GTK_TREE_STORE (model),
			iter,
			SPLIT_DECOUPE_TIME,
			PtrTime,
			-1
			);
	}
	
	// CONTINUER A PARCOURIR L'ARBRE
	return FALSE;
}

void split_spinbutton_set_mark_A_split_value_changed (void)
{
	// PRINT_FUNC_LF();
	if (BoolSplitValueChangedEnable == FALSE) return;
	if (VarSplit.AdrSpinbuttonSecondesDebut && VarSplit.AdrSpinbuttonCentiemeDebut) {
		
		gint	HeureDebut, MinuteDebut, SecondeDebut, CentiemeDebut;
		gint	HeureFin, MinuteFin, SecondeFin, CentiemeFin;
		gdouble Percent;
		
		// ACQUISITION TEMPS DEBUT
		
		Percent = splitshuttle_get_percent_begin ();
		splitshuttle_get_time_from_percent (Percent, &HeureDebut, &MinuteDebut, &SecondeDebut, &CentiemeDebut);
		SecondeDebut  = gtk_spin_button_get_value_as_int (VarSplit.AdrSpinbuttonSecondesDebut);
		CentiemeDebut = gtk_spin_button_get_value_as_int (VarSplit.AdrSpinbuttonCentiemeDebut);
				
		// ACQUISITION TEMPS FIN
		
		Percent = splitshuttle_get_percent_end ();
		splitshuttle_get_time_from_percent (Percent, &HeureFin, &MinuteFin, &SecondeFin, &CentiemeFin);
		SecondeFin = gtk_spin_button_get_value_as_int (VarSplit.AdrSpinbuttonSecondesFin);
		CentiemeFin = gtk_spin_button_get_value_as_int (VarSplit.AdrSpinbuttonCentiemeFin);
		
		// 
		
		if (HeureDebut == HeureFin && MinuteDebut == MinuteFin) {
			
			// SECONDE DE DEBUT DOIT ETRE <= A SECONDE DE FIN 
			
			if (SecondeDebut != SecondeFin) {
				SecondeFin = gtk_spin_button_get_value_as_int (VarSplit.AdrSpinbuttonSecondesFin);
				if (SecondeDebut > SecondeFin) {
					SecondeDebut = SecondeFin;
					gtk_spin_button_set_value (VarSplit.AdrSpinbuttonSecondesDebut, (gdouble)SecondeDebut);
				}
			}
			
			// CENTIEME DE DEBUT DOIT ETRE <= A CENTIEME DE FIN 
			
			else if (SecondeDebut == SecondeFin) {
				CentiemeFin = gtk_spin_button_get_value_as_int (VarSplit.AdrSpinbuttonCentiemeFin);
				if (CentiemeDebut > CentiemeFin) {
					CentiemeDebut = CentiemeFin;
					gtk_spin_button_set_value (VarSplit.AdrSpinbuttonCentiemeDebut, (gdouble)CentiemeDebut);
				}
			}
		}
						
		BoolSplitSetEnable = FALSE;
		
		Percent = splitshuttle_get_percent (HeureDebut, MinuteDebut, SecondeDebut, CentiemeDebut);
		splitshuttle_set_percent_begin (Percent);
		VarSplit.FicSplit->AdrValueMarkA = Percent;
		gtk_tree_model_foreach (GTK_TREE_MODEL(VarSplit.Adr_Tree_Model), split_foreach_affiche_time, (gpointer)(gint)SPLIT_DECOUPE_FILE_BEGIN);
		
		BoolSplitSetEnable = TRUE;
	}
}


void split_spinbutton_set_mark_B_split_value_changed (void)
{
	// PRINT_FUNC_LF();
	if (BoolSplitValueChangedEnable == FALSE) return;
	if (VarSplit.AdrSpinbuttonSecondesFin && VarSplit.AdrSpinbuttonCentiemeFin) {
		
		gint	HeureFin, MinuteFin, SecondeFin, CentiemeFin;
		gint	HeureDebut, MinuteDebut, SecondeDebut, CentiemeDebut;
		gdouble Percent;
						
		// ACQUISITION TEMPS FIN
		
		Percent = splitshuttle_get_percent_end ();
		splitshuttle_get_time_from_percent (Percent, &HeureFin, &MinuteFin, &SecondeFin, &CentiemeFin);
		SecondeFin  = gtk_spin_button_get_value_as_int (VarSplit.AdrSpinbuttonSecondesFin);
		CentiemeFin = gtk_spin_button_get_value_as_int (VarSplit.AdrSpinbuttonCentiemeFin);
		
		// ACQUISITION TEMPS DEBUT
		
		Percent = splitshuttle_get_percent_begin ();
		splitshuttle_get_time_from_percent (Percent, &HeureDebut, &MinuteDebut, &SecondeDebut, &CentiemeDebut);
		SecondeDebut  = gtk_spin_button_get_value_as_int (VarSplit.AdrSpinbuttonSecondesDebut);
		CentiemeDebut = gtk_spin_button_get_value_as_int (VarSplit.AdrSpinbuttonCentiemeDebut);
		
		// 
		
		if (HeureFin == HeureDebut && MinuteFin == MinuteDebut) {
			
			// SECONDE DE FIN DOIT ETRE >= A SECONDE DE DEBUT 
			
			if (SecondeFin != SecondeDebut) {
				SecondeDebut = gtk_spin_button_get_value_as_int (VarSplit.AdrSpinbuttonSecondesDebut);
				if (SecondeFin < SecondeDebut) {
					SecondeFin = SecondeDebut;
					gtk_spin_button_set_value (VarSplit.AdrSpinbuttonSecondesFin, (gdouble)SecondeFin);
				}
			}
			
			// CENTIEME DE FIN DOIT ETRE >= A CENTIEME DE DEBUT 
			
			else if (SecondeFin == SecondeDebut) {
				CentiemeDebut = gtk_spin_button_get_value_as_int (VarSplit.AdrSpinbuttonCentiemeDebut);
				if (CentiemeFin < CentiemeDebut) {
					CentiemeFin = CentiemeDebut;
					gtk_spin_button_set_value (VarSplit.AdrSpinbuttonCentiemeFin, (gdouble)CentiemeFin);
				}
			}
		}
				
		// ACQUISITION TEMPS TOTAL
		
		splitshuttle_get_time_from_percent (100.0, &HeureDebut, &MinuteDebut, &SecondeDebut, &CentiemeDebut);
		
		// 
		
		if (HeureFin == HeureDebut && MinuteFin == MinuteDebut) {
			
			// SECONDE DE FIN DOIT ETRE <= A SECONDE TOTALE
			
			if (SecondeFin != SecondeDebut) {
				if (SecondeFin > SecondeDebut) {
					SecondeFin = SecondeDebut;
					gtk_spin_button_set_value (VarSplit.AdrSpinbuttonSecondesFin, (gdouble)SecondeFin);
				}
			}
			
			// CENTIEME DE FIN DOIT ETRE <= A CENTIEME TOTALE
			
			else if (SecondeFin == SecondeDebut) {
				if (CentiemeFin > CentiemeDebut) {
					CentiemeFin = CentiemeDebut;
					gtk_spin_button_set_value (VarSplit.AdrSpinbuttonCentiemeFin, (gdouble)CentiemeFin);
				}
			}
		}
		
		BoolSplitSetEnable = FALSE;
		
		Percent = splitshuttle_get_percent (HeureFin, MinuteFin, SecondeFin, CentiemeFin);
		splitshuttle_set_percent_end (Percent);
		VarSplit.FicSplit->AdrValueMarkB = Percent;
		gtk_tree_model_foreach (GTK_TREE_MODEL(VarSplit.Adr_Tree_Model), split_foreach_affiche_time, (gpointer)(gint)SPLIT_DECOUPE_FILE_END);
		
		BoolSplitSetEnable = TRUE;
	}
}


gint split_get_elements (void)
{
	GList		*List = NULL;
	DETAIL		*Detail = NULL;
	FIC_SPLIT	*FicSplit = NULL;
	GList		*ListDecoupe = NULL;
	gint		 NbrElements = 0;
	
	List = g_list_first (entetefile);
	while (List) {
		if ((Detail = (DETAIL *)List->data) != NULL) {
			if ((FicSplit = (FIC_SPLIT *)Detail->fic_split) != NULL) {
				if (FicSplit->ListDecoupes != NULL) {
					ListDecoupe = g_list_first (FicSplit->ListDecoupes);
					while (ListDecoupe) {
						NbrElements ++;
						ListDecoupe = g_list_next(ListDecoupe);
					}
				}
			}
		}
		List = g_list_next (List);
	}
	// g_print("split_get_elements (void) NbrElements = %d\n", NbrElements);
	return (NbrElements);
}

void split_NEW_set_debut (gdouble Percent)
{
	gchar		*Mess = NULL;
	
	FIC_SPLIT	*FicSplit = split_get_pointeur_ficsplit_from_line_sel ();
	gint		 H, M, S, C;

	Mess = splitshuttle_get_time (Percent, TRUE, FALSE, TRUE, FALSE);
	gtk_label_set_markup (GTK_LABEL (GTK_WIDGET (XCFA_GET_OBJECT("label_split_heure_debut"))), Mess);
	
	g_free (Mess);
	Mess = NULL;	
	Mess = splitshuttle_get_time (Percent, TRUE, FALSE, FALSE, TRUE);
	gtk_label_set_markup (GTK_LABEL (GTK_WIDGET (XCFA_GET_OBJECT("label_split_minute_debut"))), Mess);
	
	g_free (Mess);
	Mess = NULL;	
	Mess = splitshuttle_get_time (Percent, TRUE, TRUE, FALSE, FALSE);
	gtk_label_set_markup (GTK_LABEL (GTK_WIDGET (XCFA_GET_OBJECT("label_split_percent_debut"))), Mess);
	
	g_free (Mess);
	Mess = NULL;
	
	// 
	if (FicSplit != NULL) {
		FicSplit->AdrValueMarkA = Percent;
		gtk_tree_model_foreach (GTK_TREE_MODEL(VarSplit.Adr_Tree_Model), split_foreach_affiche_time, (gpointer)(gint)SPLIT_DECOUPE_FILE_BEGIN);
	
		if (BoolSplitSetEnable == TRUE) {

			splitshuttle_get_time_from_percent (Percent, &H, &M, &S, &C);
			
			BoolSplitValueChangedEnable = FALSE;
			
			gtk_spin_button_set_value (VarSplit.AdrSpinbuttonSecondesDebut, S);
			gtk_spin_button_set_value (VarSplit.AdrSpinbuttonCentiemeDebut, C);
			
			BoolSplitValueChangedEnable = TRUE;
		}
	}
}
void split_NEW_set_fin (gdouble Percent)
{
	gchar		*Mess = NULL;
	FIC_SPLIT	*FicSplit = split_get_pointeur_ficsplit_from_line_sel ();
	gint		 H, M, S, C;
	
	Mess = splitshuttle_get_time (Percent, TRUE, FALSE, TRUE, FALSE);
	gtk_label_set_markup (GTK_LABEL (GTK_WIDGET (XCFA_GET_OBJECT("label_split_heure_fin"))), Mess);
	
	g_free (Mess);
	Mess = NULL;	
	Mess = splitshuttle_get_time (Percent, TRUE, FALSE, FALSE, TRUE);
	gtk_label_set_markup (GTK_LABEL (GTK_WIDGET (XCFA_GET_OBJECT("label_split_minute_fin"))), Mess);
	
	g_free (Mess);
	Mess = NULL;	
	Mess = splitshuttle_get_time (Percent, TRUE, TRUE, FALSE, FALSE);
	gtk_label_set_markup (GTK_LABEL (GTK_WIDGET (XCFA_GET_OBJECT("label_split_percent_fin"))), Mess);
	
	g_free (Mess);
	Mess = NULL;
	
	// 
	if (FicSplit != NULL) {
		FicSplit->AdrValueMarkB = Percent;
		gtk_tree_model_foreach (GTK_TREE_MODEL(VarSplit.Adr_Tree_Model), split_foreach_affiche_time, (gpointer)(gint)SPLIT_DECOUPE_FILE_END);
	
		if (BoolSplitSetEnable == TRUE) {

			splitshuttle_get_time_from_percent (Percent, &H, &M, &S, &C);
			
			BoolSplitValueChangedEnable = FALSE;
			
			gtk_spin_button_set_value (VarSplit.AdrSpinbuttonSecondesFin, S);
			gtk_spin_button_set_value (VarSplit.AdrSpinbuttonCentiemeFin, C);
			
			BoolSplitValueChangedEnable = TRUE;
		}
	}
}

void split_NEW_WaitPlay (void)
{

	gdouble		 PercentBegin = splitshuttle_get_percent_play_begin ();
	gdouble		 PercentEnd   = splitshuttle_get_percent_play_end ();
	gint		 sec;
	GList		*List = NULL;	

	gtk_widget_hide (GTK_WIDGET (VarSplit.AdrButtonPlay));
	gtk_widget_show (GTK_WIDGET (VarSplit.AdrButtonStop));
	gtk_widget_set_sensitive (GTK_WIDGET (VarSplit.AdrButtonPlay), TRUE);
	gtk_widget_set_sensitive (GTK_WIDGET (VarSplit.AdrButtonStop), TRUE);
	
	// PlayAlsa_song (VarSplit.Detail->namefile,
	// 		splitshuttle_get_percent_play_begin (),
	// 		splitshuttle_get_percent_play_end ()
	// 		);
	
	// PRINT_FUNC_LF();
	// g_print("\tBEGIN = %f\n\tEND   = %f\n", PercentBegin, PercentEnd);
		
	sec = (gint) ((splitshuttle_get_TimeSongSec () * PercentBegin) / 100.0);
	List = g_list_append (List, g_strdup ("-ss"));
	List = g_list_append (List, g_strdup_printf ("%d", sec));
	List = g_list_append (List, g_strdup (VarSplit.Detail->namefile));
		
	mplayer_set_list (LIST_MPLAYER_FROM_SPLIT, PercentEnd, splitshuttle_get_TimeSongSec (), List);
	splitshuttle_set_BoolActivePlayPercent ();
	
	List = utils_clear_list (List);
	
	splitshuttle_set_BoolActivePlayPercent ();
}
void split_NEW_StopPlay (void)
{
	splitshuttle_set_BoolStopPlayPercent ();
	splitshuttle_set_BoolStopPlayPercent ();

	gtk_widget_show (GTK_WIDGET (VarSplit.AdrButtonPlay));
	gtk_widget_hide (GTK_WIDGET (VarSplit.AdrButtonStop));
	split_set_flag_buttons_audio ();
	
	// PlayAlsa_stop ();
	mplayer_fifo_quit ();
}













