 /*
 * file      : help.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */



#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <glib.h>
#include <glib/gstdio.h>

#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#include "global.h"
#include "utils.h"
#include "prg_init.h"
#include "win_play.h"
#include "help.h"
#include "dvd_audio.h"
#include "split.h"


void help_file_enter_notify_event (GtkWidget *widget)
{
	typedef struct {
		gchar  *widget;
		gchar  *def;
	} TYPE_BUTTON;
	#define MAX_TYPE_BUTTON_ENTER_NOTIFY_FILE 28
	TYPE_BUTTON TypeButton [ MAX_TYPE_BUTTON_ENTER_NOTIFY_FILE ] = {
	{"button_import_file",				_("Importer des fichiers")},
	{"eventbox_dest_file",				_("Choisir la destination des fichiers")},
	{"button_del_file",				_("Supprimer les fichiers en selection de la liste")},
	{"button_conv_file",				_("Appliquer les conversions")},
	{"eventbox_combobox_select_type",		_("Selectionner un type de fichier")},
	{"button_apply_wav",				_("Appliquer les conversions")},
	{"spinbutton_frequence_wav",			_("Choix d'une nouvelle frequence")},
	{"button_applique_file_mp3ogg",			_("Appliquer les conversions")},
	{"button_efface_bitrate_mp3ogg",		_("Annuler les modifications")},
	{"entry_tag_title_file",			_("Tag titre")},
	{"entry_tag_album_file",			_("Tag album")},
	{"entry_tag_artist_file",			_("Tag artiste")},
	{"entry_tag_comment_file",			_("Tag commentaire")},
	{"spinbutton_tag_year_file",			_("Tag annee")},
	{"eventbox_combobox_tag_genre_file",		_("Tag genre")},
	{"spinbutton_tag_track_file",			_("Tag piste")},
	{"button_tag_appliquer",			_("Appliquer les modifications")},
	{"eventbox_image_info_conversions_file",	var_file.AdrInfosAllFiles},
	{"eventbox_image_info_wav_file",		var_file.AdrInfosWav},
	{"eventbox_image_info_mp3ogg_file",		var_file.AdrInfosMp3Ogg},
	{"eventbox_combobox_normalise_file",		_("Agit sur les lignes en selection")},
	{"spinbutton_choix_niveau_file",		_("Choix du niveau en dBFS")},
	{"eventbox_combobox_lame_abr_cbr_vbr_mp3ogg",	_("Choix abr, cbr, vbr, vbr new")},
	{"eventbox_combobox_lame_type_bitrate_mp3ogg",	_("Choix bitrate")},
	{"eventbox_combobox_lame_mode_mp3ogg",		_("Choix mode")},
	{"eventbox_combobox_oggenc_bitrate_mp3ogg",	_("Choix bitrate")},
	{"eventbox_combobox_oggenc_managed_mp3ogg",	_("Choix managed")},
	{"eventbox_combobox_oggenc_downmix_m3ogg",	_("Choix downmix")}
	};
	gint cpt;

	for (cpt = 0; cpt < MAX_TYPE_BUTTON_ENTER_NOTIFY_FILE; cpt ++) {

		if (widget == GTK_WIDGET (XCFA_GET_OBJECT("eventbox_combobox_normalise_file"))) {

			gint value = gtk_combo_box_get_active (GTK_COMBO_BOX (var_file.AdrComboboxNormalise));

			if (GTK_WIDGET_IS_SENSITIVE(GTK_COMBO_BOX (var_file.AdrComboboxNormalise)) == FALSE) {
				utils_puts_statusbar_global ("");
				return;
			}

			switch (value) {
			case 0 :
				utils_puts_statusbar_global (_("Amplification maximale du volume pour un groupe de fichiers en respectant les ecarts de niveau entre chacun d'eux."));
				return;
			case 1 :
				utils_puts_statusbar_global (_("Amplification maximale du volume pour chaque de fichier."));
				return;
			case 2 :
				utils_puts_statusbar_global (_("Ajustement du volume moyen pour un groupe de fichiers en respectant les ecarts de niveau moyen entre chacun d'eux."));
				return;
			case 3 :
				utils_puts_statusbar_global (_("Ajustement du volume moyen de chaque de fichier."));
				return;
			}
		}
		else if (widget == GTK_WIDGET (XCFA_GET_OBJECT(TypeButton [ cpt ].widget))) {
			utils_puts_statusbar_global (TypeButton [ cpt ].def);
			break;
		}
	}
}

void help_dvdaudio_enter_notify_event (GtkWidget *widget)
{
	typedef struct {
		gchar  *widget;
		gchar  *def;
	} TYPE_BUTTON;
	#define MAX_TYPE_BUTTON_ENTER_NOTIFY_DVD 10
	TYPE_BUTTON TypeButton [ MAX_TYPE_BUTTON_ENTER_NOTIFY_DVD ] = {
	{"eventbox_combobox_peripherique_dvd",		_("Choix du peripherique de lecture")},
	{"button_rafraichir_dvd",			_("Lecture du dvd")},
	{"button_destination_dvd",			_("Choisir la destination des fichiers")},
	{"eventbox_combobox_normalise_dvd",		_("Choix de la normalisation")},
	{"button_deplier_dvd",				_("Replier la liste")},
	{"button_replier_dvd",				_("Deplier la liste")},
	{"button_extraction_dvd",			_("Extraction des donnees")},
	{"eventbox_combobox_sub_dvd",			_("Sub")},
	{"eventbox_combobox_ambiance_dvd",		_("Ambiance")},
	{"button_eject_dvd",				_("Ejection du dvd")}
	};
	gint cpt;

	for (cpt = 0; cpt < MAX_TYPE_BUTTON_ENTER_NOTIFY_DVD; cpt ++) {
		if (widget == GTK_WIDGET (XCFA_GET_OBJECT("eventbox_combobox_normalise_dvd"))) {

			gint value = gtk_combo_box_get_active (GTK_COMBO_BOX (var_dvdaudio.Adr_combobox_normalise_dvd));

			if (GTK_WIDGET_IS_SENSITIVE(GTK_COMBO_BOX (var_dvdaudio.Adr_combobox_normalise_dvd)) == FALSE) {
				utils_puts_statusbar_global ("");
				return;
			}

			switch (value) {
			case 0 :
				utils_puts_statusbar_global (_("Amplification maximale du volume pour un groupe de fichiers en respectant les ecarts de niveau entre chacun d'eux."));
				return;
			case 1 :
				utils_puts_statusbar_global (_("Amplification maximale du volume pour chaque de fichier."));
				return;
			}
		}
		else if (widget == GTK_WIDGET (XCFA_GET_OBJECT(TypeButton [ cpt ].widget))) {
			utils_puts_statusbar_global (TypeButton [ cpt ].def);
			break;
		}
	}
}

void help_cdaudio_enter_notify_event (GtkWidget *widget)
{
	typedef struct {
		gchar  *widget;
		gchar  *def;
	} TYPE_BUTTON;
	#define MAX_TYPE_BUTTON_ENTER_NOTIFY_CD 22
	TYPE_BUTTON TypeButton [ MAX_TYPE_BUTTON_ENTER_NOTIFY_CD ] = {
	{"eventbox_combo_peripherique_cd",		_("Choix du peripherique de lecture")},
	{"button_rafraichir_cd",			_("Lecture du cd")},
	{"button_destination_cd",			_("Choisir la destination des fichiers")},
	{"checkbutton_creation_fichier_unique_cue",	_("Creation d'un fichier audio unique avec un format preselectionne")},
	{"eventbox_combobox_choice_file_cue",		_("Choix d'un format unique de fichier parmis: Wav, Flac, Ogg, Mpc")},
	{"entry_name_fichier_unique_cue",		_("Saisie d'un nom de fichier pour le format unique")},
	{"checkbutton_creation_fichier_cue",		_("Creation d'un fichier CUE pour le fichier audio unique")},
	{"button_cue_creation_from_cd",			_("Creation d'un fichier CUE uniquement depuis la lecture du cd-audio")},
	{"eventbox_combo_serveur_cd",			_("Choix du serveur cddb")},
	{"eventbox_combobox_normalise_cd",		_("Choix de la normalisation")},
	{"button_applique_change",			_("Extraction / conversion des donnees")},
	{"entry_tag_titre_chanson",			_("Tag titre")},
	{"entry_tag_titre_album",			_("Tag album")},
	{"entry_tag_nom_artiste",			_("Tag artiste")},
	{"entry_tag_commentaire",			_("Tag commentaire")},
	{"spinbutton_tag_annee",			_("Tag annee")},
	{"eventbox_combobox_tag_genre_cd",		_("Tag genre")},
	{"spinbutton_tag_piste",			_("Tag piste")},
	{"entry_tag_titre_fichier_m3u",			_("Saisie du nom de fichier m3u ou xspf. Cette action ajoute le template %f aux tags.")},
	{"button_eject_cd",				_("Ejection du cd audio")},
	{"button_copy_comment",				_("Memorisation du commentaire")},
	{"button_paste_comment",			_("Restitution du commentaire")}
	};
	gint cpt;

	for (cpt = 0; cpt < MAX_TYPE_BUTTON_ENTER_NOTIFY_CD; cpt ++) {
		if (widget == GTK_WIDGET (XCFA_GET_OBJECT("eventbox_combobox_normalise_cd"))) {

			gint value = gtk_combo_box_get_active (GTK_COMBO_BOX (var_cd.Adr_combobox_normalise_cd));

			if (GTK_WIDGET_IS_SENSITIVE(GTK_COMBO_BOX (var_cd.Adr_combobox_normalise_cd)) == FALSE) {
				utils_puts_statusbar_global ("");
				return;
			}

			switch (value) {
			case 0 :
				utils_puts_statusbar_global (_("Amplification maximale du volume pour un groupe de fichiers en respectant les ecarts de niveau entre chacun d'eux."));
				return;
			case 1 :
				utils_puts_statusbar_global (_("Amplification maximale du volume pour chaque de fichier."));
				return;
			}

		}
		else if (widget == GTK_WIDGET (XCFA_GET_OBJECT(TypeButton [ cpt ].widget))) {
			utils_puts_statusbar_global (TypeButton [ cpt ].def);
			break;
		}
	}
}

void help_pocheevnt_enter_notify_event (GtkWidget *widget)
{
	typedef struct {
		gchar  *widget;
		gchar  *def;
	} TYPE_BUTTON;
	#define MAX_TYPE_BUTTON_ENTER_NOTIFY_POCHETTE 24
	TYPE_BUTTON TypeButton [ MAX_TYPE_BUTTON_ENTER_NOTIFY_POCHETTE ] = {
	{"button_preview_postscript",			_("Previsualisation de la pochette")},
	{"eventbox_combobox_choice_preview_postscript",	_("Choix d'un utilitaire de previsualisation")},
	{"eventbox_combobox_generate_ps_pdf",		_("Generation de fichiers PostScripts et/ou Pdf")},
	{"togglebutton_recto",				_("Actions sur le recto")},
	{"togglebutton_verso",				_("Actions sur le verso")},
	{"eventbox_combobox_zoom_choiximage",		_("Choisir le zoom")},
	{"button_load_choiximage",			_("Importer des images")},
	{"togglebutton_remove",				_("Nettoyer les images importees")},	
	{"entry_web_search",				_("Saisie de recherche")},
	{"button_get_from_web",				_("Importer depuis le Net des images")},
	{"button_get_title_cdaudio",			_("Importation du titre du cd-audio")},
	{"spinbutton_zoom_recto",			_("Choix de la taille de l'image au recto")},
	{"spinbutton_zoom_verso",			_("Choix de la taille de l'image au verso")},
	{"button_path_image_preview",			_("Lieu de stockage des images")},
	{"entry_titre_ps",				_("Le titre de la pochette")},
	{"entry_foottext_ps",				_("Le pied de page de la pochette")},
	{"eventbox_combobox_text_recto",		_("Disposition du texte au recto de la pochette")},
	{"eventbox_combobox_text_verso",		_("Disposition du texte au recto de la pochette")},
	{"eventbox_combobox_link_fields",		_("Relier les differents champs par un trait")},
	{"button_liste_numerate",			_("Numerotation de la liste")},
	{"button_importation_titre_cd",			_("Importer les titres de musique du cd-audio")},
	{"textview_text_poche",				_("textview_text_poche")},
	{"eventbox_combobox_entry_title",		_("Choix de l'emplacement du titre")},
	{"eventbox_combobox_foottext_ps",		_("Choix de l'emplacement du pied de page")}
	};
	gint cpt;

	for (cpt = 0; cpt < MAX_TYPE_BUTTON_ENTER_NOTIFY_POCHETTE; cpt ++) {
		if (widget == GTK_WIDGET (XCFA_GET_OBJECT(TypeButton [ cpt ].widget))) {
			utils_puts_statusbar_global (TypeButton [ cpt ].def);
			break;
		}
	}
}

void help_prgextern_enter_notify_event (GtkWidget *widget)
{
	typedef struct {
		gchar  *widget;
		gchar  *def;
	} TYPE_BUTTON;
	#define MAX_TYPE_BUTTON_ENTER_NOTIFY_PRGEXT 11
	TYPE_BUTTON TypeButton [ MAX_TYPE_BUTTON_ENTER_NOTIFY_PRGEXT ] = {
	{"button_scan",					_("Recherche si tous les logiciels tiers sont installes")},
	{"button_scan_without_deb",			_("Recherche si tous les logiciels tiers sont installes")},
	{"button_add_navigator",			_("Ajouter un navigateur de fichiers")},
	{"entry_name_navigator",			_("Saisie du nom d'un navigateur de fichiers")},
	{"button_del_navigator",			_("Supprimer un navigateur de fichiers")},
	{"button_add_postscript",			_("Ajouter un visualisateur PostScript")},
	{"entry_name_postscript",			_("Saisie du nom d'un visualisateur PostScript")},
	{"button_del_postscript",			_("Supprimer un visualisateur PostScript")},
	{"button_add_audio",				_("Valider le nom du lecteur de fichiers audio")},
	{"button_del_audio",				_("Supprimer le nom du lecteur de fichier audio")},
	{"entry_name_audio",				_("Saisie du nom d'un lecteur audio")}
	};
	gint cpt;

	for (cpt = 0; cpt < MAX_TYPE_BUTTON_ENTER_NOTIFY_PRGEXT; cpt ++) {
		if (widget == GTK_WIDGET (XCFA_GET_OBJECT(TypeButton [ cpt ].widget))) {
			utils_puts_statusbar_global (TypeButton [ cpt ].def);
			break;
		}
	}
}

void help_options_enter_notify_event (GtkWidget *widget)
{
	typedef struct {
		gchar  *widget;
		gchar  *def;
	} TYPE_BUTTON;
	#define MAX_TYPE_BUTTON_ENTER_NOTIFY_OPTIONS 76
	TYPE_BUTTON TypeButton [ MAX_TYPE_BUTTON_ENTER_NOTIFY_OPTIONS ] = {

	/* General */
	{"eventbox_combobox_nice",				_("Priorite systeme de: 0 (fort) a 19 (faible)")},
	{"checkbutton_pos_onglets",				_("Cochez ce bouton pour une restitution du contexte")},
	{"button_dossier_de_conversion",			_("Choix du dossier des conversions")},
	{"button_dossier_journal",				_("Choix du dossier pour le journal")},

	/* CD */
	{"radiobutton_cdparanoia",				_("Lecture base cd-audio avec cdparanoia")},
	{"radiobutton_ioctl",					_("Lecture base cd-audio avec ioctl")},
	{"radiobutton_extract_with_cdparanoia",			_("Extraction du cd-audio avec cdparanoia")},
	{"radiobutton_extract_with_cdda2wav",			_("Extraction du cd-audio avec cdda2wav/icedax")},
	{"radiobutton_cdparanoia_mode_expert",			_("Extraction du cd-audio avec cdparanoia en mode expert")},
	{"entry_stockage_cdaudio",				_("Definition du nom de dossier de stockage")},
	{"button_WebCdparanoia_homepage",			_("Site officiel de cdparanoia")},
	{"button_WebCdparanoia_manpage",			_("Manuel de cdparanoia")},
	
	/* Lame */
	{"eventbox_combobox_lame_bitrate",			_("Choix du type d'encodage")},
	{"eventbox_combobox_lame_abr_cbr_vbr",			_("Choix du debit")},
	{"eventbox_combobox_lame_mode",				_("Choix du mode")},
	{"button_defaut_lame",					_("Options par defaut")},
	{"button_WebLame_homepage",				_("Site officiel Lame")},
	{"button_WebLame_wikimp3",				_("Wiki mp3")},
	{"button_WebLame_wikilame",				_("Wiki Lame")},
	{"entry_lame_mp3",					_("Possibilite de saisie d'options pour Lame")},
	{"button_WebLame_manpage",				_("Manuel de lame")},
	
	/* Oggenc */
	{"eventbox_combobox_oggenc_bitrate",			_("Debit")},
	{"eventbox_combobox_oggenc_managed",			_("Flux")},
	{"eventbox_combobox_oggenc_downmix",			_("Mode")},
	{"button_defaut_oggenc",				_("Options par defaut")},
	{"button_WebOggenc_wiki",				_("Wiki Oggenc")},
	{"button_WebOggenc_manpage",				_("Manuel Oggenc")},
	{"entry_oggenc_ogg",					_("Possibilite de saisie d'options pour Oggenc")},
	{"button_WebOggenc_manpage",				_("Manuel de oggenc")},
	
	/* Flac */
	{"eventbox_flac_compression",				_("Choix du taux de compression")},
	{"button_defaut_flac",					_("Options par defaut")},
	{"button_WebFlac_homepage",				_("Site officiel Flac")},
	{"button_WebFlac_framasoft",				_("Description de Flac chez Framasoft")},
	{"entry_flac_flac",					_("Possibilite de saisie d'options pour Flac")},
	{"button_WebFlac_manpage",				_("Manuel de flac")},
	
	/* Mac */
	{"eventbox_combobox_ape_compression",			_("Choix du taux de compression")},
	{"button_defaut_mac",					_("Options par defaut")},
	{"button_WebMac_wiki",					_("Wiki Mac")},
	{"entry_mac_ape",					_("Possibilite de saisie d'options pour Mac")},

	/* WavPack */
	{"eventbox_combobox_wavpack",				_("Choix du taux de compression")},
	{"eventbox_combobox_wavpack_sound",			_("sound")},
	{"eventbox_combobox_wavpack_mode_hybride",		_("mode_hybride")},
	{"eventbox_combobox_wavpack_fichier_de_correction",	_("Production d'un fichier de correction")},
	{"eventbox_combobox_wavpack_compression_maximum",	_("Compression maximum")},
	{"eventbox_combobox_wavpack_signature_md5",		_("Signature md5")},
	{"eventbox_combobox_wavpack_extra_encoding",		_("Extra encoding")},
	{"button_defaut_wavpack",				_("Options par defaut")},
	{"button_WebFlac_wiki",					_("Wiki Wavpack")},
	{"entry_wavpack_wv",					_("Possibilite de saisie d'options pour Wavpack")},
	{"button_WavPack_manpage",				_("Manuel de wavpack")},
	
	/* MusePack */
	{"eventbox_combobox_mppenc",				_("Choix du taux de compression")},
	{"button_defaut_musepack",				_("Options par defaut")},
	{"button_WebMusepack_homepage",				_("Site officiel Musepack")},
	{"button_WebMusepack_framasoft",			_("Description de Musepack chez Framasoft")},
	{"entry_musepack_mpc",					_("Possibilite de saisie d'options pour Musepack")},

	/* Faac */
	{"eventbox_combobox_faac_conteneur",			_("[ Transport Stream (ADTS) - Extension .aac ] ou [ MPEG-4 File Format (MP4) - Extension .m4a ]")},
	{"eventbox_combobox_faac_choice_vbr_abr",		_("[ Debit = ABR ] ou [ Qualite = VBR ]")},
	{"eventbox_combobox_faac_set_choice_vbr_abr",		_("Choix du debit ou de la qualite")},
	{"button_defaut_faac",					_("Options par defaut")},
	{"button_defaut_aacplusenc",				_("Options par defaut")},
	{"button_faac_homepage",				_("Site officiel Faac")},
	{"button_faac_web_info",				_("Diverses informations Faac")},
	{"entry_faac_m4a",					_("Possibilite de saisie d'options pour Faac")},
	{"button_faac_manpage",					_("Manuel de faac")},

	/* Aacplusenc */
	{"eventbox_combobox_accplusenc_stereo",			_("Choix bitrate si le fichier source est en stereo")},
	{"eventbox_combobox_accplusenc_mono",			_("Choix bitrate si le fichier source est en mono")},
	{"button_aacplusenc_homepage",				_("Site officiel AacPlusEnc")},
	{"button_aacplusenc_web_info",				_("Wiki AacPlusEnc")},
	{"button_aacplusenc_manpage",				_("Manuel de aacplusenc")},
	
	/* Tags */
	{"checkbutton_artist_tag",				_("Validation du tag Artiste")},
	{"checkbutton_title_tag",				_("Validation du tag Titre")},
	{"checkbutton_album_tag",				_("Validation du tag Album")},
	{"checkbutton_numerate_tag",				_("Validation du tag Numero")},
	{"checkbutton_genre_tag",				_("Validation du tag Genre")},
	{"checkbutton_year_tag",				_("Validation du tag Annee")},
	{"checkbutton_comment_tag",				_("Validation du tag Commentaire")}

	};
	gint cpt;
	
	if (widget == GTK_WIDGET (XCFA_GET_OBJECT("button_WebCdparanoia_manpage")) && utils_scan_by_which ("cdparanoia", NULL) == FALSE) {
		utils_puts_statusbar_global (_("CDPARANOIA absent"));
	}
	else if (widget == GTK_WIDGET (XCFA_GET_OBJECT("button_WebLame_manpage")) && utils_scan_by_which ("lame", NULL) == FALSE) {
		utils_puts_statusbar_global (_("LAME absent"));
	}
	else if (widget == GTK_WIDGET (XCFA_GET_OBJECT("button_WebOggenc_manpage")) && utils_scan_by_which ("oggenc", NULL) == FALSE) {
		utils_puts_statusbar_global (_("OGGENC absent"));
	}
	else if (widget == GTK_WIDGET (XCFA_GET_OBJECT("button_WebFlac_manpage")) && utils_scan_by_which ("flac", NULL) == FALSE) {
		utils_puts_statusbar_global (_("FLAC absent"));
	}
	else if (widget == GTK_WIDGET (XCFA_GET_OBJECT("button_WavPack_manpage")) && utils_scan_by_which ("wavpack", NULL) == FALSE) {
		utils_puts_statusbar_global (_("WAVPACK absent"));
	}
	else if (widget == GTK_WIDGET (XCFA_GET_OBJECT("button_faac_manpage")) && utils_scan_by_which ("faac", NULL) == FALSE) {
		utils_puts_statusbar_global (_("FAAC absent"));
	}
	else if (widget == GTK_WIDGET (XCFA_GET_OBJECT("button_aacplusenc_manpage")) && utils_scan_by_which ("aacplusenc", NULL) == FALSE) {
		utils_puts_statusbar_global (_("AACPLUSENC absent"));
	}
	else {
		for (cpt = 0; cpt < MAX_TYPE_BUTTON_ENTER_NOTIFY_OPTIONS; cpt ++) {
			if (widget == GTK_WIDGET (XCFA_GET_OBJECT(TypeButton [ cpt ].widget))) {
				utils_puts_statusbar_global (TypeButton [ cpt ].def);
				break;
			}
		}
	}
}

void help_split_enter_notify_event (GtkWidget *widget)
{
	typedef struct {
		gchar  *widget;
		gchar  *def;
	} TYPE_BUTTON;
	#define MAX_TYPE_BUTTON_ENTER_NOTIFY_SPLIT 13
	TYPE_BUTTON TypeButton [ MAX_TYPE_BUTTON_ENTER_NOTIFY_SPLIT ] = {
	{"button_importer_split",		_("Importer un ou plusieurs fichiers <span color=\"red\">Wav</span>")},
	{"eventbox_combobox_dest_split",	_("Choix de la destination")},
	{"button_remove_file_split",		_("Efface de la liste le fichier en selection (touche Del ou Suppr)")},
	{"button_nettoyer_tout_split",		_("Efface de la liste tous les fichier")},
	{"button_stop_lecture_split",		_("Stop")},
	{"button_lecture_split",		_("Lecture")},
	{"button_action_split",			_("Valide le decoupage du fichier")},
	{"button_ajouter_tache_split",		_("Ajouter la tache")},
	{"spinbutton_secondes_mark_A_split",	_("Ajustement des secondes pour le selecteur de debut")},
	{"spinbutton_centiemes_mark_A_split",	_("Ajustement des centiemes pour le selecteur de debut")},
	{"spinbutton_secondes_mark_B_split",	_("Ajustement des secondes pour le selecteur de fin")},
	{"spinbutton_centiemes_mark_B_split",	_("Ajustement des centiemes pour le selecteur de fin")},
	{"checkbutton_contour_split",		_("Dessin du contour de l'onde")}
	};
	gint cpt;

	/*
	if (widget == GTK_WIDGET (XCFA_GET_OBJECT("button_ajouter_tache_split"))) {

		gchar *Str = NULL;

		switch (VarSplit.SplitSelect) {
		case SPLIT_SELECT_IS_NONE :
		case SPLIT_SELECT_IS_FILE :
			Str = g_strdup (_("Ajouter un fichier de decoupage"));
			break;
		case SPLIT_SELECT_IS_TACHE_MODIFIER :
			Str = g_strdup (_("Modifier la tache / Pour ajouter la tache, pressez sur la touche Ctrl"));
			break;
		case SPLIT_SELECT_IS_TACHE_AJOUTER :
			Str = g_strdup (_("Ajouter la tache "));
			break;
		}
		utils_puts_statusbar_global (Str);
		g_free (Str);
		Str = NULL;
		return;
	}
	*/

	if (widget == GTK_WIDGET (XCFA_GET_OBJECT("button_action_split")) && PrgInit.bool_wavsplit == FALSE) {
		gchar *Str = g_strdup_printf (_("wavsplit ABSENT :: %s"), TypeButton [ 5 ].def);
		utils_puts_statusbar_global (Str);
		g_free (Str);
		Str = NULL;
		return;
	}

	if (widget == GTK_WIDGET (XCFA_GET_OBJECT("button_action_split")) && PrgInit.bool_mp3splt == FALSE) {
		gchar *Str = g_strdup_printf (_("mp3splt ABSENT :: %s"), TypeButton [ 5 ].def);
		utils_puts_statusbar_global (Str);
		g_free (Str);
		Str = NULL;
		return;
	}
	if (widget == GTK_WIDGET (XCFA_GET_OBJECT("button_lecture_split")) && PrgInit.bool_mplayer == FALSE) {
		gchar *Str = g_strdup_printf (_("mplayer ABSENT :: %s"), TypeButton [ 4 ].def);
		utils_puts_statusbar_global (Str);
		g_free (Str);
		Str = NULL;
		return;
	}

	for (cpt = 0; cpt < MAX_TYPE_BUTTON_ENTER_NOTIFY_SPLIT; cpt ++) {
		if (widget == GTK_WIDGET (XCFA_GET_OBJECT(TypeButton [ cpt ].widget))) {
			utils_puts_statusbar_global (TypeButton [ cpt ].def);
			break;
		}
	}
}

void help_leave_notify_event (void)
{
	utils_puts_statusbar_global ("");
}

void help_lecture_enter_notify_event (GtkWidget *widget)
{
	typedef struct {
		gchar  *widget;
		gchar  *def;
	} TYPE_BUTTON;
	#define MAX_TYPE_BUTTON_ENTER_NOTIFY_LECTURE 21
	TYPE_BUTTON TypeButton [ MAX_TYPE_BUTTON_ENTER_NOTIFY_LECTURE ] = {
	{"button_lecture_begin",	_("Retourne au debut")},
	{"button_lecture_recule",	_("Recule")},
	{"button_lecture",		_("Lecture")},
	{"button_lecture_pause",	_("Pause")},
	{"button_lecture_stop",		_("Stop")},
	{"button_lecture_avance",	_("Avance")},
	{"button_lecture_end",		_("Va a la fin")},
	{"button_lecture_quitter",	_("Quitter")}
	};
	gint cpt;

	for (cpt = 0; cpt < MAX_TYPE_BUTTON_ENTER_NOTIFY_LECTURE; cpt ++) {
		if (widget == GTK_WIDGET (XCFA_GET_OBJECT(TypeButton [ cpt ].widget))) {
			WinPlay_puts_statusbar (TypeButton [ cpt ].def);
			break;
		}
	}
}
void help_lecture_leave_notify_event (void)
{
	WinPlay_puts_statusbar ("");
}








