 /*
	 * file      : file_conv.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#include <gtk/gtk.h>
#include <glib/gprintf.h>

#include <pthread.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "global.h"
#include "file.h"
#include "options.h"
#include "info_song.h"
#include "utils.h"
#include "file.h"
#include "conv.h"
#include "win_control.h"
#include "secu.h"
#include "prg_init.h"
#include "notify_send.h"
#include "logs.h"





/*
*---------------------------------------------------------------------------
*
*---------------------------------------------------------------------------
*/


void fileconv_infos (DETAIL *detail, FIC *fic)
{
	g_print ("\nCONVERSION(S) DEPUIS L'ONGLET 'FICHIERS'\n");
	if (detail->type_infosong_file_is == FILE_IS_WMA) {
		g_print ("\tFrom FILE_IS_WMA\n");
		logs_write_datas ("From FILE_IS_WMA: ");
		logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_RM) {
		g_print ("\tFrom FILE_IS_RM\n");
		logs_write_datas ("From FILE_IS_RM: ");
		logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_DTS) {
		g_print ("\tFrom FILE_IS_DTS\n");
		logs_write_datas ("From FILE_IS_DTS: ");
		logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_AIFF) {
		g_print ("\tFrom FILE_IS_AIFF\n");
		logs_write_datas ("From FILE_IS_AIFF: ");
		logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_M4A) {
		g_print ("\tFrom FILE_IS_M4A\n");
		logs_write_datas ("From FILE_IS_M4A: ");
		logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_SHN) {
		g_print ("\tFrom FILE_IS_SHN\n");
		logs_write_datas ("From FILE_IS_SHN: ");
		logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_WAV) {
		g_print ("\tFrom FILE_IS_WAV\n");
		logs_write_datas ("From FILE_IS_WAV: ");
		logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_FLAC) {
		g_print ("\tFrom FILE_IS_FLAC\n");
		logs_write_datas ("From FILE_IS_FLAC: ");
		logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_MP3) {
		g_print ("\tFrom FILE_IS_MP3\n");
		logs_write_datas ("From FILE_IS_MP3: ");
		logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_OGG) {
		g_print ("\tFrom FILE_IS_OGG\n");
		logs_write_datas ("From FILE_IS_OGG: ");
		logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_MPC) {
		g_print ("\tFrom FILE_IS_MPC\n");
		logs_write_datas ("From FILE_IS_MPC: ");
		logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_APE) {
		g_print ("\tFrom FILE_IS_APE\n");
		logs_write_datas ("From FILE_IS_APE: ");
		logs_writeln_datas (detail->namefile);
	}
	if (detail->type_infosong_file_is == FILE_IS_WAVPACK) {
		g_print ("\tFrom FILE_IS_WAVPACK\n");
		logs_write_datas ("From FILE_IS_WAVPACK: ");
		logs_writeln_datas (detail->namefile);
	}
	if (fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST)	g_print ("\t\tTo Wav\n");
	if (fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)	g_print ("\t\tTo Mp3%s\n", fic->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT ? "............WithLineExpert" :"");
	if (fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)	g_print ("\t\tTo Ogg%s\n", fic->EtatSelection_Ogg >= ETAT_SELECT_EXPERT ? "............WithLineExpert" :"");
	if (fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST)	g_print ("\t\tTo Flac%s\n", fic->EtatSelection_Flac >= ETAT_SELECT_EXPERT ? "...........WithLineExpert" :"");
	if (fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST)	g_print ("\t\tTo M4a%s\n", fic->EtatSelection_M4a >= ETAT_SELECT_EXPERT ? "............WithLineExpert" :"");
	if (fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST)	g_print ("\t\tTo Aac%s\n", fic->EtatSelection_Aac >= ETAT_SELECT_EXPERT ? "............WithLineExpert" :"");
	if (fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)	g_print ("\t\tTo Mpc%s\n", fic->EtatSelection_Mpc >= ETAT_SELECT_EXPERT ? "............WithLineExpert" :"");
	if (fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST)	g_print ("\t\tTo Ape%s\n", fic->EtatSelection_Ape >= ETAT_SELECT_EXPERT ? "............WithLineExpert" :"");
	if (fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST)	g_print ("\t\tTo WavPack%s\n", fic->EtatSelection_WavPack >= ETAT_SELECT_EXPERT ? "........WithLineExpert" :"");	
	g_print ("\n");
}

gboolean fileconv_test_file (gchar *Name)
{
	gboolean BoolIsPresent = infosong_file_is_reg (Name);
	gboolean BoolIsDatas   = FALSE;
	
	if (infosong_get_size_file (Name) > 0) BoolIsDatas = TRUE;
	return (BoolIsPresent && BoolIsDatas);
}

void fileconv_change_quantification_with_sox (DETAIL *detail, FIC *fic, gchar *Quantification)
{
	GList		*ListSox = NULL;
	INFO_WAV	*info = (INFO_WAV *)detail->info;
	// gint		 Channels;
	// gint		 Hertz;
	// gint		 Bits;

	// SOX
	conv_product_name_for_label (detail->namefile);
	conv.type_conv = SOX_WAV_TO_WAV;
	conv.bool_reset_conv = TRUE;
	ListSox = conv_with_sox_get_param (fic->tmp_wav, fic->tmp_sox, info->hertz, info->voie, Quantification);
	conv.ArgConv = conv_alloc_arg (ListSox);
	conv_exec (FALSE, SOX_WAV_TO_WAV, ListSox, "SOX_WAV_TO_WAV");
	ListSox = filelc_remove_glist (ListSox);
	g_free (conv.ArgConv);
	conv.ArgConv = NULL;
	conv_inc_encode_completed ();
	conv.type_conv = NONE_CONV;
	conv_remove_name_for_label (_CONV_);

	// DEBUG
	// tagswav_file_ChangeBitrate (fic->tmp_wav, &Channels, &Hertz, &Bits);
	// g_print("fic->tmp_wav = %s\n", fic->tmp_wav);
	// g_print("Channels = %d\n", Channels);
	// g_print("Hertz    = %d\n", Hertz);
	// g_print("Bits     = %d\n", Bits);
	// tagswav_file_ChangeBitrate (fic->tmp_sox, &Channels, &Hertz, &Bits);
	// g_print("fic->tmp_sox = %s\n", fic->tmp_wav);
	// g_print("Channels = %d\n", Channels);
	// g_print("Hertz    = %d\n", Hertz);
	// g_print("Bits     = %d\n", Bits);
}

void fileconv_copy_src_to_dest (DETAIL *detail, FIC *fic)
{
	conv.type_conv = COPY_FILE;
	conv.bool_reset_conv = TRUE;
	if (fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST && infosong_file_is_reg (fic->tmp_flac)) {
		conv_product_name_for_label (fic->dest_flac);
		conv_copy_src_to_dest (fic->tmp_flac, fic->dest_flac);
		fic->EtatSelection_Flac = ETAT_ATTENTE_EXIST;
		conv.Bool_MAJ_select = TRUE;
	}
	if (fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST && infosong_file_is_reg (fic->tmp_mp3)) {
		conv_product_name_for_label (fic->dest_mp3);
		conv_copy_src_to_dest (fic->tmp_mp3, fic->dest_mp3);
		fic->EtatSelection_Mp3 = ETAT_ATTENTE_EXIST;
		conv.Bool_MAJ_select = TRUE;
	}
	if (fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST && infosong_file_is_reg (fic->tmp_ogg)) {
		conv_product_name_for_label (fic->dest_ogg);
		conv_copy_src_to_dest (fic->tmp_ogg, fic->dest_ogg);
		fic->EtatSelection_Ogg = ETAT_ATTENTE_EXIST;
		conv.Bool_MAJ_select = TRUE;
	}
	if (fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST && infosong_file_is_reg (fic->tmp_wav)) {
		conv_product_name_for_label (fic->dest_wav);
		conv_copy_src_to_dest (fic->tmp_wav, fic->dest_wav);
		fic->EtatSelection_Wav = ETAT_ATTENTE_EXIST;
		conv.Bool_MAJ_select = TRUE;
	}
	if (fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST && infosong_file_is_reg (fic->tmp_m4a)) {
		conv_product_name_for_label (fic->dest_m4a);
		conv_copy_src_to_dest (fic->tmp_m4a, fic->dest_m4a);
		fic->EtatSelection_M4a = ETAT_ATTENTE_EXIST;
		conv.Bool_MAJ_select = TRUE;
	}
	if (fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST && infosong_file_is_reg (fic->tmp_mpc)) {
		conv_product_name_for_label (fic->dest_mpc);
		conv_copy_src_to_dest (fic->tmp_mpc, fic->dest_mpc);
		fic->EtatSelection_Mpc = ETAT_ATTENTE_EXIST;
		conv.Bool_MAJ_select = TRUE;
	}
	if (fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST && infosong_file_is_reg (fic->tmp_aac)) {
		conv_product_name_for_label (fic->dest_aac);
		conv_copy_src_to_dest (fic->tmp_aac, fic->dest_aac);
		fic->EtatSelection_Aac = ETAT_ATTENTE_EXIST;
		conv.Bool_MAJ_select = TRUE;
	}
	if (fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST && infosong_file_is_reg (fic->tmp_ape)) {
		conv_product_name_for_label (fic->dest_ape);
		conv_copy_src_to_dest (fic->tmp_ape, fic->dest_ape);
		fic->EtatSelection_Ape = ETAT_ATTENTE_EXIST;
		conv.Bool_MAJ_select = TRUE;
	}
	if (fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST && infosong_file_is_reg (fic->tmp_wavpack)) {
		conv_product_name_for_label (fic->dest_wavpack);
		conv_copy_src_to_dest (fic->tmp_wavpack, fic->dest_wavpack);
		
		if (*optionsWavpack_get_wavpack_correction_file () != '\0') {
		conv_product_name_for_label (fic->dest_wavpack_md5);
			conv_copy_src_to_dest (fic->tmp_wavpack_md5, fic->dest_wavpack_md5);
		}
		fic->EtatSelection_WavPack = ETAT_ATTENTE_EXIST;
		conv.Bool_MAJ_select = TRUE;
	}
	conv.type_conv = NONE_CONV;
	conv_remove_name_for_label (_CONV_);
	
	if (fic->EtatTrash == FILE_TRASH_OK) fic->EtatTrash = FILE_TRASH_VERIF_OK;
}

/* Ce thread active les conversions de fichiers
*  --
*  entree :
*      void *arg : NULL
*  retour : -
*/
static void fileconv_do_conversion_file_to_file (void *arg)
{
	GList         *ListGlobal = NULL;
	GList         *list = NULL;
	GList         *listmplayer = NULL;
	GList         *ListSox = NULL;
	DETAIL        *detail = NULL;
	FIC           *fic = NULL;
	gchar         *name_codetable = NULL;
	gchar         *ptr = NULL;
	PARAM_FILELC   param_filelc;
	gboolean       BoolResultMplayerIsOk = FALSE;
	
	/* PRINT_FUNC_LF(); */

	conv.bool_thread_conv  = TRUE;
	PRINT("DEBUT THREAD");

	/*
	g_print ("\n");
	g_print ("!------------------------------------------!\n");
	g_print ("! CONVERSION(S) DEPUIS L'ONGLET 'FICHIERS' !\n");
	g_print ("!------------------------------------------!\n");
	g_print ("\n");
	*/

	logs_add_datas_session ("FROM FILE");
	
	ListGlobal = g_list_first (entetefile);
	while (!conv.bool_stop && ListGlobal) {
		if ((detail = (DETAIL *)ListGlobal->data)) {
		if ((fic = (FIC *)detail->fic)) {

			/*
			SOURCE WAV
			DEST   FLAC     :  WAV -> FLAC    flac
			DEST   MP3      :  WAV -> MP3     lame
			DEST   OGG      :  WAV -> OGG     oggenc
			DEST   M4A      :  WAV -> M4A     faac
			DEST   AAC	:  WAV -> M4A     aacplusenc
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (!conv.bool_stop && detail->type_infosong_file_is == FILE_IS_WAV &&
				(
				fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_WAV	*info = (INFO_WAV *)detail->info;
				gint		 Channels;
				gint		 Hertz;
				gint		 Bits;
				gchar		 StrBits [ 10 ];

				/**/fileconv_infos (detail, fic);

				// COPIE DANS LE DOSSIER TEMPORAIRE
				// SI <> NULL ALORS 'detail->namefileCopie' SE TROUVE DEJA DANS LE DOSSIER TEMPORAIRE
				if (detail->namefileCopie == NULL) {
					conv_product_name_for_label (detail->namefile);
					conv.type_conv = COPY_FILE;
					conv.bool_reset_conv = TRUE;
					conv_copy_src_to_dest (detail->namefile, fic->tmp_wav);
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
				}
								
				// CONVERSION FLAC
				if (!conv.bool_stop && fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {
					
					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_flac);

					tagswav_file_ChangeBitrate (fic->tmp_wav, &Channels, &Hertz, &Bits);
					
					// REAJUSTE LA QUANTIFICATION
					// (Bits != 24 && Bits != 16 && Bits != 8)
					if (fic->BoolEtatConv [ ETAT_FROM_WAV_TO_FLAC ] == TRUE) {
						
						g_sprintf (&StrBits[0], "%d", (gint)Bits);

						logs_write_datas ("\tChange bit ");
						logs_write_datas (StrBits);
						logs_write_datas (" -> ");
						
						if (Bits > 24)				strcpy (StrBits, "24");
						else if (Bits > 16 && Bits < 24)	strcpy (StrBits, (Bits - 16) > 3 ? "24" : "16");
						else if (Bits >  8 && Bits < 16)	strcpy (StrBits, (Bits - 8) > 3 ? "16" : "8");
						else if (Bits <  8)			strcpy (StrBits, "8");
						
						logs_writeln_datas (StrBits);
						
						fileconv_change_quantification_with_sox (detail, fic, StrBits);
					} else {
						conv_inc_encode_completed ();
					}
					
					conv_product_name_for_label (fic->dest_flac);
					conv.type_conv = FLAC_WAV_TO_FLAC;
					conv.bool_reset_conv = TRUE;

					param_filelc.type_conv            = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = (fic->BoolEtatConv [ ETAT_FROM_WAV_TO_FLAC ] == TRUE) ? fic->tmp_sox : fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_flac;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, list, "FLAC_WAV_TO_FLAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();

					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}

				// CONVERSION APE
				if (!conv.bool_stop && fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {
					
					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ape);

					tagswav_file_ChangeBitrate (fic->tmp_wav, &Channels, &Hertz, &Bits);
					
					// REAJUSTE LA QUANTIFICATION
					// (Bits != 16 && Bits != 8)
					if (fic->BoolEtatConv [ ETAT_FROM_WAV_TO_APE ] == TRUE) {
						
						g_sprintf (&StrBits[0], "%d", (gint)Bits);

						logs_write_datas ("\tChange bit ");
						logs_write_datas (StrBits);
						logs_write_datas (" -> ");
						
						if (Bits > 16)			strcpy (StrBits, "16");
						else if (Bits > 8 && Bits < 16)	strcpy (StrBits, (Bits - 8) > 3 ? "16" : "8");
						else if (Bits < 8)		strcpy (StrBits, "8");
						
						logs_writeln_datas (StrBits);
						
						fileconv_change_quantification_with_sox (detail, fic, StrBits);
					} else {
						conv_inc_encode_completed ();
					}

					conv_product_name_for_label (fic->dest_ape);
					conv.type_conv = MAC_WAV_TO_APE;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = (fic->BoolEtatConv [ ETAT_FROM_WAV_TO_APE ] == TRUE) ? fic->tmp_sox : fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, list, "MAC_WAV_TO_APE");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}

				/*  BUG TROUVE PAR XAVIER
				 *  =====================
				 *
				 *  Si je veux normaliser et convertir un wav 48 kHz en ogg, xcfa me crée un ogg en 44.1 kHz... Pas normal, hein ?
				 */
				
				// CONVERSION WAVPACK
				if (!conv.bool_stop && fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {
					
					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wavpack);

					conv_product_name_for_label (fic->dest_wavpack);
					conv.type_conv = WAVPACK_WAV_TO_WAVPACK;
					conv.bool_reset_conv = TRUE;
							
					fic->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv             = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser  = fic->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc               = fic->tmp_wav;
					param_filelc.filedest              = fic->tmp_wavpack;
					param_filelc.tags                  = info->tags;
					param_filelc.cdrom                 = NULL;
					param_filelc.num_track             = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, list, "WAVPACK_WAV_TO_WAVPACK");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
										
					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}

				// CONVERSION OGG
				if (!conv.bool_stop && fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {
					
					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ogg);

					tagswav_file_ChangeBitrate (fic->tmp_wav, &Channels, &Hertz, &Bits);
					
					// REAJUSTE LA QUANTIFICATION
					// (Bits != 24 && Bits != 16 && Bits != 8);
					if (fic->BoolEtatConv [ ETAT_FROM_WAV_TO_OGG ] == TRUE) {
						
						g_sprintf (&StrBits[0], "%d", (gint)Bits);

						logs_write_datas ("\tChange bit ");
						logs_write_datas (StrBits);
						logs_write_datas (" -> ");
						
						if (Bits > 24)				{ strcpy (StrBits, "24"); Bits = 24; }
						else if (Bits > 16 && Bits < 24)	strcpy (StrBits, (Bits - 16) > 3 ? "24" : "16");
						else if (Bits > 8 && Bits < 16)		strcpy (StrBits, (Bits - 8) > 3 ? "16" : "8");
						else if (Bits < 8)			strcpy (StrBits, "8");
						
						logs_writeln_datas (StrBits);
						
						fileconv_change_quantification_with_sox (detail, fic, StrBits);
					} else {
						conv_inc_encode_completed ();
					}
					
					// SET WITH FLOAT FORMAT IF == 24
					if (Bits == 24) {
						// SOX
						conv_product_name_for_label (detail->namefile);
						conv.type_conv = SOX_WAV_TO_WAV;
						conv.bool_reset_conv = TRUE;

						ListSox = conv_with_sox_float_get_param (
									fic->BoolEtatConv [ ETAT_FROM_WAV_TO_OGG ]  ? fic->tmp_sox : fic->tmp_wav,
									fic->tmp_sox_24);
						conv.ArgConv = conv_alloc_arg (ListSox);
						conv_exec (FALSE, SOX_WAV_TO_WAV, ListSox, "SOX_WAV_TO_WAV");
						ListSox = filelc_remove_glist (ListSox);
						g_free (conv.ArgConv);
						conv.ArgConv = NULL;
						conv_inc_encode_completed ();
						conv.type_conv = NONE_CONV;
						conv_remove_name_for_label (_CONV_);
						
						conv_product_name_for_label (fic->tmp_sox_24);
						conv.type_conv = COPY_FILE;
						conv.bool_reset_conv = TRUE;
						conv_copy_src_to_dest (fic->tmp_sox_24, fic->tmp_sox);
						conv.type_conv = NONE_CONV;
						conv_remove_name_for_label (_CONV_);
					} else {
						conv_inc_encode_completed ();
						conv_inc_encode_completed ();
					}

					conv_product_name_for_label (fic->dest_ogg);
					conv.type_conv = OGGENC_WAV_TO_OGG;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv             = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser  = fic->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					
					if (fic->BoolEtatConv [ ETAT_FROM_WAV_TO_OGG ] == TRUE || Bits == 24) {
						param_filelc.filesrc               = fic->tmp_sox;
					}
					else {
						param_filelc.filesrc               = fic->tmp_wav;
					}
					
					param_filelc.filedest              = fic->tmp_ogg;
					param_filelc.tags                  = info->tags;
					param_filelc.cdrom                 = NULL;
					param_filelc.num_track             = NULL;
					param_filelc.BoolSetBitrate        = FALSE;
					param_filelc.PtrStrBitrate         = options_get_params (OGGENC_WAV_TO_OGG, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);
					
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, list, "OGGENC_WAV_TO_OGG");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}				

				// CONVERSION M4A
				if (!conv.bool_stop && fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {
					
					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_m4a);

					tagswav_file_ChangeBitrate (fic->tmp_wav, &Channels, &Hertz, &Bits);
					
					// REAJUSTE LA QUANTIFICATION
					// (Bits != 64 && Bits != 32 && Bits != 24 && Bits != 16 && Bits != 8)
					if (fic->BoolEtatConv [ ETAT_FROM_WAV_TO_M4A ] == TRUE) {
						
						g_sprintf (&StrBits[0], "%d", (gint)Bits);

						logs_write_datas ("\tChange bit ");
						logs_write_datas (StrBits);
						logs_write_datas (" -> ");
						
						if (Bits > 64)				strcpy (StrBits, "64");
						else if (Bits > 32 && Bits < 64)	{ strcpy (StrBits, "32"); Bits = 32; }
						else if (Bits > 24 && Bits < 32)	{ strcpy (StrBits, "24"); Bits = 24; }
						else if (Bits > 16 && Bits < 24)	strcpy (StrBits, (Bits - 16) > 3 ? "24" : "16");
						else if (Bits > 8 && Bits < 16)		strcpy (StrBits, (Bits - 8) > 3 ? "16" : "8");
						else if (Bits < 8)			strcpy (StrBits, "8");
						
						logs_writeln_datas (StrBits);
						
						fileconv_change_quantification_with_sox (detail, fic, StrBits);
						// SORTIE FICHIER EN tmp_sox
					}
					else {
						conv_product_name_for_label (fic->tmp_sox_24);
						conv.type_conv = COPY_FILE;
						conv.bool_reset_conv = TRUE;
						conv_copy_src_to_dest (fic->tmp_wav, fic->tmp_sox);
						conv.type_conv = NONE_CONV;
						conv_remove_name_for_label (_CONV_);
						// SORTIE FICHIER EN tmp_sox
					}
					
					// SET WITH FLOAT FORMAT IF Bits == 24 || 32
					if (Bits == 32 || Bits == 24) {
						// SOX
						conv_product_name_for_label (detail->namefile);
						conv.type_conv = SOX_WAV_TO_WAV;
						conv.bool_reset_conv = TRUE;

						ListSox = conv_with_sox_float_get_param (
									fic->tmp_sox, 
									fic->tmp_sox_24);
						conv.ArgConv = conv_alloc_arg (ListSox);
						conv_exec (FALSE, SOX_WAV_TO_WAV, ListSox, "SOX_WAV_TO_WAV");
						ListSox = filelc_remove_glist (ListSox);
						g_free (conv.ArgConv);
						conv.ArgConv = NULL;
						conv_inc_encode_completed ();
						conv.type_conv = NONE_CONV;
						conv_remove_name_for_label (_CONV_);
						
						conv_product_name_for_label (fic->tmp_sox);
						conv.type_conv = COPY_FILE;
						conv.bool_reset_conv = TRUE;
						conv_copy_src_to_dest (fic->tmp_sox_24, fic->tmp_sox);
						conv.type_conv = NONE_CONV;
						conv_remove_name_for_label (_CONV_);
						// SORTIE FICHIER EN tmp_sox
					} else {
						conv_inc_encode_completed ();
						conv_inc_encode_completed ();
					}

					conv_product_name_for_label (fic->dest_m4a);
					conv.type_conv = FAAC_WAV_TO_M4A;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = fic->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_sox;
					param_filelc.filedest             = fic->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, list, "FAAC_WAV_TO_M4A");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}

				// CONVERSION AAC
				if (!conv.bool_stop && fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {
					
					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_aac);

					tagswav_file_ChangeBitrate (fic->tmp_wav, &Channels, &Hertz, &Bits);
					
					// REAJUSTE LA QUANTIFICATION
					// (Bits != 64 && Bits != 32 && Bits != 24 && Bits != 16 && Bits != 8)
					if (fic->BoolEtatConv [ ETAT_FROM_WAV_TO_AAC ] == TRUE) {
						
						g_sprintf (&StrBits[0], "%d", (gint)Bits);

						logs_write_datas ("\tChange bit ");
						logs_write_datas (StrBits);
						logs_write_datas (" -> ");
						
						if (Bits > 64)				strcpy (StrBits, "64");
						else if (Bits > 32 && Bits < 64)	strcpy (StrBits, "32");
						else if (Bits > 24 && Bits < 32)	{ strcpy (StrBits, "24"); Bits = 24; }
						else if (Bits > 16 && Bits < 24)	strcpy (StrBits, (Bits - 16) > 3 ? "24" : "16");
						else if (Bits > 8 && Bits < 16)		strcpy (StrBits, (Bits - 8) > 3 ? "16" : "8");
						else if (Bits < 8)			strcpy (StrBits, "8");
						
						logs_writeln_datas (StrBits);
						
						fileconv_change_quantification_with_sox (detail, fic, StrBits);
						// SORTIE FICHIER EN tmp_sox
					}
					else {
						conv_product_name_for_label (fic->tmp_sox);
						conv.type_conv = COPY_FILE;
						conv.bool_reset_conv = TRUE;
						conv_copy_src_to_dest (fic->tmp_wav, fic->tmp_sox);
						conv.type_conv = NONE_CONV;
						conv_remove_name_for_label (_CONV_);
						// SORTIE FICHIER EN tmp_sox
					}
					
					// SET WITH FLOAT FORMAT IF Bits == 24
					if (Bits == 24) {
						// SOX FLOAT
						conv_product_name_for_label (detail->namefile);
						conv.type_conv = SOX_WAV_TO_WAV;
						conv.bool_reset_conv = TRUE;
						ListSox = conv_with_sox_float_get_param (fic->tmp_sox, fic->tmp_sox_24);
						conv.ArgConv = conv_alloc_arg (ListSox);
						conv_exec (FALSE, SOX_WAV_TO_WAV, ListSox, "SOX_WAV_TO_WAV");
						ListSox = filelc_remove_glist (ListSox);
						g_free (conv.ArgConv);
						conv.ArgConv = NULL;
						conv_inc_encode_completed ();;
						conv.type_conv = NONE_CONV;
						conv_remove_name_for_label (_CONV_);
						
						conv_product_name_for_label (fic->tmp_sox);
						conv.type_conv = COPY_FILE;
						conv.bool_reset_conv = TRUE;
						conv_copy_src_to_dest (fic->tmp_sox_24, fic->tmp_sox);
						conv.type_conv = NONE_CONV;
						conv_remove_name_for_label (_CONV_);
						// SORTIE FICHIER EN tmp_sox
					} else {
						conv_inc_encode_completed ();
						conv_inc_encode_completed ();
					}
					
					if (Hertz < 44100) {
						conv_product_name_for_label (fic->tmp_sox);
						conv.type_conv = MPLAYER_WAV_TO_WAV;
						conv.bool_reset_conv = TRUE;

					GDK_THREADS_ENTER();
						listmplayer = g_list_append (listmplayer, g_strdup ("nice"));
						listmplayer = g_list_append (listmplayer, g_strdup ("-n"));
						listmplayer = g_list_append (listmplayer, g_strdup (conv.valuenice));
						listmplayer = g_list_append (listmplayer, g_strdup ("mplayer"));
						listmplayer = g_list_append (listmplayer, g_strdup ("-nojoystick"));
						listmplayer = g_list_append (listmplayer, g_strdup ("-nolirc"));
						listmplayer = g_list_append (listmplayer, g_strdup (fic->tmp_sox));
						listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
						listmplayer = g_list_append (listmplayer, g_strdup ("pcm"));
						listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
						listmplayer = g_list_append (listmplayer, g_strdup_printf ("pcm:file=%s",fic->tmp_sox_24));
						// listmplayer = g_list_append (listmplayer, g_strdup ("-af"));
						// listmplayer = g_list_append (listmplayer, g_strdup ("channels=2"));
						listmplayer = g_list_append (listmplayer, g_strdup ("-srate"));
						listmplayer = g_list_append (listmplayer, g_strdup ("44100"));
						conv.ArgConv = conv_alloc_arg (listmplayer);
					GDK_THREADS_LEAVE();
						BoolResultMplayerIsOk = conv_exec (param_filelc.With_CommandLineUser, MPLAYER_WAV_TO_WAV, listmplayer, "MPLAYER_WAV_TO_WAV");
					GDK_THREADS_ENTER();
						listmplayer = filelc_remove_glist (listmplayer);
						g_free (conv.ArgConv);
						conv.ArgConv = NULL;
					GDK_THREADS_LEAVE();

						conv.type_conv = NONE_CONV;
						conv_remove_name_for_label (_CONV_);
						conv_inc_encode_completed ();
						conv.bool_percent_conv = TRUE;
						
						conv_product_name_for_label (fic->tmp_sox);
						conv.type_conv = COPY_FILE;
						conv.bool_reset_conv = TRUE;
						conv_copy_src_to_dest (fic->tmp_sox_24, fic->tmp_sox);
						conv.type_conv = NONE_CONV;
						conv_remove_name_for_label (_CONV_);
						// SORTIE FICHIER EN tmp_sox
					} else {
						conv_inc_encode_completed ();
						conv_inc_encode_completed ();
					}
					
					conv_product_name_for_label (fic->dest_aac);
					conv.type_conv = AACPLUSENC_WAV_TO_AAC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_sox;
					param_filelc.filedest             = fic->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, list, "AACPLUSENC_WAV_TO_AAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}
				
				// CONVERSION MPC
				if (!conv.bool_stop && fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {
					
					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mpc);

					tagswav_file_ChangeBitrate (fic->tmp_wav, &Channels, &Hertz, &Bits);
					
					// REAJUSTE LA QUANTIFICATION
					// (Bits != 64 && Bits != 32 && Bits != 24 && Bits != 16 && Bits != 8)
					if (fic->BoolEtatConv [ ETAT_FROM_WAV_TO_MPC ] == TRUE) {
						
						g_sprintf (&StrBits[0], "%d", (gint)Bits);

						logs_write_datas ("\tChange bit ");
						logs_write_datas (StrBits);
						logs_write_datas (" -> ");
						
						if (Bits > 64)				strcpy (StrBits, "64");
						else if (Bits > 32 && Bits < 64)	{ strcpy (StrBits, "32"); Bits = 32; }
						else if (Bits > 24 && Bits < 32)	{ strcpy (StrBits, "24"); Bits = 24; }
						else if (Bits > 16 && Bits < 24)	strcpy (StrBits, (Bits - 16) > 3 ? "24" : "16");
						else if (Bits > 8 && Bits < 16)		strcpy (StrBits, (Bits - 8) > 3 ? "16" : "8");
						else if (Bits < 8)			strcpy (StrBits, "8");
						
						logs_writeln_datas (StrBits);
						
						fileconv_change_quantification_with_sox (detail, fic, StrBits);
						// SORTIE FICHIER EN tmp_sox
					}
					else {
						conv_product_name_for_label (fic->tmp_sox_24);
						conv.type_conv = COPY_FILE;
						conv.bool_reset_conv = TRUE;
						conv_copy_src_to_dest (fic->tmp_wav, fic->tmp_sox);
						conv.type_conv = NONE_CONV;
						conv_remove_name_for_label (_CONV_);
						// SORTIE FICHIER EN tmp_sox
					}
					
					// SET WITH FLOAT FORMAT IF Bits == 24 || 32
					if (Bits == 32 || Bits == 24) {
						// SOX
						conv_product_name_for_label (detail->namefile);
						conv.type_conv = SOX_WAV_TO_WAV;
						conv.bool_reset_conv = TRUE;
						ListSox = conv_with_sox_float_get_param (fic->tmp_sox, fic->tmp_sox_24);
						conv.ArgConv = conv_alloc_arg (ListSox);
						conv_exec (FALSE, SOX_WAV_TO_WAV, ListSox, "SOX_WAV_TO_WAV");
						ListSox = filelc_remove_glist (ListSox);
						g_free (conv.ArgConv);
						conv.ArgConv = NULL;
						conv_inc_encode_completed ();
						conv.type_conv = NONE_CONV;
						conv_remove_name_for_label (_CONV_);
						
						conv_product_name_for_label (fic->tmp_sox);
						conv.type_conv = COPY_FILE;
						conv.bool_reset_conv = TRUE;
						conv_copy_src_to_dest (fic->tmp_sox_24, fic->tmp_sox);
						conv.type_conv = NONE_CONV;
						conv_remove_name_for_label (_CONV_);
						// SORTIE FICHIER EN tmp_sox
					} else {
						conv_inc_encode_completed ();
						conv_inc_encode_completed ();
					}
					
					if (Hertz < 44100) {
						conv_product_name_for_label (fic->tmp_sox);
						conv.type_conv = MPLAYER_WAV_TO_WAV;
						conv.bool_reset_conv = TRUE;

					GDK_THREADS_ENTER();
						listmplayer = g_list_append (listmplayer, g_strdup ("nice"));
						listmplayer = g_list_append (listmplayer, g_strdup ("-n"));
						listmplayer = g_list_append (listmplayer, g_strdup (conv.valuenice));
						listmplayer = g_list_append (listmplayer, g_strdup ("mplayer"));
						listmplayer = g_list_append (listmplayer, g_strdup ("-nojoystick"));
						listmplayer = g_list_append (listmplayer, g_strdup ("-nolirc"));
						listmplayer = g_list_append (listmplayer, g_strdup (fic->tmp_sox));
						listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
						listmplayer = g_list_append (listmplayer, g_strdup ("pcm"));
						listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
						listmplayer = g_list_append (listmplayer, g_strdup_printf ("pcm:file=%s",fic->tmp_sox_24));
						// listmplayer = g_list_append (listmplayer, g_strdup ("-af"));
						// listmplayer = g_list_append (listmplayer, g_strdup ("channels=2"));
						listmplayer = g_list_append (listmplayer, g_strdup ("-srate"));
						listmplayer = g_list_append (listmplayer, g_strdup ("44100"));
						conv.ArgConv = conv_alloc_arg (listmplayer);
					GDK_THREADS_LEAVE();
						BoolResultMplayerIsOk = conv_exec (param_filelc.With_CommandLineUser, MPLAYER_WAV_TO_WAV, listmplayer, "MPLAYER_WAV_TO_WAV");
					GDK_THREADS_ENTER();
						listmplayer = filelc_remove_glist (listmplayer);
						g_free (conv.ArgConv);
						conv.ArgConv = NULL;
					GDK_THREADS_LEAVE();

						conv.type_conv = NONE_CONV;
						conv_remove_name_for_label (_CONV_);
						conv_inc_encode_completed ();
						conv.bool_percent_conv = TRUE;
						
						conv_product_name_for_label (fic->tmp_sox);
						conv.type_conv = COPY_FILE;
						conv.bool_reset_conv = TRUE;
						conv_copy_src_to_dest (fic->tmp_sox_24, fic->tmp_sox);
						conv.type_conv = NONE_CONV;
						conv_remove_name_for_label (_CONV_);
						// SORTIE FICHIER EN tmp_sox
					} else {
						conv_inc_encode_completed ();
						conv_inc_encode_completed ();
					}
					
					conv_product_name_for_label (fic->dest_mpc);
					conv.type_conv = MPPENC_WAV_TO_MPC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_sox;
					param_filelc.filedest             = fic->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, list, "MPPENC_WAV_TO_MPC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}

				// CONVERSION MP3
				if (!conv.bool_stop && fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {
					
					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mp3);

					// REAJUSTE LA QUANTIFICATION
					// Hertz == 48000 && Bits == 32
					// if (fic->BoolEtatConv [ ETAT_FROM_WAV_TO_MP3 ] == TRUE) {
					if (Hertz == 48000 && Bits == 32) {
						// SOX
						conv_product_name_for_label (detail->namefile);
						conv.type_conv = SOX_WAV_TO_WAV;
						conv.bool_reset_conv = TRUE;

						ListSox = conv_with_sox_float_get_param (fic->tmp_wav, fic->tmp_sox);
						conv.ArgConv = conv_alloc_arg (ListSox);
						conv_exec (FALSE, SOX_WAV_TO_WAV, ListSox, "SOX_WAV_TO_WAV");
						ListSox = filelc_remove_glist (ListSox);
						g_free (conv.ArgConv);
						conv.ArgConv = NULL;
						conv_inc_encode_completed ();
						conv.type_conv = NONE_CONV;
						conv_remove_name_for_label (_CONV_);
					} else if (Bits < 8) {
						// CORRECTION
						// http://forum.ubuntu-fr.org/viewtopic.php?pid=3271586#p3271586
						// joelab07
						fileconv_change_quantification_with_sox (detail, fic, "8");
						// SORTIE FICHIER EN tmp_sox
						conv_inc_encode_completed ();
					} else {
						conv_inc_encode_completed ();
					}

					conv_product_name_for_label (fic->dest_mp3);
					conv.type_conv = LAME_WAV_TO_MP3;
					conv.bool_reset_conv = TRUE;
										
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = (fic->BoolEtatConv [ ETAT_FROM_WAV_TO_MP3 ] == TRUE) ? fic->tmp_sox : fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, list, "LAME_WAV_TO_MP3");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}				

				/* copie dossier temporaire vers destination */
				if (!conv.bool_stop) {
					fileconv_copy_src_to_dest (detail, fic);
				}
			}

			/*
			SOURCE FLAC
			DEST   OGG      :  FLAC -> OGG    oggenc
			DEST   WAV      :  FLAC -> WAV    flac
			DEST   MP3      :  WAV  -> MP3    lame
			DEST   M4A      :  WAV  -> M4A    faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (!conv.bool_stop && detail->type_infosong_file_is == FILE_IS_FLAC &&
				(
				fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_FLAC *info = (INFO_FLAC *)detail->info;

				/**/fileconv_infos (detail, fic);

				/* copie source FLAC vers dossier temporaire */
				conv_product_name_for_label (detail->namefile);
				conv.type_conv = COPY_FILE;
				conv.bool_reset_conv = TRUE;
				conv_copy_src_to_dest (detail->namefile, fic->tmp_flac);
				conv.type_conv = NONE_CONV;
				conv_remove_name_for_label (_CONV_);

				if (!conv.bool_stop && fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST) {
					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wav);
				}
				
				if (!conv.bool_stop) {

					conv_product_name_for_label (fic->dest_wav);
					conv.type_conv = FLAC_FLAC_TO_WAV;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = FLAC_FLAC_TO_WAV;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_flac;
					param_filelc.filedest             = fic->tmp_wav;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					if (conv_exec (param_filelc.With_CommandLineUser, FLAC_FLAC_TO_WAV, list, "FLAC_FLAC_TO_WAV") == FALSE) {
						g_print("\n*****************************************\n---> ERREUR PENDANT LA CONVERSION DU flac vers wav\n*****************************************\n\n");
						GDK_THREADS_ENTER();
						logs_write_datas ("\nERREUR PENDANT LA CONVERSION DE [ ");
						logs_write_datas (detail->namefile);
						logs_writeln_datas (" ] VERS LE FORMAT WAV");
						GDK_THREADS_LEAVE();
					}
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}
				
				/* conversion APE */
				if (!conv.bool_stop && fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ape);

					conv_product_name_for_label (fic->dest_ape);
					conv.type_conv = MAC_WAV_TO_APE;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, list, "MAC_WAV_TO_APE");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion MPC */
				if (!conv.bool_stop && fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mpc);

					conv_product_name_for_label (fic->dest_mpc);
					conv.type_conv = MPPENC_WAV_TO_MPC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, list, "MPPENC_WAV_TO_MPC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion MP3 */
				if (!conv.bool_stop && fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mp3);

					conv_product_name_for_label (fic->dest_mp3);
					conv.type_conv = LAME_WAV_TO_MP3;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, list, "LAME_WAV_TO_MP3");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion OGG */
				if (!conv.bool_stop && fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ogg);

					conv_product_name_for_label (fic->dest_ogg);
					conv.type_conv = OGGENC_WAV_TO_OGG;
					conv.bool_reset_conv = TRUE;
					
					param_filelc.type_conv            = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_ogg;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (OGGENC_WAV_TO_OGG, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);
				
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, list, "OGGENC_WAV_TO_OGG");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
				
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion M4A */
				if (!conv.bool_stop && fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_m4a);

					conv_product_name_for_label (fic->dest_m4a);
					conv.type_conv = FAAC_WAV_TO_M4A;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = fic->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, list, "FAAC_WAV_TO_M4A");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion AAC */
				if (!conv.bool_stop && fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_aac);

					conv_product_name_for_label (fic->dest_aac);
					conv.type_conv = AACPLUSENC_WAV_TO_AAC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, list, "AACPLUSENC_WAV_TO_AAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}

				/* conversion WAVPACK */
				if (!conv.bool_stop && fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wavpack);

					conv_product_name_for_label (fic->dest_wavpack);
					conv.type_conv = WAVPACK_WAV_TO_WAVPACK;
					conv.bool_reset_conv = TRUE;
					
					fic->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv            = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser = fic->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_wavpack;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, list, "WAVPACK_WAV_TO_WAVPACK");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();

					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* copie dossier temporaire vers destination */
				if (!conv.bool_stop) {
					fileconv_copy_src_to_dest (detail, fic);
				}
			}

			/*
			SOURCE APE
			DEST   WAV      :  APE -> WAV     mac
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (!conv.bool_stop && detail->type_infosong_file_is == FILE_IS_APE &&
				(
				fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_APE *info = (INFO_APE *)detail->info;

				/**/fileconv_infos (detail, fic);

				/* copie source WAV vers dossier temporaire */
				conv_product_name_for_label (detail->namefile);
				conv.type_conv = COPY_FILE;
				conv.bool_reset_conv = TRUE;
				conv_copy_src_to_dest (detail->namefile, fic->tmp_ape);
				conv.type_conv = NONE_CONV;
				conv_remove_name_for_label (_CONV_);

				if (!conv.bool_stop && fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST) {
					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wav);
				}
				
				/* conversion WAV */
				if (!conv.bool_stop) {

					conv_product_name_for_label (fic->dest_wav);
					conv.type_conv = MAC_APE_TO_WAV;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MAC_APE_TO_WAV;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_ape;
					param_filelc.filedest             = fic->tmp_wav;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MAC_APE_TO_WAV, list, "MAC_APE_TO_WAV");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}

				/* conversion MP3 */
				if (!conv.bool_stop && fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mp3);

					conv_product_name_for_label (fic->dest_mp3);
					conv.type_conv = LAME_WAV_TO_MP3;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, list, "LAME_WAV_TO_MP3");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion OGG */
				if (!conv.bool_stop && fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ogg);

					conv_product_name_for_label (fic->dest_ogg);
					conv.type_conv = OGGENC_WAV_TO_OGG;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_ogg;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (OGGENC_WAV_TO_OGG, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, list, "OGGENC_WAV_TO_OGG");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion FLAC */
				if (!conv.bool_stop && fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_flac);

					conv_product_name_for_label (fic->dest_flac);
					conv.type_conv = FLAC_WAV_TO_FLAC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_flac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, list, "FLAC_WAV_TO_FLAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion M4A */
				if (!conv.bool_stop && fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_m4a);

					conv_product_name_for_label (fic->dest_m4a);
					conv.type_conv = FAAC_WAV_TO_M4A;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = fic->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, list, "FAAC_WAV_TO_M4A");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion AAC */
				if (!conv.bool_stop && fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_aac);

					conv_product_name_for_label (fic->dest_aac);
					conv.type_conv = AACPLUSENC_WAV_TO_AAC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, list, "AACPLUSENC_WAV_TO_AAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}

				/* conversion MPC */
				if (!conv.bool_stop && fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mpc);

					conv_product_name_for_label (fic->dest_mpc);
					conv.type_conv = MPPENC_WAV_TO_MPC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, list, "MPPENC_WAV_TO_MPC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion WAVPACK */
				if (!conv.bool_stop && fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wavpack);

					conv_product_name_for_label (fic->dest_wavpack);
					conv.type_conv = WAVPACK_WAV_TO_WAVPACK;
					conv.bool_reset_conv = TRUE;
					
					fic->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv            = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser = fic->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_wavpack;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, list, "WAVPACK_WAV_TO_WAVPACK");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();

					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* copie dossier temporaire vers destination */
				if (!conv.bool_stop) {
					fileconv_copy_src_to_dest (detail, fic);
				}
			}

			/*
			SOURCE WAVPACK
			DEST   WAV      :  WAVPACK -> WAV wvunpack
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			*/
			if (!conv.bool_stop && detail->type_infosong_file_is == FILE_IS_WAVPACK &&
				(
				fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST
				)) {

				INFO_WAVPACK *info = (INFO_WAVPACK *)detail->info;

				/**/fileconv_infos (detail, fic);

				/* copie source WAV vers dossier temporaire */
				conv_product_name_for_label (detail->namefile);
				conv.type_conv = COPY_FILE;
				conv.bool_reset_conv = TRUE;
				conv_copy_src_to_dest (detail->namefile, fic->tmp_wavpack);
				conv_remove_name_for_label (_CONV_);
				
				conv_product_name_for_label (detail->namefile);
				conv.type_conv = COPY_FILE;
				conv.bool_reset_conv = TRUE;
				conv_copy_src_to_dest (fic->dest_wavpack_md5, fic->tmp_wavpack_md5);
				conv.type_conv = NONE_CONV;
				conv_remove_name_for_label (_CONV_);

				if (!conv.bool_stop && fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST) {
					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wav);
				}
				
				/* Unpack: WAVPACK -> WAV */
				if (!conv.bool_stop) {

					conv_product_name_for_label (fic->dest_wavpack);
					conv.type_conv = WVUNPACK_WAVPACK_TO_WAV;
					conv.bool_reset_conv = TRUE;
					
					fic->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
					
				GDK_THREADS_ENTER();
					list = g_list_append (list, g_strdup ("nice"));
					list = g_list_append (list, g_strdup ("-n"));
					list = g_list_append (list, g_strdup_printf ("%d", options_get_val_nice ()));
					list = g_list_append (list, g_strdup ("wvunpack"));
					list = g_list_append (list, g_strdup ("-y"));
					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						list = g_list_append (list, g_strdup (optionsWavpack_get_wavpack_signature_md5 ()));
					}
					list = g_list_append (list, g_strdup_printf ("%s", fic->tmp_wavpack));
					list = g_list_append (list, g_strdup_printf ("%s", fic->tmp_wav));
						
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (FALSE, WVUNPACK_WAVPACK_TO_WAV, list, "WVUNPACK_WAVPACK_TO_WAV");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wvunpack = TRUE;
					}
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}

				/* conversion MP3 */
				if (!conv.bool_stop && fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mp3);

					conv_product_name_for_label (fic->dest_mp3);
					conv.type_conv = LAME_WAV_TO_MP3;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);
					
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, list, "LAME_WAV_TO_MP3");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}
				
				/* conversion OGG */
				if (!conv.bool_stop && fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ogg);

					conv_product_name_for_label (fic->dest_ogg);
					conv.type_conv = OGGENC_WAV_TO_OGG;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv             = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser  = fic->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc               = fic->tmp_wav;
					param_filelc.filedest              = fic->tmp_ogg;
					param_filelc.tags                  = info->tags;
					param_filelc.cdrom                 = NULL;
					param_filelc.num_track             = NULL;
					param_filelc.BoolSetBitrate        = FALSE;
					param_filelc.PtrStrBitrate         = options_get_params (OGGENC_WAV_TO_OGG, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, list, "OGGENC_WAV_TO_OGG");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}
				
				/* conversion FLAC */
				if (!conv.bool_stop && fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_flac);

					conv_product_name_for_label (fic->dest_flac);
					conv.type_conv = FLAC_WAV_TO_FLAC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv             = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser  = fic->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc               = fic->tmp_wav;
					param_filelc.filedest              = fic->tmp_flac;
					param_filelc.tags                  = info->tags;
					param_filelc.cdrom                 = NULL;
					param_filelc.num_track             = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, list, "FLAC_WAV_TO_FLAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}
				
				/* conversion M4A */
				if (!conv.bool_stop && fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_m4a);

					conv_product_name_for_label (fic->dest_m4a);
					conv.type_conv = FAAC_WAV_TO_M4A;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = fic->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, list, "FAAC_WAV_TO_M4A");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion AAC */
				if (!conv.bool_stop && fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_aac);

					conv_product_name_for_label (fic->dest_aac);
					conv.type_conv = AACPLUSENC_WAV_TO_AAC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, list, "AACPLUSENC_WAV_TO_AAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}

				/* conversion MPC */
				if (!conv.bool_stop && fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mpc);

					conv_product_name_for_label (fic->dest_mpc);
					conv.type_conv = MPPENC_WAV_TO_MPC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, list, "MPPENC_WAV_TO_MPC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}
				
				/* conversion APE */
				if (!conv.bool_stop && fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ape);

					conv_product_name_for_label (fic->dest_ape);
					conv.type_conv = MAC_WAV_TO_APE;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, list, "MAC_WAV_TO_APE");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}
				
				/* copie dossier temporaire vers destination */
				if (!conv.bool_stop) {
					fileconv_copy_src_to_dest (detail, fic);
				}
			}

			/*
			SOURCE OGG
			DEST   WAV      :  OGG -> WAV     ogg123
			DEST   FLAC     :  WAV -> FLAC    flac
			DEST   MP3      :  WAV -> MP3     lame
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (!conv.bool_stop && detail->type_infosong_file_is == FILE_IS_OGG &&
				(
				fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_OGG *info = (INFO_OGG *)detail->info;

				/**/fileconv_infos (detail, fic);

				/* Copie source WAV vers dossier temporaire
				 * SI <> NULL ALORS 'detail->namefileCopie' se trouve deja dans le dossier temporaire
				*/
				if (detail->namefileCopie == NULL) {
					conv_product_name_for_label (detail->namefile);
					conv.type_conv = COPY_FILE;
					conv.bool_reset_conv = TRUE;
					conv_copy_src_to_dest (detail->namefile, fic->tmp_ogg);
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
				}

				if (!conv.bool_stop && fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST) {
					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wav);
				}
				
				/* convert to: WAV */
				if (!conv.bool_stop) {

					/*
					conv_product_name_for_label (fic->dest_wav);
					conv.type_conv = OGG123_OGG_TO_WAV;
					conv.bool_reset_conv = TRUE;
					
				GDK_THREADS_ENTER();
					list = g_list_append (list, g_strdup ("nice"));
					list = g_list_append (list, g_strdup ("-n"));
					list = g_list_append (list, g_strdup_printf ("%d", options_get_val_nice ()));
					list = g_list_append (list, g_strdup ("ogg123"));
					list = g_list_append (list, g_strdup ("-d"));
					list = g_list_append (list, g_strdup ("wav"));
					list = g_list_append (list, g_strdup ("-f"));
					list = g_list_append (list, g_strdup_printf ("%s", fic->tmp_wav));
					list = g_list_append (list, g_strdup_printf ("%s", fic->tmp_ogg));
					
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();

					conv_exec (param_filelc.With_CommandLineUser, OGG123_OGG_TO_WAV, list, "OGG123_OGG_TO_WAV");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					*/
					conv_product_name_for_label (detail->namefile);
					conv.type_conv = MPLAYER_OGG_TO_WAV;
					conv.bool_reset_conv = TRUE;
				GDK_THREADS_ENTER();
					listmplayer = g_list_append (listmplayer, g_strdup ("nice"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-n"));
					listmplayer = g_list_append (listmplayer, g_strdup (conv.valuenice));
					listmplayer = g_list_append (listmplayer, g_strdup ("mplayer"));
					
					listmplayer = g_list_append (listmplayer, g_strdup ("-nojoystick"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-nolirc"));

					listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
					listmplayer = g_list_append (listmplayer, g_strdup ("pcm"));
					listmplayer = g_list_append (listmplayer, g_strdup (fic->tmp_ogg));
					listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
					listmplayer = g_list_append (listmplayer, g_strdup_printf ("pcm:file=%s", fic->tmp_wav));

					conv.ArgConv = conv_alloc_arg (listmplayer);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MPLAYER_OGG_TO_WAV, listmplayer, "MPLAYER_OGG_TO_WAV");
				GDK_THREADS_ENTER();
					listmplayer = filelc_remove_glist (listmplayer);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion APE */
				if (!conv.bool_stop && fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ape);

					conv_product_name_for_label (fic->dest_ape);
					conv.type_conv = MAC_WAV_TO_APE;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, list, "MAC_WAV_TO_APE");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion MPC */
				if (!conv.bool_stop && fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mpc);

					conv_product_name_for_label (fic->dest_mpc);
					conv.type_conv = MPPENC_WAV_TO_MPC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, list, "MPPENC_WAV_TO_MPC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion FLAC */
				if (!conv.bool_stop && fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_flac);

					conv_product_name_for_label (fic->dest_flac);
					conv.type_conv = FLAC_WAV_TO_FLAC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_flac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, list, "FLAC_WAV_TO_FLAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion MP3 */
				if (!conv.bool_stop && fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mp3);

					conv_product_name_for_label (fic->dest_mp3);
					conv.type_conv = LAME_WAV_TO_MP3;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);
					
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, list, "LAME_WAV_TO_MP3");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion M4A */
				if (!conv.bool_stop && fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_m4a);

					conv_product_name_for_label (fic->dest_m4a);
					conv.type_conv = FAAC_WAV_TO_M4A;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = fic->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, list, "FAAC_WAV_TO_M4A");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion AAC */
				if (!conv.bool_stop && fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_aac);

					conv_product_name_for_label (fic->dest_aac);
					conv.type_conv = AACPLUSENC_WAV_TO_AAC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, list, "AACPLUSENC_WAV_TO_AAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}

				/* conversion WAVPACK */
				if (!conv.bool_stop && fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wavpack);

					conv_product_name_for_label (fic->dest_wavpack);
					conv.type_conv = WAVPACK_WAV_TO_WAVPACK;
					conv.bool_reset_conv = TRUE;
					
					fic->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv             = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser  = fic->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc               = fic->tmp_wav;
					param_filelc.filedest              = fic->tmp_wavpack;
					param_filelc.tags                  = info->tags;
					param_filelc.cdrom                 = NULL;
					param_filelc.num_track             = NULL;
					
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, list, "WAVPACK_WAV_TO_WAVPACK");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();

					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* copie dossier temporaire vers destination */
				if (!conv.bool_stop) {
					fileconv_copy_src_to_dest (detail, fic);
				}
			}

			/*
			SOURCE M4A
			DEST   WAV      :  M4A -> WAV     faad
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   MP3      :  WAV -> MP3     lame
			DEST   FLAC     :  WAV -> FLAC    flac
			DEST   OGG      :  WAV -> OGG     oggenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (!conv.bool_stop && detail->type_infosong_file_is == FILE_IS_M4A &&
				(
				fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_M4A *info = (INFO_M4A *)detail->info;

				/**/fileconv_infos (detail, fic);

				/* copie source WAV vers dossier temporaire */
				conv_product_name_for_label (detail->namefile);
				conv.type_conv = COPY_FILE;
				conv.bool_reset_conv = TRUE;
				conv_copy_src_to_dest (detail->namefile, fic->tmp_m4a);
				conv.type_conv = NONE_CONV;
				conv_remove_name_for_label (_CONV_);

				conv.type_conv = MPLAYER_M4A_TO_WAV;

				if (!conv.bool_stop && fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST) {
					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wav);
				}
				
				/* conversion WAV */
				if (!conv.bool_stop) {
					
					conv_product_name_for_label (detail->namefile);
					conv.type_conv = MPLAYER_M4A_TO_WAV;
					conv.bool_reset_conv = TRUE;
				GDK_THREADS_ENTER();
					listmplayer = g_list_append (listmplayer, g_strdup ("nice"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-n"));
					listmplayer = g_list_append (listmplayer, g_strdup (conv.valuenice));
					listmplayer = g_list_append (listmplayer, g_strdup ("mplayer"));
					
					listmplayer = g_list_append (listmplayer, g_strdup ("-nojoystick"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-nolirc"));

					listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
					listmplayer = g_list_append (listmplayer, g_strdup ("pcm"));
					listmplayer = g_list_append (listmplayer, g_strdup (fic->tmp_m4a));
					listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
					listmplayer = g_list_append (listmplayer, g_strdup_printf ("pcm:file=%s", fic->tmp_wav));

					conv.ArgConv = conv_alloc_arg (listmplayer);
				GDK_THREADS_LEAVE();
					BoolResultMplayerIsOk = conv_exec (param_filelc.With_CommandLineUser, MPLAYER_M4A_TO_WAV, listmplayer, "MPLAYER_M4A_TO_WAV");
				GDK_THREADS_ENTER();
					listmplayer = filelc_remove_glist (listmplayer);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					if (BoolResultMplayerIsOk == FALSE) {
						PRINT("PROBLEME DE CONVERSION AVEC MPLAYER:---------> RETOUR");
						break;
					}
					conv_inc_encode_completed ();
					conv.type_conv = SOX_WAV_TO_WAV;
					
					/*
					listmplayer = conv_with_sox_get_param (fic->tmp_sox, fic->tmp_wav, "44100", "2", "16");
					conv.ArgConv = conv_alloc_arg (listmplayer);
					conv_exec (FALSE, SOX_WAV_TO_WAV, listmplayer, "SOX_WAV_TO_WAV");
					listmplayer = filelc_remove_glist (listmplayer);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
					*/
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*
					if (fileconv_test_file (fic->tmp_wav) == FALSE) {
						PRINT("---------> RETOUR");
						break;
					}
					*/
				}

				/* conversion APE */
				if (!conv.bool_stop && fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ape);

					conv_product_name_for_label (fic->dest_ape);
					conv.type_conv = MAC_WAV_TO_APE;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, list, "MAC_WAV_TO_APE");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion MPC */
				if (!conv.bool_stop && fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mpc);

					conv_product_name_for_label (fic->dest_mpc);
					conv.type_conv = MPPENC_WAV_TO_MPC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, list, "MPPENC_WAV_TO_MPC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion FLAC */
				if (!conv.bool_stop && fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_flac);

					conv_product_name_for_label (fic->dest_flac);
					conv.type_conv = FLAC_WAV_TO_FLAC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_flac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, list, "FLAC_WAV_TO_FLAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion MP3 */
				if (!conv.bool_stop && fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mp3);

					conv_product_name_for_label (fic->dest_mp3);
					conv.type_conv = LAME_WAV_TO_MP3;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, list, "LAME_WAV_TO_MP3");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion OGG */
				if (!conv.bool_stop && fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ogg);

					conv_product_name_for_label (fic->dest_ogg);
					conv.type_conv = OGGENC_WAV_TO_OGG;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv             = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser  = fic->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc               = fic->tmp_wav;
					param_filelc.filedest              = fic->tmp_ogg;
					param_filelc.tags                  = info->tags;
					param_filelc.cdrom                 = NULL;
					param_filelc.num_track             = NULL;
					param_filelc.BoolSetBitrate        = FALSE;
					param_filelc.PtrStrBitrate         = options_get_params (OGGENC_WAV_TO_OGG, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, list, "OGGENC_WAV_TO_OGG");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion AAC */
				if (!conv.bool_stop && fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_aac);

					conv_product_name_for_label (fic->dest_aac);
					conv.type_conv = AACPLUSENC_WAV_TO_AAC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, list, "AACPLUSENC_WAV_TO_AAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}

				/* conversion WAVPACK */
				if (!conv.bool_stop && fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wavpack);

					conv_product_name_for_label (fic->dest_wavpack);
					conv.type_conv = WAVPACK_WAV_TO_WAVPACK;
					conv.bool_reset_conv = TRUE;
					
					fic->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv            = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser = fic->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_wavpack;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, list, "WAVPACK_WAV_TO_WAVPACK");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();

					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* copie dossier temporaire vers destination */
				if (!conv.bool_stop) {
					fileconv_copy_src_to_dest (detail, fic);
				}
			}

			/*
			SOURCE MPC
			DEST   WAV      :  MPC -> WAV     mppdec
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (!conv.bool_stop && detail->type_infosong_file_is == FILE_IS_MPC &&
				(
				fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_MPC *info = (INFO_MPC *)detail->info;
				gint	  BoolApplyConvMPC = 0;
				
				/**/fileconv_infos (detail, fic);

				/* copie source WAV vers dossier temporaire */
				conv_product_name_for_label (detail->namefile);
				conv.type_conv = COPY_FILE;
				conv.bool_reset_conv = TRUE;
				conv_copy_src_to_dest (detail->namefile, fic->tmp_mpc);
				conv.type_conv = NONE_CONV;
				conv_remove_name_for_label (_CONV_);

				if (!conv.bool_stop && fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST) {
					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wav);
				}
				
				/* conversion WAV */
				if (!conv.bool_stop) {

					conv_product_name_for_label (fic->dest_wav);
					conv.type_conv = MPPDEC_MPC_TO_WAV;
					conv.bool_reset_conv = TRUE;

				GDK_THREADS_ENTER();
					list = g_list_append (list, g_strdup ("nice"));
					list = g_list_append (list, g_strdup ("-n"));
					list = g_list_append (list, g_strdup_printf ("%d", options_get_val_nice ()));
					
					// list = g_list_append (list, g_strdup (PrgInit.name_mppdec));
					// list = g_list_append (list, g_strdup (prginit_get_name (NMR_mpc123_mppdec)));
					list = g_list_append (list, g_strdup (prginit_get_name (NMR_musepack_tools_mppdec)));
					// list = g_list_append (list, g_strdup ("mppdec"));
					
					// MPC123 et MPPDEC et MPPDEC: MPC -> WAV
					BoolApplyConvMPC = 0;
					ptr = prginit_get_name (NMR_musepack_tools_mppdec);
					if (strstr (ptr, "mpc123") != NULL) BoolApplyConvMPC = 1;
					if (strstr (ptr, "mppdec") != NULL) BoolApplyConvMPC = 1;
					if (strstr (ptr, "mpcdec") != NULL) BoolApplyConvMPC = 2;
					
					// mpc123 | mppdec
					if (BoolApplyConvMPC == 1) {
						list = g_list_append (list, g_strdup ("--wav"));
					}
					
					if (HostConf.BoolCpuIs64Bits == TRUE) {
						if (BoolApplyConvMPC == 1) {
							list = g_list_append (list, g_strdup_printf ("%s", fic->tmp_wav));
							list = g_list_append (list, g_strdup_printf ("%s", fic->tmp_mpc));
						}
						else if (BoolApplyConvMPC == 2) {
							list = g_list_append (list, g_strdup_printf ("%s", fic->tmp_mpc));
							list = g_list_append (list, g_strdup_printf ("%s", fic->tmp_wav));
						}
					}
					else {
						list = g_list_append (list, g_strdup_printf ("%s", fic->tmp_mpc));
						list = g_list_append (list, g_strdup_printf ("%s", fic->tmp_wav));
					}

					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();

					conv_exec (param_filelc.With_CommandLineUser, MPPDEC_MPC_TO_WAV, list, "MPPDEC_MPC_TO_WAV");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}

				/* conversion APE */
				if (!conv.bool_stop && fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ape);

					conv_product_name_for_label (fic->dest_ape);
					conv.type_conv = MAC_WAV_TO_APE;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, list, "MAC_WAV_TO_APE");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion FLAC */
				if (!conv.bool_stop && fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_flac);

					conv_product_name_for_label (fic->dest_flac);
					conv.type_conv = FLAC_WAV_TO_FLAC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_flac;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, list, "FLAC_WAV_TO_FLAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion MP3 */
				if (!conv.bool_stop && fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mp3);

					conv_product_name_for_label (fic->dest_mp3);
					conv.type_conv = LAME_WAV_TO_MP3;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, list, "LAME_WAV_TO_MP3");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion OGG */
				if (!conv.bool_stop && fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ogg);

					conv_product_name_for_label (fic->dest_ogg);
					conv.type_conv = OGGENC_WAV_TO_OGG;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_ogg;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (OGGENC_WAV_TO_OGG, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, list, "OGGENC_WAV_TO_OGG");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion M4A */
				if (!conv.bool_stop && fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_m4a);

					conv_product_name_for_label (fic->dest_m4a);
					conv.type_conv = FAAC_WAV_TO_M4A;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = fic->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, list, "FAAC_WAV_TO_M4A");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion AAC */
				if (!conv.bool_stop && fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_aac);

					conv_product_name_for_label (fic->dest_aac);
					conv.type_conv = AACPLUSENC_WAV_TO_AAC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, list, "AACPLUSENC_WAV_TO_AAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}

				/* conversion WAVPACK */
				if (!conv.bool_stop && fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wavpack);

					conv_product_name_for_label (fic->dest_wavpack);
					conv.type_conv = WAVPACK_WAV_TO_WAVPACK;
					conv.bool_reset_conv = TRUE;
					
					fic->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv            = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser = fic->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_wavpack;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, list, "WAVPACK_WAV_TO_WAVPACK");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();

					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* copie dossier temporaire vers destination */
				if (!conv.bool_stop) {
					fileconv_copy_src_to_dest (detail, fic);
				}
			}

			/*
			SOURCE MP3
			DEST   WAV      :  MP3 -> WAV     mpg321
			DEST   FLAC     :  WAV -> FLAC    flac
			DEST   OGG      :  WAV -> OGG     oggenc
			DEST   M4A      :  WAV  -> M4A    faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (!conv.bool_stop && detail->type_infosong_file_is == FILE_IS_MP3 &&
				(
				fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Wav  > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ogg  > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_M4a  > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Aac  > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mpc  > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ape  > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_MP3 *info = (INFO_MP3 *)detail->info;

				/**/fileconv_infos (detail, fic);

				/* Copie source WAV vers dossier temporaire
				 * SI <> NULL ALORS 'detail->namefileCopie' se trouve deja dans le dossier temporaire
				*/
				if (detail->namefileCopie == NULL) {
					conv_product_name_for_label (detail->namefile);
					conv.type_conv = COPY_FILE;
					conv.bool_reset_conv = TRUE;
					conv_copy_src_to_dest (detail->namefile, fic->tmp_mp3);
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
				}

				if (!conv.bool_stop && fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST) {
					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wav);
				}
				
				if (!conv.bool_stop) {
					
					/* Changement du bitrate
					*/
					
					/* if (!conv.bool_stop && info->mpeg_is != MPEG_1) {*/
					/* if (tagswav_file_ChangeBitrate (fic->tmp_wav) == TRUE) {*/
					if (TRUE) {
						
						// PRINT("CHANGEMENT: voie + hertz + bits");
						/*conv.total_convert ++;*/
						
						conv_product_name_for_label (detail->namefile);
						conv.type_conv = MPLAYER_WAV_TO_WAV;
						conv.bool_reset_conv = TRUE;

					GDK_THREADS_ENTER();
						listmplayer = g_list_append (listmplayer, g_strdup ("nice"));
						listmplayer = g_list_append (listmplayer, g_strdup ("-n"));
						listmplayer = g_list_append (listmplayer, g_strdup (conv.valuenice));
						listmplayer = g_list_append (listmplayer, g_strdup ("mplayer"));
						listmplayer = g_list_append (listmplayer, g_strdup ("-nojoystick"));
						listmplayer = g_list_append (listmplayer, g_strdup ("-nolirc"));
						listmplayer = g_list_append (listmplayer, g_strdup (fic->tmp_mp3));
						listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
						listmplayer = g_list_append (listmplayer, g_strdup ("pcm"));
						listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
						listmplayer = g_list_append (listmplayer, g_strdup_printf ("pcm:file=%s",fic->tmp_wav));
						// listmplayer = g_list_append (listmplayer, g_strdup ("-af"));
						// listmplayer = g_list_append (listmplayer, g_strdup ("channels=2"));
						// listmplayer = g_list_append (listmplayer, g_strdup ("-srate"));
						// listmplayer = g_list_append (listmplayer, g_strdup ("44100"));
							
						conv.ArgConv = conv_alloc_arg (listmplayer);
					GDK_THREADS_LEAVE();
						BoolResultMplayerIsOk = conv_exec (param_filelc.With_CommandLineUser, MPLAYER_WAV_TO_WAV, listmplayer, "MPLAYER_WAV_TO_WAV");
					GDK_THREADS_ENTER();
						listmplayer = filelc_remove_glist (listmplayer);
						g_free (conv.ArgConv);
						conv.ArgConv = NULL;
					GDK_THREADS_LEAVE();
				
						infosong_rename_file (fic->tmp_sox, fic->tmp_wav);

						conv.type_conv = NONE_CONV;
						conv_remove_name_for_label (_CONV_);
						conv_inc_encode_completed ();
						conv.bool_percent_conv = TRUE;
						
						if (BoolResultMplayerIsOk == FALSE) {
							PRINT("PROBLEME DE CONVERSION AVEC MPLAYER:---------> RETOUR");
							break;
						}
					}
				}

				/* conversion APE */
				if (!conv.bool_stop && fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ape);

					conv_product_name_for_label (fic->dest_ape);
					conv.type_conv = MAC_WAV_TO_APE;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, list, "MAC_WAV_TO_APE");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion MPC */
				if (!conv.bool_stop && fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mpc);

					conv_product_name_for_label (fic->dest_mpc);
					conv.type_conv = MPPENC_WAV_TO_MPC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, list, "MPPENC_WAV_TO_MPC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion FLAC */
				if (!conv.bool_stop && fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_flac);

					conv_product_name_for_label (fic->dest_flac);
					conv.type_conv = FLAC_WAV_TO_FLAC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_flac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, list, "FLAC_WAV_TO_FLAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion OGG */
				if (!conv.bool_stop && fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ogg);

					conv_product_name_for_label (fic->dest_ogg);
					conv.type_conv = OGGENC_WAV_TO_OGG;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_ogg;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (OGGENC_WAV_TO_OGG, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);

				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, list, "OGGENC_WAV_TO_OGG");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion M4A */
				if (!conv.bool_stop && fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_m4a);

					conv_product_name_for_label (fic->dest_m4a);
					conv.type_conv = FAAC_WAV_TO_M4A;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = fic->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, list, "FAAC_WAV_TO_M4A");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion AAC */
				if (!conv.bool_stop && fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_aac);

					conv_product_name_for_label (fic->dest_aac);
					conv.type_conv = AACPLUSENC_WAV_TO_AAC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, list, "AACPLUSENC_WAV_TO_AAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}

				/* conversion WAVPACK */
				if (!conv.bool_stop && fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wavpack);

					conv_product_name_for_label (fic->dest_wavpack);
					conv.type_conv = WAVPACK_WAV_TO_WAVPACK;
					conv.bool_reset_conv = TRUE;
					
					fic->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv            = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser = fic->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_wavpack;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, list, "WAVPACK_WAV_TO_WAVPACK");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();

					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* copie dossier temporaire vers destination */
				if (!conv.bool_stop) {
					fileconv_copy_src_to_dest (detail, fic);
				}
			}

			/*
			SOURCE RM
			DEST   WAV      :  RM  -> WAV     mplayer ./01.rm -ao pcm -ao pcm:file=01.wav
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (!conv.bool_stop && detail->type_infosong_file_is == FILE_IS_RM &&
				(
				fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_RM *info = (INFO_RM *)detail->info;

				/**/fileconv_infos (detail, fic);

				// MPLAYER_RM_TO_WAV
				// fic->tmp_rm

				/* copie */
				conv_product_name_for_label (detail->namefile);
				conv.type_conv = COPY_FILE;
				conv.bool_reset_conv = TRUE;
				conv_copy_src_to_dest (detail->namefile, fic->tmp_rm);
				conv.type_conv = NONE_CONV;
				conv_remove_name_for_label (_CONV_);

				conv.type_conv = MPLAYER_RM_TO_WAV;
				conv.bool_reset_conv = TRUE;

				if (!conv.bool_stop && fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST) {
					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wav);
				}
				
				/* conversion WAV */
				if (!conv.bool_stop) {
					
					conv_product_name_for_label (detail->namefile);
					conv.type_conv = MPLAYER_RM_TO_WAV;
					conv.bool_reset_conv = TRUE;
					
				GDK_THREADS_ENTER();
					listmplayer = g_list_append (listmplayer, g_strdup ("nice"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-n"));
					listmplayer = g_list_append (listmplayer, g_strdup (conv.valuenice));
					listmplayer = g_list_append (listmplayer, g_strdup ("mplayer"));
					
					listmplayer = g_list_append (listmplayer, g_strdup ("-nojoystick"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-nolirc"));

					listmplayer = g_list_append (listmplayer, g_strdup (fic->tmp_rm));
					listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
					listmplayer = g_list_append (listmplayer, g_strdup ("pcm"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
					listmplayer = g_list_append (listmplayer, g_strdup_printf ("pcm:file=%s", fic->tmp_wav));
					listmplayer = g_list_append (listmplayer, g_strdup ("-af"));
					listmplayer = g_list_append (listmplayer, g_strdup ("channels=2"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-srate"));
					listmplayer = g_list_append (listmplayer, g_strdup ("44100"));
					
					conv.ArgConv = conv_alloc_arg (listmplayer);
				GDK_THREADS_LEAVE();

					BoolResultMplayerIsOk = conv_exec (param_filelc.With_CommandLineUser, MPLAYER_RM_TO_WAV, listmplayer, "MPLAYER_RM_TO_WAV");
				GDK_THREADS_ENTER();
					listmplayer = filelc_remove_glist (listmplayer);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*
					if (fileconv_test_file (fic->tmp_wav) == FALSE) {
						PRINT("---------> RETOUR");
						break;
					}
					*/
					if (BoolResultMplayerIsOk == FALSE) {
						PRINT("PROBLEME DE CONVERSION AVEC MPLAYER:---------> RETOUR");
						break;
					}
				}

				/* conversion APE */
				if (!conv.bool_stop && fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ape);

					conv_product_name_for_label (fic->dest_ape);
					conv.type_conv = MAC_WAV_TO_APE;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, list, "MAC_WAV_TO_APE");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion MPC */
				if (!conv.bool_stop && fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mpc);

					conv_product_name_for_label (fic->dest_mpc);
					conv.type_conv = MPPENC_WAV_TO_MPC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, list, "MPPENC_WAV_TO_MPC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion MP3 */
				if (!conv.bool_stop && fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mp3);

					conv_product_name_for_label (fic->dest_mp3);
					conv.type_conv = LAME_WAV_TO_MP3;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, list, "LAME_WAV_TO_MP3");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion OGG */
				if (!conv.bool_stop && fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ogg);

					conv_product_name_for_label (fic->dest_ogg);
					conv.type_conv = OGGENC_WAV_TO_OGG;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_ogg;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (OGGENC_WAV_TO_OGG, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, list, "OGGENC_WAV_TO_OGG");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion FLAC */
				if (!conv.bool_stop && fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_flac);

					conv_product_name_for_label (fic->dest_flac);
					conv.type_conv = FLAC_WAV_TO_FLAC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_flac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, list, "FLAC_WAV_TO_FLAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion M4A */
				if (!conv.bool_stop && fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_m4a);

					conv_product_name_for_label (fic->dest_m4a);
					conv.type_conv = FAAC_WAV_TO_M4A;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = fic->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, list, "FAAC_WAV_TO_M4A");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion AAC */
				if (!conv.bool_stop && fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_aac);

					conv_product_name_for_label (fic->dest_aac);
					conv.type_conv = AACPLUSENC_WAV_TO_AAC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, list, "AACPLUSENC_WAV_TO_AAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}

				/* conversion WAVPACK */
				if (!conv.bool_stop && fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wavpack);

					conv_product_name_for_label (fic->dest_wavpack);
					conv.type_conv = WAVPACK_WAV_TO_WAVPACK;
					conv.bool_reset_conv = TRUE;
					
					fic->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv            = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser = fic->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_wavpack;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, list, "WAVPACK_WAV_TO_WAVPACK");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();

					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* restitution */
				if (!conv.bool_stop) {
					fileconv_copy_src_to_dest (detail, fic);
				}
			} // END RM
			
			/*
			SOURCE DTS
			DEST   WAV      :  DTS -> WAV     mplayer ./01.dts -ao pcm -ao pcm:file=01.wav
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (!conv.bool_stop && detail->type_infosong_file_is == FILE_IS_DTS &&
				(
				fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_DTS *info = (INFO_DTS *)detail->info;

				/**/fileconv_infos (detail, fic);

				// MPLAYER_DTS_TO_WAV
				// fic->tmp_dts
				
				/* copie */
				conv_product_name_for_label (detail->namefile);
				conv.type_conv = COPY_FILE;
				conv.bool_reset_conv = TRUE;
				conv_copy_src_to_dest (detail->namefile, fic->tmp_dts);
				conv.type_conv = NONE_CONV;
				conv_remove_name_for_label (_CONV_);

				conv.type_conv = MPLAYER_DTS_TO_WAV;
				conv.bool_reset_conv = TRUE;

				if (!conv.bool_stop && fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST) {
					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wav);
				}
				
				/* conversion WAV */
				if (!conv.bool_stop) {
					
					conv_product_name_for_label (detail->namefile);
					conv.type_conv = MPLAYER_DTS_TO_WAV;
					conv.bool_reset_conv = TRUE;
					
				GDK_THREADS_ENTER();
					listmplayer = g_list_append (listmplayer, g_strdup ("nice"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-n"));
					listmplayer = g_list_append (listmplayer, g_strdup (conv.valuenice));
					listmplayer = g_list_append (listmplayer, g_strdup ("mplayer"));
					
					listmplayer = g_list_append (listmplayer, g_strdup ("-nojoystick"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-nolirc"));

					listmplayer = g_list_append (listmplayer, g_strdup (fic->tmp_dts));
					listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
					listmplayer = g_list_append (listmplayer, g_strdup ("pcm"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
					listmplayer = g_list_append (listmplayer, g_strdup_printf ("pcm:file=%s", fic->tmp_wav));
					listmplayer = g_list_append (listmplayer, g_strdup ("-af"));
					listmplayer = g_list_append (listmplayer, g_strdup ("channels=2"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-srate"));
					listmplayer = g_list_append (listmplayer, g_strdup ("44100"));
					
					conv.ArgConv = conv_alloc_arg (listmplayer);
				GDK_THREADS_LEAVE();

					BoolResultMplayerIsOk = conv_exec (param_filelc.With_CommandLineUser, MPLAYER_DTS_TO_WAV, listmplayer, "MPLAYER_DTS_TO_WAV");
				GDK_THREADS_ENTER();
					listmplayer = filelc_remove_glist (listmplayer);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*
					if (fileconv_test_file (fic->tmp_wav) == FALSE) {
						PRINT("---------> RETOUR");
						break;
					}
					*/
					if (BoolResultMplayerIsOk == FALSE) {
						PRINT("PROBLEME DE CONVERSION AVEC MPLAYER:---------> RETOUR");
						break;
					}
				}

				/* conversion APE */
				if (!conv.bool_stop && fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ape);

					conv_product_name_for_label (fic->dest_ape);
					conv.type_conv = MAC_WAV_TO_APE;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, list, "MAC_WAV_TO_APE");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion MPC */
				if (!conv.bool_stop && fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mpc);

					conv_product_name_for_label (fic->dest_mpc);
					conv.type_conv = MPPENC_WAV_TO_MPC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, list, "MPPENC_WAV_TO_MPC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion MP3 */
				if (!conv.bool_stop && fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mp3);

					conv_product_name_for_label (fic->dest_mp3);
					conv.type_conv = LAME_WAV_TO_MP3;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, list, "LAME_WAV_TO_MP3");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion OGG */
				if (!conv.bool_stop && fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ogg);

					conv_product_name_for_label (fic->dest_ogg);
					conv.type_conv = OGGENC_WAV_TO_OGG;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_ogg;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (OGGENC_WAV_TO_OGG, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, list, "OGGENC_WAV_TO_OGG");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion FLAC */
				if (!conv.bool_stop && fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_flac);

					conv_product_name_for_label (fic->dest_flac);
					conv.type_conv = FLAC_WAV_TO_FLAC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_flac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, list, "FLAC_WAV_TO_FLAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion M4A */
				if (!conv.bool_stop && fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_m4a);

					conv_product_name_for_label (fic->dest_m4a);
					conv.type_conv = FAAC_WAV_TO_M4A;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = fic->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, list, "FAAC_WAV_TO_M4A");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion AAC */
				if (!conv.bool_stop && fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_aac);

					conv_product_name_for_label (fic->dest_aac);
					conv.type_conv = AACPLUSENC_WAV_TO_AAC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, list, "AACPLUSENC_WAV_TO_AAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}

				/* conversion WAVPACK */
				if (!conv.bool_stop && fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wavpack);

					conv_product_name_for_label (fic->dest_wavpack);
					conv.type_conv = WAVPACK_WAV_TO_WAVPACK;
					conv.bool_reset_conv = TRUE;
					
					fic->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv            = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser = fic->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_wavpack;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, list, "WAVPACK_WAV_TO_WAVPACK");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();

					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* restitution */
				if (!conv.bool_stop) {
					fileconv_copy_src_to_dest (detail, fic);
				}
			} // END DTS

			/*
			SOURCE AIFF
			DEST   WAV      :  AIF -> WAV     mplayer ./01.aif -ao pcm -ao pcm:file=01.wav
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (!conv.bool_stop && detail->type_infosong_file_is == FILE_IS_AIFF &&
				(
				fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_AIFF *info = (INFO_AIFF *)detail->info;

				/**/fileconv_infos (detail, fic);

				// MPLAYER_AIFF_TO_WAV
				// fic->tmp_aiff
				
				/* copie */
				conv_product_name_for_label (detail->namefile);
				conv.type_conv = COPY_FILE;
				conv.bool_reset_conv = TRUE;
				conv_copy_src_to_dest (detail->namefile, fic->tmp_aiff);
				conv.type_conv = NONE_CONV;
				conv_remove_name_for_label (_CONV_);

				conv.type_conv = MPLAYER_AIFF_TO_WAV;
				conv.bool_reset_conv = TRUE;

				if (!conv.bool_stop && fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST) {
					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wav);
				}
				
				/* conversion WAV */
				if (!conv.bool_stop) {
					
					conv_product_name_for_label (detail->namefile);
					conv.type_conv = MPLAYER_AIFF_TO_WAV;
					conv.bool_reset_conv = TRUE;
					
				GDK_THREADS_ENTER();
					listmplayer = g_list_append (listmplayer, g_strdup ("nice"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-n"));
					listmplayer = g_list_append (listmplayer, g_strdup (conv.valuenice));
					listmplayer = g_list_append (listmplayer, g_strdup ("mplayer"));
					
					listmplayer = g_list_append (listmplayer, g_strdup ("-nojoystick"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-nolirc"));

					listmplayer = g_list_append (listmplayer, g_strdup (fic->tmp_aiff));
					listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
					listmplayer = g_list_append (listmplayer, g_strdup ("pcm"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
					listmplayer = g_list_append (listmplayer, g_strdup_printf ("pcm:file=%s", fic->tmp_wav));
					listmplayer = g_list_append (listmplayer, g_strdup ("-af"));
					listmplayer = g_list_append (listmplayer, g_strdup ("channels=2"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-srate"));
					listmplayer = g_list_append (listmplayer, g_strdup ("44100"));
					
					conv.ArgConv = conv_alloc_arg (listmplayer);
				GDK_THREADS_LEAVE();

					BoolResultMplayerIsOk = conv_exec (param_filelc.With_CommandLineUser, MPLAYER_AIFF_TO_WAV, listmplayer, "MPLAYER_AIFF_TO_WAV");
				GDK_THREADS_ENTER();
					listmplayer = filelc_remove_glist (listmplayer);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*
					if (fileconv_test_file (fic->tmp_wav) == FALSE) {
						PRINT("---------> RETOUR");
						break;
					}
					*/
					if (BoolResultMplayerIsOk == FALSE) {
						PRINT("PROBLEME DE CONVERSION AVEC MPLAYER:---------> RETOUR");
						break;
					}
				}

				/* conversion APE */
				if (!conv.bool_stop && fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ape);

					conv_product_name_for_label (fic->dest_ape);
					conv.type_conv = MAC_WAV_TO_APE;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, list, "MAC_WAV_TO_APE");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion MPC */
				if (!conv.bool_stop && fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mpc);

					conv_product_name_for_label (fic->dest_mpc);
					conv.type_conv = MPPENC_WAV_TO_MPC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, list, "MPPENC_WAV_TO_MPC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion MP3 */
				if (!conv.bool_stop && fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mp3);

					conv_product_name_for_label (fic->dest_mp3);
					conv.type_conv = LAME_WAV_TO_MP3;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, list, "LAME_WAV_TO_MP3");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion OGG */
				if (!conv.bool_stop && fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ogg);

					conv_product_name_for_label (fic->dest_ogg);
					conv.type_conv = OGGENC_WAV_TO_OGG;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_ogg;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (OGGENC_WAV_TO_OGG, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, list, "OGGENC_WAV_TO_OGG");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion FLAC */
				if (!conv.bool_stop && fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_flac);

					conv_product_name_for_label (fic->dest_flac);
					conv.type_conv = FLAC_WAV_TO_FLAC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_flac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, list, "FLAC_WAV_TO_FLAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion M4A */
				if (!conv.bool_stop && fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_m4a);

					conv_product_name_for_label (fic->dest_m4a);
					conv.type_conv = FAAC_WAV_TO_M4A;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = fic->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, list, "FAAC_WAV_TO_M4A");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion AAC */
				if (!conv.bool_stop && fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_aac);

					conv_product_name_for_label (fic->dest_aac);
					conv.type_conv = AACPLUSENC_WAV_TO_AAC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, list, "AACPLUSENC_WAV_TO_AAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}

				/* conversion WAVPACK */
				if (!conv.bool_stop && fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wavpack);

					conv_product_name_for_label (fic->dest_wavpack);
					conv.type_conv = WAVPACK_WAV_TO_WAVPACK;
					conv.bool_reset_conv = TRUE;
					
					fic->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv            = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser = fic->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_wavpack;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, list, "WAVPACK_WAV_TO_WAVPACK");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();

					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* restitution */
				if (!conv.bool_stop) {
					fileconv_copy_src_to_dest (detail, fic);
				}
			}
						
			
			/*
			SOURCE WMA
			DEST   WAV      :  WMA -> WAV     mplayer ./01.wma -ao pcm -ao pcm:file=01.wav
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (!conv.bool_stop && detail->type_infosong_file_is == FILE_IS_WMA &&
				(
				fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_WMA *info = (INFO_WMA *)detail->info;

				/**/fileconv_infos (detail, fic);

				/* copie */
				conv_product_name_for_label (detail->namefile);
				conv.type_conv = COPY_FILE;
				conv.bool_reset_conv = TRUE;
				conv_copy_src_to_dest (detail->namefile, fic->tmp_wma);
				conv.type_conv = NONE_CONV;
				conv_remove_name_for_label (_CONV_);

				conv.type_conv = MPLAYER_WMA_TO_WAV;
				conv.bool_reset_conv = TRUE;

				if (!conv.bool_stop && fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST) {
					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wav);
				}
				
				/* conversion WAV */
				if (!conv.bool_stop) {
					
					conv_product_name_for_label (detail->namefile);
					conv.type_conv = MPLAYER_WMA_TO_WAV;
					conv.bool_reset_conv = TRUE;
					
				GDK_THREADS_ENTER();
					listmplayer = g_list_append (listmplayer, g_strdup ("nice"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-n"));
					listmplayer = g_list_append (listmplayer, g_strdup (conv.valuenice));
					listmplayer = g_list_append (listmplayer, g_strdup ("mplayer"));
					
					listmplayer = g_list_append (listmplayer, g_strdup ("-nojoystick"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-nolirc"));

					listmplayer = g_list_append (listmplayer, g_strdup (fic->tmp_wma));
					listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
					listmplayer = g_list_append (listmplayer, g_strdup ("pcm"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-ao"));
					listmplayer = g_list_append (listmplayer, g_strdup_printf ("pcm:file=%s", fic->tmp_wav));
					listmplayer = g_list_append (listmplayer, g_strdup ("-af"));
					listmplayer = g_list_append (listmplayer, g_strdup ("channels=2"));
					listmplayer = g_list_append (listmplayer, g_strdup ("-srate"));
					listmplayer = g_list_append (listmplayer, g_strdup ("44100"));
					
					conv.ArgConv = conv_alloc_arg (listmplayer);
				GDK_THREADS_LEAVE();

					BoolResultMplayerIsOk = conv_exec (param_filelc.With_CommandLineUser, MPLAYER_WMA_TO_WAV, listmplayer, "MPLAYER_WMA_TO_WAV");
				GDK_THREADS_ENTER();
					listmplayer = filelc_remove_glist (listmplayer);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*
					if (fileconv_test_file (fic->tmp_wav) == FALSE) {
						PRINT("---------> RETOUR");
						break;
					}
					*/
					if (BoolResultMplayerIsOk == FALSE) {
						PRINT("PROBLEME DE CONVERSION AVEC MPLAYER:---------> RETOUR");
						break;
					}
				}

				/* conversion APE */
				if (!conv.bool_stop && fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ape);

					conv_product_name_for_label (fic->dest_ape);
					conv.type_conv = MAC_WAV_TO_APE;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, list, "MAC_WAV_TO_APE");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion MPC */
				if (!conv.bool_stop && fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mpc);

					conv_product_name_for_label (fic->dest_mpc);
					conv.type_conv = MPPENC_WAV_TO_MPC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, list, "MPPENC_WAV_TO_MPC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion MP3 */
				if (!conv.bool_stop && fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mp3);

					conv_product_name_for_label (fic->dest_mp3);
					conv.type_conv = LAME_WAV_TO_MP3;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, list, "LAME_WAV_TO_MP3");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion OGG */
				if (!conv.bool_stop && fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ogg);

					conv_product_name_for_label (fic->dest_ogg);
					conv.type_conv = OGGENC_WAV_TO_OGG;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_ogg;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (OGGENC_WAV_TO_OGG, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, list, "OGGENC_WAV_TO_OGG");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion FLAC */
				if (!conv.bool_stop && fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_flac);

					conv_product_name_for_label (fic->dest_flac);
					conv.type_conv = FLAC_WAV_TO_FLAC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_flac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, list, "FLAC_WAV_TO_FLAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion M4A */
				if (!conv.bool_stop && fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_m4a);

					conv_product_name_for_label (fic->dest_m4a);
					conv.type_conv = FAAC_WAV_TO_M4A;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = fic->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, list, "FAAC_WAV_TO_M4A");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion AAC */
				if (!conv.bool_stop && fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_aac);

					conv_product_name_for_label (fic->dest_aac);
					conv.type_conv = AACPLUSENC_WAV_TO_AAC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = AACPLUSENC_WAV_TO_AAC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Aac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_aac;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, AACPLUSENC_WAV_TO_AAC, list, "AACPLUSENC_WAV_TO_AAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}

				/* conversion WAVPACK */
				if (!conv.bool_stop && fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wavpack);

					conv_product_name_for_label (fic->dest_wavpack);
					conv.type_conv = WAVPACK_WAV_TO_WAVPACK;
					conv.bool_reset_conv = TRUE;
					
					fic->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv            = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser = fic->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_wavpack;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, list, "WAVPACK_WAV_TO_WAVPACK");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();

					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* restitution */
				if (!conv.bool_stop) {
					fileconv_copy_src_to_dest (detail, fic);
				}
			}

			/*
			SOURCE SHORTEN
			DEST   WAV      :  SHN -> WAV     shorten -x -b 256 -c 2 01.shn 01.wav
			DEST   FLAC     :  WAV -> FLAC    flac
			DEST   MP3      :  WAV -> MP3     lame
			DEST   OGG      :  WAV -> OGG     oggenc
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (!conv.bool_stop && detail->type_infosong_file_is == FILE_IS_SHN &&
				(
				fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST
				)) {

				INFO_SHN *info = (INFO_SHN *)detail->info;

				/**/fileconv_infos (detail, fic);

				/* copie source WAV vers dossier temporaire */
				conv_product_name_for_label (detail->namefile);
				conv.type_conv = COPY_FILE;
				conv.bool_reset_conv = TRUE;
				conv_copy_src_to_dest (detail->namefile, fic->tmp_shn);
				conv.type_conv = NONE_CONV;
				conv_remove_name_for_label (_CONV_);

				if (!conv.bool_stop && fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST) {
					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wav);
				}
				
				/* conversion WAV */
				if (!conv.bool_stop) {

					conv_product_name_for_label (fic->dest_wav);
					conv.type_conv = SHORTEN_SHN_TO_WAV;
					conv.bool_reset_conv = TRUE;
					
				GDK_THREADS_ENTER();
					list = g_list_append (list, g_strdup ("nice"));
					list = g_list_append (list, g_strdup ("-n"));
					list = g_list_append (list, g_strdup_printf ("%d", options_get_val_nice ()));
					list = g_list_append (list, g_strdup ("shorten"));
					list = g_list_append (list, g_strdup ("-x"));
					list = g_list_append (list, g_strdup ("-b"));
					list = g_list_append (list, g_strdup ("256"));
					list = g_list_append (list, g_strdup ("-c"));
					list = g_list_append (list, g_strdup ("2"));
					list = g_list_append (list, g_strdup_printf ("%s", fic->tmp_shn));
					list = g_list_append (list, g_strdup_printf ("%s", fic->tmp_wav));
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();

					conv_exec (param_filelc.With_CommandLineUser, SHORTEN_SHN_TO_WAV, list, "SHORTEN_SHN_TO_WAV");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
				}

				/* conversion APE */
				if (!conv.bool_stop && fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ape);

					conv_product_name_for_label (fic->dest_ape);
					conv.type_conv = MAC_WAV_TO_APE;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MAC_WAV_TO_APE;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Ape >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_ape;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MAC_WAV_TO_APE, list, "MAC_WAV_TO_APE");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion MPC */
				if (!conv.bool_stop && fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mpc);

					conv_product_name_for_label (fic->dest_mpc);
					conv.type_conv = MPPENC_WAV_TO_MPC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = MPPENC_WAV_TO_MPC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mpc >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_mpc;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, MPPENC_WAV_TO_MPC, list, "MPPENC_WAV_TO_MPC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion FLAC */
				if (!conv.bool_stop && fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_flac);

					conv_product_name_for_label (fic->dest_flac);
					conv.type_conv = FLAC_WAV_TO_FLAC;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = FLAC_WAV_TO_FLAC;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Flac >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_flac;
					param_filelc.tags                 = NULL;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FLAC_WAV_TO_FLAC, list, "FLAC_WAV_TO_FLAC");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion MP3 */
				if (!conv.bool_stop && fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_mp3);

					conv_product_name_for_label (fic->dest_mp3);
					conv.type_conv = LAME_WAV_TO_MP3;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = LAME_WAV_TO_MP3;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Mp3 >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_mp3;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (LAME_WAV_TO_MP3, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, LAME_WAV_TO_MP3, list, "LAME_WAV_TO_MP3");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion OGG */
				if (!conv.bool_stop && fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_ogg);

					conv_product_name_for_label (fic->dest_ogg);
					conv.type_conv = OGGENC_WAV_TO_OGG;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = OGGENC_WAV_TO_OGG;
					param_filelc.With_CommandLineUser = fic->EtatSelection_Ogg >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_ogg;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
					param_filelc.BoolSetBitrate       = FALSE;
					param_filelc.PtrStrBitrate        = options_get_params (OGGENC_WAV_TO_OGG, param_filelc, (FIC_MP3OGG *)detail->fic_mp3ogg);
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, OGGENC_WAV_TO_OGG, list, "OGGENC_WAV_TO_OGG");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion AAC */
				if (!conv.bool_stop && fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_m4a);

					conv_product_name_for_label (fic->dest_m4a);
					conv.type_conv = FAAC_WAV_TO_M4A;
					conv.bool_reset_conv = TRUE;
						
					param_filelc.type_conv            = FAAC_WAV_TO_M4A;
					param_filelc.With_CommandLineUser = fic->EtatSelection_M4a >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_m4a;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, FAAC_WAV_TO_M4A, list, "FAAC_WAV_TO_M4A");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* conversion WAVPACK */
				if (!conv.bool_stop && fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {

					logs_write_datas ("\t");
					logs_writeln_datas (fic->dest_wavpack);

					conv_product_name_for_label (fic->dest_wavpack);
					conv.type_conv = WAVPACK_WAV_TO_WAVPACK;
					conv.bool_reset_conv = TRUE;
					
					fic->BoolEtatConv [ ETAT_BOOL_WAVPACK ] = TRUE;
						
					param_filelc.type_conv            = WAVPACK_WAV_TO_WAVPACK;
					param_filelc.With_CommandLineUser = fic->EtatSelection_WavPack >= ETAT_SELECT_EXPERT;
					param_filelc.filesrc              = fic->tmp_wav;
					param_filelc.filedest             = fic->tmp_wavpack;
					param_filelc.tags                 = info->tags;
					param_filelc.cdrom                = NULL;
					param_filelc.num_track            = NULL;
						
				GDK_THREADS_ENTER();
					list = filelc_get_command_line (&param_filelc);
					conv.ArgConv = conv_alloc_arg (list);
				GDK_THREADS_LEAVE();
					conv_exec (param_filelc.With_CommandLineUser, WAVPACK_WAV_TO_WAVPACK, list, "WAVPACK_WAV_TO_WAVPACK");
				GDK_THREADS_ENTER();
					list = filelc_remove_glist (list);
					g_free (conv.ArgConv);
					conv.ArgConv = NULL;
				GDK_THREADS_LEAVE();

					if (*optionsWavpack_get_wavpack_signature_md5 () != '\0') {
						conv.bool_set_log_wavpack = TRUE;
					}
					
					conv.type_conv = NONE_CONV;
					conv_remove_name_for_label (_CONV_);
					conv_inc_encode_completed ();
					
					/*conv.Bool_MAJ_select = TRUE;*/
				}

				/* copie dossier temporaire vers destination */
				if (!conv.bool_stop) {
					fileconv_copy_src_to_dest (detail, fic);
				}
			}

			infosong_delete_file (fic->tmp_flac);
			infosong_delete_file (fic->tmp_wav);
			infosong_delete_file (fic->tmp_sox);
			infosong_delete_file (fic->tmp_sox_24);
			infosong_delete_file (fic->tmp_mp3);
			infosong_delete_file (fic->tmp_ogg);
			infosong_delete_file (fic->tmp_m4a);
			infosong_delete_file (fic->tmp_aac);
			infosong_delete_file (fic->tmp_shn);
			infosong_delete_file (fic->tmp_wma);
			infosong_delete_file (fic->tmp_rm);
			infosong_delete_file (fic->tmp_dts);
			infosong_delete_file (fic->tmp_mpc);
			infosong_delete_file (fic->tmp_ape);
			infosong_delete_file (fic->tmp_wavpack);
			infosong_delete_file (fic->tmp_wavpack_md5);

			name_codetable = g_strdup_printf ("%s0123456789012345678901234567890", fic->dest_mpc);
			if ((ptr = strrchr (name_codetable, '/'))) {
				ptr ++;
				strcpy (ptr, "codetable_codes.cc");
				if (infosong_file_is_reg (name_codetable)) {
					infosong_delete_file (name_codetable);
				}
			}
			g_free (name_codetable);
			name_codetable = NULL;
			ptr = NULL;
			
		}
		}
		if (conv.bool_stop == TRUE)
			break;
		else	ListGlobal = g_list_next(ListGlobal);
	}
	close(conv.tube_conv [ 0 ]);
	conv.bool_thread_conv = FALSE;
	secu_thread_sub ();
	PRINT("FIN THREAD");
	pthread_exit(0);
}

/* Cette fonction est activee avec 'gtk_timeout_add ()' et gere les retours
*  des threads d'extraction et de conversion puis se desactive grace au flag
*  'bool_thread_conv_Conversion_file' lorsqu'il est a FALSE
*  --
*  entree :
*      gpointer data :
*  retour :
*      TRUE : Lorsque l'action du timeout est terminee
*/
gint static fileconv_call_update_file_to_file (gpointer data)
{

	if (conv.bool_thread_conv == FALSE && conv.bool_reset_conv  == FALSE && conv.bool_percent_conv == FALSE) {
		DETAIL		*detail = NULL;
		FIC		*fic = NULL;
		GList		*list = NULL;
		
		fileaction_set_end ();
		gtk_timeout_remove (conv.handler_timeout_conv);
		conv_close_window ();
		
		fileanalyze_update_info ();
		
		/* Delete alloc name files of conversion
		*/
		list = g_list_first (entetefile);
		while (list) {
			if ((detail = (DETAIL *)list->data)) {
				if ((fic = (FIC *)detail->fic)) {
					
					g_free (detail->namefileCopie);		detail->namefileCopie = NULL;
					
					g_free (fic->dest_flac);		fic->dest_flac = NULL;
					g_free (fic->dest_wav);			fic->dest_wav = NULL;
					g_free (fic->dest_mp3);			fic->dest_mp3 = NULL;
					g_free (fic->dest_ogg);			fic->dest_ogg = NULL;
					g_free (fic->dest_m4a);			fic->dest_m4a = NULL;
					g_free (fic->dest_aac);			fic->dest_aac = NULL;
					g_free (fic->dest_mpc);			fic->dest_mpc = NULL;
					g_free (fic->dest_ape);			fic->dest_ape = NULL;
					g_free (fic->dest_wavpack);		fic->dest_wavpack = NULL;
					g_free (fic->dest_wavpack_md5);		fic->dest_wavpack_md5 = NULL;
					g_free (fic->tmp_flac);			fic->tmp_flac = NULL;
					g_free (fic->tmp_wav);			fic->tmp_wav = NULL;
					g_free (fic->tmp_mp3);			fic->tmp_mp3 = NULL;
					g_free (fic->tmp_ogg);			fic->tmp_ogg = NULL;
					g_free (fic->tmp_m4a);			fic->tmp_m4a = NULL;
					g_free (fic->tmp_aac);			fic->tmp_aac = NULL;
					g_free (fic->tmp_shn);			fic->tmp_shn = NULL;
					g_free (fic->tmp_wma);			fic->tmp_wma = NULL;
					g_free (fic->tmp_rm);			fic->tmp_rm = NULL;
					g_free (fic->tmp_dts);			fic->tmp_dts = NULL;
					g_free (fic->tmp_mpc);			fic->tmp_mpc = NULL;
					g_free (fic->tmp_ape);			fic->tmp_ape = NULL;
					g_free (fic->tmp_wavpack);		fic->tmp_wavpack = NULL;
					g_free (fic->tmp_wavpack_md5);		fic->tmp_wavpack_md5 = NULL;
					g_free (fic->tmp_sox);			fic->tmp_sox = NULL;
					g_free (fic->tmp_sox_24);		fic->tmp_sox_24 = NULL;
				}
			}
			list = g_list_next(list);
		}

		/* Delete temporary rep */
		if (conv.TmpRep)  {
			conv.TmpRep  = utils_remove_temporary_rep (conv.TmpRep);
		}

		conv_remove_name_for_label (_CONV_);

		utils_puts_statusbar_global (" ");

		file_pixbuf_update_glist_file ();
		
		if (conv.bool_set_log_wavpack == TRUE || conv.bool_set_log_wvunpack == TRUE) {
			conv.bool_set_log_wvunpack = FALSE;
			conv.bool_set_log_wavpack = FALSE;
		}

		if (conv.bool_stop == TRUE) {
			/*  ANALYSE PRESENCE FICHIERS DANS LES ONGLETS
			 *   - ANALYSE-WAV
			 *   - ANALYSE MP3-OGG
			 */
		}
		conv_set_struct_not_used ();
		PRINT("FIN TIMEOUT FILECONV");

		// g_print("conv.total_convert    = %d\n", conv.total_convert);
		// g_print("conv.rip_completed    = %d\n", conv.rip_completed);
		// g_print("conv.encode_completed = %d\n", conv.encode_completed);
		// g_print("conv.total_rip        = %d\n", conv.total_rip);

		NotifySend_msg (_("XCFA: Conversions fichiers"), _("Ok"));
	}
	else {
		if (conv.bool_reset_conv) {
			conv_activate_progressBar (conv.Adr_progressbar_conversion);
			conv_set_label_conversion ();
			conv_set_label_total (_CONV_);
			conv.bool_reset_conv = FALSE;
		}

		if (conv.bool_percent_conv) {
			conv_set_data_progressBar (conv.Adr_progressbar_conversion, conv.conversion_percent);
			conv_set_data_progressBar (conv.Adr_progressbar_total, conv.total_percent);
			conv.bool_percent_conv = FALSE;
		}
		
		if (conv.Bool_MAJ_select == TRUE) {
			conv.Bool_MAJ_select = FALSE;
			file_pixbuf_update_glist_file ();
		}

	}
	return (TRUE);
}

/* Initialisation des variables avant l'activation des threads d'extraction et de conversion
*  --
*  entree : -
*  retour : -
*/
void fileconv_set_flags_before_conversion_file (void)
{
	GList   *list = NULL;
	DETAIL  *detail = NULL;
	FIC     *fic = NULL;
	gint	 CptEtat;
	
	/*PRINT_FUNC_LF();*/

	/* recup du niveau de gentillesse */
	g_snprintf (conv.valuenice ,    4, "%d", options_get_val_nice ());

	/* g_snprintf (conv.bitratelame,   4, "%d", options_get_val_bitrate_lame ()); */
	/*strcpy (conv.bitratelame, options_get_str_val_bitrate_lame ());*/
	/*strcpy (conv.bitratelame, optionsLame_get_str_val_bitrate_abr_vbr_lame ());*/
	/*strcpy (conv.modelame, optionsLame_get_str_val_mode_lame ());*/

	/*g_snprintf (conv.bitrateoggenc, 4, "%d", optionsOggenc_get_val_bitrate_oggenc ());*/
	/*strcpy (conv.bitrateoggenc, optionsOggenc_get_val_bitrate_oggenc ());*/

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
		if ((fic = (FIC *)detail->fic)) {
			if (fic->EtatSelection_Wav <= ETAT_ATTENTE_EXIST &&
			    fic->EtatSelection_Mp3 <= ETAT_ATTENTE_EXIST &&
			    fic->EtatSelection_Ogg <= ETAT_ATTENTE_EXIST &&
			    fic->EtatSelection_Flac <= ETAT_ATTENTE_EXIST &&
			    fic->EtatSelection_M4a <= ETAT_ATTENTE_EXIST &&
			    fic->EtatSelection_Aac <= ETAT_ATTENTE_EXIST &&
			    fic->EtatSelection_Mpc <= ETAT_ATTENTE_EXIST &&
			    fic->EtatSelection_Ape <= ETAT_ATTENTE_EXIST &&
			    fic->EtatSelection_WavPack <= ETAT_ATTENTE_EXIST) {
				list = g_list_next(list);
				continue;
			}
			
			detail->modif = TRUE;

			/* Create temporary rep */
			if (!conv.TmpRep)  {
				conv.TmpRep  = utils_create_temporary_rep (PATH_TMP_XCFA_AUDIOFILE);
			}

			// INIT ETAT
			for (CptEtat = 0; CptEtat < ETAT_BOOL_TOTAL; CptEtat ++) {
				fic->BoolEtatConv [ CptEtat ] = FALSE;
			}
			
			/* preparation des pathnames de destinations */
			if (fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
			    fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
			    fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
			    fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
			    fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
			    fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
			    fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
			    fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
			    fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {

				fic->dest_flac        = file_make_pathname_file (detail, FILE_IS_FLAC);
				fic->dest_wav         = file_make_pathname_file (detail, FILE_IS_WAV);
				fic->dest_mp3         = file_make_pathname_file (detail, FILE_IS_MP3);
				fic->dest_ogg         = file_make_pathname_file (detail, FILE_IS_OGG);
				fic->dest_m4a         = file_make_pathname_file (detail, FILE_IS_M4A);
				fic->dest_aac         = file_make_pathname_file (detail, FILE_IS_AAC);
				fic->dest_mpc         = file_make_pathname_file (detail, FILE_IS_MPC);
				fic->dest_ape         = file_make_pathname_file (detail, FILE_IS_APE);
				fic->dest_wavpack     = file_make_pathname_file (detail, FILE_IS_WAVPACK);
				fic->dest_wavpack_md5 = file_make_pathname_file (detail, FILE_IS_WAVPACK_MD5);
			}

			/* preparation des pathnames temporaires */
			if (fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
			    fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
			    fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
			    fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
			    fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
			    fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
			    fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
			    fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
			    fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) {
								
				fic->tmp_flac         = g_strdup_printf ("%s/tmp.flac",    conv.TmpRep);
				
				if (detail->namefileCopie != NULL)
					fic->tmp_wav          = g_strdup (detail->namefileCopie);
				else	fic->tmp_wav          = g_strdup_printf ("%s/tmp.wav", conv.TmpRep);
				
				fic->tmp_sox                  = g_strdup_printf ("%s/tmp_sox.wav", conv.TmpRep);
				fic->tmp_sox_24               = g_strdup_printf ("%s/tmp_sox_24.wav", conv.TmpRep);
				fic->tmp_mp3                  = g_strdup_printf ("%s/tmp.mp3",     conv.TmpRep);
				fic->tmp_ogg                  = g_strdup_printf ("%s/tmp.ogg",     conv.TmpRep);
				fic->tmp_m4a                  = g_strdup_printf ("%s/tmp.m4a",     conv.TmpRep);
				fic->tmp_aac                  = g_strdup_printf ("%s/tmp.aac",     conv.TmpRep);
				fic->tmp_shn                  = g_strdup_printf ("%s/tmp.shn",     conv.TmpRep);
				fic->tmp_wma                  = g_strdup_printf ("%s/tmp.wma",     conv.TmpRep);
				fic->tmp_rm                   = g_strdup_printf ("%s/tmp.rm",      conv.TmpRep);
				fic->tmp_dts                  = g_strdup_printf ("%s/tmp.dts",     conv.TmpRep);
				fic->tmp_aiff                 = g_strdup_printf ("%s/tmp.aiff",    conv.TmpRep);
				fic->tmp_mpc                  = g_strdup_printf ("%s/tmp.mpc",     conv.TmpRep);
				fic->tmp_ape                  = g_strdup_printf ("%s/tmp.ape",     conv.TmpRep);
				fic->tmp_wavpack              = g_strdup_printf ("%s/tmp.wv",      conv.TmpRep);
				fic->tmp_wavpack_md5          = g_strdup_printf ("%s/tmp.wvc",     conv.TmpRep);	
			}

			/*
			SOURCE WAVPACK
			DEST   WAV      :  WAVPACK -> WAV wvunpack
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   AAC	:  WAV -> M4A     aacplusenc
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			*/
			if (detail->type_infosong_file_is == FILE_IS_WAVPACK) {

				/*if (file_get_type_normalise (NULL) < 2) conv.total_convert ++;*/

				if (fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST) conv.total_convert += 3;

				if (fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST) conv.total_convert ++;
				if (fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST) conv.total_convert ++;
				if (fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST)conv.total_convert ++;
				if (fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST) conv.total_convert ++;
				if (fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST) conv.total_convert ++;
				if (fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST) conv.total_convert ++;
				if (fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}

			/*
			SOURCE APE
			DEST   WAV      :  APE -> WAV     mac
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   AAC	:  WAV -> M4A     aacplusenc
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_APE) {

				/*if (file_get_type_normalise (NULL) < 2) conv.total_convert ++;*/

				if (fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert += 3;

				if (fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST)    conv.total_convert ++;
				if (fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}

			/*
			SOURCE MPC
			DEST   WAV      :  MPC -> WAV     mppdec
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   AAC	:  WAV -> M4A     aacplusenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_MPC) {

				/*if (file_get_type_normalise (NULL) < 2) conv.total_convert ++;*/

				if (fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert += 3;

				if (fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST)    conv.total_convert ++;
				if (fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}

			/*
			SOURCE M4A
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   WAV      :  M4A -> WAV     faad
			DEST   MP3      :  WAV -> MP3     lame
			DEST   FLAC     :  WAV -> FLAC    flac
			DEST   OGG      :  WAV -> OGG     oggenc
			DEST   AAC	:  WAV -> M4A     aacplusenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_M4A) {

				/*if (file_get_type_normalise (NULL) < 2) conv.total_convert ++;*/

				if (fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert += 4;
				
				if (fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST)    conv.total_convert ++;
				if (fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}

			/*
			SOURCE SHORTEN
			DEST   WAV      :  SHN -> WAV     shorten -x -b 256 -c 2 01.shn 01.wav
			DEST   FLAC     :  WAV -> FLAC    flac
			DEST   MP3      :  WAV -> MP3     lame
			DEST   OGG      :  WAV -> OGG     oggenc
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_SHN) {

				/*if (file_get_type_normalise (NULL) < 2) conv.total_convert ++;*/

				if (fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert += 3;
				
				if (fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST)    conv.total_convert ++;
				if (fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}

			/*
			SOURCE FLAC
			DEST   OGG      :  FLAC -> OGG    oggenc
			DEST   WAV      :  FLAC -> WAV    flac
			DEST   MP3      :  WAV  -> MP3    lame
			DEST   M4A      :  WAV  -> M4A    faac
			DEST   AAC	:  WAV -> M4A     aacplusenc
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_FLAC) {

				if (fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert += 3;
				
				if (fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}

			/*
			SOURCE WAV
			DEST   FLAC     :  WAV -> FLAC    flac
			DEST   MP3      :  WAV -> MP3     lame
			DEST   OGG      :  WAV -> OGG     oggenc
			DEST   M4A      :  WAV -> M4A     faac
			DEST   AAC	:  WAV -> M4A     aacplusenc
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_WAV) {
				
				// INFO_WAV *info = (INFO_WAV *)detail->info;
				gint		 Channels;
				gint		 Hertz;
				gint		 Bits;

				if (fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST)    conv.total_convert += 2;
				if (fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST)     conv.total_convert += 2;
				if (fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
				if (fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)     conv.total_convert += 4;
				if (fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST)     conv.total_convert += 4;
				if (fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST)     conv.total_convert += 6;
				if (fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)     conv.total_convert += 6;
				if (fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)     conv.total_convert += 2;
				
				// COPY TO TMP
				conv.total_convert += 2;
				
				tagswav_file_ChangeBitrate (detail->namefile, &Channels, &Hertz, &Bits);
				
				// TODO: conv.total_convert DOIT ETRE FIXE A SON MAXIMUM ET DOIT REGRESSER EN FONCTION DES ACTIONS DEPUIS LE THREAD
				// 
				
				fic->BoolEtatConv [ ETAT_FROM_WAV_TO_FLAC ] = 
					fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST &&
					(Bits != 24 && Bits != 16 && Bits != 8);
				
				fic->BoolEtatConv [ ETAT_FROM_WAV_TO_APE ] = 
					fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST &&
					(Bits != 16 && Bits != 8);
				
				fic->BoolEtatConv [ ETAT_FROM_WAV_TO_OGG ] = 
					fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST &&
					(Bits != 24 && Bits != 16 && Bits != 8);				
												
				fic->BoolEtatConv [ ETAT_FROM_WAV_TO_M4A ] = 
					fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST &&
					(Bits != 64 && Bits != 32 && Bits != 24 && Bits != 16 && Bits != 8);
				
				fic->BoolEtatConv [ ETAT_FROM_WAV_TO_AAC ] = 
					fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST &&
					(Bits != 64 && Bits != 32 && Bits != 24 && Bits != 16 && Bits != 8);

				fic->BoolEtatConv [ ETAT_FROM_WAV_TO_MPC ] = 
					fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST &&
					(Bits != 64 && Bits != 32 && Bits != 24 && Bits != 16 && Bits != 8);
								
				fic->BoolEtatConv [ ETAT_FROM_WAV_TO_MP3 ] = 
					(fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST &&
					 Hertz == 48000 && Bits == 32) || Bits < 8;
			}
			

			/*
			SOURCE MP3
			DEST   WAV      :  MP3 -> WAV     mpg321
			DEST   FLAC     :  WAV -> FLAC    flac
			DEST   OGG      :  WAV -> OGG     oggenc
			DEST   M4A      :  WAV  -> M4A    faac
			DEST   AAC	:  WAV -> M4A     aacplusenc
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_MP3) {
				
				if (fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert += 4;
				
				if (fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST)    conv.total_convert ++;
				if (fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}

			/*
			SOURCE OGG
			DEST   WAV      :  OGG -> WAV     ogg123
			DEST   FLAC     :  WAV -> FLAC    flac
			DEST   MP3      :  WAV -> MP3     lame
			DEST   M4A      :  WAV -> M4A     faac
			DEST   AAC	:  WAV -> M4A     aacplusenc
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_OGG) {

				/*if (file_get_type_normalise (NULL) < 2) conv.total_convert ++;*/

				if (fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert += 4;
				
				if (fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST)    conv.total_convert ++;
				if (fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}

			/*
			SOURCE WMA
			DEST   WAV      :  WMA -> WAV     mplayer ./01.wma -ao pcm -ao pcm:file=01.wav
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_WMA) {

				/*if (file_get_type_normalise (NULL) < 2) conv.total_convert ++;*/

				if (fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert += 3;
				
				if (fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST)    conv.total_convert ++;
				if (fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}

			/*
			SOURCE RM
			DEST   WAV      :  WMA -> WAV     mplayer ./01.rm -ao pcm -ao pcm:file=01.wav
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_RM) {

				if (fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert += 3;
				
				if (fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST)    conv.total_convert ++;
				if (fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}

			/*
			SOURCE DTS
			DEST   WAV      :  DTS -> WAV     mplayer ./01.dts -ao pcm -ao pcm:file=01.wav
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_DTS) {

				if (fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert += 3;
				
				if (fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST)    conv.total_convert ++;
				if (fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}

			/*
			SOURCE AIFF
			DEST   WAV      :  AIF -> WAV     mplayer ./01.aif -ao pcm -ao pcm:file=01.wav
			DEST   MP3      :  WAV -> MP3     lame file.wav file.mp3
			DEST   OGG      :  WAV -> OGG     oggenc file.wav file.ogg
			DEST   FLAC     :  WAV -> FLAC    flac -f file.wav -o file.flac
			DEST   M4A      :  WAV -> M4A     faac
			DEST   MPC      :  WAV -> MPC     mppenc
			DEST   APE      :  WAV -> APE     mac
			DEST   WAVPACK  :  WAV -> WAVPACK wavpack
			*/
			if (detail->type_infosong_file_is == FILE_IS_AIFF) {

				if (fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Wav > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST ||
				    fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert += 3;
				
				if (fic->EtatSelection_Mp3 > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Ogg > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Flac > ETAT_ATTENTE_EXIST)    conv.total_convert ++;
				if (fic->EtatSelection_M4a > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Aac > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Mpc > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_Ape > ETAT_ATTENTE_EXIST)     conv.total_convert ++;
				if (fic->EtatSelection_WavPack > ETAT_ATTENTE_EXIST) conv.total_convert ++;
			}

		}
		}
		list = g_list_next(list);
	}

	// g_print("conv.total_convert    = %d\n", conv.total_convert);
	// g_print("conv.rip_completed    = %d\n", conv.rip_completed);
	// g_print("conv.encode_completed = %d\n", conv.encode_completed);
	// g_print("conv.total_rip        = %d\n", conv.total_rip);
}

void fileconv_set_flags_before_conversion_file_replaygain (void)
{
	GList   *list = NULL;
	DETAIL  *detail = NULL;
	FIC     *fic = NULL;

	PRINT_FUNC_LF();
	/*
	fic->Etat_ReplayGain != RPG_ATTENTE
	
	*/

	list = g_list_first (entetefile);
	while (list) {
		if ((detail = (DETAIL *)list->data)) {
			if ((fic = (FIC *)detail->fic)) {
				if (fic->Etat_ReplayGain != RPG_ATTENTE) {
					PRINT("fic->Etat_ReplayGain != RPG_ATTENTE");
				}
			}
		}
		list = g_list_next(list);
	}
}

/* Cette fonction activee les threads d'extraction et de conversion
*  --
*  entree : -
*  retour : -
*/
void fileconv_conversion_file_to_file_action (void)
{
	pthread_t  nmr_tid;

	/*PRINT_FUNC_LF();*/

	conv_reset_struct ();
	/* Prepare la liste */
	fileconv_set_flags_before_conversion_file ();
	/* fenetre de conversions */
	conv_create_window (_("Conversions"));
	/**/
	conv_activate_progressBar (conv.Adr_progressbar_conversion);
	conv_activate_progressBar (conv.Adr_progressbar_total);
	conv.bool_thread_conv = TRUE;
	secu_thread_add ();
 	pthread_create (&nmr_tid, NULL ,(void *)fileconv_do_conversion_file_to_file, (void *)NULL);
	PRINT("DEBUT TIMEOUT FILECONV");
	conv.handler_timeout_conv = gtk_timeout_add (150, fileconv_call_update_file_to_file, 0);
}


