 /*
 * file      : cd_audio.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>
#include <gdk/gdkkeysyms.h>
#include <string.h>
#include <pthread.h>
#include <stdlib.h>

#include "global.h"
#include "file.h"
#include "options.h"
#include "cd_audio_extract.h"
#include "fileselect.h"
#include "prg_init.h"
#include "config_user.h"
#include "scan_cd.h"
#include "cdtoc.h"
#include "secu.h"
#include "info_song.h"
#include "file.h"
#include "utils.h"
#include "popup.h"
#include "cd_audio.h"
#include "mplayer.h"
#include "win_info.h"
#include "win_play.h"
#include "parse.h"


/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/


enum
{
	NUM_TREE_Play = 0,
	NUM_TREE_Wav,
	NUM_TREE_Flac,
	NUM_TREE_Ape,
	NUM_TREE_WavP,
	NUM_TREE_Ogg,
	NUM_TREE_M4a,
	NUM_TREE_Aac,
	NUM_TREE_Mpc,
	NUM_TREE_Mp3,
	NUM_TREE_Num,
	NUM_TREE_Time,
	NUM_TREE_Normalise,
	NUM_TREE_Nom,
	NUM_TREE_ALL_COLUMN
};



enum
{
	CD_COLUMN_PLAY = 0,
	
	CD_COLUMN_WAV,
	CD_COLUMN_FLAC,
	CD_COLUMN_APE,
	CD_COLUMN_WAVPACK,
	CD_COLUMN_OGG,
	CD_COLUMN_M4A,
	CD_COLUMN_AAC,
	CD_COLUMN_MPC,
	CD_COLUMN_MP3,
	
	CD_COLUMN_TRACK_NUM,
	CD_COLUMN_TRACK_TIME,
	
	CD_COLUMN_FILE_NORMALIZE,
	
	CD_COLUMN_TRACK_NAME,
	CF_COLUMN_EDITABLE,
	CD_NUM_COLUMNS
};


typedef struct
{
	GdkPixbuf    *PlayTrack;
	GdkPixbuf    *Flac;
	GdkPixbuf    *Wav;
	GdkPixbuf    *Mp3;
	GdkPixbuf    *Ogg;
	GdkPixbuf    *M4a;
	GdkPixbuf    *Aac;
	GdkPixbuf    *Mpc;
	GdkPixbuf    *Ape;
	GdkPixbuf    *WavPack;
	gchar        *Track_Num;
	gchar        *Track_Time;
	GdkPixbuf    *ColumnCDNormalize;
	gchar        *Track_Name;
	gboolean      Editable;

} ARTICLES_CD;

GArray     *Articles_cd = NULL;			/*  */
VAR_CD      var_cd;				/*  */
ENTETE_CD   EnteteCD;				/*  */

gboolean BoolPathCaractersStrip = FALSE;


/*
*---------------------------------------------------------------------------
* ONGLET CD-AUDIO -> ACTION
*---------------------------------------------------------------------------
*/
void cdaudio_apply_result_destination (gchar *path)
{
	/*PRINT_FUNC_LF();*/

	if (options_verif_dossier_is_ok (path) == TRUE) {
		if (utils_test_write (path) == TRUE) {
			g_free (Config_User.Path_Destination_CD);
			Config_User.Path_Destination_CD = g_strdup (path);
			gtk_button_set_label (GTK_BUTTON (var_cd.Adr_Button_Destination), Config_User.Path_Destination_CD);

			cdaudio_update_glist_audio_cd ();
			cdaudio_entry_stockage_cdaudio_changed ();
		}
	}
}
void cdaudio_button_destination_cd_clicked (void)
{
	fileselect_create (_PATH_DESTINATION_CD_, cdaudio_apply_result_destination);
}

gboolean cdaudio_bool_from_to (TYPE_FILE_IS p_to, gboolean is_mess)
{
	gboolean bool_is = FALSE;
	
	if (p_to == FILE_IS_FLAC) {
		if ((bool_is = PrgInit.bool_flac) == FALSE) {
			if (is_mess)
				utils_set_prg_not_found ("FLAC", PrgInit.bool_flac);
		}
	}
	else if (p_to == FILE_IS_WAV) {
		if (options_extract_by () == EXTRACT_WITH_CDDA2WAV) {
			if ((bool_is = PrgInit.bool_cdda2wav) == FALSE) {
				if (is_mess)
					utils_set_prg_not_found ("CDDA2WAV", PrgInit.bool_cdda2wav);
			}
		}
		else {
			if ((bool_is = PrgInit.bool_cdparanoia) == FALSE) {
				if (is_mess)
					utils_set_prg_not_found ("CDPARANOIA", PrgInit.bool_cdparanoia);
			}
		}
	}
	else if (p_to == FILE_IS_MP3) {
		if ((bool_is = PrgInit.bool_lame) == FALSE) {
			if (is_mess)
				utils_set_prg_not_found ("LAME", PrgInit.bool_lame);
		}
	}
	else if (p_to == FILE_IS_OGG) {
		if ((bool_is = PrgInit.bool_oggenc) == FALSE) {
			if (is_mess)
				utils_set_prg_not_found ("OGGENC", PrgInit.bool_oggenc);
		}
	}
	else if (p_to == FILE_IS_M4A) {
		if ((bool_is = PrgInit.bool_faac) == FALSE) {
			if (is_mess)
				utils_set_prg_not_found ("FAAC", PrgInit.bool_faac);
		}
	}
	else if (p_to == FILE_IS_AAC) {
		if ((bool_is = PrgInit.bool_aacplusenc) == FALSE) {
			if (is_mess)
				utils_set_prg_not_found ("AACPLUSENC", PrgInit.bool_aacplusenc);
		}
	}
	else if (p_to == FILE_IS_MPC) {
		if ((bool_is = PrgInit.bool_mppenc) == FALSE) {
			if (is_mess)
				utils_set_prg_not_found ("MPPENC", PrgInit.bool_mppenc);
		}
	}
	else if (p_to == FILE_IS_APE) {
		if ((bool_is = PrgInit.bool_ape) == FALSE) {
			if (is_mess)
				utils_set_prg_not_found ("APE", PrgInit.bool_ape);
		}
	}
	else if (p_to == FILE_IS_WAVPACK) {
		if ((bool_is = PrgInit.bool_wavpack) == FALSE) {
			if (is_mess)
				utils_set_prg_not_found ("WAVPACK", PrgInit.bool_wavpack);
		}
	}
	else if (p_to == FILE_TO_NORMALISE) {
		if ((bool_is = PrgInit.bool_normalize) == FALSE) {
			if (is_mess)
				utils_set_prg_not_found ("NORMALISE", PrgInit.bool_normalize);
		}
	}
	
	return (bool_is);
}


/*
*---------------------------------------------------------------------------
* ONGLET CD-AUDIO -> REALIZATE
*---------------------------------------------------------------------------
*/
gboolean cdaudio_file_exist (AUDIO *Audio, TYPE_FILE_IS TypeFileIs)
{
	gchar    *PathDest = NULL;
	gchar    *PathNameDest = NULL;
	gboolean  BoolExist = FALSE;
	
	if (Audio != NULL) {
		PathDest = cdaudio_get_result_destination (NULL);

		if (TypeFileIs == FILE_IS_FLAC)
			PathNameDest = g_strdup_printf ("%s/%s.flac", PathDest, Audio->NameSong);
		else if (TypeFileIs == FILE_IS_WAV)
			PathNameDest = g_strdup_printf ("%s/%s.wav",  PathDest, Audio->NameSong);
		else if (TypeFileIs == FILE_IS_MP3)
			PathNameDest = g_strdup_printf ("%s/%s.mp3",  PathDest, Audio->NameSong);
		else if (TypeFileIs == FILE_IS_OGG)
			PathNameDest = g_strdup_printf ("%s/%s.ogg",  PathDest, Audio->NameSong);
		else if (TypeFileIs == FILE_IS_M4A)
			PathNameDest = g_strdup_printf ("%s/%s.m4a",  PathDest, Audio->NameSong);
		else if (TypeFileIs == FILE_IS_AAC)
			PathNameDest = g_strdup_printf ("%s/%s.aac",  PathDest, Audio->NameSong);
		else if (TypeFileIs == FILE_IS_MPC)
			PathNameDest = g_strdup_printf ("%s/%s.mpc",  PathDest, Audio->NameSong);
		else if (TypeFileIs == FILE_IS_APE)
			PathNameDest = g_strdup_printf ("%s/%s.ape",  PathDest, Audio->NameSong);
		else if (TypeFileIs == FILE_IS_WAVPACK)
			PathNameDest = g_strdup_printf ("%s/%s.wv",   PathDest, Audio->NameSong);
		
		if (PathNameDest != NULL) {
			BoolExist = infosong_access_mode (AM_FILE_IS_REG, PathNameDest, NULL);
		}
		
		g_free (PathNameDest);
		PathNameDest = NULL;
		g_free (PathDest);
		PathDest = NULL;
	}
	return (BoolExist);
}

ETAT_SELECTION_CD cdaudio_get_next_flag (TYPE_FILE_IS type_file_is, gboolean p_flag_next, gint p_NumTrack)
{
	GList              *List = NULL;
	AUDIO              *Audio = NULL;
	ETAT_SELECTION_CD   etat = CD_ETAT_ATTENTE;
	gboolean            BoolOpExpert = FALSE;
	gboolean            BoolFileExist = FALSE;
	
	if (cdaudio_bool_from_to (type_file_is, TRUE) == FALSE) return (CD_ETAT_PRG_ABSENT);

	if ((List = g_list_nth (EnteteCD.GList_Audio_cd, p_NumTrack))) {
		if ((Audio = (AUDIO *)List->data)) {

			if (type_file_is == FILE_IS_FLAC) {
				etat = Audio->EtatSelection_Flac;
				BoolOpExpert = options_get_entry_is_valid (FLAC_WAV_TO_FLAC);
			}
			else if (type_file_is == FILE_IS_WAV) {
				etat = Audio->EtatSelection_Wav;
				BoolOpExpert = options_get_entry_is_valid (CDPARANOIA_CD_TO_WAV);
			}
			else if (type_file_is == FILE_IS_MP3) {
				etat = Audio->EtatSelection_Mp3;
				BoolOpExpert = options_get_entry_is_valid (LAME_WAV_TO_MP3);
			}
			else if (type_file_is == FILE_IS_OGG) {
				etat = Audio->EtatSelection_Ogg;
				BoolOpExpert = options_get_entry_is_valid (OGGENC_WAV_TO_OGG);
			}
			else if (type_file_is == FILE_IS_M4A) {
				etat = Audio->EtatSelection_M4a;
				BoolOpExpert = options_get_entry_is_valid (FAAC_WAV_TO_M4A);
			}
			else if (type_file_is == FILE_IS_AAC) {
				etat = Audio->EtatSelection_Aac;
				BoolOpExpert = options_get_entry_is_valid (AACPLUSENC_WAV_TO_AAC);
			}
			else if (type_file_is == FILE_IS_MPC) {
				etat = Audio->EtatSelection_Mpc;
				BoolOpExpert = options_get_entry_is_valid (MPPENC_WAV_TO_MPC);
			}
			else if (type_file_is == FILE_IS_APE) {
				etat = Audio->EtatSelection_Ape;
				BoolOpExpert = options_get_entry_is_valid (MAC_WAV_TO_APE);
			}
			else if (type_file_is == FILE_IS_WAVPACK) {
				etat = Audio->EtatSelection_WavPack;
				BoolOpExpert = options_get_entry_is_valid (WAVPACK_WAV_TO_WAVPACK);
			}
			
			BoolFileExist = cdaudio_file_exist (Audio, type_file_is);
			
			switch (etat) {
			case CD_ETAT_NONE :
				return (BoolFileExist ? CD_ETAT_ATTENTE_EXIST : ETAT_ATTENTE);
				
				return (CD_ETAT_NONE);
				
			case CD_ETAT_PRG_ABSENT :
				return (CD_ETAT_PRG_ABSENT);
				
			case CD_ETAT_ATTENTE :
				if (p_flag_next == TRUE) {
					if (BoolFileExist) {
						return (CD_ETAT_SELECT_EXIST);
					}
					return (CD_ETAT_SELECT);
				}
				if (BoolFileExist) return (CD_ETAT_ATTENTE_EXIST);
				return (CD_ETAT_ATTENTE);

			case CD_ETAT_ATTENTE_EXIST :
				if (p_flag_next == TRUE) {
					if (BoolFileExist) {
						return (CD_ETAT_SELECT_EXIST);
					}
					return (CD_ETAT_SELECT);
				}
				if (BoolFileExist) return (CD_ETAT_ATTENTE_EXIST);
				return (CD_ETAT_ATTENTE);

			case CD_ETAT_SELECT :
				if (p_flag_next == TRUE) {
					if (BoolFileExist) {
						if (type_file_is != FILE_IS_WAV && BoolOpExpert == TRUE) return (CD_ETAT_SELECT_EXPERT_EXIST);
						return (CD_ETAT_ATTENTE_EXIST);
					}
					if (type_file_is != FILE_IS_WAV && BoolOpExpert == TRUE) return (CD_ETAT_SELECT_EXPERT);
					return (CD_ETAT_ATTENTE);
				}
				if (BoolFileExist) return (ETAT_SELECT_EXIST);
				return (CD_ETAT_SELECT);

			case CD_ETAT_SELECT_EXIST :
				if (p_flag_next == TRUE) {
					if (BoolFileExist) {
						if (BoolOpExpert == TRUE) return (CD_ETAT_SELECT_EXPERT_EXIST);
						return (ETAT_ATTENTE_EXIST);
					}
					if (BoolOpExpert == TRUE) return (CD_ETAT_ATTENTE_EXIST);
					return (CD_ETAT_ATTENTE);
				}
				if (!BoolFileExist) return (CD_ETAT_SELECT);
				return (CD_ETAT_SELECT_EXIST);

			case CD_ETAT_SELECT_EXPERT :
				if (p_flag_next == TRUE) {
					if (BoolFileExist) {
						return (CD_ETAT_ATTENTE_EXIST);
					}
					return (CD_ETAT_ATTENTE);
				}
				if (BoolFileExist) return (CD_ETAT_SELECT_EXPERT_EXIST);
				return (CD_ETAT_SELECT_EXPERT);

			case CD_ETAT_SELECT_EXPERT_EXIST :
				if (p_flag_next == TRUE) {
					if (BoolFileExist) {
						return (CD_ETAT_ATTENTE_EXIST);
					}
					return (CD_ETAT_ATTENTE);
				}
				if (!BoolFileExist) return (CD_ETAT_SELECT_EXPERT);
				return (CD_ETAT_SELECT_EXPERT_EXIST);
			}
		}
	}
	return (CD_ETAT_ATTENTE);
}


gchar *cdaudio_get_pathname (AUDIO *Audio, TYPE_FILE_IS type_file_is)
{
	if (type_file_is == FILE_IS_FLAC) {
		return ((gchar *)g_strdup_printf ("%s/%s.flac", (gchar *)Config_User.Path_Destination_CD, Audio->NameSong));
	}
	else if (type_file_is == FILE_IS_WAV) {
		return ((gchar *)g_strdup_printf ("%s/%s.wav", (gchar *)Config_User.Path_Destination_CD, Audio->NameSong));
	}
	else if (type_file_is == FILE_IS_MP3) {
		return ((gchar *)g_strdup_printf ("%s/%s.mp3", (gchar *)Config_User.Path_Destination_CD, Audio->NameSong));
	}
	else if (type_file_is == FILE_IS_OGG) {
		return ((gchar *)g_strdup_printf ("%s/%s.ogg", (gchar *)Config_User.Path_Destination_CD, Audio->NameSong));
	}
	else if (type_file_is == FILE_IS_M4A) {
		return ((gchar *)g_strdup_printf ("%s/%s.m4a", (gchar *)Config_User.Path_Destination_CD, Audio->NameSong));
	}
	else if (type_file_is == FILE_IS_AAC) {
		return ((gchar *)g_strdup_printf ("%s/%s.aac", (gchar *)Config_User.Path_Destination_CD, Audio->NameSong));
	}
	else if (type_file_is == FILE_IS_MPC) {
		return ((gchar *)g_strdup_printf ("%s/%s.mpc", (gchar *)Config_User.Path_Destination_CD, Audio->NameSong));
	}
	else if (type_file_is == FILE_IS_APE) {
		return ((gchar *)g_strdup_printf ("%s/%s.ape", (gchar *)Config_User.Path_Destination_CD, Audio->NameSong));
	}
	else if (type_file_is == FILE_IS_WAVPACK) {
		return ((gchar *)g_strdup_printf ("%s/%s.wv", (gchar *)Config_User.Path_Destination_CD, Audio->NameSong));
	}

	return ((gchar *)NULL);
}

GdkPixbuf *cdaudio_get_pixbuf_file (AUDIO *Audio, TYPE_FILE_IS p_type_file_is)
{
	ETAT_SELECTION_CD   etat = CD_ETAT_ATTENTE;
	gint                NumTrack = Audio->Num_Track -1;
	
	if (cdaudio_bool_from_to (p_type_file_is, TRUE) == FALSE) return (var_cd.Pixbuf_NotInstall);

	if (p_type_file_is == FILE_IS_FLAC)		etat = Audio->EtatSelection_Flac    = cdaudio_get_next_flag (p_type_file_is, FALSE, NumTrack);
	else if (p_type_file_is == FILE_IS_WAV)		etat = Audio->EtatSelection_Wav     = cdaudio_get_next_flag (p_type_file_is, FALSE, NumTrack);
	else if (p_type_file_is == FILE_IS_OGG)		etat = Audio->EtatSelection_Ogg     = cdaudio_get_next_flag (p_type_file_is, FALSE, NumTrack);
	else if (p_type_file_is == FILE_IS_MP3)		etat = Audio->EtatSelection_Mp3     = cdaudio_get_next_flag (p_type_file_is, FALSE, NumTrack);
	else if (p_type_file_is == FILE_IS_M4A)	        etat = Audio->EtatSelection_M4a     = cdaudio_get_next_flag (p_type_file_is, FALSE, NumTrack);
	else if (p_type_file_is == FILE_IS_AAC)	        etat = Audio->EtatSelection_Aac     = cdaudio_get_next_flag (p_type_file_is, FALSE, NumTrack);
	else if (p_type_file_is == FILE_IS_MPC)		etat = Audio->EtatSelection_Mpc     = cdaudio_get_next_flag (p_type_file_is, FALSE, NumTrack);
	else if (p_type_file_is == FILE_IS_APE)		etat = Audio->EtatSelection_Ape     = cdaudio_get_next_flag (p_type_file_is, FALSE, NumTrack);
	else if (p_type_file_is == FILE_IS_WAVPACK)	etat = Audio->EtatSelection_WavPack = cdaudio_get_next_flag (p_type_file_is, FALSE, NumTrack);
	else if (p_type_file_is == FILE_TO_NORMALISE) {
	
		if (Audio->EtatNormalise == TRUE) {
			return (var_cd.Pixbuf_Selected);
		}
		else {
			return (var_cd.Pixbuf_Coche);
		}
	}
	
	switch (etat) {
	case CD_ETAT_NONE :
		return (NULL);
	case CD_ETAT_PRG_ABSENT :
		return (var_cd.Pixbuf_NotInstall);
	case CD_ETAT_ATTENTE :
		return (var_cd.Pixbuf_Coche);
	case CD_ETAT_ATTENTE_EXIST :
		return (var_cd.Pixbuf_Coche_exist);
	case CD_ETAT_SELECT :
		return (var_cd.Pixbuf_Selected);
	case CD_ETAT_SELECT_EXIST :
		return (var_cd.Pixbuf_Selected_exist);
	case CD_ETAT_SELECT_EXPERT :
		return (var_cd.Pixbuf_Selected_expert);
	case CD_ETAT_SELECT_EXPERT_EXIST :
		return (var_cd.Pixbuf_Selected_expert_exist);
	}
	
	return (NULL);
	
}

void cdaudio_change_all_flags_normalise_verticaly (gboolean BoolSelect)
{
	AUDIO         *Audio = NULL;
	GList         *List = NULL;
	gboolean       valid;
	GtkTreeIter    iter;
	gint           NumTrack = 0;
	GdkPixbuf     *Pixbuf = NULL;
	
	valid = gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
	while (valid) {
		List = g_list_nth (EnteteCD.GList_Audio_cd, NumTrack);
		if ((Audio = (AUDIO *)List->data)) {
			
			Audio->EtatNormalise = BoolSelect;
			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_TO_NORMALISE);
			gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_FILE_NORMALIZE, Pixbuf, -1);
		}
		NumTrack ++;
		valid = gtk_tree_model_iter_next (var_cd.Adr_Tree_Model, &iter);
	}
}

/* Modification complete de l'etat des flags 'Audio->Bool_Extract_xxx' du GList 'EnteteCD.GList_Audio_cd'
*  Modification complete de la representation graphique (a l'ecran) de l'etat d'apres le GList
*  --
*  entree :
*      TYPE_FILE_IS type      : Structure
*      gboolean     Is_Select : Etat de 'var_cd.Pixbuf_Coche' inversee
*  retour : -
*/
void cdaudio_change_all_flags_extract_verticaly (TYPE_FILE_IS type_file_is)
{
	AUDIO         *Audio = NULL;
	GdkPixbuf     *Pixbuf = NULL;
	GList         *List = NULL;
	gboolean       valid;
	GtkTreeIter    iter;
	gint           NumTrack = 0;
	
	valid = gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
	while (valid) {
		List = g_list_nth (EnteteCD.GList_Audio_cd, NumTrack);
		if ((Audio = (AUDIO *)List->data)) {

			if (type_file_is == FILE_IS_FLAC) {
				Audio->EtatSelection_Flac = cdaudio_get_next_flag (FILE_IS_FLAC, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_FLAC);
				gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_FLAC, Pixbuf, -1);
			}
			else if (type_file_is == FILE_IS_WAV) {
				Audio->EtatSelection_Wav = cdaudio_get_next_flag (FILE_IS_WAV, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_WAV);
				gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_WAV, Pixbuf, -1);
			}
			else if (type_file_is == FILE_IS_MP3) {
				Audio->EtatSelection_Mp3 = cdaudio_get_next_flag (FILE_IS_MP3, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_MP3);
				gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_MP3, Pixbuf, -1);
			}
			else if (type_file_is == FILE_IS_OGG) {
				Audio->EtatSelection_Ogg = cdaudio_get_next_flag (FILE_IS_OGG, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_OGG);
				gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_OGG, Pixbuf, -1);
			}
			else if (type_file_is == FILE_IS_M4A) {
				Audio->EtatSelection_M4a = cdaudio_get_next_flag (FILE_IS_M4A, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_M4A);
				gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_M4A, Pixbuf, -1);
			}
			else if (type_file_is == FILE_IS_AAC) {
				Audio->EtatSelection_Aac = cdaudio_get_next_flag (FILE_IS_AAC, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_AAC);
				gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_AAC, Pixbuf, -1);
			}
			else if (type_file_is == FILE_IS_MPC) {
				Audio->EtatSelection_Mpc = cdaudio_get_next_flag (FILE_IS_MPC, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_MPC);
				gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_MPC, Pixbuf, -1);
			}
			else if (type_file_is == FILE_IS_APE) {
				Audio->EtatSelection_Ape = cdaudio_get_next_flag (FILE_IS_APE, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_APE);
				gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_APE, Pixbuf, -1);
			}
			else if (type_file_is == FILE_IS_WAVPACK) {
				Audio->EtatSelection_WavPack = cdaudio_get_next_flag (FILE_IS_WAVPACK, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_WAVPACK);
				gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_WAVPACK, Pixbuf, -1);
			}
			else if (type_file_is == FILE_TO_NORMALISE) {
				Audio->EtatNormalise = (Audio->EtatNormalise == TRUE) ? FALSE : TRUE;
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_TO_NORMALISE);
				gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_FILE_NORMALIZE, Pixbuf, -1);
			}

			NumTrack ++;
		}
		valid = gtk_tree_model_iter_next (var_cd.Adr_Tree_Model, &iter);
	}
}

void cdaudio_clear_all_pixbuf_cd_play (void)
{
	GList  *List = NULL;
	AUDIO  *Audio = NULL;

	/* PRINT_FUNC_LF(); */

	List = g_list_first (EnteteCD.GList_Audio_cd);
	while (List) {
		if ((Audio = (AUDIO *) List->data) != NULL) Audio->EtatPlay = CD_ETAT_PLAY_ATTENTE;
		List = g_list_next (List);
	}
}
void cdaudio_affiche_all_pixbuf_cd_play (void)
{
	GtkTreeIter    iter;
	gboolean       valid;
	gchar         *piste;
	GdkPixbuf     *Pixbuf = NULL;
	GList         *List;
	AUDIO         *Audio = NULL;

	/* PRINT_FUNC_LF(); */

	valid = gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_cd.Adr_Tree_Model, &iter, CD_COLUMN_TRACK_NUM, &piste, -1);
		List = g_list_nth (EnteteCD.GList_Audio_cd, atoi (piste) -1);
		if ((Audio = List->data)) {

			if (Audio->EtatPlay == CD_ETAT_PLAY)			Pixbuf = var_cd.Pixbuf_CdPlay;
			else if (Audio->EtatPlay == CD_ETAT_PLAY_ATTENTE)	Pixbuf = var_cd.Pixbuf_CdStop;

			gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_PLAY, Pixbuf, -1);
		}
		valid = gtk_tree_model_iter_next (var_cd.Adr_Tree_Model, &iter);
	}
}


/* CD_ETAT_PLAY_ATTENTE
   CD_ETAT_PLAY
   */
void cdaudio_set_etat_music_pixbuf_with_detail (AUDIO *p_audio, ETAT_PLAY_CD EtatPlay)
{
	GtkTreeIter    iter;
	gboolean       valid;
	gchar         *piste;
	GList         *List;
	AUDIO         *Audio = NULL;
	
	/* Tous les flags et widget sur FILE_ETAT_PLAY_ATTENTE */
	valid = gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
	while (valid) {
		gtk_tree_model_get (var_cd.Adr_Tree_Model, &iter, CD_COLUMN_TRACK_NUM, &piste, -1);
		List = g_list_nth (EnteteCD.GList_Audio_cd, atoi (piste) -1);
		if ((Audio = List->data)) {
			Audio->EtatPlay = CD_ETAT_PLAY_ATTENTE;
			gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_PLAY, var_cd.Pixbuf_CdStop, -1);
		}
		valid = gtk_tree_model_iter_next (var_cd.Adr_Tree_Model, &iter);
	}
	
	if (EtatPlay == CD_ETAT_PLAY) {
		valid = gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
		while (valid) {
			gtk_tree_model_get (var_cd.Adr_Tree_Model, &iter, CD_COLUMN_TRACK_NUM, &piste, -1);
			List = g_list_nth (EnteteCD.GList_Audio_cd, atoi (piste) -1);
			if ((Audio = List->data)) {
				if (p_audio == Audio) {
					Audio->EtatPlay = CD_ETAT_PLAY;
					gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_PLAY, var_cd.Pixbuf_CdPlay, -1);
				}
			}
			valid = gtk_tree_model_iter_next (var_cd.Adr_Tree_Model, &iter);
		}
	}
}

/* Gestion de la selection ou de la deselection des demandes de conversions des fichiers vers un
*  autre format. Cette demande peut etre unique ou globale :
*    - unique  : click gauche
*    - globale : touche Controle appuyee + click gauche
*  --
*  entree :
*      GtkWidget *treeview   :
*      GdkEventButton *event :
*      gpointer data         :
*  retour : -
*      FALSE :
*/
gboolean cdaudio_event_click_mouse_cd (GtkWidget *treeview, GdkEventButton *event, gpointer data)
{
	GtkTreePath        *path;
	GtkTreeViewColumn  *column;
	GtkTreeViewColumn  *ColumnDum;
	gint                i;
	GtkTreeIter         iter;
	GtkTreeModel       *model = (GtkTreeModel *)data;
	gchar              *Str = NULL;
	gint                NumTrack = -1;
	GdkPixbuf          *Pixbuf = NULL;
	gint                Pos_X, Pos_Y;
	gboolean            bool_key_Control = (keys.keyval == GDK_Control_L || keys.keyval == GDK_Control_R);
	gboolean            bool_key_Shift   = (keys.keyval == GDK_Shift_L || keys.keyval == GDK_Shift_R);
	gboolean            bool_key_Release = (bool_key_Control == FALSE &&  bool_key_Shift == FALSE);
	gboolean            bool_click_droit = (event->button == 3);
	gboolean            bool_click_gauche = (event->button == 1);
	AUDIO              *Audio = NULL;
	GList              *List = NULL;

	gboolean            BoolSelectColPlay = FALSE;
	gboolean            BoolSelectColWav = FALSE;
	gboolean            BoolSelectColFlac = FALSE;
	gboolean            BoolSelectColApe = FALSE;
	gboolean            BoolSelectColWavP = FALSE;
	gboolean            BoolSelectColOgg = FALSE;
	gboolean            BoolSelectColM4a = FALSE;
	gboolean            BoolSelectColAac = FALSE;
	gboolean            BoolSelectColMpc = FALSE;
	gboolean            BoolSelectColMp3 = FALSE;
	gboolean            BoolSelectColTime = FALSE;
	gboolean            BoolSelectColNormalise = FALSE;
	gboolean            BoolSelectColNom = FALSE;

	/* PRINT_FUNC_LF(); */

	/* Single clicks only 	*/
	if (event->type != GDK_BUTTON_PRESS) return (FALSE);

	/* Si pas de selection a cet endroit retour */
	if (!gtk_tree_view_get_path_at_pos (GTK_TREE_VIEW(treeview),
						  (gint)event->x, (gint)event->y,
						   &path, &column, &Pos_X, &Pos_Y)) return (FALSE);


	/*
	enum
	{
		NUM_TREE_Play
		NUM_TREE_Wav
		NUM_TREE_Flac
		NUM_TREE_Ape
		NUM_TREE_WavP
		NUM_TREE_Ogg
		NUM_TREE_M4a
		NUM_TREE_Aac
		NUM_TREE_Mpc
		NUM_TREE_Mp3
		NUM_TREE_Num
		NUM_TREE_Time
		NUM_TREE_Normalise
		NUM_TREE_Nom
		NUM_TREE_ALL_COLUMN
	};
	*/
	/* IDEE POUR REMPLACER LES COMPARAISON PAR NOMS. EXEMPLES:
	 * 	PLAY	= 0
	 * 	TRASH	= 1
	 *	TYPE	= 2
	 * 	etc ...
	 * NOTA:
	 * 	CET ALGO PERMET DE RENOMMER AISEMENT LES ENTETES DE COLONNES DANS TOUTES LES LANGUES: FR, EN, DE, ...
	 */
	for (i = 0; i < NUM_TREE_ALL_COLUMN; i ++) {
		ColumnDum = gtk_tree_view_get_column (GTK_TREE_VIEW(treeview), i);
		if (ColumnDum == column) {
			/* g_print ("\tNUM IS: %d\n", i); */
			switch ( i ) {
			case NUM_TREE_Play :		BoolSelectColPlay		= TRUE;	break;
			case NUM_TREE_Wav :		BoolSelectColWav		= TRUE;	break;
			case NUM_TREE_Flac :		BoolSelectColFlac		= TRUE;	break;
			case NUM_TREE_Ape :		BoolSelectColApe		= TRUE;	break;
			case NUM_TREE_WavP :		BoolSelectColWavP		= TRUE;	break;
			case NUM_TREE_Ogg :		BoolSelectColOgg		= TRUE;	break;
			case NUM_TREE_M4a :		BoolSelectColM4a		= TRUE;	break;
			case NUM_TREE_Aac :		BoolSelectColAac		= TRUE;	break;
			case NUM_TREE_Mpc :		BoolSelectColMpc		= TRUE;	break;
			case NUM_TREE_Mp3 :		BoolSelectColMp3		= TRUE;	break;
			case NUM_TREE_Num :							break;
			case NUM_TREE_Time :		BoolSelectColTime		= TRUE;	break;
			case NUM_TREE_Normalise :	BoolSelectColNormalise		= TRUE;	break;
			case NUM_TREE_Nom :		BoolSelectColNom		= TRUE;	break;
			
			default: return (FALSE);
			}
			/* La colonne est trouvee ... sortie de la boucle */
			break;
		}
	}
	/*
	BoolSelectColPlay      = strcmp(column->title, "Play") == 0 ? TRUE : FALSE;
	BoolSelectColWav       = strcmp(column->title, "Wav") == 0 ? TRUE : FALSE;
	BoolSelectColFlac      = strcmp(column->title, "Flac") == 0 ? TRUE : FALSE;
	BoolSelectColApe       = strcmp(column->title, "Ape") == 0 ? TRUE : FALSE;
	BoolSelectColWavP      = strcmp(column->title, "WavP") == 0 ? TRUE : FALSE;
	BoolSelectColOgg       = strcmp(column->title, "Ogg") == 0 ? TRUE : FALSE;
	BoolSelectColM4a       = strcmp(column->title, "M4a") == 0 ? TRUE : FALSE;
	BoolSelectColAac       = strcmp(column->title, "Aac") == 0 ? TRUE : FALSE;
	BoolSelectColMpc       = strcmp(column->title, "Mpc") == 0 ? TRUE : FALSE;
	BoolSelectColMp3       = strcmp(column->title, "Mp3") == 0 ? TRUE : FALSE;
	BoolSelectColTime      = strcmp(column->title, "Time") == 0 ? TRUE : FALSE;
	BoolSelectColNormalise = strcmp(column->title, "Normalise") == 0 ? TRUE : FALSE;
	BoolSelectColNom       = strcmp(column->title, "Nom") == 0 ? TRUE : FALSE;
	*/

	/* position du curseur a l'instant du click */
	if (!BoolSelectColNormalise) {
		if (Pos_X < 18 || Pos_X > 30) return (FALSE);
		if (Pos_Y < 6 || Pos_Y > 18) return (FALSE);
	}

	if (BoolSelectColPlay) {
		BoolSelectColPlay &= (PrgInit.bool_mplayer && bool_click_gauche);
	}
	else if ((options_extract_by () == EXTRACT_WITH_CDPARANOIA_EXPERT ||  options_extract_by () == EXTRACT_WITH_CDPARANOIA) && PrgInit.bool_cdparanoia == FALSE) {
		utils_set_prg_not_found ("CDPARANOIA", PrgInit.bool_cdparanoia);
	}
	else if (options_extract_by () == EXTRACT_WITH_CDDA2WAV && PrgInit.bool_cdda2wav == FALSE) {
		utils_set_prg_not_found ("CDDA2WAV", PrgInit.bool_cdda2wav);
	}
	else if (BoolSelectColFlac) {
		BoolSelectColFlac &= PrgInit.bool_flac;
	}
	else if (BoolSelectColWav) {
		if (options_extract_by () == EXTRACT_WITH_CDDA2WAV) {
			BoolSelectColWav &= PrgInit.bool_cdda2wav;
		}
		else {
			BoolSelectColWav &= PrgInit.bool_cdparanoia;
		}
	}
	else if (BoolSelectColMp3) {
		BoolSelectColMp3 &= PrgInit.bool_lame;
	}
	else if (BoolSelectColOgg) {
		BoolSelectColOgg &= PrgInit.bool_oggenc;
	}
	else if (BoolSelectColM4a) {
		BoolSelectColM4a &= PrgInit.bool_faac;
	}
	else if (BoolSelectColAac) {
		BoolSelectColAac &= PrgInit.bool_aacplusenc;
	}
	else if (BoolSelectColMpc) {
		BoolSelectColMpc &= PrgInit.bool_mppenc;
	}
	else if (BoolSelectColApe) {
		BoolSelectColApe &= PrgInit.bool_ape;
	}
	else if (BoolSelectColWavP) {
		BoolSelectColWavP &= PrgInit.bool_wavpack;
	}

	if (bool_key_Shift && bool_click_gauche) {
		if (BoolSelectColWav  ||
		    BoolSelectColFlac ||
		    BoolSelectColMp3  ||
		    BoolSelectColOgg  ||
		    BoolSelectColM4a  ||
		    BoolSelectColAac  ||
		    BoolSelectColMpc  ||
		    BoolSelectColApe  ||
		    BoolSelectColWavP) {
			BoolSelectColWav  &= PrgInit.bool_cdparanoia;
			BoolSelectColFlac &= PrgInit.bool_flac;
			BoolSelectColMp3  &= PrgInit.bool_lame;
			BoolSelectColOgg  &= PrgInit.bool_oggenc;
			BoolSelectColM4a  &= PrgInit.bool_faac;
			BoolSelectColAac  &= PrgInit.bool_aacplusenc;
			BoolSelectColMpc  &= PrgInit.bool_mppenc;
			BoolSelectColApe  &= PrgInit.bool_ape;
			BoolSelectColWavP &= PrgInit.bool_wavpack;
		}
	}

	utils_put_error_statusbar (FALSE);

	gtk_tree_model_get_iter (model, &iter, path);
	gtk_tree_model_get (var_cd.Adr_Tree_Model, &iter, CD_COLUMN_TRACK_NUM, &Str, -1);
	NumTrack = (gint)g_strtod (Str, NULL);
	NumTrack --;
	if ((List = g_list_nth (EnteteCD.GList_Audio_cd, NumTrack)) == NULL) return (FALSE);
	Audio = (AUDIO *)List->data;
	if (!Audio) return (FALSE);
	
	if (bool_click_droit) {
		
		if (BoolSelectColNormalise) {
			/* PopUp menu normalise CD */
			popup_normalise_cd ();
			return (FALSE);
		}
		else if (!BoolSelectColNormalise) {
		
			/* PopUp menu CD */
			if (bool_click_droit &&
			    (BoolSelectColWav ||
			     BoolSelectColFlac ||
			     BoolSelectColApe ||
			     BoolSelectColWavP ||
			     BoolSelectColOgg ||
			     BoolSelectColM4a ||
			     BoolSelectColAac ||
			     BoolSelectColMpc ||
			     BoolSelectColMp3)) {
			     	TYPE_FILE_IS TypeFileIs = FILE_IS_NONE;
			     	
			     	if (BoolSelectColWav)	TypeFileIs = FILE_IS_WAV;
			     	if (BoolSelectColFlac)	TypeFileIs = FILE_IS_FLAC;
			     	if (BoolSelectColApe)	TypeFileIs = FILE_IS_APE;
			     	if (BoolSelectColWavP)	TypeFileIs = FILE_IS_WAVPACK;
			     	if (BoolSelectColOgg)	TypeFileIs = FILE_IS_OGG;
			     	if (BoolSelectColM4a)	TypeFileIs = FILE_IS_M4A;
			     	if (BoolSelectColAac)	TypeFileIs = FILE_IS_AAC;
			     	if (BoolSelectColMpc)	TypeFileIs = FILE_IS_MPC;
			     	if (BoolSelectColMp3)	TypeFileIs = FILE_IS_MP3;
			     	
				popup_cd (Audio, TypeFileIs);
				return (FALSE);
			}
		}
	}
	
	/* Un simle click change l etat de normalisaion */
	else if (BoolSelectColNormalise) {

		if (PrgInit.bool_normalize == FALSE) {
			// utils_set_prg_not_found (PrgInit.name_normalize, PrgInit.bool_normalize);
			utils_set_prg_not_found (prginit_get_name (NMR_normalize), PrgInit.bool_normalize);
		}

		Audio->EtatNormalise = (Audio->EtatNormalise == TRUE) ? FALSE : TRUE;
		Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_TO_NORMALISE);
		gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_FILE_NORMALIZE, Pixbuf, -1);
		cdaudio_set_flag_buttons_audio_cd ();
	}
	
	/* traitements */
	
	else if (BoolSelectColPlay) {
		
		gchar *piste = NULL;

		gtk_tree_model_get (var_cd.Adr_Tree_Model, &iter, CD_COLUMN_TRACK_NUM, &piste, -1);
		if (piste[0] == '0') {
			piste [0] = piste [1];
			piste [1] = '\0';
		}

		if (Audio->EtatPlay == CD_ETAT_PLAY_ATTENTE) {
			
			if (WinPlay_Is_Ok () == TRUE) {
			GList *list = NULL;
			gchar *str = NULL;
			
			cdaudio_set_etat_music_pixbuf_with_detail (Audio, CD_ETAT_PLAY);
			
			str = g_strdup_printf ("%d : %s",  Audio->Num_Track, Audio->NameSong);

			/*
			LIST_MPLAYER_FROM_DVD
			LIST_MPLAYER_FROM_CD
			LIST_MPLAYER_FROM_FILE
			*/
			if (WinPlay_IsOpen () == FALSE) {
				WinPlay_Open (LIST_MPLAYER_FROM_CD, "From CD", str);
			}
			else {
				// WinPlay_set_label_namefile (LIST_MPLAYER_FROM_CD, "From CD", str);
				WinPlay_Open (LIST_MPLAYER_FROM_CD, "From CD", str);
			}
			g_free (str);
			str = NULL;
			list = g_list_append (list, g_strdup_printf ("cdda://%s", piste));
			list = g_list_append (list, g_strdup ("-cdrom-device"));
			list = g_list_append (list, g_strdup_printf ("%s", EnteteCD.NameCD_Device));
			
			mplayer_set_list (LIST_MPLAYER_FROM_CD, 0.0, 0, list);
			
			list = utils_clear_list (list);
			}
		}
		else {
			cdaudio_set_etat_music_pixbuf_with_detail (Audio, CD_ETAT_PLAY_ATTENTE);
			
			mplayer_fifo_quit ();
		}
	}
	else if (BoolSelectColWavP ||
	         BoolSelectColApe  ||
	         BoolSelectColMpc  ||
	         BoolSelectColFlac ||
	         BoolSelectColWav  ||
	         BoolSelectColMp3  ||
	         BoolSelectColOgg  ||
	         BoolSelectColM4a  ||
	         BoolSelectColAac) {

		if (bool_key_Release && bool_click_gauche) {

			if (BoolSelectColFlac) {
				Audio->EtatSelection_Flac = cdaudio_get_next_flag (FILE_IS_FLAC, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_FLAC);
				gtk_list_store_set (var_cd.Adr_List_Store,
							&iter,
							CD_COLUMN_FLAC,
							Pixbuf,
							-1);
			}
			else if (BoolSelectColWav) {
				Audio->EtatSelection_Wav = cdaudio_get_next_flag (FILE_IS_WAV, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_WAV);
				gtk_list_store_set (var_cd.Adr_List_Store,
							&iter,
							CD_COLUMN_WAV,
							Pixbuf,
							-1);
			}
			else if (BoolSelectColMp3) {
				Audio->EtatSelection_Mp3 = cdaudio_get_next_flag (FILE_IS_MP3, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_MP3);
				gtk_list_store_set (var_cd.Adr_List_Store,
							&iter,
							CD_COLUMN_MP3,
							Pixbuf,
							-1);
			}
			else if (BoolSelectColOgg) {
				Audio->EtatSelection_Ogg = cdaudio_get_next_flag (FILE_IS_OGG, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_OGG);
				gtk_list_store_set (var_cd.Adr_List_Store,
							&iter,
							CD_COLUMN_OGG,
							Pixbuf,
							-1);
			}
			else if (BoolSelectColM4a) {
				Audio->EtatSelection_M4a = cdaudio_get_next_flag (FILE_IS_M4A, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_M4A);
				gtk_list_store_set (var_cd.Adr_List_Store,
							&iter,
							CD_COLUMN_M4A,
							Pixbuf,
							-1);
			}
			else if (BoolSelectColAac) {
				Audio->EtatSelection_Aac = cdaudio_get_next_flag (FILE_IS_AAC, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_AAC);
				gtk_list_store_set (var_cd.Adr_List_Store,
							&iter,
							CD_COLUMN_AAC,
							Pixbuf,
							-1);
			}
			else if (BoolSelectColMpc) {
				Audio->EtatSelection_Mpc = cdaudio_get_next_flag (FILE_IS_MPC, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_MPC);
				gtk_list_store_set (var_cd.Adr_List_Store,
							&iter,
							CD_COLUMN_MPC,
							Pixbuf,
							-1);
			}
			else if (BoolSelectColApe) {
				Audio->EtatSelection_Ape = cdaudio_get_next_flag (FILE_IS_APE, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_APE);
				gtk_list_store_set (var_cd.Adr_List_Store,
							&iter,
							CD_COLUMN_APE,
							Pixbuf,
							-1);
			}
			else if (BoolSelectColWavP) {
				Audio->EtatSelection_WavPack = cdaudio_get_next_flag (FILE_IS_WAVPACK, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_WAVPACK);
				gtk_list_store_set (var_cd.Adr_List_Store,
							&iter,
							CD_COLUMN_WAVPACK,
							Pixbuf,
							-1);
			}
			
			cdaudio_set_flag_buttons_audio_cd ();
			gtk_tree_selection_select_iter (var_cd.Adr_Line_Selected, &iter);
		}
		else if (bool_key_Control && bool_click_gauche) {
			
			TYPE_FILE_IS TypeFileIs = FILE_IS_NONE;
			
			if (BoolSelectColFlac)		TypeFileIs = FILE_IS_FLAC;
			else if (BoolSelectColWav)	TypeFileIs = FILE_IS_WAV;
			else if (BoolSelectColMp3)	TypeFileIs = FILE_IS_MP3;
			else if (BoolSelectColOgg)	TypeFileIs = FILE_IS_OGG;
			else if (BoolSelectColM4a)	TypeFileIs = FILE_IS_M4A;
			else if (BoolSelectColAac)	TypeFileIs = FILE_IS_AAC;
			else if (BoolSelectColMpc)	TypeFileIs = FILE_IS_MPC;
			else if (BoolSelectColApe)	TypeFileIs = FILE_IS_APE;
			else if (BoolSelectColWavP)	TypeFileIs = FILE_IS_WAVPACK;
			else				TypeFileIs = FILE_IS_NONE;
			
			if (TypeFileIs != FILE_IS_NONE) {
				cdaudio_change_all_flags_extract_verticaly (TypeFileIs);
				cdaudio_set_flag_buttons_audio_cd ();
				gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
				gtk_tree_selection_select_iter (var_cd.Adr_Line_Selected, &iter);
			}
		}
		else if (bool_key_Shift && bool_click_gauche) {

			Audio->EtatSelection_Flac = cdaudio_get_next_flag (FILE_IS_FLAC, TRUE, NumTrack);
			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_FLAC);
			gtk_list_store_set (var_cd.Adr_List_Store,
						&iter,
						CD_COLUMN_FLAC,
						Pixbuf,
						-1);

			Audio->EtatSelection_Wav = cdaudio_get_next_flag (FILE_IS_WAV, TRUE, NumTrack);
			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_WAV);
			gtk_list_store_set (var_cd.Adr_List_Store,
						&iter,
						CD_COLUMN_WAV,
						Pixbuf,
						-1);

			Audio->EtatSelection_Mp3 = cdaudio_get_next_flag (FILE_IS_MP3, TRUE, NumTrack);
			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_MP3);
			gtk_list_store_set (var_cd.Adr_List_Store,
						&iter,
						CD_COLUMN_MP3,
						Pixbuf,
						-1);

			Audio->EtatSelection_Ogg = cdaudio_get_next_flag (FILE_IS_OGG, TRUE, NumTrack);
			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_OGG);
			gtk_list_store_set (var_cd.Adr_List_Store,
						&iter,
						CD_COLUMN_OGG,
						Pixbuf,
						-1);

			Audio->EtatSelection_M4a = cdaudio_get_next_flag (FILE_IS_M4A, TRUE, NumTrack);
			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_M4A);
			gtk_list_store_set (var_cd.Adr_List_Store,
						&iter,
						CD_COLUMN_M4A,
						Pixbuf,
						-1);

			Audio->EtatSelection_Aac = cdaudio_get_next_flag (FILE_IS_AAC, TRUE, NumTrack);
			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_AAC);
			gtk_list_store_set (var_cd.Adr_List_Store,
						&iter,
						CD_COLUMN_AAC,
						Pixbuf,
						-1);

			Audio->EtatSelection_Mpc = cdaudio_get_next_flag (FILE_IS_MPC, TRUE, NumTrack);
			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_MPC);
			gtk_list_store_set (var_cd.Adr_List_Store,
						&iter,
						CD_COLUMN_MPC,
						Pixbuf,
						-1);

			Audio->EtatSelection_Ape = cdaudio_get_next_flag (FILE_IS_APE, TRUE, NumTrack);
			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_APE);
			gtk_list_store_set (var_cd.Adr_List_Store,
						&iter,
						CD_COLUMN_APE,
						Pixbuf,
						-1);

			Audio->EtatSelection_WavPack = cdaudio_get_next_flag (FILE_IS_WAVPACK, TRUE, NumTrack);
			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_WAVPACK);
			gtk_list_store_set (var_cd.Adr_List_Store,
						&iter,
						CD_COLUMN_WAVPACK,
						Pixbuf,
						-1);
			
			cdaudio_set_flag_buttons_audio_cd ();
			gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
			gtk_tree_selection_select_iter (var_cd.Adr_Line_Selected, &iter);
		}
	}

	return (FALSE);
}

/* Edition du contenu d'un champs. La modification sera repercutee dans le Glist 'EnteteCD.GList_Audio_cd'
*  --
*  entree :
*      GtkCellRendererText *cell        :
*      const gchar         *path_string :
*      const gchar         *new_text    :
*      gpointer             data        :
*  retour : -
*/
/*
static void cdaudio_cell_edited_cd (GtkCellRendererText *cell,
					const gchar         *path_string,
					const gchar         *new_text,
					gpointer             data)
{
	GtkTreeModel *model = (GtkTreeModel *)data;
	GtkTreePath  *path = gtk_tree_path_new_from_string (path_string);
	GtkTreeIter   iter;
	gint          column = GPOINTER_TO_INT (g_object_get_data (G_OBJECT (cell), "column"));

	gtk_tree_model_get_iter (model, &iter, path);

	if (column == CD_COLUMN_TRACK_NAME) {
		gint   Num_cell;
		gchar *old_text;
		GList *List = NULL;
		AUDIO *Audio = NULL;

		gtk_tree_model_get (model, &iter, CD_COLUMN_TRACK_NAME, &old_text, -1);
		g_free (old_text);
		old_text = NULL;

		Num_cell = gtk_tree_path_get_indices (path)[0];
		g_free (g_array_index (Articles_cd, ARTICLES_CD, Num_cell).Track_Name);
		g_array_index (Articles_cd, ARTICLES_CD, Num_cell).Track_Name = NULL;
		g_array_index (Articles_cd, ARTICLES_CD, Num_cell).Track_Name = g_strdup (new_text);

		List = g_list_nth (EnteteCD.GList_Audio_cd, Num_cell);
		Audio = List->data;
		if (Audio) {
			if (Audio->NameSong) {
				g_free (Audio->NameSong);
				Audio->NameSong = NULL;
			}
			Audio->NameSong = g_strdup (new_text);
		}

		gtk_list_store_set (GTK_LIST_STORE (model),
					&iter,
					CD_COLUMN_TRACK_NAME,
					g_array_index (Articles_cd, ARTICLES_CD, Num_cell).Track_Name,
					-1);
	}
}
*/

AUDIO *cdaudio_get_line_selected (void)
{
	GtkTreeModel     *model = NULL;
	GList            *List = NULL;
	GtkTreePath      *path;
	AUDIO            *Audio = NULL;
	gint              NumStruct;
	GList            *GList_cd = NULL;

	/* PRINT_FUNC_LF(); */

	if (!var_cd.Adr_TreeView) return (NULL);
	if (!var_cd.Adr_Line_Selected) return (NULL);
	if (!EnteteCD.GList_Audio_cd) return (NULL);

	model = gtk_tree_view_get_model (GTK_TREE_VIEW(var_cd.Adr_TreeView));
	List = gtk_tree_selection_get_selected_rows (var_cd.Adr_Line_Selected, &model);
	
	/* Bug resolu d'apres une description de @plikplok
	 * plikplok@hotmail.com :-> David
	 */
	if (List == NULL) {
		if ((List = g_list_nth (EnteteCD.GList_Audio_cd, 0))) {
			if ((Audio = (AUDIO *)List->data)) {
				return ((AUDIO *)Audio);
			}
		}
	}

	List = g_list_first (List);
	while (List) {
		path = List->data;
		if (path) {
			/* prend le numero de la structure
			*/
			NumStruct = gtk_tree_path_get_indices (path)[0];

			GList_cd = g_list_nth (EnteteCD.GList_Audio_cd, NumStruct);
			Audio = GList_cd->data;
			return ((AUDIO *)Audio);
		}
		List = g_list_next (List);
	}
	return ((AUDIO *)NULL);
}
AUDIO *cdaudio_get_line_selected_for_extract (void)
{
	GList *List = NULL;
	AUDIO *Audio = NULL;

	List = g_list_first (EnteteCD.GList_Audio_cd);
	while (List) {
		if ((Audio = (AUDIO *)List->data) != NULL) {

			if (Audio->EtatSelection_Mp3 >= CD_ETAT_SELECT) return ((AUDIO *)Audio);
			if (Audio->EtatSelection_Ogg >= CD_ETAT_SELECT) return ((AUDIO *)Audio);
			if (Audio->EtatSelection_Wav >= CD_ETAT_SELECT) return ((AUDIO *)Audio);
			if (Audio->EtatSelection_Flac >= CD_ETAT_SELECT) return ((AUDIO *)Audio);
			if (Audio->EtatSelection_M4a >= CD_ETAT_SELECT) return ((AUDIO *)Audio);
			if (Audio->EtatSelection_Aac >= CD_ETAT_SELECT) return ((AUDIO *)Audio);
			if (Audio->EtatSelection_Mpc >= CD_ETAT_SELECT) return ((AUDIO *)Audio);
			if (Audio->EtatSelection_Ape >= CD_ETAT_SELECT) return ((AUDIO *)Audio);
			if (Audio->EtatSelection_WavPack >= CD_ETAT_SELECT) return ((AUDIO *)Audio);
		}
		List = g_list_next(List);
	}
	
	return ((AUDIO *)cdaudio_get_line_selected ());
}

/* Enregistrement de la nouvelle ligne en selection dans la variable 'var_cd.Adr_Line_Selected'
*  --
*  entree :
*      GtkTreeSelection *selection :
*      gpointer          data      :
*  retour : -
*/
void cdaudio_changed_selection_row_file_cd (GtkTreeSelection *selection, gpointer data)
{
	var_cd.Adr_Line_Selected = selection;

	cdexpander_set_sensitive_notebook ();
	cdexpander_set_entry_tag_titre_album ();
	cdexpander_set_entry_tag_nom_artiste ();
	cdexpander_set_spinbutton_tag_annee ();
	cdexpander_set_entry_tag_titre_chanson ();
	cdexpander_set_new_genre ();
	cdexpander_set_entry_tag_commentaire ();
	cdexpander_set_spinbutton_tag_piste ();
	cdexpander_set_entry_tag_titre_fichier_m3u ();
}

gboolean cdaudio_key_press_event_cd (GtkWidget *widget, GdkEventKey *event, gpointer user_data)
{
	return (TRUE);
}

gboolean cdaudio_event (GtkWidget *treeview, GdkEvent *event, gpointer user_data)
{
	gint                x, y;
	GdkModifierType     state;
	GtkTreePath        *path;
	GtkTreeViewColumn  *column;
	GtkTreeIter         iter;
	GtkTreeModel       *model = (GtkTreeModel *)user_data;
	gint                Pos_X = 0, Pos_Y = 0;
	gint                NumTrack;
	gchar              *StrNumTrack;
	AUDIO              *Audio = NULL;
	GList              *GListCD = NULL;

	GtkTreeViewColumn  *ColumnDum;
	gint		    i;

	gboolean            BoolSelectColPlay = FALSE;
	gboolean            BoolSelectColWav = FALSE;
	gboolean            BoolSelectColFlac = FALSE;
	gboolean            BoolSelectColApe = FALSE;
	gboolean            BoolSelectColWavP = FALSE;
	gboolean            BoolSelectColOgg = FALSE;
	gboolean            BoolSelectColM4a = FALSE;
	gboolean            BoolSelectColAac = FALSE;
	gboolean            BoolSelectColMpc = FALSE;
	gboolean            BoolSelectColMp3 = FALSE;
	gboolean            BoolSelectColTime = FALSE;
	gboolean            BoolSelectColNormalise = FALSE;
	gboolean            BoolSelectColNom = FALSE;

	
	/*PRINT_FUNC_LF();*/

	if (keys.eventkey == GDK_KEY_PRESS) {
		return (FALSE);
	}

	if (event->type == GDK_ENTER_NOTIFY) {
		var_cd.cursor_on_num_file = 0;
		var_cd.bool_dedans = TRUE;
		/*PRINT("GDK_ENTER_NOTIFY");*/
	}
	else if (event->type == GDK_LEAVE_NOTIFY) {
		var_cd.cursor_on_num_file = 0;
		var_cd.bool_dedans = FALSE;
		cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, "");
		/*PRINT("GDK_LEAVE_NOTIFY");*/
		return (FALSE);
	}
	else if (event->type == GDK_MOTION_NOTIFY)  {
		var_cd.bool_dedans = TRUE;
		/*PRINT("GDK_MOTION_NOTIFY");*/
	}

	if (var_cd.bool_dedans == FALSE) {
		var_cd.cursor_on_num_file = 0;
		cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, "");
		/*PRINT("var_cd.bool_dedans == FALSE");*/
		return (FALSE);
	}

	/* Si pas de selection a cet endroit retour */
	gdk_window_get_pointer (((GdkEventButton*)event)->window, &x, &y, &state);
	if (!gtk_tree_view_get_path_at_pos (GTK_TREE_VIEW(treeview),
					   x, y,
					   &path, &column, &Pos_X, &Pos_Y)) {
		var_cd.cursor_on_num_file = 0;
		cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, "");
		/*PRINT("Si pas de selection a cet endroit retour");*/
		return (FALSE);
	}

	/* Recuperation de la structure */
	gtk_tree_model_get_iter (model, &iter, path);
	gtk_tree_model_get (var_cd.Adr_Tree_Model, &iter, CD_COLUMN_TRACK_NUM, &StrNumTrack, -1);
	NumTrack = atoi (StrNumTrack);
	GListCD = g_list_nth (EnteteCD.GList_Audio_cd, NumTrack-1);
	if ((Audio = GListCD->data) == NULL) return (FALSE);

	/* IDEE POUR REMPLACER LES COMPARAISON PAR NOMS. EXEMPLES:
	 * 	PLAY	= 0
	 * 	TRASH	= 1
	 *	TYPE	= 2
	 * 	etc ...
	 * NOTA:
	 * 	CET ALGO PERMET DE RENOMMER AISEMENT LES ENTETES DE COLONNES DANS TOUTES LES LANGUES: FR, EN, DE, ...
	 */
	for (i = 0; i < NUM_TREE_ALL_COLUMN; i ++) {
		ColumnDum = gtk_tree_view_get_column (GTK_TREE_VIEW(treeview), i);
		if (ColumnDum == column) {
			/* g_print ("\tNUM IS: %d\n", i); */
			switch ( i ) {
			case NUM_TREE_Play :		BoolSelectColPlay		= TRUE;	break;
			case NUM_TREE_Wav :		BoolSelectColWav		= TRUE;	break;
			case NUM_TREE_Flac :		BoolSelectColFlac		= TRUE;	break;
			case NUM_TREE_Ape :		BoolSelectColApe		= TRUE;	break;
			case NUM_TREE_WavP :		BoolSelectColWavP		= TRUE;	break;
			case NUM_TREE_Ogg :		BoolSelectColOgg		= TRUE;	break;
			case NUM_TREE_M4a :		BoolSelectColM4a		= TRUE;	break;
			case NUM_TREE_Aac :		BoolSelectColAac		= TRUE;	break;
			case NUM_TREE_Mpc :		BoolSelectColMpc		= TRUE;	break;
			case NUM_TREE_Mp3 :		BoolSelectColMp3		= TRUE;	break;
			case NUM_TREE_Num :							break;
			case NUM_TREE_Time :		BoolSelectColTime		= TRUE;	break;
			case NUM_TREE_Normalise :	BoolSelectColNormalise		= TRUE;	break;
			case NUM_TREE_Nom :		BoolSelectColNom		= TRUE;	break;
			
			default: return (FALSE);
			}
			/* La colonne est trouvee ... sortie de la boucle */
			break;
		}
	}

	if (BoolSelectColNormalise == TRUE) {
		utils_set_mess_from_cd_ETAT_NORMALISE_CD (Audio->EtatNormalise);
	}
	else if (BoolSelectColNom == TRUE) {

		gchar *path = NULL;
		gchar *pathdest = NULL;

		if (var_cd.cursor_on_num_file == NumTrack) return (FALSE);
		var_cd.cursor_on_num_file = NumTrack;
		pathdest = cdaudio_get_result_destination (Audio->tags);
		path = g_strdup_printf ("%s/%s", pathdest, Audio->NameSong);
		g_free (pathdest);
		pathdest = NULL;
		cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, path);
		g_free (path);
		path = NULL;
	}
	else if (BoolSelectColPlay == TRUE ||
		 BoolSelectColFlac == TRUE ||
		 BoolSelectColWav == TRUE ||
		 BoolSelectColMp3 == TRUE ||
		 BoolSelectColOgg == TRUE ||
		 BoolSelectColM4a == TRUE ||
		 BoolSelectColAac == TRUE ||
		 BoolSelectColMpc == TRUE ||
		 BoolSelectColApe == TRUE ||
		 BoolSelectColWavP == TRUE) {

		/* position du curseur a l'instant du click */
		if (Pos_X < 18 || Pos_X > 30 || Pos_Y < 8 || Pos_Y > 20) {
			var_cd.cursor_on_num_file = 0;
			cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, "");
			return (FALSE);
		}

		if (BoolSelectColPlay == TRUE) {
			utils_set_prg_not_found ("MPLAYER", PrgInit.bool_mplayer);
			utils_set_mess_from_cd_ETAT_PLAY_CD (Audio->EtatPlay);
		}
		else if (BoolSelectColFlac == TRUE) {
			utils_set_prg_not_found ("FLAC", PrgInit.bool_flac);
			utils_set_mess_from_cd_ETAT_SELECTION_CD (Audio->EtatSelection_Flac);
		}
		else if (BoolSelectColWav == TRUE) {
			if (options_extract_by () == EXTRACT_WITH_CDDA2WAV)
				utils_set_prg_not_found ("CDDA2WAV", PrgInit.bool_cdda2wav);
			else	utils_set_prg_not_found ("CDPARANOIA", PrgInit.bool_cdparanoia);

			utils_set_mess_from_cd_ETAT_SELECTION_CD (Audio->EtatSelection_Wav);
		}
		else if (BoolSelectColMp3 == TRUE) {
			utils_set_prg_not_found ("LAME", PrgInit.bool_lame);
			utils_set_mess_from_cd_ETAT_SELECTION_CD (Audio->EtatSelection_Mp3);
		}
		else if (BoolSelectColOgg == TRUE) {
			utils_set_prg_not_found ("OGGENC", PrgInit.bool_oggenc);
			utils_set_mess_from_cd_ETAT_SELECTION_CD (Audio->EtatSelection_Ogg);
		}
		else if (BoolSelectColM4a == TRUE) {
			utils_set_prg_not_found ("FAAC", PrgInit.bool_faac);
			utils_set_mess_from_cd_ETAT_SELECTION_CD (Audio->EtatSelection_M4a);
		}
		else if (BoolSelectColAac == TRUE) {
			utils_set_prg_not_found ("AACPLUSENC", PrgInit.bool_aacplusenc);
			utils_set_mess_from_cd_ETAT_SELECTION_CD (Audio->EtatSelection_Aac);
		}
		else if (BoolSelectColMpc == TRUE) {
			utils_set_prg_not_found ("MPPENC", PrgInit.bool_mppenc);
			utils_set_mess_from_cd_ETAT_SELECTION_CD (Audio->EtatSelection_Mpc);
		}
		else if (BoolSelectColApe == TRUE) {
			utils_set_prg_not_found ("MAC", PrgInit.bool_ape);
			utils_set_mess_from_cd_ETAT_SELECTION_CD (Audio->EtatSelection_Ape);
		}
		else if (BoolSelectColWavP == TRUE) {
			utils_set_prg_not_found ("WAVPACK", PrgInit.bool_wavpack);
			utils_set_mess_from_cd_ETAT_SELECTION_CD (Audio->EtatSelection_WavPack);
		}
	}
	else {
		var_cd.cursor_on_num_file = 0;
		cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, "");
	}

	return (FALSE);
}

void cdaudio_selected_column (GtkTreeViewColumn *treeviewcolumn, gpointer user_data)
{
	gint		NumColonne = GPOINTER_TO_INT(user_data);
	TYPE_FILE_IS	TypeFileIs = FILE_IS_NONE;
	
	/*
	PRINT_FUNC_LF();
	g_print("\tNumColonne = %d\n", NumColonne);
	g_print("\t\tA CODER\n");
	*/
	switch (NumColonne) {
	case 0 : TypeFileIs = FILE_IS_WAV;	break;
	case 1 : TypeFileIs = FILE_IS_FLAC;	break;
	case 2 : TypeFileIs = FILE_IS_APE;	break;
	case 3 : TypeFileIs = FILE_IS_WAVPACK;	break;
	case 4 : TypeFileIs = FILE_IS_OGG;	break;
	case 5 : TypeFileIs = FILE_IS_M4A;	break;
	case 6 : TypeFileIs = FILE_IS_AAC;	break;
	case 7 : TypeFileIs = FILE_IS_MPC;	break;
	case 8 : TypeFileIs = FILE_IS_MP3;	break;
	case 9 : TypeFileIs = FILE_TO_NORMALISE;break;
	}

	cdaudio_change_all_flags_extract_verticaly (TypeFileIs);
	cdaudio_set_flag_buttons_audio_cd ();
}

/* Creation des champs du 'treeview'
*  --
*  entree :
*      GtkTreeView *treeview :
*  retour : -
*/
static void cdaudio_add_columns_scrolledwindow_cd (GtkTreeView *treeview)
{
	GtkTreeModel      *model = gtk_tree_view_get_model (treeview);
	GtkCellRenderer   *renderer;
	GtkTreeViewColumn *column;

	/* PRINT_FUNC_LF(); */

	var_cd.cursor_on_num_file = 0;
	var_cd.bool_dedans = FALSE;

	/* SIGNAL : 'event'
	*/
	g_signal_connect(G_OBJECT(treeview),
			 "event",
                    	 (GCallback) cdaudio_event,
			 model);

	/* SIGNAL 'key-press-event'
	*/
	g_signal_connect(G_OBJECT(treeview),
			 "key-press-event",
                    	 (GCallback) cdaudio_key_press_event_cd,
			 model);

	/* SIGNAL 'button-press-event'
	*/
	g_signal_connect(G_OBJECT(treeview),
			 "button-press-event",
                    	 (GCallback) cdaudio_event_click_mouse_cd,
			 model);

	/* Ligne actuellement selectionnee
	*/
	var_cd.Adr_Line_Selected = gtk_tree_view_get_selection(GTK_TREE_VIEW(treeview));
	g_signal_connect(G_OBJECT(var_cd.Adr_Line_Selected),
			 "changed",
                   	 G_CALLBACK(cdaudio_changed_selection_row_file_cd),
                   	 "1");
                   	/* model);*/

	/* CD_COLUMN_PLAY
	*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_cd.Adr_Column_Play =
	column = gtk_tree_view_column_new_with_attributes (
							_("Play"),
							renderer,
							"pixbuf", CD_COLUMN_PLAY,
							NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);

	/*
	@Patachon, @Shankarius, @Dzef
	
	Je plaide aussi pour la réunion logique des formats lossless puis des
	autres. Je propose : 

	    lossless     |       perte      | destruction forte
	<================>
	                 <============================>
					    <=========>
	Wav | Flac | Ape | WPack | Ogg | M4a | Mpc | Mp3

	Je conviens qu'il n'est pas facile de classer, car certains formats sont
	capables d'être utilisés en lossless ou en moindre qualité. Ce n'est
	donc pas vraiment linéaire. Mais c'est une piste...
	
	Wav
	Flac
	Ape
	WPack
	Ogg
	M4a
	Mpc
	Mp3
	*/
	
	/* CD_COLUMN_WAV
	*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_cd.Adr_Column_Wav =
	column = gtk_tree_view_column_new_with_attributes (
							_("Wav"),
							renderer,
							"pixbuf", CD_COLUMN_WAV,
							/*"text", CD_COLUMN_WAV,*/
							NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);
	g_signal_connect (G_OBJECT(GTK_TREE_VIEW_COLUMN (column)),
			"clicked",
			G_CALLBACK (cdaudio_selected_column),
			GINT_TO_POINTER(0));

	/* CD_COLUMN_FLAC
	*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_cd.Adr_Column_Flac =
	column = gtk_tree_view_column_new_with_attributes (
							_("Flac"),
						 	renderer,
							"pixbuf", CD_COLUMN_FLAC,
							NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);
	g_signal_connect (G_OBJECT(GTK_TREE_VIEW_COLUMN (column)),
			"clicked",
			G_CALLBACK (cdaudio_selected_column),
			GINT_TO_POINTER(1));

	/* CD_COLUMN_APE
	*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_cd.Adr_Column_Ape =
	column = gtk_tree_view_column_new_with_attributes (
							_("Ape"),
							renderer,
							"pixbuf", CD_COLUMN_APE,
							NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);
	g_signal_connect (G_OBJECT(GTK_TREE_VIEW_COLUMN (column)),
			"clicked",
			G_CALLBACK (cdaudio_selected_column),
			GINT_TO_POINTER(2));

	/* CD_COLUMN_WAVPACK
	*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_cd.Adr_Column_Wavpack =
	column = gtk_tree_view_column_new_with_attributes (
							_("WavP"),
							renderer,
							"pixbuf", CD_COLUMN_WAVPACK,
						 	NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);
	g_signal_connect (G_OBJECT(GTK_TREE_VIEW_COLUMN (column)),
			"clicked",
			G_CALLBACK (cdaudio_selected_column),
			GINT_TO_POINTER(3));

	/* CD_COLUMN_OGG
	*/
	/*renderer = gtk_cell_renderer_text_new ();*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_cd.Adr_Column_Ogg =
	column = gtk_tree_view_column_new_with_attributes (
							_("Ogg"),
							renderer,
							"pixbuf", CD_COLUMN_OGG,
							/*"text", CD_COLUMN_OGG,*/
							NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);
	g_signal_connect (G_OBJECT(GTK_TREE_VIEW_COLUMN (column)),
			"clicked",
			G_CALLBACK (cdaudio_selected_column),
			GINT_TO_POINTER(4));

	/* CD_COLUMN_M4A
	*/
	/*renderer = gtk_cell_renderer_text_new ();*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_cd.Adr_Column_M4a =
	column = gtk_tree_view_column_new_with_attributes (
							_("M4a"),
							renderer,
							"pixbuf", CD_COLUMN_M4A,
							/*"text", CD_COLUMN_OGG,*/
							NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);
	g_signal_connect (G_OBJECT(GTK_TREE_VIEW_COLUMN (column)),
			"clicked",
			G_CALLBACK (cdaudio_selected_column),
			GINT_TO_POINTER(5));

	/* CD_COLUMN_AAC
	*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_cd.Adr_Column_Aac =
	column = gtk_tree_view_column_new_with_attributes (
							_("Aac"),
							renderer,
							"pixbuf", CD_COLUMN_AAC,
							NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);
	g_signal_connect (G_OBJECT(GTK_TREE_VIEW_COLUMN (column)),
			"clicked",
			G_CALLBACK (cdaudio_selected_column),
			GINT_TO_POINTER(6));
	
	/* CD_COLUMN_MPC
	*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_cd.Adr_Column_Mpc =
	column = gtk_tree_view_column_new_with_attributes (
							_("Mpc"),
							renderer,
							"pixbuf", CD_COLUMN_MPC,
							NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);
	g_signal_connect (G_OBJECT(GTK_TREE_VIEW_COLUMN (column)),
			"clicked",
			G_CALLBACK (cdaudio_selected_column),
			GINT_TO_POINTER(7));

	/* CD_COLUMN_MP3
	*/
	/*renderer = gtk_cell_renderer_text_new ();*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_cd.Adr_Column_Mp3 =
	column = gtk_tree_view_column_new_with_attributes (
							_("Mp3"),
							renderer,
						  	"pixbuf", CD_COLUMN_MP3,
							/*"text", CD_COLUMN_MP3,*/
							NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);
	g_signal_connect (G_OBJECT(GTK_TREE_VIEW_COLUMN (column)),
			"clicked",
			G_CALLBACK (cdaudio_selected_column),
			GINT_TO_POINTER(8));

	/* CD_COLUMN_TRACK_NUM
	*/
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_cd.Adr_Column_Num =
	column = gtk_tree_view_column_new_with_attributes (
							_("Num"),
							renderer,
							"text", CD_COLUMN_TRACK_NUM,
							NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);

	/* CD_COLUMN_TRACK_TIME
	*/
	renderer = gtk_cell_renderer_text_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_cd.Adr_Column_Time =
	column = gtk_tree_view_column_new_with_attributes (
							_("Time"),
							renderer,
							"text", CD_COLUMN_TRACK_TIME,
						 	NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);

	/* CD_COLUMN_FILE_NORMALIZE
	*/
	renderer = gtk_cell_renderer_pixbuf_new ();
	g_object_set (renderer, "xalign", 0.5, NULL);
	var_cd.Adr_Column_Normalise =
	column = gtk_tree_view_column_new_with_attributes (
							_("Normalise"),
							renderer,
							"pixbuf", CD_COLUMN_FILE_NORMALIZE,
							NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 100);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
	gtk_tree_view_column_set_clickable (GTK_TREE_VIEW_COLUMN (column), TRUE);
	g_signal_connect (G_OBJECT(GTK_TREE_VIEW_COLUMN (column)),
			"clicked",
			G_CALLBACK (cdaudio_selected_column),
			GINT_TO_POINTER(9));

	/* CD_COLUMN_TRACK_NAME
	*  CF_COLUMN_EDITABLE
	*/
	var_cd.renderer =
	renderer = gtk_cell_renderer_text_new ();
	/*
	g_signal_connect (renderer, "edited", G_CALLBACK (cdaudio_cell_edited_cd), model);
	*/
	g_object_set (renderer, "xalign", 0.5, NULL);
	g_object_set_data (G_OBJECT (renderer), "column", (gint *)CD_COLUMN_TRACK_NAME);
	var_cd.Adr_Column_Nom =
	column = gtk_tree_view_column_new_with_attributes (
							_("Nom"),
							renderer,
							"text", CD_COLUMN_TRACK_NAME,
							/* "editable", CF_COLUMN_EDITABLE */
						 	NULL);
	gtk_tree_view_column_set_sizing (GTK_TREE_VIEW_COLUMN (column),
				   GTK_TREE_VIEW_COLUMN_FIXED);
	gtk_tree_view_column_set_fixed_width (GTK_TREE_VIEW_COLUMN (column), 50);
	gtk_tree_view_column_set_alignment (GTK_TREE_VIEW_COLUMN (column), 0.5);
	gtk_tree_view_append_column (treeview, column);
}

/* Recherche du fichiers 'NameFilePixbuf' et retourne l'etat
*  --
*  entree :
*      char *NameFilePixbuf :
*  retour :
*      GdkPixbuf * :
*/
GdkPixbuf *cdaudio_init_pixbufs_cd (char *NameFilePixbuf)
{
	GdkPixbuf *NewPixbuf = NULL;
	GError    *error = NULL;
	gchar     *Pathname_Pixbuf = NULL;

	/* PRINT_FUNC_LF(); */

	Pathname_Pixbuf = utils_get_pathname (NameFilePixbuf);

	/* load pixbuf */
	NewPixbuf = gdk_pixbuf_new_from_file(Pathname_Pixbuf, &error);
 	if (error) {
		g_critical ("Could not load pixbuf: %s\n", error->message);
		g_error_free (error);
		g_free (Pathname_Pixbuf);
		Pathname_Pixbuf = NULL;
		return (NULL);
	}

	g_free (Pathname_Pixbuf);
	Pathname_Pixbuf = NULL;

	return (NewPixbuf);
}

/* Creation du context
*  --
*  entree :
*      GtkWidget *widget :
*  retour : -
*/
void cdaudio_scrolledwindow_cd_realize (GtkWidget *widget)
{
	GtkListStore *store;
	GtkTreeModel *model;
	GtkWidget    *treeview;

	/* PRINT_FUNC_LF(); */

	var_cd.Adr_scroll = widget;

	var_cd.Pixbuf_Coche                 = cdaudio_init_pixbufs_cd ("coche.png");
	var_cd.Pixbuf_Coche_exist           = cdaudio_init_pixbufs_cd ("coche_exist.png");
	var_cd.Pixbuf_Selected              = cdaudio_init_pixbufs_cd ("selected.png");
	var_cd.Pixbuf_Selected_exist        = cdaudio_init_pixbufs_cd ("selected_exist.png");
	var_cd.Pixbuf_Selected_expert       = cdaudio_init_pixbufs_cd ("selected_expert.png");
	var_cd.Pixbuf_Selected_expert_exist = cdaudio_init_pixbufs_cd ("selected_expert_exist.png");
	var_cd.Pixbuf_CdPlay                = cdaudio_init_pixbufs_cd ("sol.png");
	var_cd.Pixbuf_CdStop                = cdaudio_init_pixbufs_cd ("no_play.png");
	var_cd.Pixbuf_Normalize             = cdaudio_init_pixbufs_cd ("norm_rpg_wait.png");
	var_cd.Pixbuf_Normalize_Coche       = cdaudio_init_pixbufs_cd ("normalize2.png");
	var_cd.Pixbuf_NotInstall            = cdaudio_init_pixbufs_cd ("not_install.png");

	Articles_cd = g_array_sized_new (FALSE, FALSE, sizeof (ARTICLES_CD), 1);

	var_cd.Adr_List_Store = store =
	gtk_list_store_new (	CD_NUM_COLUMNS,		/* TOTAL NUMBER */
				GDK_TYPE_PIXBUF,	/* CD_COLUMN_PLAY */
				GDK_TYPE_PIXBUF,	/* CD_COLUMN_FLAC */
				GDK_TYPE_PIXBUF,	/* CD_COLUMN_WAV */
				GDK_TYPE_PIXBUF,	/* CD_COLUMN_MP3 */
				GDK_TYPE_PIXBUF,	/* CD_COLUMN_OGG */
				GDK_TYPE_PIXBUF,	/* CD_COLUMN_M4A */
				GDK_TYPE_PIXBUF,	/* CD_COLUMN_AAC */
				GDK_TYPE_PIXBUF,	/* CD_COLUMN_MPC */
				GDK_TYPE_PIXBUF,	/* CD_COLUMN_APE */
				GDK_TYPE_PIXBUF,	/* CD_COLUMN_WAVPACK */
				G_TYPE_STRING,		/* CD_COLUMN_TRACK_NUM  */
				G_TYPE_STRING,		/* CD_COLUMN_TRACK_TIME */
				GDK_TYPE_PIXBUF,	/* CD_COLUMN_FILE_NORMALIZE */
				G_TYPE_STRING,		/* CD_COLUMN_TRACK_NAME */
				G_TYPE_BOOLEAN
			   );

	var_cd.Adr_Tree_Model = model = GTK_TREE_MODEL (store);

	/* creation de tree view
	 */
	var_cd.Adr_TreeView =
	treeview = gtk_tree_view_new_with_model (model);
	gtk_tree_view_set_rules_hint (GTK_TREE_VIEW (treeview), TRUE);
	g_object_unref (model);
	gtk_container_add (GTK_CONTAINER (widget), treeview);
	cdaudio_add_columns_scrolledwindow_cd (GTK_TREE_VIEW (treeview));

	gtk_widget_show_all (widget);
}


/*
*---------------------------------------------------------------------------
* ONGLET CD-AUDIO -> ACTION
*---------------------------------------------------------------------------
*/

/* Insertion d'un numero de serie unique au debut des noms de piste. Cela permet, par exemple pour
*  une operation de gravure ulterieure d'un cd 'WAV' de reprendre les pistes dans le meme ordre.
*  --
*  entree : -
*  retour : -
*/
gboolean cdaudio_template_valid (void)
{
	gchar *ptr = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_new_titre_cdaudio));

	while (*ptr) {
		if (*ptr == '%' &&
			(*(ptr +1) == 'a' || *(ptr +1) == 'b' || *(ptr +1) == 'c' || *(ptr +1) == 'd' || *(ptr +1) == 'e')) {
			return (TRUE);
		}
		ptr ++;
	}
	return (FALSE);
}

gboolean bool_entree_cd_verif_car = TRUE;

void cdaudio_set_titre_chanson (void)
{
	gint		 Num_cell = 0;
	gboolean	 valid;
	GtkTreeIter	 iter;
	GList		*List = NULL;
	gchar		*ptr_template = NULL;
	gchar		*ptr = NULL;
	AUDIO		*Audio = NULL;
	gchar		*StrLine = NULL;
	
	// PRINT_FUNC_LF();

	if (var_cd.Adr_entry_new_titre_cdaudio == NULL) return;
	if (EnteteCD.GList_Audio_cd == NULL) return;
	if (bool_entree_cd_verif_car == FALSE) return;
	ptr_template = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_new_titre_cdaudio));

	/**/
	var_cd.Bool_create_file_m3u = FALSE;
		
	valid = gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
	while (valid) {
		
		List = g_list_nth (EnteteCD.GList_Audio_cd, Num_cell);
		if ((Audio = (AUDIO *)List->data)) {

			// POINTEUR SUR LIGNE PARSEE
			StrLine = Parse_get_line (PARSE_TYPE_TITLE_CD, Num_cell);
			
			/* free 'Track_Name' */
			g_free (g_array_index (Articles_cd, ARTICLES_CD, Num_cell).Track_Name);
			g_array_index (Articles_cd, ARTICLES_CD, Num_cell).Track_Name = NULL;

			// SUPPRESSION DES ESPACES DE DEBUT
			ptr = StrLine;
			while (*ptr == ' ') ptr ++;
			strcpy (StrLine, ptr);
			// SUPPRESSION DES ESPACES DE FIN
			ptr = StrLine;
			while (*ptr) ptr ++;
			ptr --;
			while (*ptr == ' ') ptr --;
			ptr ++;
			*ptr = '\0';
			
			g_array_index (Articles_cd, ARTICLES_CD, Num_cell).Track_Name = g_strdup (StrLine);

			if (Audio->NameSong) {
				g_free (Audio->NameSong);
				Audio->NameSong = NULL;
			}
			Audio->NameSong = g_strdup (StrLine);

			// AFFICHAGE
			gtk_list_store_set (GTK_LIST_STORE (var_cd.Adr_Tree_Model),
						&iter,
						CD_COLUMN_TRACK_NAME,
						/*g_array_index (Articles_cd, ARTICLES_CD, Num_cell).Track_Name,*/
						StrLine,
						-1);
			
			g_free (StrLine);
			StrLine = NULL;
		}
		/* suivant */
		valid = gtk_tree_model_iter_next (var_cd.Adr_Tree_Model, &iter);
		Num_cell ++;
	}

	cdaudio_entry_stockage_cdaudio_changed ();
}


gchar *cdaudio_get_titre_chanson (AUDIO *Audio, gint Num_cell)
{
	gchar        *StrLine = NULL;

	// PRINT_FUNC_LF();

	if (EnteteCD.GList_Audio_cd == NULL) return ((gchar *)NULL);
	if (var_cd.Adr_entry_new_titre_cdaudio == NULL) return ((gchar *)NULL);

	var_cd.Bool_create_file_m3u = FALSE;
	
	StrLine = Parse_get_line (PARSE_TYPE_TITLE_CD, Num_cell);
	
	if (Audio->NameSong != NULL) {
		g_free (Audio->NameSong);
		Audio->NameSong = NULL;
	}
	Audio->NameSong = g_strdup (StrLine);
	return ((gchar* )Audio->NameSong);
}


/* Deallocation complete des lignes du context
*  --
*  entree : -
*  retour : -
*/
void cdaudio_deallocate_glist_context (void)
{
	gint          Num_cell;
	gboolean      valid;
	GtkTreeIter   iter;

	// PRINT_FUNC_LF();

	Num_cell = 0;
	valid = gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
	while (valid) {

		g_free (g_array_index (Articles_cd, ARTICLES_CD, Num_cell).Track_Num);
		
		g_array_index (Articles_cd, ARTICLES_CD, Num_cell).Track_Num = NULL;
		g_free (g_array_index (Articles_cd, ARTICLES_CD, Num_cell).Track_Time);
		
		g_array_index (Articles_cd, ARTICLES_CD, Num_cell).Track_Time = NULL;
		
		g_free (g_array_index (Articles_cd, ARTICLES_CD, Num_cell).Track_Name);
		g_array_index (Articles_cd, ARTICLES_CD, Num_cell).Track_Name = NULL;

		valid = gtk_tree_model_iter_next (var_cd.Adr_Tree_Model, &iter);
		Num_cell ++;
	}
}


GdkPixbuf *cdaudio_get_pixbuf_play (AUDIO *Audio)
{
	GdkPixbuf *PixBuf = NULL;

	/*PRINT_FUNC_LF();*/
	if (PrgInit.bool_mplayer == FALSE) {
		utils_set_prg_not_found ("MPLAYER", PrgInit.bool_mplayer);
		PixBuf = var_cd.Pixbuf_NotInstall;
	}
	else {
		if (Audio->EtatPlay == CD_ETAT_PLAY)		PixBuf = var_cd.Pixbuf_CdPlay;
		if (Audio->EtatPlay == CD_ETAT_PLAY_ATTENTE)	PixBuf = var_cd.Pixbuf_CdStop;
	}
	return ((GdkPixbuf *)PixBuf);
}
GdkPixbuf *cdaudio_get_pixbuf_normalize (AUDIO *Audio)
{
	GdkPixbuf *PixBuf = NULL;

	/* PRINT_FUNC_LF(); */
	if (PrgInit.bool_normalize == FALSE) {
		// utils_set_prg_not_found (PrgInit.name_normalize, PrgInit.bool_normalize);
		utils_set_prg_not_found (prginit_get_name (NMR_normalize), PrgInit.bool_normalize);
		PixBuf = var_cd.Pixbuf_NotInstall;
	}
	else {
		PixBuf = var_cd.Pixbuf_Normalize;
	}
	return ((GdkPixbuf *)PixBuf);
}

/* Reaffichage complet du context depuis les datas du GList 'EnteteCD.GList_Audio_cd'
*  --
*  entree : -
*  retour : -
*/
void cdaudio_affiche_glist_audio_cd (void)
{
	GList           *List = NULL;
	AUDIO           *Audio = NULL;
	GtkAdjustment   *Adj = NULL;
	GtkTreeIter      iter;
	ARTICLES_CD      Foo;
	gint             NumTrack;

	/* PRINT_FUNC_LF(); */

	cdaudio_deallocate_glist_context ();
	gtk_list_store_clear (var_cd.Adr_List_Store);

	/* Mise a jour du scroll vertical
	*/
	Adj = gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW (var_cd.Adr_scroll));
	/*
	g_print ("Adj->value %f\n", Adj->value);
	g_print ("Adj->lower %f\n", Adj->lower);
	g_print ("Adj->upper %f\n", Adj->upper);
	g_print ("Adj->step_increment %f\n", Adj->step_increment);
	g_print ("Adj->page_increment %f\n", Adj->page_increment);
	g_print ("Adj->page_size %f\n", Adj->page_size);
	*/
	gtk_adjustment_set_value (Adj, 0.0);
	gtk_scrolled_window_set_vadjustment (GTK_SCROLLED_WINDOW (var_cd.Adr_scroll), Adj);

	List = g_list_first (EnteteCD.GList_Audio_cd);
	while (List) {
		if ((Audio = (AUDIO *)List->data) != NULL) {

			NumTrack = (gint)g_strtod (Audio->Str_Track, NULL);
			NumTrack --;

			if (Audio->EtatPlay == CD_ETAT_PLAY)			Foo.PlayTrack  = var_cd.Pixbuf_CdPlay;
			else if (Audio->EtatPlay == CD_ETAT_PLAY_ATTENTE)	Foo.PlayTrack  = var_cd.Pixbuf_CdStop;

			Foo.PlayTrack  = cdaudio_get_pixbuf_play (Audio);

			Foo.Track_Name        = g_strdup ((gchar *)cdaudio_get_titre_chanson (Audio, NumTrack));
			Foo.Flac              = cdaudio_get_pixbuf_file (Audio, FILE_IS_FLAC);
			Foo.Wav               = cdaudio_get_pixbuf_file (Audio, FILE_IS_WAV);
			Foo.Mp3               = cdaudio_get_pixbuf_file (Audio, FILE_IS_MP3);
			Foo.Ogg               = cdaudio_get_pixbuf_file (Audio, FILE_IS_OGG);
			Foo.M4a               = cdaudio_get_pixbuf_file (Audio, FILE_IS_M4A);
			Foo.Aac               = cdaudio_get_pixbuf_file (Audio, FILE_IS_AAC);
			Foo.Mpc               = cdaudio_get_pixbuf_file (Audio, FILE_IS_MPC);
			Foo.Ape               = cdaudio_get_pixbuf_file (Audio, FILE_IS_APE);
			Foo.WavPack           = cdaudio_get_pixbuf_file (Audio, FILE_IS_WAVPACK);
			Foo.Track_Num         = g_strdup (Audio->Str_Track);
			Foo.Track_Time        = g_strdup (Audio->Duree);
			Foo.ColumnCDNormalize = cdaudio_get_pixbuf_file (Audio, FILE_TO_NORMALISE);
			Foo.Editable          = TRUE;

			g_array_append_vals (Articles_cd, &Foo, 1);

			gtk_list_store_append (var_cd.Adr_List_Store, &iter);

			gtk_list_store_set (
				var_cd.Adr_List_Store, &iter,
				CD_COLUMN_PLAY,			Foo.PlayTrack,
				CD_COLUMN_FLAC,			Foo.Flac,
				CD_COLUMN_WAV,			Foo.Wav,
				CD_COLUMN_MP3,			Foo.Mp3,
				CD_COLUMN_OGG,			Foo.Ogg,
				CD_COLUMN_M4A,			Foo.M4a,
				CD_COLUMN_AAC,			Foo.Aac,
				CD_COLUMN_MPC,			Foo.Mpc,
				CD_COLUMN_APE,			Foo.Ape,
				CD_COLUMN_WAVPACK,		Foo.WavPack,
				CD_COLUMN_TRACK_NUM,		Foo.Track_Num,
				CD_COLUMN_TRACK_TIME,		Foo.Track_Time,
				CD_COLUMN_FILE_NORMALIZE,	Foo.ColumnCDNormalize,
				CD_COLUMN_TRACK_NAME,		Foo.Track_Name,
				CF_COLUMN_EDITABLE,		Foo.Editable,
				-1);
		}
		List = g_list_next(List);
	}

	cdaudio_set_titre_chanson ();

	utils_put_error_statusbar (FALSE);

	/* select line number one
	*/
	if (EnteteCD.GList_Audio_cd) {
		gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
		gtk_tree_selection_select_iter (var_cd.Adr_Line_Selected, &iter);
	}
}

gboolean  BoolEntercdaudio_update_glist_audio_cd = FALSE;

void cdaudio_update_glist_audio_cd (void)
{
	AUDIO           *Audio = NULL;
	GdkPixbuf       *Pixbuf = NULL;
	GList           *List = NULL;
	gboolean         valid;
	GtkTreeIter      iter;
	gint             NumTrack = 0;
	
	if (!var_cd.Adr_Tree_Model) return;
	if (BoolEntercdaudio_update_glist_audio_cd == TRUE) {
		PRINT("ENTREE REFUSEE");
		return;
	}
	BoolEntercdaudio_update_glist_audio_cd = TRUE;

	valid = gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
	while (valid) {
		List = g_list_nth (EnteteCD.GList_Audio_cd, NumTrack);
		if (List && (Audio = (AUDIO *)List->data)) {

			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_WAV);
			gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_WAV, Pixbuf, -1);

			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_FLAC);
			gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_FLAC, Pixbuf, -1);

			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_APE);
			gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_APE, Pixbuf, -1);

			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_WAVPACK);
			gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_WAVPACK, Pixbuf, -1);

			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_OGG);
			gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_OGG, Pixbuf, -1);

			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_M4A);
			gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_M4A, Pixbuf, -1);

			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_AAC);
			gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_AAC, Pixbuf, -1);

			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_MPC);
			gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_MPC, Pixbuf, -1);

			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_MP3);
			gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_MP3, Pixbuf, -1);

			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_TO_NORMALISE);
			gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_FILE_NORMALIZE, Pixbuf, -1);			

			NumTrack ++;
		}
		valid = gtk_tree_model_iter_next (var_cd.Adr_Tree_Model, &iter);
	}

	BoolEntercdaudio_update_glist_audio_cd = FALSE;
}

/* Deallocation complete du GList 'EnteteCD.GList_Audio_cd'
*  --
*  entree : -
*  retour : -
*/
void cdaudio_deallocate_glist_cd (void)
{
	AUDIO *Audio = NULL;
	GList *List = NULL;

	/* PRINT_FUNC_LF(); */

	/* Deallocate ENTETE
	*/
	g_free (EnteteCD.TitleCD);	EnteteCD.TitleCD = NULL;
	g_free (EnteteCD.Duree_cd);	EnteteCD.Duree_cd = NULL;
	g_free (EnteteCD.StrGenre);	EnteteCD.StrGenre = NULL;
	g_free (EnteteCD.StrYear);	EnteteCD.StrYear = NULL;
	g_free (EnteteCD.Message);	EnteteCD.Message = NULL;

	/* Deallocate ALLs struct Audio in GList_Audio_cd
	*/
	List = g_list_first (EnteteCD.GList_Audio_cd);
	while (List) {
		if ((Audio = (AUDIO *)List->data)) {

			g_free (Audio->Str_Track);
			g_free (Audio->NameSong);
			g_free (Audio->Duree);

			g_free (Audio->PathName_Dest_Wav);
			g_free (Audio->PathName_Dest_Mp3);
			g_free (Audio->PathName_Dest_Ogg);

			Audio->tags = (TAGS *)tags_remove (Audio->tags);

			g_free (Audio);
			Audio = NULL;
			List->data = NULL;
		}
		List = g_list_next(List);
	}

	/* Deallocate GList_Audio_cd
	*/
	g_list_free (EnteteCD.GList_Audio_cd);
	EnteteCD.GList_Audio_cd = NULL;
}

/* Le flag 'STATUS_LABEL HideShow' permet de cacher ou d'activer le statusbar
*  La chaine 'gchar *Messag' sera affichee a l'endroit 'TYPE_LABEL TypeLabel'
*  --
*  entree :
*      TYPE_LABEL TypeLabel  :
*      STATUS_LABEL HideShow :
*      gchar *Messag         :
*  retour : -
*/
void cdaudio_put_label_status_bar_cd (TYPE_LABEL TypeLabel, STATUS_LABEL HideShow, gchar *Messag)
{
	gchar     *New_Str = NULL;
	GtkWidget *widget = NULL;
	gint       SizeFont = SIZE_CAR_STATUSBAR;

	/* PRINT_FUNC_LF(); */

	switch (TypeLabel) {
	case _DUREE_ :
		widget = var_cd.Adr_Label_Duree;
		if (Messag)
			New_Str = g_strdup_printf (" <span font_desc=\"sans %d\"><span color=\"black\"><b>%s</b></span></span>", SizeFont, Messag);
		else    New_Str = g_strdup (" <b></b>");
		break;
	case _TITRE_ :
		widget = var_cd.Adr_Label_Titre;
		if (Messag)
			New_Str = g_strdup_printf (" <span font_desc=\"sans %d\"><span color=\"black\"><b>%s</b></span></span>", SizeFont, Messag);
		else    New_Str = g_strdup (" <b></b>");
		break;
	case _INFO_  :
		widget = var_utils.AdrLabelStatusbarGlobal;
		if (Messag)
			New_Str = g_strdup_printf (" <span font_desc=\"sans %d\"><span color=\"black\"><b>%s</b></span></span>", SizeFont, Messag);
		else    New_Str = g_strdup (" <b></b>");
		break;
	}

	if (HideShow == _HIDE_) {
		gtk_label_set_markup (GTK_LABEL (widget), New_Str);
		gtk_widget_hide (GTK_WIDGET (widget));
	}
	else {
		gtk_widget_show (GTK_WIDGET (widget));
		gtk_label_set_markup (GTK_LABEL (widget), New_Str);
	}

	g_free (New_Str);
	New_Str = NULL;
}

/* Cette fonction retourne l'etat 'TRUE' si au moins une demande d'extraction est activee
*  --
*  entree : -
*  retour :
*      FALSE : Aucune demande d'extraction
*      TRUE  : Au moins une demande d'extraction est activee
*/
gboolean cdaudio_get_bool_all_extract (void)
{
	GList *List = NULL;
	AUDIO *Audio = NULL;

	/* PRINT_FUNC_LF(); */

	List = g_list_first (EnteteCD.GList_Audio_cd);
	while (List) {
		if ((Audio = (AUDIO *)List->data) != NULL) {
			if (Audio->EtatSelection_Flac > CD_ETAT_ATTENTE_EXIST ||
			    Audio->EtatSelection_Wav > CD_ETAT_ATTENTE_EXIST ||
			    Audio->EtatSelection_Mp3 > CD_ETAT_ATTENTE_EXIST ||
			    Audio->EtatSelection_Ogg > CD_ETAT_ATTENTE_EXIST ||
			    Audio->EtatSelection_M4a > CD_ETAT_ATTENTE_EXIST ||
			    Audio->EtatSelection_Aac > CD_ETAT_ATTENTE_EXIST ||
			    Audio->EtatSelection_Mpc > CD_ETAT_ATTENTE_EXIST ||
			    Audio->EtatSelection_Ape > CD_ETAT_ATTENTE_EXIST ||
			    Audio->EtatSelection_WavPack > CD_ETAT_ATTENTE_EXIST)  return (TRUE);
		}
		List = g_list_next (List);
	}
	return (FALSE);
}
gboolean cdaudio_get_bool_wav_extract (void)
{
	GList *List = NULL;
	AUDIO *Audio = NULL;

	/* PRINT_FUNC_LF(); */

	List = g_list_first (EnteteCD.GList_Audio_cd);
	while (List) {
		if ((Audio = (AUDIO *)List->data) != NULL) {
			if (Audio->EtatSelection_Wav > CD_ETAT_ATTENTE_EXIST) return (TRUE);
		}
		List = g_list_next (List);
	}
	return (FALSE);
}
gboolean cdaudio_get_bool_mp3_extract (void)
{
	GList *List = NULL;
	AUDIO *Audio = NULL;

	/* PRINT_FUNC_LF(); */

	List = g_list_first (EnteteCD.GList_Audio_cd);
	while (List) {
		if ((Audio = (AUDIO *)List->data) != NULL) {
			if (Audio->EtatSelection_Mp3 > CD_ETAT_ATTENTE_EXIST) return (TRUE);
		}
		List = g_list_next (List);
	}
	return (FALSE);
}

gboolean cdaudio_get_etat_normaise (void)
{
	GList *List = NULL;
	AUDIO *Audio = NULL;

	/* PRINT_FUNC_LF(); */

	List = g_list_first (EnteteCD.GList_Audio_cd);
	while (List) {
		if ((Audio = (AUDIO *)List->data) != NULL) {
			if (Audio->EtatNormalise == TRUE) return (TRUE);
		}
		List = g_list_next (List);
	}
	return (FALSE);
}

gboolean cdaudio_get_bool_is_wav_extract_to_cue (void)
{
	GList		*List = NULL;
	AUDIO		*Audio = NULL;
	gint		 NbrSelectedWav = 0;
	gboolean	 BoolSelectedOthers = FALSE;
	
	/* PRINT_FUNC_LF(); */

	List = g_list_first (EnteteCD.GList_Audio_cd);
	while (List) {
		if ((Audio = (AUDIO *)List->data) != NULL) {
			if (Audio->EtatSelection_Wav > CD_ETAT_ATTENTE_EXIST) NbrSelectedWav ++;
			if (Audio->EtatSelection_Flac > CD_ETAT_ATTENTE_EXIST ||
			    Audio->EtatSelection_Mp3 > CD_ETAT_ATTENTE_EXIST ||
			    Audio->EtatSelection_Ogg > CD_ETAT_ATTENTE_EXIST ||
			    Audio->EtatSelection_M4a > CD_ETAT_ATTENTE_EXIST ||
			    Audio->EtatSelection_Aac > CD_ETAT_ATTENTE_EXIST ||
			    Audio->EtatSelection_Mpc > CD_ETAT_ATTENTE_EXIST ||
			    Audio->EtatSelection_Ape > CD_ETAT_ATTENTE_EXIST ||
			    Audio->EtatSelection_WavPack > CD_ETAT_ATTENTE_EXIST) BoolSelectedOthers = TRUE;
		}
		List = g_list_next (List);
	}
	if (BoolSelectedOthers == TRUE) return (FALSE);
	return (NbrSelectedWav > 1 ? TRUE : FALSE);
}

/* Rendre utilisable ou non les boutons du notebook CD AUDIO
*  --
*  entree : -
*  retour : -
*/
void cdaudio_set_flag_buttons_audio_cd (void)
{
	gboolean     BoolButtonsAudio [ 3 ] = {FALSE, FALSE, FALSE};

	/* PRINT_FUNC_LF(); */

	/* raffraichir
	*/
	BoolButtonsAudio [ 0 ] = TRUE;
	BoolButtonsAudio [ 0 ] = scancd_get_text_combo_cd (_CD_) != NULL ? TRUE : FALSE;

	/* extraction
	*/
	BoolButtonsAudio [ 1 ] = cdaudio_get_bool_all_extract ();

	/* action
	*/
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_rafraichir_cd")), BoolButtonsAudio [ 0 ]);
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_applique_change")), BoolButtonsAudio [ 1 ]);

	/* Numerate begin file
	*/
	BoolButtonsAudio [ 2 ] = EnteteCD.GList_Audio_cd ? TRUE : FALSE;
	gtk_widget_set_sensitive (GTK_WIDGET (GTK_COMBO_BOX (var_cd.Adr_combobox_normalise_cd)), cdaudio_get_etat_normaise ());
	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("vbox_options_cue")), cdaudio_get_bool_is_wav_extract_to_cue ());
	
	if (EnteteCD.StrMemoTagComment == NULL)
		gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_paste_comment")), FALSE);
	else	gtk_widget_set_sensitive (GTK_WIDGET (XCFA_GET_OBJECT("button_paste_comment")), TRUE);
}

/*
*---------------------------------------------------------------------------
* READ TOC CD AND INFOS FROM WEB WITH THREAD AND gtk_timeout_add
*---------------------------------------------------------------------------
*/


/* Demande d'annulation de recuperation d'informations du cd-audio sur le web
*  --
*  entree : -
*  retour : -
*/
void cdaudio_set_cancel_cddb (void)
{
	/* PRINT_FUNC_LF(); */

	/* recherche CDDB is FALSE */
	cddb_set_bool_cancel_cddb (TRUE);
	cdaudio_put_label_status_bar_cd (_INFO_, _SHOW_, _("Processus d'annulation de la base CDDB en cours. Veuillez patienter ..."));
}

void cdaudio_combobox_serveur_cd_realize (GtkWidget *widget)
{
	/*
	gchar *str = NULL;
	gchar pays [ 4 ];
	*/

	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));
	/*
	strncpy (pays, gtk_set_locale (), 2);
	pays [ 2 ] = '\0';
	str = g_strdup_printf ("Auto: %s.freedb", pays);
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), str);
	g_free (str);
	str = NULL;
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "at");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "ca");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "de");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "fi");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "fr");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "no");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "uk");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "us");
	*/
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Auto: freedb");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("NON"));
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.serveur_cddb);
	var_cd.Adr_combobox_serveur = GTK_COMBO_BOX (widget);
}

gint cdaudio_get_val_serveur_cd (void)
{
	/* PRINT_FUNC_LF(); */
	return (gtk_combo_box_get_active (var_cd.Adr_combobox_serveur));
}

void cdaudio_applique_change (void)
{
	if (EnteteCD.GList_Audio_cd != NULL) {

		/*  La normalisation des fichiers se fait a la fin des
		 *  extractions et conversion des fichiers
		 */
		if (cdaudio_get_bool_all_extract ()) {
			cdaudio_clear_all_pixbuf_cd_play ();
			cdaudio_affiche_all_pixbuf_cd_play ();
			mplayer_fifo_quit ();
			cdaudioextract_extraction_cd_to_file_action ();
		}
	}
}

gchar *cdaudio_get_TitleCD (void)
{
	/*PRINT_FUNC_LF();*/
	return ((gchar *)EnteteCD.TitleCD);
}

void cdaudio_get_etat (guint *p_conv, guint *p_normalyze)
{
	GList *List = NULL;
	AUDIO *Audio = NULL;

	/* PRINT_FUNC_LF(); */

	(*p_normalyze) = 0;
	(*p_conv) = 0;

	List = g_list_first (EnteteCD.GList_Audio_cd);
	while (List) {
		if ((Audio = (AUDIO *)List->data) != NULL) {
			if (Audio->EtatSelection_Mp3 > CD_ETAT_ATTENTE_EXIST)      (*p_conv) ++;
			if (Audio->EtatSelection_Flac > CD_ETAT_ATTENTE_EXIST)     (*p_conv) ++;
			if (Audio->EtatSelection_Wav > CD_ETAT_ATTENTE_EXIST)      (*p_conv) ++;
			if (Audio->EtatSelection_Ogg > CD_ETAT_ATTENTE_EXIST)      (*p_conv) ++;
			if (Audio->EtatSelection_M4a > CD_ETAT_ATTENTE_EXIST)      (*p_conv) ++;
			if (Audio->EtatSelection_Aac > CD_ETAT_ATTENTE_EXIST)      (*p_conv) ++;
			if (Audio->EtatSelection_Mpc > CD_ETAT_ATTENTE_EXIST)      (*p_conv) ++;
			if (Audio->EtatSelection_Ape > CD_ETAT_ATTENTE_EXIST)      (*p_conv) ++;
			if (Audio->EtatSelection_WavPack > CD_ETAT_ATTENTE_EXIST)  (*p_conv) ++;
			
			if (Audio->EtatSelection_Mp3 > CD_ETAT_ATTENTE_EXIST || 
			    Audio->EtatSelection_Flac > CD_ETAT_ATTENTE_EXIST || 
			    Audio->EtatSelection_Wav > CD_ETAT_ATTENTE_EXIST || 
			    Audio->EtatSelection_Ogg > CD_ETAT_ATTENTE_EXIST || 
			    Audio->EtatSelection_M4a > CD_ETAT_ATTENTE_EXIST || 
			    Audio->EtatSelection_Aac > CD_ETAT_ATTENTE_EXIST || 
			    Audio->EtatSelection_Mpc > CD_ETAT_ATTENTE_EXIST || 
			    Audio->EtatSelection_Ape > CD_ETAT_ATTENTE_EXIST || 
			    Audio->EtatSelection_WavPack> CD_ETAT_ATTENTE_EXIST ) (*p_normalyze) ++;
		}
		List = g_list_next (List);
	}
}

/*  TAGS CD-AUDIO */

// 
// PATCH: jerome AT jolimont POINT fr : Jerome Lafrechoux
// 
// Remplacement des ESPACES et caractères spéciaux par des UNDERSCORES
// 
gchar *cdaudio_get_template_destination (AUDIO *Audio, gchar *p_PtrTemplate)
{
	/*
	var_cd.Adr_entry_stockage_cdaudio = widget;
	var_cd.Adr_label_stockage_cdaudio = widget;

	%a artiste
	%b titre de l'album
	%c numero de la piste
	%d titre de la chanson
	%e annee
	%g genre
	*/
	GString	*gstr = g_string_new (NULL);
	gchar	*Ptr = NULL;
	gchar	*BufRet = NULL;
	gchar	 str [ 10 ];

	// PRINT_FUNC_LF();
	
	while (*p_PtrTemplate) {
		
		if (p_PtrTemplate && *p_PtrTemplate == '%' && *(p_PtrTemplate +1) != '\0') {
			switch (*(p_PtrTemplate +1)) {
			case 'a' :
				Ptr = Audio->tags->Artist;
				p_PtrTemplate += 2;
				break;
			case 'b' :
				Ptr = Audio->tags->Album;
				p_PtrTemplate += 2;
				break;
			case 'c' :
				g_string_append_printf (gstr, "%02d", Audio->tags->IntNumber);
				p_PtrTemplate += 2;
				break;
			case 'd' :
				Ptr = Audio->tags->Title;
				p_PtrTemplate += 2;
				break;
			case 'e' :
				g_string_append_printf (gstr, "%d", Audio->tags->IntYear);
				p_PtrTemplate += 2;
				break;
			case 'g' :
				Ptr = Audio->tags->Genre;
				p_PtrTemplate += 2;
				break;
			default :
				// SI FONCTION INCONNUE -> NE PAS TRAITER
				if (*p_PtrTemplate > 0) {
					str [ 0 ] = *(p_PtrTemplate +1);
					str [ 1 ] = '\0';
					g_string_append_printf (gstr, "%s", str);
				}
				if (*(p_PtrTemplate +1) < 0)	p_PtrTemplate += 3;
				else				p_PtrTemplate += 2;
			}
			while (Ptr && *Ptr != '\0')
			{
				str [ 0 ] = *Ptr;
				if ( *Ptr != '/' && ((*Ptr == ' ') || (g_ascii_isalnum(*Ptr) == FALSE))) {
					str [ 0 ] = '_';
				}
				str [ 1 ] = '\0';
				str [ 2 ] = '\0';
				g_string_append_printf (gstr, "%s", str);
				if (*Ptr < 0)	Ptr += 2;
				else		Ptr ++;
			}
			Ptr = NULL;
		}
		else {
			if (*p_PtrTemplate > 0 && *p_PtrTemplate != '%' /*&& g_ascii_isalnum(*p_PtrTemplate) == TRUE*/) {
				str [ 0 ] = *p_PtrTemplate;
				str [ 1 ] = '\0';
				g_string_append_printf (gstr, "%s", str);
			}

			if (*p_PtrTemplate < 0)	p_PtrTemplate += 2;
			else			p_PtrTemplate ++;
		}
		Ptr = NULL;
	}
	
	BufRet = g_strdup (gstr->str);
	for (Ptr = BufRet; *Ptr; Ptr ++) {
		if (*(Ptr +1) != '\0' && *Ptr == '/' && *(Ptr +1) == '/') *Ptr = '_';
	}
	g_string_free (gstr, TRUE);
	return (BufRet);
}

void cdaudio_entry_stockage_cdaudio_changed (void)
{
	gchar		*ptr_template = NULL;
	gchar		*Ptr = NULL;
	GString		*gstr = NULL;
	gchar		*StrTemplate = NULL;
	AUDIO		*Audio = NULL;
	gboolean	bool = FALSE;

	// PRINT_FUNC_LF();
	
	if (!var_cd.Adr_entry_stockage_cdaudio || !var_cd.Adr_label_stockage_cdaudio) return;
	if (bool_entree_cd_verif_car == FALSE) return;

	ptr_template = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_stockage_cdaudio));
	
	for (Ptr = ptr_template; *Ptr; Ptr ++) {
		if (*Ptr == ' ') {
			*Ptr = '_';
		} else if (*(Ptr +1) != '\0' && *Ptr == '/' && *(Ptr +1) == '/') {
			*Ptr = '_';
		}
	}	
	
	if ((Audio = cdaudio_get_line_selected_for_extract ()) == NULL) {
		if (strstr (ptr_template, "%a") || strstr (ptr_template, "%b") || strstr (ptr_template, "%c") ||
			 strstr (ptr_template, "%d") || strstr (ptr_template, "%e") || strstr (ptr_template, "%g")) {

			gstr = g_string_new (NULL);
			g_string_append_printf (gstr,
				_("<b>%s/<span color=\"blue\">%s</span></b>\n"
				  "<span color=\"red\">Pour evaluer les templates, vous devez activer une lecture de cdaudio</span>"
				  "%s"),
				(gchar *)Config_User.Path_Destination_CD,
				ptr_template,
				bool ? _("\n<span color=\"blue\"><i>Un seul dossier de stockage peut etre cree. !</i></span>") : ""
				);
			gtk_label_set_markup (GTK_LABEL (var_cd.Adr_label_stockage_cdaudio), gstr->str);
			g_string_free (gstr, TRUE);
			bool = FALSE;
			bool_entree_cd_verif_car = TRUE;
			return;
		}
	}

	gtk_label_set_markup (GTK_LABEL (var_cd.Adr_label_stockage_cdaudio), "");
	gstr = g_string_new (NULL);
	g_string_append_printf (gstr, "<b>%s/<span color=\"blue\">", (gchar *)Config_User.Path_Destination_CD);
	StrTemplate = cdaudio_get_template_destination (Audio, ptr_template);

	g_string_append_printf (gstr, "%s</span></b>%s",
				StrTemplate,
				bool ? _("\n<span color=\"blue\"><i>Un seul dossier de stockage peut etre cree. !</i></span>") : ""
				);
	bool = FALSE;
	gtk_label_set_markup (GTK_LABEL (var_cd.Adr_label_stockage_cdaudio), gstr->str);
	g_free (StrTemplate);
	StrTemplate = NULL;
	g_string_free (gstr, TRUE);
	bool_entree_cd_verif_car = TRUE;
}


/* Recuperation d'un pointeur de texte sur le contenu du bouton 'destination' qui est
*  le chemin de destination des extractions / conversions de pistes musicales
*  --
*  entree : -
*  retour :
*      gchar * : pointeur de texte
*/
gchar *cdaudio_get_result_destination (TAGS *tags)
{
	gchar        *NameDir = NULL;

	// PRINT_FUNC_LF();
	
	if (tags) {
		gchar	*StrTemplate = NULL;
		gchar	*ptr_template = NULL;
		AUDIO	*Audio = NULL;

		ptr_template = (gchar *)gtk_entry_get_text (GTK_ENTRY (var_cd.Adr_entry_stockage_cdaudio));

		if ((Audio = cdaudio_get_line_selected ())) {
			StrTemplate = cdaudio_get_template_destination (Audio, ptr_template);
			NameDir = g_strdup_printf ("%s/%s", Config_User.Path_Destination_CD, StrTemplate);
			g_free (StrTemplate);
			StrTemplate = NULL;
		}
		else {
			NameDir = g_strdup_printf ("%s", (gchar *)Config_User.Path_Destination_CD);
		}
	}
	else if (EnteteCD.Bool_Connected == CONNECT_IS_FALSE) {

		gint cpt = 0;

		NameDir = g_strdup_printf ("%s/Track", (gchar *)Config_User.Path_Destination_CD);

		if (infosong_file_is_dir (NameDir) == TRUE) {

			g_free (NameDir);
			NameDir = NULL;

			while (TRUE) {

				NameDir = g_strdup_printf ("%s/%03d_Track", (gchar *)Config_User.Path_Destination_CD, cpt);
				if (infosong_file_is_dir (NameDir) == FALSE) {
					return (NameDir);
				}
				cpt ++;
			}
		}
	}
	else {
		NameDir = g_strdup_printf ("%s", (gchar *)Config_User.Path_Destination_CD);
	}
	
	return (NameDir);
}

GList *cdaudio_get_glist_play (void)
{
	GList		*list = NULL;
	AUDIO		*Audio = NULL;
	gchar		*Str = NULL;

	if ((Audio = cdaudio_get_line_selected ()) != NULL) {

		cdaudio_set_etat_music_pixbuf_with_detail (Audio, CD_ETAT_PLAY);
		
		list = g_list_append (list, g_strdup_printf ("cdda://%d", Audio->Num_Track));
		list = g_list_append (list, g_strdup ("-cdrom-device"));
		list = g_list_append (list, g_strdup_printf ("%s", EnteteCD.NameCD_Device));
		
		Str = g_strdup_printf ("%d : %s",  Audio->Num_Track, Audio->NameSong);
		// WinPlay_set_label_namefile (LIST_MPLAYER_FROM_CD, "From CD", Str);
		WinPlay_Open (LIST_MPLAYER_FROM_CD, "From CD", Str);
		g_free (Str);
		Str = NULL;
	}
	
	return ((GList *)list);
}


void cdaudio_deselect_all_flags_extract (void)
{
	AUDIO         *Audio = NULL;
	GdkPixbuf     *Pixbuf = NULL;
	GList         *List = NULL;
	gboolean       valid;
	GtkTreeIter    iter;
	gint           NumTrack = 0;
	
	valid = gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
	while (valid) {
		List = g_list_nth (EnteteCD.GList_Audio_cd, NumTrack);
		if ((Audio = (AUDIO *)List->data)) {
			
			Audio->EtatSelection_Flac =
			Audio->EtatSelection_Wav =
			Audio->EtatSelection_Mp3 =
			Audio->EtatSelection_Ogg =
			Audio->EtatSelection_M4a =
			Audio->EtatSelection_Aac =
			Audio->EtatSelection_Mpc =
			Audio->EtatSelection_Ape =
			Audio->EtatSelection_WavPack = CD_ETAT_ATTENTE;
			
			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_FLAC);
			gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_FLAC, Pixbuf, -1);
			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_WAV);
			gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_WAV, Pixbuf, -1);
			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_MP3);
			gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_MP3, Pixbuf, -1);
			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_OGG);
			gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_OGG, Pixbuf, -1);
			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_M4A);
			gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_M4A, Pixbuf, -1);
			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_AAC);
			gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_AAC, Pixbuf, -1);
			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_MPC);
			gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_MPC, Pixbuf, -1);
			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_APE);
			gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_APE, Pixbuf, -1);
			Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_WAVPACK);
			gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_WAVPACK, Pixbuf, -1);
			
			NumTrack ++;
		}
		valid = gtk_tree_model_iter_next (var_cd.Adr_Tree_Model, &iter);
	}
	cdaudio_set_flag_buttons_audio_cd ();
}


void cdaudio_de_select_verticaly_all_flags_extract (gboolean BoolSelect, gboolean BoolSelectExpert, TYPE_FILE_IS TypeFileIs)
{
	AUDIO         *Audio = NULL;
	GdkPixbuf     *Pixbuf = NULL;
	GList         *List = NULL;
	gboolean       valid;
	GtkTreeIter    iter;
	gint           NumTrack = 0;
	
	/*PRINT_FUNC_LF();*/
	
	valid = gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
	while (valid) {
		List = g_list_nth (EnteteCD.GList_Audio_cd, NumTrack);
		if ((Audio = (AUDIO *)List->data)) {
			
			if (TypeFileIs == FILE_IS_FLAC) {
				if (BoolSelect && BoolSelectExpert)
					Audio->EtatSelection_Flac = CD_ETAT_SELECT;
				else	Audio->EtatSelection_Flac = CD_ETAT_ATTENTE;
				if (BoolSelect == TRUE)
					Audio->EtatSelection_Flac    = cdaudio_get_next_flag (FILE_IS_FLAC, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_FLAC);
				gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_FLAC, Pixbuf, -1);
			}
			else if (TypeFileIs == FILE_IS_WAV) {
				if (BoolSelect && BoolSelectExpert)
					Audio->EtatSelection_Wav = CD_ETAT_SELECT;
				else	Audio->EtatSelection_Wav = CD_ETAT_ATTENTE;
				if (BoolSelect == TRUE)
					Audio->EtatSelection_Wav    = cdaudio_get_next_flag (FILE_IS_WAV, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_WAV);
				gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_WAV, Pixbuf, -1);
			}
			else if (TypeFileIs == FILE_IS_MP3) {
				if (BoolSelect && BoolSelectExpert)
					Audio->EtatSelection_Mp3 = CD_ETAT_SELECT;
				else	Audio->EtatSelection_Mp3 = CD_ETAT_ATTENTE;
				if (BoolSelect == TRUE)
					Audio->EtatSelection_Mp3    = cdaudio_get_next_flag (FILE_IS_MP3, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_MP3);
				gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_MP3, Pixbuf, -1);
			}
			else if (TypeFileIs == FILE_IS_OGG) {
				if (BoolSelect && BoolSelectExpert)
					Audio->EtatSelection_Ogg = CD_ETAT_SELECT;
				else	Audio->EtatSelection_Ogg = CD_ETAT_ATTENTE;
				if (BoolSelect == TRUE)
					Audio->EtatSelection_Ogg    = cdaudio_get_next_flag (FILE_IS_OGG, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_OGG);
				gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_OGG, Pixbuf, -1);
			}
			else if (TypeFileIs == FILE_IS_M4A) {
				if (BoolSelect && BoolSelectExpert)
					Audio->EtatSelection_M4a = CD_ETAT_SELECT;
				else	Audio->EtatSelection_M4a = CD_ETAT_ATTENTE;
				if (BoolSelect == TRUE)
					Audio->EtatSelection_M4a    = cdaudio_get_next_flag (FILE_IS_M4A, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_M4A);
				gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_M4A, Pixbuf, -1);
			}
			else if (TypeFileIs == FILE_IS_AAC) {
				if (BoolSelect && BoolSelectExpert)
					Audio->EtatSelection_Aac = CD_ETAT_SELECT;
				else	Audio->EtatSelection_Aac = CD_ETAT_ATTENTE;
				if (BoolSelect == TRUE)
					Audio->EtatSelection_Aac    = cdaudio_get_next_flag (FILE_IS_AAC, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_AAC);
				gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_AAC, Pixbuf, -1);
			}
			else if (TypeFileIs == FILE_IS_MPC) {
				if (BoolSelect && BoolSelectExpert)
					Audio->EtatSelection_Mpc = CD_ETAT_SELECT;
				else	Audio->EtatSelection_Mpc = CD_ETAT_ATTENTE;
				if (BoolSelect == TRUE)
					Audio->EtatSelection_Mpc    = cdaudio_get_next_flag (FILE_IS_MPC, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_MPC);
				gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_MPC, Pixbuf, -1);
			}
			else if (TypeFileIs == FILE_IS_APE) {
				if (BoolSelect && BoolSelectExpert)
					Audio->EtatSelection_Ape = CD_ETAT_SELECT;
				else	Audio->EtatSelection_Ape = CD_ETAT_ATTENTE;
				if (BoolSelect == TRUE)
					Audio->EtatSelection_Ape    = cdaudio_get_next_flag (FILE_IS_APE, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_APE);
				gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_APE, Pixbuf, -1);
			}
			else if (TypeFileIs == FILE_IS_WAVPACK) {
				if (BoolSelect && BoolSelectExpert)
					Audio->EtatSelection_WavPack = CD_ETAT_SELECT;
				else	Audio->EtatSelection_WavPack = CD_ETAT_ATTENTE;
				if (BoolSelect == TRUE)
					Audio->EtatSelection_WavPack    = cdaudio_get_next_flag (FILE_IS_WAVPACK, TRUE, NumTrack);
				Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_WAVPACK);
				gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_WAVPACK, Pixbuf, -1);
			}

			NumTrack ++;
		}
		valid = gtk_tree_model_iter_next (var_cd.Adr_Tree_Model, &iter);
	}
	cdaudio_set_flag_buttons_audio_cd ();
}

void cdaudio_de_select_horizontaly_all_flags_extract (AUDIO *p_Audio, gboolean BoolSelect, gboolean BoolSelectExpert)
{
	AUDIO         *Audio = NULL;
	GdkPixbuf     *Pixbuf = NULL;
	GList         *List = NULL;
	gboolean       valid;
	GtkTreeIter    iter;
	gint           NumTrack = 0;
	
	/*PRINT_FUNC_LF();*/
	
	valid = gtk_tree_model_get_iter_first (var_cd.Adr_Tree_Model, &iter);
	while (valid) {
		List = g_list_nth (EnteteCD.GList_Audio_cd, NumTrack);
		if ((Audio = (AUDIO *)List->data)) {
			if (Audio == p_Audio) break;
			NumTrack ++;
		}
		valid = gtk_tree_model_iter_next (var_cd.Adr_Tree_Model, &iter);
	}

	if (BoolSelect && BoolSelectExpert) {
		Audio->EtatSelection_Flac =
		Audio->EtatSelection_Wav =
		Audio->EtatSelection_Mp3 =
		Audio->EtatSelection_Ogg =
		Audio->EtatSelection_M4a =
		Audio->EtatSelection_Aac =
		Audio->EtatSelection_Mpc =
		Audio->EtatSelection_Ape =
		Audio->EtatSelection_WavPack = CD_ETAT_SELECT;
	}
	else {
		Audio->EtatSelection_Flac =
		Audio->EtatSelection_Wav =
		Audio->EtatSelection_Mp3 =
		Audio->EtatSelection_Ogg =
		Audio->EtatSelection_M4a =
		Audio->EtatSelection_Aac =
		Audio->EtatSelection_Mpc =
		Audio->EtatSelection_Ape =
		Audio->EtatSelection_WavPack = CD_ETAT_ATTENTE;
	}
	
	if (BoolSelect == TRUE) {
		Audio->EtatSelection_Flac    = cdaudio_get_next_flag (FILE_IS_FLAC, TRUE, NumTrack);
		Audio->EtatSelection_Wav     = cdaudio_get_next_flag (FILE_IS_WAV, TRUE, NumTrack);
		Audio->EtatSelection_Mp3     = cdaudio_get_next_flag (FILE_IS_MP3, TRUE, NumTrack);
		Audio->EtatSelection_Ogg     = cdaudio_get_next_flag (FILE_IS_OGG, TRUE, NumTrack);
		Audio->EtatSelection_M4a     = cdaudio_get_next_flag (FILE_IS_M4A, TRUE, NumTrack);
		Audio->EtatSelection_Aac     = cdaudio_get_next_flag (FILE_IS_AAC, TRUE, NumTrack);
		Audio->EtatSelection_Mpc     = cdaudio_get_next_flag (FILE_IS_MPC, TRUE, NumTrack);
		Audio->EtatSelection_Ape     = cdaudio_get_next_flag (FILE_IS_APE, TRUE, NumTrack);
		Audio->EtatSelection_WavPack = cdaudio_get_next_flag (FILE_IS_WAVPACK, TRUE, NumTrack);
	}
				
	Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_FLAC);
	gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_FLAC, Pixbuf, -1);
	Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_WAV);
	gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_WAV, Pixbuf, -1);
	Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_MP3);
	gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_MP3, Pixbuf, -1);
	Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_OGG);
	gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_OGG, Pixbuf, -1);
	Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_M4A);
	gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_M4A, Pixbuf, -1);
	Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_AAC);
	gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_AAC, Pixbuf, -1);
	Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_MPC);
	gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_MPC, Pixbuf, -1);
	Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_APE);
	gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_APE, Pixbuf, -1);
	Pixbuf = cdaudio_get_pixbuf_file (Audio, FILE_IS_WAVPACK);
	gtk_list_store_set (var_cd.Adr_List_Store, &iter, CD_COLUMN_WAVPACK, Pixbuf, -1);

	cdaudio_set_flag_buttons_audio_cd ();
}


void cdaudio_combobox_normalise_cd_realize (GtkWidget *widget)
{
	// utils_clear_elements_combobox (GTK_COMBO_BOX (widget));
	utils_alloc_combo (GTK_COMBO_BOX (widget));
	
	var_cd.Adr_combobox_normalise_cd = GTK_COMBO_BOX (widget);
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Peak/Album");
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), "Peak");
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), 0);

	/*g_signal_connect(G_OBJECT(widget), "changed", G_CALLBACK(cdaudio_choix_compression), NULL);*/
}

gint cdaudio_get_value_normalise_cd (void)
{
	if (var_cd.Adr_combobox_normalise_cd == NULL) return (-1);
	return (gtk_combo_box_get_active (GTK_COMBO_BOX (var_cd.Adr_combobox_normalise_cd)));
}

void cdaudio_combobox_normalise_cd_changed (void)
{
	if (var_cd.Adr_combobox_normalise_cd == NULL) return;
}




