 /*
 * file      : about_xcfa.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003 - 2010 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <gtk/gtk.h>

#include <stdlib.h>

#include "global.h"
#include "web.h"
#include "utils.h"
#include "win_control.h"
#include "get.h"
#include "about_xcfa.h"



typedef struct {
	GtkWidget	*AdrWin;
	gboolean	 Bool;
} VAR_ABOUT;

VAR_ABOUT VarAbout = { NULL, TRUE };



void AboutXcfa_quit (void)
{
	NEW_wincontrol_realize_window (&VarAbout.AdrWin, "wind_about", &VarAbout.Bool, WIND_IS_SHOW, WIND_USE_STRUCT, WIND_IS_MODAL, WIND_IS_TRANSIENT);
}

gboolean AboutXcfa_delete_event (void)
{
	AboutXcfa_quit ();
	return TRUE;
}
gboolean AboutXcfa_destroy_event (void)
{
	AboutXcfa_quit ();
	return TRUE;
}
void AboutXcfa_button_ok_about_clicked (void)
{
	AboutXcfa_quit ();
}

void AboutXcfa_image_about_realize (GtkWidget *widget)
{
	gchar     *LineCommand = NULL;

	LineCommand = utils_get_pathname ("about.png");
	gtk_image_set_from_file (GTK_IMAGE (widget), LineCommand);
	g_free (LineCommand);
	LineCommand = NULL;
}
void AboutXcfa_label_xcfa_about_realize (GtkWidget *widget)
{
	gchar	*str = NULL;
	gchar	*ModelName = get_set_cpu_info ();

	str = g_strdup_printf (
		/*"\n<b>X</b>  <b>C</b>onvert  <b>F</b>ile  <b>A</b>udio\n"*/
		"\n"
		"GTK+ implementation of the GNU shell command.\n"
		"version %s\n"
		"\n"
		"<i>%s</i>\n",
		// "(<i>%d CPU %d bits</i>)\n",
		VERSION,
		// HostConf.NbCpu,
		// HostConf.TypeCpu);
		ModelName);
	gtk_label_set_justify (GTK_LABEL(widget), GTK_JUSTIFY_CENTER);
	gtk_label_set_markup (GTK_LABEL(widget), str);
	g_free (str);
	str = NULL;
	g_free (ModelName);
	ModelName = NULL;
}
void AboutXcfa_label_author_about_realize (GtkWidget *widget)
{
	gtk_label_set_justify (GTK_LABEL(widget), GTK_JUSTIFY_CENTER);
	gtk_label_set_markup (GTK_LABEL(widget), "\nCopyright © 2003-2010  -  Bulin Claude  -  fr\n");
}
void AboutXcfa_label_contrib_about_realize (GtkWidget *widget)
{
#define TEXTE _("\n<span foreground=\"#00000F\" weight=\"normal\"><i>" \
		"<b>Au tout debut:</b>\n\n" \
		"Serres Patrick, Hamann Regis, Fabien Gregis, @Dzef, @alteo_gange, \n" \
		"@Leonux, @zarer, @Shankarius, @bishop, @Ludo, @Patachonf,\n" \
		"...  ;-)\n\n" \
		"</i></span>")

	gtk_label_set_use_markup (GTK_LABEL (widget), TRUE);
	gtk_label_set_justify (GTK_LABEL (widget), GTK_JUSTIFY_CENTER);
	gtk_label_set_markup (GTK_LABEL (widget), TEXTE);
}
void AboutXcfa_textview_label_license_about_realize (GtkWidget *widget)
{
	gtk_text_view_set_editable (GTK_TEXT_VIEW (widget), FALSE);
	gtk_text_view_set_justification (GTK_TEXT_VIEW (widget), GTK_JUSTIFY_CENTER);
	gtk_text_view_set_cursor_visible (GTK_TEXT_VIEW (widget), FALSE);
	gtk_text_buffer_set_text (gtk_text_view_get_buffer (GTK_TEXT_VIEW (widget)),
	"\n\nLicense 2003 - 2010, Claude Bulin\n\n\nThis program is free software;"
	" you can redistribute it and/or modify\nit under the terms of the GNU General Public License as published by\n"
	"the Free Software Foundation; either version 2 of the License, or\n(at your option) any later version.\n \n"
	"This program is distributed in the hope that it will be useful,\nbut WITHOUT ANY WARRANTY; "
	"without even the implied warranty of\nMERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  "
	"See the\nGNU General Public License for more details.\n \nYou should have received a copy of the GNU General Public License\n"
	/*
	"along with this program; if not, write to the Free Software\nFoundation, Inc., 59 Temple Place - Suite 330, Boston, "
	"MA 02111-1307, USA.\n\n------------\n\nPermission  est  donnee  a  tout  individu  ou  institution d'utiliser,\n"
	
	Il faut remplacer l'adresse de la FSF (qui a changé depuis juillet 2005) dans le fichier copyright.
	Ancienne adresse: 59 Temple Place - Suite 330, Boston, MA 02111-1307 USA
	Nouvelel adresse: 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
	*/
	"along with this program; if not, write to the Free Software\nFoundation, Inc., 51 Franklin Street, Fifth Floor, Boston, "
	"MA 02110-1301, USA.\n\n------------\n\nPermission  est  donnee  a  tout  individu  ou  institution d'utiliser,\n"
	
	"copier, ou redistribuer ce logiciel des  lors  que  tous  les  fichiers\nd'origine  sont  inclus,  que ce n'est pas vendu"
	" pour des benefices, et\nque cette notice sur le copyright est incluse.\n\nCe programme est un logiciel libre; vous pouvez le  "
	"redistribuer  et/ou\nle modifier sous les termes de la licence GNU GPL telle que publiee par\nla Free Software Foundation; "
	"soit la version 2, soit  (a  votre  conve-\nnance) toute version ulterieure.\n\nCe  programme  est  distribue dans l'espoir "
	"qu'il soit utile, mais SANS\nAUCUNE GARANTIE; meme sans la garantie implicite  de  UTILISABILITE  ou\nd'ADAPTATION  A  UN "
	"USAGE PRECIS. Lisez la licence GNU GPL pour plus de\ndetails.\n", -1);
}
void AboutXcfa_label_button_pagexcfa_about_realize (GtkWidget *widget)
{
	gtk_label_set_markup (GTK_LABEL (widget), _("<span foreground=\"#0000FF\">  Xcfa sur le web</span>"));
}
void AboutXcfa_button_contrib_about_clicked (GtkButton *button)
{
	typedef struct {
		gchar  *NameWidget;
		gchar  *Url;
	} TYPE_BUTTON;
	#define MAX_TYPE_BUTTON_PAGE_WEB 20
	TYPE_BUTTON TypeButton [ MAX_TYPE_BUTTON_PAGE_WEB ] = {
	{"button_pagexcfa_about",		"http://www.xcfa.tuxfamily.org"},
	{"button01_contrib_about",		"http://www.road2mayotte.org/index.html "},
	{"button02_contrib_about",		"http://e17blog.tuxfamily.org/index.php"},
	{"button03_contrib_about",		"http://ubunteros.tuxfamily.org/spip.php?page=plan"},
	{"button04_contrib_about",		"http://www.jesuislibre.org"},
	{"button05_contrib_about",		"http://audiobezon.dlinkddns.com/"},
	{"button06_contrib_about",		"http://www.tuxfamily.org"},
	{"button07_contrib_about",		"http://www.framasoft.net/article4492.html"},
	{"button08_contrib_about",		"http://ekd.tuxfamily.org"},
	{"button09_contrib_about",		"http://defis-libristes.tuxfamily.org/viewforum.php?id=2"},
	{"button10_contrib_about",		"http://doc.ubuntu-fr.org/xcfa"},
	{"button11_contrib_about",		"http://unm.arcis.free.fr/spip.php?article109"},
	{"button12_contrib_about",		"http://ubunteros.tuxfamily.org/spip.php?article168"},
	{"button13_contrib_about",		"http://ubunteros.tuxfamily.org/spip.php?article159"},
	{"button14_contrib_about",		"http://ubunteros.tuxfamily.org/spip.php?article30"},
	{"button15_contrib_about",		"http://lalinuxerie.free.fr/"},
	{"button16_contrib_about",		"http://www.debian-multimedia.org/"},
	{"button17_contrib_about",		"http://frugalware.org/"},
	{"button20_contrib_about",		"http://opera-info.de/forum/thread.php?threadid=20506"},
	{"button21_contrib_about",		"http://linuxforen.de/forums/showthread.php?p=1693658"},
	};

	gint cpt;

	for (cpt = 0; cpt < MAX_TYPE_BUTTON_PAGE_WEB; cpt ++) {
		// if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (lookup_widget (VarAbout.AdrWin, TypeButton [ cpt ].NameWidget)))) {
		if (GTK_BUTTON (button) == GTK_BUTTON (GTK_WIDGET (XCFA_GET_OBJECT(TypeButton [ cpt ].NameWidget)))) {
			web_goto_xcfa_page (TypeButton [ cpt ].Url);
			break;
		}
	}
}
void AboutXcfa_info_machine (GtkWidget *widget, gchar *text)
{
	gchar *save = NULL;
	
	save = g_strdup_printf ("%s%s", gtk_label_get_label (GTK_LABEL(widget)), text);
	
	gtk_label_set_use_markup (GTK_LABEL (widget), TRUE);
	gtk_label_set_justify (GTK_LABEL (widget), GTK_JUSTIFY_LEFT);
	gtk_label_set_markup (GTK_LABEL (widget), save);
	gtk_widget_show (widget);
	
	g_free (save);
	save = NULL;
}
void on_label_about_machine_realize (GtkWidget *widget, gpointer user_data)
{
	gchar *ptr = NULL;
	
	ptr = utils_get_infos_ordi (TRUE, TRUE);
	AboutXcfa_info_machine (widget, "\n");
	AboutXcfa_info_machine (widget, ptr);
	g_free (ptr);
	ptr = NULL;
	
	AboutXcfa_info_machine (widget, "\n<span foreground=\"#0000FF\"><b>Depots Debian-multimedia</b></span>\n\n");
	AboutXcfa_info_machine (widget,

		"\tdeb http://www.debian-multimedia.org sid main\n"
		"\tdeb-src http://www.debian-multimedia.org sid main\n"
		"\n<span foreground=\"#0000FF\"><b><i>Ou</i></b></span>"
		"\tdeb http://www.debian-multimedia.org testing main\n"
		"\tdeb-src http://www.debian-multimedia.org testing main\n"
		"\n"
		);
	
	AboutXcfa_info_machine (widget, "<span foreground=\"#0000FF\"><b>Depots TuxFamily</b></span>\n\n");
	AboutXcfa_info_machine (widget,

		"\tdeb http://download.tuxfamily.org/xcfaudio/xcfa dev contrib\n"
		"\tdeb-src http://download.tuxfamily.org/xcfaudio/xcfa dev contrib\n"
		"\n"
		);

	AboutXcfa_info_machine (widget, "<span foreground=\"#0000FF\"><b>XCFA exist dans les depots Frugalware  :-)</b></span>\n\n");
	
	ptr = g_strdup ("\n<span foreground=\"#F00000\"><b><i>NOTE:\nSi sox ne vous donne pas satisfaction:</i></b></span>\n\n");
	AboutXcfa_info_machine (widget, ptr);
	g_free (ptr);
	ptr = NULL;
	AboutXcfa_info_machine (widget,
		"\t<b># (sudo) apt-get install libsox-fmt-all</b>\n"
		"\n"
		);

	ptr = g_strdup ("\n<span foreground=\"#0000FF\"><b>Dernieres modifications</b></span>\n\n");
	AboutXcfa_info_machine (widget, ptr);
	g_free (ptr);
	ptr = NULL;
	
	AboutXcfa_info_machine (widget,

		"\t<span foreground=\"#0000FF\"><b>3.7.0</b></span>\n"
		
		"\t<b>GtkBuilder</b> est maintenant utilise.\n"
		"\t<b>La sauvegarde</b> du contexte est automatisee.\n"
		"\t<b>Suppression:</b> de la possibilite d'installation des programmes tiers depuis Xcfa.\n"
		"\t<b>Correction:(@Patachonf):</b> de l'import des fichiers ape.\n"
		"\t<b>Correction:(@Dzef):</b> pour la conversion WAV vers ALL des frequences, voies et quantification.\n"
		"\t<b>Ajout:</b> Depuis Fichier->mp3ogg->bitrate d'une possibilite de tri.\n"
		"\t<b>Ajout:(Jerome Lafrechoux):</b> remplacement des ESPACES et caracteres speciaux par des UNDERSCORES.\n"
		
		"\t<span foreground=\"#0000FF\"><b>3.7.1</b></span>\n"
		
		"\t<b>Correction :</b> conversion de masse depuis Fichiers->mp3ogg.\n"
		"\t<b>Correction:(François Nautre et @Gounlaf):</b> d'un bug pour extraction mp3 et ogg  ;).\n"
		
		"\t<span foreground=\"#0000FF\"><b>3.7.2</b></span>\n"
		
		"\t<b>Ajout:</b> depuis onglet fichiers-conversions des types RM et DTS vers xxx.\n"
		"\t<b>Correction:</b> lecture correcte de l'entete MPC.\n"
		"\t<b>Ajout:</b> lecture d'un flux RM et/ou DTS via le player.\n"
		"\t<b>Ajout:(@zarer):</b> des manpages reelles des applications.\n"
		"\t<b>Modification:</b> Utilisation de ICEDAX pour la lecture du catalog cd.\n"
		"\t<b>Ajout:</b> depuis onglet fichiers-conversions du type AIF vers xxx.\n"
		"\t<b>Ajout:</b> depuis onglet split des types: MP3, OGG, FLAC, SHN, WAVPACK.\n"
		
		"\t<span foreground=\"#0000FF\"><b>3.7.3</b></span>\n"
		
		"\t<b>Modification:</b> depuis onglet [ CD->Arrangement des titres du CD ] de l'option %u\n"
		"\t\t<b>%u(SOURCE=DESTINATION)</b>\n"
		"\t\t<b><i>Le ou les caracteres SOURCE seront remplaces par le caractere DESTINATION</i></b>\n"
		"\t\t\t<b>SOURCE</b>\n"
		"\t\t\tpeut etre un ou une suite de caracteres\n"
		"\t\t\t<b>DESTINATION</b>\n"
		"\t\t\test un caractere unique pour remplacer la SOURCE\n"
		"\t\t<b>Exemple</b>:\n"
		"\t\t\t%u(AB=C)\n"
		"\t<b>Correction:(@Dzef):</b> pour la conversion WAV vers ALL des frequences, voies et quantification.\n"
		"\t<b>Suppression</b> de la fenetre d'erreur et ajout d'un journal de logs.\n"
		"\t<b>Correction:</b> de la traduction: mon mini-parseur de fichier *.glade possedait un mini-bug  ;-).\n"
		"\t<b>Correction/Modification:</b> de la normalisation CD/Fichiers.\n"
		"\t<b>Suppression</b> de la fonction sysinfo(struct sysinfo *info) pour une compilation correcte sous kfreebsd par Christian Marillat.\n"
		
		"\t<span foreground=\"#F00000\"><b>A VENIR</b></span>\n"
		
		"\t<b>Traduction:</b> vers l'Italien par ???.\n"
		"\t<b>Ajout:</b> onglet Join.\n"
		"\t<b>Ajout:</b> fenetre d'installation des progs tiers au premier lancement.\n"
		"\t<b>Ajout:</b> Depuis l'onglet fichiers, ajouter le dernier dossier d'import à la destination.\n"
		
		"\n"
		);
	
	ptr = g_strdup ("<span foreground=\"#0000FF\"><b>Todo ...</b></span>\n\n");
	AboutXcfa_info_machine (widget, ptr);
	g_free (ptr);
	ptr = NULL;
	AboutXcfa_info_machine (widget, 
		"\t<b>Shankarius:</b>\n"
		"\t\t> J'en profite pour te faire un petit rappel concernant les copies temporaires inutiles. ;)\n"
		"\t<b>b52:</b>\n"
		"\t\t<b>Nouvel onglet:</b> Extraction bande son depuis un film\n"
		"\n"
		);

	ptr = g_strdup_printf ("<span foreground=\"#0000FF\"><b>DE GRANDS MERCIS ...\nTHANK YOU ...\n</b></span>\n");
	AboutXcfa_info_machine (widget, ptr);
	g_free (ptr);
	ptr = NULL;

	AboutXcfa_info_machine (widget, 

		"\t... <b><i>a tous pour le temps consacre au developpement + tests d'Xcfa</i></b>\n"
		"\t... <b><i>for all time spent on developing + Xcfa tests</i></b>\n"
		"\t<b><i>;-)</i></b>"
		"\n"
		);
}
void AboutXcfa_Create_Windows (void)
{
	NEW_wincontrol_realize_window (&VarAbout.AdrWin, "wind_about", &VarAbout.Bool, WIND_IS_SHOW, WIND_USE_STRUCT, WIND_IS_MODAL, WIND_IS_TRANSIENT);
}


