 /*
 * file      : win_play.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#include <gtk/gtk.h>
#include "support.h"
#include "interface.h"

#include "global.h"
#include "utils.h"
#include "win_control.h"
#include "player.h"
#include "config_user.h"
#include "dvd_audio.h"
#include "win_info.h"
#include "win_play.h"




VAR_LECTURE VarLecture = { NULL, NULL, NULL, NULL };



void WinPlay_quit (void)
{
	gtk_widget_destroy(VarLecture.AdrWin);
	VarLecture.AdrWin           = NULL;
	VarLecture.AdrAdjustAllFile = NULL;
	VarLecture.AdrHscaleAllFile = NULL;
	VarLecture.AdrLabelNameFile = NULL;
	VarLecture.AdrStatusBar     = NULL;
	
	wincontrol_remove_last ();
}

gboolean WinPlay_wind_lecture_delete_event (void)
{
	PlayerExec_user_to_quit ();
	WinPlay_quit ();
	gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (wind_main, "vbox_split")), TRUE);
	return FALSE;
}
gboolean WinPlay_wind_lecture_destroy_event (void)
{
	PlayerExec_user_to_quit ();
	WinPlay_quit ();
	gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (wind_main, "vbox_split")), TRUE);
	return FALSE;
}

void WinPlay_set_value_time (gdouble value)
{
	gchar   *Mess = NULL;
	gint     sec   = 0;

	if (value < 0.0)   value = 0.0;
	if (value > 100.0) value = 100.0;
	
	sec = (gint) ((VarPlayer.DOUBLE_TempsTotal * value) / 100.0);
	
	if (sec < 0) sec = 0;
	
	Mess = g_strdup_printf ("<b> %02d:%02d:%02d </b>", (sec/60)/60, (sec/60)%60, sec%60);
/*g_print("%s\n", Mess);*/
	
	if (WinPlay_IsOpen () == TRUE) {
		gtk_adjustment_set_value (GTK_ADJUSTMENT (VarLecture.AdrAdjustAllFile), value);
	}
	
	g_free (Mess);
	Mess = NULL;

}

gboolean WinPlay_change_value_time (GtkRange *range, GtkScrollType scroll, gdouble value, gpointer user_data)
{
	if (value < 0.0) value = 0.0;
	if (value > 100.0) value = 100.0;

	/*g_print ("%f\n", value);*/
	
	if (VarPlayer.Button != GDK_BUTTON_PRESS && VarPlayer.BoolPushButton == PUSH_BUTTON_PLAY) {
		PlayerExec_fifo_seek_with_hundr (value);
		VarPlayer.Button = -1;
	}

	VarPlayer.PercentTempsActuel = value;
	if (WinPlay_IsOpen () == TRUE) {
		gtk_adjustment_set_value (GTK_ADJUSTMENT (VarLecture.AdrAdjustAllFile), value);
	}
	return FALSE;
}
gboolean WinPlay_event_music (GtkWidget *treeview, GdkEvent *event, gpointer user_data)
{
	if (event->type == GDK_BUTTON_PRESS) {
		VarPlayer.Button = GDK_BUTTON_PRESS;
	}
	if (event->type == GDK_BUTTON_RELEASE) {
		VarPlayer.Button = GDK_BUTTON_RELEASE;
	}
	return (FALSE);
}

void WinPlay_hbox_lecture_realize (GtkWidget *widget)
{
	VarLecture.AdrAdjustAllFile = gtk_adjustment_new (0, 0, 100.0, 0.001, 1, 0);
	VarLecture.AdrHscaleAllFile = gtk_hscale_new (GTK_ADJUSTMENT (VarLecture.AdrAdjustAllFile));
	gtk_widget_show (VarLecture.AdrHscaleAllFile);
	gtk_scale_set_draw_value (GTK_SCALE (VarLecture.AdrHscaleAllFile), FALSE);
	gtk_box_pack_start (GTK_BOX (widget), VarLecture.AdrHscaleAllFile, TRUE, TRUE, 0);
	
	GTK_WIDGET_UNSET_FLAGS (widget, GTK_CAN_FOCUS);
	gtk_scale_set_value_pos (GTK_SCALE (VarLecture.AdrHscaleAllFile), GTK_POS_LEFT);

	g_signal_connect ((gpointer) VarLecture.AdrHscaleAllFile, "change_value", G_CALLBACK (WinPlay_change_value_time), NULL);
	g_signal_connect ((gpointer) VarLecture.AdrHscaleAllFile, "event",G_CALLBACK (WinPlay_event_music), NULL);
}



void WinPlay_button_lecture_begin (void)
{
	/*PRINT_FUNC_LF();*/
	VarPlayer.BoolPushButton = PUSH_BUTTON_PAUSE;
	VarPlayer.Button = GDK_BUTTON_RELEASE;
	PlayerExec_fifo_seek_with_hundr (0.0);
	VarPlayer.BoolPushButton = PUSH_BUTTON_PLAY;
	VarPlayer.Button = -1;
}
void WinPlay_button_lecture_recule (void)
{
	static gdouble value = 0.0;

	/*PRINT_FUNC_LF();*/

	value = gtk_adjustment_get_value (GTK_ADJUSTMENT (VarLecture.AdrAdjustAllFile));
	value -= 1.0;
	if (value < 0.0) value = 0.0;
	
	if (VarPlayer.BoolPushButton == PUSH_BUTTON_PLAY) {
		
		PlayerExec_fifo_seek_with_hundr (value);
	}
	else if (VarPlayer.BoolPushButton == PUSH_BUTTON_PAUSE) {
		
		VarPlayer.PercentTempsActuel = value;
		WinPlay_set_value_time (value);
	}
}
void WinPlay_button_lecture (void)
{
	PRINT_FUNC_LF();
	switch (Config_User.notebook_general) {
	case NOTEBOOK_FICHIERS :
		if (VarPlayer.BoolPushButton == PUSH_BUTTON_PAUSE) {
			
			PlayerExec_fifo_seek (VarPlayer.PercentTempsActuel);
		}
		else if (VarPlayer.BoolPushButton == PUSH_BUTTON_STOP) {
	
			PlayerExec_set_list (LIST_PLAY_FROM_FILE, 0.0, 0, file_get_glist_play ());
		}
		break;
	
	case NOTEBOOK_DVD_AUDIO :
		if (VarPlayer.BoolPushButton == PUSH_BUTTON_PAUSE) {
			
			PlayerExec_fifo_seek (VarPlayer.PercentTempsActuel);
		}
		else if (VarPlayer.BoolPushButton == PUSH_BUTTON_STOP) {
			
			PlayerExec_set_list (LIST_PLAY_FROM_DVD,
						var_dvdaudio.PlayDvdAudio.double_TempsTotal,
						var_dvdaudio.PlayDvdAudio.guint_TempsTotal,
						var_dvdaudio.PlayDvdAudio.list);
		}
		dvdaudio_set_etat_music_pixbuf (NULL, TRUE);
		break;
	
	case NOTEBOOK_CD_AUDIO :
		if (VarPlayer.BoolPushButton == PUSH_BUTTON_PAUSE) {
			
			PlayerExec_fifo_seek (VarPlayer.PercentTempsActuel);
		}
		else if (VarPlayer.BoolPushButton == PUSH_BUTTON_STOP) {
			
			PlayerExec_set_list (LIST_PLAY_FROM_CD, 0.0, 0, cdaudio_get_glist_play ());
		}
		break;
	}

	gtk_widget_show (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture_pause")));
	gtk_widget_hide (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture")));
	gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture_stop")), TRUE);
	
	VarPlayer.Button = -1;
	VarPlayer.BoolPushButton = PUSH_BUTTON_PLAY;
}
void WinPlay_button_lecture_pause (void)
{
	/*PRINT_FUNC_LF();*/
	
	gtk_widget_show (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture")));
	gtk_widget_hide (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture_pause")));
	gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture_stop")), TRUE);
	
	PlayerExec_user_to_pause ();
}
void WinPlay_button_lecture_stop (void)
{
	/*PRINT_FUNC_LF();*/
	PlayerExec_user_to_quit ();
	VarPlayer.Button = -1;
	VarPlayer.BoolPushButton = PUSH_BUTTON_STOP;
	
	gtk_widget_show (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture")));
	gtk_widget_hide (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture_pause")));
	gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture_stop")), FALSE);
	
}
void WinPlay_button_lecture_avance (void)
{
	static gdouble value = 0.0;

	/*PRINT_FUNC_LF();*/
	
	value = gtk_adjustment_get_value (GTK_ADJUSTMENT (VarLecture.AdrAdjustAllFile));
	value += 1.0;
	if (value > 100.0) value = 100.0;
	
	if (VarPlayer.BoolPushButton == PUSH_BUTTON_PLAY) {
		
		PlayerExec_fifo_seek_with_hundr (value);
	}
	else if (VarPlayer.BoolPushButton == PUSH_BUTTON_PAUSE) {
		
		VarPlayer.PercentTempsActuel = value;
		WinPlay_set_value_time (value);
	}
}
void WinPlay_button_lecture_end (void)
{
	PRINT_FUNC_LF();
	VarPlayer.BoolPushButton = PUSH_BUTTON_PAUSE;
	VarPlayer.Button = GDK_BUTTON_RELEASE;
	PlayerExec_fifo_seek_with_hundr (100.0);
	VarPlayer.BoolPushButton = PUSH_BUTTON_PLAY;
	VarPlayer.Button = -1;
}
void WinPlay_button_lecture_quitter (void)
{
	PlayerExec_user_to_quit ();
	WinPlay_quit ();
	gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (wind_main, "vbox_split")), TRUE);
}

void WinPlay_button_lecture_clicked (GtkButton *button)
{
	typedef struct {
		gchar	*NameWidget;
		void	(*Call_Func) (void);
	} TYPE_WIDGET;
	#define MAX_TYPE_WIDGET 8
	TYPE_WIDGET TypeWidget [ MAX_TYPE_WIDGET ] = {
	
	{"button_lecture_begin",	WinPlay_button_lecture_begin},
	{"button_lecture_recule",	WinPlay_button_lecture_recule},
	{"button_lecture",		WinPlay_button_lecture},
	{"button_lecture_pause",	WinPlay_button_lecture_pause},
	{"button_lecture_stop",		WinPlay_button_lecture_stop},
	{"button_lecture_avance",	WinPlay_button_lecture_avance},
	{"button_lecture_end",		WinPlay_button_lecture_end},
	{"button_lecture_quitter",	WinPlay_button_lecture_quitter}
	};

	gint cpt;
	
	if (VarLecture.AdrWin == NULL) return;
	
	for (cpt = 0; cpt < MAX_TYPE_WIDGET; cpt ++) {
		if (button == GTK_BUTTON (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, TypeWidget [ cpt ].NameWidget)))) {
			if (TypeWidget [ cpt ].Call_Func != NULL) {
				(*TypeWidget [ cpt ].Call_Func) ();
				break;
			}
		}
	}
}

void WinPlay_puts_statusbar (gchar *mess_label_status)
{
	if (var_utils.AdrLabelStatusbarGlobal) {
		
		gchar *New_Str = NULL;
		
		New_Str = g_strdup_printf (" <span font_desc=\"sans %d\"><span color=\"black\"><b>%s</b></span></span>",
					SIZE_CAR_STATUSBAR,
					mess_label_status);
		gtk_label_set_use_markup (GTK_LABEL (VarLecture.AdrStatusBar), TRUE);
		gtk_label_set_justify (GTK_LABEL (VarLecture.AdrStatusBar), GTK_JUSTIFY_CENTER);
		gtk_label_set_markup (GTK_LABEL (VarLecture.AdrStatusBar), New_Str);

		g_free (New_Str);
		New_Str = NULL;
	}
}


gboolean WinPlay_IsOpen (void)
{
	return (VarLecture.AdrWin == NULL ? FALSE : TRUE);
}

void WinPlay_after_end (void)
{
	if (WinPlay_IsOpen () == TRUE) {
		gtk_widget_show (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture")));
		gtk_widget_hide (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture_pause")));
		gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture_stop")), FALSE);
	}
	VarPlayer.BoolPushButton = PUSH_BUTTON_STOP;
}

void WinPlay_set_label_namefile (LIST_PLAY_FROM ListPlayFrom, gchar *From, gchar *NameFile)
{
	gboolean	 BoolAffiche = TRUE;
	gchar		*NewNameFile = fileanalyze_get_name_without_path_ext (NameFile, FALSE);
		
	gchar *str = g_strdup_printf ("<span color=\"blue\"><i>%s</i>\n<b>%s</b></span>", From, NewNameFile);
	gtk_label_set_markup (GTK_LABEL (VarLecture.AdrLabelNameFile), str);
	g_free (str);
	str = NULL;
	g_free (NewNameFile);
	NewNameFile = NULL;

	gtk_widget_show (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture_pause")));
	gtk_widget_hide (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture")));
	gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture_stop")), TRUE);
		
	BoolAffiche = (ListPlayFrom == LIST_PLAY_FROM_DVD) ? FALSE : TRUE;
	
	gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture_begin")), BoolAffiche);
	gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture_recule")), BoolAffiche);
	/*button_lecture
	button_lecture_pause
	button_lecture_stop*/
	gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture_avance")), BoolAffiche);
	gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture_end")), BoolAffiche);
	/*button_lecture_quitter*/
	gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "hbox_lecture")), BoolAffiche);	
}

void WinPlay_Open (LIST_PLAY_FROM ListPlayFrom, gchar *From, gchar *NameFile)
{
	if (VarLecture.AdrWin != NULL) {
		WinPlay_button_lecture_quitter ();
	}
	else {
		gboolean	BoolAffiche = TRUE;
		
		VarLecture.AdrWin = create_wind_lecture ();
		wincontrol_set_adr (
			VarLecture.AdrWin,		/* Window adress                */
			"Lecture",			/* Window name			*/
			TRUE,				/* gtk_window_set_transient_for */
			FALSE				/* gtk_window_set_modal         */
			);
		utils_set_default_icone_xcfa (VarLecture.AdrWin);
		gtk_widget_show_all (VarLecture.AdrWin);
		
		if (NameFile != NULL) {
			WinPlay_set_label_namefile (ListPlayFrom, From, NameFile);
		}
		
		BoolAffiche = (ListPlayFrom == LIST_PLAY_FROM_DVD) ? FALSE : TRUE;
		
		gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture_begin")), BoolAffiche);
		gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture_recule")), BoolAffiche);
		/*button_lecture
		button_lecture_pause
		button_lecture_stop*/
		gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture_avance")), BoolAffiche);
		gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture_end")), BoolAffiche);
		/*button_lecture_quitter*/
		gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "hbox_lecture")), BoolAffiche);
		
		gtk_widget_show (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture_pause")));
		gtk_widget_hide (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture")));
		gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (VarLecture.AdrWin, "button_lecture_stop")), TRUE);
	
		gtk_widget_set_sensitive (GTK_WIDGET (lookup_widget (wind_main, "vbox_split")), FALSE);
	}
}

gboolean WinPlay_Is_Ok (void)
{
	if (PlayerExec_is_activate_from_split () == TRUE) {
		wininfo_create (
			_("Split est en action  !"),
			_("   Arretez toutes les actions depuis Split ...    "),
			  "\n",
			_("   ... et recommencez."),
			  "\n",
			"");
		return (FALSE);
	}
	return (TRUE);	
}


