 /*
 * file      : options_musepack.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#include <gtk/gtk.h>
#include "support.h"
#include <string.h>
#include "global.h"
#include "config_user.h"
#include "cd_audio.h"
#include "utils.h"
#include "options.h"
#include <stdlib.h>
#include <glib.h>
#include <glib/gstdio.h>
#include "info_song.h"

/*
*---------------------------------------------------------------------------
* VARIABLES
*---------------------------------------------------------------------------
*/

/*
*---------------------------------------------------------------------------
* CODE
*---------------------------------------------------------------------------
*/
void optionsMusepack_combobox_mppenc_realize (GtkWidget *widget)
{
	var_options.Adr_Widget_Mppenc = GTK_COMBO_BOX (widget);
	utils_clear_elements_combobox (widget);
	
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("telephone: lowest quality              :   32 ..  48 kbit/s"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("thumb      : low quality/internet     :   58 ..  86 kbit/s"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("radio        : medium (MP3) quality : 112 .. 152 kbit/s"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("standard  : high quality (dflt)         : 142 .. 184 kbit/s"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("xtreme     : extreme high quality   : 168 .. 212 kbit/s"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("insane      : extreme high quality   : 232 .. 268 kbit/s"));
	gtk_combo_box_append_text (GTK_COMBO_BOX (widget), _("braindead : extreme high quality   : 232 .. 278 kbit/s"));
	
	gtk_combo_box_set_active (GTK_COMBO_BOX (widget), Config_User.quality_mppenc);
}
gchar *optionsMusepack_get_quality_mppenc (void)
{
	gchar *str_val_preset[] = {
		"--telephone",
		"--thumb",
		"--radio",
		"--standard",
		"--xtreme",
		"--insane",
		"--braindead"
	};
	return ( (gchar *)str_val_preset[ gtk_combo_box_get_active (var_options.Adr_Widget_Mppenc) ]);
}

void optionsMusepack_combobox_mppenc_changed (void)
{
	options_set_datas_interne (COLOR_MUSEPACK_QUALITE, var_options.Adr_label_musepack_mpc, MPPENC_WAV_TO_MPC);
}
