 /*
 * file      : get.c
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 */



#include <gtk/gtk.h>
#include "support.h"

#include <pthread.h>
#include <sys/types.h>
#include <signal.h>
#include <sys/wait.h>
#include <unistd.h>
#include <stdlib.h>
#include <string.h>

#include "global.h"
#include "prg_init.h"
#include "get.h"
#include "info_song.h"
#include "prg_install.h"
#include "utils.h"
#include "scan_cd.h"

#define GET_MAX_CARS 1024


typedef struct {

	pid_t      code_fork;		/* Num Code Fork	*/
	int        signal_numchildren;	/* the signal handler	*/
	int        tube [ 2 ];		/* for pipe		*/

} GET;

GET get;


/*
*---------------------------------------------------------------------------
* SIGNAL
*---------------------------------------------------------------------------
*/

void get_sigchld (gint signum)
{
        gint status;

        wait(&status);

	/* PRINT_FUNC(); */
        /* if there are still children waiting
        *  re-install the signal handler
	*/
	get.signal_numchildren --;
        if (get.signal_numchildren > 0)
        {
                /* re-install the signal handler */
                signal (SIGCHLD, get_sigchld);
        }
}

gint get_exec_with_output (gchar **args, pid_t *p, gint Streams)
{
	get.signal_numchildren = 0;

	if (pipe (get.tube) != 0)
	{
		fprintf (stderr, "error: pipe\n");
		exit (1);
	}
	if ((*p = fork()) == 0)
	{
		dup2 (get.tube [ 1 ], Streams); /* STDOUT_FILENO STDERR_FILENO */
		execvp (args[0], args);
		fprintf (stderr, "error: exec");
		exit (2);
	}
	get.signal_numchildren ++;
	signal (SIGCHLD, get_sigchld);
	close (get.tube [ 1 ]);
	return (get.tube [ 0 ]);
}


/*
*---------------------------------------------------------------------------
* FUNCTION
*---------------------------------------------------------------------------
*/


GString *get_with_file (gchar *file)
{
	gint     fd;
	gint     pos = 0;
	gchar   *args [ 10 ];
	gchar    buf [ GET_MAX_CARS + 10 ];
	gint     size = 0;
	GString *gstr = g_string_new (NULL);

	args[pos++] = "file";
	args[pos++] = "-b";
	args[pos++] = "-z";
	args[pos++] = "-n";
	args[pos++] = file;
	args[pos++] = NULL;

/*
	g_print ("!-----------------------------------!\n");
	g_print ("!             F I L E               !\n");
	g_print ("!-----------------------------------!\n");
	for (pos = 0; args[ pos ] != NULL; pos++)
		g_print ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	g_print ("\n");
*/

	fd = get_exec_with_output (args, &get.code_fork, STDOUT_FILENO);

	do {
		pos = -1;
		do {
			pos++;
			if (pos >= GET_MAX_CARS) {
				PRINT_FUNC_LF();
				g_print ("pos(%d) >= GET_MAX_CARS(%d)\n", pos, GET_MAX_CARS);
				pos --;
			}
			size = read(fd, &buf[pos], 1);

		} while ((buf[pos] != '\b') && (buf[pos] != '\r') && (buf[pos] != '\n') && (size > 0));
		/*
		if (pos > 0 ) {
			buf[pos ++ ] = '\n';
			buf[pos] = '\0';
			g_string_append_printf (gstr, "%s", buf);
		}
		*/
		buf[pos ++ ] = '\n';
		buf[pos] = '\0';
		g_string_append_printf (gstr, "%s", buf);

	} while (size != 0);

	close(fd);
	return (gstr);
}

GString *get_with_faad (gchar *file)
{
	gint     fd;
	gint     pos = 0;
	gchar   *args [ 10 ];
	gchar    buf [ GET_MAX_CARS + 10 ];
	gint     size = 0;
	GString *gstr = g_string_new (NULL);

	args[pos++] = "faad";
	args[pos++] = "-i";
	args[pos++] = file;
	args[pos++] = NULL;

	/*
	g_print ("!-----------------------------------!\n");
	g_print ("!             F A A D               !\n");
	g_print ("!-----------------------------------!\n");
	for (pos = 0; args[ pos ] != NULL; pos++)
		g_print ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	g_print ("\n");
	*/

	fd = get_exec_with_output (args, &get.code_fork, STDERR_FILENO);
	do {
		pos = -1;
		do {
			pos++;
			if (pos >= GET_MAX_CARS) {
				PRINT_FUNC_LF();
				g_print ("pos(%d) >= GET_MAX_CARS(%d)\n", pos, GET_MAX_CARS);
				pos --;
			}
			size = read(fd, &buf[pos], 1);

		} while ((buf[pos] != '\b') && (buf[pos] != '\r') && (buf[pos] != '\n') && (size > 0));
		/*
		if (pos > 0 ) {
			buf[pos ++ ] = '\n';
			buf[pos] = '\0';
			g_string_append_printf (gstr, "%s", buf);
		}
		*/
		buf[pos ++ ] = '\n';
		buf[pos] = '\0';
		g_string_append_printf (gstr, "%s", buf);

	} while (size != 0);

	close(fd);
	return (gstr);
}

GString *get_with_checkmp3 (gchar *file)
{
	gint     fd;
	gint     pos = 0;
	gchar   *args [ 10 ];
	gchar    buf [ GET_MAX_CARS + 10 ];
	gint     size = 0;
	GString *gstr = NULL;

	gstr = g_string_new (NULL);

	// args[pos++] = PrgInit.name_checkmp3;
	args[pos++] = prginit_get_name (NMR_checkmp3);
	args[pos++] = "-a";
	args[pos++] = "-v";
	args[pos++] = "-i";
	args[pos++] = file;
	args[pos++] = NULL;
	/*
	g_print ("!-----------------------------------!\n");
	g_print ("!           C H E C K M P 3         !\n");
	g_print ("!-----------------------------------!\n");
	for (pos = 0; args[ pos ] != NULL; pos++)
		g_print ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	g_print ("\n");
	*/
	fd = get_exec_with_output (args, &get.code_fork, STDOUT_FILENO);
	do {
		pos = -1;
		do {
			pos++;
			if (pos >= GET_MAX_CARS) {
				PRINT_FUNC_LF();
				g_print ("pos(%d) >= GET_MAX_CARS(%d)\n", pos, GET_MAX_CARS);
				pos --;
			}
			size = read(fd, &buf[pos], 1);

		} while ((buf[pos] != '\b') && (buf[pos] != '\r') && (buf[pos] != '\n') && (size > 0));
		if (pos > 0 ) {
			buf[pos ++ ] = '\n';
			buf[pos] = '\0';
			g_string_append_printf (gstr, "%s", buf);
		}
	} while (size != 0);

	close(fd);
	return (gstr);
}

GString *get_with_ogginfo (gchar *file)
{
	gint     fd;
	gint     pos = 0;
	gchar   *args [ 10 ];
	gchar    buf [ GET_MAX_CARS + 10 ];
	gint     size = 0;
	GString *gstr = g_string_new (NULL);

	args[pos++] = "ogginfo";
	args[pos++] = file;
	args[pos++] = NULL;

	/*
	g_print ("!-----------------------------------!\n");
	g_print ("!           O G G I N F O           !\n");
	g_print ("!-----------------------------------!\n");
	for (pos = 0; args[ pos ] != NULL; pos++)
		g_print ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	g_print ("\n");
	*/

	fd = get_exec_with_output (args, &get.code_fork, STDOUT_FILENO);
	do {
		pos = -1;
		do {
			pos++;
			if (pos >= GET_MAX_CARS) {
				PRINT_FUNC_LF();
				g_print ("pos(%d) >= GET_MAX_CARS(%d)\n", pos, GET_MAX_CARS);
				pos --;
			}
			size = read(fd, &buf[pos], 1);

		} while ((buf[pos] != '\b') && (buf[pos] != '\r') && (buf[pos] != '\n') && (size > 0));
		if (pos > 0 ) {
			buf[pos ++ ] = '\n';
			buf[pos] = '\0';
			g_string_append_printf (gstr, "%s", buf);
		}
	} while (size != 0);

	close(fd);
	return (gstr);
}
GString *get_with_mediainfo (gchar *file)
{
	gint     fd;
	gint     pos = 0;
	gchar   *args [ 10 ];
	gchar    buf [ GET_MAX_CARS + 10 ];
	gint     size = 0;
	GString *gstr = g_string_new (NULL);

	args[pos++] = "dvd+rw-mediainfo";
	args[pos++] = file;
	args[pos++] = NULL;

	/*
	g_print ("!-----------------------------------!\n");
	g_print ("!        DVD+RW-MEDIAINFO           !\n");
	g_print ("!-----------------------------------!\n");
	for (pos = 0; args[ pos ] != NULL; pos++)
		g_print ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	g_print ("\n");
	*/

	fd = get_exec_with_output (args, &get.code_fork, STDOUT_FILENO);
	do {
		pos = -1;
		do {
			pos++;
			if (pos >= GET_MAX_CARS) {
				PRINT_FUNC_LF();
				g_print ("pos(%d) >= GET_MAX_CARS(%d)\n", pos, GET_MAX_CARS);
				pos --;
			}
			size = read(fd, &buf[pos], 1);

		} while ((buf[pos] != '\b') && (buf[pos] != '\r') && (buf[pos] != '\n') && (size > 0));
		if (pos > 0 ) {
			buf[pos ++ ] = '\n';
			buf[pos] = '\0';
			g_string_append_printf (gstr, "%s", buf);
		}
	} while (size != 0);

	close(fd);
	return (gstr);
}
GString *get_with_cdplay (gchar *file)
{
	gint     fd;
	gint     pos = 0;
	gchar   *args [ 10 ];
	gchar    buf [ GET_MAX_CARS + 10 ];
	gint     size = 0;
	GString *gstr = g_string_new (NULL);

	args[pos++] = "cdplay";
	args[pos++] = "-d";
	args[pos++] = file;
	args[pos++] = "info";
	args[pos++] = NULL;

	/*
	g_print ("!-----------------------------------!\n");
	g_print ("!           C D P L A Y             !\n");
	g_print ("!-----------------------------------!\n");
	for (pos = 0; args[ pos ] != NULL; pos++)
		g_print ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	g_print ("\n");
	*/

	fd = get_exec_with_output (args, &get.code_fork, STDOUT_FILENO);
	do {
		pos = -1;
		do {
			pos++;
			if (pos >= GET_MAX_CARS) {
				PRINT_FUNC_LF();
				g_print ("pos(%d) >= GET_MAX_CARS(%d)\n", pos, GET_MAX_CARS);
				pos --;
			}
			size = read(fd, &buf[pos], 1);

		} while ((buf[pos] != '\b') && (buf[pos] != '\r') && (buf[pos] != '\n') && (size > 0));
		if (pos > 0 ) {
			buf[pos ++ ] = '\n';
			buf[pos] = '\0';
			g_string_append_printf (gstr, "%s", buf);
		}
	} while (size != 0);

	close(fd);
	return (gstr);
}
GString *get_with_which (gchar *file)
{
	gint     fd;
	gint     pos = 0;
	gchar   *args [ 10 ];
	gchar    buf [ GET_MAX_CARS + 10 ];
	gint     size = 0;
	GString *gstr = g_string_new (NULL);

	args[pos++] = "which";
	args[pos++] = file;
	args[pos++] = NULL;

	/*
	g_print ("!-----------------------------------!\n");
	g_print ("!             W H I C H             !\n");
	g_print ("!-----------------------------------!\n");
	for (pos = 0; args[ pos ] != NULL; pos++)
		g_print ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	g_print ("\n");
	*/

	fd = get_exec_with_output (args, &get.code_fork, STDOUT_FILENO);
	do {
		pos = -1;
		do {
			pos++;
			if (pos >= GET_MAX_CARS) {
				PRINT_FUNC_LF();
				g_print ("pos(%d) >= GET_MAX_CARS(%d)\n", pos, GET_MAX_CARS);
				pos --;
			}
			size = read(fd, &buf[pos], 1);

		} while ((buf[pos] != '\b') && (buf[pos] != '\r') && (buf[pos] != '\n') && (size > 0));
		if (pos > 0 ) {
			buf[pos ++ ] = '\n';
			buf[pos] = '\0';
			g_string_append_printf (gstr, "%s", buf);
		}
	} while (size != 0);

	close(fd);
	return (gstr);
}

void get_with_eject (gchar *StrDevice)
{
	gint     fd;
	gint     pos = 0;
	gchar   *args [ 10 ];
	gchar    buf [ GET_MAX_CARS + 10 ];
	gint     size = 0;

	args[pos++] = "eject";
	args[pos++] = "--cdrom";
	args[pos++] = StrDevice;
	args[pos++] = NULL;

	/*
	g_print ("!-----------------------------------!\n");
	g_print ("!              E J E C T            !\n");
	g_print ("!-----------------------------------!\n");
	for (pos = 0; args[ pos ] != NULL; pos++)
		g_print ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	g_print ("\n");
	*/

	fd = get_exec_with_output (args, &get.code_fork, STDERR_FILENO);
	do {
		pos = -1;
		do {
			pos++;
			if (pos >= GET_MAX_CARS) {
				PRINT_FUNC_LF();
				g_print ("pos(%d) >= GET_MAX_CARS(%d)\n", pos, GET_MAX_CARS);
				pos --;
			}
			size = read(fd, &buf[pos], 1);

		} while ((buf[pos] != '\b') && (buf[pos] != '\r') && (buf[pos] != '\n') && (size > 0));
	} while (size != 0);

	close(fd);
}

GString *get_with_cdparanoia (gchar *file)
{
	gint     fd;
	gint     pos = 0;
	gchar   *args [ 10 ];
	gchar    buf [ GET_MAX_CARS + 10 ];
	gint     size = 0;
	GString *gstr = g_string_new (NULL);

	args[pos++] = "cdparanoia";
	args[pos++] = "-Q";
	args[pos++] = "-d";
	args[pos++] = file;
	args[pos++] = NULL;

	/*
	g_print ("!-----------------------------------!\n");
	g_print ("!       C D P A R A N O I A         !\n");
	g_print ("!-----------------------------------!\n");
	for (pos = 0; args[ pos ] != NULL; pos++)
		g_print ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	g_print ("\n");
	*/

	fd = get_exec_with_output (args, &get.code_fork, STDERR_FILENO);
	do {
		pos = -1;
		do {
			pos++;
			if (pos >= GET_MAX_CARS) {
				PRINT_FUNC_LF();
				g_print ("pos(%d) >= GET_MAX_CARS(%d)\n", pos, GET_MAX_CARS);
				pos --;
			}
			size = read(fd, &buf[pos], 1);

		} while ((buf[pos] != '\b') && (buf[pos] != '\r') && (buf[pos] != '\n') && (size > 0));
		if (pos > 0 ) {
			buf[pos ++ ] = '\n';
			buf[pos] = '\0';
			g_string_append_printf (gstr, "%s", buf);
		}
	} while (size != 0);

	close(fd);
	return (gstr);
}

GString *get_with_metaflac (gchar *file)
{
	gint     fd;
	gint     pos = 0;
	gchar   *args [ 10 ];
	gchar    buf [ GET_MAX_CARS + 10 ];
	gint     size = 0;
	GString *gstr = g_string_new (NULL);

	args[pos++] = "metaflac";
	args[pos++] = "--show-total-samples";
	args[pos++] = "--show-sample-rate";
	args[pos++] = file;
	args[pos++] = NULL;

	/*
	g_print ("!-----------------------------------!\n");
	g_print ("!         M E T A F L A C           !\n");
	g_print ("!-----------------------------------!\n");
	for (pos = 0; args[ pos ] != NULL; pos++)
		g_print ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	g_print ("\n");
	*/

	fd = get_exec_with_output (args, &get.code_fork, STDOUT_FILENO);
	do {
		pos = -1;
		do {
			pos++;
			if (pos >= GET_MAX_CARS) {
				PRINT_FUNC_LF();
				g_print ("pos(%d) >= GET_MAX_CARS(%d)\n", pos, GET_MAX_CARS);
				pos --;
			}
			size = read(fd, &buf[pos], 1);

		} while ((buf[pos] != '\b') && (buf[pos] != '\r') && (buf[pos] != '\n') && (size > 0));
		if (pos > 0 ) {
			buf[pos ++ ] = '\n';
			buf[pos] = '\0';
			g_string_append_printf (gstr, "%s", buf);
		}
	} while (size != 0);

	close(fd);
	return (gstr);
}

void get_with_wget (void)
{
	gint     fd;
	gint     pos = 0;
	gchar   *args [ 10 ];
	gchar    buf [ GET_MAX_CARS + 10 ];
	gint     size = 0;

	args[pos++] = "wget";
	args[pos++] = "--user-agent=\"Mozilla 22.0\"";
	args[pos++] = "--directory-prefix=/tmp/";
	args[pos++] = "http://www.google.fr/index.html";
	args[pos++] = NULL;
	args[pos++] = NULL;

	/*g_print ("!-----------------------------------!\n");
	g_print ("!             W G E T               !\n");
	g_print ("!-----------------------------------!\n");
	for (pos = 0; args[ pos ] != NULL; pos++)
		g_print ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	g_print ("\n");*/

	fd = get_exec_with_output (args, &get.code_fork, STDERR_FILENO);
	do {
		pos = -1;
		do {
			pos++;
			if (pos >= GET_MAX_CARS) {
				PRINT_FUNC_LF();
				g_print ("pos(%d) >= GET_MAX_CARS(%d)\n", pos, GET_MAX_CARS);
				pos --;
			}
			size = read(fd, &buf[pos], 1);

		} while ((buf[pos] != '\b') && (buf[pos] != '\r') && (buf[pos] != '\n') && (size > 0));
		/*
		if (pos > 0 ) {
			buf[pos ++ ] = '\n';
			buf[pos] = '\0';
		}
		*/
	} while (size != 0);

	close(fd);
}

gint get_in_super_user (void)
{
	gchar	*args[ 15 ];
	gint	pos = 0;
	gint	fd;
	gchar	buf [ GET_MAX_CARS + 10 ];
	gint	size = 0;
	gint	RetCode = 1;

	/* La liste des arguments ... */
	if (utils_scan_by_which (GK_SUDO, NULL) == TRUE) {
		args [ pos++ ] = GK_SUDO;
		args [ pos++ ] = "-u";
		args [ pos++ ] = "root";
	}
	else if (utils_scan_by_which (KDE_SUDO, NULL) == TRUE) {
		args [ pos++ ] = KDE_SUDO;
		args [ pos++ ] = "-u";
		args [ pos++ ] = "root";
	}
	else if (utils_scan_by_which (RPM_SUDO, NULL) == TRUE) {
		args [ pos++ ] = RPM_SUDO;
	}

	args [ pos++ ] = "/tmp/xcfa_install.sh";

	/* qui doit se finir par NULL */
	args [ pos++ ] = NULL;
	args [ pos++ ] = NULL;

	/* Affichage en console de la liste */
	/*g_print ("!-----------------------------------!\n");
	g_print ("!               %s\n", args [0] );
	g_print ("!-----------------------------------!\n");
	for (pos = 0; args[ pos ] != NULL; pos++)
		g_print ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	g_print ("\n");*/

	fd = get_exec_with_output (args, &get.code_fork, STDERR_FILENO);

	do {
		pos = -1;
		do {
			pos++;
			if (pos >= GET_MAX_CARS) {
				PRINT_FUNC_LF();
				g_print ("pos(%d) >= GET_MAX_CARS(%d)\n", pos, GET_MAX_CARS);
				pos --;
			}
			size = read(fd, &buf[pos], 1);

		} while ((buf[pos] != '\b') && (buf[pos] != '\r') && (buf[pos] != '\n') && (size > 0));
		
		if (strstr (buf, "is another process using it?") != NULL) {
			RetCode = 0;
			break;
		}
	} while (size != 0);

	close(fd);
	return (RetCode);
}

/*
gboolean get_version_metaflac_is_ok (void)
{
	gint     fd;
	gint     pos = 0;
	gchar   *args [ 10 ];
	gchar    buf [ GET_MAX_CARS + 10 ];
	gint     size = 0;
	gchar    StrVersion [ 50 ];
	gint     Major;
	gint     Minor;
	gint     Reste;
	gchar   *Ptr = NULL;

	args[pos++] = "metaflac";
	args[pos++] = "--version";
	args[pos++] = NULL;

	g_print ("!-----------------------------------!\n");
	g_print ("!    M E T A F L A C  --version     !\n");
	g_print ("!-----------------------------------!\n");
	for (pos = 0; args[ pos ] != NULL; pos++)
		g_print ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	g_print ("\n");

	fd = get_exec_with_output (args, &get.code_fork, STDOUT_FILENO);
	do {
		pos = -1;
		do {
			pos++;
			if (pos >= GET_MAX_CARS) {
				PRINT_FUNC_LF();
				g_print ("pos(%d) >= GET_MAX_CARS(%d)\n", pos, GET_MAX_CARS);
				pos --;
			}
			size = read(fd, &buf[pos], 1);

		} while ((buf[pos] != '\b') && (buf[pos] != '\r') && (buf[pos] != '\n') && (size > 0));
		pos ++;
		buf[pos] = '\0';
		if (strstr (buf, "metaflac"))strcpy (StrVersion, buf);

	} while (size != 0);

	close(fd);
	g_print ("StrVersion = %s\n", StrVersion);
	Ptr = &StrVersion[0];
	while (*Ptr < '0' || *Ptr > '9') Ptr++;
	g_print ("Ptr = %s\n", Ptr);
	Major = atoi (Ptr);
	g_print ("Major = %d\n", Major);
	Ptr ++;

	return (TRUE);
}
*/

/* Renvoie la taille pour les types
 *	ape
 *	wv
 *	shn
 *Length:                       1:25.09
 *
 */
/*
typedef struct {
	guint	 SecTime;
	gchar	*time;
	gchar	*size;
} SHNTAG;
*/

SHNTAG *get_free_shntool (SHNTAG *ShnTag)
{
	if (ShnTag != NULL) {
		g_free (ShnTag->time);
		g_free (ShnTag->size);

		g_free (ShnTag);
		ShnTag = NULL;
	}

	return ((SHNTAG *)NULL);

}

SHNTAG *get_with_shntool (gchar *file)
{
	gint     fd;
	gint     pos = 0;
	gchar   *args [ 10 ];
	gchar    buf [ GET_MAX_CARS + 10 ];
	gint     size = 0;
	GString *gstr = g_string_new (NULL);
	SHNTAG	*ShnTag = NULL;
	gchar	*Ptr = NULL;

	guint	 Min;
	guint	 Sec;
	guint	 Hundr;

	args[pos++] = "shntool";
	args[pos++] = "info";
	args[pos++] = file;
	args[pos++] = NULL;

	/*
	g_print ("!-----------------------------------!\n");
	g_print ("!         M E T A F L A C           !\n");
	g_print ("!-----------------------------------!\n");
	for (pos = 0; args[ pos ] != NULL; pos++)
		g_print ("args [ %02d ] = '%s'\n", pos, args [ pos ]);
	g_print ("\n");
	*/

	fd = get_exec_with_output (args, &get.code_fork, STDOUT_FILENO);
	do {
		pos = -1;
		do {
			pos++;
			if (pos >= GET_MAX_CARS) {
				PRINT_FUNC_LF();
				g_print ("pos(%d) >= GET_MAX_CARS(%d)\n", pos, GET_MAX_CARS);
				pos --;
			}
			size = read(fd, &buf[pos], 1);

		} while ((buf[pos] != '\b') && (buf[pos] != '\r') && (buf[pos] != '\n') && (size > 0));
		if (pos > 0 ) {
			buf[pos ++ ] = '\n';
			buf[pos] = '\0';
			g_string_append_printf (gstr, "%s", buf);
		}
	} while (size != 0);

	close(fd);

	ShnTag = g_malloc0 (sizeof (SHNTAG));

	if ((Ptr = strstr (gstr->str, "Length:")) != NULL) {
		Ptr = strchr (Ptr, ':');
		Ptr ++;
		while (*Ptr == ' ') Ptr ++;

		Min = atoi (Ptr);

		Ptr = strchr (Ptr, ':');
		Ptr ++;
		Sec = atoi (Ptr);

		Ptr = strchr (Ptr, '.');
		Ptr ++;
		Hundr = atoi (Ptr);

		ShnTag->SecTime = (gdouble)(Min * 60) + (gdouble)(Sec) + (gdouble)(Hundr / 10.0);

		ShnTag->time = g_strdup_printf ("%02d:%02d", Min, Sec);

		if ((Ptr = strchr (ShnTag->time, '.')) != NULL) {
			*Ptr = '\0';
		}
	}

	ShnTag->size = g_strdup_printf ("%d Ko", (gint)infosong_get_size_file (file) / 1024);

	g_string_free (gstr, TRUE);

	return ((SHNTAG *)ShnTag);
}









