 /*
 * file      : file.h
 * project   : xcfa
 * with      : Gtk-2
 *
 * copyright : (C) 2003,2004,2005,2006,2007,2008,2009 by Claude Bulin
 *
 * xcfa - GTK+ implementation of the GNU shell command
 * GNU General Public License
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * OLD ADRESS:
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 * NEW ADRESS:
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 * 
 */


#ifndef __file_h__
#define __file_h__ 1

typedef struct {
	gboolean		 bool_tag_cd;				/* TRUE is CD-AUDIO else is FILE				*/
	gboolean		 bool_save;				/* TRUE -> save							*/
	gchar			*Album;					/* %b								*/
	gchar			*Artist;				/* %a								*/
	gchar			*Title;					/* %d								*/
	gchar			*Number;				/* %c								*/
	gint			 IntNumber;				/*								*/
	gchar			*Genre;					/* %g								*/
	gint			 IntGenre;				/*								*/
	gchar			*Year;					/* %e								*/
	gint			 IntYear;				/*								*/
	gchar			*Comment;				/*								*/
	gchar			*Description;				/*								*/
} TAGS;

/*
*---------------------------------------------------------------------------
* I N F O _
*---------------------------------------------------------------------------
*/

typedef struct {
	gdouble			 Value;					/* 								*/
	gdouble			 ValueMarkA;				/* 								*/
	gdouble			 ValueMarkB;				/* 								*/
	guint			 SecTime;				/* 								*/
} VALUE_MARK;

typedef struct {
	gint			 level;					/* Niveau en dBFS						*/
	gint			 NewLevel;				/* Nouveau niveau en dBFS					*/
} LEVEL_DBFS;

typedef struct {
	gchar			*namefile;				/* Nom complet du fichier					*/
	gchar			*time;					/* Temps d'ecoute						*/
	guint			 SecTime;				/* Temps d'ecoute en secondes					*/
	VALUE_MARK		 ValueMark;				/*								*/
	gchar			*hertz;					/*								*/
	TAGS			*tags;					/* Tags								*/
} INFO_M4A;

typedef struct {
	gchar			*namefile;				/* Nom complet du fichier					*/
	gchar			*time;					/* Temps d'ecoute						*/
	guint			 SecTime;				/* Temps d'ecoute en secondes					*/
	VALUE_MARK		 ValueMark;				/*								*/
	gchar			*hertz;					/*								*/
	TAGS			*tags;					/* Tags								*/
} INFO_AAC;

typedef struct {
	gchar			*namefile;				/* Nom complet du fichier					*/
	gchar			*time;					/* Temps d'ecoute						*/
	guint			 SecTime;				/* Temps d'ecoute en secondes					*/
	VALUE_MARK		 ValueMark;				/*								*/
	gchar			*hertz;					/*								*/
	gchar			*voie;					/*								*/
	gchar			*bits;					/*								*/
	TAGS			*tags;					/* Tags								*/
	LEVEL_DBFS		 LevelDbfs;
} INFO_WAV;

typedef enum {								/* type:     bitrate:                                             */
	MPEG_1 = 0,							/* MPV_1     [ 32 40 48 56 64 80 96 112 128 160 192 224 256 320 ] */
	MPEG_2,								/* MPV_2     [  8 16 24 32 40 48 56  64  80  96 112 128 144 160 ] */
	MPEG_25								/* MPV_25    [  8 16 24 32 40 48 56  64  80  96 112 128 144 160 ] */
} MPEG_IS;

typedef struct {
	gchar			*namefile;				/* Nom complet du fichier					*/
	gchar			*bitrate;				/*								*/
	gchar			*time;					/* Temps d'ecoute						*/
	guint			 SecTime;				/* Temps d'ecoute en secondes					*/
	VALUE_MARK		 ValueMark;				/*								*/
	MPEG_IS			 mpeg_is;				/*								*/
	gchar			*size;					/*								*/
	TAGS			*tags;					/* Tags								*/
	LEVEL_DBFS		 LevelDbfs;				/*								*/
} INFO_MP3;

typedef struct {
	gchar			*namefile;				/* Nom complet du fichier					*/
	gchar			*Channels;				/*								*/
	gchar			*Rate;					/*								*/
	gchar			*Nominal_bitrate;			/*								*/
	gchar			*time;					/* Temps d'ecoute						*/
	guint			 SecTime;				/* Temps d'ecoute en secondes					*/
	VALUE_MARK		 ValueMark;				/*								*/
	gchar			*size;					/*								*/
	TAGS			*tags;					/* Tags								*/
	LEVEL_DBFS		 LevelDbfs;				/* Datas du dBFS						*/
} INFO_OGG;

typedef struct {
	gchar			*namefile;				/* Nom complet du fichier					*/
	gchar			*time;					/* Temps d'ecoute						*/
	guint			 SecTime;				/* Temps d'ecoute en secondes					*/
	VALUE_MARK		 ValueMark;				/*								*/
	TAGS			*tags;					/* Tags								*/
} INFO_FLAC;

typedef struct {
	gchar			*namefile;				/* Nom complet du fichier					*/
	TAGS			*tags;					/* Tags								*/
} INFO_WMA;

typedef struct {
	gchar			*namefile;				/* Nom complet du fichier					*/
	TAGS			*tags;					/* Tags								*/
} INFO_MPC;

typedef struct {
	gchar			*namefile;				/* Nom complet du fichier					*/
	TAGS			*tags;					/* Tags								*/
	gchar			*time;					/* Temps d'ecoute						*/
	guint			 SecTime;				/* Temps d'ecoute en secondes					*/
	VALUE_MARK		 ValueMark;				/*								*/
	gchar			*size;					/*								*/
} INFO_SHN;

typedef struct {
	gchar			*namefile;				/* Nom complet du fichier					*/
	TAGS			*tags;					/* Tags								*/
	gchar			*time;					/* Temps d'ecoute						*/
	guint			 SecTime;				/* Temps d'ecoute en secondes					*/
	VALUE_MARK		 ValueMark;				/*								*/
	gchar			*size;					/*								*/
} INFO_APE;

typedef struct {
	gchar			*namefile;				/* Nom complet du fichier					*/
	TAGS			*tags;					/* Tags								*/
	gchar			*time;					/* Temps d'ecoute						*/
	guint			 SecTime;				/* Temps d'ecoute en secondes					*/
	VALUE_MARK		 ValueMark;				/*								*/
	gchar			*size;					/*								*/
} INFO_WAVPACK;

/*
*---------------------------------------------------------------------------
* F I C    M P 3 O G G
*---------------------------------------------------------------------------
*/

typedef struct {
	gint			type;
	gint			debit;
	gint			mode;

} TYPE_MP3OGG;

typedef struct {

	gboolean		 Bool_Conv;				/* TRUE si convertion						*/

	gchar			*New_src;				/* Temporaire: Pathname						*/
	gchar			*destwav;				/* Temporaire: Pathname						*/
	gchar			*destsox;				/* Temporaire: Pathname						*/
	gchar			*destmp3;				/* Temporaire: Pathname						*/
	gchar			*destogg;				/* Temporaire: Pathname						*/
	gchar			*destfile;				/* Destination du fichier apres rectification			*/

	gchar			*Bitrate;				/* Le bitrate actuel						*/
	/*gchar			*NewBitrate;				 Le nouveau bitrate						*/
	
	TYPE_MP3OGG		Lame;
	TYPE_MP3OGG		Oggenc;
	
} FIC_MP3OGG;

/*
*---------------------------------------------------------------------------
* F I C    W A V
*---------------------------------------------------------------------------
*/

typedef struct {

	gboolean 		 Bool_Conv;				/* TRUE si convertion						*/

	gchar			*Path;					/* Path du fichier source					*/
	gchar			*TmpSrc;				/* $TMP/original						*/
	gchar			*TmpDest;				/* $TMP/modifie							*/
	gchar			*TmpMplayer;				/* $TMP/							*/
	gchar			*NameDest;				/* Copie vers la destination					*/
	
									/* Caracteristique de départ					*/
	gchar			*Hertz;					/* Taux d'échantillonnage en hertz (qualité du son)		*/
	gchar			*Voie;					/* 1, 2 ou 4							*/
	gchar			*Bits;					/* 8, 16, 32 ou 64						*/

									/* Nouvelles caracteristiques					*/
	gchar 			*NewHertz;				/* NEW								*/
	gchar			*NewVoie;				/* NEW								*/
	gchar			*NewBits;				/* NEW								*/
} FIC_WAV;

/*
*---------------------------------------------------------------------------
* F I C
*---------------------------------------------------------------------------
*/

typedef enum {

	FILE_IS_NONE = 0,
	FILE_IS_FLAC,
	FILE_IS_WAV,
	FILE_IS_MP3,
	FILE_IS_OGG,
	/* Les fichiers au format AAC, portant l'extension
		.mp4 (pour MPEG-4),
	   	.m4a (pour MPEG-4 Audio)
	   	.m4p (pour MPEG-4 Protégé),
	   sont globalement plus petits que les fichiers au format MP3. */
	FILE_IS_M4A,
	FILE_IS_AAC,
	FILE_IS_SHN,
	FILE_IS_WMA,
	FILE_IS_MPC,
	FILE_IS_APE,
	FILE_IS_WAVPACK,
	FILE_IS_WAVPACK_MD5,
	FILE_IS_CUE,
	
	FILE_TO_NORMALISE,
	FILE_TO_NORMALISE_COLLECTIF,
	FILE_TO_REPLAYGAIN,
	FILE_IS_IMG,
	FILE_IS_HTML,
	FILE_IS_TXT,
	FILE_IS_XCFA_GEN_CONF

} TYPE_FILE_IS;

typedef enum {

	FILE_NONE = 0,
	FILE_WAITING,
	FILE_CONV_OK

} ETAT_CONV_FILE;

typedef enum {

	FILE_ATTENTE = 0,
	FILE_SELECTED,
	FILE_SELECTED_LC
	
} ETAT_CONVFILE;

typedef enum {

	VERIF_FILE_NONE = 0,
	VERIF_FILE_BAD,
	VERIF_FILE_OK

} VERIF_FILE;

typedef enum {

	ETAT_SCAN_NONE = 0,
	ETAT_SCAN_DEMANDE,
	ETAT_SCAN_OK

} ETAT_SCAN;

/*
	Intitulé	Correspond à	Valeurs		Fichiers
	PEAK/ALBUM					Choix
	PEAK						Choix
	(scan)RMS/ALBUM	Mix		-6 à -22	Tous ou aucun
	(scan)RMS	Fix		-6 à -24	Tous ou aucun

PEAK/ALBUM
    Amplification maximale du volume pour un groupe de fichiers en respectant les écarts de niveau entre chacun d'eux.
PEAK
    Amplification maximale du volume pour chaque de fichier
RMS/ALBUM
    Ajustement du volume moyen pour un groupe de fichiers en respectant les écarts de niveau moyen entre chacun d'eux
RMS
    Ajustement du volume moyen de chaque de fichier
    
    sed -i 's/ANCIENNE PHRASE/NOUVELLE PHRASE/g' *.c
    sed -i 's/ANCIENNE PHRASE/NOUVELLE PHRASE/g' *.h
*/
typedef enum {
	NORM_NONE = 0,
	NORM_READY_FOR_SELECT,						/*  Pret a la selection wav,mp3, ogg				*/
	NORM_PEAK_ALBUM,						/*  NORM_PEAK_ALBUM						*/
	NORM_PEAK,							/*  NORM_PEAK							*/
	NORM_RMS_MIX_ALBUM,						/*  (scan) NORM_RMS_MIX_ALBUM					*/
	NORM_RMS_FIX							/*  (scan) NORM_RMS_FIX						*/
	
} ETAT_NORMALISE;

typedef enum {

	RPG_NONE = 0,							/* Attente de selection						*/
	RPG_ATTENTE,							/* Attente de selection						*/
	RPG_PISTE,							/* Mode PISTE							*/
	RPG_ALBUM,							/* Mode ALBUM							*/
	RPG_EFFACER							/* Mode EFFACER							*/
	
} ETAT_REPLAYGAIN;

typedef enum {
	ETAT_PRG_NONE = 0,
	ETAT_PRG_ABSENT,
	ETAT_ATTENTE,
	ETAT_ATTENTE_EXIST,
	ETAT_SELECT,
	ETAT_SELECT_EXIST,
	ETAT_SELECT_EXPERT,
	ETAT_SELECT_EXPERT_EXIST
	
} ETAT_SELECTION;

typedef enum {
	FILE_ETAT_PLAY_NONE = 0,
	FILE_ETAT_PLAY_PRG_ABSENT,
	FILE_ETAT_PLAY_ATTENTE,
	FILE_ETAT_PLAY
	
} ETAT_PLAY_FILE;

typedef enum {
	FILE_TRASH_NONE = 0,
	FILE_TRASH_OK,
	FILE_TRASH_VERIF_OK
	
} ETAT_TRASH_FILE;

typedef struct {

	ETAT_PLAY_FILE		 EtatPlay;				/*								*/
	
	ETAT_TRASH_FILE		 EtatTrash;				/*								*/
	
	ETAT_SELECTION		 EtatSelection_Flac;			/*								*/
	ETAT_SELECTION		 EtatSelection_Wav;			/*								*/
	ETAT_SELECTION		 EtatSelection_Mp3;			/*								*/
	ETAT_SELECTION		 EtatSelection_Ogg;			/*								*/
	ETAT_SELECTION		 EtatSelection_M4a;			/*								*/
	ETAT_SELECTION		 EtatSelection_Aac;			/*								*/
	ETAT_SELECTION		 EtatSelection_Mpc;			/*								*/
	ETAT_SELECTION		 EtatSelection_Ape;			/*								*/
	ETAT_SELECTION		 EtatSelection_WavPack;			/*								*/

	gchar			*name_dest;				/* Nom du fichier de destination sans le path ni l'extension	*/

	gchar			*dest_flac;				/*								*/
	gchar			*dest_wav;				/*								*/
	gchar			*dest_mp3;				/*								*/
	gchar			*dest_ogg;				/*								*/
	gchar			*dest_m4a;				/*								*/
	gchar			*dest_aac;				/*								*/
	gchar			*dest_mpc;				/*								*/
	gchar			*dest_ape;				/*								*/
	gchar			*dest_wavpack;				/*								*/
	gchar			*dest_wavpack_md5;			/*								*/
	gchar			*tmp_flac;				/*								*/
	gchar			*tmp_wav;				/*								*/
	gchar			*tmp_sox;				/* wav to wav							*/
	gchar			*tmp_mp3;				/*								*/
	gchar			*tmp_ogg;				/*								*/
	gchar			*tmp_m4a;				/*								*/
	gchar			*tmp_aac;				/*								*/
	gchar			*tmp_shn;				/*								*/
	gchar			*tmp_wma;				/*								*/
	gchar			*tmp_mpc;				/*								*/
	gchar			*tmp_ape;				/*								*/
	gchar			*tmp_wavpack;				/*								*/
	gchar			*tmp_wavpack_md5;			/*								*/

	ETAT_CONV_FILE		 Etat_Flac;				/*								*/
	ETAT_CONV_FILE		 Etat_Wav;				/*								*/
	ETAT_CONV_FILE		 Etat_Mp3;				/*								*/
	ETAT_CONV_FILE		 Etat_Ogg;				/*								*/
	ETAT_CONV_FILE		 Etat_m4a;				/*								*/
	ETAT_CONV_FILE		 Etat_aac;				/*								*/
	ETAT_CONV_FILE		 Etat_Mpc;				/*								*/
	ETAT_CONV_FILE		 Etat_Ape;				/*								*/
	ETAT_CONV_FILE		 Etat_wavpack;				/*								*/

	ETAT_NORMALISE		 Etat_Normalise;			/*								*/
	ETAT_SCAN		 Etat_Scan;				/* ETAT_SCAN_NONE or ETAT_SCAN_DEMANDE or ETAT_SCAN_OK		*/
	gboolean		 BoolNewString;
	ETAT_REPLAYGAIN		 Etat_ReplayGain;			/*								*/
	
	gint			 LevelMix;				/*								*/
} FIC;

typedef enum {
	STRUCT_NO_REMOVE = 0,						/*								*/
	STRUCT_FIC_REMOVE,						/* Remove struct FIC						*/
	STRUCT_FIC_REMOVE_WAV,						/* Remove struct FIC_WAV					*/
	STRUCT_FIC_REMOVE_MP3OGG,					/* Remove struct FIC_MP3OGG					*/
	STRUCT_FIC_REMOVE_SPLIT						/* Remove struct FIC_SPLIT					*/
} TYPE_STRUCT;

typedef enum {
	_TREEVIEW_ALL_,							/* Tous les types de fichiers supportes	sauf split		*/
	_TREEVIEW_SPLIT_,						/* SPLIT: wav, mp3, ogg, flac, shorten, wavpack			*/
	_TREEVIEW_SPLIT_ALL_,						/* SPLIT + ALL							*/
} CHOICE_TREEVIEW;

/*
*---------------------------------------------------------------------------
* F I C _ S P L I T
*---------------------------------------------------------------------------
*/


typedef enum {
	SPLIT_MASTER = 0,						/* Pere								*/
	SPLIT_CUTTING							/* Enfant							*/
} SPLIT_TYPE;

/* LES FICHIERS
*/
typedef struct {
	SPLIT_TYPE		 SplitType;
	GList			*ListDecoupes;				/* GList de pointeurs DECOUPES_FIC_SPLIT			*/
	gchar			*Name;					/* Le nom du fichier						*/
	guint			 GUINT_TempsTotal;			/* La duree Total d' ecoute					*/
	gdouble			 AdrValueMarkA;				/* Marquage de debut						*/
	gdouble			 AdrValueMarkB;				/* Marquage de fin						*/
	
} FIC_SPLIT;

typedef struct {
	gchar			*namefile;				/* nom complet du fichier					*/
	gchar			*namefileCopie;				/* nom complet du fichier					*/
	
	gchar			*nametreeview;				/* nom dans le treeview						*/
	gint			 num_struct;				/* numero unique de la structure				*/

	TYPE_FILE_IS		 type_infosong_file_is;			/* type du fichier						*/
	void 			*info;					/* INFO_WAV ou INFO_MP3 ou INFO_OGG ou INFO_FLAC ou INFO_ACC	*/

	CHOICE_TREEVIEW		 choice_treeview;			/*								*/
	FIC			*fic;					/* wav, mp3, ogg, flac et aac					*/
	FIC_WAV			*fic_wav;				/* wav								*/
	FIC_MP3OGG		*fic_mp3ogg;				/* mp3, ogg							*/
	FIC_SPLIT		*fic_split;				/* pointeur sur: FIC_SPLIT					*/
	
	gboolean		 modif;					/* TRUE = update all treeview					*/
	gint			 count_item;				/* Superieur a ZERO si add item					*/
	TYPE_STRUCT		 remove;				/* Destruction							*/

	VALUE_MARK		 ValuePlay;				/* Play song							*/
	gboolean		 BoolCueFile;				/* TRUE = provenance fichier cue				*/
	
} DETAIL;

extern GList *entetefile;						/* pointeur sur DETAIL */

/*
*---------------------------------------------------------------------------
* FILE.C
*---------------------------------------------------------------------------
*/
typedef struct {
	GtkComboBox		*AdrComboboxNormalise;			/* Adresse							*/
	GtkSpinButton		*AdrSpinbuttonNormalise;		/* Adresse							*/
	
	GtkWidget		*Adr_Label_Number;			/* Adresse							*/
	GtkWidget		*Adr_scroll;				/* Adresse							*/
	GtkListStore		*Adr_List_Store;			/* Adresse							*/
	GtkTreeModel		*Adr_Tree_Model;			/* Adresse							*/
	
	GtkTreeSelection	*Adr_Line_Selected;			/* Adresse							*/
	GList			*AdrGlistFile;
	GList			*AdrGlistFileWav;
	GList			*AdrGlistFileMp3Ogg;

	
	GtkWidget		*Adr_TreeView;				/* Adresse							*/
	GtkWidget		*Adr_Entry_Dest;			/* Adresse							*/
	GtkWidget		*Adr_Button_Dest;			/* Adresse							*/
	
	GtkComboBox		*Adr_combobox_DestFile;			/* Adresse							*/
	
	GtkComboBox		*Adr_combobox_select_type;		/* Adresse							*/
	GtkComboBox		*Adr_combobox_normalise;		/* Adresse							*/
	
	GdkPixbuf		*Pixbuf_Coche;				/* coche.png */
	GdkPixbuf		*Pixbuf_Coche_exist;			/* coche_exist.png */
	GdkPixbuf		*Pixbuf_Selected;			/* selected.png */
	GdkPixbuf		*Pixbuf_Selected_exist;			/* selected_exist.png */
	GdkPixbuf		*Pixbuf_Selected_expert;		/* selected_expert.png */
	GdkPixbuf		*Pixbuf_Selected_expert_exist;		/* selected_expert_exist.png */
	GdkPixbuf		*Pixbuf_Normalize_Coche;		/* normalize2.png */
	GdkPixbuf		*Pixbuf_FilePlay;			/* play.png */
	GdkPixbuf		*Pixbuf_FileStop;			/* sol.png */
	GdkPixbuf		*Pixbuf_NotInstall;			/* not_install.png */
	
	GdkPixbuf		*Pixbuf_Trash;				/* trash.png */
	GdkPixbuf		*Pixbuf_NoTrash;			/* coche.png */
	
	gboolean		 BOOL_ENTER;				/* Because appel crash */
	gboolean		 BOOL_ENTER_SPIN;			/* Because appel crash */
	GtkWidget		*Adr_progressbar_wav;			/*  */
	gint			 cursor_on_num_file;			/*  */
	gboolean		 bool_dedans;				/*  */

	GtkWidget		*Adr_Expander;				/*  */
	GtkWidget		*Adr_entry_tag_album;
	GtkWidget		*Adr_entry_tag_title;
	GtkWidget		*Adr_entry_tag_artist;
	GtkWidget		*Adr_entry_tag_comment;
	GtkWidget		*Adr_spinbutton_tag_year;
	GtkWidget		*Adr_spinbutton_tag_track;
	GtkComboBox		*Adr_combobox_tag_genre;
	GtkWidget		*Adr_label_tag_change;
	GtkWidget		*Adr_button_tag_appliquer;
	GtkWidget		*Adr_table_tag;
	
	/* Adresse du RENDERER */
	GtkCellRenderer		*Adr_ColumnFileAligmentRenderer;
	GtkCellRenderer		*Adr_ColumnFileWavAligmentRenderer;
	GtkCellRenderer		*Adr_ColumnFileMp3OggAligmentRenderer;
	/* Adresses des colonnes FILE */
	GtkTreeViewColumn	*Adr_ColumnFilePlay;
	GtkTreeViewColumn	*Adr_ColumnFileTrash;
	GtkTreeViewColumn	*Adr_ColumnFileType;
	GtkTreeViewColumn	*Adr_ColumnFileFlac;
	GtkTreeViewColumn	*Adr_ColumnFileWav;
	GtkTreeViewColumn	*Adr_ColumnFileMp3;
	GtkTreeViewColumn	*Adr_ColumnFileOgg;
	GtkTreeViewColumn	*Adr_ColumnFileM4a;
	GtkTreeViewColumn	*Adr_ColumnFileAac;
	GtkTreeViewColumn	*Adr_ColumnFileMpc;
	GtkTreeViewColumn	*Adr_ColumnFileApe;
	GtkTreeViewColumn	*Adr_ColumnFileWavPack;
	GtkTreeViewColumn	*Adr_ColumnFileTime;
	GtkTreeViewColumn	*Adr_ColumnFileNormalize;
	GtkTreeViewColumn	*Adr_ColumnFileReplayGain;
	GtkTreeViewColumn	*Adr_ColumnFileName;
	/* Adresses des colonnes FILEWAV */
	GtkTreeViewColumn	*Adr_ColumnFileWavHertz;
	GtkTreeViewColumn	*Adr_ColumnFileWavVoie;
	GtkTreeViewColumn	*Adr_ColumnFileWavBits;
	GtkTreeViewColumn	*Adr_ColumnFileWavNewHertz;
	GtkTreeViewColumn	*Adr_ColumnFileWavNewVoie;
	GtkTreeViewColumn	*Adr_ColumnFileWavNewBits;
	GtkTreeViewColumn	*Adr_ColumnFileWavName;
	/* Adresses des colonnes FILEMP3OGG */
	GtkTreeViewColumn	*Adr_ColumnFileMp3OggType;
	GtkTreeViewColumn	*Adr_ColumnFileMp3OggBitrate;
	GtkTreeViewColumn	*Adr_ColumnFileMp3OggNewBitrate;
	GtkTreeViewColumn	*Adr_ColumnFileMp3OggSize;
	GtkTreeViewColumn	*Adr_ColumnFileMp3OggTime;
	GtkTreeViewColumn	*Adr_ColumnFileMp3OggName;

	gint			 PageNum;

	GdkPixbuf		*Pixbuf_rpg_piste;			/*  rpg_piste.png		*/
	GdkPixbuf		*Pixbuf_rpg_album;			/*  rpg_album.png		*/
	GdkPixbuf		*Pixbuf_rpg_effacer;			/*  rpg_effacer.png		*/
	GdkPixbuf		*Pixbuf_rpg_wait;			/*  rpg_wait.png		*/
	
	GdkPixbuf		*Pixbuf_norm_fix;			/*  norm_fix.png		*/
	GdkPixbuf		*Pixbuf_norm_mix;			/*  norm_mix.png		*/
	GdkPixbuf		*Pixbuf_norm_peak;			/*  norm_peak.png		*/
	GdkPixbuf		*Pixbuf_norm_wait;			/*  norm_wait.png		*/
	
	GtkSpinButton		*Adr_spinbutton_frequence;
	
	/* TOOLTIPS EN LIGNE: Infos fichiers onglets ALL, WAV, MP3OGG */
	gchar			*AdrInfosAllFiles;
	gchar			*AdrInfosWav;
	gchar			*AdrInfosMp3Ogg;

	GtkComboBox		*Adr_Widget_Lame_abr_cbr_vbr;
	GtkComboBox		*Adr_Widget_Lame_bitrate;		
	GtkComboBox		*Adr_Widget_Lame_Mode;
	GtkComboBox		*Adr_Widget_Oggenc_bitrate;
	GtkComboBox		*Adr_Widget_Oggenc_managed;
	GtkComboBox		*Adr_Widget_Oggenc_downmix;
	
} VAR_FILE;

extern VAR_FILE var_file;

void       file_spinbutton_change_frequence_value (void);
void       file_spinbutton_frequence_value_changed (void);
void       file_combobox_dest_file_realize (GtkWidget *widget);
void       file_combobox_dest_file_changed (void);
void       file_set_combobox_dest_file (gint p_PageNum);
void       file_button_import_file_clicked (void);
void       file_notebook_in_file_switch_page (guint page_num);
void       file_button_efface_bitrate_clicked_file_MP3OGG (void);
void       file_button_apply_file_clicked (GtkButton *button);
void       file_update_glist_wav (void);
void       file_change_parameters_MP3OGG (void);
gchar     *file_get_time_file (DETAIL *detail);
guint      file_get_time_in_secondes (DETAIL *detail);
void       file_update_glist_file_MP3OGG (void);
void       file_set_etat_music_pixbuf_with_detail (DETAIL *p_detail, ETAT_PLAY_FILE EtatPlay);
typedef enum {
	_CEIL_ = 0,
	_COLUMN_,
	_DEFAULT_CEIL_,
	_DEFAULT_COLUMN_
} TYPE_CEIL_WAV;
void       file_convert_set_change_parameters_is_selected (TYPE_CEIL_WAV TypeCeilWav, gint freq, gint voie, gint bits);
typedef struct {
	glong	SizeTmpKo;
	gint	NbrFile;
	glong	SizeFileKo;
} SIZE_TMP;
gboolean   file_peak_get_size_is_ok (ETAT_NORMALISE p_EtatNormalise, SIZE_TMP *SizeTmp);

/* MODIF BITRATE FICHIERS MP3 ET OGG
*/
void       file_combobox_lame_type_bitrate_mp3ogg_realize (GtkWidget *widget);
void       file_combobox_lame_mode_mp3ogg_realize (GtkWidget *widget);
void       file_combobox_lame_abr_cbr_vbr_mp3ogg_realize (GtkWidget *widget);
void       file_combobox_lame_abr_cbr_vbr_mp3ogg_changed (void);
void       file_combobox_lame_type_bitrate_mp3ogg_changed (void);
void       file_combobox_lame_mode_mp3ogg_changed (void);

void       file_combobox_oggenc_bitrate_mp3ogg_realize (GtkWidget *widget);
void       file_combobox_oggenc_managed_mp3ogg_realize (GtkWidget *widget);
void       file_combobox_oggenc_downmix_m3ogg_realize (GtkWidget *widget);
void       file_combobox_oggenc_bitrate_mp3ogg_changed (void);
void       file_combobox_oggenc_managed_mp3ogg_changed (void);
void       file_combobox_oggenc_downmix_m3ogg_changed (void);

gchar       *file_get_val_bitrate_oggenc (void);
gchar       *file_get_val_managed_oggenc (void);
gchar       *file_get_val_downmix_oggenc (void);
gchar       *file_get_param_lame (void);
gchar       *file_get_param_lame_print (void);
gchar       *file_get_param_lame_affiche (gint abr_cbr_vbr, gint bitrate, gint mode);
gchar       *file_get_param_oggenc (void);
gchar       *file_get_param_oggenc_print (void);
gchar       *file_get_param_oggenc_affiche (gint bitrate, gint managed, gint downmix);



/* PLAYER ONGLET FICHIER
*/
void       file_hbox_all_file_realize (GtkWidget *widget);
void       file_hbox_wav_file_realize (GtkWidget *widget);
void       file_hbox_mp3ogg_file_realize (GtkWidget *widget);
void       file_set_value_time (gdouble value);

void       file_scrolledwindow_file_realize (GtkWidget *widget);
void       file_puts_label_statusbar_file (gchar *mess_label_status);
void       file_set_flag_buttons_audio_file (void);
void       file_affiche_all_pixbuf_file_play (void);
void       file_del_all_pixbuf_file_play (void);
void       file_clear_all_pixbuf_file_play (void);
void       file_time_update_glist_file (gchar *name, gchar *time);
gchar     *file_get_pixbuf_normalize (DETAIL *detail, gboolean p_bool_next);
void       file_button_conv_file_clicked (void);
void       file_button_del_file_clicked (void);
void       file_pixbuf_update_glist_file (void);
void       file_affiche_glist_file (void);
void       file_UpdateTime_glist (void);
gchar     *file_make_pathname_file (DETAIL *detail, TYPE_FILE_IS Type_File);
void       file_combobox_select_type_realize (GtkWidget *widget);
void       file_combobox_select_type_changed (void);
gboolean   file_get_bool_ReplaygainApply_file (void);
gboolean   file_get_bool_ReplaygainClear_file (void);
gboolean   file_get_bool_replaygain_file (void);
void       file_select_or_deselect_vertical_replaygain (ETAT_REPLAYGAIN EtatReplayGain);
gboolean   file_get_bool_normalize_file (void);
void       file_select_or_deselect_vertical_normalise (ETAT_NORMALISE EtatNormalise);

gboolean   file_get_bool_conversion_FILE (void);
void       file_set_tooltips (void);

gint       file_get_pointer_struct (void);

gint       file_get_COLUMN_FILE_NORMALIZE (void);
DETAIL    *file_get_line_selected (void);
void       file_affiche_type (void);
/*
void       file_set_new_value_dbfs (gint NewLevel, gboolean BoolAllChange);
void       file_set_new_value_dbfs_mix (gint NewLevelMix, gboolean BoolAllChange);
*/

void       file_all_deselect (void);
void       file_select_or_deselect_verticaly (TYPE_FILE_IS type_file_is, ETAT_SELECTION EtatSelection);
void       file_select_set_etat_next (TYPE_FILE_IS TypeFileIs);
void       file_select_or_deselect_horizontal (DETAIL *p_detail, ETAT_SELECTION EtatSelection);
void       file_select_or_deselect_vertical_trash (gboolean BoolSelect);

gint       file_verif_existing_file (void);
void       file_verif_existing_file_alert (gint NbrFileRemove);

GList     *file_get_glist_play (void);
gint       file_set_scan (void);
void       file_combobox_normalise_file_realize (GtkWidget *widget);
void       file_combobox_normalise_file_changed (void);
void       file_spinbutton_choix_niveau_file_value_changed (void);
/*
*---------------------------------------------------------------------------
* FILE_SCAN_DB.C
*---------------------------------------------------------------------------
*/
void       FileScanDB_action (gboolean BoolAllScan);

/*
*---------------------------------------------------------------------------
* FILE_ANALYZE.C
*---------------------------------------------------------------------------
*/
#include "info_song.h"

void     fileanalyze_modify_glist_entetefile (void);
void     fileanalyze_remove_entetefile (void);

void     fileanalyze_add_file_to_treeview_ (CHOICE_TREEVIEW choice_treeview, gboolean BoolCueFile);
/*--
gboolean fileanalyze_create_glist_analyze_file (GList *ListFile, gboolean BoolCueFile);
void     fileanalyze_add_file_to_treeview (CHOICE_TREEVIEW choice_treeview);
*/

gchar   *fileanalyze_get_name_without_path_ext (gchar *namefile, gboolean BoolVerif);
gchar   *fileanalyze_get_name_with_ext (gchar *namefile);
void     fileanalyze_update_info (void);
gboolean fileanalyze_linecommand_exist (void);
gboolean fileanalyze_exist (DETAIL *detail, TYPE_FILE_IS type);
gboolean fileanalyze_IS_END_OF_add_file_to_treeview (void);

/*
*---------------------------------------------------------------------------
* FILE_CONV.C
*---------------------------------------------------------------------------
*/
void fileconv_conversion_file_to_file_action (void);

/*
*---------------------------------------------------------------------------
* FILE_MP3OGG_CONV.C
*---------------------------------------------------------------------------
*/
void filemp3oggconv_apply_regul_mp3ogg_by_conv (void);

/*
*---------------------------------------------------------------------------
* FILE_WAV_CONV.C
*---------------------------------------------------------------------------
*/
void     filewavconv_apply (void);
gboolean filewavconv_delete_event (void);
gboolean filewavconv_destroy_event (void);
void     filewavconv_stop_wav_to_wav_clicked (void);

/*
*---------------------------------------------------------------------------
* FILE_ACTION.C
*---------------------------------------------------------------------------
*/
void     fileaction_choice (void);
void     fileaction_set_end (void);

/*
*---------------------------------------------------------------------------
* FILE_EXPANDER.C
*---------------------------------------------------------------------------
*/
void     filexpander_set_entry_tag_album (void);
void     filexpander_set_entry_tag_title (void);
void     filexpander_set_entry_tag_artist (void);
void     filexpander_set_entry_tag_comment (void);
void     filexpander_set_spinbutton_tag_year (void);
void     filexpander_set_spinbutton_tag_track (void);
void     filexpander_set_combobox_tag_genre (void);
TAGS    *filexpander_get_tag (DETAIL *detail);
void     filexpander_set_label_tag_change (void);

/*
*---------------------------------------------------------------------------
* FILE_LC.C
*---------------------------------------------------------------------------
*/

#include "cd_audio.h"
#include "conv.h"

/*
typedef struct {
	gint			type;
	gint			debit;
	gint			mode;

} TYPE_MP3OGG;
*/

typedef struct {
	TYPE_CONV	 type_conv;
	gboolean	 With_CommandLineUser;
	gchar		*filesrc;
	gchar		*filedest;
	TAGS		*tags;
	gchar		*cdrom;
	gchar		*num_track;
	gboolean	 BoolSetBitrate;
} PARAM_FILELC;

GList     *filelc_get_command_line (PARAM_FILELC *param_filelc);
GList     *filelc_get_command_line_extract (PARAM_FILELC *param_filelc);
GList     *filelc_remove_glist (GList *New);
GString   *filelc_get_options_for_visual (TYPE_CONV type_conv);
GList     *filelc_get_command_line_extract_elem (gint Elem, gchar *Dev, gchar *Dest);


/*
*---------------------------------------------------------------------------
* FILE_SHOWHIDE.C
*---------------------------------------------------------------------------
*/
/*
void       fileshowhide_create_win (void);
void       fileshowhide_showhide_from_menu (GtkMenuItem *menuitem);
void       fileshowhide_set_etat_options_menu (gchar *p_str_etat);
gchar     *fileshowhide_get_etat_options_menu (void);
*/

/*
*---------------------------------------------------------------------------
* FILE_TRASH.C
*---------------------------------------------------------------------------
*/
void       filetrash_action (void);
gboolean   filetrash_ok (void);
gboolean   filetrash_move_to_trash (gchar *Name);
gchar     *filetrash_get_trash (void);
void       filetrash_test_trash_is_ok (void);

#endif

