#include "xev.h"
#include "enemy.h"

PRIVATE Pixmap pixmap[4],pixmap_mask[4];
PRIVATE GC gc[4];
PRIVATE domogram_anim[16] = {0,1,1,1,2,2,2,3,3,2,2,1,1,1,1,0};
PRIVATE int mim_init_xy[8][2] = {
      {4,-1},{5,-1},{6,-1},{4,-2},{5,-3},
      {6,-2},{4,-3},{6,-3}
};
PRIVATE int mim_vxy[8][2] = {
      {-1,1},{0,1},{1,1},{-1,0},
      {0,-1},{1,0},{-1,-1},{1,-1}
};

PRIVATE int bonodo_init_xy[8][2] = {
      {8,-9},{5,-9},{3,-7},{3,-4},{5,-1},{8,-1},{10,-4},{10,-7}
};

PRIVATE int bonodo_vxy[8][2] = {
      {-14,0},{-10,10},{0,14},{10,10},
      {14,0},{10,-10},{0,-14},{-10,-10}
};
      
PRIVATE char *fn[] = {
      "domogram.img",
      "domogram1.img",
      "domogram2.img",
      "domogram3.img"
};

PRIVATE int shot_p[5][3] = {
      {1,1,1},
      {1,2,3},
      {2,3,4},
      {3,4,5},
      {9,10,15}
};

PRIVATE int domo_num[16] = {
      0, 7, 0, 5, 4, 8, 0, 18,
      0, 1, 5,13, 4, 0,14,14
};
PRIVATE char domo_vx[18][100];
PRIVATE char domo_vy[18][100];

void DomoStageInit(stage)
     int stage;
{
      FILE *fp;
      char fn[128] , dummy[200];
      int i,j;
      
      bzero(domo_vx , sizeof(domo_vx));
      bzero(domo_vy , sizeof(domo_vy));
 
      domo_no = 0;

      for(i = 0 ; i < domo_num[stage-1] ; i++) {
	    sprintf(fn , "%s/domoX%02d%02d.dat",DOMO_DIR,stage,i+1);

	    if( (fp = fopen(fn,"rb")) == NULL) {
		  fprintf(stderr,"DomoStageInit : open error %s\n",fn);
		  exit(1);
	    }

	    if(fread(&domo_vx[i] , sizeof(char)*100 , 1 , fp) != 1) {
		  fprintf(stderr,"DomoStageInit : read error %s\n",fn);
                  exit(1);
            }
	    
	    fclose(fp);

	    sprintf(fn , "%s/domoY%02d%02d.dat",DOMO_DIR,stage,i+1);

            if( (fp = fopen(fn,"rb")) == NULL) {
                  fprintf(stderr,"DomoStageInit : open error %s\n",fn);
                  exit(1);
            }

            if(fread(&domo_vy[i] , sizeof(char)*100 , 1 , fp) != 1) {
                  fprintf(stderr,"DomoStageInit : read error %s\n",fn);
                  exit(1);
            }
	    
            fclose(fp);
	    
      }
}

void DomoInit(enemy_no , x , char_no)
     int enemy_no,x,char_no;
{

      enemy_chijou[enemy_no].x.dummy = x*CSIZE*32768;
      enemy_chijou[enemy_no].y.dummy = -32*65536;
      enemy_chijou[enemy_no].enemy_no  = char_no;
      enemy_chijou[enemy_no].tmp3 = domo_no;/*ưѥ No.*/
      enemy_chijou[enemy_no].tmp2 = 0; /*ưƥå*/
      enemy_chijou[enemy_no].tmp1 = 0;
      
      enemy_chijou[enemy_no].vx = 0;
      enemy_chijou[enemy_no].vy = STPF;
      
      /*if(map[scrl_ptr][x/2] == UMINO || map[scrl_ptr][x/2] == BARA)
        enemy_chijou[enemy_no].tmp3 = 0;
      else
        enemy_chijou[enemy_no].tmp3 = 1;*/
      
      domo_no++;
     
}

int Domogram(enemy_no)
     int enemy_no;
{
      int sx,sy;
      int pat , step;
      
      sx = enemy_chijou[enemy_no].x.sht[UNION];
      sy = enemy_chijou[enemy_no].y.sht[UNION];
      pat = enemy_chijou[enemy_no].tmp3;
      step = enemy_chijou[enemy_no].tmp2;
      
      enemy_chijou[enemy_no].y.sht[UNION] += (short)domo_vy[pat][step/8];
      enemy_chijou[enemy_no].x.sht[UNION] += (short)domo_vx[pat][step/8];
      enemy_chijou[enemy_no].tmp2++;

      if (!enemy_chijou[enemy_no].tmp1 && (rand() & 255) 
          < shot_p[game_level][level]) {
            enemy_chijou[enemy_no].tmp1 = 16;
      }
      if(enemy_chijou[enemy_no].tmp1 == 7)
        EShut(enemy_no,enemy_chijou[enemy_no].x.dummy+16*65536
              ,enemy_chijou[enemy_no].y.dummy+16*65536);

      enemy_chijou[enemy_no].tmp1 -=
        (enemy_chijou[enemy_no].tmp1 > 0);
      
      SetSprite(sx,sy,pixmap[domogram_anim[enemy_chijou[enemy_no].tmp1]],
		gc[domogram_anim[enemy_chijou[enemy_no].tmp1]],
                CSIZE,CSIZE);
      

      if(sx < 0 || sx > XSIZE || sy < -32 || sy > YSIZE) {
            enemy_chijou[enemy_no].enemy_no = 0;
      }
      if((jx.sht[UNION] - sx) > -20 &&
         (jx.sht[UNION] - sx) < 20 &&
         (jy.sht[UNION] - sy) > 192 &&
         (jy.sht[UNION] - sy) < 224)
        shojun_flag = 1;
      
      if((shot_chi.x.sht[UNION] - sx) > -10 &&
         (shot_chi.x.sht[UNION] - sx) < 32 &&
         (shot_chi.y.sht[UNION] - sy) > -10 &&
         (shot_chi.y.sht[UNION] - sy) < 42 &&
         shot_chi.z == 1) {
	    int j;
	    
            for(j = 0 ; j < 8 ; j++) {
                  if(!enemy_chijou[j].enemy_no) {
                        enemy_chijou[j].tmp3 = 1;
                        enemy_chijou[j].x = enemy_chijou[enemy_no].x;
                        enemy_chijou[j].y = enemy_chijou[enemy_no].y;
                        enemy_chijou[enemy_no].enemy_no = 0;
                        BombCInit(j);
                        score += 800;
                        return 1;
                  }
            }
	    
      }else
        return 0;
}

void DomogramSetChar()
{
      int c_no;
      char img[CSIZE*CSIZE] , mask[128];
      XGCValues gcv;
      
      for(c_no = 0 ; c_no < 4 ; c_no++) {
            int x,y;
	    
            sprintf(tpath , "%s/%s",IMAGE_DIR,fn[c_no]);
            LoadChar(tpath,img , sizeof(img));
            pixmap[c_no] = XCreatePixmap(d,w,CSIZE,CSIZE,depth);
	    gcv.graphics_exposures = True;
	    gc[c_no] = XCreateGC(d,w,GCGraphicsExposures,&gcv);
            bzero(mask , sizeof(mask));
            
	    DrawChar32(img , mask , gc[c_no],pixmap[c_no]);
	    pixmap_mask[c_no] 
	      = XCreateBitmapFromData(d,w,mask,CSIZE,CSIZE);
            XSetClipMask(d,gc[c_no],pixmap_mask[c_no]);
      }
      
}


void DomogramFree()
{
      int i;
      
      for(i = 0 ; i > 4 ; i++) {
            XFreePixmap(d,pixmap[i]);
            XFreePixmap(d,pixmap_mask[i]);
	    XFreeGC(d,gc[i]);
      }
}

void MimInit(dummy,dummy1,dummy2)
     int dummy,dummy1,dummy2;
{
      int i,j;
      
      for(i = 0 ; i < 8 ; i++) {
	    for(j = 8 ; j < ENEMY_MAX ; j++) {
		  if(!enemy_chijou[j].enemy_no) {
			enemy_chijou[j].enemy_no = MIM;
			enemy_chijou[j].x.sht[UNION] = mim_init_xy[i][0]*CSIZE;
			enemy_chijou[j].y.sht[UNION] = mim_init_xy[i][1]*CSIZE;
			enemy_chijou[j].tmp1 = 0;
			enemy_chijou[j].tmp2 = 0;
			enemy_chijou[j].tmp3 = 1;
			enemy_chijou[j].vx = mim_vxy[i][0]*50000;
			enemy_chijou[j].vy = mim_vxy[i][1]*50000;
			break;
		  }
	    }
      }
}

int Mim(enemy_no)
     int enemy_no;
{
      int sx,sy;
      sx = enemy_chijou[enemy_no].x.sht[UNION];
      sy = enemy_chijou[enemy_no].y.sht[UNION];

      enemy_chijou[enemy_no].y.dummy += (enemy_chijou[enemy_no].vy+2*65536);
      enemy_chijou[enemy_no].x.dummy += enemy_chijou[enemy_no].vx;
      
      enemy_chijou[enemy_no].tmp1 ++;
      enemy_chijou[enemy_no].tmp1 &= 63;

      if(!enemy_chijou[enemy_no].tmp1) {
	    enemy_chijou[enemy_no].vx
	      = -enemy_chijou[enemy_no].vx;
	    enemy_chijou[enemy_no].vy
	      = -enemy_chijou[enemy_no].vy;
      }

      if (!enemy_chijou[enemy_no].tmp3 && (rand() & 255) 
	  < shot_p[game_level][level]) {
            enemy_chijou[enemy_no].tmp3 = 16;
      }
      
      if(enemy_chijou[enemy_no].tmp3 == 7)
        EShut(enemy_no,enemy_chijou[enemy_no].x.dummy+16*65536
              ,enemy_chijou[enemy_no].y.dummy+16*65536);

      enemy_chijou[enemy_no].tmp3 -=
        (enemy_chijou[enemy_no].tmp3 > 0);

      SetSprite(sx,sy,pixmap[domogram_anim[enemy_chijou[enemy_no].tmp3]],
		gc[domogram_anim[enemy_chijou[enemy_no].tmp3]],
		CSIZE,CSIZE);

      if(sy > YSIZE) {
            enemy_chijou[enemy_no].enemy_no = 0;
      }
      if((jx.sht[UNION] - sx) > -20 &&
         (jx.sht[UNION] - sx) < 20 &&
         (jy.sht[UNION] - sy) > 192 &&
         (jy.sht[UNION] - sy) < 224)
        shojun_flag = 1;
      
      if((shot_chi.x.sht[UNION] - sx) > -10 &&
         (shot_chi.x.sht[UNION] - sx) < 32 &&
         (shot_chi.y.sht[UNION] - sy) > -10 &&
         (shot_chi.y.sht[UNION] - sy) < 42 &&
         shot_chi.z == 1) {
	    enemy_chijou[enemy_no].tmp3 = 1;
            BombCInit(enemy_no);
	    score += 800;
            return 1;
      }else
        return 0;
}

void BonodoInit(dummy,dummy1,dummy2)
     int dummy,dummy1,dummy2;
{
      int i,j;
      
      for(i = 0 ; i < 8 ; i++) {
	    for(j = 8 ; j < ENEMY_MAX ; j++) {
		  if(!enemy_chijou[j].enemy_no) {
			enemy_chijou[j].enemy_no = BONODORI;
			enemy_chijou[j].x.sht[UNION] = bonodo_init_xy[i][0]*CSIZE;
			enemy_chijou[j].y.sht[UNION] = bonodo_init_xy[i][1]*CSIZE;
			enemy_chijou[j].tmp1 = 0;
			enemy_chijou[j].tmp2 = i;
			enemy_chijou[j].tmp3 = 1;
			enemy_chijou[j].vx = bonodo_vxy[i][0]*3300;
			enemy_chijou[j].vy = bonodo_vxy[i][1]*3300;
			break;
		  }
	    }
      }
}

int Bonodo(enemy_no)
     int enemy_no;
{
      int sx,sy;
      sx = enemy_chijou[enemy_no].x.sht[UNION];
      sy = enemy_chijou[enemy_no].y.sht[UNION];

      enemy_chijou[enemy_no].y.dummy += (enemy_chijou[enemy_no].vy+2*65536);
      enemy_chijou[enemy_no].x.dummy += enemy_chijou[enemy_no].vx;
      
      enemy_chijou[enemy_no].tmp1 ++;

      if(enemy_chijou[enemy_no].tmp1==155) {
	    enemy_chijou[enemy_no].tmp1 = 0;
	    enemy_chijou[enemy_no].tmp2++;
	    enemy_chijou[enemy_no].tmp2 &= 7;
	    enemy_chijou[enemy_no].vx
	      = bonodo_vxy[enemy_chijou[enemy_no].tmp2][0]*3300;
	    enemy_chijou[enemy_no].vy
	      = bonodo_vxy[enemy_chijou[enemy_no].tmp2][1]*3300;
      }

      if (!enemy_chijou[enemy_no].tmp3 && (rand() & 255) 
	  < shot_p[game_level][level]) {
            enemy_chijou[enemy_no].tmp3 = 16;
      }
      
      if(enemy_chijou[enemy_no].tmp3 == 7)
        EShut(enemy_no,enemy_chijou[enemy_no].x.dummy+16*65536
              ,enemy_chijou[enemy_no].y.dummy+16*65536);

      enemy_chijou[enemy_no].tmp3 -=
        (enemy_chijou[enemy_no].tmp3 > 0);

      SetSprite(sx,sy,pixmap[domogram_anim[enemy_chijou[enemy_no].tmp3]],
		gc[domogram_anim[enemy_chijou[enemy_no].tmp3]],
		CSIZE,CSIZE);

      if(sy > YSIZE) {
            enemy_chijou[enemy_no].enemy_no = 0;
      }
      if((jx.sht[UNION] - sx) > -20 &&
         (jx.sht[UNION] - sx) < 20 &&
         (jy.sht[UNION] - sy) > 192 &&
         (jy.sht[UNION] - sy) < 224)
        shojun_flag = 1;
      
      if((shot_chi.x.sht[UNION] - sx) > -10 &&
         (shot_chi.x.sht[UNION] - sx) < 32 &&
         (shot_chi.y.sht[UNION] - sy) > -10 &&
         (shot_chi.y.sht[UNION] - sy) < 42 &&
         shot_chi.z == 1) {
	    int j;

	    for(j = 0 ; j < 8 ; j++) {
		  if(!enemy_chijou[j].enemy_no) {
			enemy_chijou[j].tmp3 = 1;
			enemy_chijou[j].x = enemy_chijou[enemy_no].x;
			enemy_chijou[j].y = enemy_chijou[enemy_no].y;
			enemy_chijou[enemy_no].enemy_no = 0;
			BombCInit(j);
			score += 800;
			return 1;
		  }
	    }
      }else
        return 0;
}




