/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tree;

import com.icl.saxon.Context;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.om.DocumentInfo;
import com.icl.saxon.om.ElementInfo;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.pattern.NamedNodePattern;
import com.icl.saxon.pattern.NodeTestPattern;
import com.icl.saxon.pattern.Pattern;
import com.icl.saxon.tree.DOMExceptionImpl;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.ParentNodeImpl;
import java.util.Vector;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

abstract class NodeImpl
implements NodeInfo {
    protected static NodeInfo[] emptyArray = new NodeInfo[0];
    protected ParentNodeImpl parent;
    protected int index;

    NodeImpl() {
    }

    public boolean isSameNode(NodeInfo nodeInfo) {
        return this == nodeInfo;
    }

    public String getSystemId() {
        return this.parent.getSystemId();
    }

    public long getSequenceNumber() {
        NodeInfo nodeInfo = this;
        int n = 0;
        while (!(nodeInfo instanceof ParentNodeImpl)) {
            nodeInfo = nodeInfo.getPreviousInDocument();
            ++n;
        }
        return nodeInfo.getSequenceNumber() + 65536L + (long)n;
    }

    public String getNodeName() {
        return this.getDisplayName();
    }

    public String getPrefix() {
        return null;
    }

    public String getURI() {
        Name name = this.getExpandedName();
        if (name == null) {
            return "";
        }
        return name.getURI();
    }

    public String getDisplayName() {
        Name name = this.getExpandedName();
        if (name == null) {
            return "";
        }
        return name.getDisplayName();
    }

    public String getAbsoluteName() {
        Name name = this.getExpandedName();
        if (name == null) {
            return "";
        }
        return name.getAbsoluteName();
    }

    public String getLocalName() {
        Name name = this.getExpandedName();
        if (name == null) {
            return "";
        }
        return name.getLocalName();
    }

    public boolean hasName(Name name) {
        Name name2 = this.getExpandedName();
        if (name2 == null) {
            return false;
        }
        return name2.equals(name);
    }

    public int getLineNumber() {
        return this.parent.getLineNumber();
    }

    public int getColumnNumber() {
        return -1;
    }

    public String getPublicId() {
        return null;
    }

    public final int getIndex() {
        return this.index;
    }

    public final Node getParentNode() {
        return this.parent;
    }

    public Node getPreviousSibling() {
        return this.parent.getNthChild(this.index - 1);
    }

    public Node getNextSibling() {
        return this.parent.getNthChild(this.index + 1);
    }

    public Node getFirstChild() {
        return null;
    }

    public Node getLastChild() {
        return null;
    }

    public int getNumberOfChildren() {
        return 0;
    }

    public NodeInfo[] getAllChildNodes() {
        return emptyArray;
    }

    public final boolean isa(int n) {
        return n == 0 || n == this.getNodeType();
    }

    public String getAttributeValue(Name name) {
        return null;
    }

    public String getAttributeValue(String string) {
        return null;
    }

    public final ElementInfo getAncestor(Name name) {
        NodeImpl nodeImpl = (NodeImpl)this.getParentNode();
        while (nodeImpl != null && nodeImpl instanceof ElementInfo && !nodeImpl.hasName(name)) {
            nodeImpl = (NodeImpl)nodeImpl.getParentNode();
        }
        if (nodeImpl instanceof DocumentInfo) {
            return null;
        }
        return (ElementInfo)((Object)nodeImpl);
    }

    public final NodeInfo getAncestor(Pattern pattern, Context context) throws SAXException {
        NodeInfo nodeInfo = (NodeInfo)this.getParentNode();
        while (nodeInfo != null) {
            if (pattern.matches(nodeInfo, context)) {
                return nodeInfo;
            }
            nodeInfo = (NodeInfo)nodeInfo.getParentNode();
        }
        return null;
    }

    public boolean isDocumentElement() {
        return this instanceof ElementInfo && this.getParentNode() instanceof DocumentInfo;
    }

    public boolean isAncestor(NodeInfo nodeInfo) {
        NodeInfo nodeInfo2 = (NodeInfo)nodeInfo.getParentNode();
        if (nodeInfo2 == null) {
            return false;
        }
        if (nodeInfo2 == this) {
            return true;
        }
        return this.isAncestor(nodeInfo2);
    }

    public Element getDocumentElement() {
        return ((DocumentImpl)this.getDocumentRoot()).getDocumentElement();
    }

    public DocumentInfo getDocumentRoot() {
        NodeImpl nodeImpl = this;
        while (!((nodeImpl = (NodeImpl)nodeImpl.getParentNode()) instanceof DocumentInfo)) {
        }
        return (DocumentInfo)((Object)nodeImpl);
    }

    public final NodeInfo getNextSibling(Pattern pattern, Context context) throws SAXException {
        NodeInfo nodeInfo = (NodeInfo)this.getNextSibling();
        while (nodeInfo != null) {
            if (pattern.matches(nodeInfo, context)) {
                return nodeInfo;
            }
            nodeInfo = (NodeInfo)nodeInfo.getNextSibling();
        }
        return null;
    }

    public NodeInfo getNextInDocument(NodeInfo nodeInfo) {
        NodeInfo nodeInfo2 = (NodeInfo)this.getFirstChild();
        if (nodeInfo2 != null) {
            return nodeInfo2;
        }
        if (this == nodeInfo) {
            return null;
        }
        nodeInfo2 = (NodeInfo)this.getNextSibling();
        if (nodeInfo2 != null) {
            return nodeInfo2;
        }
        NodeInfo nodeInfo3 = this;
        do {
            if ((nodeInfo3 = (NodeInfo)nodeInfo3.getParentNode()) == null) {
                return null;
            }
            if (nodeInfo3 != nodeInfo) continue;
            return null;
        } while ((nodeInfo2 = (NodeInfo)nodeInfo3.getNextSibling()) == null);
        return nodeInfo2;
    }

    public final NodeInfo getFirstChild(Pattern pattern, Context context) throws SAXException {
        NodeInfo nodeInfo = (NodeInfo)this.getFirstChild();
        while (nodeInfo != null) {
            if (pattern.matches(nodeInfo, context)) {
                return nodeInfo;
            }
            nodeInfo = (NodeInfo)nodeInfo.getNextSibling();
        }
        return null;
    }

    public final NodeInfo getPreviousSibling(Pattern pattern, Context context) throws SAXException {
        NodeInfo nodeInfo = (NodeInfo)this.getPreviousSibling();
        while (nodeInfo != null) {
            if (pattern.matches(nodeInfo, context)) {
                return nodeInfo;
            }
            nodeInfo = (NodeInfo)nodeInfo.getPreviousSibling();
        }
        return null;
    }

    public NodeInfo getPreviousInDocument() {
        NodeInfo nodeInfo = (NodeInfo)this.getPreviousSibling();
        if (nodeInfo != null) {
            return ((NodeImpl)nodeInfo).getLastDescendantOrSelf();
        }
        return (NodeInfo)this.getParentNode();
    }

    private NodeInfo getLastDescendantOrSelf() {
        NodeImpl nodeImpl = (NodeImpl)this.getLastChild();
        if (nodeImpl == null) {
            return this;
        }
        return nodeImpl.getLastDescendantOrSelf();
    }

    public final NodeInfo getPreviousInDocument(Pattern pattern, Context context) throws SAXException {
        NodeInfo nodeInfo = this;
        do {
            if ((nodeInfo = nodeInfo.getPreviousInDocument()) != null) continue;
            return null;
        } while (!pattern.matches(nodeInfo, context));
        return nodeInfo;
    }

    public final NodeInfo getLastChild(Pattern pattern, Context context) throws SAXException {
        NodeInfo nodeInfo = (NodeInfo)this.getLastChild();
        while (nodeInfo != null) {
            if (pattern.matches(nodeInfo, context)) {
                return nodeInfo;
            }
            nodeInfo = (NodeInfo)nodeInfo.getPreviousSibling();
        }
        return null;
    }

    public void copyStringValue(Outputter outputter) throws SAXException {
        outputter.writeContent(this.getValue());
    }

    /*
     * Unable to fully structure code
     */
    public int getNumberSimple(Context var1_1) {
        var2_2 = 1;
        var3_3 = this.getNodeType();
        var4_4 = this.getExpandedName();
        var5_5 = (NodeInfo)this.getPreviousSibling();
        if (var5_5 == null || var5_5.getNodeType() != var3_3 || !var5_5.hasName(var4_4) || (var6_6 = var1_1.getRememberedNumber(var5_5)) <= 0) ** GOTO lbl11
        var1_1.setRememberedNumber(this, ++var6_6);
        return var6_6;
lbl-1000:
        // 1 sources

        {
            if (var5_5.getNodeType() == var3_3 && (var4_4 == null || var5_5.hasName(var4_4))) {
                ++var2_2;
            }
            var5_5 = (NodeInfo)var5_5.getPreviousSibling();
lbl11:
            // 2 sources

            ** while (var5_5 != null)
        }
lbl12:
        // 1 sources

        var1_1.setRememberedNumber(this, var2_2);
        return var2_2;
    }

    public int getNumberSimple() {
        int n = 1;
        short s = this.getNodeType();
        Name name = this.getExpandedName();
        NodeInfo nodeInfo = (NodeInfo)this.getPreviousSibling();
        while (nodeInfo != null) {
            if (nodeInfo.getNodeType() == s && (name == null || nodeInfo.hasName(name))) {
                ++n;
            }
            nodeInfo = (NodeInfo)nodeInfo.getPreviousSibling();
        }
        return n;
    }

    public int getNumberSingle(Pattern pattern, Pattern pattern2, Context context) throws SAXException {
        if (pattern == null && pattern2 == null) {
            return this.getNumberSimple(context);
        }
        if (pattern == null) {
            pattern = this.getExpandedName() == null ? new NodeTestPattern(this.getNodeType()) : new NamedNodePattern(this.getNodeType(), this.getExpandedName());
        }
        NodeInfo nodeInfo = pattern2 == null ? this.getDocumentRoot() : this.getAncestor(pattern2, context);
        NodeInfo nodeInfo2 = this;
        while (!pattern.matches(nodeInfo2, context)) {
            if ((nodeInfo2 = (NodeInfo)nodeInfo2.getParentNode()) != null && nodeInfo2 != nodeInfo) continue;
            return 0;
        }
        int n = 0;
        NodeInfo nodeInfo3 = nodeInfo2;
        while (nodeInfo3 != null) {
            ++n;
            nodeInfo3 = nodeInfo3.getPreviousSibling(pattern, context);
        }
        return n;
    }

    public int getNumberAny(Pattern pattern, Pattern pattern2, Context context) throws SAXException {
        if (pattern == null) {
            pattern = this.getExpandedName() == null ? new NodeTestPattern(this.getNodeType()) : new NamedNodePattern(this.getNodeType(), this.getExpandedName());
        }
        int n = 0;
        for (NodeInfo nodeInfo = this; !(nodeInfo == null || pattern2 != null && pattern2.matches(nodeInfo, context)); nodeInfo = nodeInfo.getPreviousInDocument()) {
            if (!pattern.matches(nodeInfo, context)) continue;
            ++n;
        }
        return n;
    }

    public Vector getNumberMulti(Pattern pattern, Pattern pattern2, Context context) throws SAXException {
        Vector<Integer> vector = new Vector<Integer>();
        if (pattern == null) {
            pattern = this.getExpandedName() == null ? new NodeTestPattern(this.getNodeType()) : new NamedNodePattern(this.getNodeType(), this.getExpandedName());
        }
        NodeInfo nodeInfo = this;
        do {
            if (!pattern.matches(nodeInfo, context)) continue;
            int n = nodeInfo.getNumberSingle(pattern, null, context);
            vector.insertElementAt(new Integer(n), 0);
        } while ((nodeInfo = (NodeInfo)nodeInfo.getParentNode()) != null && (pattern2 == null || !pattern2.matches(nodeInfo, context)));
        return vector;
    }

    public String getSequentialKey() {
        NodeInfo nodeInfo = this;
        StringBuffer stringBuffer = new StringBuffer();
        while (!(nodeInfo instanceof DocumentInfo)) {
            stringBuffer.insert(0, NodeImpl.alphaKey(nodeInfo.getIndex()));
            nodeInfo = (NodeInfo)nodeInfo.getParentNode();
        }
        stringBuffer.insert(0, nodeInfo.getSequentialKey());
        return stringBuffer.toString();
    }

    protected static String alphaKey(int n) {
        if (n < 1) {
            return "a";
        }
        if (n < 10) {
            return "b" + n;
        }
        if (n < 100) {
            return "c" + n;
        }
        if (n < 1000) {
            return "d" + n;
        }
        if (n < 10000) {
            return "e" + n;
        }
        if (n < 100000) {
            return "f" + n;
        }
        if (n < 1000000) {
            return "g" + n;
        }
        if (n < 10000000) {
            return "h" + n;
        }
        if (n < 100000000) {
            return "i" + n;
        }
        if (n < 1000000000) {
            return "j" + n;
        }
        return "k" + n;
    }

    public String toString() {
        String string = this.getDisplayName();
        if (string == "") {
            NodeInfo nodeInfo = (NodeInfo)this.getParentNode();
            if (nodeInfo != null) {
                string = nodeInfo.getExpandedName() + "/";
            }
            string = string + "\"" + this.getValue().trim() + "\"";
        }
        string = string + "(" + this.getIndex() + ")";
        return string;
    }

    public void removeNode() throws SAXException {
        this.parent.removeChild(this.index);
    }

    public static String getNodeTypeName(int n) {
        switch (n) {
            case 0: {
                return "NODE";
            }
            case 1: {
                return "ELEMENT";
            }
            case 3: {
                return "TEXT";
            }
            case 2: {
                return "ATTRIBUTE";
            }
            case 4: {
                return "DOCUMENT";
            }
            case 7: {
                return "PI";
            }
            case 8: {
                return "COMMENT";
            }
        }
        return "NODE";
    }

    public String getNodeValue() {
        return this.getValue();
    }

    public void setNodeValue(String string) throws DOMException {
        this.disallowUpdate();
    }

    public NodeList getChildNodes() {
        return new NodeSetExtent(this.getAllChildNodes());
    }

    public NamedNodeMap getAttributes() {
        return null;
    }

    public Document getOwnerDocument() {
        return (DocumentImpl)this.getDocumentRoot();
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Node removeChild(Node node) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public Node appendChild(Node node) throws DOMException {
        this.disallowUpdate();
        return null;
    }

    public boolean hasChildNodes() {
        return this.getFirstChild() != null;
    }

    public Node cloneNode(boolean bl) {
        return null;
    }

    public void normalize() {
    }

    public boolean supports(String string, String string2) {
        return false;
    }

    public String getNamespaceURI() {
        String string = this.getURI();
        return string == "" ? null : string;
    }

    public void setPrefix(String string) throws DOMException {
        this.disallowUpdate();
    }

    protected void disallowUpdate() throws DOMException {
        throw new DOMExceptionImpl(7, "The Saxon DOM cannot be updated");
    }

    public boolean hasAttributes() {
        return false;
    }

    public boolean isSupported(String string, String string2) {
        return string.equalsIgnoreCase("xml");
    }

    public abstract String getPath();

    public abstract void copy(Outputter var1) throws SAXException;

    public abstract void defaultAction(Context var1) throws SAXException;

    public abstract Name getExpandedName();

    public abstract String getValue();

    public abstract short getNodeType();
}

