/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.functions;

import com.icl.saxon.Context;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.Function;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.expr.Value;
import com.icl.saxon.functions.Round;
import java.util.Vector;
import org.xml.sax.SAXException;

public class Substring
extends Function {
    public String getName() {
        return "substring";
    }

    public int getDataType() {
        return 3;
    }

    public Value eval(Vector vector, Context context) throws SAXException {
        int n = this.checkArgumentCount(2, 3);
        Value value = (Value)vector.elementAt(0);
        String string = value.asString();
        double d = ((Value)vector.elementAt(1)).asNumber();
        if (n == 2) {
            return new StringValue(Substring.substring(string, d));
        }
        double d2 = ((Value)vector.elementAt(2)).asNumber();
        return new StringValue(Substring.substring(string, d, d2));
    }

    public Expression simplify() throws SAXException {
        return this.simplifyPureFunction();
    }

    public static String substring(String string, double d) {
        int n = string.length();
        int n2 = n - (int)d + 1;
        if (n2 < 0) {
            n2 = 1;
        }
        if (n2 > n) {
            n2 = n;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 1;
        int n4 = 0;
        double d2 = Round.round(d);
        while (n4 < n) {
            char c;
            if ((double)n3 >= d2) {
                stringBuffer.append(string.charAt(n4));
            }
            if ((c = string.charAt(n4++)) >= '\ud800' && c <= '\udbff') continue;
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static String substring(String string, double d, double d2) {
        int n = string.length();
        int n2 = (int)d2;
        if (n2 < 0) {
            n2 = 1;
        }
        if (n2 > n) {
            n2 = n;
        }
        StringBuffer stringBuffer = new StringBuffer(n2);
        int n3 = 1;
        int n4 = 0;
        double d3 = Round.round(d);
        double d4 = Round.round(d2);
        while (n4 < n) {
            char c;
            if ((double)n3 >= d3) {
                if (!((double)n3 < d3 + d4)) break;
                stringBuffer.append(string.charAt(n4));
            }
            if ((c = string.charAt(n4++)) >= '\ud800' && c <= '\udbff') continue;
            ++n3;
        }
        return stringBuffer.toString();
    }
}

