/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.expr;

import com.icl.saxon.expr.NodeEnumeration;
import com.icl.saxon.expr.NodeSetExtent;
import com.icl.saxon.om.NodeInfo;
import org.xml.sax.SAXException;

public class DifferenceEnumeration
implements NodeEnumeration {
    private NodeEnumeration p1;
    private NodeEnumeration p2;
    private NodeEnumeration e1;
    private NodeEnumeration e2;
    private NodeInfo nextNode1 = null;
    private NodeInfo nextNode2 = null;
    private long nextKey1 = -1L;
    private long nextKey2 = -1L;
    NodeInfo nextNode = null;

    public DifferenceEnumeration(NodeEnumeration nodeEnumeration, NodeEnumeration nodeEnumeration2) throws SAXException {
        this.p1 = nodeEnumeration;
        this.p2 = nodeEnumeration2;
        this.e1 = nodeEnumeration;
        this.e2 = nodeEnumeration2;
        if (!this.e1.isSorted()) {
            this.e1 = new NodeSetExtent(this.e1).sort().enumerate();
        }
        if (!this.e2.isSorted()) {
            this.e2 = new NodeSetExtent(this.e2).sort().enumerate();
        }
        if (this.e1.hasMoreElements()) {
            this.nextNode1 = this.e1.nextElement();
            this.nextKey1 = this.nextNode1.getSequenceNumber();
        }
        if (this.e2.hasMoreElements()) {
            this.nextNode2 = this.e2.nextElement();
            this.nextKey2 = this.nextNode2.getSequenceNumber();
        }
        this.advance();
    }

    public boolean hasMoreElements() throws SAXException {
        return this.nextNode != null;
    }

    public NodeInfo nextElement() throws SAXException {
        NodeInfo nodeInfo = this.nextNode;
        this.advance();
        return nodeInfo;
    }

    private void advance() throws SAXException {
        while (this.nextNode1 != null && this.nextNode2 != null) {
            NodeInfo nodeInfo;
            long l = this.nextKey1 - this.nextKey2;
            if (l < 0L) {
                nodeInfo = this.nextNode1;
                if (this.e1.hasMoreElements()) {
                    this.nextNode1 = this.e1.nextElement();
                    this.nextKey1 = this.nextNode1.getSequenceNumber();
                } else {
                    this.nextNode1 = null;
                    this.nextNode = null;
                }
                this.nextNode = nodeInfo;
                return;
            }
            if (l > 0L) {
                nodeInfo = this.nextNode2;
                if (this.e2.hasMoreElements()) {
                    this.nextNode2 = this.e2.nextElement();
                    this.nextKey2 = this.nextNode2.getSequenceNumber();
                    continue;
                }
                this.nextNode2 = null;
                this.nextNode = null;
                continue;
            }
            nodeInfo = this.nextNode2;
            if (this.e2.hasMoreElements()) {
                this.nextNode2 = this.e2.nextElement();
                this.nextKey2 = this.nextNode2.getSequenceNumber();
            } else {
                this.nextNode2 = null;
            }
            if (this.e1.hasMoreElements()) {
                this.nextNode1 = this.e1.nextElement();
                this.nextKey1 = this.nextNode1.getSequenceNumber();
                continue;
            }
            this.nextNode1 = null;
        }
        if (this.nextNode1 != null) {
            this.nextNode = this.nextNode1;
            this.nextNode1 = this.e1.hasMoreElements() ? this.e1.nextElement() : null;
            return;
        }
        this.nextNode = null;
    }

    public boolean isSorted() {
        return true;
    }

    public boolean isReverseSorted() {
        return false;
    }

    public boolean isPeer() {
        return false;
    }
}

