/*
   XCIN ANY WHERE version 0.3b+CV pre 0p3
   by weijr
 */
#include <unistd.h>
#include <sys/types.h>
#include <sys/uio.h>
#include <sys/stat.h>
#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <fcntl.h>
#include <ctype.h>
#include <stdlib.h>
#include <dlfcn.h>
#include <X11/Intrinsic.h>
#include <X11/keysym.h>
#include <X11/Xlocale.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <stdarg.h>
#include "config.h"

#define min(a,b) (((a) < (b)) ? (a) : (b))
#define max(a,b) (((a) > (b)) ? (a) : (b))

/* Wrapped functions */
static Display * (* real_XOpenDisplay)(_Xconst char *);
static int (* real_XCloseDisplay)(Display *);

static Bool (* real_XGetFontProperty)(XFontStruct *,Atom,unsigned long *);
static int (* real_XFreeFont)(Display *,XFontStruct *);
static int (* real_XFreeFontInfo)(char **,XFontStruct *,int);
static XFontStruct* (* real_XQueryFont)(Display *,XID);
static XFontStruct* (* real_XLoadQueryFont)(Display *,char *);

static int (* real_XTextWidth)(XFontStruct *,_Xconst char *,int);
static int (* real_XTextWidth16)(XFontStruct *,XChar2b *,int);

static int (* real_XTextExtents)(XFontStruct *,_Xconst char *,int,int *,int *, 
			    int *,XCharStruct *);
static int (* real_XTextExtents16)(XFontStruct *,XChar2b *,int,int *,int *,
			      int *,XCharStruct *);
static int (* real_XQueryTextExtents)(Display *,XID,_Xconst char *,int,
				      int *,int *,
				      int *,XCharStruct *);
static int (* real_XQueryTextExtents16)(Display *,XID,XChar2b *,int,int *,
					int *,int *,XCharStruct *);

static int (* real_XDrawString)(Display *,Drawable,GC,int,int,
				_Xconst char *,int);
static int (* real_XDrawString16)(Display *,Drawable,GC,int,int,XChar2b *,int);
static int (* real_XDrawImageString)(Display *,Drawable,GC,
				     int,int,_Xconst 
				     char *,int);
static int (* real_XDrawImageString16)(Display *,Drawable,GC,
				       int,int,XChar2b *,int);

static int (* real_XChangeGC)(Display *,GC,unsigned long,XGCValues *);
static Status (* real_XGetGCValues)(Display *,GC,unsigned long,XGCValues *);

static int (* real_XChangeProperty)(Display *,Window,Atom,Atom,int,int,
			       unsigned char *,int);

static int (* real_XNextEvent)(Display *,XEvent *);
static int (* real_XPeekEvent)(Display *,XEvent *);
static int (* real_XPutBackEvent)(Display *,XEvent *);
static int (* real_XLookupString)(XKeyEvent *,char *,int,KeySym *,XComposeStatus *);
static int (* real_XSetSelectionOwner)(Display *,Atom,Window,Time);
static Window (* real_XGetSelectionOwner)(Display *,Atom);

static Atom (* real_XInternAtom)(Display *,char *,Bool);

/*
  various static variable to keep the state
 */
static char xa_encoding = DEFAULT_XA_ENCODING;
static char xa_mode = DEFAULT_XA_MODE;
static char cv_mode = DEFAULT_CV_MODE;
static char xa_smart_mode = DEFAULT_XA_SMART;
static char xa_face[20] = DEFAULT_FACE;
static char xa_family[20] = DEFAULT_FAMILY;
static char xa_basefontname[256] = DEFAULT_BASE_FONT_NAME;
static Bool dont_wrap = False;
static int wrap_count = 0;
static Display *sdisplay = NULL;
/* Fixed for netscape Bus Error problem... :(  */
/* 8 display in Max.. Who needs to open more then 8 display ?? */
static Display *display_list[8] = {NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL};
static display_count = 0;

/*
  log function
 */
static void p_log(int id, char *fmt,...)
{

#ifdef XA_DEBUG
	Bool temp;
	va_list args;
	FILE *fp;

	temp=dont_wrap;
        dont_wrap=True;
	if (fp = fopen("/tmp/wraplog", "a")) {
		fprintf(fp, "xa+cv: [%d] ", id);
		va_start(args, fmt);
		vfprintf(fp, fmt, args);
		va_end(args);
		fclose(fp);
	}
	dont_wrap=temp;

#endif 

}

int getprocname(char *return_name)
{
	int i;
	char field1[BufferSize];
	char statusfilename[BufferSize];
	char *dirbase="/proc/%ld/status";
	pid_t pid_number;
	FILE *statusfile;

	pid_number=getpid();
	sprintf(statusfilename, dirbase, (long) pid_number);
	statusfile=fopen(statusfilename, "r");
	if (! statusfile){
	  return_name[0]='\0';
	  return 0;
	}
	fscanf(statusfile,"%70[^\t]\t%256[^\t\n]",field1,return_name);
	fclose(statusfile);
	return strlen(return_name);
}

int xa_mode_init()
{
  char ch;

  if (getenv("XA_ENCODING") && strlen(getenv("XA_ENCODING")) == 1) {
    ch = *(getenv("XA_ENCODING"));
    switch (ch) 
      {
      case ENCODING_BIG5:
      case ENCODING_GB:
	xa_encoding=ch;
	break;
      default:
	xa_encoding=DEFAULT_XA_ENCODING;
	break;
      }
  } else {                 /* No XA_ENCODING, find from LANG */
    if ( getenv("LANG") && strlen(getenv("LANG")) >=5 ){
      if ( !strncasecmp(getenv("LANG"), "zh_TW",5))
	xa_encoding=ENCODING_BIG5;
      if ( !strncasecmp(getenv("LANG"), "zh_CN",5))
	xa_encoding=ENCODING_GB;
    }
  }
  if (getenv("XA_MODE") && strlen(getenv("XA_MODE")) == 1) {
    ch = *(getenv("XA_MODE"));
    switch (ch) 
      {
      case XA_MODE_DISABLE:
      case XA_MODE_TRADITION:
      case XA_MODE_DISCRETE:
      case XA_MODE_PASTE:
	xa_mode=ch;
	break;
      default:
	xa_mode=DEFAULT_XA_MODE;
	break;
      }
  }
}

int cv_mode_init()
{
  char ch;

  if (getenv("XA_CVMODE") && strlen(getenv("XA_CVMODE")) == 1) {
    ch = *(getenv("XA_CVMODE"));
    switch (ch)
      {
      case CV_MODE_ENABLE:
      case CV_MODE_DISABLE:
	cv_mode=ch;
	break;
      default:
	cv_mode=DEFAULT_CV_MODE;
	break;
      }
  }
}

int smart_mode_init()
{
  char ch;
  char program_name[BufferSize];
  char field1[80],field2[16],field3[16];
  char *buff,buffer[BufferSize];
  FILE *database;
  int i;

  if (getenv("XA_SMART") && strlen(getenv("XA_SMART")) == 1) {
    ch = *(getenv("XA_SMART"));
    switch (ch)
      {
      case XA_SMART_YES:
      case XA_SMART_NO:
	xa_smart_mode=ch;
	break;
      default:
	xa_smart_mode=DEFAULT_XA_SMART;
	break;
      }
  }
  
  if ( xa_smart_mode != XA_SMART_NO){
    /* get the program name */
    i=getprocname(program_name);
    if (i !=0){
      p_log(-1,"program_name=%s\n",program_name);
      
      database=fopen(XA_SMART_DADABASE,"r");
      if ( ! database){
	p_log(-1, "can't open database %s!!!\nNo smart mode..\n", 
	      XA_SMART_DADABASE);
      } else {
	while(fgets(buffer,BufferSize,database)){
	  if(buffer[0] == '!') /* stop sign */
	    break;
	  if(buffer[0] != '#'){
	    i=sscanf(buffer,"%70[^:]:%6[^:]:%6[^:\n]",field1,field2,field3);
	    if(i == 3 ){
	      if(! strncmp(program_name,field1,BufferSize)){
		switch (field2[0]) 
		  {
		  case XA_MODE_DISABLE:
		  case XA_MODE_TRADITION:
		  case XA_MODE_DISCRETE:
		  case XA_MODE_PASTE:
		    xa_mode=field2[0];
		    p_log(-1, "smart xa_mode= %c\n",xa_mode); 
		    break;
		  default:
		    break;
		  };
		switch (field3[0])
		  {
		  case CV_MODE_ENABLE:
		  case CV_MODE_DISABLE:
		    cv_mode=field3[0];
		    p_log(-1, "smart cv_mode= %c\n",cv_mode); 
		    break;
		  default:
		    break;
		  };
	      } /* ! strncmp */
	    } /* if (i==3) */
	  } /* if( buffer[0]) */
	} /* while */
	fclose(database);
      } /* else */
    } /* if (xa_smart_mode */
  }
}
  
int load_all_syms(void *handle)
{
  char *error;

  real_XOpenDisplay=dlsym(handle,"XOpenDisplay");
  p_log(-1, " XOpenDisplay loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XCloseDisplay=dlsym(handle,"XCloseDisplay");
  p_log(-1, " XCloseDisplay loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XGetFontProperty=dlsym(handle,"XGetFontProperty");
  p_log(-1, " XGetFontProperty loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XFreeFont=dlsym(handle,"XFreeFont");
  p_log(-1, " XFreeFont loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XFreeFontInfo=dlsym(handle,"XFreeFontInfo");
  p_log(-1, " XFreeFontInfo loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XQueryFont=dlsym(handle,"XQueryFont");
  p_log(-1, " XQueryFont loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XLoadQueryFont=dlsym(handle,"XLoadQueryFont");
  p_log(-1, " XLoadQueryFont loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XTextWidth=dlsym(handle,"XTextWidth");
  p_log(-1, " XTextWidth loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XTextWidth16=dlsym(handle,"XTextWidth16");
  p_log(-1, " XTextWidth16 loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XTextExtents=dlsym(handle,"XTextExtents");
  p_log(-1, " XTextExtents loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XTextExtents16=dlsym(handle,"XTextExtents16");
  p_log(-1, " XTextExtents16 loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XQueryTextExtents=dlsym(handle,"XQueryTextExtents");
  p_log(-1, " XQueryTextExtents loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XQueryTextExtents16=dlsym(handle,"XQueryTextExtents16");
  p_log(-1, " XQueryTextExtents16 loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XDrawString=dlsym(handle,"XDrawString");
  p_log(-1, " XDrawString loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XDrawString16=dlsym(handle,"XDrawString16");
  p_log(-1, " XDrawString16 loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XDrawImageString=dlsym(handle,"XDrawImageString");
  p_log(-1, " XDrawImageString loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XDrawImageString16=dlsym(handle,"XDrawImageString16");
  p_log(-1, " XDrawImageString16 loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XChangeGC=dlsym(handle,"XChangeGC");
  p_log(-1, " XChangeGC loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XGetGCValues=dlsym(handle,"XGetGCValues");
  p_log(-1, " XGetGCValues loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XChangeProperty=dlsym(handle,"XChangeProperty");
  p_log(-1, " XChangeProperty loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XNextEvent=dlsym(handle,"XNextEvent");
  p_log(-1, " XNextEvent loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XPeekEvent=dlsym(handle,"XPeekEvent");
  p_log(-1, " XPeekEvent loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XPutBackEvent=dlsym(handle,"XPutBackEvent");
  p_log(-1, " XPutBackEvent loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XLookupString=dlsym(handle,"XLookupString");
  p_log(-1, " XLookupString loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XSetSelectionOwner=dlsym(handle,"XSetSelectionOwner");
  p_log(-1, " XSetSelectionOwner loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XGetSelectionOwner=dlsym(handle,"XGetSelectionOwner");
  p_log(-1, " XGetSelectionOwner loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  real_XInternAtom=dlsym(handle,"XInternAtom");
  p_log(-1, " XInternAtom loaded...\n");  
  if ((error = dlerror()) != NULL)  {
    fputs(error, stderr);
    exit(1);
  }
  
}  

/*
  
 */
void wrap_init()
{
  static int init_ok = False;
  static void *handle;
  char lib_path[200] = XA_LIBX11;
  
  p_log(-1, "In wrap_init\n");
  
  if (!init_ok) {
    if (getenv("XA_LIBX11") != NULL)
      strcpy(lib_path, getenv("XA_LIBX11"));
    
    p_log(-1, "In ! wrap_init ok\n");
    
    handle = dlopen(lib_path, RTLD_LAZY);
    
    if (!handle) {
      p_log(-1, "can't open %s!!!\ntry default\n", lib_path, XA_LIBX11);
      handle = dlopen(XA_LIBX11, RTLD_LAZY);
      if (!handle) {
	p_log(-1, "can't open %s!!!\n", XA_LIBX11);
	exit(1);
      }
    }
    init_ok = True;
    
    /* do some init :) */
    xa_mode_init();
    cv_mode_init();
    smart_mode_init();

    if (getenv("XA_BASEFONTNAME") && strlen(getenv("XA_BASEFONTNAME")) >= 1 
	&& strlen(getenv("XA_BASEFONTNAME")) <= 250)
      strncpy(xa_basefontname , getenv("XA_BASEFONTNAME"),255 );

    if (getenv("XA_FACE") && strlen(getenv("XA_FACE")) >= 1 
	&& strlen(getenv("XA_FACE")) <=16)
      strncpy(xa_face , getenv("XA_FACE"),16 );

    if (getenv("XA_FAMILY") && strlen(getenv("XA_FAMILY")) >= 1
	&& strlen(getenv("XA_FAMILY")) <=16)
      strncpy(xa_family , getenv("XA_FAMILY"),16 );

    /* Open all needed sym... */
    load_all_syms(handle);  
  }
  
  p_log(-1, "Leave wrap_init\n");
  
}

Bool isbig5(const unsigned char *string)
{
  if ((string[0] >= 0xa1 && string[0] <= 0xfe) && 
      ((string[1] >= 0x40 && string[1] <= 0x7e) ||
       (string[1] >= 0xa1 && string[1] <= 0xfe)))
    return True;
  else
    return False;
}

Bool isgbk(const unsigned char *string)
{
  if ((string[0] >= 0x81 && string[0] <= 0xfe) && 
      (string[1] >= 0x40 && string[1] <= 0xfe))
    return True;
  else
    return False;
}

/*
  IN:  string to be divided, start point, length of the string
  OUT: chinese -> *ischinese=1
       not chinese -> *ischinese=0
       return -> next start
 */
int next_string(const unsigned char *string,int start,int length,int *ischinese)
{
  *ischinese=-1;
/*  p_log(-1,"string=\"%s\"start=%d length=%d\n",string,start,length); */
  for (; start < length;) {  
    if ( ((xa_encoding==ENCODING_GB && isgbk(&string[start])) ||
	 (xa_encoding==ENCODING_BIG5 && isbig5(&string[start]))) &&
	 (start < length -1 ) ) {
      if(*ischinese==-1) *ischinese=1;
      if(!*ischinese) return start;
      start += 2;
    } else {
      if(*ischinese==-1) *ischinese=0;
      if (*ischinese) return start;
      start++;
    }
  }
  return start;
} 

/*
  get_cfont
 */

XFontStruct *get_cfont(Display *display, XFontStruct *efont)
{

  char fontname[BufferSize];
  long prop[BufferSize];

  static XFontStruct *cfontlist[CFNTMAX], *small_cfont;
  static int cfontpixels[CFNTMAX];
  static int cfontnow=0;
  static int cfont_init=0;
  static int small_cfont_init=0;

  int i;
  int e_pixels=0;
  int cfontnext=0;
  Atom am;

  /* get the hight of english font */
  am=real_XInternAtom(display, "PIXEL_SIZE", False);
  if (real_XGetFontProperty(efont, am, prop))
    e_pixels=(int) prop[0];
  else {
    p_log(-1,"Can't find the PIXEL_SIZE, am=%d\n",am);
    exit(1);
  }

  p_log(-1,"cfont-1\n");
  /* clear the too small font */
  /* small_cfont_init == 0 -> not init yet
     small_cfont_init == 1 -> init ok,,return it!!
     small_cfont_init == -1 -> init non-ok,, don't use small font.
  */
      
  if ( e_pixels < MIN_SMALL_FONT_PIXELS){
    p_log(-1,"cfont-2\n");
    /* load the default small c font */
    if (small_cfont_init == 0){
      /* not load yet */
        p_log(-1,"cfont-3\n");
      if ( xa_encoding == ENCODING_GB)
	strcpy(fontname,DEFAULT_SMALL_GB_FONT);
      else
	strcpy(fontname,DEFAULT_SMALL_BIG5_FONT);
      p_log(-1,"cfont-4\n");
      if (!( small_cfont = real_XLoadQueryFont(display, fontname))){
	/* no default small font */
	small_cfont_init = -1;
      } else {
	small_cfont_init =1;
	  p_log(-1,"cfont-5\n");
	return small_cfont;
      }
    }
    if (small_cfont_init == 1)
      return small_cfont;
  }


    p_log(-1,"cfont-6\n");
  /* Have we init the cfontlist ?? */
  if(! cfont_init){    /* not init!! */
    cfont_init=1;
    p_log(-1,"cfont-7\n");
    /* zero the cfontpixels array */
    for(i=0; i<CFNTMAX; i++)
      cfontpixels[i]=0;
    
    p_log(-1,"cfont-8\n");
    if ( xa_encoding == ENCODING_GB)
      sprintf(fontname, xa_basefontname, xa_family, xa_face, e_pixels,e_pixels*10, GB_FONT_ENCODING);
    else
      sprintf(fontname, xa_basefontname, xa_family, xa_face, e_pixels,e_pixels*10, BIG5_FONT_ENCODING);
    
    p_log(-1,"fontname-1-: %s\n",fontname);
    if (!(cfontlist[0] = real_XLoadQueryFont(display, fontname))){
      /* can't find matched cfont */

      /* check if we got a small_font as default */
      if (small_cfont_init == 1)
	return small_cfont;

      /* anyway, pick one font whatever... */
      if ( xa_encoding == ENCODING_GB)
	sprintf(fontname, "-*-*-*-r-*-*-*-*-*-*-*-*-%s",GB_FONT_ENCODING);
      else
	sprintf(fontname, "-*-*-*-r-*-*-*-*-*-*-*-*-%s",BIG5_FONT_ENCODING);
      
      if (!(cfontlist[0] = real_XLoadQueryFont(display, fontname))){
	p_log(-1,"Can't find any cfont, %s\n",fontname);
	exit(1);
      }
      if (real_XGetFontProperty(cfontlist[0], am, prop))
	cfontpixels[0]=(int) prop[0];
      else {
	p_log(-1,"Can't find PIXEL_SIZE of cfont, am=%d\n",am);
	exit(1);
      }
      cfontnow=0;
      p_log(-1,"Ok1, load whatever cfont, %s\n",fontname);
      cfont_init=1;
      return cfontlist[0];
    }
    cfontpixels[0]=e_pixels;
    cfontnow=0;
    p_log(-1,"Ok, init load cfont, %s\n",fontname);
    cfont_init=1;
    return cfontlist[0];
  }

  /* can we find a loaded cfont which matched in the cfontlist ?? */
  for ( i=0; i<CFNTMAX; i++)
    if (cfontpixels[i] == e_pixels )      /* Yes!! return it.. :)  */
      return cfontlist[i];
  
  /* No, allocate a new one */
  cfontnext=cfontnow+1;
  if (cfontnext >= CFNTMAX)
    cfontnext=cfontnext % CFNTMAX;
  
  if ( cfontpixels[cfontnext] >0)
    real_XFreeFont(display, cfontlist[cfontnext]);

  if ( xa_encoding == ENCODING_GB)
    sprintf(fontname, xa_basefontname, xa_family, xa_face, e_pixels,e_pixels*10, GB_FONT_ENCODING);
  else
    sprintf(fontname, xa_basefontname, xa_family, xa_face, e_pixels,e_pixels*10, BIG5_FONT_ENCODING);

  p_log(-1,"fontname-2-: %s\n",fontname);
  
  if (!(cfontlist[cfontnext] = real_XLoadQueryFont(display, fontname))){
    /* can't find matched cfont */
    /* check if we got a small_font as default */
    if (small_cfont_init == 1)
      return small_cfont;
    
    /* anyway, pick one font whatever... */
    if ( xa_encoding == ENCODING_GB)
      sprintf(fontname, "-*-*-*-r-*-*-*-*-*-*-*-*-%s",GB_FONT_ENCODING);
    else
      sprintf(fontname, "-*-*-*-r-*-*-*-*-*-*-*-*-%s",BIG5_FONT_ENCODING);
      
    if (!(cfontlist[cfontnext] = real_XLoadQueryFont(display, fontname))){
      p_log(-1,"Can't find any cfont, %s\n",fontname);
      exit(1);
    }
    if (real_XGetFontProperty(cfontlist[cfontnext], am, prop))
      cfontpixels[cfontnext]=(int) prop[0];
    else {
      p_log(-1,"Can't find PIXEL_SIZE of cfont, am=%d\n",am);
      exit(1);
    }
    cfontnow=cfontnext;
    p_log(-1,"Ok11, load whatever cfont, %s\n",fontname);
    return cfontlist[cfontnext];
  }
  cfontpixels[cfontnext]=e_pixels;
  cfontnow=cfontnext;
  p_log(-1,"Ok, load cfont, %s\n",fontname);
  return cfontlist[cfontnext];
  
}


/*
  CV type functions
  We wrapped the following functions:
  XOpenDisplay
  XTextWidth
  XTextExtents
  XQueryTextExtents
  XDrawString
  XDrawImageString
*/

Display * XOpenDisplay (_Xconst char *display_name)
{
  p_log(-1, "In XOpenDisplay\n");
  wrap_init();

  if ( sdisplay != NULL ){
    /* keep the old display */
    p_log(-1, "keep the old display!!\n");
    display_list[display_count]=sdisplay;
    display_count++;
    p_log(-1, "display_count = %d\n",display_count);
  }
  sdisplay = real_XOpenDisplay(display_name);
  return sdisplay;
}


int XCloseDisplay (Display *display)
{
  int i,j;

  p_log(-1, "In XCloseDisplay\n");
  wrap_init();
  if ( sdisplay != NULL && display_list[display_count-1] != NULL){
    /* renew a display */
    if(sdisplay == display) {
      p_log(-1, "In XCloseDisplay 1\n");
      sdisplay=display_list[display_count-1];
      display_list[display_count-1]=NULL;
      display_count--;
    } else {
      p_log(-1, "In XCloseDisplay 2\n");
      for(i=0; i<display_count; i++){
	if( display_list[i] == display) {
	  for(j=i;j<display_count-1;j++)
	    display_list[j]=display_list[j+1];
	  display_list[display_count-1]=NULL;
	  display_count--;
	}
      }
    }
  }
  return (real_XCloseDisplay(display));
}


int XTextWidth (XFontStruct *font_struct,_Xconst char *in_string, int count)
{
  int width=0;
  int i=0,j=0;
  int k=0;
  int ischinese;
  XFontStruct *cfont;
  unsigned char string[BufferSize*4];
  
  wrap_init();
  if (dont_wrap || cv_mode==CV_MODE_DISABLE) 
    return real_XTextWidth(font_struct, in_string, count);
  
  dont_wrap=True;

  strncpy(string, in_string,count);
  /* got the chinese font */
  cfont=get_cfont(sdisplay, font_struct);

  for(;j<count;){
    j=next_string(string, i, count, &ischinese);
    if ( ischinese == 1){
      if (xa_encoding == ENCODING_GB )
	for(k=i;k<j;k++) string[k] -= 0x80;
      width += real_XTextWidth16(cfont, (XChar2b *) &string[i],(j-i)/2);
      if (xa_encoding == ENCODING_GB )
	for(k=i;k<j;k++) string[k] += 0x80;
    }
    else
      width += real_XTextWidth(font_struct, &string[i], (j-i));
    
    i=j;
  }
  dont_wrap=False;
  return width;
}

int XTextExtents (XFontStruct *font_struct,_Xconst char *in_string, 
		  int nchars,
		  int *direction_return, int *font_ascent_return,
		  int *font_descent_return, XCharStruct *overall_return )
{
  int ascent=0,descent=0;
  XCharStruct overall;
  int i=0,j=0;
  int k=0;
  int ischinese;
  XFontStruct *cfont;
  unsigned char string[BufferSize*4];
  int rtn;

  p_log(-1, "In XTextExtents-1\n");
  wrap_init();
  if (dont_wrap || cv_mode==CV_MODE_DISABLE)
    return real_XTextExtents(font_struct,in_string,nchars,direction_return,
				font_ascent_return,font_descent_return,
				overall_return);
  dont_wrap=True;

  strncpy(string, in_string,nchars);
  p_log(-1, "In XTextExtents-2\n");
  rtn=0;
  /* got the chinese font */
  cfont=get_cfont(sdisplay, font_struct);
  p_log(-1, "In XTextExtents-3\n");

  j=next_string(string, i, nchars, &ischinese);
  p_log(-1, "In XTextExtents-4\n");
  /* frist segment of the string */
  if ( ischinese == 1){
      p_log(-1, "In XTextExtents-5\n");
    if (xa_encoding == ENCODING_GB )
      for(k=i;k<j;k++) string[k] -= 0x80;
    rtn=real_XTextExtents16(cfont, (XChar2b *) &string[i], 
			    (j-i)/2,direction_return,
			    font_ascent_return,font_descent_return,
			    overall_return);
    if (xa_encoding == ENCODING_GB )
      for(k=i;k<j;k++) string[k] += 0x80;
  }
  else
    rtn=real_XTextExtents(font_struct,&string[i], (j-i),direction_return,
		 font_ascent_return,font_descent_return,overall_return);
  
  p_log(-1, "In XTextExtents-6\n");
  for(;j<nchars;){
    p_log(-1, "In XTextExtents-7\n");
    j=next_string(string, i, nchars, &ischinese);
    if ( ischinese == 1){
      if (xa_encoding == ENCODING_GB )
	for(k=i;k<j;k++) string[k] -= 0x80;
      rtn+=real_XTextExtents16(cfont,(XChar2b *)&string[i],
			       (j-i)/2,direction_return,
			       &ascent,&descent,&overall);
      if (xa_encoding == ENCODING_GB )
	for(k=i;k<j;k++) string[k] += 0x80;
    }
    else
      rtn+=real_XTextExtents(font_struct,&string[i], (j-i),direction_return,
		    &ascent,&descent,&overall);

    *font_ascent_return=max(ascent,*font_ascent_return);
    *font_descent_return=max(descent,*font_descent_return);
    overall_return->rbearing=overall_return->width + overall.rbearing;
    overall_return->width+=overall.width;
    overall_return->ascent=max(overall_return->ascent,overall.ascent);
    overall_return->descent=max(overall_return->descent,overall.descent);
    
    i=j;
  }
  p_log(-1, "In XTextExtents-8\n");
  dont_wrap=False;

  return rtn;
}



int XQueryTextExtents(Display *display,XID font_ID,_Xconst char *in_string, 
		      int nchars,
		      int *direction_return, int *font_ascent_return,
		      int *font_descent_return, XCharStruct *overall_return )
{
  int ascent=0,descent=0;
  XCharStruct overall;
  int i=0,j=0;
  int k=0;
  int ischinese;
  XFontStruct *cfont,*efont;
  unsigned char string[BufferSize*4];
  int rtn;

  wrap_init();
  if (dont_wrap || cv_mode==CV_MODE_DISABLE)
    return real_XQueryTextExtents(display,font_ID,in_string,nchars,
				     direction_return,
				     font_ascent_return,
				     font_descent_return,
				     overall_return);
  dont_wrap=True;
  
  strncpy(string, in_string,nchars);
  rtn=0;
  /* got the chinese font */
  efont=real_XQueryFont(display,font_ID);
  cfont=get_cfont(display, efont);
  real_XFreeFontInfo(NULL,efont,1);

  j=next_string(string, i, nchars, &ischinese);

  /* frist segment of the string */
  if ( ischinese == 1){
    if (xa_encoding == ENCODING_GB )
      for(k=i;k<j;k++) string[k] -= 0x80;
    rtn=real_XQueryTextExtents16(display,cfont->fid, (XChar2b *) &string[i], 
			    (j-i)/2,direction_return,font_ascent_return,
			    font_descent_return,overall_return);
    if (xa_encoding == ENCODING_GB )
      for(k=i;k<j;k++) string[k] += 0x80;
  }
  else
    rtn=real_XQueryTextExtents(display,font_ID,&string[i], (j-i),direction_return,
		 font_ascent_return,font_descent_return,overall_return);
  
  for(;j<nchars;){
    j=next_string(string, i, nchars, &ischinese);
    if ( ischinese == 1){
      if (xa_encoding == ENCODING_GB )
	for(k=i;k<j;k++) string[k] -= 0x80;
      rtn+=real_XQueryTextExtents16(display,cfont->fid,(XChar2b *)&string[i],
			       (j-i)/2,direction_return,
			       &ascent,&descent,&overall);
      if (xa_encoding == ENCODING_GB )
	for(k=i;k<j;k++) string[k] += 0x80;
    }
    else
      rtn+=real_XQueryTextExtents(display,font_ID,&string[i], (j-i),direction_return,
		    &ascent,&descent,&overall);

    *font_ascent_return=max(ascent,*font_ascent_return);
    *font_descent_return=max(descent,*font_descent_return);
    overall_return->rbearing=overall_return->width + overall.rbearing;
    overall_return->width+=overall.width;
    overall_return->ascent=max(overall_return->ascent,overall.ascent);
    overall_return->descent=max(overall_return->descent,overall.descent);
    
    i=j;
  }
  dont_wrap=False;
  return rtn;
}


int XDrawString (Display *display,Drawable d, GC gc, int x, int y,
		 _Xconst char *in_string, int length)
{
  int width=0;
  int i=0,j=0;
  int k=0;
  int ischinese;
  int rtn;
  XGCValues xgcv;
  XFontStruct *cfont,*efont;
  unsigned char string[BufferSize*4];

  wrap_init();
  if (dont_wrap || cv_mode==CV_MODE_DISABLE)
    return real_XDrawString(display,d,gc,x,y,in_string,length);
  dont_wrap=True;
  strncpy(string, in_string,length);
  rtn=0;
  
  /* got the chinese font */
  real_XGetGCValues(display, gc, GCFont, &xgcv);
  efont=real_XQueryFont(display, xgcv.font);
  cfont=get_cfont(display, efont);

  for(;j<length;){
    j=next_string(string, i, length, &ischinese);
    if ( ischinese == 1){
      xgcv.font = cfont->fid;
      real_XChangeGC(display, gc, GCFont, &xgcv);
      if (xa_encoding == ENCODING_GB )
	for(k=i;k<j;k++) string[k] -= 0x80;
      rtn=real_XDrawString16(display,d,gc,x+width,y,(XChar2b *)&string[i],(j-i)/2);
      width+=real_XTextWidth16(cfont,(XChar2b *)&string[i],(j-i)/2);
      if (xa_encoding == ENCODING_GB )
	for(k=i;k<j;k++) string[k] += 0x80;
      xgcv.font = efont->fid;
      real_XChangeGC(display, gc, GCFont, &xgcv);
    } else {
      rtn=real_XDrawString(display,d,gc,x+width,y,&string[i],(j-i));
      dont_wrap=1;
      width+=real_XTextWidth(efont,&string[i],(j-i));
      dont_wrap=0;
    }
    i=j;
  }
  real_XFreeFontInfo(NULL,efont,1);
  dont_wrap=False;
  return rtn;
}


int XDrawImageString (Display *display,Drawable d, GC gc, int x, int y,
		      _Xconst char *in_string, int length)
{
  int width=0;
  int i=0,j=0;
  int k=0;
  int ischinese;
  XGCValues xgcv;
  XFontStruct *cfont,*efont;
  unsigned char string[BufferSize*4];
  int rtn;

  wrap_init();
  if (dont_wrap || cv_mode==CV_MODE_DISABLE)
    return real_XDrawImageString(display,d,gc,x,y,in_string,length);
  dont_wrap=True;

  strncpy(string, in_string,length);
  rtn=0;
  
  /* got the chinese font */
  real_XGetGCValues(display, gc, GCFont, &xgcv);
  efont=real_XQueryFont(display, xgcv.font);
  cfont=get_cfont(display, efont);

  for(;j<length;){
    j=next_string(string, i, length, &ischinese);
    if ( ischinese == 1){
      xgcv.font = cfont->fid;
      real_XChangeGC(display, gc, GCFont, &xgcv);
      if (xa_encoding == ENCODING_GB )
	for(k=i;k<j;k++) string[k] -= 0x80;
      rtn=real_XDrawImageString16(display,d,gc,x+width,y,(XChar2b *)&string[i],(j-i)/2);
      width+=real_XTextWidth16(cfont,(XChar2b *)&string[i],(j-i)/2);
      if (xa_encoding == ENCODING_GB )
	for(k=i;k<j;k++) string[k] += 0x80;
      xgcv.font = efont->fid;
      real_XChangeGC(display, gc, GCFont, &xgcv);
    } else {
      rtn=real_XDrawImageString(display,d,gc,x+width,y,&string[i],(j-i));
      dont_wrap=1;
      width+=real_XTextWidth(efont,&string[i],(j-i));
      dont_wrap=0;
    }
    i=j;
  }
  real_XFreeFontInfo(NULL,efont,1);
  dont_wrap=False;
  return rtn;
 
}

/*
  XA type functions
  We wrapped the following functions:
  XNextEvent
  XLookupString
*/

extern void __Xcin_Anywhere_Select_Mode__(Display *, char *, char *);
static init = 0;
static Display *defdisplay;
static Window defw;

static real_a = 1;
static not_real_a = 0;
static char bigbuf[500] = "\0";
static int kk;
static int oldkcode;

int XLookupString(XKeyEvent * eve, char *buf, int len, 
		  KeySym * ksym, XComposeStatus * st)
{
  int rtn;

  wrap_init();
  if (dont_wrap || xa_mode == XA_MODE_DISABLE)
    return real_XLookupString(eve, buf, len, ksym, st);

  if (init && !real_a && eve->keycode == A_SCAN_CODE && strlen(bigbuf)) {
    eve->keycode = A_SCAN_CODE;
    real_XLookupString(eve, buf, len, ksym, st);
    if (xa_mode == XA_MODE_TRADITION){
      strncpy(buf, bigbuf, len - 1);
      buf[len - 1] = 0;
      rtn = strlen(buf);
    }
    else{
      buf[0]=bigbuf[0];
      rtn = 1;
    }
    p_log(1, "Send len=%d %s!!!\n", len, buf);
  } else {
    rtn = real_XLookupString(eve, buf, len, ksym, st);   
    p_log(1, "len=%d\n", len);
  }
  p_log(1, "rtn=%d \n", rtn);
  return rtn;
}


static int do_key(Display * display, XKeyEvent * xke)
{
  char ybuf[2000];
  if (xke->keycode == A_SCAN_CODE && not_real_a > 0) {
    not_real_a--;
    return 0;
  }
  defdisplay = display;
  memcpy(&defw, &(xke->window), sizeof defw);
  dont_wrap = 1;
  kk = send_key(display, defw, xke, ybuf);
  dont_wrap = 0;
  
  init = 1;
  if (!kk) {
    if (xke->keycode == A_SCAN_CODE)
      real_a = 1;
    return 1;
  }
  if (ybuf[0]) {
    xke->state = 0;
    xke->keycode = A_SCAN_CODE;
    real_a = 0;
    strcpy(bigbuf, ybuf);
    p_log(0, "bigbuf len=%d\n", strlen(bigbuf));
    return 1;
  }
  return 0;
}

static saved = 0;
static XEvent sevent;

int XNextEvent(Display * display, XEvent * event)
{
  int rtn;

  wrap_init();
  if (dont_wrap)
    return real_XNextEvent(display, event);
  if (xa_mode == XA_MODE_DISCRETE && saved && strlen(bigbuf) > 1) {
    int i, j;
    
    XKeyEvent *xke = (XKeyEvent *) event;
    p_log(1, "bigbuf len=%d\n", strlen(bigbuf));
    j = strlen(bigbuf);
    if (j == 2) {
      XKeyEvent *xke = (XKeyEvent *) event;
      real_XPeekEvent(display, event);
      if (event->type == KeyPress && not_real_a > 0)
	if (xke->keycode == A_SCAN_CODE) {
	  rtn = real_XNextEvent(display, event);
	  not_real_a--;
	}
    }
    for (i = 0; i < j; i++)
      bigbuf[i] = bigbuf[i + 1];
    memcpy(event, &sevent, sizeof(sevent));
    xke->state = 0;
    xke->keycode = A_SCAN_CODE;
    real_a = 0;
    return 0;
  }
 ne_start:
  rtn = real_XNextEvent(display, event);
  
  if (event->type == KeyPress) {
    XKeyEvent *xke = (XKeyEvent *) event;
    KeySym ks;
    char smallbuf[20];
    memcpy(&sevent, event, sizeof(sevent));
    saved = 1;
    
    dont_wrap = 1;
    if (!real_XLookupString(xke, smallbuf, sizeof(smallbuf), &ks, NULL)
	&& ( ks == XK_F12 ) ) {
      __Xcin_Anywhere_Select_Mode__(xke->display, &xa_mode, &cv_mode);
      if (xa_mode == XA_MODE_DISCRETE)
	bigbuf[0] = 0;
      dont_wrap = 0;
      goto ne_start;
    }
    dont_wrap = 0;
    if (xa_mode == XA_MODE_DISABLE)
      return 0;
    
    
    p_log(1, "Key Pressed state=%d code=%d\n", xke->state, xke->keycode);
    
    if (!do_key(display, xke))
      goto ne_start;
    if (!real_a && bigbuf[0] && xke->keycode == A_SCAN_CODE) {
      if(xa_mode!=XA_MODE_PASTE)
	{
	  real_XPutBackEvent(display, event);
	  not_real_a++;
        }
      else
	{
	  XSelectionEvent *notify;
	  XButtonEvent *xbe;
	  xbe=(XButtonEvent *)event;
	  notify=(XSelectionEvent *)event;
	  
	  real_XSetSelectionOwner(display, XA_PRIMARY, defw, xke->time);
	  if (real_XGetSelectionOwner(display, XA_PRIMARY) != defw)
	    p_log(-1,"Could not get primary selection");
	  real_XChangeProperty(display, DefaultRootWindow(display), 
			       XA_CUT_BUFFER0,
			       XA_STRING, 8, 
			       PropModeReplace, bigbuf, strlen(bigbuf));
	  p_log(-1,"button!!!\n");
	  event->type=ButtonPress;
	  xbe->button=Button2;
	  real_XPutBackEvent(display, event);  
	  event->type=ButtonRelease;
	  xbe->button=Button2;
	}
    }
  } else if (event->type == FocusIn) {
    p_log(1, "Focus in\n");
    if (init) {
      send_FocusIn(defdisplay, defw);
    }
    else if (event->type==SelectionRequest)
      {
	p_log(-1,"SelectionRequest\n");
      }
    
  }
  p_log(1, "rtn=%d\n", rtn);
  return rtn;
}

