//////////////////////////////////////////////////////////////////////////////
// Name:        svgview.cpp
// Purpose:     
// Author:      Alex Thuering
// Created:     15/01/2005
// RCS-ID:      $Id: calculette.cpp,v 1.11 2008/07/01 16:51:49 etisserant Exp $
// Copyright:   (c) Alex Thuering
// Licence:     wxWindows licence
//////////////////////////////////////////////////////////////////////////////

#if defined(__GNUG__) && !defined(__APPLE__)
#pragma implementation
#pragma interface
#endif

// For compilers that support precompilation, includes "wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#include <wx/filename.h>
#endif

#ifndef __WXMSW__
#include <locale.h>
#endif

#include "calculette.h"
#include <wxSVG/svg.h>

//////////////////////////////////////////////////////////////////////////////
///////////////////////////////  Application /////////////////////////////////
//////////////////////////////////////////////////////////////////////////////

IMPLEMENT_APP(SVGViewApp)

bool SVGViewApp::OnInit()
{
#ifndef __WXMSW__
  setlocale(LC_NUMERIC, "C");
#endif
  //wxLog::SetActiveTarget(new wxLogStderr);
  
  new MainFrame(NULL, wxT("Calculette"),
  wxDefaultPosition, wxSize(275, 335));
  return true;
}

//////////////////////////////////////////////////////////////////////////////
////////////////////////////////  MainFrame //////////////////////////////////
//////////////////////////////////////////////////////////////////////////////
enum
{
wxID_FIT = 1,
};

const double pi = 3.1415926;

BEGIN_EVENT_TABLE(Calculette, SVGUIWindow)
  EVT_BUTTON (SVGUIID("boutonAC"), Calculette::OnBoutonACClick)
  EVT_BUTTON (SVGUIID("bouton0"), Calculette::OnBouton0Click)
  EVT_BUTTON (SVGUIID("bouton1"), Calculette::OnBouton1Click)
  EVT_BUTTON (SVGUIID("bouton2"), Calculette::OnBouton2Click)
  EVT_BUTTON (SVGUIID("bouton3"), Calculette::OnBouton3Click)
  EVT_BUTTON (SVGUIID("bouton4"), Calculette::OnBouton4Click)
  EVT_BUTTON (SVGUIID("bouton5"), Calculette::OnBouton5Click)
  EVT_BUTTON (SVGUIID("bouton6"), Calculette::OnBouton6Click)
  EVT_BUTTON (SVGUIID("bouton7"), Calculette::OnBouton7Click)
  EVT_BUTTON (SVGUIID("bouton8"), Calculette::OnBouton8Click)
  EVT_BUTTON (SVGUIID("bouton9"), Calculette::OnBouton9Click)
  EVT_BUTTON (SVGUIID("boutonpoint"), Calculette::OnBoutonPointClick)
  EVT_BUTTON (SVGUIID("boutonegal"), Calculette::OnBoutonEgalClick)
  EVT_BUTTON (SVGUIID("boutonmultiplier"), Calculette::OnBoutonMultiplierClick)
  EVT_BUTTON (SVGUIID("boutondiviser"), Calculette::OnBoutonDiviserClick)
  EVT_BUTTON (SVGUIID("boutonplus"), Calculette::OnBoutonPlusClick)
  EVT_BUTTON (SVGUIID("boutonmoins"), Calculette::OnBoutonMoinsClick)
  EVT_BUTTON (SVGUIID("boutoncos"), Calculette::OnBoutonCosClick)
  EVT_BUTTON (SVGUIID("boutonsin"), Calculette::OnBoutonSinClick)
  EVT_BUTTON (SVGUIID("boutontan"), Calculette::OnBoutonTanClick)
  EVT_BUTTON (SVGUIID("boutonangleplus"), Calculette::OnBoutonAnglePlusClick)
  EVT_BUTTON (SVGUIID("boutonanglemoins"), Calculette::OnBoutonAngleMoinsClick)
  EVT_COMMAND_SCROLL_THUMBTRACK(SVGUIID("cercle_trigo"), Calculette::OnCercleTrigoChanged)
END_EVENT_TABLE()

MainFrame::MainFrame(wxWindow *parent, const wxString& title, const wxPoint& pos,
  const wxSize& size, long style): wxFrame(parent, wxID_ANY, title, pos, size, style)
{
  wxFileName apppath(wxTheApp->argv[0]);
  apppath.RemoveLastDir();
  wxFileName svgfilepath(apppath.GetPath(), wxT("Calculette.svg"));
  wxFileName xmlfilepath(apppath.GetPath(), wxT("Calculette.xml"));
  
  m_svgCtrl = new Calculette(this);
  if (wxTheApp->argc > 1)
    m_svgCtrl->LoadFiles(wxTheApp->argv[1],wxTheApp->argv[2]);
  else
    m_svgCtrl->LoadFiles(svgfilepath.GetFullPath(), xmlfilepath.GetFullPath());
  
  Show(true);
  m_svgCtrl->SetFocus();
  m_svgCtrl->Erase();
  m_svgCtrl->SetFitToFrame(true);
  m_svgCtrl->RefreshTrigoValues();
  m_svgCtrl->Update();
}

Calculette::Calculette(wxWindow* parent):
 SVGUIWindow(parent)
{
  m_first_key = true;
  m_result = 0;
  m_operation = NO;  
}

wxWindow* Calculette::CreateWindow(const wxString& classname)
{
  wxWindow* res = NULL;
  if (classname == wxT("Calculette"))
    res = new Calculette(this);
  return res;
}

void Calculette::SetNombreValue(const wxString value)
{
  SVGUITextCtrl* text = (SVGUITextCtrl*)GetElementByName(wxT("nombre"));
  text->SetValue(value);
  m_first_key = true;
}

void Calculette::Erase()
{
  SVGUITextCtrl* text = (SVGUITextCtrl*)GetElementByName(wxT("nombre"));
  text->SetValue(wxT("0"));
  m_first_key = true;
  m_result = 0;
  m_operation = NO;
}

void Calculette::Error()
{
  SVGUITextCtrl* text = (SVGUITextCtrl*)GetElementByName(wxT("nombre"));
  text->SetValue(wxT("Error"));
  m_first_key = true;
  m_result = 0;
  m_operation = NO;
}

void Calculette::Calculer()
{
  SVGUITextCtrl* text = (SVGUITextCtrl*)GetElementByName(wxT("nombre"));
  double value;
  if (text->GetValue().ToDouble(&value))
  {
    if (m_operation == NO)
      m_result = value;
    else if (m_operation == PLUS)
      m_result += value;
    else if (m_operation == MOINS)
      m_result -= value;
    else if (m_operation == MULTIPLIER)
      m_result *= value;
    else if (m_operation == DIVISER)
    {
      if (value == 0)
      {
        Error();
        return;
      }
      m_result /= value;
    }
    wxString result = wxString::Format(wxT("%.1f"), m_result);
    text->SetValue(result);
    m_first_key = true;
  }
  else
    Error();
}

void Calculette::OnBoutonACClick(wxCommandEvent& event)
{
  wxKeyEvent keyevent(wxEVT_CHAR);
  keyevent.m_keyCode = WXK_DELETE;
  ProcessEvent(keyevent);
  event.Skip();
}

void Calculette::OnChar(wxKeyEvent& event)
{
  SVGUITextCtrl* text = (SVGUITextCtrl*)GetElementByName(wxT("nombre"));
  long keycode = event.GetKeyCode();
  if ((char)keycode == '+')
  {
    Calculer();
    m_operation = PLUS;
  }
  else if ((char)keycode == '-')
  {
    Calculer();
    m_operation = MOINS;
  }
  else if ((char)keycode == '*')
  {
    Calculer();
    m_operation = MULTIPLIER;
  }
  else if ((char)keycode == '/')
  {
    Calculer();
    m_operation = DIVISER;
  }
  else if (keycode == WXK_RETURN)
  {
    Calculer();
    m_operation = NO;
  }
  else if (keycode == WXK_DELETE)
  {
    Erase();  
  }
  else if (keycode == (long)'.')
  {
    if (m_first_key)
    {
      m_first_key = false;
      text->SetValue(wxT("0"));
    }
    text->OnChar(event);
  }
  else if (keycode >= (long)'0' && keycode <= (long)'9')
  {
    if (m_first_key)
    {
      m_first_key = false;
      text->SetValue(wxT(""));
    }
    text->OnChar(event);
  }
}

void Calculette::OnBouton0Click(wxCommandEvent& event)
{
  wxKeyEvent keyevent(wxEVT_CHAR);
  keyevent.m_keyCode = (long)'0';
  ProcessEvent(keyevent);
  event.Skip();
}

void Calculette::OnBouton1Click(wxCommandEvent& event)
{
  wxKeyEvent keyevent(wxEVT_CHAR);
  keyevent.m_keyCode = (long)'1';
  ProcessEvent(keyevent);
  event.Skip();
}

void Calculette::OnBouton2Click(wxCommandEvent& event)
{
  wxKeyEvent keyevent(wxEVT_CHAR);
  keyevent.m_keyCode = (long)'2';
  ProcessEvent(keyevent);
  event.Skip();
}

void Calculette::OnBouton3Click(wxCommandEvent& event)
{
  wxKeyEvent keyevent(wxEVT_CHAR);
  keyevent.m_keyCode = (long)'3';
  ProcessEvent(keyevent);
  event.Skip();
}

void Calculette::OnBouton4Click(wxCommandEvent& event)
{
  wxKeyEvent keyevent(wxEVT_CHAR);
  keyevent.m_keyCode = (long)'4';
  ProcessEvent(keyevent);
  event.Skip();
}

void Calculette::OnBouton5Click(wxCommandEvent& event)
{
  wxKeyEvent keyevent(wxEVT_CHAR);
  keyevent.m_keyCode = (long)'5';
  ProcessEvent(keyevent);
  event.Skip();
}

void Calculette::OnBouton6Click(wxCommandEvent& event)
{
  wxKeyEvent keyevent(wxEVT_CHAR);
  keyevent.m_keyCode = (long)'6';
  ProcessEvent(keyevent);
  event.Skip();
}

void Calculette::OnBouton7Click(wxCommandEvent& event)
{
  wxKeyEvent keyevent(wxEVT_CHAR);
  keyevent.m_keyCode = (long)'7';
  ProcessEvent(keyevent);
  event.Skip();
}

void Calculette::OnBouton8Click(wxCommandEvent& event)
{
  wxKeyEvent keyevent(wxEVT_CHAR);
  keyevent.m_keyCode = (long)'8';
  ProcessEvent(keyevent);
  event.Skip();
}

void Calculette::OnBouton9Click(wxCommandEvent& event)
{
  wxKeyEvent keyevent(wxEVT_CHAR);
  keyevent.m_keyCode = (long)'9';
  ProcessEvent(keyevent);
  event.Skip();
}

void Calculette::OnBoutonPlusClick(wxCommandEvent& event)
{
  wxKeyEvent keyevent(wxEVT_CHAR);
  keyevent.m_keyCode = (long)'+';
  ProcessEvent(keyevent);
  event.Skip();
}

void Calculette::OnBoutonMoinsClick(wxCommandEvent& event)
{
  wxKeyEvent keyevent(wxEVT_CHAR);
  keyevent.m_keyCode = (long)'-';
  ProcessEvent(keyevent);
  event.Skip();
}

void Calculette::OnBoutonMultiplierClick(wxCommandEvent& event)
{
  wxKeyEvent keyevent(wxEVT_CHAR);
  keyevent.m_keyCode = (long)'*';
  ProcessEvent(keyevent);
  event.Skip();
}

void Calculette::OnBoutonDiviserClick(wxCommandEvent& event)
{
  wxKeyEvent keyevent(wxEVT_CHAR);
  keyevent.m_keyCode = (long)'/';
  ProcessEvent(keyevent);
  event.Skip();
}

void Calculette::OnBoutonPointClick(wxCommandEvent& event)
{
  wxKeyEvent keyevent(wxEVT_CHAR);
  keyevent.m_keyCode = (long)'.';
  ProcessEvent(keyevent);
  event.Skip();
}

void Calculette::OnBoutonEgalClick(wxCommandEvent& event)
{
  wxKeyEvent keyevent(wxEVT_CHAR);
  keyevent.m_keyCode = WXK_RETURN;
  ProcessEvent(keyevent);
  event.Skip();
}

void Calculette::RefreshTrigoValues()
{
  double angle = 0;
  SVGUIRotatingCtrl* rotatingctrl = (SVGUIRotatingCtrl*)GetElementByName(wxT("cercle_trigo"));
  if (rotatingctrl)
    angle = rotatingctrl->GetAngle();
  SVGUITextCtrl* costext = (SVGUITextCtrl*)GetElementByName(wxT("costext"));
  if (costext)
    costext->SetValue(wxString::Format(wxT("%.2f"), cos(angle*pi/180.0)));
  SVGUITextCtrl* sintext = (SVGUITextCtrl*)GetElementByName(wxT("sintext"));
  if (sintext)
    sintext->SetValue(wxString::Format(wxT("%.2f"), sin(angle*pi/180.0)));
  SVGUITextCtrl* tantext = (SVGUITextCtrl*)GetElementByName(wxT("tantext"));
  if (tantext)
    tantext->SetValue(wxString::Format(wxT("%.2f"), tan(angle*pi/180.0)));
  SVGUITextCtrl* angletext = (SVGUITextCtrl*)GetElementByName(wxT("angletext"));
  if (angletext)
    angletext->SetValue(wxString::Format(wxT("%.2f"), angle));
}

void Calculette::OnBoutonCosClick(wxCommandEvent& event)
{
  SVGUITextCtrl* costext = (SVGUITextCtrl*)GetElementByName(wxT("costext"));
  if (costext)
  {
    wxString value = costext->GetValue();
    SetNombreValue(value);
  }
}

void Calculette::OnBoutonSinClick(wxCommandEvent& event)
{
  SVGUITextCtrl* sintext = (SVGUITextCtrl*)GetElementByName(wxT("sintext"));
  if (sintext)
  {
    wxString value = sintext->GetValue();
    SetNombreValue(value);
  }
}

void Calculette::OnBoutonTanClick(wxCommandEvent& event)
{
  SVGUITextCtrl* tantext = (SVGUITextCtrl*)GetElementByName(wxT("tantext"));
  if (tantext)
  {
    wxString value = tantext->GetValue();
    SetNombreValue(value);
  }
}

void Calculette::OnBoutonAnglePlusClick(wxCommandEvent& event)
{
  SVGUIRotatingCtrl* rotatingctrl = (SVGUIRotatingCtrl*)GetElementByName(wxT("cercle_trigo"));
  if (rotatingctrl)
    rotatingctrl->Rotate(10);
  RefreshTrigoValues();
}

void Calculette::OnBoutonAngleMoinsClick(wxCommandEvent& event)
{
  SVGUIRotatingCtrl* rotatingctrl = (SVGUIRotatingCtrl*)GetElementByName(wxT("cercle_trigo"));
  if (rotatingctrl)
    rotatingctrl->Rotate(-10);
  RefreshTrigoValues();
}

void Calculette::OnCercleTrigoChanged(wxScrollEvent& event)
{
  RefreshTrigoValues();
}

