/*
 *========================================================================
 * $Id: uptime.c 88 2004-09-28 22:49:38Z rgb $
 *
 * See copyright in copyright.h and the accompanying file COPYING
 *========================================================================
 */

#include <wulfware/libwulf.h>

/*
 * <uptime> tag init and update (same thing)
 */
void init_uptime(Host *hostptr)
{

 /* 
  * scratch: current timestamp and delta (to microsecond resolution) 
  */
 unsigned long seconds,useconds;

 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: Starting init_update().  Use -v %d to focus.\n",D_VALUES);
   
 }

 /* 
  * uptime - tv_sec and tv_usec timestamps.
  */
 /* <uptime tv_sec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&seconds,value_xpath[UPTIME],
                      "tv_sec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[UPTIME]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: seconds = %d\n",seconds);
 }
 hostptr->val.uptime_tv_sec = seconds;

 /* <uptime tv_usec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&useconds,value_xpath[UPTIME],
                      "tv_usec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[UPTIME]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: useconds = %d\n",useconds);
 }
 hostptr->val.uptime_tv_usec = useconds;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: uptime_tv_sec = %ul uptime_tv_usec = %ul\n",hostptr->val.uptime_tv_sec,hostptr->val.uptime_tv_usec);
 }

 /*
  * We need both components of uptime
  */
 /* uptime up time */
 if(xtract(DOUBLE,&hostptr->val.uptime_up,value_xpath[UPTIME_UP],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",value_xpath[UPTIME_UP]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: uptime_up = %d\n",hostptr->val.uptime_up);
 }
 /* uptime idle time */
 if(xtract(DOUBLE,&hostptr->val.uptime_idle,value_xpath[UPTIME_IDLE],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",value_xpath[UPTIME_IDLE]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: uptime_idle = %d\n",hostptr->val.uptime_idle);
 }

 /* and we need to convert this into an uptime string */
 make_uptime(hostptr->val.uptime_up,hostptr->val.uptime);

 /* and (very useful!) a "duty cycle efficiency" */
 hostptr->val.duty_cycle = 100.0*(hostptr->val.uptime_up - hostptr->val.uptime_idle)/hostptr->val.uptime_up;

}


void update_uptime(Host *hostptr)
{

 /* 
  * scratch: current timestamp and delta (to microsecond resolution) 
  */
 unsigned long seconds,useconds;

 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: Starting init_uptime().  Use -v %d to focus.\n",D_VALUES);
   
 }

 /* 
  * uptime - tv_sec and tv_usec timestamps.
  */
 /* <uptime tv_sec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&seconds,value_xpath[UPTIME],
                      "tv_sec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[UPTIME]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: seconds = %d\n",seconds);
 }
 hostptr->val.uptime_tv_sec = seconds;

 /* <uptime tv_usec=?> */
 if(xtract_attribute(UNSIGNED_LONG,&useconds,value_xpath[UPTIME],
                      "tv_usec",hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",
         value_xpath[UPTIME]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: useconds = %d\n",useconds);
 }
 hostptr->val.uptime_tv_usec = useconds;
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: uptime_tv_sec = %ul uptime_tv_usec = %ul\n",hostptr->val.uptime_tv_sec,hostptr->val.uptime_tv_usec);
 }

 /*
  * We need both components of uptime
  */
 /* uptime up time */
 if(xtract(DOUBLE,&hostptr->val.uptime_up,value_xpath[UPTIME_UP],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",value_xpath[UPTIME_UP]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: uptime_up = %d\n",hostptr->val.uptime_up);
 }
 /* uptime idle time */
 if(xtract(DOUBLE,&hostptr->val.uptime_idle,value_xpath[UPTIME_IDLE],hostptr->xp_doc) > 1){
   fprintf(OUTFP,"fill_values() Warning: %s not unique content tag.\n",value_xpath[UPTIME_IDLE]);
 }
 if((verbose == D_ALL) || (verbose == D_VALUES)){
   fprintf(OUTFP,"D_VALUES: uptime_idle = %d\n",hostptr->val.uptime_idle);
 }

 /* and we need to convert this into an uptime string */
 make_uptime(hostptr->val.uptime_up,hostptr->val.uptime);

 /* and (very useful!) a "duty cycle efficiency" */
 hostptr->val.duty_cycle = 100.0*(hostptr->val.uptime_up - hostptr->val.uptime_idle)/hostptr->val.uptime_up;

}
