/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "JT6MProtocolPreferences.h"

const int BORDER_SIZE = 5;

CJT6MProtocolPreferences::CJT6MProtocolPreferences(wxWindow* parent, int id, int minLength) :
wxPanel(parent, id),
m_length(NULL)
{
	wxFlexGridSizer* sizer = new wxFlexGridSizer(2);

	wxStaticText* lengthLabel = new wxStaticText(this, -1, wxT("Length x 10ms"));
	sizer->Add(lengthLabel, 0, wxTOP, BORDER_SIZE);

	m_length = new wxSpinCtrl(this, -1);
	m_length->SetValue(minLength);
	m_length->SetRange(0, 100);
	sizer->Add(m_length, 0, wxALL, BORDER_SIZE);

	SetAutoLayout(true);

	sizer->Fit(this);
	sizer->SetSizeHints(this);

	SetSizer(sizer);
}

CJT6MProtocolPreferences::~CJT6MProtocolPreferences()
{
}

int CJT6MProtocolPreferences::getMinLength() const
{
	wxASSERT(m_length != NULL);

	return m_length->GetValue();
}
