/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	JT6MApp_H
#define	JT6MApp_H

#include <wx/wx.h>

#include "JT6MFrame.h"
#include "JT6MController.h"
#include "JT6MLevels.h"
#include "JT6MMessage.h"
#include "JT6MFileReceive.h"

#include "common/Text.h"
#include "common/Receive.h"

class CJT6MApp : public wxApp {

    public:
	CJT6MApp();
	virtual ~CJT6MApp();

	virtual bool OnInit();
	virtual int  OnExit();
	
	// This is overridden because dialog boxes from threads are bad news
#ifdef __WXDEBUG__
	virtual void OnAssert(const wxChar* file, int line, const wxChar* cond, const wxChar* msg);
#endif

	virtual void receiveMessage(CJT6MMessage* message, EWho who) const;
	virtual void showLevels(CJT6MLevels* levels, EWho who) const;
	virtual void showAudio(double audio, EWho who) const;

	virtual void error(const wxString& text) const;

	virtual bool     getTXFirst() const;
	virtual void     setTXFirst(bool first) const;
	virtual bool     getTXEnable() const;
	virtual void     setTXEnable(bool enabled);
	
	virtual int      getMinLength() const;
	virtual void     setMinLength(int length) const;

	virtual void     getPersonal(wxString& callsign, wxString& locator) const;
	virtual void     setPersonal(const wxString& callsign, const wxString& locator) const;
	virtual void     getPTT(wxString& type, wxString& device) const;
	virtual void     setPTT(const wxString& type, const wxString& device) const;
	virtual void     getSound(wxString& fileName) const;
	virtual void     setSound(const wxString& fileName) const;
	virtual wxString getReplacedMessage(int n) const;
	virtual wxString getOriginalMessage(int n) const;
	virtual void     setMessage(int n, const wxString& message);
	virtual void     getMessage(int n, wxString& message) const;
	virtual void     getPaths(wxString& audioPath, wxString& textPath) const;
	virtual void     setPaths(const wxString& audioPath, const wxString& textPath) const;

	virtual void     setRemote(const wxString& callsign, const wxString& locator);
	virtual void     setRecording(bool recording);
	virtual void     sendMessage(const wxString& message);
	virtual void     readFile(const wxString& fileName);

	virtual void     setSaving(bool saving);
	virtual void     logMessage(const CJT6MMessage& message) const;
	virtual void     deleteMessages() const;

    private:
	CJT6MFrame*       m_frame;
	CJT6MController*  m_controller;
	CText**           m_messages;
	CJT6MFileReceive* m_file;
	bool              m_saving;
	bool              m_recording;
	bool              m_txEnable;

	void createController();
	void createFileReader();
	void readRegistry();
};

DECLARE_APP(CJT6MApp)

#endif
