/*
 *   Copyright (C) 2002-2004 by Jonathan Naylor G4KLX
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef	Controller_H
#define	Controller_H

#include <wx/thread.h>

#include "Send.h"
#include "Receive.h"
#include "SoundDev.h"
#include "PTTPort.h"

class CController : public wxThread {

    public:
	CController(ISoundDev* soundDev, CPTTPort* pttPort);
	virtual ~CController();

	virtual void setTXEnable(bool enable);
	virtual void setTXFirst(bool first);
	virtual void setRXRecording(bool record);
	virtual void sendMessage(const wxString& message);

	virtual void* Entry();

	virtual int  waitForNextPeriod();
	virtual void waitTime(int seconds);

	virtual CSend*    createSendThread(const wxString& name, ISoundDev* soundDev, CPTTPort* pttPort) = 0;
	virtual CReceive* createReceiveThread(const wxString& name, ISoundDev* soundDev, EWho who) = 0;

	virtual void setLocal();

    protected:
	CReceive* getReceive1();
	CReceive* getReceive2();
	CSend*    getSend();

	wxMutex&  getMutex();

    private:
	ISoundDev* m_soundDev;
	CPTTPort*  m_pttPort;
	CReceive*  m_receive1;
	CReceive*  m_receive2;
	CSend*     m_send;
	wxString   m_message;
	bool       m_txFirst;
	bool       m_txEnable;
	bool       m_record;
	wxMutex    m_mutex;
};

#endif
