/* TextRunStyle: Stores (and writes) paragraph/span-style-based information 
 * (e.g.: a paragraph might be bold) that is needed at the head of an OO 
 * document.
 *
 * Copyright (C) 2002-2003 William Lachance (william.lachance@sympatico.ca)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * For further information visit http://libwpd.sourceforge.net
 *
 */

/* "This product is not manufactured, approved, or supported by 
 * Corel Corporation or Corel Corporation Limited."
 */

#ifndef _TEXTRUNSTYLE_H
#define _TEXTRUNSTYLE_H
#include <libwpd/libwpd.h>
#include <gsf/gsf-utils.h>
#include <gsf/gsf-output-stdio.h>
#include <gsf/gsf-outfile.h>

#include "Style.h"
class TagOpenElement;
class DocumentElement;

class TextRunStyle : public Style
{
public:
	TextRunStyle(const guint32 iTextAttributeBits, const gchar *pFontName, const float fFontSize, const gchar *psName);	
	virtual ~TextRunStyle();

	const int getTextAttributeBits() const { return miTextAttributeBits; }
	const virtual bool isParagraphStyle() const { return false; }
	const virtual bool isSectionBreak() const { return false; }

protected:
	const UTF8String & getFontName() const { return msFontName; }
	const float getFontSize() const { return mfFontSize; }
	void _addTextProperties(TagOpenElement *pStylePropertiesOpenElement) const;
	#if 0
	void writeBegin(GsfOutput *pOutput, const char *psFamily) const;
	void writeEnd(GsfOutput *pOutput) const;
	#endif

	int miTextAttributeBits;
 private:
	UTF8String msFontName;
	float mfFontSize;
};

class SpanStyle : public TextRunStyle
{
 public:
	SpanStyle(const guint32 iTextAttributeBits, const gchar *pFontName, const float fFontSize, const gchar *psName) : TextRunStyle(iTextAttributeBits, pFontName, fFontSize, psName) {}
	virtual void write(GsfOutput *pOutput) const;
};

class ParagraphStyle : public TextRunStyle, public TopLevelElementStyle
{
public:
	ParagraphStyle(const guint8 iParagraphJustification, const guint32 iTextAttributeBits,
		       const float fMarginLeft, const float fMarginRight, 		       
		       const gchar *pFontName, const float fFontSize,
		       const float fLineSpacing,
		       const bool bColumnBreak, const bool bPageBreak, 
		       const gchar *psName, const gchar *psParentName);

	virtual ~ParagraphStyle();

	void setListStyleName(UTF8String &sListStyleName) { mpsListStyleName = new UTF8String(sListStyleName); }
	virtual void write(GsfOutput *pOutput) const;
	const virtual bool isParagraphStyle() const { return true; }
	
private:
	GString *mpsParentName;
	UTF8String *mpsListStyleName;
	float mfMarginLeft;
	float mfMarginRight;
	float mfLineSpacing;
	guint8 miParagraphJustification;
	bool mbColumnBreak;
	bool mbPageBreak;
};
#endif
