/* opentabmenuop.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2018 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "opentabmenuop.hh"
#include "listermode.h"
#include "worker_locale.h"
#include "worker.h"

const char *OpenTabMenuOp::name = "OpenTabMenuOp";

OpenTabMenuOp::OpenTabMenuOp() : FunctionProto()
{
}

OpenTabMenuOp::~OpenTabMenuOp()
{
}

OpenTabMenuOp *OpenTabMenuOp::duplicate() const
{
    OpenTabMenuOp *ta = new OpenTabMenuOp();
    return ta;
}

bool OpenTabMenuOp::isName(const char *str)
{
    if ( strcmp( str, name ) == 0 )
        return true;
    else
        return false;
}

const char *OpenTabMenuOp::getName()
{
    return name;
}

int OpenTabMenuOp::run( WPUContext *wpu, ActionMessage *msg )
{
    ListerMode *lm1;
    if ( msg->mode != msg->AM_MODE_DNDACTION ) {
        Lister *l1 = msg->getWorker()->getActiveLister();
        if ( l1 != NULL ) {
            lm1 = l1->getActiveMode();
            if ( lm1 != NULL ) {
                lm1->runCommand( "open_current_tab_menu" );
            }
        }
    }
    return 0;
}

const char *OpenTabMenuOp::getDescription()
{
    return catalog.getLocaleCom( 69 );
}
