/* changesymlinkop.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: changesymlinkop.cc,v 1.9 2004/03/18 07:05:27 ralf Exp $ */

#include "changesymlinkop.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"

const char *ChangeSymlinkOp::name="ChangeSymlinkOp";

ChangeSymlinkOp::ChangeSymlinkOp() : FunctionProto()
{
}

ChangeSymlinkOp::~ChangeSymlinkOp()
{
}

ChangeSymlinkOp*
ChangeSymlinkOp::duplicate() const
{
  ChangeSymlinkOp *ta=new ChangeSymlinkOp();
  return ta;
}

bool
ChangeSymlinkOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *
ChangeSymlinkOp::getName()
{
  return name;
}

int
ChangeSymlinkOp::run(ActionMessage *msg)
{
  ListerMode *lm1;
  am=msg;
  if(msg->mode!=msg->AM_MODE_DNDACTION) {
    Lister *l1 = msg->getWorker()->getActiveLister();
    if(l1!=NULL) {
      startlister=l1;
      lm1=startlister->getActiveMode();
      if(lm1!=NULL)
        if(lm1->isType("NormalMode")==true)
          normalmodechangesl();
    }
  }
  return 0;
}

const char *
ChangeSymlinkOp::getDescription()
{
  return catalog.getLocaleCom(37);
}

int
ChangeSymlinkOp::normalmodechangesl()
{
  NormalMode *nm1=NULL;
  ListerMode *lm1=NULL;
  struct NM_specialsource *specialsource=NULL;
  struct NM_changesymlinkorder chslorder;
  
  if(startlister==NULL) return 1;
  lm1=startlister->getActiveMode();
  if(lm1==NULL) return 1;
  if(lm1->isType("NormalMode")!=true) return 1;
  nm1=(NormalMode*)lm1;

  memset( &chslorder, 0, sizeof( chslorder ) );
  if(am->mode==am->AM_MODE_ONLYACTIVE)
    chslorder.source=chslorder.NM_ONLYACTIVE;
  else if(am->mode==am->AM_MODE_DNDACTION) {
    // insert DND-element into list
    chslorder.source=chslorder.NM_SPECIAL;
    chslorder.sources=new List;
    specialsource=(struct NM_specialsource*)_allocsafe(sizeof(struct NM_specialsource));
    specialsource->entry=NULL;
    specialsource->row=-1;
    //TODO: specialsource nach am besetzen (je nachdem wir ich das realisiere)
    chslorder.sources->addElement(specialsource);
  } else if(am->mode==am->AM_MODE_SPECIAL) {
    chslorder.source=chslorder.NM_SPECIAL;
    chslorder.sources=new List;
    specialsource=(struct NM_specialsource*)_allocsafe(sizeof(struct NM_specialsource));
    specialsource->entry=(FileEntry*)am->extraInfo;
    specialsource->row=-1;
    chslorder.sources->addElement(specialsource);
  } else
    chslorder.source=chslorder.NM_ALLENTRIES;

  nm1->changesymlink(&chslorder);
  if(chslorder.source==chslorder.NM_SPECIAL) {
    if(specialsource!=NULL) _freesafe(specialsource);
    delete chslorder.sources;
  }
  return 0;
}

