/* condvar.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2002-2004 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: condvar.cc,v 1.3 2004/03/18 06:58:54 ralf Exp $ */

#include "condvar.h"

CondVar::CondVar():MutEx()
{
}

CondVar::~CondVar()
{
}

void CondVar::wait()
{
#ifdef WANT_THREADS
  int oldcount;
  
  pthread_mutex_lock( &dmutex );
  if ( ( owncount > 0 ) && ( owner == pthread_self() ) ) {
    oldcount = owncount;
    owncount = 0;
    owner = 0;
    pthread_mutex_unlock( &dmutex );

    // now this lock is marked as free but no one get the lock for "mutex"
    // until I call wait

#ifdef THREAD_DEBUG
    printf("(%d,%p)::wait %d\n",pthread_self(),this,oldcount);
#endif

    pthread_cond_wait( &condvar, &mutex );

    // I have the lock for "mutex" again

#ifdef THREAD_DEBUG
    printf("(%d)::wait end\n",pthread_self());
#endif

    // now enter me again as owner

    pthread_mutex_lock( &dmutex );

#ifdef THREAD_DEBUG
    printf("(%d)::wait lock ok\n",pthread_self());
#endif

    owner = pthread_self();
    owncount = oldcount;
  }
  pthread_mutex_unlock( &dmutex );
#endif
}

void CondVar::signal()
{
#ifdef WANT_THREADS
  pthread_cond_signal( &condvar );
#endif

#ifdef THREAD_DEBUG
  printf("(%d,%p)signal::count %d\n",pthread_self(),this,owncount);
#endif
}

void CondVar::bcast()
{
#ifdef WANT_THREADS
  pthread_cond_broadcast( &condvar );
#endif
}

void CondVar::lock()
{
#ifdef WANT_THREADS
  bool amiowner;

  pthread_mutex_lock( &dmutex );
  if ( ( owncount > 0 ) && ( owner == pthread_self() ) )
    amiowner = true;
  else
    amiowner = false;
  
  if ( amiowner == true ) {
    owncount++;
  } else {
    pthread_mutex_unlock( &dmutex );
    
    // now I'm sure I'm not the owner
    // so try to get the lock
    
    pthread_mutex_lock( &mutex );
    
    // got lock so enter me as owner
    pthread_mutex_lock( &dmutex );
    owner = pthread_self();
    owncount = 1;
  }
  pthread_mutex_unlock( &dmutex );  
#endif
}

void CondVar::unlock()
{
#ifdef WANT_THREADS
  pthread_mutex_lock( &dmutex );
  
  if ( ( owncount > 0 ) && ( owner == pthread_self() ) ) {
    owncount--;
    
    if ( owncount == 0 ) {
      pthread_mutex_unlock( &mutex );
      owner = 0;
    }
  } else {
    // not owner
  }
  
  pthread_mutex_unlock( &dmutex );  
#endif
}

