/* aguix.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2004 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: aguix.h,v 1.46 2004/03/18 06:57:28 ralf Exp $ */

#ifndef AGUIX_H
#define AGUIX_H

#include "aguixdefs.h"
#include "lowlevelfunc.h"
#include "message.h"
#include "util.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/keysym.h>
#include <X11/cursorfont.h>
#include <X11/Xatom.h>

class AWindow;
class AGUIXFont;

enum {MES_WAIT,MES_GET};
enum {NON_GADGET,CLOSE_GADGET,BUTTON_GADGET,SHADOW_GADGET,CHOOSE_GADGET,LISTVIEW,ONELVC,MORELVC,STRING_GADGET};

class AGUIX {
public:
  AGUIX();
  ~AGUIX();
  AGUIX( const AGUIX &other );
  AGUIX &operator=( const AGUIX &other );

  int initX( int argc, char **argv, const char *classname );
  int checkX();
  void closeX();
  int getDepth() const;
  Colormap getColormap() const;
  Display *getDisplay() const;
  int getScreen() const;
  void panic(const char *);
  void setFG(int color);
  void setBG(int color);
  void setFG(GC gc,int color);
  void setBG(GC gc,int color);
  int getCharHeight() const;
  int getCharWidth() const;
  void FillRectangle(Drawable buffer,int x,int y,int w,int h);
  void DrawText(Drawable buffer,const char *text,int x,int y);
  void DrawLine(Drawable buffer,int px1,int py1,int px2,int py2);
  void DrawPoint(Drawable buffer,int x,int y);
  void FillRectangle(Drawable buffer,GC gc,int x,int y,int w,int h);
  void DrawText(Drawable buffer,AGUIXFont *,const char *text,int x,int y);
  void DrawLine(Drawable buffer,GC gc,int px1,int py1,int px2,int py2);
  void DrawPoint(Drawable buffer,GC gc,int x,int y);

  void DrawTriangleFilled(Drawable buffer, int px1, int py1, int px2, int py2, int px3, int py3);
  void DrawTriangleFilled(Drawable buffer, GC tgc, int px1, int py1, int px2, int py2, int px3, int py3);

  void ClearWin(Window win);
  void SetWindowBG(Window win,int color);
  int getFontBaseline() const;
  int AddColor(int red,int green,int blue);
  void removeLastColor();
  int changeColor(int,int,int,int);
  int getMaxCols() const;
  unsigned long getPixel(int color) const;
  char *getClassname() const;
  Atom *getCloseAtom();
  void insertWindow(AWindow *win);
  void removeWindow(AWindow *win);
  AGMessage *GetMessage(AWindow *parent);
  AGMessage *WaitMessage(AWindow *parent);
  void ReplyMessage(AGMessage *);
  Message *wait4mess( int mode );
  void copyArea(Drawable source,Drawable dest,int s_x,int s_y,int width,int height,int d_x,int d_y);
  void Flush();
  int getargc() const;
  char **getargv() const;
  void putAGMsg(AGMessage *msg);
  AGMessage *getAGMsg();
  void WindowtoFront(Window);
  void WindowtoBack(Window);
  AGUIXFont *getFont( const char* );
  int setFont( const char* );
  void ExposeHandler(Message*);
  AWindow *findAWindow(Window);
  char *getNameOfKey(KeySym,unsigned int) const;
  Window getGroupWin() const;
  int queryPointer(Window win,int *x,int *y);
  int queryRootPointer(int *x,int *y);
  int queryPointer(Window win,int *x,int *y,unsigned int *buttons);
  void setCursor(Window win,int type);
  void unsetCursor(Window win);

  enum {WAIT_CURSOR=0,SCROLLH_CURSOR,SCROLLV_CURSOR,MAXCURSORS};
  int startCut(GUIElement *elem,const char *buffer);
  void cancelCut();
  int startPaste(GUIElement *elem);
  bool amiOwner() const;
  const char *getCutBuffer() const;
  void requestCut(Window win);
  void cancelCutPaste(GUIElement *elem);
  bool isDoubleClick(struct timeval *t1,struct timeval *t2) const;
  bool isDoubleClick( Time t1, Time t2 ) const;

  static int scaleElementsW( int wantedWidth,
			     int borderwidth,
			     int minSpace,
			     int maxSpace,
			     bool allowShrink,
			     bool allowStretch,
			     GUIElement **elem,
			     int *minWidths,
			     int nr );
  static int centerElementsY( GUIElement *element,
			      GUIElement *center2element );
  int getRootWindowWidth() const;
  int getRootWindowHeight() const;

  Pixmap createPixmap( Drawable d, int width, int height );
  void freePixmap( Pixmap p );

  void DrawDottedLine( Drawable buffer, int px1, int py1, int px2, int py2 );
  void DrawDottedRectangle( Drawable buffer, int x, int y, int w, int h );
  void setDottedFG( int color );

  void DrawDashXorLine( Drawable buffer, int px1, int py1, int px2, int py2 );
  void DrawDashXorRectangle( Drawable buffer, int x, int y, int w, int h );
  
  void DrawDashDLine( Drawable buffer, int px1, int py1, int px2, int py2 );
  void DrawDashDRectangle( Drawable buffer, int x, int y, int w, int h );
  void setDashDFG( int color );
  void setDashDBG( int color );

  static bool isModifier( KeySym key );
  static char *getStringForKeySym( KeySym key );
  static KeySym getKeySymForString( const char *str1 );
  void rebuildBackgroundPixmap();
  void setWindowBackgroundPixmap( Window win );
  void doXMsgs( AWindow *parent, bool onlyexpose );
  void doXMsgs( int mode, AWindow *parent, bool onlyexpose );
  bool noMoreMessages() const;
#ifdef USE_XIM
  XIMStyle getXIMStyle() const;
  XIM getXIM() const;
  void IMInstCallback( Display *calldsp );
  void IMDestCallback();
#endif
  void setTransientWindow( AWindow *twin = NULL );
  const AWindow* getTransientWindow() const;
  int addDefaultColors();
  KeySym getLastKeyRelease();
  unsigned int getLastMouseRelease();
  void msgLock( GUIElement *e );
  void msgUnlock( const GUIElement *e );
  void enableTimer();
  void disableTimer();

  static long timerEvent;
private:
  Display *dsp;
  int scr;
  Colormap cmap;
  GC gc, dotted_gc, dashxor_gc, dashdouble_gc;
  Atom WM_delete_window;
  char *classname;
  unsigned long white,black;
  XFontStruct *myfont;
  AGUIXFont *mainfont;
  int initOK;
  int argc;
  char **argv;
  int CharHeight;
  int CharWidth;
  unsigned long ColBuf[256];
  int colors;
  XEvent LastEvent;
  List *wins;
  List *messages;
  List *fonts;
  Window groupwin;
  void createGroupWin();
  void destroyGroupWin();
  
  bool ReactMessage(Message*,AWindow*);
  void buildAGMessage( Message *agmsg );
  
  bool privatecmap;
  void changeColormap();

  Cursor cursors[MAXCURSORS];
  GUIElement *cutstart,*pastestart;
  char *cutbuffer;

  unsigned int rootWindowWidth, rootWindowHeight;
  Pixmap backpm;
#ifdef USE_XIM
  XIM inputmethod;
  XIMStyle im_style;

  int openIM();
  void closeIM();
#endif
  char *keybuf;
  int keybuf_len;

  AWindow *transientwindow;
  KeySym lastkeyrelease;
  unsigned int lastmouserelease;

  GUIElement *msgLockElement;
  bool timerEnabled;
#ifndef USE_AGUIXTIMER
  struct timeval timerStart;
#endif
  int msgHandler( int mode, AWindow *parent, bool onlyExpose );
  enum { TIMER_TICKS = 25 }; //HARDCODED
  long lastTimerEventNr;
};

class AGUIXFont
{
public:
  AGUIXFont(AGUIX*);
  ~AGUIXFont();
  AGUIXFont( const AGUIXFont &other );
  AGUIXFont &operator=( const AGUIXFont &other );

  int setFont( const char* );
  void removeFont();
  GC getGC() const;
  const char *getName() const;
  int getCharHeight() const;
  int getCharWidth() const;
  int getBaseline() const;
  XFontStruct *getFontStruct() const;
private:
  char *name;
  GC gc;
  AGUIX *aguix;
  XFontStruct *font;
  int charWidth,charHeight;
};

#endif
