/* xliwrapper_worker.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: xliwrapper_worker.cc,v 1.7 2002/09/01 15:56:59 ralf Exp $ */

#include "wdefines.h"
#include <aguix/util.h>
#include <aguix/lowlevelfunc.h>

#define XLISTR "xli -quiet -border %s -clip %d,%d,%d,%d -zoom %d -windowid 0x%s '%s'"

bool fileExists(const char *name)
{
  struct stat stbuf;
  if(lstat(name,&stbuf)!=0) return false;
  return true;
}

char *createTMPName()
{
  char *returnstr,buffer[ A_BYTESFORNUMBER( int ) ];
  int rannr;
  
  for(;;) {
    rannr=rand();
    sprintf(buffer,"%d",rannr);
    returnstr=(char*)_allocsafe(strlen("/tmp/worker")+strlen(buffer)+1);
    sprintf(returnstr,"/tmp/worker%s",buffer);
    if(fileExists(returnstr)==false) break;
    _freesafe(returnstr);
  }
  return returnstr;
}

int main(int argc,char **argv)
{
  char *tstr,*tmp, *sqname;
  int ch,wi,he,mode;
  int aw,ah,ax,ay,xzf,yzf,zf;
  int tx,ty,tw,th;
  
  FILE *fp;
  
  srand(time(NULL));  
  if(argc<8) {
    printf("This is the xliwrapper_worker program. It belongs to the worker filemanager.\n");
    printf("  This is not a standalone program but will normally called from\n  worker to display pics in it.\n");
    printf("  The arguments are:\n");
    printf("  1.x-coord.\n  2.y-coord.\n  3.width of the area\n  4.height of the area\n  5.hex-number of the window\n");
    printf("  6.the filename to show\n  7.the background color in X11-format\n\n");
  } else {
    sqname = AGUIX_prepareForSingleQuote( argv[6] );
    tmp=createTMPName();
    tstr = (char*)_allocsafe( strlen( "xli -identify '' > 2>/dev/null") + strlen( sqname ) + strlen( tmp ) + 1 + 128 );
    sprintf( tstr, "xli -identify  '%s' >%s 2>/dev/null", sqname, tmp );
    system(tstr);
    _freesafe(tstr);

    fp=fopen(tmp,"r");
    if(fp!=NULL) {
      wi=he=0;
      mode=0;
      for(;;) {
        ch=getc(fp);
        if(ch==EOF) break;
        switch(mode) {
          case 1://i
            if(ch=='s') mode=2;
            else if(ch!='i') mode=0;
            break;
          case 2://s
            if(ch==' ') mode=3;
            else if(ch=='i') mode=1;
            else mode=0;
            break;
          case 3://<space>
            if(ch=='a') mode=4;
            else if(ch=='i') mode=1;
            else mode=0;
            break;
          case 4://a
            if(ch==' ') mode=5;
            else if(ch=='i') mode=1;
            else mode=0;
            break;
          case 5:// now follows the widthxheight
            if(isdigit(ch)) {
              wi*=10;
              wi+=ch-'0';
            } else if(ch=='x') mode=6;
            else mode=7;
            break;
          case 6:
            if(isdigit(ch)) {
              he*=10;
              he+=ch-'0';
            } else mode=7;
            break;
          case 7:
            break;
          default:
            if(ch=='i') mode=1;
            break;
        }
        if(mode==7) break;
      }
      fclose(fp);

      if((wi>0)&&(he>0)) {
        // valid width and height
        ax=atoi(argv[1]);
        ay=atoi(argv[2]);
        aw=atoi(argv[3]);
        ah=atoi(argv[4]);
        
        xzf=aw*100/wi;
        yzf=ah*100/he;
        zf=(xzf>yzf)?yzf:xzf;
        if(zf<1) zf=1;
        
        tx=ax*100/zf;
        ty=ay*100/zf;
        tw=aw*100/zf;
        tw++;
        th=ah*100/zf;
        th++;
        
        tstr = (char*)_allocsafe( strlen( XLISTR ) +
                                  5 * A_BYTESFORNUMBER( int ) +
                                  strlen( argv[ 5 ] ) +
                                  strlen( sqname ) +
                                  strlen( argv[ 7 ] ) + 1 + 128 );
        sprintf( tstr, XLISTR, argv[7], tx, ty, tw, th, zf, argv[5], sqname );
        system(tstr);
        _freesafe(tstr);
      }
    }
    
    remove(tmp);
    _freesafe(tmp);
    _freesafe( sqname );
  }  
  return 0;
}

