/* informationmode.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: informationmode.h,v 1.8 2003/07/03 22:50:46 ralf Exp $ */

#ifndef INFORMATIONMODE_H
#define INFORMATIONMODE_H

#include "wdefines.h"
#include <aguix/aguix.h>
#include <aguix/message.h>
#include <aguix/fieldlistview.h>
#include <aguix/stringgadget.h>
#include <aguix/button.h>
#include <aguix/request.h>
#include <aguix/awindow.h>
#include "listermode.h"
#include "datei.h"
#include "normalmode.h"

class Lister;

class InformationMode:public ListerMode
{
public:
  InformationMode(Lister *);
  virtual ~InformationMode();
  virtual void messageHandler(AGMessage *);
  virtual void on();
  virtual void off();
  virtual void activate();
  virtual void deactivate();
  virtual bool isType(const char *);
  virtual const char *getType();
  virtual int configure();
  virtual void cyclicfunc(cyclicfunc_mode_t mode);
  virtual const char* getLocaleName();
  virtual int load();
  virtual int loadBin(Datei*);
  virtual bool save(Datei *);
  virtual void reconfig();
  
  static const char *getStaticLocaleName();
  static const char *getStaticType();
protected:
  void reconf(int,int,int,int);
  static const char *type;
  int x,y,w,h;
  void setName();
  FieldListView *lv;
  
  FileEntry *lastactivefe;
  
  void update(bool force);
  bool blanked;
  void showinfos();
  
  bool nospaceinfo;
};

#endif

