/* basic_actions.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: basic_actions.h,v 1.7 2003/05/04 00:34:34 ralf Exp $ */

#ifndef BASIC_ACTIONS_H
#define BASIC_ACTIONS_H

#include "wdefines.h"
#include "functionproto.h"

class DNDAction:public FunctionProto
{
public:
  DNDAction();
  virtual ~DNDAction();
  virtual DNDAction *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
  void normalmodedndaction();
};

class DoubleClickAction:public FunctionProto
{
public:
  DoubleClickAction();
  virtual ~DoubleClickAction();
  virtual DoubleClickAction *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
  void normalmodeddaction();
};

class ShowAction:public FunctionProto
{
public:
  ShowAction();
  virtual ~ShowAction();
  virtual ShowAction *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
  void normalmodeshow();
};

class RawShowAction:public FunctionProto
{
public:
  RawShowAction();
  virtual ~RawShowAction();
  virtual RawShowAction *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
protected:
  static const char *name;
  void normalmoderawshow();
};

class UserAction:public FunctionProto
{
public:
  UserAction();
  virtual ~UserAction();
  virtual UserAction *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual const char *getDescription();
  virtual bool save(Datei*);
  virtual int configure();
  int getNr() const;
  void setNr( int n );
protected:
  static const char *name;
  int nr;
  void normalmodeuseraction();
};

class ChangeHiddenFlag:public FunctionProto
{
public:
  ChangeHiddenFlag();
  virtual ~ChangeHiddenFlag();
  virtual ChangeHiddenFlag *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
  virtual int run(ActionMessage*);
  virtual bool save(Datei*);
  virtual const char *getDescription();
  virtual int configure();
  
  int getMode() const;
  void setMode( int m );
protected:
  static const char *name;
  int mode;
};

#endif
