/* request.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: request.h,v 1.13 2003/06/04 22:45:31 ralf Exp $ */

#ifndef AGUIX_REQUEST_H
#define AGUIX_REQUEST_H

#include "aguixdefs.h"

class Requester
{
public:
  Requester(class AGUIX *parent);
  Requester( class AGUIX *parent, class AWindow *twin );
  ~Requester();

  typedef enum { REQUEST_NONE = 0,
		 REQUEST_CURSORLEFT = 1,
		 REQUEST_CURSORRIGHT = 2,
		 REQUEST_SELECTALL = 3,
		 REQUEST_CANCELWITHLEFT = 4 } request_flags_t;

  int request(const char *title,const char *text,const char *buttons);
  int request(const char *title,const char *text,const char *buttons, request_flags_t flags);
  int request(const char *title,const char *text,const char *buttons, AWindow *twin, request_flags_t flags);
  int string_request( const char *title, const char *lines, const char *default_str, const char *buttons,char **return_str);
  int string_request( const char *title, const char *lines, const char *default_str, const char *buttons,char **return_str, request_flags_t flags );
  int string_request( const char *title, const char *lines, const char *default_str, const char *buttons,char **return_str, AWindow *twin, request_flags_t flags );
private:
  class AGUIX *aguix;
  AWindow *transientawin;
};

#endif
