/* fieldlistviewdnd.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2002 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: fieldlistviewdnd.cc,v 1.15 2004/01/22 21:18:56 ralf Exp $ */

#include "fieldlistviewdnd.h"
#include "awindow.h"
#include "guielement.h"

const char *FieldListViewDND::type="FieldListViewDND";

FieldListViewDND::~FieldListViewDND()
{
  removealldndtexts();
  delete dndtexts;
}

FieldListViewDND::FieldListViewDND( AGUIX *taguix,
				    int tx,
				    int ty,
				    int width,
				    int height,
				    int tdata ) : FieldListView( taguix,
								 tx,
								 ty,
								 width,
								 height,
								 tdata )
{
  dndtexts = new ArrayList();
  dndMode = DND_IDLE;
  dndtext = NULL;
}

void FieldListViewDND::handleSelect(Message *msg)
{
  int j;
  Window root, child;
  int root_x, root_y, win_x, win_y;
  unsigned int keys_buttons;
  int newelement;
  AGMessage *agmsg;
  
  if ( parent == NULL ) return;

  if ( dndMode != DND_IDLE ) {
    handleDND( msg );
    return;
  }
  if ( msg->type == ButtonPress ) {
    if ( msg->window != win ) return;
    if ( selectMode != SELECT_IDLE ) {
      if ( ( msg->button == Button3 ) &&
	   ( selectMode == SELECT_HOLD ) ){
	dndMode = DND_ACTIVE;

	XQueryPointer( aguix->getDisplay(),
		       win,
		       &root,
		       &child,
		       &root_x,
		       &root_y,
		       &win_x,
		       &win_y,
		       &keys_buttons );
	if ( isValidRow( clickLastSelectedRow ) == true ) {
	  colorclass_t ti;
	  
	  if ( clickLastSelectedRow == activerow ) {
	    if ( getSelect( clickLastSelectedRow ) == true )
	      ti = CC_SELACT;
	    else
	      ti = CC_ACTIVE;
	  } else {
	    if ( getSelect( clickLastSelectedRow ) == true )
	      ti = CC_SELECT;
	    else
	      ti = CC_NORMAL;
	  }
	  
	  char *tstr = (char*)dndtexts->getElementAt( clickLastSelectedRow );
	  if ( tstr == NULL ) tstr = dupstring( ( elementarray[ clickLastSelectedRow ]->getText( 0 ) ).c_str() );
	  else tstr = dupstring( tstr );

	  AGMessage *agmsg = AGUIX_allocAGMessage();
	  agmsg->dnd.element = this;
	  agmsg->dnd.specialinfo.voidP = NULL;
	  agmsg->dnd.specialinfo.value = clickLastSelectedRow;

	  FieldLVRowData *dp = getDataExt( clickLastSelectedRow );
	  if ( dp != NULL ) {
	    agmsg->dnd.specialinfo.rowDataP = dp->duplicate();
	  } else {
	    agmsg->dnd.specialinfo.rowDataP = NULL;
	  }
	  agmsg->dnd.window = NULL;
	  agmsg->dnd.relx = win_x;
	  agmsg->dnd.rely = win_y;
	  agmsg->type = AG_DND_START;
	  aguix->putAGMsg( agmsg );

	  dndtext = new DNDText( aguix,
				 tstr,
				 getFG( clickLastSelectedRow, ti ),
				 getBG( clickLastSelectedRow, ti),
				 font );
	  dndtext->create();
	  _freesafe( tstr );
	}
      }
      return;
    }

    j = getRowForMouseY( msg->mousey );
    if ( j < 0 ) return;
    if ( ( j + yoffset ) >= elements ) return;
    if ( j >= maxdisplayv ) return;

    clickLastSelectedRow = j + yoffset;
    clickState = ( getSelect( clickLastSelectedRow ) == false ) ? true : false;
    clickFirstSelectedRow = clickLastSelectedRow;
    clickSelected = 1;

    setSelect( clickLastSelectedRow, clickState );
    setActiveRow( clickLastSelectedRow );
    runSelectHandler( clickLastSelectedRow );
    
    selectMode = SELECT_HOLD;

    aguix->Flush();
    aguix->msgLock( this );
  } else if ( msg->type == MotionNotify ) {
    if ( ( msg->window == win ) &&
	 ( ( selectMode == SELECT_HOLD ) ||
	   ( selectMode == SELECT_SCROLL_DOWN ) ||
	   ( selectMode == SELECT_SCROLL_UP ) ) ) {
      //    aguix->queryPointer( win, &mx, &my );
      XQueryPointer( aguix->getDisplay(),
		     msg->window,
		     &root,
		     &child,
		     &root_x,
		     &root_y,
		     &win_x,
		     &win_y,
		     &keys_buttons );
      if ( ( keys_buttons & Button1Mask ) != 0 ) {
	j = getRowForMouseY( win_y );
	if ( ( j < 0 ) && ( yoffset > 0 ) ) {
	  newelement = yoffset - 1;
	  if ( newelement >= 0 ) {
	    if ( selectMode != SELECT_SCROLL_UP ) {
	      scrollV1( -1 );
	      clickSelected += selectRowsRange( clickLastSelectedRow, newelement, clickState );
	      clickLastSelectedRow = newelement;
	      selectMode = SELECT_SCROLL_UP;
	      aguix->enableTimer();
	    }
	  }
	} else if ( ( j >= maxdisplayv ) && ( ( yoffset + maxdisplayv ) < elements ) ) {
	  newelement = yoffset + maxdisplayv;
	  if ( newelement < elements ) {
	    if ( selectMode != SELECT_SCROLL_DOWN ) {
	      scrollV1( 1 );
	      clickSelected += selectRowsRange( clickLastSelectedRow, newelement, clickState );
	      clickLastSelectedRow = newelement;
	      selectMode = SELECT_SCROLL_DOWN;
	      aguix->enableTimer();
	    }
	  }
	} else {
	  if ( j < 0 ) j = 0;
	  if ( ( j + yoffset ) >= elements ) {
	    j = elements - 1 - yoffset;
	  }
	  if ( ( j + yoffset ) != clickLastSelectedRow ) {
	    newelement = j + yoffset;
	    clickSelected += selectRowsRange( clickLastSelectedRow, newelement, clickState );
	    clickLastSelectedRow = newelement;
	  }
	  if ( selectMode != SELECT_HOLD ) {
	    selectMode = SELECT_HOLD;
	    aguix->disableTimer();
	  }
	}
      }
    }
  } else if ( msg->type == ButtonRelease ) {
    if ( ( msg->window == win ) &&
	 ( msg->button == Button1 ) ) {
      switch ( selectMode ) {
	case SELECT_IGNORE:
	  aguix->msgUnlock( this );
	  selectMode = SELECT_IDLE;
	  break;
	case SELECT_SCROLL_UP:
	case SELECT_SCROLL_DOWN:
	  aguix->disableTimer();
	case SELECT_HOLD:
	  agmsg = AGUIX_allocAGMessage();
	  agmsg->fieldlv.lv = this;
	  agmsg->fieldlv.row = clickFirstSelectedRow;
	  agmsg->fieldlv.time = msg->time;
	  agmsg->fieldlv.mouse = true;
	  if ( clickSelected == 1 ) {
	    agmsg->type = AG_FIELDLV_ONESELECT;
	  } else {
	    agmsg->type = AG_FIELDLV_MULTISELECT;
	  }
	  aguix->putAGMsg( agmsg );
	  aguix->msgUnlock( this );
	  selectMode = SELECT_IDLE;
	  break;
	default:
	  break;
      }
    }
  } else if ( msg->type == ClientMessage ) {
    if ( msg->specialType == Message::TIMEREVENT ) {
      if ( ( msg->time % 1 ) == 0 ) { //HARDCODED
	if ( selectMode == SELECT_SCROLL_UP ) {
	  newelement = clickLastSelectedRow - 1;
	  if ( newelement >= 0 ) {
	    scrollV1( -1 );
	    clickSelected += selectRowsRange( clickLastSelectedRow, newelement, clickState );
	    clickLastSelectedRow = newelement;
	  }
	} else if ( selectMode == SELECT_SCROLL_DOWN ) {
	  newelement = clickLastSelectedRow + 1;
	  if ( newelement < elements ) {
	    scrollV1( 1 );
	    clickSelected += selectRowsRange( clickLastSelectedRow, newelement, clickState );
	    clickLastSelectedRow = newelement;
	  }
	}
	aguix->Flush();
      }
    }
  }
}

void FieldListViewDND::handleDND( Message *msg )
{
  int xw, yw, xr, yr;
  Window root, child, rroot;
  unsigned int keys_button;
  
  if ( parent == NULL ) return;

  if ( msg->type == ButtonPress ) {
    if ( ( dndMode == DND_ACTIVE ) &&
	 ( msg->button == Button3 ) ) {
      delete dndtext;
      dndtext = NULL;
      dndMode = DND_DEACTIVE;
    }
  } else if ( ( msg->type == MotionNotify ) ||
	      ( msg->type == Expose ) ) {
    if ( dndtext != NULL ) dndtext->handler( msg );
  } else if ( msg->type == ButtonRelease ) {
    if ( msg->button == Button1 ) {
      if ( dndtext != NULL ) {
	delete dndtext;
	dndtext = NULL;
      }
      Display *dsp=aguix->getDisplay();
      root=RootWindow(dsp,aguix->getScreen());
      for(;;) {
      XQueryPointer(dsp,root,&rroot,&child,&xr,&yr,&xw,&yw,&keys_button);
	if(child==0) break;
	root=child;
      }
      // Fenster finden, dass child enthaelt
      child=root;
      AWindow *awin=aguix->findAWindow(child);
      GUIElement *guiel=NULL;
      if(awin!=NULL) {
	guiel=awin->findGUIElement(child);
	if(guiel!=NULL) XQueryPointer(dsp,guiel->getWindow(),&root,&child,&xr,&yr,&xw,&yw,&keys_button);
      }
      AGMessage *agmsg = AGUIX_allocAGMessage();
      agmsg->dnd.element=guiel;
      agmsg->dnd.window=awin;
      agmsg->dnd.specialinfo.voidP = NULL;
      agmsg->dnd.specialinfo.value = 0;
      agmsg->dnd.specialinfo.rowDataP = NULL;
      agmsg->dnd.relx=xw;
      agmsg->dnd.rely=yw;
      if ( dndMode == DND_ACTIVE ) agmsg->type=AG_DND_END;
      else agmsg->type=AG_DND_CANCEL;
      aguix->putAGMsg(agmsg);

      switch ( selectMode ) {
	case SELECT_SCROLL_UP:
	case SELECT_SCROLL_DOWN:
	  aguix->disableTimer();
	case SELECT_HOLD:
	  setSelect( clickLastSelectedRow, false );
	  runSelectHandler( clickLastSelectedRow );
	  agmsg = AGUIX_allocAGMessage();
	  agmsg->fieldlv.lv = this;
	  agmsg->fieldlv.row = clickFirstSelectedRow;
	  agmsg->fieldlv.time = msg->time;
	  agmsg->fieldlv.mouse = true;
	  if ( clickSelected == 1 ) {
	    agmsg->type = AG_FIELDLV_ONESELECT;
	  } else {
	    agmsg->type = AG_FIELDLV_MULTISELECT;
	  }
	  aguix->putAGMsg( agmsg );
	  break;
	default:
	  break;
      }
      aguix->msgUnlock( this );
      selectMode = SELECT_IDLE;
      dndMode = DND_IDLE;
    }
  }
}

const char *FieldListViewDND::getType() const
{
  return type;
}

bool FieldListViewDND::isType(const char *qtype) const
{
  if(strcmp(type,qtype)==0) return true;
  return false;
}

void FieldListViewDND::removealldndtexts()
{
  int id=dndtexts->initEnum();
  char *tstr=(char*)dndtexts->getFirstElement(id);
  while(tstr!=NULL) {
    _freesafe(tstr);
    dndtexts->removeFirstElement();
    tstr=(char*)dndtexts->getFirstElement(id);
  }
  dndtexts->closeEnum(id);
}

void FieldListViewDND::removedndtextat(int index2)
{
  char *tstr=(char*)dndtexts->getElementAt(index2);
  dndtexts->removeElementAt(index2);
  if(tstr!=NULL) _freesafe(tstr);
}

void FieldListViewDND::replacedndtext(int index2,char *tstr)
{
  if((index2<0)||(index2>=dndtexts->size())) return;
  char *tstr2=(char*)dndtexts->exchangeElement(index2,dupstring(tstr));
  if(tstr2!=NULL) _freesafe(tstr2);
}

void FieldListViewDND::insertdndtext(int index2,char *tstr)
{
  dndtexts->addElementAt(index2,dupstring(tstr));
}

void FieldListViewDND::adddndtext(char *tstr)
{
  dndtexts->addElement(dupstring(tstr));
}

void FieldListViewDND::setSizeDNDText(int ns)
{
  int elems=dndtexts->size();
  char *tstr;
  while(elems<ns) {
    dndtexts->addElement(NULL);
    elems++;
  }
  while(elems>ns) {
    tstr=(char*)dndtexts->getElementAt(elems-1);
    dndtexts->removeElementAt(elems-1);
    elems--;
    if(tstr!=NULL) _freesafe(tstr);
  }
}
