/* cyclebutton.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001 Ralf Hoffmann.
 * You can contact me at: ralf.hoffmann@epost.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: cyclebutton.cc,v 1.17 2004/01/22 21:18:30 ralf Exp $ */

#include "cyclebutton.h"
#include "awindow.h"
#include "guielement.h"

const char *CycleButton::type="CycleButton";

CycleButton::~CycleButton()
{
  char *tstr=(char*)options->getFirstElement();
  while(tstr!=NULL) {
    _freesafe(tstr);
    tstr=(char*)options->getNextElement();
  }
  delete options;
}

CycleButton::CycleButton(AGUIX *taguix):GUIElement(taguix)
{
  this->data=0;
  this->state=0;
  this->instate=0;
  this->fg=1;
  this->bg=0;
  lastbg=-1;
  font=NULL;
  options=new List();
  act_opt=-1;
  canHandleFocus = true;
  setAcceptFocus( true );
}

CycleButton::CycleButton(AGUIX *taguix,int tx,int ty,int width,
                         int tfg,int tbg,int tdata):GUIElement(taguix)
{
  this->x=tx;
  this->y=ty;
  if ( width > 0 ) this->w = width;
  this->h=taguix->getCharHeight()+4;
  this->data=tdata;
  this->state=0;
  this->instate=0;
  this->fg=tfg;
  this->bg=tbg;
  lastbg=-1;
  font=NULL;
  options=new List();
  act_opt=-1;
  canHandleFocus = true;
  setAcceptFocus( true );
}

CycleButton::CycleButton(AGUIX *taguix,int tx,int ty,int width,int height,
                         int tfg,int tbg,int tdata):GUIElement(taguix)
{
  this->x=tx;
  this->y=ty;
  if ( width > 0 ) this->w = width;
  if ( height > 0 ) this->h = height;
  this->data=tdata;
  this->state=0;
  this->instate=0;
  this->fg=tfg;
  this->bg=tbg;
  lastbg=-1;
  font=NULL;
  options=new List();
  act_opt=-1;
  canHandleFocus = true;
  setAcceptFocus( true );
}

char *CycleButton::getOption(int index2)
{
  if((index2<0)||(index2>=options->size())) return NULL;
  return (char*)options->getElementAt(index2);
}

int CycleButton::addOption(const char *new_text)
{
  options->addElement(dupstring(new_text));
  if(act_opt==-1) {
    act_opt=0;
    redraw();
  }
  return options->size()-1;
}

void CycleButton::setOption(int index2)
{
  if((index2>=0)&&(index2<options->size())) {
    act_opt=index2;
    redraw();
  }
}

void CycleButton::setFG(int tfg)
{
  if((tfg<(aguix->getMaxCols()))&&(tfg>=0)) {
    this->fg=tfg;
  }
  redraw();
}

int CycleButton::getFG() const
{
  return fg;
}

void CycleButton::setBG(int tbg)
{
  if((tbg<(aguix->getMaxCols()))&&(tbg>=0)) {
    this->bg=tbg;
  }
  redraw();
}

int CycleButton::getBG() const
{
  return bg;
}

int CycleButton::getData() const
{
  return data;
}

void CycleButton::setData(int tdata)
{
  this->data=tdata;
}

void CycleButton::redraw()
{
  double circle[11][4]={{6.0/8, 5.0/8, 6.0/8, 6.0/8},
                        {6.0/8, 6.0/8, 5.0/8, 7.0/8},
			{5.0/8, 7.0/8, 2.0/8, 7.0/8},
			{2.0/8, 7.0/8, 1.0/8, 6.0/8},
			{1.0/8, 6.0/8, 1.0/8, 2.0/8},
			{1.0/8, 2.0/8, 2.0/8, 1.0/8},
			{2.0/8, 1.0/8, 5.0/8, 1.0/8},
			{5.0/8, 1.0/8, 6.0/8, 2.0/8},
			{6.0/8, 2.0/8, 6.0/8, 4.0/8},
			{6.0/8, 4.0/8, 5.0/8, 3.0/8},
			{6.0/8, 4.0/8, 7.0/8, 3.0/8}};
  GC usegc;
  double x1,x2,ty1,y2;
  if(parent==NULL) return;
  if(win==0) return;
  if(bg!=lastbg) {
    aguix->SetWindowBG(win,bg);
    lastbg=bg;
  }
  aguix->ClearWin(win);
  if(font==NULL) usegc=0; else usegc=font->getGC();
  if(state==0) {
    aguix->setFG(usegc,2);
  } else {
    aguix->setFG(usegc,1);
  }
  aguix->DrawLine(win,usegc,0,h-1,0,0);
  aguix->DrawLine(win,usegc,0,0,w-1,0);
  if(state==0) {
    aguix->setFG(usegc,1);
  } else {
    aguix->setFG(usegc,2);
  }
  aguix->DrawLine(win,usegc,0,h-1,w-1,h-1);
  aguix->DrawLine(win,usegc,w-1,h-1,w-1,1);

  aguix->setFG(usegc,1);
  aguix->DrawLine(win,usegc,h-1,1,h-1,h-2);
  for(int i=0;i<11;i++) {
    x1=circle[i][0];
    x2=circle[i][2];
    ty1=circle[i][1];
    y2=circle[i][3];
    x1*=h-2;
    x2*=h-2;
    ty1*=h-2;
    y2*=h-2;
    aguix->DrawLine(win,usegc,(int)x1+1,(int)ty1+1,(int)x2+1,(int)y2+1);
  }

  aguix->setFG(usegc,fg);
  int ch,cw;
  if(font==NULL) {
    ch=aguix->getCharHeight();
    cw=aguix->getCharWidth();
  } else {
    ch=font->getCharHeight();
    cw=font->getCharWidth();
  }
  int dy=h/2-ch/2;
  unsigned int maxdisplay=(w-2)/cw;
  char *tstr;
  if(act_opt>=0) tstr=dupstring((char*)options->getElementAt(act_opt));
  else tstr=dupstring("");
  if(strlen(tstr)>maxdisplay) tstr[maxdisplay]=0;
  int dx=h+5;
  if(font==NULL) {
    aguix->DrawText(win,tstr,dx,dy);
  } else {
    aguix->DrawText(win,font,tstr,dx,dy);
  }
  _freesafe(tstr);

  if ( ( getAcceptFocus() == true ) && ( hasFocus() == true ) ) {
    aguix->setDottedFG( 1 );
    aguix->DrawDottedRectangle( win, h, 1, w - h - 1, h - 2 );
  }

  aguix->Flush();
}

void CycleButton::flush()
{
}

void CycleButton::setState(int tstate)
{
  this->state=tstate;
  redraw();
}

int CycleButton::getState() const
{
  return state;
}

bool CycleButton::isInside(int px,int py) const
{
  if((px>0)&&(px<=w)) {
    if((py>0)&&(py<=h)) return true;
  }
  return false;
}

bool CycleButton::handleMessage(XEvent *E,Message *msg)
{
  bool returnvalue;
  
  if ( parent == NULL ) return false;

  returnvalue=false;
  AGMessage *agmsg;
  if((msg->type==ButtonPress)||(msg->type==ButtonRelease)) {
    if ( msg->window == win ) {
      int mx,my;

      takeFocus();

      mx=msg->mousex;
      my=msg->mousey;
      if(msg->type==ButtonPress) {
	if(msg->window==win) {
	  setState(1);
	  instate=1;
	  returnvalue=true;
	}
      } else {
	if((state!=0)&&(instate!=0)) {
	  if(options->size()>0) {
	    if(msg->button==Button3) {
	      act_opt--;
	      if(act_opt<0) act_opt=options->size()-1;
	    } else if(msg->button==Button1) {
	      act_opt++;
	      if(act_opt>=options->size()) act_opt=0;
	    } else if(msg->button==Button4) {
	      if(act_opt>0) act_opt--;
	    } else if(msg->button==Button5) {
	      if((act_opt+1)<options->size()) act_opt++;
	    }
	  }
	  
	  agmsg = AGUIX_allocAGMessage();
	  agmsg->type=AG_CYCLEBUTTONCLICKED;
	  agmsg->cyclebutton.cyclebutton=this;
	  agmsg->cyclebutton.option=act_opt;
	  aguix->putAGMsg(agmsg);
	}
	if(instate!=0) {
	  setState(0);
	  instate=0;
	  returnvalue=true;
	}
      }
    }
  } else if(msg->type==EnterNotify) {
    // alles hier und alles mit instate wird benutzt, damit Button sich anpat, wenn
    // Mauszeiger im Button oder auerhalb des Buttons ist
    if ( msg->window == win ) {
      if(instate!=0) {
	if(state!=instate) {
	  setState(instate);
	}
      }
    }
  } else if(msg->type==LeaveNotify) {
    // alles hier und alles mit instate wird benutzt, damit Button sich anpat, wenn
    // Mauszeiger im Button oder auerhalb des Buttons ist
    if ( msg->window == win ) {
      if(instate!=0) {
	setState(0);
      }
    }
  } else if(msg->type==Expose) {
    if ( msg->window == win ) {
      redraw();
    }
  } else if ( msg->type == KeyPress ) {
    if ( ( getAcceptFocus() == true ) && ( hasFocus() == true ) ) {
      if ( options->size() > 0 ) {
	if ( isVisible() == true ) {
	  if ( parent->isTopParent( msg->window ) == true ) {
	    switch ( msg->key ) {
	    case XK_space:
	      if(options->size()>0) {
		act_opt++;
		if(act_opt>=options->size()) act_opt=0;
	      }
	      
	      agmsg = AGUIX_allocAGMessage();
	      agmsg->type=AG_CYCLEBUTTONCLICKED;
	      agmsg->cyclebutton.cyclebutton=this;
	      agmsg->cyclebutton.option=act_opt;
	      aguix->putAGMsg(agmsg);
	      if(instate!=0) {
		setState(0);
		instate=0;
		returnvalue=true;
	      } else redraw();  // setState will make this so just in the else-case
	      break;
	    case XK_Up:
	      if ( act_opt > 0 ) {
		act_opt--;
		agmsg = AGUIX_allocAGMessage();
		agmsg->type = AG_CYCLEBUTTONCLICKED;
		agmsg->cyclebutton.cyclebutton = this;
		agmsg->cyclebutton.option = act_opt;
		aguix->putAGMsg( agmsg );
		redraw();
	      }
	      break;
	    case XK_Down:
	      if ( ( act_opt + 1 ) < options->size() ) {
		act_opt++;
		agmsg = AGUIX_allocAGMessage();
		agmsg->type = AG_CYCLEBUTTONCLICKED;
		agmsg->cyclebutton.cyclebutton = this;
		agmsg->cyclebutton.option = act_opt;
		aguix->putAGMsg( agmsg );
		redraw();
	      }
	      break;
	    }
	  }
	}
      }
    }
  }
  if(returnvalue==true) {
    // jetzt noch die Message mit den Werten fllen
    msg->gadget=this;
    msg->gadgettype=BUTTON_GADGET;
  }
//  return returnvalue;
  return false;  // we return false because an other element can take use of
                 // this message (f.e. StringGagdet for deactivating)
}

int CycleButton::setFont(char *fontname)
{
  font=aguix->getFont(fontname);
  if(font==NULL) return -1;
  return 0;
}

const char *CycleButton::getType() const
{
  return type;
}

bool CycleButton::isType(const char *qtype) const
{
  if(strcmp(type,qtype)==0) return true;
  return false;
}

int CycleButton::getMaxSize() const
{
  int maxlen=-1,len;
  int cw;
  char *tstr=(char*)options->getFirstElement();
  while(tstr!=NULL) {
    len=strlen(tstr);
    if(len>maxlen) maxlen=len;
    tstr=(char*)options->getNextElement();
  }
  if(font==NULL) {
    cw=aguix->getCharWidth();
  } else {
    cw=font->getCharWidth();
  }
  return h+10+cw*maxlen;
}

int
CycleButton::getSelectedOption() const
{
  return act_opt;
}
