/* normalmode_delete.cc
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2011 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "normalmode.h"
#include "worker_locale.h"
#include "deleteop.h"
#include "nmcacheentry.hh"
#include "nmcopyopdir.hh"
#include "nmfieldlistviewdnd.hh"
#include "fileentry.hh"
#include "simplelist.hh"

void NormalMode::deletef( struct NM_deleteorder *delorder )
{
    NM_specialsourceInt *ss1;
    //  bool found;
    bool enter;
    NM_CopyOp_Dir *cod1,*tcod;
    unsigned long files,dirs,gf,gd;
    bool skip,cancel=false;
    DeleteOpWin *dowin;
    nm_copy_t ce1;
    char *buttonstr,*textstr;
    int erg;
    bool empty;
    int tnrfiles,tnrdirs;
    std::list<NM_specialsourceInt*> *dellist;
    std::list<NM_specialsourceInt*>::iterator iti1;
  
    if(delorder==NULL) return;
    if ( getCurrentDir() == NULL ) {
        // no current dir => no files to delete
        return;
    }

    if ( ce->dirOpened() == false ) return;

    tnrfiles = ce->getNrOfFiles( 1 );
    tnrdirs = ce->getNrOfDirs( 1 );

    if ( ( delorder->source == delorder->NM_ALLENTRIES ) &&
         ( ( tnrfiles + tnrdirs ) < 1 ) ) {
        if ( ce->getActiveFE() != NULL ) {
            if ( strcmp( ce->getActiveFE()->name, ".." ) != 0 ) {
                if ( ce->getActiveFE()->isDir() == true ) tnrdirs++;
                else tnrfiles++;
            }
        }
    }
  
    if ( ( tnrfiles + tnrdirs ) < 1 )
        return;

    finishsearchmode();
  
    buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(11))+1+
                                strlen(catalog.getLocale(8))+1);
    sprintf(buttonstr,"%s|%s",catalog.getLocale(11),
            catalog.getLocale(8));
    textstr = (char*)_allocsafe( strlen( catalog.getLocale( 145 ) ) + A_BYTESFORNUMBER( tnrfiles ) +
                                 A_BYTESFORNUMBER( tnrdirs ) + 1 );
    sprintf(textstr,catalog.getLocale(145),tnrfiles,tnrdirs);
    erg = request( catalog.getLocale( 123 ), textstr, buttonstr );
    _freesafe(buttonstr);
    _freesafe(textstr);
    if(erg!=0) return;

    // clear the reclist so the slace doesn't block us because he is still reading
    // from disk
    ft_rec_list_clear();
  
    dowin=delorder->dowin;
    if(dowin!=NULL) {
        dowin->open();
        dowin->setmessage(catalog.getLocale(140));
        if ( dowin->redraw() != 0 ) cancel = true;
    }
    dellist = new std::list<NM_specialsourceInt*>;
    switch(delorder->source) {
        case NM_deleteorder::NM_SPECIAL:
            break;
        case NM_deleteorder::NM_ONLYACTIVE:
            /*OPT:At the moment I doesn't allow onlyactive
              if(ce->activefe!=NULL) {
              lvc=lv->getActiveLVC();
              if(lvc!=NULL) {
              if(lvc->getData()___wrong___==ce->activefe->nr) {
              if(strcmp(ce->activefe->name,"..")!=0) {
	      ss2 = new NM_specialsource( ce->activefe );
              ss2->lvc=lvc;
              ss2->cod=NULL;
              dellist->addElement(ss2);
              }
              }
              }
              }*/
            break;
        case NM_deleteorder::NM_ONLYSELECTED:
            getSelFiles( dellist, NM_GETFILES_ONLYSELECT, false );
            break;
        default:  // all selected entries
            getSelFiles( dellist, NM_GETFILES_SELORACT, false );
            break;
    }
    if(dowin!=NULL) dowin->redraw();

    // create the NM_CopyOp_Dir for each dir in dellist
    files=dirs=gf=gd=0;
  
    for ( iti1 = dellist->begin(); iti1 != dellist->end(); iti1++ ) {
        if ( cancel == true ) break;
        ss1 = *iti1;
        enter=false;
        if ( ss1->entry()->isDir() == true ) {
            // fe is a dir, check if it is a link and take it only when follow_symlinks==true
            if ( ss1->entry()->isLink == false ) enter = true;
        }
        if(enter==true) {
            // fe is a dir so creating corresponding entry
            cod1 = new NM_CopyOp_Dir( ss1->entry() );
            if ( cod1->user_abort == false ) {
                // recursive call
                if(cod1->createSubDirs(delorder,&gf,&gd)!=0) cancel=true;
            } else cancel = true;
            // add the values from this subdir to this dir
            files+=cod1->files;
            dirs+=cod1->dirs;
      
            ss1->cod=cod1;
            // this is a dir so inc the counter
            dirs++;
            gd++;
            if(dowin!=NULL) {
                dowin->set_files_to_delete(gf);
                dowin->set_dirs_to_delete(gd);
                if(dowin->redraw()!=0) cancel=true;;
            }
        } else {
            // is not dir (mostly a file but can also be links ...)
            files++;
            gf++;
            ss1->cod=NULL;
        }
    }

    if(dowin!=NULL) {
        dowin->set_files_to_delete(files);
        dowin->set_dirs_to_delete(dirs);
    }
    // now database ready, can start copy-process
    skip=false;
    for ( iti1 = dellist->begin(); ( iti1 != dellist->end() ) && ( cancel == false ); iti1++ ) {
        ss1 = *iti1;
        tcod=ss1->cod;
        if ( cancel == true ) break;
        if ( ss1->row >= 0 ) {
            lv->setVisMark( ss1->row, true );
            lv->showRow( ss1->row );
        }
        if(tcod!=NULL) {
            // determine if the dir is empty or not
            if((tcod->files+tcod->dirs)>0) empty=false;
            else empty=true;
            skip=false;
            // skip if the user doesn't want to delete non-empty dirs
            if((delorder->dirdel==delorder->NM_DIRDELETE_NONE)&&(empty==false)) skip=true;
            // if the user doesn't select ALL or NONE and the the dir isn't empty show a request
            if((delorder->dirdel==delorder->NM_DIRDELETE_NORMAL)&&(empty==false)) {
                textstr=(char*)_allocsafe(strlen(catalog.getLocale(146))+
                                          strlen( ss1->entry()->fullname ) + 1 );
                sprintf( textstr, catalog.getLocale( 146 ), ss1->entry()->fullname );
                buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(11))+1+
                                            strlen(catalog.getLocale(287))+1+
                                            strlen(catalog.getLocale(288))+1+
                                            strlen(catalog.getLocale(225))+1+
                                            strlen(catalog.getLocale(8))+1);
                sprintf(buttonstr,"%s|%s|%s|%s|%s",catalog.getLocale(11),
                        catalog.getLocale(287),
                        catalog.getLocale(288),
                        catalog.getLocale(225),
                        catalog.getLocale(8));
                erg = request( delorder->dowin, catalog.getLocale( 123 ), textstr, buttonstr );
                _freesafe(buttonstr);
                _freesafe(textstr);
                switch(erg) {
                    case 1:
                        delorder->dirdel=delorder->NM_DIRDELETE_ALL;
                        break;
                    case 2:
                        delorder->dirdel=delorder->NM_DIRDELETE_NONE;
                        skip=true;
                        break;
                    case 3:
                        skip=true;
                        break;
                    case 4:
                        cancel=true;
                        skip=true;
                        break;
                }
            }
            if(skip==false) {
                ce1 = deldir( ss1->entry(), tcod, delorder );
                if(ce1==NM_COPY_OK) {
                    // success
                } else if(ce1==NM_COPY_CANCEL) {
                    cancel=true;
                }
                if((tcod->error_counter==0)&&(cancel==false)) {
                    // successful delete this dir so remove it form the lv
                    // first show this lvc
                    if(ss1->row>=0) lv->showRow(ss1->row);
                    removeEntry( ss1->entry(), ss1->row );
                    fixSpecialSourceList( dellist, ss1->row );
                }
            }
        } else {
            if ( dowin != NULL ) dowin->setfilename( ss1->entry()->fullname );
            ce1 = delfile( ss1->entry(), delorder, false );
            if(ce1==NM_COPY_OK) {
                // success
                if(ss1->row>=0) lv->showRow(ss1->row);
                removeEntry( ss1->entry(), ss1->row );
                fixSpecialSourceList( dellist, ss1->row );
            } else if(ce1==NM_COPY_CANCEL) {
                cancel=true;
            }
        }
        if ( ss1->row >= 0 ) {
            // this can and will changed the wrong row when the entry
            // was deleted successfully
            // but for this case this doesn't matter because
            // the disabled visual mark is the default
            lv->setVisMark( ss1->row, false );
        }
        if(dowin!=NULL) {
            if(dowin->redraw()!=0) cancel=true;
        }
    }
    if(dowin!=NULL) dowin->close();
  
    for ( iti1 = dellist->begin(); iti1 != dellist->end(); iti1++ ) {
        ss1 = *iti1;
        if(ss1->cod!=NULL) delete ss1->cod;
        delete ss1;
    }
    delete dellist;

    ce->restartcheck();
    rebuildView();
    lv->showActive();
    aguix->Flush();
}

NormalMode::nm_copy_t NormalMode::deldir( const FileEntry *fe, NM_CopyOp_Dir *cod, struct NM_deleteorder *delorder )
{
    NM_CopyOp_Dir *cod1=NULL;
    int id1;
    FileEntry *subfe;
    bool isdir,skip,cancel;
    //  char *buttonstr,*textstr;
    //  int erg;
    nm_copy_t ce1;
    DeleteOpWin *dowin=delorder->dowin;
    bool delerror;

    skip=cancel=false;

    if(dowin!=NULL) dowin->setfilename(fe->fullname);
    // first del all subdirs
    // then del all files 
    id1=cod->subdirs->initEnum();
    cod1=(NM_CopyOp_Dir*)cod->subdirs->getFirstElement(id1);
    while(cod1!=NULL) {
        ce1=deldir(cod1->fileentry,cod1,delorder);
        if(ce1==NM_COPY_OK) {
            // success
            cod->error_counter+=cod1->error_counter;
        } else {
            cod->error_counter+=cod1->error_counter+1;
            if(ce1==NM_COPY_CANCEL) {
                cancel=true;
                break;
            }
        }
        cod1=(NM_CopyOp_Dir*)cod->subdirs->getNextElement(id1);
    }
    cod->subdirs->closeEnum(id1);

    // next only if read this dir correctly
    if((cod->ok==true)&&(cancel==false)) {
        for ( Verzeichnis::verz_it subfe_it1 = cod->verz->begin();
              subfe_it1 != cod->verz->end();
              subfe_it1++ ) {
            subfe = *subfe_it1;
            if(strcmp(subfe->name,"..")!=0) {
                isdir=false;
                if(subfe->isDir()==true) {
                    if(subfe->isLink==false) isdir=true;
                }
                if(isdir==false) {
                    ce1=delfile(subfe,delorder,false);
                    if(ce1==NM_COPY_OK) {
                        // success
                    } else {
                        cod->error_counter++;
                        if(ce1==NM_COPY_CANCEL) {
                            cancel=true;
                            break;
                        }
                    }
                }
            }
        }
    }
    if((skip==true)&&(dowin!=NULL)) {
        // dir skiped so dec CopyOpWin counter by the files/dirs skiped
        dowin->dec_file_counter(cod->files);
        dowin->dec_dir_counter(cod->dirs);
    }

    delerror=true;
    if((skip==false)&&(cancel==false)) {
        if(cod->error_counter==0) {
            ce1=delfile(fe,delorder,true);
            if(ce1==NM_COPY_OK) {
                // success
                delerror=false;
            } else {
                cod->error_counter++;
                if(ce1==NM_COPY_CANCEL) {
                    cancel=true;
                }
            }
        }
    }
    if(delerror==true) {
        char *textstr=(char*)_allocsafe(strlen(catalog.getLocale(289))+strlen(fe->fullname)+1);
        sprintf(textstr,catalog.getLocale(289),fe->fullname);
        char *buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(11))+1+
                                          strlen(catalog.getLocale(8))+1);
        sprintf(buttonstr,"%s|%s",catalog.getLocale(11),
                catalog.getLocale(8));
        int erg = request( delorder->dowin, catalog.getLocale( 125 ), textstr, buttonstr );
        _freesafe(buttonstr);
        _freesafe(textstr);
        if(erg==1) cancel=true;
        else skip=true;
    }
    if(cancel==true) return NM_COPY_CANCEL;
    else if(skip==true) {
        cod->error_counter++;
        return NM_COPY_SKIP;
    }
    return NM_COPY_OK;
}

NormalMode::nm_copy_t NormalMode::delfile( const FileEntry *fe, struct NM_deleteorder *delorder, bool dir )
{
    bool skip,cancel;
    char *textstr,*buttonstr;
    int erg;
    DeleteOpWin *dowin=delorder->dowin;

    skip=cancel=false;

    if ( dir == true ) erg = worker_rmdir( fe->fullname );
    else erg = worker_unlink( fe->fullname );
    if(erg!=0) {
        //    textstr="Failed to remove this file!";
        //    buttonstr="Ok|Cancel";

        if(dir==true) {
            textstr=(char*)_allocsafe(strlen(catalog.getLocale(147))+strlen(fe->fullname)+1);
            sprintf(textstr,catalog.getLocale(147),fe->fullname);
        } else { 
            textstr=(char*)_allocsafe(strlen(catalog.getLocale(286))+strlen(fe->fullname)+1);
            sprintf(textstr,catalog.getLocale(286),fe->fullname);
        }
        buttonstr=(char*)_allocsafe(strlen(catalog.getLocale(11))+1+
                                    strlen(catalog.getLocale(8))+1);
        sprintf(buttonstr,"%s|%s",catalog.getLocale(11),
                catalog.getLocale(8));
        erg = request( delorder->dowin, catalog.getLocale( 347 ), textstr, buttonstr );
        _freesafe(buttonstr);
        _freesafe(textstr);
        if(erg==1) cancel=true;
        else skip=true;
    }
    if(dowin!=NULL) {
        if(dir==true) {
            dowin->dir_finished();
            if(dowin->redraw()!=0) cancel=true;
        } else dowin->file_finished();
    }
    if(cancel==true) return NM_COPY_CANCEL;
    else if(skip==true) return NM_COPY_SKIP;
    return NM_COPY_OK;
}
