/* wconfig_generalconf.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2007 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "wconfig_generalconf.hh"
#include "wconfig.h"
#include "worker.h"
#include <aguix/acontainerbb.h>

GeneralConfPanel::GeneralConfPanel( AWindow &basewin, WConfig &baseconfig ) : WConfigPanel( basewin, baseconfig )
{
}

GeneralConfPanel::~GeneralConfPanel()
{
}

int GeneralConfPanel::create()
{
    int res;
    
    res = Panel::create();
    
    AContainer *ac1 = setContainer( new AContainer( this, 1, 2 ), true );
    ac1->setMinSpace( 5 );
    ac1->setMaxSpace( 5 );
    
    ac1->add( new Text( _aguix, 0, 0, catalog.getLocale( 784 ), 1 ), 0, 0, AContainer::CINCWNR );

    AContainerBB *ac1_1 = (AContainerBB*)ac1->add( new AContainerBB( this, 1, 1 ), 0, 1 );
    ac1_1->setMinSpace( 5 );
    ac1_1->setMaxSpace( -1 );
    ac1_1->setBorderWidth( 7 );

    m_cb = (ChooseButton*)ac1_1->add( new ChooseButton( _aguix,
                                                        0,
                                                        0,
                                                        _baseconfig.getSaveWorkerStateOnExit(),
                                                        catalog.getLocale( 785 ),
                                                        LABEL_LEFT,
                                                        1,
                                                        0 ), 0, 0, AContainer::CINCWNR );
    
    contMaximize( true );
    return 0;
}

int GeneralConfPanel::saveValues()
{
    _baseconfig.setSaveWorkerStateOnExit( m_cb->getState() );
    return 0;
}
