/* normalmode.h
 * This file belongs to Worker, a file manager for UN*X/X11.
 * Copyright (C) 2001-2009 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef NORMALMODE_H
#define NORMALMODE_H

#include "wdefines.h"
#include <aguix/aguix.h>
#include <aguix/message.h>
#include <aguix/fieldlistview.h>
#include <aguix/fieldlistviewdnd.h>
#include <aguix/stringgadget.h>
#include <aguix/button.h>
#include <aguix/request.h>
#include <aguix/mutex.h>
#include <aguix/condvar.h>
#include <aguix/refcount.hh>
#include <aguix/popupmenu.hh>
#include <map>
#include <memory>
#include "listermode.h"
#include "condparser.h"
#include "nmfilter.hh"
#include "dirfiltersettings.hh"
#include "dirsortsettings.hh"
#include "stringmatcher_fnmatch.hh"
#include "dirbookmarkssettings.hh"
#include "fileentry_customcolor.hh"
#include <string>

class Lister;
class NMFieldListViewDND;
class CopyOpWin;
class NMBookmarkCB;
class NM_specialsourceExt;
class NMExtList;
class NM_CopyOp_Dir;
class NMCacheEntry;
class DeleteOpWin;
class FileEntry;
class AContainer;
class KarteiButton;

struct NM_copyorder {
  char *destdir;
  enum {NM_ALLENTRIES,NM_ONLYACTIVE,NM_SPECIAL} source;
  std::list<NM_specialsourceExt*> *sources;
  // modes:
  bool move; // true = move, false = copy
  bool follow_symlinks;
  bool do_rename;
  bool preserve_attr;
  enum {NM_OVERWRITE_NORMAL,NM_OVERWRITE_ALWAYS,NM_OVERWRITE_NEVER} overwrite;
    /* _NORMAL: Request what to do
       _ALWAYS: overwrite without request
       _NEVER: no overwriting */
  enum {NM_COPYMODE_NORMAL,NM_COPYMODE_NODATABASE} copymode;
  CopyOpWin *cowin;

  int error;  // for returning an error
  bool ignoreLosedAttr;  // true when the user don't want to get a requester
                         // when SUID/SGID bit couldn't be restored
};

struct NM_deleteorder {
  enum {NM_ALLENTRIES,NM_ONLYACTIVE,NM_SPECIAL,NM_ONLYSELECTED} source;
  std::list<NM_specialsourceExt*> *sources;
  enum {NM_DELMODE_NORMAL} delmode;
  enum {NM_DIRDELETE_NORMAL,NM_DIRDELETE_ALL,NM_DIRDELETE_NONE} dirdel;
  DeleteOpWin *dowin;

  int error;  // for returning an error
};

class NM_externorder {
public:
  NM_externorder();
  ~NM_externorder();
  NM_externorder( const NM_externorder &other );
  NM_externorder &operator=( const NM_externorder &other );

  bool separate_each_entry;
  bool recursive;
  bool inbackground;

  enum {NM_EXT_START_NORMAL=0,
        NM_EXT_START_IN_TERMINAL,
        NM_EXT_START_IN_TERMINAL_AND_WAIT4KEY,
        NM_EXT_SHOW_OUTPUT} extstart;

  char *com_str;
  char *view_str;

  enum {NM_ALLENTRIES,NM_ONLYACTIVE,NM_SPECIAL} source;
  std::list<NM_specialsourceExt*> *sources;
  
  // this is for DND-actions for identifying the destination (for the dp-flag)
  class NormalMode *destmode;
  class WPUContext *wpu;
  bool take_dirs;
  bool dontcd;
};

struct NM_renameorder {
  enum {NM_ALLENTRIES,NM_ONLYACTIVE,NM_SPECIAL} source;
  std::list<NM_specialsourceExt*> *sources;
};

struct NM_dirsizeorder {
  enum {NM_ALLENTRIES,NM_ONLYACTIVE,NM_SPECIAL} source;
  std::list<NM_specialsourceExt*> *sources;
};

struct NM_createsymlinkorder {
  bool local;
  char *destdir;
  enum {NM_ALLENTRIES,NM_ONLYACTIVE,NM_SPECIAL} source;
  std::list<NM_specialsourceExt*> *sources;
};

struct NM_chmodorder {
  bool ondirs,onfiles,recursive;
  enum {NM_ALLENTRIES,NM_ONLYACTIVE,NM_SPECIAL} source;
  std::list<NM_specialsourceExt*> *sources;
};

struct NM_chownorder {
  bool ondirs,onfiles,recursive;
  enum {NM_ALLENTRIES,NM_ONLYACTIVE,NM_SPECIAL} source;
  std::list<NM_specialsourceExt*> *sources;
};

struct NM_changesymlinkorder {
  enum {NM_ALLENTRIES,NM_ONLYACTIVE,NM_SPECIAL} source;
  std::list<NM_specialsourceExt*> *sources;
};

class NormalMode:public ListerMode
{
public:
  NormalMode(Lister *);
  virtual ~NormalMode();
  NormalMode( const NormalMode &other );
  NormalMode &operator=( const NormalMode &other );

  virtual void messageHandler(AGMessage *);
  virtual void on();
  virtual void off();
  virtual void activate();
  virtual void deactivate();
  void selhandler( FieldListView*, int row );
  virtual bool isType(const char *);
  virtual const char *getType();
  virtual int configure();
  virtual void cyclicfunc(cyclicfunc_mode_t mode);
  virtual const char* getLocaleName();
  virtual int load();
  virtual int loadBin(Datei*);
  virtual bool save(Datei *);
  virtual void reconfig();
  static const char *getStaticLocaleName();
  static const char *getStaticType();
  
  int enterDir(const char *dirstr);
  int enterPath( const std::string &fullname );
  void enterDirActive();
  void setActiveDir2Other();
  void up();
  void down();
  void top();
  void last();
  void pageup();
  void pagedown();
  void select();
  void selectall();
  void selectnone();
  void invertall();
  void parent();
  void filterselect(char *filter,int mode);
  void copy(struct NM_copyorder *copyorder);
  void deletef(struct NM_deleteorder *delorder);
  void update(bool reset_dirsizes);
  void update(bool reset_dirsizes, bool keep_filetypes );
  void makedir();
  void externprog(class NM_externorder *extorder);
  void renamef(struct NM_renameorder *renorder);
  void dirsize(struct NM_dirsizeorder *dsorder);
  void simdd();
  void searchentry( bool ignore_case, bool reverse_search = false );
  void enterpath();
  void scrolllister(int dir);
  void createsymlink(struct NM_createsymlinkorder *cslorder);
  void changesymlink(struct NM_changesymlinkorder *chslorder);
  void chmodf(struct NM_chmodorder *cmorder);
  void chownf(struct NM_chownorder *coorder);
  
  void toggleHidden();
  void setShowHidden(bool);
  const char *getCurrentDir();
  static bool isCorrectViewProg(const char *str);
  
  typedef enum {NM_GETFILES_ONLYACTIVE,
                NM_GETFILES_ONLYSELECT,
                NM_GETFILES_SELORACT} nm_getfiles_t;
  int getSelFiles( std::list<NM_specialsourceExt*>*, nm_getfiles_t, bool unselect = false );
  static void freeSelFiles( std::list<NM_specialsourceExt*>* );
  int getDirSize( FileEntry *fe, loff_t &return_size, bool &cancel );

  virtual bool startdnd(DNDMsg *dm);
  virtual bool isyours( Widget *elem );

  FileEntry *getFE4DNDSTART( const AGDNDSTART *st );
  void setSortmode(int nmode);
  
  typedef enum {NM_FILTER_INCLUDE,NM_FILTER_EXCLUDE,NM_FILTER_UNSET} nm_filter_t;
  void unsetAllFilters();
  void setFilter(const char *filter,nm_filter_t mode);
    nm_filter_t checkFilter( const char *filter ) throw( int );

  void slavehandler();
  static void freeExtList( List *extlist );
  char *parseComStrExt( const char *sstr,class NM_externorder *extorder,int maxlen, NMExtList *entries[2], bool quote);
  /* deselect for extern access, check for existance of fe => slow for big dirs */
  void deselect( const FileEntry *fe );
  virtual void lvbDoubleClicked();
  
  int showCacheList();
  int request( const char *title,
               const char *text,
               const char *buttons,
               Requester::request_flags_t flags = Requester::REQUEST_NONE );
  int string_request( const char *title,
                      const char *lines,
                      const char *default_str,
                      const char *buttons,
                      char **return_str,
                      Requester::request_flags_t flags = Requester::REQUEST_NONE );
  int request_choose( const char *title,
		      const char *text,
		      const char *choose_text,
		      bool &choose_var,
		      const char *buttons,
		      Requester::request_flags_t flags = Requester::REQUEST_NONE );
  int request( CopyOpWin *cowin,
               const char *title,
               const char *text,
               const char *buttons,
               Requester::request_flags_t flags = Requester::REQUEST_NONE );
  int string_request( CopyOpWin *cowin,
                      const char *title,
                      const char *lines,
                      const char *default_str,
                      const char *buttons,
                      char **return_str,
                      Requester::request_flags_t flags = Requester::REQUEST_NONE );
  int request( DeleteOpWin *dowin,
               const char *title,
               const char *text,
               const char *buttons,
               Requester::request_flags_t flags = Requester::REQUEST_NONE );
  int string_request( DeleteOpWin *dowin,
                      const char *title,
                      const char *lines,
                      const char *default_str,
                      const char *buttons,
                      char **return_str,
                      Requester::request_flags_t flags = Requester::REQUEST_NONE );
  int tryApplyOwnerPerm( const char *filename,
                         const uid_t wanted_user,
                         const gid_t wanted_group,
                         const mode_t wanted_mode,
                         struct NM_copyorder *copyorder );
  NM_specialsourceExt *getSpecialsourceForFE( const FileEntry *searchfe );

  void activateEntry( const std::string &name );

  bool filteredSearchActive() const;
  void deactivateFilteredSearch();
  
  void openContextMenu();
  void bookmarksChanged();
  void updateOnBookmarkChange();
  void openLabelPopUp();

    void setHighlightBookmarkPrefix( bool nv );
    bool getHighlightBookmarkPrefix() const;

    void setBookmarkFilter( DirFilterSettings::bookmark_filter_t v );
    DirFilterSettings::bookmark_filter_t getBookmarkFilter() const;

    void setSpecificBookmarkLabel( const std::string &l );
    const std::string &getSpecificBookmarkLabel() const;

    int queryLVDimensions( int &x, int &y,
                           int &w, int &h );

    void newTab();
    void closeCurrentTab();
    void switchToTab( int tab );
    void switchToTabDirection( int direction );
protected:
  /*
   * NM_specialsourceInt always stores a pointer to a FE
   */
  class NM_specialsourceInt {
   public:
    NM_specialsourceInt( FileEntry *tfe );
    ~NM_specialsourceInt();
    FileEntry *entry() const
    {
      return fe;
    }
    int row;  // corresponding row or -1
    NM_CopyOp_Dir *cod; // when fe is dir, this will be the corresponding structure
   private:
    FileEntry *fe;  // element to copy
  };

  void buildListView();
  void deleteCache();
  void showcache(int);
  void showCacheAbs( int pos );
  void showCacheState();
  void startAction(FileEntry*);
  
  typedef enum {NM_NEWNAME_OK,
                NM_NEWNAME_SKIP,
                NM_NEWNAME_CANCEL,
                NM_NEWNAME_OVERWRITE,
                NM_NEWNAME_USE} nm_newname_t;
  typedef enum {NM_COPY_OK,
                NM_COPY_SKIP,
                NM_COPY_CANCEL,
                NM_COPY_NEED_DELETE} nm_copy_t;
  nm_newname_t getNewName(const FileEntry *oldfe,struct NM_copyorder *copyorder,char *dest,
                          char **newname_return,bool requestDir,bool acceptrename);
  nm_newname_t getNewName4File(const FileEntry*oldfe,struct NM_copyorder *copyorder,char *dest,
                          char **newname_return,bool acceptrename);
  nm_newname_t getNewName4Dir(const FileEntry*oldfe,struct NM_copyorder *copyorder,char *dest,
                          char **newname_return,bool acceptrename);
  nm_copy_t copydir(const FileEntry *fe,
              NM_CopyOp_Dir *cod,
              struct NM_copyorder *copyorder,
              bool acceptrename,
              char *destdir);
  nm_copy_t copyfile(const FileEntry *fe,
               struct NM_copyorder *copyorder,
               bool acceptrename,
               char *destdir);
  nm_copy_t deldir(const FileEntry *fe,
              NM_CopyOp_Dir *cod,
              struct NM_deleteorder *delorder);
  nm_copy_t delfile(const FileEntry *fe,
               struct NM_deleteorder *delorder,
               bool dir);

  NMFieldListViewDND *lv;
  Button *hb[2], *parentb;
  StringGadget *sg;
  static const char *type;
  NMCacheEntry *ce;
  List *cache;
  Requester *req;
  #define BUFSIZE 128*1024
  void *buf;
  bool searchmodeon;
  char *oldstr;
  char *lastsearch;
  std::list<const FileEntry*> *copy_deletefe_list;
  int sortmode;
  
  bool showfreespace;
  int updatetime;
  time_t lastfsupdate;
  std::string namestr;
  char *freespacestr;
  enum ssh_allow_t { SSH_ASK, SSH_NEVER, SSH_ALWAYS } ssh_allow;
  
  struct timeval lastclick;
  int lastrow;
  void removeEntry( FileEntry *fe, int row );
  void fixSpecialSourceList( const std::list<NM_specialsourceInt*> *l, int deleted_row );
  char *parseComStr( const char *sstr,class NM_externorder *extorder,int maxlen, NMExtList *entries[2], bool quote );
  void deselect( FileEntry *fe, int row );
  char *StringRequest(char *sstr,class NM_externorder *extorder,int maxlen, NMExtList *entries[2]);
  void startsearchmode();
  void finishsearchmode();

  /**
   * jumps to the next entry matching the given string or the last search
   * string (if tstr == NULL )
   */
  bool shownextentry( const char *tstr, bool reverse_search = false, bool start_at_same = false );

  typedef struct changemod_info{
      changemod_info();
      bool forAll;
      
      mode_t mode;
      
      typedef enum {
          CHMOD_SET,
          CHMOD_ADD,
          CHMOD_REM
      } chmod_op_t;
      
      chmod_op_t op;
  } changemod_info_t;
  int worker_changemod( const NM_specialsourceInt *ss1,
                        changemod_info_t *cminfo,
                        const NM_chmodorder *cmorder );
  int applyNewMode( const NM_specialsourceInt *ss1, changemod_info_t newmode );
  typedef struct changeown_info{
    changeown_info();
    bool forAll;
    uid_t newuid;
    gid_t newgid;
  } changeown_info_t;
  int worker_changeown( const struct NM_specialsourceInt *ss1,
                        changeown_info_t *coinfo,
                        const NM_chownorder *coorder );
  int applyNewOwner( const NM_specialsourceInt *ss1, uid_t newuid, gid_t newgid );

  int requestNewMode( FileEntry *fe, changemod_info_t *return_mode );
  void setFilters( const std::list<NM_Filter> &filters );
    void configureFilters( bool * tshowhidden, std::list<NM_Filter> &filters, DirFilterSettings &dir_settings );
  void setLVC4Filter( FieldListView *filv, int row, NM_Filter &fi);
  int configureFilter( NM_Filter &fi );
  void rebuildView();
  void setName();
  void updateName();
  void showFreeSpace(bool force);
  int updateFreeSpaceStr( int ti );
  void setShowFreeSpace(bool v);
  void setUpdatetime(int nv);
  void setSSHAllow( enum ssh_allow_t nv );
  void setQuicksearchEnabled( bool nv );
  void setFilteredSearchEnabled( bool nv );
  
  static int maxfilestrlen,maxdirstrlen,maxbytesstrlen,maxwbytesstrlen,maxnochanges;
public:   // why the h*** need the Sun compiler a public definition for a
          // protected struct?
  typedef enum { THREAD_NOP,
                 THREAD_WAIT,
                 THREAD_RUN,
                 THREAD_EXIT,
                 THREAD_REINIT } thread_order_t;
protected:
  struct {
    int running;
    thread_order_t order;
    thread_order_t status;
    CondVar statusvar;
    pthread_t th;
    
    List *filetypes;
    CondVar filetype_ex;
    
  } slave;
  int switchOrder( thread_order_t neworder );
  int waitForNoOrder( void );
  int waitForNewOrder( void );
  int switchStatus( thread_order_t newstatus );
  int waitForStatus( thread_order_t waitstatus );
  
  // intern list (special fifo) for the tasks for the slave-thread
  // can contain up to size elements of prev type
  // main thread does put and remove
  // slave does slaveread
  class ft_rec_list
  {
  public:
    // type for the ft_rec_list
    // contains filename, FileEntry (only for main thread)
    
    // as long as you hold the lock at least
    // name and dontCheckContent are valid
    // if you release the lock take this entry as invalid
    // so copy needed things inside the lock
    typedef struct _ft_rec_list_t {
      const char *name;
      FileEntry *fe;
      bool dontCheckContent;
      struct _ft_rec_list_t *next;
    } ft_rec_list_t;

    ft_rec_list();
    ~ft_rec_list();
    ft_rec_list( const ft_rec_list &other );
    ft_rec_list &operator=( const ft_rec_list &other );

    int slaveread_locked( const char **name, bool *dontCheckContent );
    bool elemAvail_locked();
    bool isFull_locked();
    bool isEmpty_locked();
    int put_locked( ft_rec_list_t *elem );
    ft_rec_list_t *remove_locked();
    ft_rec_list_t *gettop_locked();

    void lock();
    void unlock();
    void wait();
    void signal();
  protected:
    CondVar ex;
    int size;
    ft_rec_list_t *head, *tail;
    
    ft_rec_list_t *readp;
    int elements;
  };
  void ft_rec_list_clear();

  // fifo for ft-results
  // main thread does remove
  // slave does put
  // no size limitation
  class ft_recres_list {
  public:
    // this is the type for the filetype-recogn-result
    // contains the name and the position of the ft in the wconfig list
    // index of ft because so every slave can hold a copy of the ft-list
    // to work without need to lock
    class ft_recres_list_t {
    public:
      char *name;
      std::vector<unsigned int> *ft_index;
      std::auto_ptr<FileEntryCustomColor> custom_color;
      ft_recres_list_t *next;

      ft_recres_list_t()
      {
	name = NULL;
	ft_index = NULL;
	next = NULL;
      }
      ~ft_recres_list_t()
      {
        if ( name != NULL ) _freesafe( name );
        if ( ft_index != NULL ) delete ft_index;
      }
      ft_recres_list_t( const ft_recres_list_t &other );
      ft_recres_list_t &operator=( const ft_recres_list_t &other );
    };
    
    ft_recres_list();
    ~ft_recres_list();
    ft_recres_list( const ft_recres_list &other );
    ft_recres_list &operator=( const ft_recres_list &other );

    bool isEmpty_locked();
    int put_locked( ft_recres_list_t *elem );
    ft_recres_list_t *remove_locked();
    
    void lock();
    void unlock();
  protected:
    ft_recres_list_t *head, *tail;
    MutEx ex;
    
    int elements;
  };
  void ft_recres_list_clear();

  ft_rec_list *reclist;
  ft_recres_list *recreslist;

  void ft_list_clear();
  void ft_list_update();

  class checkFiletypeRes_t {
  public:
      //TODO use auto_ptr?
    std::vector<unsigned int> *v;
    std::auto_ptr<FileEntryCustomColor> custom_color;
    
    checkFiletypeRes_t() {
      v = NULL;
    }
    checkFiletypeRes_t( const checkFiletypeRes_t &other );
    checkFiletypeRes_t &operator=( const checkFiletypeRes_t &rhs );
  };
  
  int slave_checkFiletype( const char *fullname, bool dontCheckContent, checkFiletypeRes_t &res_return );
  
  bool lasteagain;
  
  void setupLVFields();

  typedef struct {
    union {
      uid_t uid;
      gid_t gid;
    } id;
    char *name;
  } chownrequest_id_name_t;
  
  void freeOwnerRequestInfos();
  void buildOwnerRequestInfos();
  int requestNewOwner( FileEntry *fe, uid_t *return_owner, gid_t *return_group );  
  List *chownUserList;
  List *chownGroupList;
  
  bool isColumnVisible( const WorkerTypes::listcol_t c );
  bool visChanged;
  int oldlvy;
  
  void showInvalidList( ArrayList *list, const char *descr );
  void changeSortModeForField( int field );
  
  int busyFlag;
  time_t lastBusyFlagUpdate;
  
  CondParser condparser;
  WCFiletype *findFiletype( std::vector<unsigned int> *v );
  int getSelFiles( std::list<NM_specialsourceInt*> *, nm_getfiles_t, bool unselect );
  FileEntry *findFE( const FileEntry *tfe );

  class Requests
  {
  public:
    Requests();
    ~Requests();
    Requests( const Requests &other );
    Requests &operator=( const Requests &other );
    typedef enum { SKIP_CANCEL,
		   NO_SPACE_LEFT,
		   WRITE_ERROR } request_t;
    typedef enum { OKAY, SKIP, CANCEL, REQUEST_ERROR } request_choose_t;
    request_choose_t request( request_t type, AWindow *win, std::string text );
    request_choose_t request( request_t type, AWindow *win, const char *format, const char *str2, int error_number );
    request_choose_t request_va( request_t type, AWindow *win, const char *format, ... );
  private:
    std::map<request_t, std::list<request_choose_t> > request_chooses;
    std::map<request_choose_t, std::string> choose_strings;
  };
  Requests requests;

  typedef enum { REG_COPY_OK, REG_COPY_SKIP, REG_COPY_CANCEL, REG_COPY_ERROR } reg_copy_erg_t;
  
  reg_copy_erg_t copyfile_reg( const char *sourcename,
			       const char *destname,
			       const char *destdirname,
			       const char *destbasename,
			       mode_t create_mode,
			       CopyOpWin *cowin,
			       loff_t bytesToCopy );
  bool checkForEmptyActionList( WCFiletype *ft );
  std::map<std::string,int> _field_map;
  std::map<std::string,int> _loaded_field_width;
  int getAndEraseLoadedFieldWidth( std::string str1 );
  int writeFieldWidthsToLoadMap();

  bool quicksearch_enabled;

  void makeRowActive( int row );
  void makeListViewRowActive( int row );

  DirFilterSettings _dir_filter_sets;
  DirSortSettings _dir_sort_sets;
  DirBookmarksSettings m_dir_bookmarks_sets;

  bool checkEnterDir( const char *dir2 );

  FileEntry *getFEForRow( int row );
  int _lv_ids_serial;

  StringMatcherFNMatch _entrysearch_matcher;
  void setEntrySearchString( const std::string &str, bool update_lv = true );
  std::string getEntrySearchString();
  void setEntrySearchCaseSensitive( bool nv );
  
  void updateDirFilter();

  bool _filtered_search_enabled;
  bool m_filtered_search_active;

  int buildSpecialSourceIntList( const std::list<NM_specialsourceExt*> &inlist,
                                 std::list<NM_specialsourceInt*> &outlist );
  
  void lv_pressed( int row, bool open_under_mouse = true );
  void buildContextPopUpMenu( FileEntry *entry );
  void buildLabelPopUpMenu( FileEntry *entry );
  void freePopUpMenus();
  void startLVPopUpAction( AGMessage *msg );

  time_t m_last_statebar_update;
  bool m_bookmarks_has_been_changed;
  NMBookmarkCB *m_bookmark_cb;

    std::list<PopUpMenu::PopUpEntry> buildLabelPopUpData( FileEntry *entry );
    void handleLabelPopUp( AGMessage *msg );
    void handleLabelPopUp( FileEntry *fe, const std::list<int> &entry_ids );

    typedef struct _label_popup_table_t {
        typedef enum { REMOVE_LABEL, ADD_LABEL } label_popup_t;

        _label_popup_table_t() : type( REMOVE_LABEL ),
                                 label( "" )
        {}
        _label_popup_table_t( label_popup_t t, const std::string &l ) : type( t ),
                                                                        label( l )
        {}

        label_popup_t type;
        std::string label;
    } label_popup_table_t;

    class PopUpSettings {
    public:
        PopUpSettings();
        PopUpSettings( const PopUpSettings &other );
        PopUpSettings &operator=( const PopUpSettings &rhs );

        void reset();

        int label_menu_id;
        std::map<int, label_popup_table_t> label_id_to_action;
        std::auto_ptr<PopUpMenu> label_popup_menu;

        std::map<int, RefCount<ActionDescr> > popup_descr;
        std::auto_ptr<FileEntry> entry_for_popup;
        PopUpMenu *lv_popup_menu;
    };

    PopUpSettings m_current_popup_settings;

    AContainer *m_cont, *m_cont2, *m_tab_cont;
    KarteiButton *m_tab_b;
    Button *m_tab_new, *m_tab_close;

    void updateTabs();
    NMCacheEntry *findOldestCacheEntryNotInTab();

    struct {
        std::list<std::string> list_of_used_tabs;
        int active_tab;
    } m_off_store;

    RefCount<TextShrinker> m_shrinker;
};

class NMFieldListViewDND:public FieldListViewDND
{
public:
  NMFieldListViewDND(AGUIX*,int,int,int,int,int);
  virtual ~NMFieldListViewDND();
  NMFieldListViewDND( const NMFieldListViewDND &other );
  NMFieldListViewDND &operator=( const NMFieldListViewDND &other );

  void setSelectHandler(NormalMode*);
protected:
  NormalMode *nm;
  virtual void runSelectHandler( int row );
};

#endif

/* Local Variables: */
/* mode:c++ */
/* End: */
