%{
/* parser for config file (bison generated)
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2003-2008 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "wdefines.h"
#include "wconfig.h"
#include "wcdoubleshortkey.hh"
#include "wcpath.hh"
#include "wcfiletype.hh"
#include "wchotkey.hh"
#include "wcbutton.hh"
#include <stdlib.h>
#include <string.h>
#include "worker_commands.h"
#include "configheader.h"
#include <list>

int lconfig_side;
int lconfig_pos;
List *lconfig_listp,
     *lconfig_listb,
     *lconfig_listft,
     *lconfig_listh,
     *lconfig_listsk,
     *lconfig_listcom,
     *lconfig_ignorelist;
WCButton *lconfig_bt1;
WCFiletype *lconfig_ft1, *old_lconfig_ft1;
std::list<WCFiletype*> filetypehier;
WCHotkey *lconfig_hk1;
WCDoubleShortkey *lconfig_dk;
WCPath *lconfig_p1;
int lconfig_id;
KeySym lconfig_nkeysym;
unsigned int lconfig_keymod;
char *lconfig_tstr;
FunctionProto *lconfig_fp1;
char lconfig_error[256];

extern WConfig *lconfig;

extern int yyerror( char *s );

void lconfig_parseinit(void)
{
  lconfig_listp = NULL;
  lconfig_listb = NULL;
  lconfig_listft = NULL;
  lconfig_listh = NULL;
  lconfig_listsk = NULL;
  lconfig_listcom = NULL;
  lconfig_ignorelist = NULL;
  lconfig_bt1 = NULL;
  lconfig_ft1 = NULL;
  lconfig_hk1 = NULL;
  lconfig_dk = NULL;
  lconfig_p1 = NULL;
  lconfig_tstr = NULL;
  lconfig_fp1 = NULL;
}

void lconfig_cleanup(void)
{
  // free all stuff in the list
  if ( lconfig_fp1 != NULL ) {
    delete lconfig_fp1;
    lconfig_fp1 = NULL;
  }
  if ( lconfig_tstr != NULL ) {
    _freesafe( lconfig_tstr );
    lconfig_tstr = NULL;
  }
  if ( lconfig_p1 != NULL ) {
    delete lconfig_p1;
    lconfig_p1 = NULL;
  }
  if ( lconfig_dk != NULL ) {
    delete lconfig_dk;
    lconfig_dk = NULL;
  }
  if ( lconfig_hk1 != NULL ) {
    delete lconfig_hk1;
    lconfig_hk1 = NULL;
  }
  if ( lconfig_ft1 != NULL ) {
    delete lconfig_ft1;
    lconfig_ft1 = NULL;
  }
  if ( lconfig_bt1 != NULL ) {
    delete lconfig_bt1;
    lconfig_bt1 = NULL;
  }
  if ( lconfig_listp != NULL ) {
    lconfig_id = lconfig_listp->initEnum();
    lconfig_p1 = (WCPath*)lconfig_listp->getFirstElement( lconfig_id );
    while ( lconfig_p1 != NULL ) {
      delete lconfig_p1;
      lconfig_p1 = (WCPath*)lconfig_listp->getNextElement( lconfig_id );
    }
    lconfig_listp->closeEnum( lconfig_id );
    delete lconfig_listp;
    lconfig_listp = NULL;
  }
  if ( lconfig_listb != NULL ) {
    lconfig_id = lconfig_listb->initEnum();
    lconfig_bt1 = (WCButton*)lconfig_listb->getFirstElement( lconfig_id );
    while ( lconfig_bt1 != NULL ) {
      delete lconfig_bt1;
      lconfig_bt1 = (WCButton*)lconfig_listb->getNextElement( lconfig_id );
    }
    lconfig_listb->closeEnum( lconfig_id );
    delete lconfig_listb;
    lconfig_listb = NULL;
  }
  if ( lconfig_listft != NULL ) {
    lconfig_id = lconfig_listft->initEnum();
    lconfig_ft1 = (WCFiletype*)lconfig_listft->getFirstElement( lconfig_id );
    while ( lconfig_ft1 != NULL ) {
      delete lconfig_ft1;
      lconfig_ft1 = (WCFiletype*)lconfig_listft->getNextElement( lconfig_id );
    }
    lconfig_listft->closeEnum( lconfig_id );
    delete lconfig_listft;
    lconfig_listft = NULL;
  }

  while ( filetypehier.size() > 0 ) {
      lconfig_ft1 = filetypehier.back();
      filetypehier.pop_back();
      delete lconfig_ft1;
      lconfig_ft1 = NULL;
  }

  if ( lconfig_listh != NULL ) {
    lconfig_id = lconfig_listh->initEnum();
    lconfig_hk1 = (WCHotkey*)lconfig_listh->getFirstElement( lconfig_id );
    while ( lconfig_hk1 != NULL ) {
      delete lconfig_hk1;
      lconfig_hk1 = (WCHotkey*)lconfig_listh->getNextElement( lconfig_id );
    }
    lconfig_listh->closeEnum( lconfig_id );
    delete lconfig_listh;
    lconfig_listh = NULL;
  }
  if ( lconfig_listsk != NULL ) {
    lconfig_id = lconfig_listsk->initEnum();
    lconfig_dk = (WCDoubleShortkey*)lconfig_listsk->getFirstElement( lconfig_id );
    while ( lconfig_dk != NULL ) {
      delete lconfig_dk;
      lconfig_listsk->removeFirstElement();
      lconfig_dk = (WCDoubleShortkey*)lconfig_listsk->getFirstElement( lconfig_id );
    }
    lconfig_listsk->closeEnum( lconfig_id );
    delete lconfig_listsk;
    lconfig_listsk = NULL;
  }
  if ( lconfig_listcom != NULL ) {
    lconfig_id = lconfig_listcom->initEnum();
    lconfig_fp1 = (FunctionProto*)lconfig_listcom->getFirstElement( lconfig_id );
    while ( lconfig_fp1 != NULL ) {
      delete lconfig_fp1;
      lconfig_listcom->removeFirstElement();
      lconfig_fp1 = (FunctionProto*)lconfig_listcom->getFirstElement( lconfig_id );
    }
    lconfig_listcom->closeEnum( lconfig_id );
    delete lconfig_listcom;
    lconfig_listcom = NULL;
  }
  if ( lconfig_ignorelist != NULL ) {
    lconfig_id = lconfig_ignorelist->initEnum();
    lconfig_tstr = (char*)lconfig_ignorelist->getFirstElement( lconfig_id );
    while ( lconfig_tstr != NULL ) {
      _freesafe( lconfig_tstr );
      lconfig_tstr = (char*)lconfig_ignorelist->getNextElement( lconfig_id );
    }
    lconfig_ignorelist->closeEnum( lconfig_id );
    delete lconfig_ignorelist;
    lconfig_ignorelist = NULL;
  }
}

/*#define YYERROR_VERBOSE*/

%}

%union {
  int num;
  char *strptr;
}

%token LEFTBRACE_WCP RIGHTBRACE_WCP GLOBAL_WCP COLORS_WCP LANG_WCP PALETTE_WCP OWNOP_WCP LISTERSETS_WCP YES_WCP NO_WCP
%token LEFT_WCP RIGHT_WCP HBARTOP_WCP HBARHEIGHT_WCP VBARLEFT_WCP VBARWIDTH_WCP DISPLAYSETS_WCP
%token NAME_WCP SIZE_WCP TYPE_WCP PERMISSION_WCP OWNER_WCP DESTINATION_WCP MODTIME_WCP ACCTIME_WCP CHGTIME_WCP ROWS_WCP
%token COLUMNS_WCP CACHESIZE_WCP OWNERSTYLE_WCP TERMINAL_WCP USESTRINGFORDIRSIZE_WCP
%token TIMESETS_WCP STYLE1_WCP STYLE2_WCP STYLE3_WCP DATE_WCP TIME_WCP DATESUBSTITUTION_WCP DATEBEFORETIME_WCP
%token STATEBAR_WCP SELLVBAR_WCP UNSELLVBAR_WCP CLOCKBAR_WCP REQUESTER_WCP UNSELDIR_WCP SELDIR_WCP UNSELFILE_WCP
%token SELFILE_WCP UNSELACTDIR_WCP SELACTDIR_WCP UNSELACTFILE_WCP SELACTFILE_WCP LVBG_WCP
%token STARTUP_WCP BUTTON_WCP BUTTONS_WCP POSITION_WCP TITLE_WCP COMMANDS_WCP SHORTKEYS_WCP
%token PATHS_WCP PATH_WCP FILETYPES_WCP FILETYPE_WCP NORMAL_WCP NOTYETCHECKED_WCP UNKNOWN_WCP NOSELECT_WCP DIR_WCP
%token USEPATTERN_WCP USECONTENT_WCP PATTERN_WCP CONTENT_WCP FTCOMMANDS_WCP DND_WCP DC_WCP SHOW_WCP RAWSHOW_WCP USER_WCP
%token FLAGS_WCP IGNOREDIRS_WCP HOTKEYS_WCP HOTKEY_WCP FONTS_WCP GLOBALFONT_WCP BUTTONFONT_WCP LEFTFONT_WCP RIGHTFONT_WCP
%token CLOCKBARSETS_WCP MODUS_WCP TIMESPACE_WCP VERSION_WCP EXTERN_WCP UPDATETIME_WCP PROGRAM_WCP
%token KEY_WCP DOUBLE_WCP MOD_WCP CONTROL_WCP SHIFT_WCP LOCK_WCP MOD1_WCP MOD2_WCP MOD3_WCP MOD4_WCP MOD5_WCP
%token DNDACTION_WCP DCACTION_WCP SHOWACTION_WCP RSHOWACTION_WCP USERACTION_WCP ROWUP_WCP ROWDOWN_WCP
%token CHANGEHIDDENFLAG_WCP COPYOP_WCP FIRSTROW_WCP LASTROW_WCP PAGEUP_WCP PAGEDOWN_WCP SELECTOP_WCP
%token SELECTALLOP_WCP SELECTNONEOP_WCP INVERTALLOP_WCP PARENTDIROP_WCP ENTERDIROP_WCP
%token CHANGELISTERSETOP_WCP SWITCHLISTEROP_WCP FILTERSELECTOP_WCP FILTERUNSELECTOP_WCP
%token PATHTOOTHERSIDEOP_WCP QUITOP_WCP DELETEOP_WCP RELOADOP_WCP MAKEDIROP_WCP RENAMEOP_WCP DIRSIZEOP_WCP
%token SIMDDOP_WCP STARTPROGOP_WCP SEARCHENTRYOP_WCP ENTERPATHOP_WCP SCROLLLISTEROP_WCP
%token CREATESYMLINKOP_WCP CHANGESYMLINKOP_WCP CHMODOP_WCP TOGGLELISTERMODEOP_WCP SETSORTMODEOP_WCP
%token SETFILTEROP_WCP SHORTKEYFROMLISTOP_WCP CHOWNOP_WCP WORKERCONFIG_WCP
%token USERSTYLE_WCP DATESTRING_WCP TIMESTRING_WCP COLOR_WCP PATTERNIGNORECASE_WCP PATTERNUSEREGEXP_WCP PATTERNUSEFULLNAME_WCP
%token COM_WCP SEPARATEEACHENTRY_WCP RECURSIVE_WCP START_WCP TERMINALWAIT_WCP SHOWOUTPUT_WCP VIEWSTR_WCP
%token INBACKGROUND_WCP TAKEDIRS_WCP ACTIONNUMBER_WCP HIDDENFILES_WCP HIDE_WCP TOGGLE_WCP
%token FOLLOWSYMLINKS_WCP MOVE_WCP RENAME_WCP SAMEDIR_WCP REQUESTDEST_WCP REQUESTFLAGS_WCP OVERWRITE_WCP
%token ALWAYS_WCP NEVER_WCP COPYMODE_WCP FAST_WCP PRESERVEATTR_WCP MODE_WCP ACTIVE_WCP ACTIVE2OTHER_WCP SPECIAL_WCP
%token REQUEST_WCP CURRENT_WCP OTHER_WCP FILTER_WCP QUICK_WCP ALSOACTIVE_WCP RESETDIRSIZES_WCP KEEPFILETYPES_WCP
%token RELATIVE_WCP ONFILES_WCP ONDIRS_WCP SORTBY_WCP SORTFLAG_WCP REVERSE_WCP DIRLAST_WCP DIRMIXED_WCP EXCLUDE_WCP
%token INCLUDE_WCP UNSET_WCP UNSETALL_WCP SCRIPTOP_WCP NOP_WCP PUSH_WCP LABEL_WCP IF_WCP END_WCP POP_WCP SETTINGS_WCP WINDOW_WCP
%token GOTO_WCP PUSHUSEOUTPUT_WCP DODEBUG_WCP WPURECURSIVE_WCP WPUTAKEDIRS_WCP STACKNR_WCP PUSHSTRING_WCP
%token IFTEST_WCP IFLABEL_WCP WINTYPE_WCP OPEN_WCP CLOSE_WCP LEAVE_WCP CHANGEPROGRESS_WCP CHANGETEXT_WCP
%token PROGRESSUSEOUTPUT_WCP WINTEXTUSEOUTPUT_WCP PROGRESS_WCP WINTEXT_WCP SHOWDIRCACHEOP_WCP
%token INODE_WCP NLINK_WCP BLOCKS_WCP SHOWHEADER_WCP LVHEADER_WCP IGNORECASE_WCP
%token LISTVIEWS_WCP BLL_WCP LBL_WCP LLB_WCP BL_WCP LB_WCP LAYOUT_WCP BUTTONSVERT_WCP LISTVIEWSVERT_WCP
%token EXTCOND_WCP USEEXTCOND_WCP
%token SUBTYPE_WCP PARENTACTIONOP_WCP NOOPERATIONOP_WCP
%token COLORMODE_WCP DEFAULT_WCP CUSTOM_WCP UNSELECTCOLOR_WCP SELECTCOLOR_WCP UNSELECTACTIVECOLOR_WCP
%token SELECTACTIVECOLOR_WCP COLOREXTERNPROG_WCP PARENT_WCP DONTCD_WCP DONTCHECKVIRTUAL_WCP GOFTPOP_WCP
%token HOSTNAME_WCP USERNAME_WCP PASSWORD_WCP DONTENTERFTP_WCP ALWAYSSTOREPW_WCP
%token INTERNALVIEWOP_WCP CUSTOMFILES_WCP SHOWMODE_WCP SELECTED_WCP REVERSESEARCH_WCP
%token MOUSECONF_WCP SELECTBUTTON_WCP ACTIVATEBUTTON_WCP SCROLLBUTTON_WCP SELECTMETHOD_WCP ALTERNATIVE_WCP
%token SEARCHOP_WCP EDITCOMMAND_WCP SHOWPREVRESULTS_WCP
%token TEXTVIEW_WCP TEXTVIEWHIGHLIGHTED_WCP TEXTVIEWSELECTION_WCP
%token DIRBOOKMARKOP_WCP OPENCONTEXTMENUOP_WCP RUNCUSTOMACTION_WCP CUSTOMNAME_WCP
%token CONTEXTBUTTON_WCP ACTIVATEMOD_WCP SCROLLMOD_WCP CONTEXTMOD_WCP NONE_WCP
%token CUSTOMACTION_WCP SAVE_WORKER_STATE_ON_EXIT_WCP OPENWORKERMENUOP_WCP

%token ERROR ACTIVESIDE_WCP SHOWFREESPACE_WCP ACTIVEMODE_WCP ASK_WCP SSHALLOW_WCP FIELD_WIDTH_WCP QUICKSEARCHENABLED_WCP
%token FILTEREDSEARCHENABLED_WCP XFTFONTS_WCP
%token USEMAGIC_WCP MAGICPATTERN_WCP

%type <num> bool
%type <num> ft_type
%token <strptr> STRING_WCP 
%token <num> NUM_WCP

%%
S:{ lconfig_parseinit();}WORKERCONFIG_WCP NUM_WCP'.'NUM_WCP'.'NUM_WCP';' start
 ;

start:GLOBAL_WCP LEFTBRACE_WCP glb RIGHTBRACE_WCP start
     |COLORS_WCP LEFTBRACE_WCP cols RIGHTBRACE_WCP start
     |STARTUP_WCP LEFTBRACE_WCP startup RIGHTBRACE_WCP start
     |PATHS_WCP LEFTBRACE_WCP { lconfig_listp = new List(); }
      paths RIGHTBRACE_WCP { lconfig->setPaths( lconfig_listp );
                             lconfig_id = lconfig_listp->initEnum();
                             lconfig_p1 = (WCPath*)lconfig_listp->getFirstElement( lconfig_id );
                             while ( lconfig_p1 != NULL ) {
                               delete lconfig_p1;
                               lconfig_p1 = (WCPath*)lconfig_listp->getNextElement( lconfig_id );
                             }
                             lconfig_listp->closeEnum( lconfig_id );
                             delete lconfig_listp;
                             lconfig_listp = NULL;
                           } start
     |FILETYPES_WCP LEFTBRACE_WCP { lconfig_listft = new List(); }
      filetypes RIGHTBRACE_WCP { lconfig->setFiletypes( lconfig_listft );
                                 lconfig_id = lconfig_listft->initEnum();
                                 lconfig_ft1 = (WCFiletype*)lconfig_listft->getFirstElement( lconfig_id );
                                 while ( lconfig_ft1 != NULL ) {
                                   delete lconfig_ft1;
                                   lconfig_ft1 = (WCFiletype*)lconfig_listft->getNextElement( lconfig_id );
                                 }
                                 lconfig_listft->closeEnum( lconfig_id );
                                 delete lconfig_listft;
                                 lconfig_listft = NULL;
                               } start
     |HOTKEYS_WCP LEFTBRACE_WCP { lconfig_listh = new List(); }
      hotkeys RIGHTBRACE_WCP { lconfig->setHotkeys( lconfig_listh );
                               lconfig_id = lconfig_listh->initEnum();
                               lconfig_hk1 = (WCHotkey*)lconfig_listh->getFirstElement( lconfig_id );
                               while ( lconfig_hk1 != NULL ) {
                                 delete lconfig_hk1;
                                 lconfig_hk1 = (WCHotkey*)lconfig_listh->getNextElement( lconfig_id );
                               }
                               lconfig_listh->closeEnum( lconfig_id );
                               delete lconfig_listh;
                               lconfig_listh = NULL;
                             } start
     |BUTTONS_WCP LEFTBRACE_WCP { lconfig_listb = new List(); }
      buttons RIGHTBRACE_WCP { lconfig->setButtons( lconfig_listb );
                               lconfig_id = lconfig_listb->initEnum();
                               lconfig_bt1 = (WCButton*)lconfig_listb->getFirstElement( lconfig_id );
                               while ( lconfig_bt1 != NULL ) {
                                 delete lconfig_bt1;
                                 lconfig_bt1 = (WCButton*)lconfig_listb->getNextElement( lconfig_id );
                               }
                               lconfig_listb->closeEnum( lconfig_id );
                               delete lconfig_listb;
                               lconfig_listb = NULL;
                             } start
     |FONTS_WCP LEFTBRACE_WCP fonts RIGHTBRACE_WCP start
     |XFTFONTS_WCP LEFTBRACE_WCP xftfonts RIGHTBRACE_WCP start
     |CLOCKBARSETS_WCP LEFTBRACE_WCP clockbarsets RIGHTBRACE_WCP start
     |;

glb:LANG_WCP'='STRING_WCP';' { lconfig->setLang( $3 ); } glb
   |ROWS_WCP'='NUM_WCP';'{ lconfig->setRows( $3 ); } glb
   |COLUMNS_WCP'='NUM_WCP';'{ lconfig->setColumns( $3 ); } glb
   |CACHESIZE_WCP'='NUM_WCP';'{ lconfig->setCacheSize( $3 ); } glb
   |LISTERSETS_WCP LEFTBRACE_WCP listersets RIGHTBRACE_WCP glb
   |OWNERSTYLE_WCP'='STYLE1_WCP';' { lconfig->setOwnerstringtype( 0 ); } glb
   |OWNERSTYLE_WCP'='STYLE2_WCP';'{ lconfig->setOwnerstringtype( 1 ); } glb
   |TERMINAL_WCP'='STRING_WCP';'{ lconfig->setTerminalBin( $3 ); } glb
   |USESTRINGFORDIRSIZE_WCP'='bool';'{ lconfig->setShowStringForDirSize( ( ( $3 ) == 1 ) ? true : false ); } glb
/*   |STRINGFORDIRSIZE'='STRING_WCP';' { lconfig->setStringForDirSize( $3 ); } glb*/
    |TIMESETS_WCP LEFTBRACE_WCP timesets RIGHTBRACE_WCP glb
    |PALETTE_WCP LEFTBRACE_WCP { lconfig->resetColors(); } pal RIGHTBRACE_WCP glb
    |LAYOUT_WCP LEFTBRACE_WCP { lconfig->clearLayoutOrders(); } layout RIGHTBRACE_WCP glb
    |MOUSECONF_WCP LEFTBRACE_WCP mouseconf RIGHTBRACE_WCP glb
    |SAVE_WORKER_STATE_ON_EXIT_WCP'='bool';'{ lconfig->setSaveWorkerStateOnExit( ( ( $3 ) == 1 ) ? true : false ); } glb
    |;

layout:STATEBAR_WCP';' { lconfig->layoutAddEntry( WConfig::LO_STATEBAR ); } layout
      |CLOCKBAR_WCP';' { lconfig->layoutAddEntry( WConfig::LO_CLOCKBAR ); } layout
      |BUTTONS_WCP';' { lconfig->layoutAddEntry( WConfig::LO_BUTTONS ); } layout
      |LISTVIEWS_WCP';' { lconfig->layoutAddEntry( WConfig::LO_LISTVIEWS ); } layout
      |BLL_WCP';' { lconfig->layoutAddEntry( WConfig::LO_BLL ); } layout
      |LBL_WCP';' { lconfig->layoutAddEntry( WConfig::LO_LBL ); } layout
      |LLB_WCP';' { lconfig->layoutAddEntry( WConfig::LO_LLB ); } layout
      |BL_WCP';' { lconfig->layoutAddEntry( WConfig::LO_BL ); } layout
      |LB_WCP';' { lconfig->layoutAddEntry( WConfig::LO_LB ); } layout
      |BUTTONSVERT_WCP'='bool';'{ lconfig->setLayoutButtonVert( ( ( $3 ) == 1 ) ? true : false ); } layout
      |LISTVIEWSVERT_WCP'='bool';'{ lconfig->setLayoutListviewVert( ( ( $3 ) == 1 ) ? true : false ); } layout
      |;

pal:NUM_WCP'='NUM_WCP','NUM_WCP','NUM_WCP';'{ lconfig->setColor( $1, $3, $5, $7 ); } pal
   |;

listersets:LEFT_WCP{ lconfig_side = 0; } LEFTBRACE_WCP listersets2 RIGHTBRACE_WCP listersets
          |RIGHT_WCP{ lconfig_side = 1; } LEFTBRACE_WCP listersets2 RIGHTBRACE_WCP listersets
          |;

listersets2:HBARTOP_WCP'='bool';'{ lconfig->setHBarTop( lconfig_side, ( ( $3 ) == 1 ) ? true : false ); } listersets2
           |HBARHEIGHT_WCP'='NUM_WCP';'{ lconfig->setHBarHeight( lconfig_side, $3 ); } listersets2
           |VBARLEFT_WCP'='bool';'{ lconfig->setVBarLeft( lconfig_side, ( ( $3 ) == 1 ) ? true : false ); } listersets2
           |VBARWIDTH_WCP'='NUM_WCP';'{ lconfig->setVBarWidth( lconfig_side, $3 ); } listersets2
           |DISPLAYSETS_WCP LEFTBRACE_WCP { lconfig->clearVisCols( lconfig_side ); } displaysets RIGHTBRACE_WCP listersets2
           |SHOWHEADER_WCP'='bool';'{ lconfig->setShowHeader( lconfig_side, ( ( $3 ) == 1 ) ? true : false ); } listersets2
           |;

displaysets:NAME_WCP';'{ lconfig->addListCol( lconfig_side, WorkerTypes::LISTCOL_NAME ); } displaysets
           |SIZE_WCP';'{ lconfig->addListCol( lconfig_side, WorkerTypes::LISTCOL_SIZE ); } displaysets
           |TYPE_WCP';'{ lconfig->addListCol( lconfig_side, WorkerTypes::LISTCOL_TYPE ); } displaysets
           |PERMISSION_WCP';'{ lconfig->addListCol( lconfig_side, WorkerTypes::LISTCOL_PERM ); } displaysets
           |OWNER_WCP';'{ lconfig->addListCol( lconfig_side, WorkerTypes::LISTCOL_OWNER ); } displaysets
           |DESTINATION_WCP';'{ lconfig->addListCol( lconfig_side, WorkerTypes::LISTCOL_DEST ); } displaysets
           |MODTIME_WCP';'{ lconfig->addListCol( lconfig_side, WorkerTypes::LISTCOL_MOD ); } displaysets
           |ACCTIME_WCP';'{ lconfig->addListCol( lconfig_side, WorkerTypes::LISTCOL_ACC ); } displaysets
           |CHGTIME_WCP';'{ lconfig->addListCol( lconfig_side, WorkerTypes::LISTCOL_CHANGE ); } displaysets
           |INODE_WCP';'{ lconfig->addListCol( lconfig_side, WorkerTypes::LISTCOL_INODE ); } displaysets
           |NLINK_WCP';'{ lconfig->addListCol( lconfig_side, WorkerTypes::LISTCOL_NLINK ); } displaysets
           |BLOCKS_WCP';'{ lconfig->addListCol( lconfig_side, WorkerTypes::LISTCOL_BLOCKS ); } displaysets
           |;

timesets:DATE_WCP'='STYLE1_WCP';' { lconfig->setDateFormat( 0 ); } timesets
	|DATE_WCP'='STYLE2_WCP';' { lconfig->setDateFormat( 1 ); } timesets
	|DATE_WCP'='STYLE3_WCP';' { lconfig->setDateFormat( 2 ); } timesets
	|DATE_WCP'='USERSTYLE_WCP';' { lconfig->setDateFormat( -1 ); } timesets
        |DATESTRING_WCP'='STRING_WCP';' { lconfig->setDateFormatString( $3 ); } timesets
        |DATESUBSTITUTION_WCP'='bool';' { lconfig->setDateSubst( ( ( $3 ) == 1 ) ? true : false ); } timesets
        |TIME_WCP'='STYLE1_WCP';' { lconfig->setTimeFormat( 0 ); } timesets
        |TIME_WCP'='STYLE2_WCP';' { lconfig->setTimeFormat( 1 ); } timesets
        |TIME_WCP'='USERSTYLE_WCP';' { lconfig->setTimeFormat( -1 ); } timesets
        |TIMESTRING_WCP'='STRING_WCP';' { lconfig->setTimeFormatString( $3 ); } timesets
        |DATEBEFORETIME_WCP'='bool';' { lconfig->setDateBeforeTime( ( ( $3 ) == 1 ) ? true : false ); } timesets
	|;

mouseconf:SELECTBUTTON_WCP'='NUM_WCP';' { lconfig->setMouseSelectButton( $3 ); } mouseconf
         |ACTIVATEBUTTON_WCP'='NUM_WCP';' { lconfig->setMouseActivateButton( $3 ); } mouseconf
         |SCROLLBUTTON_WCP'='NUM_WCP';' { lconfig->setMouseScrollButton( $3 ); } mouseconf
         |SELECTMETHOD_WCP'='NORMAL_WCP';' { lconfig->setMouseSelectMethod( WConfig::MOUSECONF_NORMAL_MODE ); } mouseconf
         |SELECTMETHOD_WCP'='ALTERNATIVE_WCP';' { lconfig->setMouseSelectMethod( WConfig::MOUSECONF_ALT_MODE ); } mouseconf
         |CONTEXTBUTTON_WCP'='NUM_WCP';' { lconfig->setMouseContextButton( $3 ); } mouseconf
         |ACTIVATEMOD_WCP LEFTBRACE_WCP { lconfig_keymod = 0; }
          mods RIGHTBRACE_WCP { lconfig->setMouseActivateMod( lconfig_keymod ); } mouseconf
         |SCROLLMOD_WCP LEFTBRACE_WCP { lconfig_keymod = 0; }
          mods RIGHTBRACE_WCP { lconfig->setMouseScrollMod( lconfig_keymod ); } mouseconf
         |CONTEXTMOD_WCP LEFTBRACE_WCP { lconfig_keymod = 0; }
          mods RIGHTBRACE_WCP { lconfig->setMouseContextMod( lconfig_keymod ); } mouseconf
	 |;

cols:STATEBAR_WCP'='NUM_WCP','NUM_WCP';' { lconfig->setStatusbar( 0, $3 );
                               lconfig->setStatusbar( 1, $5 ); } cols
    |SELLVBAR_WCP'='NUM_WCP','NUM_WCP';' { lconfig->setSelLVB( 0, $3 );
                               lconfig->setSelLVB( 1, $5 ); } cols
    |UNSELLVBAR_WCP'='NUM_WCP','NUM_WCP';' { lconfig->setUnselLVB( 0, $3 );
                                 lconfig->setUnselLVB( 1, $5 ); } cols
    |SELDIR_WCP'='NUM_WCP','NUM_WCP';' { lconfig->setSelDir( 0, $3 );
                             lconfig->setSelDir( 1, $5 ); } cols
    |UNSELDIR_WCP'='NUM_WCP','NUM_WCP';' { lconfig->setUnselDir( 0, $3 );
                               lconfig->setUnselDir( 1, $5 ); } cols
    |SELFILE_WCP'='NUM_WCP','NUM_WCP';' { lconfig->setSelFile( 0, $3 );
                              lconfig->setSelFile( 1, $5 ); } cols
    |UNSELFILE_WCP'='NUM_WCP','NUM_WCP';' { lconfig->setUnselFile( 0, $3 );
                                lconfig->setUnselFile( 1, $5 ); } cols
    |CLOCKBAR_WCP'='NUM_WCP','NUM_WCP';' { lconfig->setClockbar( 0, $3 );
                               lconfig->setClockbar( 1, $5 ); } cols
    |REQUESTER_WCP'='NUM_WCP','NUM_WCP';' { lconfig->setRequest( 0, $3 );
                                lconfig->setRequest( 1, $5 ); } cols
    |SELACTDIR_WCP'='NUM_WCP','NUM_WCP';' { lconfig->setSelDirAct( 0, $3 );
                                lconfig->setSelDirAct( 1, $5 ); } cols
    |UNSELACTDIR_WCP'='NUM_WCP','NUM_WCP';' { lconfig->setUnselDirAct( 0, $3 );
                                  lconfig->setUnselDirAct( 1, $5 ); } cols
    |SELACTFILE_WCP'='NUM_WCP','NUM_WCP';' { lconfig->setSelFileAct( 0, $3 );
                                 lconfig->setSelFileAct( 1, $5 ); } cols
    |UNSELACTFILE_WCP'='NUM_WCP','NUM_WCP';' { lconfig->setUnselFileAct( 0, $3 );
                                   lconfig->setUnselFileAct( 1, $5 ); } cols
    |LVHEADER_WCP'='NUM_WCP','NUM_WCP';' { lconfig->setLVHeader( 0, $3 );
                                lconfig->setLVHeader( 1, $5 ); } cols
    |LVBG_WCP'='NUM_WCP';' { lconfig->setListerBG( $3 ); } cols
    |TEXTVIEW_WCP'='NUM_WCP','NUM_WCP';' {
        WConfig::ColorDef c = lconfig->getColorDefs();
        c.setTextViewTextColor( $3 );
        c.setTextViewBackground( $5 );
        lconfig->setColorDefs( c ); } cols
    |TEXTVIEWHIGHLIGHTED_WCP'='NUM_WCP','NUM_WCP';' {
        WConfig::ColorDef c = lconfig->getColorDefs();
        c.setTextViewHighlightedFG( $3 );
        c.setTextViewHighlightedBG( $5 );
        lconfig->setColorDefs( c ); } cols
    |TEXTVIEWSELECTION_WCP'='NUM_WCP','NUM_WCP';' {
        WConfig::ColorDef c = lconfig->getColorDefs();
        c.setTextViewSelectionFG( $3 );
        c.setTextViewSelectionBG( $5 );
        lconfig->setColorDefs( c ); } cols
    |;

startup:LEFT_WCP'='STRING_WCP';' { lconfig->setStartDir( 0, $3 ); } startup
       |RIGHT_WCP'='STRING_WCP';' { lconfig->setStartDir( 1, $3 ); } startup
       |;

paths:PATH_WCP LEFTBRACE_WCP { lconfig_p1 = new WCPath(); }
      path RIGHTBRACE_WCP { lconfig_p1->setCheck( true );
                        while ( lconfig_listp->size() < ( lconfig_pos + 1 ) ) lconfig_listp->addElement( new WCPath() );
                        lconfig_p1 = (WCPath*)lconfig_listp->exchangeElement( lconfig_pos, lconfig_p1 );
                        delete lconfig_p1;
                        lconfig_p1 = NULL;
                      } paths
     |;

path:POSITION_WCP'='NUM_WCP';' { lconfig_pos = $3;
                         if ( lconfig_pos < 0 ) lconfig_pos = 0;
                         if ( lconfig_pos > 10240 ) lconfig_pos = 10240;
                       } path
    |TITLE_WCP'='STRING_WCP';' { lconfig_p1->setName( $3 ); } path
    |COLOR_WCP'='NUM_WCP','NUM_WCP';' { lconfig_p1->setFG( $3 );
                            lconfig_p1->setBG( $5 );
                          } path
    |PATH_WCP'='STRING_WCP';' { lconfig_p1->setPath( $3 ); } path
    |SHORTKEYS_WCP LEFTBRACE_WCP { lconfig_listsk = new List(); }
     keylist RIGHTBRACE_WCP { lconfig_p1->setDoubleKeys( lconfig_listsk );
                              lconfig_id = lconfig_listsk->initEnum();
                              lconfig_dk = (WCDoubleShortkey*)lconfig_listsk->getFirstElement( lconfig_id );
                              while ( lconfig_dk != NULL ) {
                                delete lconfig_dk;
                                lconfig_listsk->removeFirstElement();
                                lconfig_dk = (WCDoubleShortkey*)lconfig_listsk->getFirstElement( lconfig_id );
                              }
                              lconfig_listsk->closeEnum( lconfig_id );
                              delete lconfig_listsk;
                              lconfig_listsk = NULL;
                            } path
    |;

keylist:NORMAL_WCP LEFTBRACE_WCP { lconfig_dk = new WCDoubleShortkey();
                                   lconfig_dk->setType( WCDoubleShortkey::WCDS_NORMAL );
                                 }
        KEY_WCP'='STRING_WCP';' { lconfig_nkeysym = AGUIX::getKeySymForString( $6 );
                          if ( lconfig_nkeysym != NoSymbol ) lconfig_dk->setKeySym( lconfig_nkeysym, 0 );
                          else lconfig_dk->setKeySym( 0, 0 );  /*TODO:Fehler printen?*/
                          lconfig_keymod = 0;
                        }
        mods { lconfig_dk->setMod( lconfig_keymod, 0 ); }
        RIGHTBRACE_WCP { lconfig_listsk->addElement( lconfig_dk ); }
        keylist
       |DOUBLE_WCP LEFTBRACE_WCP { lconfig_dk = new WCDoubleShortkey();
                                   lconfig_dk->setType( WCDoubleShortkey::WCDS_DOUBLE );
                                  }
        KEY_WCP'='STRING_WCP';' { lconfig_nkeysym = AGUIX::getKeySymForString( $6 );
                          if ( lconfig_nkeysym != NoSymbol ) lconfig_dk->setKeySym( lconfig_nkeysym, 0 );
                          else lconfig_dk->setKeySym( 0, 0 );  /*TODO:Fehler printen?*/
                          lconfig_keymod = 0;
                        }
        mods { lconfig_dk->setMod( lconfig_keymod, 0 ); /*TODO:finzt das so mit dem lconfig_keymod?*/}
        KEY_WCP'='STRING_WCP';' { lconfig_nkeysym = AGUIX::getKeySymForString( $13 );
                          if ( lconfig_nkeysym != NoSymbol ) lconfig_dk->setKeySym( lconfig_nkeysym, 1 );
                          else lconfig_dk->setKeySym( 0, 1 );  /*TODO:Fehler printen?*/
                          lconfig_keymod = 0;
                        }
        mods { lconfig_dk->setMod( lconfig_keymod, 1 ); }
        RIGHTBRACE_WCP { lconfig_listsk->addElement( lconfig_dk ); }
        keylist
       |;

mods:MOD_WCP'='CONTROL_WCP';' { lconfig_keymod |= ControlMask; } mods
    |MOD_WCP'='SHIFT_WCP';' { lconfig_keymod |= ShiftMask; } mods
    |MOD_WCP'='LOCK_WCP';' { lconfig_keymod |= LockMask; } mods
    |MOD_WCP'='MOD1_WCP';' { lconfig_keymod |= Mod1Mask; } mods
    |MOD_WCP'='MOD2_WCP';' { lconfig_keymod |= Mod2Mask; } mods
    |MOD_WCP'='MOD3_WCP';' { lconfig_keymod |= Mod3Mask; } mods
    |MOD_WCP'='MOD4_WCP';' { lconfig_keymod |= Mod4Mask; } mods
    |MOD_WCP'='MOD5_WCP';' { lconfig_keymod |= Mod5Mask; } mods
    |;

filetypes:FILETYPE_WCP LEFTBRACE_WCP { lconfig_ft1 = new WCFiletype(); }
          filetype RIGHTBRACE_WCP { lconfig_listft->addElement( lconfig_ft1 );
                                lconfig_ft1 = NULL;
                              } filetypes
         |IGNOREDIRS_WCP LEFTBRACE_WCP { lconfig_ignorelist = new List(); }
          ignoredirs RIGHTBRACE_WCP { lconfig->setDontCheckDirs( lconfig_ignorelist );
                                  lconfig_id = lconfig_ignorelist->initEnum();
                                  lconfig_tstr = (char*)lconfig_ignorelist->getFirstElement( lconfig_id );
                                  while ( lconfig_tstr != NULL ) {
                                    _freesafe( lconfig_tstr );
                                    lconfig_tstr = (char*)lconfig_ignorelist->getNextElement( lconfig_id );
                                  }
                                  lconfig_ignorelist->closeEnum( lconfig_id );
                                  delete lconfig_ignorelist;
                                  lconfig_ignorelist = NULL;
                                 } filetypes
	 |DONTCHECKVIRTUAL_WCP'='bool';' { lconfig->setDontCheckVirtual( ( ( $3 ) == 1 ) ? true : false ); } filetypes
         |;

ignoredirs:STRING_WCP';' { lconfig_ignorelist->addElement( dupstring( $1 ) ); } ignoredirs
          |;

subfiletypes:FILETYPE_WCP LEFTBRACE_WCP { filetypehier.push_back( lconfig_ft1 );
                                          lconfig_ft1 = new WCFiletype();
                                        }
             filetype RIGHTBRACE_WCP { old_lconfig_ft1 = filetypehier.back();
	                               filetypehier.pop_back();
				       if ( old_lconfig_ft1 != NULL ) {
					 old_lconfig_ft1->addSubType( lconfig_ft1 );
				       } else {
					 delete lconfig_ft1;
				       }
				       lconfig_ft1 = old_lconfig_ft1;
	                             } subfiletypes
            |;

filetype:TYPE_WCP'='ft_type';' { lconfig_ft1->setinternID( $3 ); } filetype
        |TITLE_WCP'='STRING_WCP';' { lconfig_ft1->setName( $3 ); } filetype
        |PATTERN_WCP'='STRING_WCP';' { lconfig_ft1->setPattern( $3 ); } filetype
        |USEPATTERN_WCP'='bool';' { lconfig_ft1->setUsePattern( ( ( $3 ) == 1 ) ? true : false ); } filetype
        |CONTENT_WCP LEFTBRACE_WCP { lconfig_ft1->clearFiledesc(); }
         filecontent RIGHTBRACE_WCP filetype
        |USECONTENT_WCP'='bool';' { lconfig_ft1->setUseFiledesc( ( ( $3 ) == 1 ) ? true : false ); } filetype
        |PATTERNIGNORECASE_WCP'='bool';' { lconfig_ft1->setPatternIgnoreCase( ( ( $3 ) == 1 ) ? true : false ); } filetype
        |PATTERNUSEREGEXP_WCP'='bool';' { lconfig_ft1->setPatternUseRegExp( ( ( $3 ) == 1 ) ? true : false ); } filetype
        |PATTERNUSEFULLNAME_WCP'='bool';' { lconfig_ft1->setPatternUseFullname( ( ( $3 ) == 1 ) ? true : false ); } filetype
        |FTCOMMANDS_WCP LEFTBRACE_WCP ftcommands RIGHTBRACE_WCP filetype
        |EXTCOND_WCP'='STRING_WCP';' { lconfig_ft1->setExtCond( $3 ); } filetype
        |USEEXTCOND_WCP'='bool';' { lconfig_ft1->setUseExtCond( ( ( $3 ) == 1 ) ? true : false ); } filetype
	|SUBTYPE_WCP LEFTBRACE_WCP subfiletypes RIGHTBRACE_WCP filetype
	|UNSELECTCOLOR_WCP'='NUM_WCP','NUM_WCP';' { lconfig_ft1->setCustomColor( 0, 0, $3 );
	                                            lconfig_ft1->setCustomColor( 1, 0, $5 );
                                                  } filetype
	|SELECTCOLOR_WCP'='NUM_WCP','NUM_WCP';' { lconfig_ft1->setCustomColor( 0, 1, $3 );
	                                          lconfig_ft1->setCustomColor( 1, 1, $5 );
                                                } filetype
	|UNSELECTACTIVECOLOR_WCP'='NUM_WCP','NUM_WCP';' { lconfig_ft1->setCustomColor( 0, 2, $3 );
	                                                  lconfig_ft1->setCustomColor( 1, 2, $5 );
                                                        } filetype
	|SELECTACTIVECOLOR_WCP'='NUM_WCP','NUM_WCP';' { lconfig_ft1->setCustomColor( 0, 3, $3 );
	                                                lconfig_ft1->setCustomColor( 1, 3, $5 );
                                                      } filetype
        |COLOREXTERNPROG_WCP'='STRING_WCP';' { lconfig_ft1->setColorExt( $3 ); } filetype
        |COLORMODE_WCP'='DEFAULT_WCP';' { lconfig_ft1->setColorMode( WCFiletype::DEFAULTCOL ); } filetype
        |COLORMODE_WCP'='CUSTOM_WCP';' { lconfig_ft1->setColorMode( WCFiletype::CUSTOMCOL ); } filetype
        |COLORMODE_WCP'='EXTERN_WCP';' { lconfig_ft1->setColorMode( WCFiletype::EXTERNALCOL ); } filetype
        |COLORMODE_WCP'='PARENT_WCP';' { lconfig_ft1->setColorMode( WCFiletype::PARENTCOL ); } filetype
        |MAGICPATTERN_WCP'='STRING_WCP';' { lconfig_ft1->setMagicPattern( $3 ); } filetype
        |USEMAGIC_WCP'='bool';' { lconfig_ft1->setUseMagic( ( ( $3 ) == 1 ) ? true : false ); } filetype
        |;

filecontent:NUM_WCP'='NUM_WCP';' { lconfig_ft1->setFiledesc( $1, $3 ); } filecontent
           |;

ft_type:NORMAL_WCP { $$ = NORMALTYPE; }
       |NOTYETCHECKED_WCP { $$ = NOTYETTYPE; }
       |UNKNOWN_WCP { $$ = UNKNOWNTYPE; }
       |NOSELECT_WCP { $$ = VOIDTYPE; }
       |DIR_WCP { $$ = DIRTYPE; }
       ;

ftcommands:DND_WCP LEFTBRACE_WCP { lconfig_listcom = new List(); }
           commands RIGHTBRACE_WCP { lconfig_ft1->setDNDActions( lconfig_listcom );
                                 lconfig_id = lconfig_listcom->initEnum();
                                 lconfig_fp1 = (FunctionProto*)lconfig_listcom->getFirstElement( lconfig_id );
                                 while ( lconfig_fp1 != NULL ) {
                                   delete lconfig_fp1;
                                   lconfig_listcom->removeFirstElement();
                                   lconfig_fp1 = (FunctionProto*)lconfig_listcom->getFirstElement( lconfig_id );
                                 }
                                 lconfig_listcom->closeEnum( lconfig_id );
                                 delete lconfig_listcom;
                                 lconfig_listcom = NULL;
                                 //TODO: ggf. noch die Flags uebertragen
                               } ftcommands
          |DC_WCP LEFTBRACE_WCP { lconfig_listcom = new List(); }
           commands RIGHTBRACE_WCP { lconfig_ft1->setDoubleClickActions( lconfig_listcom );
                                 lconfig_id = lconfig_listcom->initEnum();
                                 lconfig_fp1 = (FunctionProto*)lconfig_listcom->getFirstElement( lconfig_id );
                                 while ( lconfig_fp1 != NULL ) {
                                   delete lconfig_fp1;
                                   lconfig_listcom->removeFirstElement();
                                   lconfig_fp1 = (FunctionProto*)lconfig_listcom->getFirstElement( lconfig_id );
                                 }
                                 lconfig_listcom->closeEnum( lconfig_id );
                                 delete lconfig_listcom;
                                 lconfig_listcom = NULL;
                                 //TODO: ggf. noch die Flags uebertragen
                               } ftcommands
          |SHOW_WCP LEFTBRACE_WCP { lconfig_listcom = new List(); }
           commands RIGHTBRACE_WCP { lconfig_ft1->setShowActions( lconfig_listcom );
                                 lconfig_id = lconfig_listcom->initEnum();
                                 lconfig_fp1 = (FunctionProto*)lconfig_listcom->getFirstElement( lconfig_id );
                                 while ( lconfig_fp1 != NULL ) {
                                   delete lconfig_fp1;
                                   lconfig_listcom->removeFirstElement();
                                   lconfig_fp1 = (FunctionProto*)lconfig_listcom->getFirstElement( lconfig_id );
                                 }
                                 lconfig_listcom->closeEnum( lconfig_id );
                                 delete lconfig_listcom;
                                 lconfig_listcom = NULL;
                                 //TODO: ggf. noch die Flags uebertragen
                               } ftcommands
          |RAWSHOW_WCP LEFTBRACE_WCP { lconfig_listcom = new List(); }
           commands RIGHTBRACE_WCP { lconfig_ft1->setRawShowActions( lconfig_listcom );
                                 lconfig_id = lconfig_listcom->initEnum();
                                 lconfig_fp1 = (FunctionProto*)lconfig_listcom->getFirstElement( lconfig_id );
                                 while ( lconfig_fp1 != NULL ) {
                                   delete lconfig_fp1;
                                   lconfig_listcom->removeFirstElement();
                                   lconfig_fp1 = (FunctionProto*)lconfig_listcom->getFirstElement( lconfig_id );
                                 }
                                 lconfig_listcom->closeEnum( lconfig_id );
                                 delete lconfig_listcom;
                                 lconfig_listcom = NULL;
                                 //TODO: ggf. noch die Flags uebertragen
                               } ftcommands
          |USER_WCP NUM_WCP LEFTBRACE_WCP { lconfig_listcom = new List(); }
           commands RIGHTBRACE_WCP { lconfig_ft1->setUserActions( $2, lconfig_listcom );
                                 lconfig_id = lconfig_listcom->initEnum();
                                 lconfig_fp1 = (FunctionProto*)lconfig_listcom->getFirstElement( lconfig_id );
                                 while ( lconfig_fp1 != NULL ) {
                                   delete lconfig_fp1;
                                   lconfig_listcom->removeFirstElement();
                                   lconfig_fp1 = (FunctionProto*)lconfig_listcom->getFirstElement( lconfig_id );
                                 }
                                 lconfig_listcom->closeEnum( lconfig_id );
                                 delete lconfig_listcom;
                                 lconfig_listcom = NULL;
                                 //TODO: ggf. noch die Flags uebertragen
                               } ftcommands
          |CUSTOMACTION_WCP LEFTBRACE_WCP { lconfig_listcom = new List(); }
           NAME_WCP'='STRING_WCP';'
           COMMANDS_WCP LEFTBRACE_WCP
           commands RIGHTBRACE_WCP RIGHTBRACE_WCP { lconfig_ft1->setCustomActions( $6, lconfig_listcom );
                                 lconfig_id = lconfig_listcom->initEnum();
                                 lconfig_fp1 = (FunctionProto*)lconfig_listcom->getFirstElement( lconfig_id );
                                 while ( lconfig_fp1 != NULL ) {
                                   delete lconfig_fp1;
                                   lconfig_listcom->removeFirstElement();
                                   lconfig_fp1 = (FunctionProto*)lconfig_listcom->getFirstElement( lconfig_id );
                                 }
                                 lconfig_listcom->closeEnum( lconfig_id );
                                 delete lconfig_listcom;
                                 lconfig_listcom = NULL;
                               } ftcommands
          |;

commands:command commands
        |FLAGS_WCP LEFTBRACE_WCP flags RIGHTBRACE_WCP commands
	|;

flags:;

hotkeys:HOTKEY_WCP LEFTBRACE_WCP { lconfig_hk1 = new WCHotkey(); }
        hotkey RIGHTBRACE_WCP { lconfig_listh->addElement( lconfig_hk1 );
                            lconfig_hk1 = NULL;
                          } hotkeys
       |;

hotkey:TITLE_WCP'='STRING_WCP';' { lconfig_hk1->setName( $3 ); } hotkey
      |COMMANDS_WCP LEFTBRACE_WCP { lconfig_listcom = new List(); }
       commands RIGHTBRACE_WCP { lconfig_hk1->setComs( lconfig_listcom );
                             lconfig_id = lconfig_listcom->initEnum();
                             lconfig_fp1 = (FunctionProto*)lconfig_listcom->getFirstElement( lconfig_id );
                             while ( lconfig_fp1 != NULL ) {
                               delete lconfig_fp1;
                               lconfig_listcom->removeFirstElement();
                               lconfig_fp1 = (FunctionProto*)lconfig_listcom->getFirstElement( lconfig_id );
                             }
                             lconfig_listcom->closeEnum( lconfig_id );
                             delete lconfig_listcom;
                             lconfig_listcom = NULL;
                             //TODO: ggf. noch die Flags uebertragen
                           } hotkey
      |SHORTKEYS_WCP LEFTBRACE_WCP { lconfig_listsk = new List(); }
       keylist RIGHTBRACE_WCP { lconfig_hk1->setDoubleKeys( lconfig_listsk );
                            lconfig_id = lconfig_listsk->initEnum();
                            lconfig_dk = (WCDoubleShortkey*)lconfig_listsk->getFirstElement( lconfig_id );
                            while ( lconfig_dk != NULL ) {
                              delete lconfig_dk;
                              lconfig_listsk->removeFirstElement();
                              lconfig_dk = (WCDoubleShortkey*)lconfig_listsk->getFirstElement( lconfig_id );
                            }
                            lconfig_listsk->closeEnum( lconfig_id );
                            delete lconfig_listsk;
                            lconfig_listsk = NULL;
                          } hotkey
      |;

buttons:BUTTON_WCP LEFTBRACE_WCP { lconfig_bt1 = new WCButton(); }
        button RIGHTBRACE_WCP { lconfig_bt1->setCheck( true );
                            while ( lconfig_listb->size() < ( lconfig_pos + 1 ) ) lconfig_listb->addElement( new WCButton() );
                            lconfig_bt1 = (WCButton*)lconfig_listb->exchangeElement( lconfig_pos, lconfig_bt1 );
                            delete lconfig_bt1;
                            lconfig_bt1 = NULL;
                          } buttons
       |;

button:POSITION_WCP'='NUM_WCP';' { lconfig_pos = $3;
                           if ( lconfig_pos < 0 ) lconfig_pos = 0;
                           if ( lconfig_pos > 100000 ) lconfig_pos = 100000;
                         } button
      |TITLE_WCP'='STRING_WCP';'{ lconfig_bt1->setText( $3 ); } button
      |COLOR_WCP'='NUM_WCP','NUM_WCP';' { lconfig_bt1->setFG( $3 );
                              lconfig_bt1->setBG( $5 );
                            } button
      |COMMANDS_WCP LEFTBRACE_WCP { lconfig_listcom = new List(); }
       commands RIGHTBRACE_WCP { lconfig_bt1->setComs( lconfig_listcom );
                             lconfig_id = lconfig_listcom->initEnum();
                             lconfig_fp1 = (FunctionProto*)lconfig_listcom->getFirstElement( lconfig_id );
                             while ( lconfig_fp1 != NULL ) {
                               delete lconfig_fp1;
                               lconfig_listcom->removeFirstElement();
                               lconfig_fp1 = (FunctionProto*)lconfig_listcom->getFirstElement( lconfig_id );
                             }
                             lconfig_listcom->closeEnum( lconfig_id );
                             delete lconfig_listcom;
                             lconfig_listcom = NULL;
                             //TODO: ggf. noch die Flags uebertragen
                           } button
      |SHORTKEYS_WCP LEFTBRACE_WCP { lconfig_listsk = new List(); }
       keylist RIGHTBRACE_WCP { lconfig_bt1->setDoubleKeys( lconfig_listsk );
                            lconfig_id = lconfig_listsk->initEnum();
                            lconfig_dk = (WCDoubleShortkey*)lconfig_listsk->getFirstElement( lconfig_id );
                            while ( lconfig_dk != NULL ) {
                              delete lconfig_dk;
                              lconfig_listsk->removeFirstElement();
                             lconfig_dk = (WCDoubleShortkey*)lconfig_listsk->getFirstElement( lconfig_id );
                            }
                            lconfig_listsk->closeEnum( lconfig_id );
                            delete lconfig_listsk;
                            lconfig_listsk = NULL;
                          } button
      |;

fonts:GLOBALFONT_WCP'='STRING_WCP';'
      {
#ifndef HAVE_XFT
        lconfig->setFont( 0, $3 );
#endif
        lconfig->setFontName( WConfig::FONT_X11_GLOBAL, $3 );
      } fonts
     |BUTTONFONT_WCP'='STRING_WCP';'
      {
#ifndef HAVE_XFT
        lconfig->setFont( 1, $3 );
#endif
        lconfig->setFontName( WConfig::FONT_X11_BUTTONS, $3 );
      } fonts
     |LEFTFONT_WCP'='STRING_WCP';'
      {
#ifndef HAVE_XFT
        lconfig->setFont( 2, $3 );
#endif
        lconfig->setFontName( WConfig::FONT_X11_LEFT, $3 );
      } fonts
     |RIGHTFONT_WCP'='STRING_WCP';'
      {
#ifndef HAVE_XFT
        lconfig->setFont( 3, $3 );
#endif
        lconfig->setFontName( WConfig::FONT_X11_RIGHT, $3 );
      } fonts
     |;

xftfonts:GLOBALFONT_WCP'='STRING_WCP';'
         {
#ifdef HAVE_XFT
           lconfig->setFont( 0, $3 );
#endif
           lconfig->setFontName( WConfig::FONT_XFT_GLOBAL, $3 );
         } xftfonts
        |BUTTONFONT_WCP'='STRING_WCP';'
         {
#ifdef HAVE_XFT
           lconfig->setFont( 1, $3 );
#endif
           lconfig->setFontName( WConfig::FONT_XFT_BUTTONS, $3 );
         } xftfonts
        |LEFTFONT_WCP'='STRING_WCP';'
         {
#ifdef HAVE_XFT
           lconfig->setFont( 2, $3 );
#endif
           lconfig->setFontName( WConfig::FONT_XFT_LEFT, $3 );
         } xftfonts
        |RIGHTFONT_WCP'='STRING_WCP';'
         {
#ifdef HAVE_XFT
           lconfig->setFont( 3, $3 );
#endif
           lconfig->setFontName( WConfig::FONT_XFT_RIGHT, $3 );
         } xftfonts
        |;

clockbarsets:MODUS_WCP'='TIMESPACE_WCP';' { lconfig->setClockbarMode( WConfig::CLOCKBAR_MODE_TIMERAM ); } clockbarsets
            |MODUS_WCP'='TIME_WCP';' { lconfig->setClockbarMode( WConfig::CLOCKBAR_MODE_TIME ); } clockbarsets
            |MODUS_WCP'='VERSION_WCP';' { lconfig->setClockbarMode( WConfig::CLOCKBAR_MODE_VERSION ); } clockbarsets
            |MODUS_WCP'='EXTERN_WCP';' { lconfig->setClockbarMode( WConfig::CLOCKBAR_MODE_EXTERN ); } clockbarsets
            |UPDATETIME_WCP'='NUM_WCP';' { lconfig->setClockbarUpdatetime( $3 ); } clockbarsets
            |PROGRAM_WCP'='STRING_WCP';' { lconfig->setClockbarCommand( $3 ); } clockbarsets
            |;

bool:YES_WCP { $$ = 1; }
    |NO_WCP { $$ = 0; };

command:ownop
       |dndaction
       |dcaction
       |showaction
       |rshowaction
       |useraction
       |rowup
       |rowdown
       |changehiddenflag
       |copyop
       |firstrow
       |lastrow
       |pageup
       |pagedown
       |selectop
       |selectallop
       |selectnoneop
       |invertallop
       |parentdirop
       |enterdirop
       |changelistersetop
       |switchlisterop
       |filterselectop
       |filterunselectop
       |pathtoothersideop
       |quitop
       |deleteop
       |reloadop
       |makedirop
       |renameop
       |dirsizeop
       |simddop
       |startprogop
       |searchentryop
       |enterpathop
       |scrolllisterop
       |createsymlinkop
       |changesymlinkop
       |chmodop
       |togglelistermodeop
       |setsortmodeop
       |setfilterop
       |shortkeyfromlistop
       |chownop
       |scriptop
       |showdircacheop
       |parentactionop
       |nooperationop
       |goftpop
       |internalviewop
       |searchop
       |dirbookmarkop
       |opencontextmenuop
       |runcustomaction
       |openworkermenuop;

ownop:OWNOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new OwnOp(); }
      ownopbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

ownopbody:COM_WCP'='STRING_WCP';' { ((OwnOp*)lconfig_fp1)->setComStr( $3 ); } ownopbody
         |SEPARATEEACHENTRY_WCP'='bool';' { ((OwnOp*)lconfig_fp1)->setSeparateEachEntry( ( ( $3 ) == 1 ) ? true : false ); } ownopbody
         |RECURSIVE_WCP'='bool';' { ((OwnOp*)lconfig_fp1)->setRecursive( ( ( $3 ) == 1 ) ? true : false ); } ownopbody
         |START_WCP'='TERMINAL_WCP';' { ((OwnOp*)lconfig_fp1)->setOwnStart( OwnOp::OWNOP_START_IN_TERMINAL ); } ownopbody
         |START_WCP'='TERMINALWAIT_WCP';' { ((OwnOp*)lconfig_fp1)->setOwnStart( OwnOp::OWNOP_START_IN_TERMINAL_AND_WAIT4KEY ); } ownopbody
         |START_WCP'='SHOWOUTPUT_WCP';' { ((OwnOp*)lconfig_fp1)->setOwnStart( OwnOp::OWNOP_SHOW_OUTPUT ); } ownopbody
         |START_WCP'='NORMAL_WCP';' { ((OwnOp*)lconfig_fp1)->setOwnStart( OwnOp::OWNOP_START_NORMAL ); } ownopbody
         |VIEWSTR_WCP'='STRING_WCP';' { ((OwnOp*)lconfig_fp1)->setViewStr( $3 ); } ownopbody
         |INBACKGROUND_WCP'='bool';' { ((OwnOp*)lconfig_fp1)->setInBackground( ( ( $3 ) == 1 ) ? true : false ); } ownopbody
         |TAKEDIRS_WCP'='bool';' { ((OwnOp*)lconfig_fp1)->setTakeDirs( ( ( $3 ) == 1 ) ? true : false ); } ownopbody
         |DONTCD_WCP'='bool';' { ((OwnOp*)lconfig_fp1)->setDontCD( ( ( $3 ) == 1 ) ? true : false ); } ownopbody
         |;

dndaction:DNDACTION_WCP LEFTBRACE_WCP { lconfig_fp1 = new DNDAction(); }
          RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

dcaction:DCACTION_WCP LEFTBRACE_WCP { lconfig_fp1 = new DoubleClickAction(); }
         RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

showaction:SHOWACTION_WCP LEFTBRACE_WCP { lconfig_fp1 = new ShowAction(); }
           RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

rshowaction:RSHOWACTION_WCP LEFTBRACE_WCP { lconfig_fp1 = new RawShowAction(); }
            RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

useraction:USERACTION_WCP LEFTBRACE_WCP { lconfig_fp1 = new UserAction(); }
           useractionbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

useractionbody:ACTIONNUMBER_WCP'='NUM_WCP';' { ((UserAction*)lconfig_fp1)->setNr( $3 ); } useractionbody
              |;

rowup:ROWUP_WCP LEFTBRACE_WCP { lconfig_fp1 = new RowUp(); }
      RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

rowdown:ROWDOWN_WCP LEFTBRACE_WCP { lconfig_fp1 = new RowDown(); }
        RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

changehiddenflag:CHANGEHIDDENFLAG_WCP LEFTBRACE_WCP { lconfig_fp1 = new ChangeHiddenFlag(); }
                 changehiddenflagbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

changehiddenflagbody:HIDDENFILES_WCP'='SHOW_WCP';' { ((ChangeHiddenFlag*)lconfig_fp1)->setMode( 2 ); } changehiddenflagbody
                    |HIDDENFILES_WCP'='HIDE_WCP';' { ((ChangeHiddenFlag*)lconfig_fp1)->setMode( 1 ); } changehiddenflagbody
                    |HIDDENFILES_WCP'='TOGGLE_WCP';' { ((ChangeHiddenFlag*)lconfig_fp1)->setMode( 0 ); } changehiddenflagbody
                    |;

copyop:COPYOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new CopyOp(); }
       copyopbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

copyopbody:FOLLOWSYMLINKS_WCP'='bool';' { ((CopyOp*)lconfig_fp1)->setFollowSymlinks( ( ( $3 ) == 1 ) ? true : false ); } copyopbody
          |MOVE_WCP'='bool';' { ((CopyOp*)lconfig_fp1)->setMove( ( ( $3 ) == 1 ) ? true : false ); } copyopbody
          |RENAME_WCP'='bool';' { ((CopyOp*)lconfig_fp1)->setRename( ( ( $3 ) == 1 ) ? true : false ); } copyopbody
          |SAMEDIR_WCP'='bool';' { ((CopyOp*)lconfig_fp1)->setSameDir( ( ( $3 ) == 1 ) ? true : false ); } copyopbody
          |REQUESTDEST_WCP'='bool';' { ((CopyOp*)lconfig_fp1)->setRequestDest( ( ( $3 ) == 1 ) ? true : false ); } copyopbody
          |REQUESTFLAGS_WCP'='bool';' { ((CopyOp*)lconfig_fp1)->setRequestFlags( ( ( $3 ) == 1 ) ? true : false ); } copyopbody
          |OVERWRITE_WCP'='ALWAYS_WCP';' { ((CopyOp*)lconfig_fp1)->setOverwrite( CopyOp::COPYOP_OVERWRITE_ALWAYS ); } copyopbody
          |OVERWRITE_WCP'='NEVER_WCP';' { ((CopyOp*)lconfig_fp1)->setOverwrite( CopyOp::COPYOP_OVERWRITE_NEVER ); } copyopbody
          |OVERWRITE_WCP'='NORMAL_WCP';' { ((CopyOp*)lconfig_fp1)->setOverwrite( CopyOp::COPYOP_OVERWRITE_NORMAL ); } copyopbody
          |COPYMODE_WCP'='NORMAL_WCP';' { ((CopyOp*)lconfig_fp1)->setFastcopy( CopyOp::COPYOP_NORMALCOPY ); } copyopbody
          |COPYMODE_WCP'='FAST_WCP';' { ((CopyOp*)lconfig_fp1)->setFastcopy( CopyOp::COPYOP_FASTCOPY ); } copyopbody
/*          |COPYMODE_WCP'='FASTEST';' { ((CopyOp*)lconfig_fp1)->setFastcopy( CopyOp::COPYOP_FASTESTCOPY ); } copyopbody*/
          |PRESERVEATTR_WCP'='bool';' { ((CopyOp*)lconfig_fp1)->setPreserveAttr( ( ( $3 ) == 1 ) ? true : false ); } copyopbody
          |;

firstrow:FIRSTROW_WCP LEFTBRACE_WCP { lconfig_fp1 = new FirstRow(); }
         RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

lastrow:LASTROW_WCP LEFTBRACE_WCP { lconfig_fp1 = new LastRow(); }
        RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

pageup:PAGEUP_WCP LEFTBRACE_WCP { lconfig_fp1 = new PageUp(); }
       RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

pagedown:PAGEDOWN_WCP LEFTBRACE_WCP { lconfig_fp1 = new PageDown(); }
         RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

selectop:SELECTOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new SelectOp(); }
         RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

selectallop:SELECTALLOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new SelectAllOp(); }
            RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

selectnoneop:SELECTNONEOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new SelectNoneOp(); }
             RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

invertallop:INVERTALLOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new InvertAllOp(); }
            RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

parentdirop:PARENTDIROP_WCP LEFTBRACE_WCP { lconfig_fp1 = new ParentDirOp(); }
            RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

enterdirop:ENTERDIROP_WCP LEFTBRACE_WCP { lconfig_fp1 = new EnterDirOp(); }
           enterdiropbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

enterdiropbody:DIR_WCP'='STRING_WCP';' { ((EnterDirOp*)lconfig_fp1)->setDir( $3 ); } enterdiropbody
              |MODE_WCP'='ACTIVE_WCP';' { ((EnterDirOp*)lconfig_fp1)->setMode( EnterDirOp::ENTERDIROP_ACTIVE ); } enterdiropbody
              |MODE_WCP'='ACTIVE2OTHER_WCP';' { ((EnterDirOp*)lconfig_fp1)->setMode( EnterDirOp::ENTERDIROP_ACTIVE2OTHER ); } enterdiropbody
              |MODE_WCP'='SPECIAL_WCP';' { ((EnterDirOp*)lconfig_fp1)->setMode( EnterDirOp::ENTERDIROP_SPECIAL ); } enterdiropbody
              |MODE_WCP'='REQUEST_WCP';' { ((EnterDirOp*)lconfig_fp1)->setMode( EnterDirOp::ENTERDIROP_REQUEST ); } enterdiropbody
              |;

changelistersetop:CHANGELISTERSETOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new ChangeListerSetOp(); }
                  changelistersetopbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

changelistersetopbody:MODE_WCP'='LEFT_WCP';' { ((ChangeListerSetOp*)lconfig_fp1)->setMode( ChangeListerSetOp::CLS_LEFT_LISTER ); } changelistersetopbody
                     |MODE_WCP'='RIGHT_WCP';' { ((ChangeListerSetOp*)lconfig_fp1)->setMode( ChangeListerSetOp::CLS_RIGHT_LISTER ); } changelistersetopbody
                     |MODE_WCP'='CURRENT_WCP';' { ((ChangeListerSetOp*)lconfig_fp1)->setMode( ChangeListerSetOp::CLS_CURRENT_LISTER ); } changelistersetopbody
                     |MODE_WCP'='OTHER_WCP';' { ((ChangeListerSetOp*)lconfig_fp1)->setMode( ChangeListerSetOp::CLS_OTHER_LISTER ); } changelistersetopbody
                     |;

switchlisterop:SWITCHLISTEROP_WCP LEFTBRACE_WCP { lconfig_fp1 = new SwitchListerOp(); }
               RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

filterselectop:FILTERSELECTOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new FilterSelectOp(); }
               filterselectopbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

filterselectopbody:FILTER_WCP'='STRING_WCP';' { ((FilterSelectOp*)lconfig_fp1)->setFilter( $3 ); } filterselectopbody
                  |;

filterunselectop:FILTERUNSELECTOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new FilterUnSelectOp(); }
                 filterunselectopbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

filterunselectopbody:FILTER_WCP'='STRING_WCP';' { ((FilterUnSelectOp*)lconfig_fp1)->setFilter( $3 ); } filterunselectopbody
                    |;

pathtoothersideop:PATHTOOTHERSIDEOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new Path2OSideOp(); }
                  RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

quitop:QUITOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new QuitOp(); }
       quitopbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

quitopbody:MODE_WCP'='NORMAL_WCP';' { ((QuitOp*)lconfig_fp1)->setMode( QuitOp::Q_NORMAL_QUIT ); } quitopbody
          |MODE_WCP'='QUICK_WCP';' { ((QuitOp*)lconfig_fp1)->setMode( QuitOp::Q_QUICK_QUIT ); } quitopbody
          |;

deleteop:DELETEOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new DeleteOp(); }
         deleteopbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

deleteopbody:ALSOACTIVE_WCP'='bool';' { ((DeleteOp*)lconfig_fp1)->setAlsoActive( ( ( $3 ) == 1 ) ? true : false ); } deleteopbody
            |;

reloadop:RELOADOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new ReloadOp(); }
         reloadopbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

reloadopbody:MODE_WCP'='LEFT_WCP';' { ((ReloadOp*)lconfig_fp1)->setReloadside( ReloadOp::RELOADOP_LEFTSIDE ); } reloadopbody
            |MODE_WCP'='RIGHT_WCP';' { ((ReloadOp*)lconfig_fp1)->setReloadside( ReloadOp::RELOADOP_RIGHTSIDE ); } reloadopbody
            |MODE_WCP'='CURRENT_WCP';' { ((ReloadOp*)lconfig_fp1)->setReloadside( ReloadOp::RELOADOP_THISSIDE ); } reloadopbody
            |MODE_WCP'='OTHER_WCP';' { ((ReloadOp*)lconfig_fp1)->setReloadside( ReloadOp::RELOADOP_OTHERSIDE ); } reloadopbody
            |RESETDIRSIZES_WCP'='bool';' { ((ReloadOp*)lconfig_fp1)->setResetDirSizes( ( ( $3 ) == 1 ) ? true : false ); } reloadopbody
            |KEEPFILETYPES_WCP'='bool';' { ((ReloadOp*)lconfig_fp1)->setKeepFiletypes( ( ( $3 ) == 1 ) ? true : false ); } reloadopbody
            |;

makedirop:MAKEDIROP_WCP LEFTBRACE_WCP { lconfig_fp1 = new MakeDirOp(); }
          RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

renameop:RENAMEOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new RenameOp(); }
         RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

dirsizeop:DIRSIZEOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new DirSizeOp(); }
          RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

simddop:SIMDDOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new SimDDOp(); }
        RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

startprogop:STARTPROGOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new StartProgOp(); }
            startprogopbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

startprogopbody:START_WCP'='TERMINAL_WCP';' { ((StartProgOp*)lconfig_fp1)->setStart( StartProgOp::STARTPROGOP_START_IN_TERMINAL ); } startprogopbody
               |START_WCP'='TERMINALWAIT_WCP';' { ((StartProgOp*)lconfig_fp1)->setStart( StartProgOp::STARTPROGOP_START_IN_TERMINAL_AND_WAIT4KEY ); } startprogopbody
               |START_WCP'='SHOWOUTPUT_WCP';' { ((StartProgOp*)lconfig_fp1)->setStart( StartProgOp::STARTPROGOP_SHOW_OUTPUT ); } startprogopbody
               |START_WCP'='NORMAL_WCP';' { ((StartProgOp*)lconfig_fp1)->setStart( StartProgOp::STARTPROGOP_START_NORMAL ); } startprogopbody
               |VIEWSTR_WCP'='STRING_WCP';' { ((StartProgOp*)lconfig_fp1)->setViewStr( $3 ); } startprogopbody
               |GLOBAL_WCP'='bool';' { ((StartProgOp*)lconfig_fp1)->setGlobal( ( ( $3 ) == 1 ) ? true : false ); } startprogopbody
               |REQUESTFLAGS_WCP'='bool';' { ((StartProgOp*)lconfig_fp1)->setRequestFlags( ( ( $3 ) == 1 ) ? true : false ); } startprogopbody
               |INBACKGROUND_WCP'='bool';' { ((StartProgOp*)lconfig_fp1)->setInBackground( ( ( $3 ) == 1 ) ? true : false ); } startprogopbody
               |DONTCD_WCP'='bool';' { ((StartProgOp*)lconfig_fp1)->setDontCD( ( ( $3 ) == 1 ) ? true : false ); } startprogopbody
               |;

searchentryop:SEARCHENTRYOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new SearchEntryOp(); }
              searchentryopbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

searchentryopbody:IGNORECASE_WCP'='bool';' { ((SearchEntryOp*)lconfig_fp1)->setIgnoreCase( ( ( $3 ) == 1 ) ? true : false ); } searchentryopbody
                 |REVERSESEARCH_WCP'='bool';' { ((SearchEntryOp*)lconfig_fp1)->setReverseSearch( ( ( $3 ) == 1 ) ? true : false ); } searchentryopbody
                 |;

enterpathop:ENTERPATHOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new EnterPathOp(); }
            enterpathopbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

enterpathopbody:MODE_WCP'='LEFT_WCP';' { ((EnterPathOp*)lconfig_fp1)->setSide( EnterPathOp::ENTERPATHOP_LEFTSIDE ); } enterpathopbody
               |MODE_WCP'='RIGHT_WCP';' { ((EnterPathOp*)lconfig_fp1)->setSide( EnterPathOp::ENTERPATHOP_RIGHTSIDE ); } enterpathopbody
               |MODE_WCP'='CURRENT_WCP';' { ((EnterPathOp*)lconfig_fp1)->setSide( EnterPathOp::ENTERPATHOP_THISSIDE ); } enterpathopbody
               |MODE_WCP'='OTHER_WCP';' { ((EnterPathOp*)lconfig_fp1)->setSide( EnterPathOp::ENTERPATHOP_OTHERSIDE ); } enterpathopbody
               |;

scrolllisterop:SCROLLLISTEROP_WCP LEFTBRACE_WCP { lconfig_fp1 = new ScrollListerOp(); }
               scrolllisteropbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

scrolllisteropbody:MODE_WCP'='LEFT_WCP';' { ((ScrollListerOp*)lconfig_fp1)->setDir( ScrollListerOp::SCROLLLISTEROP_LEFT ); } scrolllisteropbody
                  |MODE_WCP'='RIGHT_WCP';' { ((ScrollListerOp*)lconfig_fp1)->setDir( ScrollListerOp::SCROLLLISTEROP_RIGHT ); } scrolllisteropbody
                  |;

createsymlinkop:CREATESYMLINKOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new CreateSymlinkOp(); }
                createsymlinkopbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

createsymlinkopbody:SAMEDIR_WCP'='bool';' { ((CreateSymlinkOp*)lconfig_fp1)->setSameDir( ( ( $3 ) == 1 ) ? true : false ); } createsymlinkopbody
                   |RELATIVE_WCP'='bool';' { ((CreateSymlinkOp*)lconfig_fp1)->setLocal( ( ( $3 ) == 1 ) ? true : false ); } createsymlinkopbody
                   |REQUESTFLAGS_WCP'='bool';' { ((CreateSymlinkOp*)lconfig_fp1)->setRequestFlags( ( ( $3 ) == 1 ) ? true : false ); } createsymlinkopbody
                   |;

changesymlinkop:CHANGESYMLINKOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new ChangeSymlinkOp(); }
                RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

chmodop:CHMODOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new ChModOp(); }
        chmodopbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

chmodopbody:ONFILES_WCP'='bool';' { ((ChModOp*)lconfig_fp1)->setOnFiles( ( ( $3 ) == 1 ) ? true : false ); } chmodopbody
           |ONDIRS_WCP'='bool';' { ((ChModOp*)lconfig_fp1)->setOnDirs( ( ( $3 ) == 1 ) ? true : false ); } chmodopbody
           |RECURSIVE_WCP'='bool';' { ((ChModOp*)lconfig_fp1)->setRecursive( ( ( $3 ) == 1 ) ? true : false ); } chmodopbody
           |REQUESTFLAGS_WCP'='bool';' { ((ChModOp*)lconfig_fp1)->setRequestFlags( ( ( $3 ) == 1 ) ? true : false ); } chmodopbody
           |;

togglelistermodeop:TOGGLELISTERMODEOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new ToggleListermodeOp(); }
                   togglelistermodeopbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

togglelistermodeopbody:MODE_WCP'='STRING_WCP';' { ((ToggleListermodeOp*)lconfig_fp1)->setMode( Worker::getID4Name( $3 ) ); } togglelistermodeopbody
                      |;

setsortmodeop:SETSORTMODEOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new SetSortmodeOp();
                                        ((SetSortmodeOp*)lconfig_fp1)->setMode( 0 );
                                      }
              setsortmodeopbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

setsortmodeopbody:SORTBY_WCP'='NAME_WCP';' { ((SetSortmodeOp*)lconfig_fp1)->setSortby( SORT_NAME ); } setsortmodeopbody
                 |SORTBY_WCP'='SIZE_WCP';' { ((SetSortmodeOp*)lconfig_fp1)->setSortby( SORT_SIZE ); } setsortmodeopbody
                 |SORTBY_WCP'='ACCTIME_WCP';' { ((SetSortmodeOp*)lconfig_fp1)->setSortby( SORT_ACCTIME ); } setsortmodeopbody
                 |SORTBY_WCP'='MODTIME_WCP';' { ((SetSortmodeOp*)lconfig_fp1)->setSortby( SORT_MODTIME ); } setsortmodeopbody
                 |SORTBY_WCP'='CHGTIME_WCP';' { ((SetSortmodeOp*)lconfig_fp1)->setSortby( SORT_CHGTIME ); } setsortmodeopbody
                 |SORTBY_WCP'='TYPE_WCP';' { ((SetSortmodeOp*)lconfig_fp1)->setSortby( SORT_TYPE ); } setsortmodeopbody
                 |SORTBY_WCP'='OWNER_WCP';' { ((SetSortmodeOp*)lconfig_fp1)->setSortby( SORT_OWNER ); } setsortmodeopbody
                 |SORTBY_WCP'='INODE_WCP';' { ((SetSortmodeOp*)lconfig_fp1)->setSortby( SORT_INODE ); } setsortmodeopbody
                 |SORTBY_WCP'='NLINK_WCP';' { ((SetSortmodeOp*)lconfig_fp1)->setSortby( SORT_NLINK ); } setsortmodeopbody
                 |SORTFLAG_WCP'='REVERSE_WCP';' { ((SetSortmodeOp*)lconfig_fp1)->setSortFlag( SORT_REVERSE ); } setsortmodeopbody
                 |SORTFLAG_WCP'='DIRLAST_WCP';' { ((SetSortmodeOp*)lconfig_fp1)->setSortFlag( SORT_DIRLAST ); } setsortmodeopbody
                 |SORTFLAG_WCP'='DIRMIXED_WCP';' { ((SetSortmodeOp*)lconfig_fp1)->setSortFlag( SORT_DIRMIXED ); } setsortmodeopbody
                 |;

setfilterop:SETFILTEROP_WCP LEFTBRACE_WCP { lconfig_fp1 = new SetFilterOp(); }
            setfilteropbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

setfilteropbody:REQUESTFLAGS_WCP'='bool';' { ((SetFilterOp*)lconfig_fp1)->setRequestFlags( ( ( $3 ) == 1 ) ? true : false ); } setfilteropbody
               |MODE_WCP'='EXCLUDE_WCP';' { ((SetFilterOp*)lconfig_fp1)->setFiltermode( SetFilterOp::EXCLUDE_FILTER ); } setfilteropbody
               |MODE_WCP'='INCLUDE_WCP';' { ((SetFilterOp*)lconfig_fp1)->setFiltermode( SetFilterOp::INCLUDE_FILTER ); } setfilteropbody
               |MODE_WCP'='UNSET_WCP';' { ((SetFilterOp*)lconfig_fp1)->setFiltermode( SetFilterOp::UNSET_FILTER ); } setfilteropbody
               |MODE_WCP'='UNSETALL_WCP';' { ((SetFilterOp*)lconfig_fp1)->setFiltermode( SetFilterOp::UNSET_ALL ); } setfilteropbody
               |FILTER_WCP'='STRING_WCP';' { ((SetFilterOp*)lconfig_fp1)->setFilter( $3 ); } setfilteropbody
               |;

shortkeyfromlistop:SHORTKEYFROMLISTOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new ShortkeyFromListOp(); }
                   RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

chownop:CHOWNOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new ChOwnOp(); }
        chownopbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

chownopbody:ONFILES_WCP'='bool';' { ((ChOwnOp*)lconfig_fp1)->setOnFiles( ( ( $3 ) == 1 ) ? true : false ); } chownopbody
           |ONDIRS_WCP'='bool';' { ((ChOwnOp*)lconfig_fp1)->setOnDirs( ( ( $3 ) == 1 ) ? true : false ); } chownopbody
           |RECURSIVE_WCP'='bool';' { ((ChOwnOp*)lconfig_fp1)->setRecursive( ( ( $3 ) == 1 ) ? true : false ); } chownopbody
           |REQUESTFLAGS_WCP'='bool';' { ((ChOwnOp*)lconfig_fp1)->setRequestFlags( ( ( $3 ) == 1 ) ? true : false ); } chownopbody
           |;

scriptop:SCRIPTOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new ScriptOp(); }
         scriptopbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

scriptopbody:TYPE_WCP'='NOP_WCP';' { ((ScriptOp*)lconfig_fp1)->setType( ScriptOp::SCRIPT_NOP ); } scriptopbody
            |TYPE_WCP'='PUSH_WCP';' { ((ScriptOp*)lconfig_fp1)->setType( ScriptOp::SCRIPT_PUSH ); } scriptopbody
            |TYPE_WCP'='LABEL_WCP';' { ((ScriptOp*)lconfig_fp1)->setType( ScriptOp::SCRIPT_LABEL ); } scriptopbody
            |TYPE_WCP'='IF_WCP';' { ((ScriptOp*)lconfig_fp1)->setType( ScriptOp::SCRIPT_IF ); } scriptopbody
            |TYPE_WCP'='END_WCP';' { ((ScriptOp*)lconfig_fp1)->setType( ScriptOp::SCRIPT_END ); } scriptopbody
            |TYPE_WCP'='POP_WCP';' { ((ScriptOp*)lconfig_fp1)->setType( ScriptOp::SCRIPT_POP ); } scriptopbody
            |TYPE_WCP'='SETTINGS_WCP';' { ((ScriptOp*)lconfig_fp1)->setType( ScriptOp::SCRIPT_SETTINGS ); } scriptopbody
            |TYPE_WCP'='WINDOW_WCP';' { ((ScriptOp*)lconfig_fp1)->setType( ScriptOp::SCRIPT_WINDOW ); } scriptopbody
            |TYPE_WCP'='GOTO_WCP';' { ((ScriptOp*)lconfig_fp1)->setType( ScriptOp::SCRIPT_GOTO ); } scriptopbody
            |PUSHUSEOUTPUT_WCP'='bool';' { ((ScriptOp*)lconfig_fp1)->setPushUseOutput( ( ( $3 ) == 1 ) ? true : false ); } scriptopbody
            |DODEBUG_WCP'='bool';' { ((ScriptOp*)lconfig_fp1)->setDoDebug( ( ( $3 ) == 1 ) ? true : false ); } scriptopbody
            |WPURECURSIVE_WCP'='bool';' { ((ScriptOp*)lconfig_fp1)->setWPURecursive( ( ( $3 ) == 1 ) ? true : false ); } scriptopbody
            |WPUTAKEDIRS_WCP'='bool';' { ((ScriptOp*)lconfig_fp1)->setWPUTakeDirs( ( ( $3 ) == 1 ) ? true : false ); } scriptopbody
            |STACKNR_WCP'='NUM_WCP';' { ((ScriptOp*)lconfig_fp1)->setStackNr( $3 ); } scriptopbody
            |LABEL_WCP'='STRING_WCP';' { ((ScriptOp*)lconfig_fp1)->setLabel( $3 ); } scriptopbody
            |PUSHSTRING_WCP'='STRING_WCP';' { ((ScriptOp*)lconfig_fp1)->setPushString( $3 ); } scriptopbody
            |IFTEST_WCP'='STRING_WCP';' { ((ScriptOp*)lconfig_fp1)->setIfTest( $3 ); } scriptopbody
            |IFLABEL_WCP'='STRING_WCP';' { ((ScriptOp*)lconfig_fp1)->setIfLabel( $3 ); } scriptopbody
            |WINTYPE_WCP'='OPEN_WCP';' { ((ScriptOp*)lconfig_fp1)->setWinType( ScriptOp::SCRIPT_WINDOW_OPEN ); } scriptopbody
            |WINTYPE_WCP'='CLOSE_WCP';' { ((ScriptOp*)lconfig_fp1)->setWinType( ScriptOp::SCRIPT_WINDOW_CLOSE ); } scriptopbody
            |WINTYPE_WCP'='LEAVE_WCP';' { ((ScriptOp*)lconfig_fp1)->setWinType( ScriptOp::SCRIPT_WINDOW_LEAVE ); } scriptopbody
            |CHANGEPROGRESS_WCP'='bool';' { ((ScriptOp*)lconfig_fp1)->setChangeProgress( ( ( $3 ) == 1 ) ? true : false ); } scriptopbody
            |CHANGETEXT_WCP'='bool';' { ((ScriptOp*)lconfig_fp1)->setChangeText( ( ( $3 ) == 1 ) ? true : false ); } scriptopbody
            |PROGRESSUSEOUTPUT_WCP'='bool';' { ((ScriptOp*)lconfig_fp1)->setProgressUseOutput( ( ( $3 ) == 1 ) ? true : false ); } scriptopbody
            |WINTEXTUSEOUTPUT_WCP'='bool';' { ((ScriptOp*)lconfig_fp1)->setWinTextUseOutput( ( ( $3 ) == 1 ) ? true : false ); } scriptopbody
            |PROGRESS_WCP'='STRING_WCP';' { ((ScriptOp*)lconfig_fp1)->setProgress( $3 ); } scriptopbody
            |WINTEXT_WCP'='STRING_WCP';' { ((ScriptOp*)lconfig_fp1)->setWinText( $3 ); } scriptopbody
            |;

showdircacheop:SHOWDIRCACHEOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new ShowDirCacheOp(); }
               RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

parentactionop:PARENTACTIONOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new ParentActionOp(); }
               RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

nooperationop:NOOPERATIONOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new NoOperationOp(); }
              RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

goftpop:GOFTPOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new GoFTPOp(); }
        goftpopbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

goftpopbody:REQUESTFLAGS_WCP'='bool';' { ((GoFTPOp*)lconfig_fp1)->setRequestFlags( ( ( $3 ) == 1 ) ? true : false ); } goftpopbody
           |HOSTNAME_WCP'='STRING_WCP';' { ((GoFTPOp*)lconfig_fp1)->setHost( $3 ); } goftpopbody
           |USERNAME_WCP'='STRING_WCP';' { ((GoFTPOp*)lconfig_fp1)->setUser( $3 ); } goftpopbody
           |PASSWORD_WCP'='STRING_WCP';' { ((GoFTPOp*)lconfig_fp1)->setPass( $3 ); } goftpopbody
	   |DONTENTERFTP_WCP'='bool';' { ((GoFTPOp*)lconfig_fp1)->setDontEnterFTP( ( ( $3 ) == 1 ) ? true : false ); } goftpopbody
	   |ALWAYSSTOREPW_WCP'='bool';' { ((GoFTPOp*)lconfig_fp1)->setAlwaysStorePW( ( ( $3 ) == 1 ) ? true : false ); } goftpopbody
           |;

internalviewop:INTERNALVIEWOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new InternalViewOp(); }
               internalviewopbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

internalviewopbody:REQUESTFLAGS_WCP'='bool';' { ((InternalViewOp*)lconfig_fp1)->setRequestFlags( ( ( $3 ) == 1 ) ? true : false ); } internalviewopbody
           |CUSTOMFILES_WCP'='STRING_WCP';' { ((InternalViewOp*)lconfig_fp1)->setCustomFiles( $3 ); } internalviewopbody
           |SHOWMODE_WCP'='ACTIVE_WCP';' { ((InternalViewOp*)lconfig_fp1)->setShowFileMode( InternalViewOp::SHOW_ACTIVE_FILE ); } internalviewopbody
           |SHOWMODE_WCP'='CUSTOM_WCP';' { ((InternalViewOp*)lconfig_fp1)->setShowFileMode( InternalViewOp::SHOW_CUSTOM_FILES ); } internalviewopbody
	   /*           |SHOWMODE_WCP'='SELECTED_WCP';' { ((InternalViewOp*)lconfig_fp1)->setShowFileMode( InternalViewOp::SHOW_SELECTED_FILES ); } internalviewopbody*/
           |;

searchop:SEARCHOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new SearchOp(); }
         searchopbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

searchopbody:EDITCOMMAND_WCP'='STRING_WCP';' { ((SearchOp*)lconfig_fp1)->setEditCommand( $3 ); } searchopbody
            |SHOWPREVRESULTS_WCP'='bool';' { ((SearchOp*)lconfig_fp1)->setShowPrevResults( ( ( $3 ) == 1 ) ? true : false ); } searchopbody
            |;

dirbookmarkop:DIRBOOKMARKOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new DirBookmarkOp(); }
              RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

opencontextmenuop:OPENCONTEXTMENUOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new OpenContextMenuOp(); }
                  RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

runcustomaction:RUNCUSTOMACTION_WCP LEFTBRACE_WCP { lconfig_fp1 = new RunCustomAction(); }
                runcustomactionbody RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };

runcustomactionbody:CUSTOMNAME_WCP'='STRING_WCP';' { ((RunCustomAction*)lconfig_fp1)->setCustomName( $3 ); } runcustomactionbody
              |;

openworkermenuop:OPENWORKERMENUOP_WCP LEFTBRACE_WCP { lconfig_fp1 = new OpenWorkerMenuOp(); }
                 RIGHTBRACE_WCP { lconfig_listcom->addElement( lconfig_fp1 ); };


%%
/**/
int yymyparse(void)
{
  int erg;

  lconfig_error[0] = '\0';
  lconfig_linenr = 0;
  erg = yyparse();
  /* free all strings found by the lexer
     we don't need them anymore */
  lexer_cleanup();
  return erg;
}

int yyerror(char *s)
{
  lconfig_cleanup();
  /* the following isn't really needed because yyerror is called inside the parser
     which itselve was started with yymyparse which will call it again
     but it doesn't hurt...*/
  lexer_cleanup();
  memcpy( lconfig_error, s, sizeof( lconfig_error ) );
  lconfig_error[ sizeof( lconfig_error ) - 1] = '\0';
  return 0;
}
