/* nmcacheentry.hh
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2007 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef NMCACHEENTRY_HH
#define NMCACHEENTRY_HH

#include "wdefines.h"
#include "datei.h"
#include "verzeichnis.hh"
#include <memory>

class NMCacheEntry {
public:
    NMCacheEntry( std::auto_ptr<Verzeichnis> verz,
                  class DirFilterSettings *dir_filter_sets,
                  class DirSortSettings *dir_sort_sets );
    ~NMCacheEntry();
    NMCacheEntry( const NMCacheEntry &other );
    NMCacheEntry &operator=( const NMCacheEntry &other );

    void setVerz( std::auto_ptr<Verzeichnis> verz );

    const char *getDir();
    FileEntry *getActiveFE();
    void setActiveFE( FileEntry *fe );
    FileEntry *getCheckFE();
    FileEntry *getFirstNULLFT();
    int getPos() const;
    void setPos( int pos );
    int getXPos() const;
    void setXPos( int xpos );
    bool getDontCheck() const;
    void setActiveIsVisible( bool nv );
    bool getActiveIsVisible() const;
    void setLastActiveRow( int row );
    int getLastActiveRow() const;

    void updateStatEntrySelected( const FileEntry *fe );
    void updateStatEntryDeselected( const FileEntry *fe );

    void reset_checkfe();
    void reset_firstnullft();
    void recalcStats();
    void next_checkfe();
    void restartcheck();
    void reset_dirsizes();
    void next_firstnullft();
    void checkfordcd();
    void resetCheckFE2FirstNULLFT();

    void forceUpdate();

    long getNrOfFiles( int i );
    loff_t getSizeOfFiles( int i );
    long getNrOfDirs( int i );
    loff_t getSizeOfDirs( int i );

    FileEntry *getEntryByID( int ID );
    void removeEntry( const FileEntry *fe );
    int getSerialOfIDs();

    Verzeichnis::verz_it begin();
    Verzeichnis::verz_it end();
    bool dirOpened();
private:
    Verzeichnis *getVerz();
    void checkDirSettings( bool force = false );
    void subEntryFromStats( const FileEntry *fe );

    FileEntry *_activefe;
    int _pos, _xpos;
    bool _active_is_visible;
    int _last_active_row;
    long _files[2];
    loff_t _files_s[2];  /* Jeweils Insgesamt und selektiert, Bytes gesamt, Bytes
                         * selektiert */
    long _dirs[2];
    loff_t _dirs_s[2];
    FileEntry *_checkfe;
    
    bool _dontcheck;
    FileEntry *_firstnullft;

    std::auto_ptr<Verzeichnis> _verz;

    class DirFilterSettings *_dir_filter_sets;
    class DirSortSettings *_dir_sort_sets;
    int _filter_serial_nr, _sort_serial_nr;
};

#endif
