/* copyop.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2005 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: copyop.h,v 1.32 2005/10/19 18:06:46 ralf Exp $ */

#ifndef COPYOP_H
#define COPYOP_H

#include "wdefines.h"
#include "functionproto.h"
#include <aguix/awindow.h>
#include <aguix/text.h>
#include <aguix/solidbutton.h>
#include <aguix/button.h>
#include <aguix/cyclebutton.h>
#include <aguix/bevelbox.h>
#include <aguix/request.h>
#include <aguix/awidth.h>

class CopyOp:public FunctionProto
{
public:
  CopyOp();
  virtual ~CopyOp();
  CopyOp( const CopyOp &other );
  CopyOp &operator=( const CopyOp &other );

  virtual CopyOp *duplicate() const;
  virtual bool isName(const char *);
  virtual const char *getName();
#if ! ( defined ( __GNUC__ ) && ( __GNUC__ < 3 ) )
  using FunctionProto::run;
#endif
  int run( WPUContext *wpu, ActionMessage* );
  virtual bool save(Datei*);
  virtual const char *getDescription();
  virtual int configure();

  int doconfigure(int mode);

  typedef enum {COPYOP_OVERWRITE_NORMAL=0,COPYOP_OVERWRITE_ALWAYS,COPYOP_OVERWRITE_NEVER} overwrite_t;
  typedef enum {COPYOP_NORMALCOPY=0,COPYOP_FASTCOPY,COPYOP_FASTESTCOPY} fastcopy_t;
  void setFollowSymlinks(bool);
  void setMove(bool);
  void setRename(bool);
  void setSameDir(bool);
  void setRequestDest(bool);
  void setRequestFlags(bool);
  void setOverwrite(overwrite_t);
  void setPreserveAttr(bool);
  void setFastcopy(fastcopy_t);
protected:
  static const char *name;
  // Infos to save
  bool follow_symlinks;
  bool move;
  bool do_rename;
  bool same_dir;
  bool request_dest;
  bool preserve_attr;
  bool request_flags;

  overwrite_t overwrite;

  fastcopy_t fastcopy;

  // temp variables
  Lister *startlister,*endlister;
  
  // temp values filled when request_flags==true
  bool tfollow_symlinks;
  bool tmove;
  bool trename;
  bool tsame_dir;
  bool trequest_dest;
  bool tpreserve_attr;
  overwrite_t toverwrite;
  fastcopy_t tfastcopy;

  int normalmodecopy( ActionMessage *am );
  int requestdest( const char *defaultstr, char **dest );
};

class CopyOpWin
{
public:
  CopyOpWin( AGUIX*, bool _move = false );
  ~CopyOpWin();
  CopyOpWin( const CopyOpWin &other );
  CopyOpWin &operator=( const CopyOpWin &other );

  int open(bool slim);
  void close();
  void starttimer(); // called once to set timer
  void stoptimer();  // when user-action is needed
  void conttimer();  // when user-interaction finished
  // called once:
  void set_files_to_copy(long nfiles);
  void set_dirs_to_copy(long ndirs);
  void set_bytes_to_copy(loff_t nbytes);
  // calld after newfile()
  void set_bytes_to_copy_curfile(loff_t nbytes);
  
  void dir_finished();
  void file_finished();
  // called when a block from the current file is copied
  void add_curbytes_copied(loff_t nbytes);
  // called when start a new file
  void newfile(char *name,char *ndest);
  // for setting a message in the two lines used for display copy source/dest
  void setmessage( const char *msg, int line );
  // for dec file/dir-counter (mainly in case of skiped files/dirs
  void dec_file_counter(unsigned long f);
  void dec_dir_counter(unsigned long d);
  void dec_byte_counter(loff_t b);
  
  void file_skipped( loff_t byteSum, bool subCopied );

  /* should be called in copy-loop
   * does the update of the window AND process X-events
   * returnvalues: 0 - normal exists
   *               1 - cancel/close window pressed */ 
  int redraw();
  void forceredraw();
  int request( const char *title,
               const char *text,
               const char *buttons,
               Requester::request_flags_t flags = Requester::REQUEST_NONE );
  int string_request( const char *title,
                      const char *lines,
                      const char *default_str,
                      const char *buttons,
                      char **return_str,
                      Requester::request_flags_t flags = Requester::REQUEST_NONE );
protected:
  char *source;
  char *dest;
  loff_t copied_bytes_curfile,bytes_curfile;
  loff_t copied_bytes,bytes;
  long copied_files,files;
  long copied_dirs,dirs;
  struct timeval starttime;
  struct timeval filestarttime;
  struct timeval stoptime;
  struct timeval lasttime;
  int sbw;
  loff_t lastbytes;
  double lastrate;
  
  double mintime;
  bool slim;
  
  AGUIX *aguix;
  AWindow *window;
  Text *sourcetext,*desttext,*filetext,*globtext,*files2gotext,*dirs2gotext,*timetext,*fileavgtext;
  SolidButton *fsb,*gsb;
  BevelBox *bb1, *bb2, *bb3, *bb4;
  Button *cb;
  bool update_sourcetext,update_desttext,update_filetext,update_globtext,update_files2gotext;
  bool update_dirs2gotext;
  int melw;
  int filenamespace[2];
  bool ismessage[2];
  
/* currently displayed infos:
   1.source (only filename)
   2.destination (whole path)
   3.progressbar for current file
   4.<copied Bytes>/<bytes> @ <rate>
   5.files 2 copy
   6.dirs 2 copy
   7.progressbar for the whole operation
   8.<copied Bytes>/<bytes> @ <rate>
*/
  int glob_percent;
  bool move;
  AFontWidth *lencalc;

  bool timer_stopped;
};

#endif
