/* intviewop.cc
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2005 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: intviewop.cc,v 1.1 2005/05/19 19:47:37 ralf Exp $ */

#include "intviewop.h"
#include "listermode.h"
#include "normalmode.h"
#include "worker.h"
#include "ownop.h"
#include "wpucontext.h"
#include "execlass.h"
#include <aguix/textview.h>
#include "textstoragefile.h"

const char *InternalViewOp::name = "InternalViewOp";

InternalViewOp::InternalViewOp() : FunctionProto()
{
  _request_flags = false;
  _mode = SHOW_ACTIVE_FILE;
  _custom_files = "";
  
  hasConfigure = true;
}

InternalViewOp::~InternalViewOp()
{
}

InternalViewOp*
InternalViewOp::duplicate() const
{
  InternalViewOp *ta=new InternalViewOp();
  ta->setRequestFlags( _request_flags );
  ta->setShowFileMode( _mode );
  ta->setCustomFiles( _custom_files );
  return ta;
}

bool
InternalViewOp::isName(const char *str)
{
  if(strcmp(str,name)==0) return true; else return false;
}

const char *
InternalViewOp::getName()
{
  return name;
}

int
InternalViewOp::run( WPUContext *wpu, ActionMessage *msg )
{
  std::string str1;
  bool cont = true;
  NormalMode *nm1 = NULL;
  ListerMode *lm1 = NULL;
  std::list<NM_specialsourceExt*> extfilelist;
  std::list<NM_specialsourceExt*>::iterator it1;
  std::list<std::string> filelist;

  if ( _request_flags == true ) {
    if ( doconfigure( 1 ) != 0 ) cont = false;
  } else {
    _tcustom_files = _custom_files;
    _tmode = _mode;
  }
  
  if ( cont == true ) {
    if ( msg->mode != msg->AM_MODE_DNDACTION ) {
      Lister *l1 = msg->getWorker()->getActiveLister();
      if ( l1 != NULL )
	lm1 = l1->getActiveMode();
    } else {
      lm1 = am->dndmsg->getSourceMode();
    }
    
    if ( ( lm1 != NULL ) && ( lm1->isType( "NormalMode" ) == true ) )
      nm1 = (NormalMode*)lm1;
    
    if ( msg->mode == msg->AM_MODE_ONLYACTIVE )
      _tmode = SHOW_ACTIVE_FILE;
    else if ( msg->mode == msg->AM_MODE_DNDACTION ) {
      filelist.push_back( am->dndmsg->getFE()->fullname );
    } else if ( msg->mode == msg->AM_MODE_SPECIAL ) {
      filelist.push_back( am->getFE()->fullname );
    }

    if ( filelist.size() < 1 ) {
      if ( _tmode == SHOW_ACTIVE_FILE ) {
	if ( nm1 != NULL ) {
	  nm1->getSelFiles( &extfilelist, NormalMode::NM_GETFILES_ONLYACTIVE );
	  for ( it1 = extfilelist.begin(); it1 != extfilelist.end(); it1++ ) {
	    filelist.push_back( (*it1)->entry()->fullname );
	  }
	  NormalMode::freeSelFiles( &extfilelist );
	}
	/*} else if ( _tmode == SHOW_SELECTED_FILES ) {
	  if ( nm1 != NULL ) {
	  nm1->getSelFiles( &extfilelist, NormalMode::NM_GETFILES_SELORACT, true );
	  for ( it1 = extfilelist.begin(); it1 != extfilelist.end(); it1++ ) {
	  filelist.push_back( (*it1)->entry()->fullname );
	  }
	  NormalMode::freeSelFiles( &extfilelist );
	  }*/
      } else if ( _tmode == SHOW_CUSTOM_FILES ) {
        char *tstr = wpu->parse( _tcustom_files.c_str(),
				 a_max( EXE_STRING_LEN - 1024, 256 ),
				 true );
	if ( tstr != NULL ) {
	  char **argvlist;
	  char *unquoted_str;
	  int n, i;
	  
	  n = Worker_buildArgvList( tstr, &argvlist );
	  
	  for ( i = 0; i < n; i++ ) {
	    unquoted_str = AGUIX_unquoteString( argvlist[i] );
	    filelist.push_back( unquoted_str );
	    _freesafe( unquoted_str );
	  }
	  
	  Worker_freeArgvList( argvlist );
	  _freesafe( tstr );
	}
      }
    }

    if ( filelist.size() > 0 ) {
      msg->getWorker()->setWaitCursor();
      view( filelist );
      msg->getWorker()->unsetWaitCursor();
    }
  }
  return 0;
}

bool
InternalViewOp::save(Datei *fh)
{
  if ( fh == NULL ) return false;
  WConfig::configPutPairBool( fh, "requestflags", _request_flags );
  WConfig::configPutPairString( fh, "customfiles", _custom_files.c_str() );
  switch ( _mode ) {
    /*case SHOW_SELECTED_FILE:
      WConfig::configPutPair( fh, "showmode", "selected" );
      break;*/
    case SHOW_CUSTOM_FILES:
      WConfig::configPutPair( fh, "showmode", "custom" );
      break;
    default:
      WConfig::configPutPair( fh, "showmode", "active" );
      break;
  }
  return true;
}

const char *
InternalViewOp::getDescription()
{
  return catalog.getLocaleCom( 49 );
}

int
InternalViewOp::configure()
{
  return doconfigure(0);
}

int
InternalViewOp::doconfigure(int mode)
{
  AGUIX *aguix = Worker::getAGUIX();
  Button *okb,*cancelb, *flagb;
  AWindow *win;
  ChooseButton *rfcb=NULL;
  CycleButton *cycbm;
  StringGadget *sgcf;
  AGMessage *msg;
  int endmode=-1;
  char *tstr;
  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;
  const int cincwnr = cincw +
                      AContainer::ACONT_NORESIZE;
  const int cfix = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW +
                   AContainer::ACONT_MAXH +
                   AContainer::ACONT_MAXW;
  
  tstr = (char*)_allocsafe( strlen( catalog.getLocale( 293 ) ) + strlen( catalog.getLocaleCom( 49 ) ) + 1 );
  sprintf( tstr, catalog.getLocale( 293 ), catalog.getLocaleCom( 49 ) );
  win = new AWindow( aguix, 10, 10, 10, 10, 0, tstr );
  win->create();
  _freesafe( tstr );

  AContainer *ac1 = win->setContainer( new AContainer( win, 1, 4 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );

  AContainer *ac1_2 = ac1->add( new AContainer( win, 2, 1 ), 0, 0 );
  ac1_2->setMinSpace( 5 );
  ac1_2->setMaxSpace( 5 );
  ac1_2->setBorderWidth( 0 );
  ac1_2->add( new Text( aguix, 0, 0, catalog.getLocale( 632 ), 1 ), 0, 0, cfix );
  cycbm = (CycleButton*)ac1_2->add( new CycleButton( aguix, 0, 0, 100, 1, 0, 0 ), 1, 0, cincw );

  cycbm->addOption( catalog.getLocale( 634 ) );
  cycbm->addOption( catalog.getLocale( 635 ) );
  cycbm->resize( cycbm->getMaxSize(), cycbm->getHeight() );
  switch( _mode ) {
    case SHOW_CUSTOM_FILES:
      cycbm->setOption( 1 );
      break;
    default:
      cycbm->setOption( 0 );
      break;
  }
  ac1_2->readLimits();

  AContainer *ac1_3 = ac1->add( new AContainer( win, 3, 1 ), 0, 1 );
  ac1_3->setMinSpace( 5 );
  ac1_3->setMaxSpace( 5 );
  ac1_3->setBorderWidth( 0 );
  ac1_3->add( new Text( aguix, 0, 0, catalog.getLocale( 636 ), 1 ), 0, 0, cfix );
  sgcf = (StringGadget*)ac1_3->add( new StringGadget( aguix, 0, 0, 100, _custom_files.c_str(), 0 ),
				    1, 0, cincw );
  flagb = (Button*)ac1_3->add( new Button( aguix,
					   0,
					   0,
					   "F",
					   1,
					   0,
					   0 ), 2, 0, cfix );
  
  if ( mode == 0 ) {
    rfcb = (ChooseButton*)ac1->add( new ChooseButton( aguix, 0, 0, ( _request_flags == true ) ? 1 : 0,
						      catalog.getLocale( 294 ), LABEL_RIGHT, 1, 0 ),
				    0, 2, cincwnr );
  }

  AContainer *ac1_5 = ac1->add( new AContainer( win, 2, 1 ), 0, 3 );
  ac1_5->setMinSpace( 5 );
  ac1_5->setMaxSpace( -1 );
  ac1_5->setBorderWidth( 0 );
  okb = (Button*)ac1_5->add( new Button( aguix,
					 0,
					 0,
					 catalog.getLocale( 11 ),
					 1,
					 0,
					 0 ), 0, 0, cfix );
  cancelb = (Button*)ac1_5->add( new Button( aguix,
					     0,
					     0,
					     catalog.getLocale( 8 ),
					     1,
                                                     0,
					     0 ), 1, 0, cfix );
  win->contMaximize( true );

  win->setDoTabCycling( true );
  win->show();
  for( ; endmode == -1; ) {
    msg = aguix->WaitMessage( win );
    if ( msg != NULL ) {
      switch ( msg->type ) {
        case AG_CLOSEWINDOW:
          if ( msg->closewindow.window == win->getWindow() ) endmode = 1;
          break;
        case AG_BUTTONCLICKED:
          if ( msg->button.button == okb ) endmode = 0;
          else if ( msg->button.button == cancelb ) endmode = 1;
          else if ( msg->button.button == flagb ) {
            tstr = OwnOp::getFlag();
            if ( tstr != NULL ) {
              sgcf->insertAtCursor( tstr );
              _freesafe( tstr );
            }
	  }
	  break;
        case AG_KEYPRESSED:
          if ( win->isParent( msg->key.window, false ) == true ) {
            switch ( msg->key.key ) {
              case XK_Return:
                if ( cancelb->getHasFocus() == true ) {
		  endmode = 1;
		} else {
                  endmode=0;
                }
                break;
              case XK_Escape:
                endmode = 1;
                break;
            }
          }
          break;
      }
      aguix->ReplyMessage( msg );
    }
  }
  
  if ( endmode == 0 ) {
    // ok
    if ( mode == 1 ) {
      switch( cycbm->getSelectedOption() ) {
	case 1:
	  _tmode = SHOW_CUSTOM_FILES;
	  break;
	default:
	  _tmode = SHOW_ACTIVE_FILE;
	  break;
      }
      _tcustom_files = sgcf->getText();
    } else {
      switch( cycbm->getSelectedOption() ) {
	case 1:
	  _tmode = SHOW_CUSTOM_FILES;
	  break;
	default:
	  _tmode = SHOW_ACTIVE_FILE;
	  break;
      }
      if ( rfcb != NULL ) _request_flags = ( rfcb->getState() == 1 ) ? true : false;
      setCustomFiles( sgcf->getText() );
    }
  }
  delete win;

  return endmode;
}

void InternalViewOp::setRequestFlags( bool nv )
{
  _request_flags = nv;
}

void InternalViewOp::setShowFileMode( show_file_mode_t nv )
{
  _mode = nv;
}

void InternalViewOp::setCustomFiles( std::string nv )
{
  _custom_files = nv;
}

void InternalViewOp::view( std::list<std::string> &filelist ) const
{
  AGUIX *aguix = Worker::getAGUIX();
  Button *okb;
  const int cfix = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW +
                   AContainer::ACONT_MAXH +
                   AContainer::ACONT_MAXW;
  const int cincw = AContainer::ACONT_MINH +
                    AContainer::ACONT_MINW +
                    AContainer::ACONT_MAXH;
  const int cincwnr = cincw +
                      AContainer::ACONT_NORESIZE;
  TextStorageFile *ts = NULL;
  TextView *tv = NULL;
  std::list<std::string>::iterator it1;
  int w, h, sw, sh;
  static bool last_wrap_mode = false;

  AWindow *win = new AWindow( aguix, 10, 10, 10, 10, 0, catalog.getLocaleCom( 49 ) );
  win->create();
  /*  if ( aguix->getTransientWindow() != NULL ) {
    win->setTransientForAWindow( aguix->getTransientWindow() );
    }*/

  AContainer *ac1 = win->setContainer( new AContainer( win, 1, 3 ), true );
  ac1->setMinSpace( 5 );
  ac1->setMaxSpace( 5 );

  AContainer *ac1_1 = ac1->add( new AContainer( win, 2, 1 ), 0, 0 );
  ac1_1->setMinSpace( 5 );
  ac1_1->setMaxSpace( 5 );
  ac1_1->setBorderWidth( 0 );
  ac1_1->add( new Text( aguix, 0, 0, catalog.getLocale( 404 ), 1 ), 0, 0, cfix );
  Text *fnt = (Text*)ac1_1->add( new Text( aguix, 0, 0, "", 1 ), 1, 0, cincwnr );

  it1 = filelist.begin();
  buildTextView( *it1, &ts, &tv, ac1, fnt );
  ac1->readLimits();
  ac1_1->readLimits();

  AContainer *ac1_3 = ac1->add( new AContainer( win, 2, 1 ), 0, 2 );
  ac1_3->setMinSpace( 5 );
  ac1_3->setMaxSpace( -1 );
  ac1_3->setBorderWidth( 0 );
  
  /*nextb = (Button*)ac1_3->add( new Button( aguix, 0, 0, "Next", 1, 0, 2 ),
    0, 0, cfix );
    prevb = (Button*)ac1_3->add( new Button( aguix, 0, 0, "Prev", 1, 0, 2 ),
    1, 0, cfix );*/
  ChooseButton *wcb = (ChooseButton*)ac1_3->add( new ChooseButton( aguix, 0, 0,
								 last_wrap_mode, catalog.getLocale( 637 ),
								 LABEL_RIGHT, 1, 0 ),
					       0, 0, cincwnr );
  okb = (Button*)ac1_3->add( new Button( aguix, 0, 0, catalog.getLocale( 633 ), 1, 0, 2 ),
			     1, 0, cfix );

  win->setDoTabCycling( true );
  win->contMaximize( true );
  
  w = win->getWidth();
  h = win->getHeight();

  sw = aguix->getRootWindowWidth();
  sh = aguix->getRootWindowHeight();
  sw = (int)( (double)sw * 0.8 );
  sh = (int)( (double)sh * 0.8 );
  if ( sw < 200 ) sw = 200;
  if ( sh < 100 ) sh = 100;
  if ( w < sw ) w = sw;
  if ( h < sh ) h = sh;
  win->resize( w, h );

  tv->setLineWrap( wcb->getState() );

  win->useStippleBackground();
  win->centerScreen();
  win->show();

  win->applyFocus( tv );

  AGMessage *msg;
  int endmode = -1;
  for( ; endmode == -1; ) {
    msg = aguix->WaitMessage( win );
    if ( msg != NULL ) {
      switch ( msg->type ) {
        case AG_CLOSEWINDOW:
          if ( msg->closewindow.window == win->getWindow() ) {
	    endmode = 0;
	  }
          break;
	case AG_CHOOSECLICKED:
	  if ( msg->choose.button == wcb ) {
	    tv->setLineWrap( msg->choose.state );
	  }
	  break;
        case AG_BUTTONCLICKED:
	  if ( msg->button.button == okb ) {
	    endmode = 0;
	    /*	  } else if ( msg->button.button == nextb ) {
		  it1++;
		  if ( it1 == filelist.end() ) it1 = filelist.begin();
		  buildTextView( *it1, &ts, &tv, ac1 );
		  } else if ( msg->button.button == prevb ) {
		  if ( it1 == filelist.begin() )
		  it1 = filelist.end();
		  it1--;
		  buildTextView( *it1, &ts, &tv, ac1 );*/
	  }
          break;
	case AG_KEYPRESSED:
	  if ( win->isParent( msg->key.window, false ) == true ) {
	    wcb->setState( tv->getLineWrap() );
	    switch(msg->key.key) {
	      case XK_q:
	      case XK_Escape:
	      case XK_F3:
	      case XK_F10:
	        endmode = 0;
	        break;
	    }
	  }
	  break;
      }
      aguix->ReplyMessage( msg );
    }
  }

  last_wrap_mode = tv->getLineWrap();

  delete win;
  if ( ts != NULL ) delete ts;
}

void InternalViewOp::buildTextView( std::string &filename,
				    TextStorageFile **ts,
				    TextView **tv,
				    AContainer *ac1,
				    class Text *fnt ) const
{
  AGUIX *aguix = Worker::getAGUIX();
  const int cmin = AContainer::ACONT_MINH +
                   AContainer::ACONT_MINW;
  
  if ( ts == NULL || tv == NULL || ac1 == NULL ) return;
  
  delete *tv;
  *ts = new TextStorageFile( filename );
  *tv = new TextView( aguix, 0, 0, 100, 100, 0, "", **ts );
  (*tv)->setDisplayFocus( true );
  ac1->add( *tv, 0, 1, cmin );
  (*tv)->create();
  if ( fnt != NULL ) fnt->setText( filename.c_str() );
  ac1->rearrange();
  (*tv)->show();
}
