/* normalmode.h
 * This file belongs to Worker, a filemanager for UNIX/X11.
 * Copyright (C) 2001-2005 Ralf Hoffmann.
 * You can contact me at: ralf@boomerangsworld.de
 *   or http://www.boomerangsworld.de/worker
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
/* $Id: normalmode.h,v 1.100 2005/03/23 21:52:40 ralf Exp $ */

#ifndef NORMALMODE_H
#define NORMALMODE_H

#include "wdefines.h"
#include <aguix/aguix.h>
#include <aguix/message.h>
#include <aguix/fieldlistview.h>
#include <aguix/fieldlistviewdnd.h>
#include <aguix/stringgadget.h>
#include <aguix/button.h>
#include <aguix/request.h>
#include "listermode.h"
#include "datei.h"
#include "copyop.h"
#include "deleteop.h"
#include "condparser.h"

#ifdef WANT_THREADS
#include <aguix/mutex.h>
#include <aguix/condvar.h>
#endif

class Lister;
class NMFieldListViewDND;

class NM_Filter {
public:
  NM_Filter();
  ~NM_Filter();
  NM_Filter( const NM_Filter &other );
  NM_Filter &operator=( const NM_Filter &other );

  void setPattern(const char*);
  char *getPattern();
  void setCheck(int);
  int getCheck();
  int load();
  int loadBin(Datei*);
  int save(Datei*);
  NM_Filter *duplicate();
private:
  char *pattern;
  int check;
};

class NMCacheEntry {
public:
  NMCacheEntry();
  ~NMCacheEntry();
  NMCacheEntry( const NMCacheEntry &other );
  NMCacheEntry &operator=( const NMCacheEntry &other );

  void recalcStats();
  void subentry(FileEntry *fe);
  void next_checkfe();
  void restartcheck();
  void reset_checkfe();
  void checkfordcd();
  void reset_dirsizes();
  void reset_firstnullft();
  void next_firstnullft();
//protected:  // Vorerst public
  Verzeichnis *verz;
  FileEntry *activefe;
  int pos,xpos;
  long files[2];
  loff_t files_s[2];  // Jeweils Insgesamt und selektiert, Bytes gesamt, Bytes
                  // selektiert
  long dirs[2];
  loff_t dirs_s[2];
  FileEntry *checkfe;
  FileEntry *lastfe;  // when this is recognized update the whole listview
  
  int actsortmode;
  int actshowhidden;
  int actfilterlfdnr;
  bool dontcheck;
  FileEntry *firstnullft;
};

class NM_CopyOp_Dir
{
public:
  NM_CopyOp_Dir(const FileEntry *fe);
  ~NM_CopyOp_Dir();
  NM_CopyOp_Dir( const NM_CopyOp_Dir &other );
  NM_CopyOp_Dir &operator=( const NM_CopyOp_Dir &other );

  int createSubDirs(struct NM_copyorder*copyorder,unsigned long *gf,unsigned long *gd);
  int createSubDirs(struct NM_deleteorder*delorder,unsigned long *gf,unsigned long *gd);
  int createSubDirs();
  
  List *subdirs; // contains elements of this class
  Verzeichnis *verz;
  const FileEntry *fileentry;
  unsigned long files,dirs;
  loff_t bytes;
  bool ok; // only use this dir if ok==true
  bool user_abort; // true when user selected cancel from one of
                   // the requesters used inside
  
  unsigned long error_counter; // files/dirs not finished (recursive)
};

/*
 * NM_specialsourceExt always stores a duplicate FE
 */
class NM_specialsourceExt {
 public:
  NM_specialsourceExt( const FileEntry *tfe );
  ~NM_specialsourceExt();
  const FileEntry *entry() const
  {
    return fe;
  }
  int row;  // corresponding row or -1
 private:
  FileEntry *fe;  // element to copy
};

struct NM_copyorder {
  char *destdir;
  enum {NM_ALLENTRIES,NM_ONLYACTIVE,NM_SPECIAL} source;
  std::list<NM_specialsourceExt*> *sources;
  // modes:
  bool move; // true = move, false = copy
  bool follow_symlinks;
  bool do_rename;
  bool preserve_attr;
  enum {NM_OVERWRITE_NORMAL,NM_OVERWRITE_ALWAYS,NM_OVERWRITE_NEVER} overwrite;
    /* _NORMAL: Request what to do
       _ALWAYS: overwrite without request
       _NEVER: no overwriting */
  enum {NM_COPYMODE_NORMAL,NM_COPYMODE_NODATABASE} copymode;
  CopyOpWin *cowin;

  int error;  // for returning an error
  bool ignoreLosedAttr;  // true when the user don't want to get a requester
                         // when SUID/SGID bit couldn't be restored
};

struct NM_deleteorder {
  enum {NM_ALLENTRIES,NM_ONLYACTIVE,NM_SPECIAL,NM_ONLYSELECTED} source;
  std::list<NM_specialsourceExt*> *sources;
  enum {NM_DELMODE_NORMAL,NM_DELMODE_NODATABASE} delmode;
  enum {NM_DIRDELETE_NORMAL,NM_DIRDELETE_ALL,NM_DIRDELETE_NONE} dirdel;
  DeleteOpWin *dowin;

  int error;  // for returning an error
};

class NM_externorder {
public:
  NM_externorder();
  ~NM_externorder();
  NM_externorder( const NM_externorder &other );
  NM_externorder &operator=( const NM_externorder &other );

  bool separate_each_entry;
  bool recursive;
  bool inbackground;

  enum {NM_EXT_START_NORMAL=0,
        NM_EXT_START_IN_TERMINAL,
        NM_EXT_START_IN_TERMINAL_AND_WAIT4KEY,
        NM_EXT_SHOW_OUTPUT} extstart;

  char *com_str;
  char *view_str;

  enum {NM_ALLENTRIES,NM_ONLYACTIVE,NM_SPECIAL} source;
  std::list<NM_specialsourceExt*> *sources;
  
  // this is for DND-actions for identifying the destination (for the dp-flag)
  class NormalMode *destmode;
  class WPUContext *wpu;
  bool take_dirs;
  bool dontcd;
};

struct NM_startprogorder {
  const FileEntry *usefe;
  bool global;
  bool inbackground;
  enum {NM_START_NORMAL=0,
        NM_START_IN_TERMINAL,
        NM_START_IN_TERMINAL_AND_WAIT4KEY,
        NM_SHOW_OUTPUT} start;

  char *view_str;
  bool dontcd;
};

struct NM_renameorder {
  enum {NM_ALLENTRIES,NM_ONLYACTIVE,NM_SPECIAL} source;
  std::list<NM_specialsourceExt*> *sources;
};

struct NM_dirsizeorder {
  enum {NM_ALLENTRIES,NM_ONLYACTIVE,NM_SPECIAL} source;
  std::list<NM_specialsourceExt*> *sources;
};

struct NM_createsymlinkorder {
  bool local;
  char *destdir;
  enum {NM_ALLENTRIES,NM_ONLYACTIVE,NM_SPECIAL} source;
  std::list<NM_specialsourceExt*> *sources;
};

struct NM_chmodorder {
  bool ondirs,onfiles,recursive;
  enum {NM_ALLENTRIES,NM_ONLYACTIVE,NM_SPECIAL} source;
  std::list<NM_specialsourceExt*> *sources;
};

struct NM_chownorder {
  bool ondirs,onfiles,recursive;
  enum {NM_ALLENTRIES,NM_ONLYACTIVE,NM_SPECIAL} source;
  std::list<NM_specialsourceExt*> *sources;
};

struct NM_changesymlinkorder {
  enum {NM_ALLENTRIES,NM_ONLYACTIVE,NM_SPECIAL} source;
  std::list<NM_specialsourceExt*> *sources;
};

class NM_extern_fe {
public:
  NM_extern_fe(char *nfn);
  NM_extern_fe( char *nfn, const FileEntry *fe, int row );
  ~NM_extern_fe();
  NM_extern_fe( const NM_extern_fe &other );
  NM_extern_fe &operator=( const NM_extern_fe &other );

  char *getFullname(bool noext);
  char *getName(bool noext);
  void setDirFinished(int);
  int getDirFinished();
  const FileEntry *getFE();
  int getRow();
protected:
  char *fullname[2];
  char *name[2];
  FileEntry *fe;
  int row;
  int dirfinished;
};

class NMExtList
{
public:
  NMExtList();
  ~NMExtList();
  NMExtList( const NMExtList &other );
  NMExtList &operator=( const NMExtList &other );

  int getSize();
  int getRealSize();
  void setTakeDirs( bool nv);
  int initEnum();
  void closeEnum( int );
  NM_extern_fe *getFirstElement( int id );
  NM_extern_fe *getNextElement( int id );
  int removeElement( NM_extern_fe * );
  void createExtList( class NormalMode *nm, bool rec );
  void createExtList( class NormalMode *nm, ActionMessage *msg, bool rec );
protected:
  List *extlist;
  int files, dirs;
  bool take_dirs;
};

class NormalMode:public ListerMode
{
public:
  NormalMode(Lister *);
  virtual ~NormalMode();
  NormalMode( const NormalMode &other );
  NormalMode &operator=( const NormalMode &other );

  virtual void messageHandler(AGMessage *);
  virtual void on();
  virtual void off();
  virtual void activate();
  virtual void deactivate();
  void selhandler( FieldListView*, int row );
  virtual bool isType(const char *);
  virtual const char *getType();
  virtual int configure();
  virtual void cyclicfunc(cyclicfunc_mode_t mode);
  virtual const char* getLocaleName();
  virtual int load();
  virtual int loadBin(Datei*);
  virtual bool save(Datei *);
  virtual void reconfig();
  static const char *getStaticLocaleName();
  static const char *getStaticType();
  
  int enterDir(const char *dirstr);
  void enterDirActive();
  void setActiveDir2Other();
  void up();
  void down();
  void top();
  void last();
  void pageup();
  void pagedown();
  void select();
  void selectall();
  void selectnone();
  void invertall();
  void parent();
  void filterselect(char *filter,int mode);
  void copy(struct NM_copyorder *copyorder);
  void deletef(struct NM_deleteorder *delorder);
  void update(bool reset_dirsizes);
  void update(bool reset_dirsizes, bool keep_filetypes );
  void makedir();
  void externprog(class NM_externorder *extorder);
  void renamef(struct NM_renameorder *renorder);
  void dirsize(struct NM_dirsizeorder *dsorder);
  void simdd();
  void startprog(struct NM_startprogorder *sporder);
  void searchentry();
  void searchentry( bool ignore_case );
  void enterpath();
  void scrolllister(int dir);
  void createsymlink(struct NM_createsymlinkorder *cslorder);
  void changesymlink(struct NM_changesymlinkorder *chslorder);
  void chmodf(struct NM_chmodorder *cmorder);
  void chownf(struct NM_chownorder *coorder);
  
  void toggleHiddenE();
  void setShowHiddenE(bool);
  char *getCurrentDir();
  static bool isCorrectViewProg(const char *str);
  
  typedef enum {NM_GETFILES_ONLYACTIVE,
                NM_GETFILES_ONLYSELECT,
                NM_GETFILES_SELORACT} nm_getfiles_t;
  int getSelFiles( std::list<NM_specialsourceExt*>*, nm_getfiles_t, bool unselect = false );
  void freeSelFiles( std::list<NM_specialsourceExt*>* ) const;
  int getDirSize( FileEntry *fe, loff_t &return_size );

  virtual bool startdnd(DNDMsg *dm);
  virtual bool isyours(GUIElement *elem);

  FileEntry *getFE4DNDSTART( const AGDNDSTART *st );
  void setSortmode(int nmode);
  
  typedef enum {NM_FILTER_INCLUDE,NM_FILTER_EXCLUDE,NM_FILTER_UNSET} nm_filter_t;
  void unsetAllFilters();
  void setFilter(const char *filter,nm_filter_t mode);

#ifdef WANT_THREADS
  void slavehandler();
#endif
  int createExtList( bool rec, List *extlist );
  static void freeExtList( List *extlist );
  char *parseComStrExt(char *sstr,class NM_externorder *extorder,int maxlen, NMExtList *entries[2], bool quote);
  /* deselect for extern access, check for existance of fe => slow for big dirs */
  void deselect( const FileEntry *fe );
  int createExtList( ActionMessage *amsg, bool rec, List *extlist );
  static int getEntriesRealSize( List* );
  virtual void lvbDoubleClicked();
  
  int showCacheList();
  int request( const char *title,
               const char *text,
               const char *buttons,
               Requester::request_flags_t flags = Requester::REQUEST_NONE );
  int string_request( const char *title,
                      const char *lines,
                      const char *default_str,
                      const char *buttons,
                      char **return_str,
                      Requester::request_flags_t flags = Requester::REQUEST_NONE );
  int request_choose( const char *title,
		      const char *text,
		      const char *choose_text,
		      bool &choose_var,
		      const char *buttons,
		      Requester::request_flags_t flags = Requester::REQUEST_NONE );
  int request( CopyOpWin *cowin,
               const char *title,
               const char *text,
               const char *buttons,
               Requester::request_flags_t flags = Requester::REQUEST_NONE );
  int string_request( CopyOpWin *cowin,
                      const char *title,
                      const char *lines,
                      const char *default_str,
                      const char *buttons,
                      char **return_str,
                      Requester::request_flags_t flags = Requester::REQUEST_NONE );
  int request( DeleteOpWin *dowin,
               const char *title,
               const char *text,
               const char *buttons,
               Requester::request_flags_t flags = Requester::REQUEST_NONE );
  int string_request( DeleteOpWin *dowin,
                      const char *title,
                      const char *lines,
                      const char *default_str,
                      const char *buttons,
                      char **return_str,
                      Requester::request_flags_t flags = Requester::REQUEST_NONE );
  int tryApplyOwnerPerm( const char *filename,
                         const uid_t wanted_user,
                         const gid_t wanted_group,
                         const mode_t wanted_mode,
                         struct NM_copyorder *copyorder );
protected:
  /*
   * NM_specialsourceInt always stores a pointer to a FE
   */
  class NM_specialsourceInt {
   public:
    NM_specialsourceInt( FileEntry *tfe );
    ~NM_specialsourceInt();
    FileEntry *entry() const
    {
      return fe;
    }
    int row;  // corresponding row or -1
    NM_CopyOp_Dir *cod; // when fe is dir, this will be the corresponding structure
   private:
    FileEntry *fe;  // element to copy
  };

  void reconf( int nx, int ny, int nw, int nh, bool force = false );
  void buildLister();
  void deleteCache();
  void deleteFilters();
  void showcache(int);
  void showCacheAbs( int pos );
  void checkFilters( NMCacheEntry* );
  void showCacheState();
  void toggleHidden();
  void setShowHidden(bool);
  void startAction(FileEntry*);
  
  typedef enum {NM_NEWNAME_OK,
                NM_NEWNAME_SKIP,
                NM_NEWNAME_CANCEL,
                NM_NEWNAME_OVERWRITE,
                NM_NEWNAME_USE} nm_newname_t;
  typedef enum {NM_COPY_OK,
                NM_COPY_SKIP,
                NM_COPY_CANCEL,
                NM_COPY_NEED_DELETE} nm_copy_t;
  nm_newname_t getNewName(const FileEntry *oldfe,struct NM_copyorder *copyorder,char *dest,
                          char **newname_return,bool requestDir,bool acceptrename);
  nm_newname_t getNewName4File(const FileEntry*oldfe,struct NM_copyorder *copyorder,char *dest,
                          char **newname_return,bool acceptrename);
  nm_newname_t getNewName4Dir(const FileEntry*oldfe,struct NM_copyorder *copyorder,char *dest,
                          char **newname_return,bool acceptrename);
  nm_copy_t copydir(const FileEntry *fe,
              NM_CopyOp_Dir *cod,
              struct NM_copyorder *copyorder,
              bool acceptrename,
              char *destdir);
  nm_copy_t copyfile(const FileEntry *fe,
               struct NM_copyorder *copyorder,
               bool acceptrename,
               char *destdir);
  nm_copy_t deldir(const FileEntry *fe,
              NM_CopyOp_Dir *cod,
              struct NM_deleteorder *delorder);
  nm_copy_t delfile(const FileEntry *fe,
               struct NM_deleteorder *delorder,
               bool dir);

  NMFieldListViewDND *lv;
  Button *hb[2], *parentb;
  StringGadget *sg;
  static const char *type;
  int x,y,w,h;
  NMCacheEntry *ce;
  int stored_cacheentry;
  List *cache;
  List *filters;
  bool showHidden;
  Requester *req;
  #define BUFSIZE 128*1024
  void *buf;
  bool searchmodeon;
  bool searchmode_ignore_case;
  char *oldstr;
  char *lastsearch;
  std::list<const FileEntry*> *copy_deletefe_list;
  int sortmode;
  int filterlfdnr;
  
  bool showfreespace;
  int updatetime;
  time_t lastfsupdate;
  char *namestr;
  char *freespacestr;
  enum ssh_allow_t { SSH_ASK, SSH_NEVER, SSH_ALWAYS } ssh_allow;
  
  struct timeval lastclick;
  int lastrow;
  void removeEntry(FileEntry *fe, int row,bool quick);
  void fixSpecialSourceList( const std::list<NM_specialsourceInt*> *l, int deleted_row );
  int createExtList( std::list<NM_specialsourceExt*> *splist,bool rec,List *extlist) const;
  int create_externfe_rec(List *extlist,
                          char *fullname,
                          bool rec,
                          const FileEntry *fe,
                          int row ) const;
  char *parseComStr(char *sstr,class NM_externorder *extorder,int maxlen, NMExtList *entries[2], bool quote );
  void deselect( FileEntry *fe, int row );
  char *StringRequest(char *sstr,class NM_externorder *extorder,int maxlen, NMExtList *entries[2]);
  void startsearchmode();
  void finishsearchmode();
  bool showfirstentry(const char *str);
  bool shownextentry();
  bool shownextentry( const char *str, int pos );

  typedef struct changemod_info{
    changemod_info();
    bool forAll;
    mode_t newmode;
  } changemod_info_t;
  int worker_changemod( const NM_specialsourceInt *ss1,
                        changemod_info_t *cminfo,
                        const NM_chmodorder *cmorder );
  int applyNewMode( const NM_specialsourceInt *ss1, mode_t newmode );
  typedef struct changeown_info{
    changeown_info();
    bool forAll;
    uid_t newuid;
    gid_t newgid;
  } changeown_info_t;
  int worker_changeown( const struct NM_specialsourceInt *ss1,
                        changeown_info_t *coinfo,
                        const NM_chownorder *coorder );
  int applyNewOwner( const NM_specialsourceInt *ss1, uid_t newuid, gid_t newgid );

  int requestNewMode(FileEntry *fe,mode_t *return_mode);
  void setFilters(List*);
  void configureFilters(bool*,List*);
  void setLVC4Filter( FieldListView *filv, int row, NM_Filter *fi);
  int configureFilter(NM_Filter *fi);
  void checkRebuild( NMCacheEntry *ce, bool forcerebuild );
  void setName();
  void updateName();
  void showFreeSpace(bool force);
  int updateFreeSpaceStr( int ti );
  void setShowFreeSpace(bool v);
  void setUpdatetime(int nv);
  void setSSHAllow( enum ssh_allow_t nv );
  
  int runCommand( const char*exestr,
                  const char *tmpname,
                  const char *tmpoutput,
                  bool inbackground );
  
  static int maxfilestrlen,maxdirstrlen,maxbytesstrlen,maxwbytesstrlen,maxnochanges;
  
#ifdef WANT_THREADS
public:   // why the h*** need the Sun compiler a public definition for a
          // protected struct?
  typedef enum { THREAD_NOP,
                 THREAD_WAIT,
                 THREAD_RUN,
                 THREAD_EXIT,
                 THREAD_REINIT } thread_order_t;
protected:
  struct {
    int running;
    thread_order_t order;
    thread_order_t status;
    CondVar statusvar;
    pthread_t th;
    
    List *filetypes;
    CondVar filetype_ex;
    
  } slave;
  int switchOrder( thread_order_t neworder );
  int waitForNoOrder( void );
  int waitForNewOrder( void );
  int switchStatus( thread_order_t newstatus );
  int waitForStatus( thread_order_t waitstatus );
  // true if thread creation was successful
  // false otherwise and also when WANT_THREADS is not defined
#endif
  bool thread_usage;
#ifdef WANT_THREADS
  
  // intern list (special fifo) for the tasks for the slave-thread
  // can contain up to size elements of prev type
  // main thread does put and remove
  // slave does slaveread
  class ft_rec_list
  {
  public:
    // type for the ft_rec_list
    // contains filename, FileEntry (only for main thread)
    
    // as long as you hold the lock at least
    // name and dontCheckContent are valid
    // if you release the lock take this entry as invalid
    // so copy needed things inside the lock
    typedef struct _ft_rec_list_t {
      const char *name;
      FileEntry *fe;
      bool dontCheckContent;
      struct _ft_rec_list_t *next;
    } ft_rec_list_t;

    ft_rec_list();
    ~ft_rec_list();
    ft_rec_list( const ft_rec_list &other );
    ft_rec_list &operator=( const ft_rec_list &other );

    int slaveread_locked( const char **name, bool *dontCheckContent );
    bool elemAvail_locked();
    bool isFull_locked();
    bool isEmpty_locked();
    int put_locked( ft_rec_list_t *elem );
    ft_rec_list_t *remove_locked();
    ft_rec_list_t *gettop_locked();

    void lock();
    void unlock();
    void wait();
    void signal();
  protected:
    CondVar ex;
    int size;
    ft_rec_list_t *head, *tail;
    
    ft_rec_list_t *readp;
    int elements;
  };
  void ft_rec_list_clear();

  // fifo for ft-results
  // main thread does remove
  // slave does put
  // no size limitation
  class ft_recres_list {
  public:
    // this is the type for the filetype-recogn-result
    // contains the name and the position of the ft in the wconfig list
    // index of ft because so every slave can hold a copy of the ft-list
    // to work without need to lock
    class ft_recres_list_t {
    public:
      char *name;
      std::vector<unsigned int> *ft_index;
      bool customcolors;
      int *fg, *bg;
      ft_recres_list_t *next;

      ft_recres_list_t()
      {
	name = NULL;
	ft_index = NULL;
	customcolors = false;
	fg = bg = NULL;
	next = NULL;
      }
      ~ft_recres_list_t()
      {
	if ( fg != NULL ) delete [] fg;
	if ( bg != NULL ) delete [] bg;
        if ( name != NULL ) _freesafe( name );
      }
    };
    
    ft_recres_list();
    ~ft_recres_list();
    ft_recres_list( const ft_recres_list &other );
    ft_recres_list &operator=( const ft_recres_list &other );

    bool isEmpty_locked();
    int put_locked( ft_recres_list_t *elem );
    ft_recres_list_t *remove_locked();
    
    void lock();
    void unlock();
  protected:
    ft_recres_list_t *head, *tail;
    MutEx ex;
    
    int elements;
  };
  void ft_recres_list_clear();

  ft_rec_list *reclist;
  ft_recres_list *recreslist;

  void ft_list_clear();
  void ft_list_update();

  class checkFiletypeRes_t {
  public:
    std::vector<unsigned int> *v;
    bool customcolors;
    int *fg, *bg;
    
    checkFiletypeRes_t() {
      v = NULL;
      fg = bg = NULL;
      customcolors = false;
    }
  };
  
  checkFiletypeRes_t slave_checkFiletype( const char *fullname, bool dontCheckContent );
#endif
  
  bool lasteagain;
  bool finish_done;
  
  void setupLVFields();

  typedef struct {
    union {
      uid_t uid;
      gid_t gid;
    } id;
    char *name;
  } chownrequest_id_name_t;
  
  void freeOwnerRequestInfos();
  void buildOwnerRequestInfos();
  int requestNewOwner( FileEntry *fe, uid_t *return_owner, gid_t *return_group );  
  List *chownUserList;
  List *chownGroupList;
  
  bool isColumnVisible( const WorkerTypes::listcol_t c );
  bool visChanged;
  int oldlvy;
  FileEntry *findFileEntryForData( int data, int startpos );
  NM_specialsourceExt *getSpecialsourceForFE( const FileEntry *searchfe );
  
  void showInvalidList( ArrayList *list, const char *descr );
  void changeSortModeForField( int field );
  
  int busyFlag;
  time_t lastBusyFlagUpdate;
  
  CondParser condparser;
  WCFiletype *findFiletype( std::vector<unsigned int> *v );
  int getSelFiles( std::list<NM_specialsourceInt*> *, nm_getfiles_t, bool unselect );
  FileEntry *findFE( const FileEntry *tfe );
};

class NMFieldListViewDND:public FieldListViewDND
{
public:
  NMFieldListViewDND(AGUIX*,int,int,int,int,int);
  virtual ~NMFieldListViewDND();
  NMFieldListViewDND( const NMFieldListViewDND &other );
  NMFieldListViewDND &operator=( const NMFieldListViewDND &other );

  void setSelectHandler(NormalMode*);
protected:
  NormalMode *nm;
  virtual void runSelectHandler( int row );
};

#endif

