/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000-2004 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef _QSIMPLETEXTBROWSER_H_
#define _QSIMPLETEXTBROWSER_H_

#include <qmime.h>
#include <qstylesheet.h>
#include <qtextbrowser.h>
#include <qstring.h>
#include <qpopupmenu.h>
#include <qcolor.h>

//class QPoint;

class MyMimeSourceFactory : public QMimeSourceFactory
{

public:
	MyMimeSourceFactory();
	~MyMimeSourceFactory();

	virtual const QMimeSource* data( const QString & abs_name) const;
};

class MyStyleSheet : public QStyleSheet
{
public:
	MyStyleSheet( QObject * parent=0, const char * name=0 );
	virtual void error ( const QString & ) const;
};

class QSimpleTextBrowser : public QTextBrowser
{
	Q_OBJECT

public:

	QSimpleTextBrowser(QWidget * parent=0, const char *name=0 );
	~QSimpleTextBrowser();

	virtual void setSource ( const QString & name );
	virtual void setText ( const QString & text, 
                           const QString & context = QString::null );
	QString nameText() { return name_of_last; };

	//Charset que se utilizar para grabar a un fichero de texto
	void setCharset( const QString &charset) { encoding_charset= charset; };
	QString getCharset() { return encoding_charset; };

	QColor colorFondo();

	//Para QT 3
	virtual void setDefaultFont ( const QFont & );
	virtual QFont defaultFont();

signals:
	//void anchor_clicked( const QString& palabra );
	void fontCambiado( const QFont& font );
	void changedDefaultFont( const QFont& font );

public slots:
	void copia_texto();
	void cambia_font();
	void cambia_color();
	void cambia_color( QColor c );
	void imprimir();
	void grabar();

protected:
	void viewportMousePressEvent( QMouseEvent *e );
	//virtual QPopupMenu *createPopupMenu ( const QPoint & pos ) { return menu; };
	//virtual QPopupMenu *createPopupMenu() { return menu; };
	QPopupMenu *menu;

protected slots:
	void activa_popupmenu();
	//void slot_linkClicked( const QString & link );

private:
	QString name_of_last;
	QString encoding_charset;
	QFont default_font;
};

#endif

