/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000-2004 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

#ifndef _QDICCIONARIOS_H_
#define _QDICCIONARIOS_H_

#include <qglobal.h>
#if QT_VERSION >= 300
#include <qvariant.h> // QT3
#include <qptrlist.h>
#else
#include <qlist.h>
#endif

#include "DiccionarioBase.h"

#ifndef NO_GRAPHICS_AT_ALL
class QPopupMenu;
class QPixmap;
#endif

class QDiccionarios {

public:
	QDiccionarios(const QString & defaultDir=QString::null);
	~QDiccionarios();

	void load();

	void add(DiccionarioBase *d);

	DiccionarioBase * first();
	DiccionarioBase * next();
	DiccionarioBase * last();
	DiccionarioBase * prev();
	DiccionarioBase * at( unsigned int index);
	DiccionarioBase * find( const QString& alias, int &index );

#ifndef NO_GRAPHICS_AT_ALL
	QPopupMenu * creaMenu();
	void addMenuItems(QPopupMenu *menu);
	void updateMenuItems(QPopupMenu *menu, int index);
	//void updateMenuItem( QPopupMenu *menu, int index );

	QPixmap * getIconoTipo(DiccionarioBase *dic);
#endif

	void save_all_dicts();

	void show_dicts();

protected:
	void copiar(const QString& filtro);
	void copiar();
	void load(const QString& filtro, bool baby, bool dictd);

#if QT_VERSION >= 300
	QPtrList<DiccionarioBase> lista_dict;
#else
	QList<DiccionarioBase> lista_dict;
#endif

	QString directorio;
	bool allow_save_configs;

#ifndef NO_GRAPHICS_AT_ALL
	//Iconos para cada tipo de diccionario
	QPixmap *icono_texto;
	QPixmap *icono_babylon;
	QPixmap *icono_dict;
#endif
};

#endif

