/*  Wordtrans, front-end for several dictionaries, for the Qt toolkit.
    Copyright (C) 2000-2004 Ricardo Villalba <rvm@escomposlinux.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


#ifndef QCuestionario_included
#define QCuestionario_included

#include <qdialog.h>
#include <qpushbutton.h>
#include <qmultilinedit.h>
#include <qstring.h>

class QCuestionario : public QDialog
{
    Q_OBJECT

public:

    QCuestionario
    (
        QWidget* parent = NULL,
        const char* name = NULL
    );

    virtual ~QCuestionario();


protected slots:
    virtual void enviar();
    virtual void copiar_todo();
    virtual void cancelar();
	virtual void add_system_info();

protected:
	bool load();
	bool send();
	QString leeFichero(const QString& fichero);

	QPushButton* send_button;
	QMultiLineEdit* editor;
};

#endif // QCuestionario_included
