
#include "setup.h"
#include "qfunciones.h"
#include "intern.h"
#include <qglobal.h>
#include <qfontdialog.h>
#include <qtextcodec.h>

#if QT_VERSION >= 300
#include <qstylefactory.h>
#endif

#ifdef HAVE_KDELIBS3
#include <kcolorbutton.h>
#else
#include "kdeui/kcolorbutton.h"
#endif

// Includes panel fuentes
#include <qgroupbox.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlayout.h>
#include <qvariant.h>
#include <qtooltip.h>
#include <qwhatsthis.h>

// Includes panel browser
#include <qcheckbox.h>
#include <qcombobox.h>

// Includes panel clipboard
#include <qspinbox.h>


#include "pixmaps/select_browser.xpm"
#include "pixmaps/select_fonts.xpm"
#include "pixmaps/select_clipboard.xpm"
#include "pixmaps/select_appearance.xpm"
#include "pixmaps/select_charsets.xpm"


Setup * Setup::static_dialog=NULL;

Setup::Setup( QWidget* parent,  const char* name, bool , WFlags  )
    : KDialogBase(KDialogBase::IconList, "Setup",
                Ok|Cancel|Apply,KDialogBase::Ok,parent,name,false,true)
{
	//qDebug( "marginHint:%d", KDialog::marginHint() );
	//qDebug( "spacingHint:%d", KDialog::spacingHint() );

	setCaption( _("Settings") );
	setButtonOKText( _("&Ok") );
	setButtonApplyText( _("&Apply") );
	setButtonCancelText( _("&Cancel") );

	creaPanelFonts();
	creaPanelBrowser();
	creaPanelClipboard();
	creaPanelMisc();
	creaPanelCharsets();

	QTextCodec *codec;
	int n=0;
	do {
		codec = QTextCodec::codecForIndex(n);
#if QT_VERSION >= 300
		if (codec!=NULL) comboCharset->insertItem( codec->mimeName(), 0 );
#else
		if (codec!=NULL) comboCharset->insertItem( codec->name(), 0 );
#endif
		n++;
	} while (codec!=NULL);


	//Conecta botones
	connect( cambiaFontMain, SIGNAL( clicked() ),
             this, SLOT( cambiarFuentePrincipal() ) );
	connect( botonCambiaFontOutput, SIGNAL( clicked() ),
             this, SLOT( cambiarFuenteSalida() ) );
	connect( botonCambiaFontMini, SIGNAL( clicked() ),
             this, SLOT( cambiarFuenteMini() ) );
}

Setup::~Setup()
{
	debug("Destroying Setup...");
}

Setup * Setup::dialog() {
	if (static_dialog==NULL) {
		debug("Creating 'setup' dialog..");
		static_dialog = new Setup( 0, "static_dialog" );
	}
	return static_dialog;
}

//Propiedades "fuentes y colores":
void Setup::setMainFont(const QFont& font) { setFuente(*labelViewFontMain,font); };
void Setup::setOutputFont(const QFont& font) { setFuente(*labelViewFontOutput,font); };
void Setup::setMiniwindowFont(const QFont& font) { setFuente(*labelViewFontMini,font); };

QFont Setup::getMainFont() { return labelViewFontMain->font(); };
QFont Setup::getOutputFont() { return labelViewFontOutput->font(); };
QFont Setup::getMiniwindowFont() { return labelViewFontMini->font(); };

void Setup::setOutputColor( const QColor& color ) { colorOutput->setColor(color); };
void Setup::setMiniwindowColor( const QColor& color ) { colorMini->setColor(color); };

QColor Setup::getOutputColor() { return colorOutput->color(); };
QColor Setup::getMiniwindowColor() { return colorMini->color(); };


//Propiedades "browser":
void Setup::setBrowser( const QString& nombre ) {
	seleccionaItem( comboBrowser, nombre );
}

QString Setup::getBrowser() { return comboBrowser->currentText(); }

void Setup::setInternalBrowser(bool b) { useBrowser->setChecked(b); }
bool Setup::getInternalBrowser() { return useBrowser->isChecked(); }


//Propiedades "apariencia:"
void Setup::setStyle( const QString& nombre ) { 
	seleccionaItem(comboStyle,nombre);
}

QString Setup::getStyle() { return comboStyle->currentText(); }

void Setup::setBigToolbar( bool big ) {
	if (big) 
		comboToolbar->setCurrentItem( 0 );
	else
		comboToolbar->setCurrentItem( 1 );
}

bool Setup::getBigToolbar(){
	return (comboToolbar->currentItem()==0);
}

void Setup::setEfecto( int tipo_efecto) {
	comboEffects->setCurrentItem( tipo_efecto );
}

int Setup::getEfecto() {
	return comboEffects->currentItem();
}

void Setup::setMenubarVisible( bool b) { showMenubar->setChecked(b); }
bool Setup::isMenubarVisible() { return showMenubar->isChecked(); }
void Setup::setToolbarVisible( bool b) { showToolbar->setChecked(b); }
bool Setup::isToolbarVisible() { return showToolbar->isChecked(); }
void Setup::setStatusbarVisible( bool b) { showStatusbar->setChecked(b); }
bool Setup::isStatusbarVisible() { return showStatusbar->isChecked(); }


//Propiedades "clipboard":
void Setup::setClipboardTime(int msec) { inputClipboardTime->setValue(msec); }

int Setup::getClipboardTime() {
	QString s=inputClipboardTime->text();

	bool ok;
	int valor=s.toInt( &ok );

	if (!ok) {
		debug("Valor en milliseconds no correcto");
		return inputClipboardTime->value();
	} else {
		if (valor < inputClipboardTime->minValue() ) valor=inputClipboardTime->minValue();
		if (valor > inputClipboardTime->maxValue() ) valor=inputClipboardTime->maxValue();
		return valor;
	}
}


void Setup::setFuente( QLabel& label, const QFont& font ) {
	label.setText( QString("%1, %2").arg(font.family()).arg(font.pointSize()) );
	label.setFont( font );
}

void Setup::cambiaFuente( QLabel& label ) {
	bool ok;
	QFont f = QFontDialog::getFont( &ok, label.font(), this );
    if ( ok ) {
		setFuente( label, f );
	}
}

//Propiedades charsets
void Setup::setSavingCharset(const QString & charset) {
	seleccionaItem(comboCharset, charset);
}

QString Setup::getSavingCharset() { return comboCharset->currentText(); }


//SLOTS
void Setup::cambiarFuentePrincipal() {
	cambiaFuente( *labelViewFontMain );
}

void Setup::cambiarFuenteSalida() {
	cambiaFuente( *labelViewFontOutput );
}

void Setup::cambiarFuenteMini() {
	cambiaFuente( *labelViewFontMini );
}


void Setup::creaPanelFonts() {
/*--- Fuentes ---*/
	tab_fuentes = addPage( _("Fonts and colours"), 
        QString::null, QPixmap(select_fonts_xpm) );
		
	//Definicin widgets panel fuentes:
    FuentesLayout = new QVBoxLayout( tab_fuentes, 0, spacingHint() );
    FuentesLayout->setSpacing( 6 );
    FuentesLayout->setMargin( 11 );

    groupFonts = new QGroupBox( tab_fuentes, "groupFonts" );
    groupFonts->setTitle( _( "Main" ) );
    groupFonts->setColumnLayout(0, Qt::Vertical );
    groupFonts->layout()->setSpacing( 0 );
    groupFonts->layout()->setMargin( 0 );
    groupFontsLayout = new QHBoxLayout( groupFonts->layout() );
    groupFontsLayout->setAlignment( Qt::AlignTop );
    groupFontsLayout->setSpacing( 6 );
    groupFontsLayout->setMargin( 11 );

    labelFontMain = new QLabel( groupFonts, "labelFontMain" );
    labelFontMain->setText( _( "Font:" ) );
    labelFontMain->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignLeft ) );
    groupFontsLayout->addWidget( labelFontMain );

    labelViewFontMain = new QLabel( groupFonts, "labelViewFontMain" );
    labelViewFontMain->setText( _( "Arial" ) );
    labelViewFontMain->setAlignment( int( QLabel::AlignCenter ) );
    groupFontsLayout->addWidget( labelViewFontMain );

    cambiaFontMain = new QPushButton( groupFonts, "cambiaFontMain" );
    cambiaFontMain->setText( _( "Change..." ) );
    groupFontsLayout->addWidget( cambiaFontMain );
    FuentesLayout->addWidget( groupFonts );

    groupOutput = new QGroupBox( tab_fuentes, "groupOutput" );
    groupOutput->setTitle( _( "Output window" ) );
    groupOutput->setColumnLayout(0, Qt::Vertical );
    groupOutput->layout()->setSpacing( 0 );
    groupOutput->layout()->setMargin( 0 );
    groupOutputLayout = new QGridLayout( groupOutput->layout() );
    groupOutputLayout->setAlignment( Qt::AlignTop );
    groupOutputLayout->setSpacing( 6 );
    groupOutputLayout->setMargin( 11 );

    labelFontOutput = new QLabel( groupOutput, "labelFontOutput" );
    labelFontOutput->setText( _( "Font:" ) );
    labelFontOutput->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignLeft ) );

    groupOutputLayout->addWidget( labelFontOutput, 0, 0 );

    botonCambiaFontOutput = new QPushButton( groupOutput, "botonCambiaFontOutput" );
    botonCambiaFontOutput->setText( _( "Change..." ) );

    groupOutputLayout->addWidget( botonCambiaFontOutput, 0, 2 );

    labelColorOutput = new QLabel( groupOutput, "labelColorOutput" );
    labelColorOutput->setText( _( "Colour:" ) );
    labelColorOutput->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignLeft ) );

    groupOutputLayout->addMultiCellWidget( labelColorOutput, 1, 1, 0, 1 );

    labelViewFontOutput = new QLabel( groupOutput, "labelViewFontOutput" );
    labelViewFontOutput->setText( _( "Arial" ) );
    labelViewFontOutput->setAlignment( int( QLabel::AlignCenter ) );

    groupOutputLayout->addWidget( labelViewFontOutput, 0, 1 );

    colorOutput = new KColorButton( groupOutput, "colorOutput" );

    groupOutputLayout->addWidget( colorOutput, 1, 2 );
    FuentesLayout->addWidget( groupOutput );

    groupMiniwindow = new QGroupBox( tab_fuentes, "groupMiniwindow" );
    groupMiniwindow->setTitle( _( "Mini-window" ) );
    groupMiniwindow->setColumnLayout(0, Qt::Vertical );
    groupMiniwindow->layout()->setSpacing( 0 );
    groupMiniwindow->layout()->setMargin( 0 );
    groupMiniwindowLayout = new QGridLayout( groupMiniwindow->layout() );
    groupMiniwindowLayout->setAlignment( Qt::AlignTop );
    groupMiniwindowLayout->setSpacing( 6 );
    groupMiniwindowLayout->setMargin( 11 );

    labelFontMini = new QLabel( groupMiniwindow, "labelFontMini" );
    labelFontMini->setText( _( "Font:" ) );
    labelFontMini->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignLeft ) );

    groupMiniwindowLayout->addWidget( labelFontMini, 0, 0 );

    botonCambiaFontMini = new QPushButton( groupMiniwindow, "botonCambiaFontMini" );
    botonCambiaFontMini->setText( _( "Change..." ) );

    groupMiniwindowLayout->addWidget( botonCambiaFontMini, 0, 2 );

    labelViewFontMini = new QLabel( groupMiniwindow, "labelViewFontMini" );
    labelViewFontMini->setText( _( "Arial" ) );
    labelViewFontMini->setAlignment( int( QLabel::AlignCenter ) );

    groupMiniwindowLayout->addWidget( labelViewFontMini, 0, 1 );

    labelColorMini = new QLabel( groupMiniwindow, "labelColorMini" );
    labelColorMini->setText( _( "Colour:" ) );
    labelColorMini->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignLeft ) );

    groupMiniwindowLayout->addMultiCellWidget( labelColorMini, 1, 1, 0, 1 );

    colorMini = new KColorButton( groupMiniwindow, "colorMini" );

    groupMiniwindowLayout->addWidget( colorMini, 1, 2 );
    FuentesLayout->addWidget( groupMiniwindow );
	//Fin definicin widgets panel fuentes
}

void Setup::creaPanelBrowser() {
/*--- Browser ---*/
	tab_browser = addPage( _("Browser"), QString::null,
		QPixmap(select_browser_xpm) );
		
	//Definicin widgets panel browser:
    BrowserLayout = new QVBoxLayout( tab_browser, 0, spacingHint() );
    BrowserLayout->setSpacing( 6 );
    BrowserLayout->setMargin( 11 );

    grupoBrowser = new QGroupBox( tab_browser, "grupoBrowser" );
    grupoBrowser->setTitle( _( "Browser" ) );
    grupoBrowser->setAlignment( int( QGroupBox::AlignLeft ) );
    grupoBrowser->setColumnLayout(0, Qt::Vertical );
    grupoBrowser->layout()->setSpacing( 0 );
    grupoBrowser->layout()->setMargin( 0 );
    grupoBrowserLayout = new QVBoxLayout( grupoBrowser->layout() );
    grupoBrowserLayout->setAlignment( Qt::AlignTop );
    grupoBrowserLayout->setSpacing( 6 );
    grupoBrowserLayout->setMargin( 11 );

    labelBrowser = new QLabel( grupoBrowser, "labelBrowser" );
    labelBrowser->setText( _( "&Select a browser for viewing the documentation or web pages (from faster to extremely slow):" ) );
    labelBrowser->setAlignment( int( QLabel::WordBreak | QLabel::AlignVCenter | QLabel::AlignLeft ) );
    grupoBrowserLayout->addWidget( labelBrowser );

    comboBrowser = new QComboBox( FALSE, grupoBrowser, "comboBrowser" );
    comboBrowser->insertItem( "dillo" );
    comboBrowser->insertItem( "opera" );
    comboBrowser->insertItem( "netscape" );
    comboBrowser->insertItem( "galeon" );
    comboBrowser->insertItem( "konqueror" );
    comboBrowser->insertItem( "mozilla" );
    grupoBrowserLayout->addWidget( comboBrowser );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    grupoBrowserLayout->addItem( spacer );
    BrowserLayout->addWidget( grupoBrowser );

    useBrowser = new QCheckBox( tab_browser, "useBrowser" );
    useBrowser->setText( _( "&Use internal browser for help pages (recommended)" ) );
    BrowserLayout->addWidget( useBrowser );

    // buddies
    labelBrowser->setBuddy( comboBrowser );
	//Fin definicin widgets panel browser
}

void Setup::creaPanelClipboard() {
/*--- Clipboard ---*/
	tab_clipboard = addPage( _("Clipboard"), QString::null,
		QPixmap(select_clipboard_xpm) );
		
	//Definicin widgets panel clipboard:
    ClipboardLayout = new QVBoxLayout( tab_clipboard, 0, spacingHint() );
    ClipboardLayout->setSpacing( 6 );
    ClipboardLayout->setMargin( 11 );

    labelClipboardText = new QLabel( tab_clipboard, "labelClipboardText" );
    labelClipboardText->setFrameShape( QLabel::Box );
    labelClipboardText->setFrameShadow( QLabel::Sunken );
    labelClipboardText->setText( _( "Wordtrans will check the clipboard from time to time if the \"Check clipboard\" option is enabled. \nHere you can select the interval for checking the clipboard. \n\nThe lower it is, the faster the response of the program will be, but your processor will be a little busier." ) );
    labelClipboardText->setTextFormat( QLabel::PlainText );
    labelClipboardText->setAlignment( int( QLabel::WordBreak | QLabel::AlignVCenter | QLabel::AlignLeft ) );
    ClipboardLayout->addWidget( labelClipboardText );

    clipboardLayout1 = new QHBoxLayout; 
    clipboardLayout1->setSpacing( 6 );
    clipboardLayout1->setMargin( 0 );

    labelClipboard1 = new QLabel( tab_clipboard, "labelClipboard1" );
    labelClipboard1->setText( _( "&Check clipboard every" ) );
    clipboardLayout1->addWidget( labelClipboard1 );

    inputClipboardTime = new QSpinBox( tab_clipboard, "inputClipboardTime" );
    clipboardLayout1->addWidget( inputClipboardTime );

    labelClipboard2 = new QLabel( tab_clipboard, "labelClipboard2" );
    labelClipboard2->setText( _( "milliseconds" ) );
    clipboardLayout1->addWidget( labelClipboard2 );
    ClipboardLayout->addLayout( clipboardLayout1 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    ClipboardLayout->addItem( spacer );

    // buddies
    labelClipboard1->setBuddy( inputClipboardTime );
	//Fin definicin widgets panel clipboard

	//Aadido a mano
	inputClipboardTime->setRange( 10, 50000 );
	inputClipboardTime->setSteps( 20, 0 );
}

void Setup::creaPanelMisc() {
/*--- Apariencia ---*/
	tab_misc = addPage( _("Appearance"), QString::null,
		QPixmap(select_appearance_xpm) );
		
	//Definicin widgets panel apariencia:
    AppearanceLayout = new QVBoxLayout( tab_misc, 0, spacingHint() );
    AppearanceLayout->setSpacing( 6 );
    AppearanceLayout->setMargin( 11 );

    grupoMisc = new QGroupBox( tab_misc, "grupoMisc" );
    grupoMisc->setFrameShape( QGroupBox::Box );
    grupoMisc->setFrameShadow( QGroupBox::Sunken );
    grupoMisc->setTitle( _( "Visible elements" ) );
    grupoMisc->setColumnLayout(0, Qt::Vertical );
    grupoMisc->layout()->setSpacing( 0 );
    grupoMisc->layout()->setMargin( 0 );
    grupoMiscLayout = new QGridLayout( grupoMisc->layout() );
    grupoMiscLayout->setAlignment( Qt::AlignTop );
    grupoMiscLayout->setSpacing( 6 );
    grupoMiscLayout->setMargin( 11 );

    showMenubar = new QCheckBox( grupoMisc, "showMenubar" );
    showMenubar->setText( _( "&Menubar" ) );

    grupoMiscLayout->addWidget( showMenubar, 0, 0 );

    showToolbar = new QCheckBox( grupoMisc, "showToolbar" );
    showToolbar->setText( _( "&Toolbar" ) );

    grupoMiscLayout->addWidget( showToolbar, 1, 0 );

    showStatusbar = new QCheckBox( grupoMisc, "showStatusbar" );
    showStatusbar->setText( _( "&Statusbar" ) );

    grupoMiscLayout->addWidget( showStatusbar, 2, 0 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Minimum );
    grupoMiscLayout->addItem( spacer, 0, 3 );
    QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Minimum );
    grupoMiscLayout->addItem( spacer_2, 1, 3 );
    QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Minimum );
    grupoMiscLayout->addItem( spacer_3, 2, 3 );

    comboToolbar = new QComboBox( FALSE, grupoMisc, "comboToolbar" );
    comboToolbar->insertItem( _( "Big" ) );
    comboToolbar->insertItem( _( "Small" ) );

    grupoMiscLayout->addWidget( comboToolbar, 1, 2 );

    labelSize = new QLabel( grupoMisc, "labelSize" );
    labelSize->setText( _( "Si&ze:" ) );
    labelSize->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignRight ) );

    grupoMiscLayout->addWidget( labelSize, 1, 1 );
    AppearanceLayout->addWidget( grupoMisc );

    grupoEffects = new QGroupBox( tab_misc, "grupoEffects" );
    grupoEffects->setTitle( _( "Look and feel" ) );
    grupoEffects->setColumnLayout(0, Qt::Vertical );
    grupoEffects->layout()->setSpacing( 0 );
    grupoEffects->layout()->setMargin( 0 );
    grupoEffectsLayout = new QGridLayout( grupoEffects->layout() );
    grupoEffectsLayout->setAlignment( Qt::AlignTop );
    grupoEffectsLayout->setSpacing( 6 );
    grupoEffectsLayout->setMargin( 11 );

    labelEffects = new QLabel( grupoEffects, "labelEffects" );
    labelEffects->setText( _( "&Effects:" ) );

    grupoEffectsLayout->addWidget( labelEffects, 0, 0 );

    labelStyle = new QLabel( grupoEffects, "labelStyle" );
    labelStyle->setText( _( "St&yle:" ) );
    labelStyle->setAlignment( int( QLabel::AlignVCenter | QLabel::AlignLeft ) );

    grupoEffectsLayout->addWidget( labelStyle, 1, 0 );

    comboStyle = new QComboBox( FALSE, grupoEffects, "comboStyle" );
    comboStyle->insertItem( "Windows" );
    comboStyle->insertItem( "Motif" );
    comboStyle->insertItem( "Platinum" );
    comboStyle->insertItem( "CDE" );
    comboStyle->insertItem( "Motifplus" );
    comboStyle->insertItem( "SGI" );

    grupoEffectsLayout->addWidget( comboStyle, 1, 1 );

    comboEffects = new QComboBox( FALSE, grupoEffects, "comboEffects" );
    comboEffects->insertItem( _( "None" ) );
    comboEffects->insertItem( _( "Animate" ) );
    comboEffects->insertItem( _( "Fade" ) );

    grupoEffectsLayout->addWidget( comboEffects, 0, 1 );
    QSpacerItem* spacer_4 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Minimum );
    grupoEffectsLayout->addItem( spacer_4, 0, 2 );
    QSpacerItem* spacer_5 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Minimum );
    grupoEffectsLayout->addItem( spacer_5, 1, 2 );
    AppearanceLayout->addWidget( grupoEffects );

    // buddies
    labelSize->setBuddy( comboToolbar );
    labelEffects->setBuddy( comboEffects );
    labelStyle->setBuddy( comboStyle );
	//Fin definicin widgets panel apariencia

#ifdef HAVE_KDELIBS3
	labelStyle->setEnabled(false);
	comboStyle->setEnabled(false);
#endif

#if QT_VERSION >= 300
	comboStyle->clear();
	comboStyle->insertStringList( QStyleFactory::keys() );
#endif
}

void Setup::creaPanelCharsets() {
/*--- Charsets ---*/
	tab_charsets = addPage( _("Charsets"), QString::null,
		QPixmap(select_charsets_xpm) );
		
	//Definicin widgets panel charsets:
    CharsetsLayout = new QVBoxLayout( tab_charsets, 0, spacingHint()  ); 
    CharsetsLayout->setSpacing( 6 );
    CharsetsLayout->setMargin( 11 );

    labelCharsetExpl = new QLabel( tab_charsets, "labelCharsetExpl" );
    labelCharsetExpl->setFrameShape( QLabel::Box );
    labelCharsetExpl->setFrameShadow( QLabel::Sunken );
    labelCharsetExpl->setText( _( "Select the charset to use when saving a text file. If you are not sure select ISO-8859-1 (latin1)." ) );
    labelCharsetExpl->setTextFormat( QLabel::AutoText );
    labelCharsetExpl->setAlignment( int( QLabel::WordBreak | QLabel::AlignVCenter | QLabel::AlignLeft ) );
    CharsetsLayout->addWidget( labelCharsetExpl );

    charsetlayout1 = new QHBoxLayout; 
    charsetlayout1->setSpacing( 6 );
    charsetlayout1->setMargin( 0 );
    QSpacerItem* spacer = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Minimum );
    charsetlayout1->addItem( spacer );

    labelCharset = new QLabel( tab_charsets, "labelCharset" );
    labelCharset->setText( _( "&Charset:" ) );
    charsetlayout1->addWidget( labelCharset );

    comboCharset = new QComboBox( FALSE, tab_charsets, "comboCharset" );
    comboCharset->setMinimumSize( QSize( 150, 0 ) );
    charsetlayout1->addWidget( comboCharset );
    QSpacerItem* spacer_2 = new QSpacerItem( 20, 20, QSizePolicy::Preferred, QSizePolicy::Minimum );
    charsetlayout1->addItem( spacer_2 );
    CharsetsLayout->addLayout( charsetlayout1 );
    QSpacerItem* spacer_3 = new QSpacerItem( 20, 20, QSizePolicy::Minimum, QSizePolicy::Expanding );
    CharsetsLayout->addItem( spacer_3 );

    // buddies
    labelCharset->setBuddy( comboCharset );
	//Fin definicin widgets panel charsets
}

#include "setup.moc.cpp"

