/* 						WMKeyboard					*
 * 		By Dimitris Economou <trackman@mfa.gr>		*
 * 													*
 * 	Finished Databases: misc, modifier, japanese,	*
 * 						iso9995, 3270, latin, 		*
 * 						arabic, cyrillic, greek		*
 *  Unfinished Databases: currency, georgian, korean*
 * 						  armenian, thai, hebrew,	*
 * 						  publishing, technical,	*
 * 						  special					*
 * 	If you would like to help by finishing up one of*
 * 	the keysym databases above, just email me. The	*
 * 	keysyms are all defined in: 					*
 * 		/usr/X11R6/include/X11/keysymdef.h			*
 * 													*/

#define NUMBER_OF_KEYSYM_DB 18

#define Misc_DB_Length 137
#define Modifier_DB_Length 14
#define Japanese_DB_Length 19
#define iso9995_DB_Length 100
#define i3270_DB_Length 30
#define Latin_DB_Length 193
#define Arabic_DB_Length 49
#define Cyrillic_DB_Length 95
#define Greek_DB_Length 71
#define Technical_DB_Length 49
#define Publishing_DB_Length 83
#define Hebrew_DB_Length 0
#define Thai_DB_Length 0
#define Korean_DB_Length 0
#define Armenian_DB_Length 0
#define Georgian_DB_Length 0
#define Currency_DB_Length 0
#define Katakana_DB_Length 0

#define MAXIMUM 193

struct KeysymDatabase {
   char *name;
   int size;
   char *keysyms[MAXIMUM][2];
}keysymdb[NUMBER_OF_KEYSYM_DB];

char *miscdb[Misc_DB_Length][2] = {
    { "XK_BackSpace", (char *) 0xFF08 },
	{ "XK_Tab", (char *) 0xFF09 },
	{ "XK_Linefeed", (char *) 0xFF0A },
	{ "XK_Clear", (char *) 0xFF0B },
	{ "XK_Return", (char *) 0xFF0D },
	{ "XK_Pause", (char *) 0xFF13 },
	{ "XK_Scroll_Lock", (char *) 0xFF14 },
	{ "XK_Sys_Req", (char *) 0xFF15 },
	{ "XK_Escape", (char *) 0xFF1B },
	{ "XK_Delete", (char *) 0xFFFF },
	{ "XK_Multi_key", (char *) 0xFF20 },
	{ "XK_Codeinput", (char *) 0xFF37 },
	{ "XK_SingleCandidate", (char *) 0xFF3C },
	{ "XK_MultipleCandidate", (char *) 0xFF3D },
	{ "XK_PreviousCandidate", (char *) 0xFF3E },
	{ "XK_Home", (char *) 0xFF50 },
	{ "XK_Left", (char *) 0xFF51 },
	{ "XK_Up", (char *) 0xFF52 },
	{ "XK_Right", (char *) 0xFF53 },
	{ "XK_Down", (char *) 0xFF54 },
	{ "XK_Prior", (char *) 0xFF55 },
	{ "XK_Page_Up", (char *) 0xFF55 },
	{ "XK_Next", (char *) 0xFF56 },
	{ "XK_Page_Down", (char *) 0xFF56 },
	{ "XK_End", (char *) 0xFF57 },
	{ "XK_Begin", (char *) 0xFF58 },
	{ "XK_Select", (char *) 0xFF60 },
	{ "XK_Print", (char *) 0xFF61 },
	{ "XK_Execute", (char *) 0xFF62 },
	{ "XK_Insert", (char *) 0xFF63 },
	{ "XK_Undo", (char *) 0xFF65 },
	{ "XK_Redo", (char *) 0xFF66 },
	{ "XK_Menu", (char *) 0xFF67 },
	{ "XK_Find", (char *) 0xFF68 },
	{ "XK_Cancel", (char *) 0xFF69 },
	{ "XK_Help", (char *) 0xFF6A },
	{ "XK_Break", (char *) 0xFF6B },
	{ "XK_Mode_switch", (char *) 0xFF7E },
	{ "XK_script_switch", (char *) 0xFF7E },
	{ "XK_Num_Lock", (char *) 0xFF7E },
	{ "XK_KP_Space", (char *) 0xFF80 },
	{ "XK_KP_Tab", (char *) 0xFF89 },
	{ "XK_KP_Enter", (char *) 0xFF8D },
	{ "XK_KP_F1", (char *) 0xFF91 },
	{ "XK_KP_F2", (char *) 0xFF92 },
	{ "XK_KP_F3", (char *) 0xFF93 },
	{ "XK_KP_F4", (char *) 0xFF94 },
	{ "XK_KP_Home", (char *) 0xFF95 },
	{ "XK_KP_Left", (char *) 0xFF96 },
	{ "XK_KP_Up", (char *) 0xFF97 },
	{ "XK_KP_Right", (char *) 0xFF98 },
	{ "XK_KP_Down", (char *) 0xFF99 },
	{ "XK_KP_Prior", (char *) 0xFF9A },
	{ "XK_KP_Page_Up", (char *) 0xFF9A },
	{ "XK_KP_Next", (char *) 0xFF9B },
	{ "XK_KP_Page_Down", (char *) 0xFF9B },
	{ "XK_KP_End", (char *) 0xFF9C },
	{ "XK_KP_Begin", (char *) 0xFF9D },
	{ "XK_KP_Insert", (char *) 0xFF9E },
	{ "XK_KP_Delete", (char *) 0xFF9F },
	{ "XK_KP_Equal", (char *) 0xFFBD },
	{ "XK_KP_Multiply", (char *) 0xFFAA },
	{ "XK_KP_Add", (char *) 0xFFAB },
	{ "XK_KP_Separator", (char *) 0xFFAC },
	{ "XK_KP_Subtract", (char *) 0xFFAD },
	{ "XK_KP_Decimal", (char *) 0xFFAE },
	{ "XK_KP_Divide", (char *) 0xFFAF },
	{ "XK_KP_0", (char *) 0xFFB0 },
	{ "XK_KP_1", (char *) 0xFFB1 },
	{ "XK_KP_2", (char *) 0xFFB2 },
	{ "XK_KP_3", (char *) 0xFFB3 },
	{ "XK_KP_4", (char *) 0xFFB4 },
	{ "XK_KP_5", (char *) 0xFFB5 },
	{ "XK_KP_6", (char *) 0xFFB6 },
	{ "XK_KP_7", (char *) 0xFFB7 },
	{ "XK_KP_8", (char *) 0xFFB8 },
	{ "XK_KP_9", (char *) 0xFFB9 },
	{ "XK_F1", (char *) 0xFFBE },
	{ "XK_F2", (char *) 0xFFBF },
	{ "XK_F3", (char *) 0xFFC0 },
	{ "XK_F4", (char *) 0xFFC1 },
	{ "XK_F5", (char *) 0xFFC2 },
	{ "XK_F6", (char *) 0xFFC3 },
	{ "XK_F7", (char *) 0xFFC4 },
	{ "XK_F8", (char *) 0xFFC5 },
	{ "XK_F9", (char *) 0xFFC6 },
	{ "XK_F10", (char *) 0xFFC7 },
	{ "XK_F11", (char *) 0xFFC8 },
	{ "XK_L1", (char *) 0xFFC8 },
	{ "XK_F12", (char *) 0xFFC9 },
	{ "XK_L2", (char *) 0xFFC9 },
	{ "XK_F13", (char *) 0xFFCA },
	{ "XK_L3", (char *) 0xFFCA },
	{ "XK_F14", (char *) 0xFFCB },
	{ "XK_L4", (char *) 0xFFCB },
	{ "XK_F15", (char *) 0xFFCC },
	{ "XK_L5", (char *) 0xFFCC },
	{ "XK_F16", (char *) 0xFFCD },
	{ "XK_L6", (char *) 0xFFCD },
	{ "XK_F17", (char *) 0xFFCE },
	{ "XK_L7", (char *) 0xFFCE },
	{ "XK_F18", (char *) 0xFFCF },
	{ "XK_L8", (char *) 0xFFCF },
	{ "XK_F19", (char *) 0xFFD0 },
	{ "XK_L9", (char *) 0xFFD0 },
	{ "XK_F20", (char *) 0xFFD1 },
	{ "XK_L10", (char *) 0xFFD1 },
	{ "XK_F21", (char *) 0xFFD2 },
	{ "XK_R1", (char *) 0xFFD2 },
	{ "XK_F22", (char *) 0xFFD3 },
	{ "XK_R2", (char *) 0xFFD3 },
	{ "XK_F23", (char *) 0xFFD4 },
	{ "XK_R3", (char *) 0xFFD4 },
	{ "XK_F24", (char *) 0xFFD5 },
	{ "XK_R4", (char *) 0xFFD5 },
	{ "XK_F25", (char *) 0xFFD6 },
	{ "XK_R5", (char *) 0xFFD6 },
	{ "XK_F26", (char *) 0xFFD7 },
	{ "XK_R6", (char *) 0xFFD7 },
	{ "XK_F27", (char *) 0xFFD8 },
	{ "XK_R7", (char *) 0xFFD8 },
	{ "XK_F28", (char *) 0xFFD9 },
	{ "XK_R8", (char *) 0xFFD9 },
	{ "XK_F29", (char *) 0xFFDA },
	{ "XK_R9", (char *) 0xFFDA },
	{ "XK_F30", (char *) 0xFFDB },
	{ "XK_R10", (char *) 0xFFDB },
	{ "XK_F31", (char *) 0xFFDC },
	{ "XK_R11", (char *) 0xFFDC },
	{ "XK_F32", (char *) 0xFFDD },
	{ "XK_R12", (char *) 0xFFDD },
	{ "XK_F33", (char *) 0xFFDE },
	{ "XK_R13", (char *) 0xFFDE },
	{ "XK_F34", (char *) 0xFFDF },
	{ "XK_R14", (char *) 0xFFDF },
	{ "XK_F35", (char *) 0xFFE0 },
	{ "XK_R15", (char *) 0xFFE0 }
};

char *modifierdb[Modifier_DB_Length][2] = {
	{ "XK_Shift_L", (char *) 0xFFE1 },
	{ "XK_Shift_R", (char *) 0xFFE2 },
	{ "XK_Control_L", (char *) 0xFFE3 },
	{ "XK_Control_R", (char *) 0xFFE4 },
	{ "XK_Caps_Lock", (char *) 0xFFE5 },
	{ "XK_Shift_Lock", (char *) 0xFFE6 },
	{ "XK_Meta_L", (char *) 0xFFE7 },
	{ "XK_Meta_R", (char *) 0xFFE8 },
	{ "XK_Alt_L", (char *) 0xFFE9 },
	{ "XK_Alt_R", (char *) 0xFFEA },
	{ "XK_Super_L", (char *) 0xFFEB },
	{ "XK_Super_R", (char *) 0xFFEC },
	{ "XK_Hyper_L", (char *) 0xFFED },
	{ "XK_Hyper_R", (char *) 0xFFEE }
};

char *japanesedb[Japanese_DB_Length][2] = {
	{ "XK_Kanji", (char *) 0xFF21 },
	{ "XK_Muhenkan", (char *) 0xFF22 },
	{ "XK_Henkan", (char *) 0xFF23 },
	{ "XK_Romaji", (char *) 0xFF24 },
	{ "XK_Hiragana", (char *) 0xFF25 },
	{ "XK_Katakana", (char *) 0xFF26 },
	{ "XK_Hiragana_Katakana", (char *) 0xFF27 },
	{ "XK_Zenkaku", (char *) 0xFF28 },
	{ "XK_Hankaku", (char *) 0xFF29 },
	{ "XK_Zenkaku_Hankaku", (char *) 0xFF2A },
	{ "XK_Touroku", (char *) 0xFF2B },
	{ "XK_Massyo", (char *) 0xFF2C },
	{ "XK_Kana_Lock", (char *) 0xFF2D },
	{ "XK_Kana_Shift", (char *) 0xFF2E },
	{ "XK_Eisu_Shift", (char *) 0xFF2F },
	{ "XK_Eisu_toggle", (char *) 0xFF30 },
	{ "XK_Kanji_Bangou", (char *) 0xFF37 },
	{ "XK_Zen_Koho", (char *) 0xFF3D },
	{ "XK_Mae_Koho", (char *) 0xFF3E }
};

char *iso9995db[iso9995_DB_Length][2] = {
	{ "XK_ISO_Lock", (char *) 0xFF01 },
	{ "XK_ISO_Level2_Latch", (char *) 0xFF02 },
	{ "XK_ISO_Level3_Shift", (char *) 0xFF03 },
	{ "XK_ISO_Level3_Latch", (char *) 0xFF04 },
	{ "XK_ISO_Level3_Lock", (char *) 0xFF05 },
	{ "XK_ISO_Group_Shift", (char *) 0xFF7E },
	{ "XK_ISO_Group_Latch", (char *) 0xFF06 },
	{ "XK_ISO_Group_Lock", (char *) 0xFF07 },
	{ "XK_ISO_Next_Group", (char *) 0xFF08 },
	{ "XK_ISO_Next_Group_Lock", (char *) 0xFF09 },
	{ "XK_ISO_Prev_Group", (char *) 0xFF0A },
	{ "XK_ISO_Prev_Group_Lock", (char *) 0xFF0B },
	{ "XK_ISO_First_Group", (char *) 0xFF0C },
	{ "XK_ISO_First_Group_Lock", (char *) 0xFF0D },
	{ "XK_ISO_Last_Group", (char *) 0xFF0E },
	{ "XK_ISO_Last_Group_Lock", (char *) 0xFF0F },
	{ "XK_ISO_Left_Tab", (char *) 0xFF20 },
	{ "XK_ISO_Move_Line_Up", (char *) 0xFF21 },
	{ "XK_ISO_Move_Line_Down", (char *) 0xFF22 },
	{ "XK_ISO_Partial_Line_Up", (char *) 0xFF23 },
	{ "XK_ISO_Partial_Line_Down", (char *) 0xFF24 },
	{ "XK_ISO_Partial_Space_Left", (char *) 0xFF25 },
	{ "XK_ISO_Partial_Space_Right", (char *) 0xFF26 },
	{ "XK_ISO_Set_Margin_Left", (char *) 0xFF27 },
	{ "XK_ISO_Set_Margin_Right", (char *) 0xFF28 },
	{ "XK_ISO_Release_Margin_Left", (char *) 0xFF29 },
	{ "XK_ISO_Release_Margin_Right", (char *) 0xFF2A },
	{ "XK_ISO_Release_Both_Margins", (char *) 0xFF2B },
	{ "XK_ISO_Fast_Cursor_Left", (char *) 0xFF2C },
	{ "XK_ISO_Fast_Cursor_Right", (char *) 0xFF2D },
	{ "XK_ISO_Fast_Cursor_Up", (char *) 0xFF2E },
	{ "XK_ISO_Fast_Cursor_Down", (char *) 0xFF2F },
	{ "XK_ISO_Continuous_Underline", (char *) 0xFF30 },
	{ "XK_ISO_Discontinuous_Underline", (char *) 0xFF31 },
	{ "XK_ISO_Emphasize", (char *) 0xFF32 },
	{ "XK_ISO_Center_Object", (char *) 0xFF33 },
	{ "XK_ISO_Enter", (char *) 0xFF34 },
	{ "XK_dead_grave", (char *) 0xFF50 },
	{ "XK_dead_acute", (char *) 0xFF51 },
	{ "XK_dead_circumflex", (char *) 0xFF52 },
	{ "XK_dead_tilde", (char *) 0xFF53 },
	{ "XK_dead_macron", (char *) 0xFF54 },
	{ "XK_dead_breve", (char *) 0xFF55 },
	{ "XK_dead_abovedot", (char *) 0xFF56 },
	{ "XK_dead_diaeresis", (char *) 0xFF57 },
	{ "XK_dead_abovering", (char *) 0xFF58 },
	{ "XK_dead_doubleacute", (char *) 0xFF59 },
	{ "XK_dead_caron", (char *) 0xFF5A },
	{ "XK_dead_cedilla", (char *) 0xFF5B },
	{ "XK_dead_ogonek", (char *) 0xFF5C },
	{ "XK_dead_iota", (char *) 0xFF5D },
	{ "XK_dead_voiced_sound", (char *) 0xFF5E },
	{ "XK_dead_semivoiced_sound", (char *) 0xFF5F },
	{ "XK_dead_belowdot", (char *) 0xFF60 },
	{ "XK_First_Virtual_Screen", (char *) 0xFFD0 },
	{ "XK_Prev_Virtual_Screen", (char *) 0xFFD1 },
	{ "XK_Next_Virtual_Screen", (char *) 0xFFD2 },
	{ "XK_Last_Virtual_Screen", (char *) 0xFFD4 },
	{ "XK_Terminate_Server", (char *) 0xFFD5 },
	{ "XK_AccessX_Enable", (char *) 0xFE70 },
	{ "XK_AccessX_Feedback_Enable", (char *) 0xFE71 },
	{ "XK_RepeatKeys_Enable", (char *) 0xFE72 },
	{ "XK_SlowKeys_Enable", (char *) 0xFE73 },
	{ "XK_BounceKeys_Enable", (char *) 0xFE74 },
	{ "XK_StickyKeys_Enable", (char *) 0xFE75 },
	{ "XK_MouseKeys_Enable", (char *) 0xFE76 },
	{ "XK_MouseKeys_Accel_Enable", (char *) 0xFE77 },
	{ "XK_Overlay1_Enable", (char *) 0xFE78 },
	{ "XK_Overlay2_Enable", (char *) 0xFE79 },
	{ "XK_AudibleBell_Enable", (char *) 0xFE7A },
	{ "XK_Pointer_Left", (char *) 0xFEE0 },
	{ "XK_Pointer_Right", (char *) 0xFEE1 },
	{ "XK_Pointer_Up", (char *) 0xFEE2 },
	{ "XK_Pointer_Down", (char *) 0xFEE3 },
	{ "XK_Pointer_UpLeft", (char *) 0xFEE4 },
	{ "XK_Pointer_UpRight", (char *) 0xFEE5 },
	{ "XK_Pointer_DownLeft", (char *) 0xFEE6 },
	{ "XK_Pointer_DownRight", (char *) 0xFEE7 },
	{ "XK_Pointer_Button_Dflt", (char *) 0xFEE8 },
	{ "XK_Pointer_Button1", (char *) 0xFEE9 },
	{ "XK_Pointer_Button2", (char *) 0xFEEA },
	{ "XK_Pointer_Button3", (char *) 0xFEEB },
	{ "XK_Pointer_Button4", (char *) 0xFEEC },
	{ "XK_Pointer_Button5", (char *) 0xFEED },
	{ "XK_Pointer_DblClick_Dflt", (char *) 0xFEEE },
	{ "XK_Pointer_DblClick1", (char *) 0xFEEF },
	{ "XK_Pointer_DblClick2", (char *) 0xFEF0 },
	{ "XK_Pointer_DblClick3", (char *) 0xFEF1 },
	{ "XK_Pointer_DblClick4", (char *) 0xFEF2 },
	{ "XK_Pointer_DblClick5", (char *) 0xFEF3 },
	{ "XK_Pointer_Drag_Dflt", (char *) 0xFEF4 },
	{ "XK_Pointer_Drag1", (char *) 0xFEF5 },
	{ "XK_Pointer_Drag2", (char *) 0xFEF6 },
	{ "XK_Pointer_Drag3", (char *) 0xFEF7 },
	{ "XK_Pointer_Drag4", (char *) 0xFEF8 },
	{ "XK_Pointer_Drag5", (char *) 0xFEFD },
	{ "XK_Pointer_EnableKeys", (char *) 0xFEF9 },
	{ "XK_Pointer_Accelerate", (char *) 0xFEFA },
	{ "XK_Pointer_DfltBtnNext", (char *) 0xFEFB },
	{ "XK_Pointer_DfltBtnPrev", (char *) 0xFEFC }
};

char *i3270db[i3270_DB_Length][2] = {
	{ "XK_3270_Duplicate", (char *) 0xFD01 },
	{ "XK_3270_FieldMark", (char *) 0xFD02 },
	{ "XK_3270_Right2", (char *) 0xFD03 },
	{ "XK_3270_Left2", (char *) 0xFD04 },
	{ "XK_3270_BackTab", (char *) 0xFD05 },
	{ "XK_3270_EraseEOF", (char *) 0xFD06 },
	{ "XK_3270_EraseInput", (char *) 0xFD07},
	{ "XK_3270_Reset", (char *) 0xFD08 },
	{ "XK_3270_Quit", (char *) 0xFD09 },
	{ "XK_3270_PA1", (char *) 0xFD0A },
	{ "XK_3270_PA2", (char *) 0xFD0B },
	{ "XK_3270_PA3", (char *) 0xFD0C },
	{ "XK_3270_Test", (char *) 0xFD0D },
	{ "XK_3270_Attn", (char *) 0xFD0E },
	{ "XK_3270_CursorBlink", (char *) 0xFD0F },
	{ "XK_3270_AltCursor", (char *) 0xFD10 },
	{ "XK_3270_KeyClick", (char *) 0xFD11 },
	{ "XK_3270_Jump", (char *) 0xFD12 },
	{ "XK_3270_Indent", (char *) 0xFD13 },
	{ "XK_3270_Rule", (char *) 0xFD14 },
	{ "XK_3270_Copy", (char *) 0xFD15 },
	{ "XK_3270_Play", (char *) 0xFD16 },
	{ "XK_3270_Setup", (char *) 0xFD17 },
	{ "XK_3270_Record", (char *) 0xFD18 },
	{ "XK_3270_ChangeScreen", (char *) 0xFD19 },
	{ "XK_3270_DeleteWord", (char *) 0xFD1A },
	{ "XK_3270_ExSelect", (char *) 0xFD1B },
	{ "XK_3270_CursorSelect", (char *) 0xFD1C },
	{ "XK_3270_PrintScreen", (char *) 0xFD1D },
	{ "XK_3270_Enter", (char *) 0xFD1E }
};

char *latindb[Latin_DB_Length][2] = {
	{ "XK_space", (char *) 0x020 },
	{ "XK_exclam", (char *) 0x021 },
	{ "XK_quotedbl", (char *) 0x022 },
	{ "XK_numbersign", (char *) 0x023 },
	{ "XK_dollar", (char *) 0x024 },
	{ "XK_percent", (char *) 0x025 },
	{ "XK_ampersand", (char *) 0x026 },
	{ "XK_apostrophe", (char *) 0x027 },
	{ "XK_quoteright", (char *) 0x027 },
	{ "XK_parenleft", (char *) 0x028 },
	{ "XK_parenright", (char *) 0x029 },
	{ "XK_asterisk", (char *) 0x02a },
	{ "XK_plus", (char *) 0x02b },
	{ "XK_comma", (char *) 0x02c },
	{ "XK_minus", (char *) 0x02d },
	{ "XK_period", (char *) 0x02e },
	{ "XK_slash", (char *) 0x02f },
	{ "XK_0", (char *) 0x030 },
	{ "XK_1", (char *) 0x031 },
	{ "XK_2", (char *) 0x032 },
	{ "XK_3", (char *) 0x033 },
	{ "XK_4", (char *) 0x034 },
	{ "XK_5", (char *) 0x035 },
	{ "XK_6", (char *) 0x036 },
	{ "XK_7", (char *) 0x037 },
	{ "XK_8", (char *) 0x038 },
	{ "XK_9", (char *) 0x039 },
	{ "XK_colon", (char *) 0x03a },
	{ "XK_semicolon", (char *) 0x03b },
	{ "XK_less", (char *) 0x03c },
	{ "XK_equal", (char *) 0x03d },
	{ "XK_greater", (char *) 0x03e },
	{ "XK_question", (char *) 0x03f },
	{ "XK_at", (char *) 0x040 },
	{ "XK_A", (char *) 0x041 },
	{ "XK_B", (char *) 0x042 },
	{ "XK_C", (char *) 0x043 },
	{ "XK_D", (char *) 0x044 },
	{ "XK_E", (char *) 0x045 },
	{ "XK_F", (char *) 0x046 },
	{ "XK_G", (char *) 0x047 },
	{ "XK_H", (char *) 0x048 },
	{ "XK_I", (char *) 0x049 },
	{ "XK_J", (char *) 0x04a },
	{ "XK_K", (char *) 0x04b },
	{ "XK_L", (char *) 0x04c },
	{ "XK_M", (char *) 0x04d },
	{ "XK_N", (char *) 0x04e },
	{ "XK_O", (char *) 0x04f },
	{ "XK_P", (char *) 0x050 },
	{ "XK_Q", (char *) 0x051 },
	{ "XK_R", (char *) 0x052 },
	{ "XK_S", (char *) 0x053 },
	{ "XK_T", (char *) 0x054 },
	{ "XK_U", (char *) 0x055 },
	{ "XK_V", (char *) 0x056 },
	{ "XK_W", (char *) 0x057 },
	{ "XK_X", (char *) 0x058 },
	{ "XK_Y", (char *) 0x059 },
	{ "XK_Z", (char *) 0x05a },
	{ "XK_bracketleft", (char *) 0x05b },
	{ "XK_backslash", (char *) 0x05c },
	{ "XK_bracketright", (char *) 0x05d },
	{ "XK_asciicircum", (char *) 0x05e },
	{ "XK_underscore", (char *) 0x05f },
	{ "XK_grave", (char *) 0x060 },
	{ "XK_quoteleft", (char *) 0x060 },
	{ "XK_a", (char *) 0x061 },
	{ "XK_b", (char *) 0x062 },
	{ "XK_c", (char *) 0x063 },
	{ "XK_d", (char *) 0x064 },
	{ "XK_e", (char *) 0x065 },
	{ "XK_f", (char *) 0x066 },
	{ "XK_g", (char *) 0x067 },
	{ "XK_h", (char *) 0x068 },
	{ "XK_i", (char *) 0x069 },
	{ "XK_j", (char *) 0x06a },
	{ "XK_k", (char *) 0x06b },
	{ "XK_l", (char *) 0x06c },
	{ "XK_m", (char *) 0x06d },
	{ "XK_n", (char *) 0x06e },
	{ "XK_o", (char *) 0x06f },
	{ "XK_p", (char *) 0x070 },
	{ "XK_q", (char *) 0x071 },
	{ "XK_r", (char *) 0x072 },
	{ "XK_s", (char *) 0x073 },
	{ "XK_t", (char *) 0x074 },
	{ "XK_u", (char *) 0x075 },
	{ "XK_v", (char *) 0x076 },
	{ "XK_w", (char *) 0x077 },
	{ "XK_x", (char *) 0x078 },
	{ "XK_y", (char *) 0x079 },
	{ "XK_z", (char *) 0x07a },
	{ "XK_braceleft", (char *) 0x07b },
	{ "XK_bar", (char *) 0x07c },
	{ "XK_braceright", (char *) 0x07d },
	{ "XK_asciitilde", (char *) 0x07e },
	{ "XK_nobreakspace", (char *) 0x0a0 },
	{ "XK_exclamdown", (char *) 0x0a1 },
	{ "XK_cent", (char *) 0x0a2 },
	{ "XK_sterling", (char *) 0x0a3 },
	{ "XK_currency", (char *) 0x0a4 },
	{ "XK_yen", (char *) 0x0a5 },
	{ "XK_brokenbar", (char *) 0x0a6 },
	{ "XK_section", (char *) 0x0a7 },
	{ "XK_diaeresis", (char *) 0x0a8 },
	{ "XK_copyright", (char *) 0x0a9 },
	{ "XK_ordfeminine", (char *) 0x0aa },
	{ "XK_guillemotleft", (char *) 0x0ab },
	{ "XK_notsign", (char *) 0x0ac },
	{ "XK_hyphen", (char *) 0x0ad },
	{ "XK_registered", (char *) 0x0ae },
	{ "XK_macron", (char *) 0x0af },
	{ "XK_degree", (char *) 0x0b0 },
	{ "XK_plusminus", (char *) 0x0b1 },
	{ "XK_twosuperior", (char *) 0x0b2 },
	{ "XK_threesuperior", (char *) 0x0b3 },
	{ "XK_acute", (char *) 0x0b4 },
	{ "XK_mu", (char *) 0x0b5 },
	{ "XK_paragraph", (char *) 0x0b6 },
	{ "XK_periodcentered", (char *) 0x0b7 },
	{ "XK_cedilla", (char *) 0x0b8 },
	{ "XK_onesuperior", (char *) 0x0b9 },
	{ "XK_masculine", (char *) 0x0ba },
	{ "XK_guillemotright", (char *) 0x0bb },
	{ "XK_onequarter", (char *) 0x0bc },
	{ "XK_onehalf", (char *) 0x0bd },
	{ "XK_threequarters", (char *) 0x0be },
	{ "XK_questiondown", (char *) 0x0bf },
	{ "XK_Agrave", (char *) 0x0c0 },
	{ "XK_Aacute", (char *) 0x0c1 },
	{ "XK_Acircumflex", (char *) 0x0c2 },
	{ "XK_Atilde", (char *) 0x0c3 },
	{ "XK_Adiaeresis", (char *) 0x0c4 },
	{ "XK_Aring", (char *) 0x0c5 },
	{ "XK_AE", (char *) 0x0c6 },
	{ "XK_Ccedilla", (char *) 0x0c7 },
	{ "XK_Egrave", (char *) 0x0c8 },
	{ "XK_Eacute", (char *) 0x0c9 },
	{ "XK_Ecircumflex", (char *) 0x0ca },
	{ "XK_Ediaeresis", (char *) 0x0cb },
	{ "XK_Igrave", (char *) 0x0cc },
	{ "XK_Iacute", (char *) 0x0cd },
	{ "XK_Icircumflex", (char *) 0x0ce },
	{ "XK_Idiaeresis", (char *) 0x0cf },
	{ "XK_ETH", (char *) 0x0d0 },
	{ "XK_Ntilde", (char *) 0x0d1 },
	{ "XK_Ograve", (char *) 0x0d2 },
	{ "XK_Oacute", (char *) 0x0d3 },
	{ "XK_Ocircumflex", (char *) 0x0d4 },
	{ "XK_Otilde", (char *) 0x0d5 },
	{ "XK_Odiaeresis", (char *) 0x0d6 },
	{ "XK_multiply", (char *) 0x0d7 },
	{ "XK_Ooblique", (char *) 0x0d8 },
	{ "XK_Ugrave", (char *) 0x0d9 },
	{ "XK_Uacute", (char *) 0x0da },
	{ "XK_Ucircumflex", (char *) 0x0db },
	{ "XK_Udiaeresis", (char *) 0x0dc },
	{ "XK_Yacute", (char *) 0x0dd },
	{ "XK_THORN", (char *) 0x0de },
	{ "XK_ssharp", (char *) 0x0df },
	{ "XK_agrave", (char *) 0x0e0 },
	{ "XK_aacute", (char *) 0x0e1 },
	{ "XK_acircumflex", (char *) 0x0e2 },
	{ "XK_atilde", (char *) 0x0e3 },
	{ "XK_adiaeresis", (char *) 0x0e4 },
	{ "XK_aring", (char *) 0x0e5 },
	{ "XK_ae", (char *) 0x0e6 },
	{ "XK_ccedilla", (char *) 0x0e7 },
	{ "XK_egrave", (char *) 0x0e8 },
	{ "XK_eacute", (char *) 0x0e9 },
	{ "XK_ecircumflex", (char *) 0x0ea },
	{ "XK_ediaeresis", (char *) 0x0eb },
	{ "XK_igrave", (char *) 0x0ec },
	{ "XK_iacute", (char *) 0x0ed },
	{ "XK_icircumflex", (char *) 0x0ee },
	{ "XK_idiaeresis", (char *) 0x0ef },
	{ "XK_eth", (char *) 0x0f0 },
	{ "XK_ntilde", (char *) 0x0f1 },
	{ "XK_ograve", (char *) 0x0f2 },
	{ "XK_oacute", (char *) 0x0f3 },
	{ "XK_ocircumflex", (char *) 0x0f4 },
	{ "XK_otilde", (char *) 0x0f5 },
	{ "XK_odiaeresis", (char *) 0x0f6 },
	{ "XK_division", (char *) 0x0f7 },
	{ "XK_oslash", (char *) 0x0f8 },
	{ "XK_ugrave", (char *) 0x0f9 },
	{ "XK_uacute", (char *) 0x0fa },
	{ "XK_ucircumflex", (char *) 0x0fb },
	{ "XK_udiaeresis", (char *) 0x0fc },
	{ "XK_yacute", (char *) 0x0fd },
	{ "XK_thorn", (char *) 0x0fe },
	{ "XK_ydiaeresis", (char *) 0x0ff }
};

char *arabicdb[Arabic_DB_Length][2] = {
	{ "XK_Arabic_comma", (char *) 0x5ac },
	{ "XK_Arabic_semicolon", (char *) 0x5bb },
	{ "XK_Arabic_question_mark", (char *) 0x5bf },
	{ "XK_Arabic_hamza", (char *) 0x5c1 },
	{ "XK_Arabic_maddaonalef", (char *) 0x5c2 },
	{ "XK_Arabic_hamzaonalef", (char *) 0x5c3 },
	{ "XK_Arabic_hamzaonwaw", (char *) 0x5c4 },
	{ "XK_Arabic_hamzaunderalef", (char *) 0x5c5 },
	{ "XK_Arabic_hamzaonyeh", (char *) 0x5c6 },
	{ "XK_Arabic_alef", (char *) 0x5c7 },
	{ "XK_Arabic_beh", (char *) 0x5c8 },
	{ "XK_Arabic_tehmarbuta", (char *) 0x5c9 },
	{ "XK_Arabic_teh", (char *) 0x5ca },
	{ "XK_Arabic_theh", (char *) 0x5cb },
	{ "XK_Arabic_jeem", (char *) 0x5cc },
	{ "XK_Arabic_hah", (char *) 0x5cd },
	{ "XK_Arabic_khah", (char *) 0x5ce },
	{ "XK_Arabic_dal", (char *) 0x5cf },
	{ "XK_Arabic_thal", (char *) 0x5d0 },
	{ "XK_Arabic_ra", (char *) 0x5d1 },
	{ "XK_Arabic_zain", (char *) 0x5d2 },
	{ "XK_Arabic_seen", (char *) 0x5d3 },
	{ "XK_Arabic_sheen", (char *) 0x5d4 },
	{ "XK_Arabic_sad", (char *) 0x5d5 },
	{ "XK_Arabic_dad", (char *) 0x5d6 },
	{ "XK_Arabic_tah", (char *) 0x5d7 },
	{ "XK_Arabic_zah", (char *) 0x5d8 },
	{ "XK_Arabic_ain", (char *) 0x5d9 },
	{ "XK_Arabic_ghain", (char *) 0x5da },
	{ "XK_Arabic_tatweel", (char *) 0x5e0 },
	{ "XK_Arabic_feh", (char *) 0x5e1 },
	{ "XK_Arabic_qaf", (char *) 0x5e2 },
	{ "XK_Arabic_kaf", (char *) 0x5e3 },
	{ "XK_Arabic_laf", (char *) 0x5e4 },
	{ "XK_Arabic_meem", (char *) 0x5e5 },
	{ "XK_Arabic_noon", (char *) 0x5e6 },
	{ "XK_Arabic_ha", (char *) 0x5e7 },
	{ "XK_Arabic_waw", (char *) 0x5e8 },
	{ "XK_Arabic_alefmaksura", (char *) 0x5e9 },
	{ "XK_Arabic_yeh", (char *) 0x5ea },
	{ "XK_Arabic_fathatan", (char *) 0x5eb },
	{ "XK_Arabic_dammatan", (char *) 0x5ec },
	{ "XK_Arabic_kasratan", (char *) 0x5ed },
	{ "XK_Arabic_fatha", (char *) 0x5ee },
	{ "XK_Arabic_damma", (char *) 0x5ef },
	{ "XK_Arabic_kasra", (char *) 0x5f0 },
	{ "XK_Arabic_shadda", (char *) 0x5f1 },
	{ "XK_Arabic_sukun", (char *) 0x5f2 },
	{ "XK_Arabic_switch", (char *) 0xFF7E }
};

char *cyrillicdb[Cyrillic_DB_Length][2] = {
	{ "XK_Serbian_dje", (char *) 0x6a1 },
	{ "XK_Skopje_gje", (char *) 0x6a2 },
	{ "XK_Cyrillic_io", (char *) 0x6a3 },
	{ "XK_Ukranian_je", (char *) 0x6a4 },
	{ "XK_Skopje_dse", (char *) 0x6a5 },
	{ "XK_Ukranian_i", (char *) 0x6a6 },
	{ "XK_Ukranian_yi", (char *) 0x6a7 },
	{ "XK_Cyrillic_je", (char *) 0x6a8 },
	{ "XK_Cyrillic_lje", (char *) 0x6a9 },
	{ "XK_Cyrillic_nje", (char *) 0x6aa },
	{ "XK_Serbian_tshe", (char *) 0x6ab },
	{ "XK_Skopje_kje", (char *) 0x6ac },
	{ "XK_Ukranian_ghe_with_upturn", (char *) 0x6ad },
	{ "XK_Byelorussian_shortu", (char *) 0x6ae },
	{ "XK_Cyrillic_dzhe", (char *) 0x6af },
	{ "XK_numerosign", (char *) 0x6b0 },
	{ "XK_Serbian_DJE", (char *) 0x6b1 },
	{ "XK_Skopje_GJE", (char *) 0x6b2 },
	{ "XK_Cyrillic_IO", (char *) 0x6b3 },
	{ "XK_Ukranian_JE", (char *) 0x6b4 },
	{ "XK_Skopje_DSE", (char *) 0x6b5 },
	{ "XK_Ukranian_I", (char *) 0x6b6 },
	{ "XK_Ukranian_YI", (char *) 0x6b7 },
	{ "XK_Cyrillic_JE", (char *) 0x6b8 },
	{ "XK_Cyrillic_LJE", (char *) 0x6b9 },
	{ "XK_Cyrillic_NJE", (char *) 0x6ba },
	{ "XK_Serbian_TSHE", (char *) 0x6bb },
	{ "XK_Skopje_KJE", (char *) 0x6bc },
	{ "XK_Ukranian_GHE_WITH_UPTURN", (char *) 0x6bd },
	{ "XK_Byelorussian_SHORTU", (char *) 0x6be },
	{ "XK_Cyrillic_DZHE", (char *) 0x6bf },
	{ "XK_Cyrillic_yu", (char *) 0x6c0 },
	{ "XK_Cyrillic_a", (char *) 0x6c1 },
	{ "XK_Cyrillic_be", (char *) 0x6c2 },
	{ "XK_Cyrillic_tse", (char *) 0x6c3 },
	{ "XK_Cyrillic_de", (char *) 0x6c4 },
	{ "XK_Cyrillic_ie", (char *) 0x6c5 },
	{ "XK_Cyrillic_ef", (char *) 0x6c6 },
	{ "XK_Cyrillic_ghe", (char *) 0x6c7 },
	{ "XK_Cyrillic_ha", (char *) 0x6c8 },
	{ "XK_Cyrillic_i", (char *) 0x6c9 },
	{ "XK_Cyrillic_shorti", (char *) 0x6ca },
	{ "XK_Cyrillic_ka", (char *) 0x6cb },
	{ "XK_Cyrillic_el", (char *) 0x6cc },
	{ "XK_Cyrillic_em", (char *) 0x6cd },
	{ "XK_Cyrillic_en", (char *) 0x6ce },
	{ "XK_Cyrillic_o", (char *) 0x6cf },
	{ "XK_Cyrillic_pe", (char *) 0x6d0 },
	{ "XK_Cyrillic_ya", (char *) 0x6d1 },
	{ "XK_Cyrillic_er", (char *) 0x6d2 },
	{ "XK_Cyrillic_es", (char *) 0x6d3 },
	{ "XK_Cyrillic_te", (char *) 0x6d4 },
	{ "XK_Cyrillic_u", (char *) 0x6d5 },
	{ "XK_Cyrillic_zhe", (char *) 0x6d6 },
	{ "XK_Cyrillic_ve", (char *) 0x6d7 },
	{ "XK_Cyrillic_softsign", (char *) 0x6d8 },
	{ "XK_Cyrillic_yeru", (char *) 0x6d9 },
	{ "XK_Cyrillic_ze", (char *) 0x6da },
	{ "XK_Cyrillic_sha", (char *) 0x6db },
	{ "XK_Cyrillic_e", (char *) 0x6dc },
	{ "XK_Cyrillic_shcha", (char *) 0x6dd },
	{ "XK_Cyrillic_che", (char *) 0x6de },
	{ "XK_Cyrillic_hardsign", (char *) 0x6df },
	{ "XK_Cyrillic_YU", (char *) 0x6e0 },
	{ "XK_Cyrillic_A", (char *) 0x6e1 },
	{ "XK_Cyrillic_BE", (char *) 0x6e2 },
	{ "XK_Cyrillic_TSE", (char *) 0x6e3 },
	{ "XK_Cyrillic_DE", (char *) 0x6e4 },
	{ "XK_Cyrillic_IE", (char *) 0x6e5 },
	{ "XK_Cyrillic_EF", (char *) 0x6e6 },
	{ "XK_Cyrillic_GHE", (char *) 0x6e7 },
	{ "XK_Cyrillic_HA", (char *) 0x6e8 },
	{ "XK_Cyrillic_I", (char *) 0x6e9 },
	{ "XK_Cyrillic_SHORTI", (char *) 0x6ea },
	{ "XK_Cyrillic_KA", (char *) 0x6eb },
	{ "XK_Cyrillic_EL", (char *) 0x6ec },
	{ "XK_Cyrillic_EM", (char *) 0x6ed },
	{ "XK_Cyrillic_EN", (char *) 0x6ee },
	{ "XK_Cyrillic_O", (char *) 0x6ef },
	{ "XK_Cyrillic_PE", (char *) 0x6f0 },
	{ "XK_Cyrillic_YA", (char *) 0x6f1 },
	{ "XK_Cyrillic_ER", (char *) 0x6f2 },
	{ "XK_Cyrillic_ES", (char *) 0x6f3 },
	{ "XK_Cyrillic_TE", (char *) 0x6f4 },
	{ "XK_Cyrillic_U", (char *) 0x6f5 },
	{ "XK_Cyrillic_ZHE", (char *) 0x6f6 },
	{ "XK_Cyrillic_VE", (char *) 0x6f7 },
	{ "XK_Cyrillic_SOFTSIGN", (char *) 0x6f8 },
	{ "XK_Cyrillic_YERU", (char *) 0x6f9 },
	{ "XK_Cyrillic_ZE", (char *) 0x6fa },
	{ "XK_Cyrillic_SHA", (char *) 0x6fb },
	{ "XK_Cyrillic_E", (char *) 0x6fc },
	{ "XK_Cyrillic_SHCHA", (char *) 0x6fd },
	{ "XK_Cyrillic_CHE", (char *) 0x6fe },
	{ "XK_Cyrillic_HARDSIGN", (char *) 0x6ff }
};

char *greekdb[Greek_DB_Length][2] = {
	{ "XK_Greek_ALPHAaccent", (char *) 0x7a1 },	
	{ "XK_Greek_EPSILONaccent", (char *) 0x7a2 },
	{ "XK_Greek_ETAaccent", (char *) 0x7a3 },
	{ "XK_Greek_IOTAaccent", (char *) 0x7a4 },
	{ "XK_Greek_IOTAdiaeresis", (char *) 0x7a5 },
	{ "XK_Greek_OMICRONaccent", (char *) 0x7a7 },
	{ "XK_Greek_UPSILONaccent", (char *) 0x7a8 },
	{ "XK_Greek_UPSILONdiaeresis", (char *) 0x7a9 },
	{ "XK_Greek_OMEGAaccent", (char *) 0x7ab },
	{ "XK_Greek_accentdiaeresis", (char *) 0x7ae },
	{ "XK_Greek_horizbar", (char *) 0x7af },
	{ "XK_Greek_alphaaccent", (char *) 0x7b1 },
	{ "XK_Greek_epsilonaccent", (char *) 0x7b2 },
	{ "XK_Greek_etaaccent", (char *) 0x7b3 },
	{ "XK_Greek_iotaaccent", (char *) 0x7b4 },
	{ "XK_Greek_iotadiaeresis", (char *) 0x7b5 },
	{ "XK_Greek_iotaaccentdiaeresis", (char *) 0x7b6 },
	{ "XK_Greek_omicronaccent", (char *) 0x7b7 },
	{ "XK_Greek_upsilonaccent", (char *) 0x7b8 },
	{ "XK_Greek_upsilondiaeresis", (char *) 0x7b9 },
	{ "XK_Greek_upsilonaccentdiaeresis", (char *) 0x7ba },
	{ "XK_Greek_omegaaccent", (char *) 0x7bb },
	{ "XK_Greek_ALPHA", (char *) 0x7c1 },
	{ "XK_Greek_BETA", (char *) 0x7c2 },
	{ "XK_Greek_GAMMA", (char *) 0x7c3 },
	{ "XK_Greek_DELTA", (char *) 0x7c4 },
	{ "XK_Greek_EPSILON", (char *) 0x7c5 },
	{ "XK_Greek_ZETA", (char *) 0x7c6 },
	{ "XK_Greek_ETA", (char *) 0x7c7 },
	{ "XK_Greek_THETA", (char *) 0x7c8 },
	{ "XK_Greek_IOTA", (char *) 0x7c9 },
	{ "XK_Greek_KAPPA", (char *) 0x7ca },
	{ "XK_Greek_LAMBDA", (char *) 0x7cb },
	{ "XK_Greek_MU", (char *) 0x7cc },
	{ "XK_Greek_NU", (char *) 0x7cd },
	{ "XK_Greek_XI", (char *) 0x7ce },
	{ "XK_Greek_OMICRON", (char *) 0x7cf },
	{ "XK_Greek_PI", (char *) 0x7d0 },
	{ "XK_Greek_RHO", (char *) 0x7d1 },
	{ "XK_Greek_SIGMA", (char *) 0x7d2 },
	{ "XK_Greek_TAU", (char *) 0x7d4 },
	{ "XK_Greek_UPSILON", (char *) 0x7d5 },
	{ "XK_Greek_PHI", (char *) 0x7d6 },
	{ "XK_Greek_CHI", (char *) 0x7d7 },
	{ "XK_Greek_PSI", (char *) 0x7d8 },
	{ "XK_Greek_OMEGA", (char *) 0x7d9 },
	{ "XK_Greek_alpha", (char *) 0x7e1 },
	{ "XK_Greek_beta", (char *) 0x7e2 },
	{ "XK_Greek_gamma", (char *) 0x7e3 },
	{ "XK_Greek_delta", (char *) 0x7e4 },
	{ "XK_Greek_epsilon", (char *) 0x7e5 },
	{ "XK_Greek_zeta", (char *) 0x7e6 },
	{ "XK_Greek_eta", (char *) 0x7e7 },
	{ "XK_Greek_theta", (char *) 0x7e8 },
	{ "XK_Greek_iota", (char *) 0x7e9 },
	{ "XK_Greek_kappa", (char *) 0x7ea },
	{ "XK_Greek_lambda", (char *) 0x7eb },
	{ "XK_Greek_mu", (char *) 0x7ec },
	{ "XK_Greek_nu", (char *) 0x7ed },
	{ "XK_Greek_xi", (char *) 0x7ee },
	{ "XK_Greek_omicron", (char *) 0x7ef0 },
	{ "XK_Greek_pi", (char *) 0x7f1 },
	{ "XK_Greek_rho", (char *) 0x7f2 },
	{ "XK_Greek_sigma", (char *) 0x7f3 },
	{ "XK_Greek_tau", (char *) 0x7f4 },
	{ "XK_Greek_upsilon", (char *) 0x7f5 },
	{ "XK_Greek_phi", (char *) 0x7f6 },
	{ "XK_Greek_chi", (char *) 0x7f7 },
	{ "XK_Greek_psi", (char *) 0x7f8 },
	{ "XK_Greek_omega", (char *) 0x7f9 },
	{ "XK_Greek_switch", (char *) 0xFF7E }
};

char *technicaldb[Technical_DB_Length][2] = {
	{ "XK_leftradical", (char *) 0x8a1 },
	{ "XK_topleftradical", (char *) 0x8a2 },
	{ "XK_horizconnector", (char *) 0x8a3 },
	{ "XK_topintegral", (char *) 0x8a4 },
	{ "XK_botintegral", (char *) 0x8a5 },
	{ "XK_vertconnector", (char *) 0x8a6 },
	{ "XK_topleftsqbracket", (char *) 0x8a7 },
	{ "XK_botleftsqbracket", (char *) 0x8a8 },
	{ "XK_toprightsqbracket", (char *) 0x8a9 },
	{ "XK_bottomrightsqbracket", (char *) 0x8aa },
	{ "XK_topleftparens", (char *) 0x8ab },
	{ "XK_botleftparens", (char *) 0x8ac },
	{ "XK_toprightparens", (char *) 0x8ad },
	{ "XK_botrightparens", (char *) 0x8ae },
	{ "XK_leftmiddlecurlybrace", (char *) 0x8af },
	{ "XK_rightmiddlecurlybrace", (char *) 0x8b0 },
	{ "XK_topleftsummation", (char *) 0x8b1 },
	{ "XK_botleftsummation", (char *) 0x8b2 },
	{ "XK_topvertsummationconnector", (char *) 0x8b3 },
	{ "XK_botvertsummationconnector", (char *) 0x8b4 },
	{ "XK_toprightsummation", (char *) 0x8b5 },
	{ "XK_botrightsummation", (char *) 0x8b6 },
	{ "XK_rightmiddlesummation", (char *) 0x8b7 },
	{ "XK_lessthanequal", (char *) 0x8bc },
	{ "XK_notequal", (char *) 0x8bd },
	{ "XK_greaterthanequal", (char *) 0x8be },
	{ "XK_integral", (char *) 0x8bf },
	{ "XK_therefore", (char *) 0x8c0 },
	{ "XK_variation", (char *) 0x8c1 },
	{ "XK_infinity", (char *) 0x8c2 },
	{ "XK_nabla", (char *) 0x8c5 },
	{ "XK_approximate", (char *) 0x8c8 },
	{ "XK_similarequal", (char *) 0x8c9 },
	{ "XK_ifonlyif", (char *) 0x8cd },
	{ "XK_implies", (char *) 0x8ce },
	{ "XK_identical", (char *) 0x8cf },
	{ "XK_radical", (char *) 0x8d6 },
	{ "XK_includedin", (char *) 0x8da },
	{ "XK_includes", (char *) 0x8db },
	{ "XK_intersection", (char *) 0x8dc },
	{ "XK_union", (char *) 0x8dd },
	{ "XK_logicaland", (char *) 0x8de },
	{ "XK_logicalor", (char *) 0x8df },
	{ "XK_partialderivative", (char *) 0x8ef },
	{ "XK_function", (char *) 0x8f6 },
	{ "XK_leftarrow", (char *) 0x8fb },
	{ "XK_uparrow", (char *) 0x8fc },
	{ "XK_rightarrow", (char *) 0x8fd },
	{ "XK_downarrow", (char *) 0x8fe }
};

char *publishingdb[Publishing_DB_Length][2] = {
	{ "XK_emspace", (char *) 0xaa1 },
	{ "XK_enspace", (char *) 0xaa2 },
	{ "XK_em3space", (char *) 0xaa3 },
	{ "XK_em4space", (char *) 0xaa4 },
	{ "XK_digitspace", (char *) 0xaa5 },
	{ "XK_punctspace", (char *) 0xaa6 },
	{ "XK_thinspace", (char *) 0xaa7 },
	{ "XK_hairspace", (char *) 0xaa8 },
	{ "XK_emdash", (char *) 0xaa9 },
	{ "XK_endash", (char *) 0xaaa },
	{ "XK_signifblack", (char *) 0xaac },
	{ "XK_ellipsis", (char *) 0xaae },
	{ "XK_doubbaselinedot", (char *) 0xaaf },
	{ "XK_onethird", (char *) 0xab0 },
	{ "XK_twothirds", (char *) 0xab1 },
	{ "XK_onefifth", (char *) 0xab2 },
	{ "XK_twofifths", (char *) 0xab3 },
	{ "XK_threefifths", (char *) 0xab4 },
	{ "XK_fourfifths", (char *) 0xab5 },
	{ "XK_onesixth", (char *) 0xab6 },
	{ "XK_fivesixths", (char *) 0xab7 },
	{ "XK_careof", (char *) 0xab8 },
	{ "XK_figdash", (char *) 0xabb },
	{ "XK_leftanglebracket", (char *) 0xabc },
	{ "XK_decimalpoint", (char *) 0xabd },
	{ "XK_rightanglebracket", (char *) 0xabe },
	{ "XK_marker", (char *) 0xabf },
	{ "XK_oneeighth", (char *) 0xac3 },
	{ "XK_threeeighths", (char *) 0xac4 },
	{ "XK_fiveeighths", (char *) 0xac5 },
	{ "XK_seveneighths", (char *) 0xac6 },
	{ "XK_trademark", (char *) 0xac9 },
	{ "XK_signaturemark", (char *) 0xaca },
	{ "XK_trademarkincircle", (char *) 0xacb },
	{ "XK_leftopentriangle", (char *) 0xacc },
	{ "XK_rightopentriangle", (char *) 0xacd },
	{ "XK_emopencircle", (char *) 0xace },
	{ "XK_emopenrectangle", (char *) 0xacf },
	{ "XK_leftsinglequotemark", (char *) 0xad0 },
	{ "XK_rightsinglequotemark", (char *) 0xad1 },
	{ "XK_leftdoublequotemark", (char *) 0xad2 },
	{ "XK_rightdoublequotemark", (char *) 0xad3 },
	{ "XK_prescription", (char *) 0xad4 },
	{ "XK_minutes", (char *) 0xad6 },
	{ "XK_seconds", (char *) 0xad7 },
	{ "XK_latincross", (char *) 0xad9 },
	{ "XK_hexagram", (char *) 0xada },
	{ "XK_filledrectbullet", (char *) 0xadb },
	{ "XK_filledlefttribullet", (char *) 0xadc },
	{ "XK_filledrighttribullet", (char *) 0xadd },
	{ "XK_emfilledcircle", (char *) 0xade },
	{ "XK_emfilledrect", (char *) 0xadf },
	{ "XK_enopencircbullet", (char *) 0xae0 },
	{ "XK_enopensquarebullet", (char *) 0xae1 },
	{ "XK_openrectbullet", (char *) 0xae2 },
	{ "XK_opentribulletup", (char *) 0xae3 },
	{ "XK_opentribulletdown", (char *) 0xae4 },
	{ "XK_openstar", (char *) 0xae5 },
	{ "XK_enfilledcircbullet", (char *) 0xae6 },
	{ "XK_enfilledsqbullet", (char *) 0xae7 },
	{ "XK_filledtribulletup", (char *) 0xae8 },
	{ "XK_filledtribulletdown", (char *) 0xae9 },
	{ "XK_leftpointer", (char *) 0xaea },
	{ "XK_rightpointer", (char *) 0xaeb },
	{ "XK_club", (char *) 0xaec },
	{ "XK_diamond", (char *) 0xaed },
	{ "XK_heart", (char *) 0xaee },
	{ "XK_maltesecross", (char *) 0xaf0 },
	{ "XK_dagger", (char *) 0xaf1 },
	{ "XK_doubledagger", (char *) 0xaf2 },
	{ "XK_checkmark", (char *) 0xaf3 },
	{ "XK_ballotcross", (char *) 0xaf4 },
	{ "XK_musicalsharp", (char *) 0xaf5 },
	{ "XK_musicalflat", (char *) 0xaf6 },
	{ "XK_malesymbol", (char *) 0xaf7 },
	{ "XK_femalesymbol", (char *) 0xaf8 },
	{ "XK_telephone", (char *) 0xaf9 },
	{ "XK_telephonerecorder", (char *) 0xafa },
	{ "XK_phonographcopyright", (char *) 0xafb },
	{ "XK_caret", (char *) 0xafc },
	{ "XK_singlelowquotemark", (char *) 0xafd },
	{ "XK_doublelowquotemark", (char *) 0xafe },
	{ "XK_cursor", (char *) 0xaff }
};

char *hebrewdb[Hebrew_DB_Length][2] = {

};

char *thaidb[Thai_DB_Length][2] = {

};

char *koreandb[Korean_DB_Length][2] = {

};

char *armeniandb[Armenian_DB_Length][2] = {

};

char *georgiandb[Georgian_DB_Length][2] = {

};

char *currencydb[Currency_DB_Length][2] = {

};

char *katakanadb[Katakana_DB_Length][2] = {

};

void init_keysym_db( void )
{
	keysymdb[0].name = "Miscellaneous";
	keysymdb[0].size = Misc_DB_Length;
	for( i=0; i<Misc_DB_Length; i++ )
		keysymdb[0].keysyms[i] = miscdb[i];
	
	keysymdb[1].name = "Modifiers";
	keysymdb[1].size = Modifier_DB_Length;
	for( i=0; i<Modifier_DB_Length; i++ )
		keysymdb[1].keysyms[i] = modifierdb[i];

	keysymdb[2].name = "Japanese";
	keysymdb[2].size = Japanese_DB_Length;
	for( i=0; i<Japanese_DB_Length; i++ )
		keysymdb[2].keysyms[i] = japanesedb[i];

	keysymdb[3].name = "ISO-9995";
	keysymdb[3].size = iso9995_DB_Length;
	for( i=0; i<iso9995_DB_Length; i++ )
		keysymdb[3].keysyms[i] = iso9995db[i];
	
	keysymdb[4].name = "i3270";
	keysymdb[4].size = i3270_DB_Length;
	for( i=0; i<i3270_DB_Length; i++ )
		keysymdb[4].keysyms[i] = i3270db[i];

	keysymdb[5].name = "Latin";
	keysymdb[5].size = Latin_DB_Length;
	for( i=0; i<Latin_DB_Length; i++ )
		keysymdb[5].keysyms[i] = latindb[i];
							
	keysymdb[6].name = "Arabic";
	keysymdb[6].size = Arabic_DB_Length;
	for( i=0; i<Arabic_DB_Length; i++ )
		keysymdb[6].keysyms[i] = arabicdb[i];
	
	keysymdb[7].name = "Cyrillic";
	keysymdb[7].size = Cyrillic_DB_Length;
	for( i=0; i<Cyrillic_DB_Length; i++ )
		keysymdb[7].keysyms[i] = cyrillicdb[i];

	keysymdb[8].name = "Greek";
	keysymdb[8].size = Greek_DB_Length;
	for( i=0; i<Greek_DB_Length; i++ )
		keysymdb[8].keysyms[i] = greekdb[i];

	keysymdb[9].name = "Technical";
	keysymdb[9].size = Technical_DB_Length;
	for( i=0; i<Technical_DB_Length; i++ )
		keysymdb[9].keysyms[i] = technicaldb[i];

	keysymdb[10].name = "Publishing";
	keysymdb[10].size = Publishing_DB_Length;
	for( i=0; i<Publishing_DB_Length; i++ )
		keysymdb[10].keysyms[i] = publishingdb[i];

	keysymdb[11].name = "Hebrew";
	keysymdb[11].size = Hebrew_DB_Length;
	for( i=0; i<Hebrew_DB_Length; i++ )
		keysymdb[11].keysyms[i] = hebrewdb[i];

	keysymdb[12].name = "Thai";
	keysymdb[12].size = Thai_DB_Length;
	for( i=0; i<Thai_DB_Length; i++ )
		keysymdb[12].keysyms[i] = thaidb[i];

	keysymdb[13].name = "Korean";
	keysymdb[13].size = Korean_DB_Length;
	for( i=0; i<Korean_DB_Length; i++ )
		keysymdb[13].keysyms[i] = koreandb[i];

	keysymdb[14].name = "Armenian";
	keysymdb[14].size = Armenian_DB_Length;
	for( i=0; i<Armenian_DB_Length; i++ )
		keysymdb[14].keysyms[i] = armeniandb[i];

	keysymdb[15].name = "Georgian";
	keysymdb[15].size = Georgian_DB_Length;
	for( i=0; i<Georgian_DB_Length; i++ )
		keysymdb[15].keysyms[i] = georgiandb[i];

	keysymdb[16].name = "Currency";
	keysymdb[16].size = Currency_DB_Length;
	for( i=0; i<Currency_DB_Length; i++ )
		keysymdb[16].keysyms[i] = currencydb[i];

	keysymdb[17].name = "Katakana";
	keysymdb[17].size = Katakana_DB_Length;
	for( i=0; i<Katakana_DB_Length; i++ )
		keysymdb[17].keysyms[i] = katakanadb[i];
}
