/* -------------------------------------------------*
 * ---------------------WMKeyboard------------------*
 * ----Author: Dimitris Economou <trackman@mfa.gr>--*
 * ------This program is distributed under the------*
 * --------------------GPL license.-----------------*
 * -------------------------------------------------*/

#define DATE "February 18th, 2000"
#define VERSION "0.4"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <X11/Xlib.h>
#include <X11/xpm.h>
#include <X11/extensions/shape.h>
#include <X11/keysym.h>
#include "xpm/mask.xpm"

struct icon {
	Pixmap pixmap;
	Pixmap mask;
	XpmAttributes attributes;
	void load( char** xpm_name );
	void draw( int x, int y );
};

struct Keymap {
	icon flag, abbr, alt;
	char FlagIcon_filename[200];
	char Alternate_filename[200];
	char Initials_filename[200];
	char name[30];
	int keysyms_per_keycode;
	char *keysym_array[134][4];
};

struct KeymapBak {
	char *keysym_array[134][4];
};

KeymapBak keysym_array[50];

int num_of_keymaps = 0;
Keymap keymaps[50];
char buf[256];

Keymap *alang, *blang;
Keymap *templang;
Keymap lang1, lang2;

icon mask;

Display *dpy;
int scr;
int d_depth;
int x_fd;
Window root, win, iconwin;
Pixel back_pix, fore_pix;
XSizeHints mysizehints;
XWMHints mywmhints;
unsigned int borderwidth = 1;
XClassHint classHint;
XTextProperty name;
char *wname = "wmkbd";
GC NormalGC;
XGCValues gcv;
unsigned long gcm;
XEvent event;
char *Geometry = "";
int i;

#include "keysyms.c"

int min_keycodes, max_keycodes, num_of_keycodes;
KeyCode first_keycode;

char config_filename[100];
int SwitchMethod;
char DefaultKeymap[30];
char AlternateKeymap[30];

int flush_expose( Window w );
Pixel GetColor( char *name );

void save_options();

#include "option.c"

int load_keymaps( void )
{
	FILE *keymap_file;
	char Filename[200];
	
	sprintf( Filename, "%s/.wmkbd_keymaps", getenv( "HOME" ));
	
	if( ( keymap_file = fopen( Filename, "rb" )) == NULL )
	{
		fprintf( stderr, "Error opening %s\n", Filename );
		exit(1);
	}
	
	if(( fread( keysym_array, sizeof( KeymapBak ), num_of_keymaps, keymap_file)) != num_of_keymaps )
	{
		fprintf( stderr, "Error reading file: %s\n", Filename );
		exit(1);
	}
	
	for( i=0; i<num_of_keymaps; i++ )
		keymaps[i].keysym_array = keysym_array[i].keysym_array;
	
	fclose( keymap_file );
	
	for( i=0; i<num_of_keymaps; i++ )
	{
		if(( strncmp( keymaps[i].name, DefaultKeymap, strlen( DefaultKeymap )))==0 )
		{	
			alang = &keymaps[i];
			break;
		}
	}
	
	for( i=0; i<num_of_keymaps; i++ )
	{	
		if(( strncmp( keymaps[i].name, AlternateKeymap, strlen( AlternateKeymap )))==0 )
		{
			blang = &keymaps[i];
			break;
		}
	}
}

int load_saved_options()
{	
	FILE *config_file;
	
	int done;
	
	sprintf( config_filename, "%s/.wmkbd", getenv( "HOME" ));
	
	if( ( config_file = fopen( config_filename, "r" )) == NULL )
	{
		fprintf( stderr, "Error opening %s\n", config_filename );
		exit(1);
	}
	
	fscanf( config_file, "SwitchMethod %d\n", &SwitchMethod );
	
	do{
		fgets( buf, 250, config_file );
		if( ( done = feof( config_file )) == 0 )
		{
			buf[ strlen( buf ) - 1 ] = 0;
			if( strncmp( buf, "DefaultKeymap ", strlen("DefaultKeymap "))==0)
				sprintf( DefaultKeymap, "%s", buf+strlen("DefaultKeymap "));
			if( strncmp( buf, "AlternateKeymap ", 
					strlen("AlternateKeymap "))==0)
				sprintf( AlternateKeymap, "%s",
					buf+strlen("AlternateKeymap "));
			if( strncmp( buf, "Keymap ", strlen("Keymap "))==0)
			{
				sprintf( keymaps[num_of_keymaps].name, "%s", 
					buf+strlen("Keymap "));
				fscanf( config_file, " FlagIcon %s", 
					&keymaps[num_of_keymaps].FlagIcon_filename );
				fscanf( config_file, " Initials %s", 
					&keymaps[num_of_keymaps].Initials_filename);
				fscanf( config_file, " AltIcon %s", 
					&keymaps[num_of_keymaps].Alternate_filename);
				keymaps[num_of_keymaps].keysyms_per_keycode=4;
				num_of_keymaps++;
			}
		}
	} while( done == 0 );
	
	fclose( config_file );
	
	return 1;
}

void nocolor( char *a, char *b )
{
	fprintf( stderr, "%s:can't %s %s\n", wname, a, b );
}

void RedrawWindow( void )
{
	alang->flag.draw( 5, 5 );
	alang->abbr.draw( 31, 4 );
	blang->alt.draw( 31, 49 );
	
	flush_expose( iconwin );
	XCopyArea( dpy, mask.pixmap, iconwin, NormalGC, 0, 0, mask.attributes.width,
		mask.attributes.height, 0, 0 );
	flush_expose( win );
	XCopyArea( dpy, mask.pixmap, win, NormalGC, 0, 0, mask.attributes.width,
		mask.attributes.height, 0, 0 );
}

void load_xpms( void )
{
	int i;
	
	for( i=0; i<num_of_keymaps; i++ )
	{
		XpmReadFileToPixmap( dpy, root, keymaps[i].FlagIcon_filename,
			&keymaps[i].flag.pixmap, &keymaps[i].flag.mask, 
			&keymaps[i].flag.attributes );
		XpmReadFileToPixmap( dpy, root, keymaps[i].Alternate_filename,
			&keymaps[i].alt.pixmap, &keymaps[i].alt.mask, 
			&keymaps[i].alt.attributes );
		XpmReadFileToPixmap( dpy, root, keymaps[i].Initials_filename,
			&keymaps[i].abbr.pixmap, &keymaps[i].abbr.mask, 
			&keymaps[i].abbr.attributes );
	}
	mask.load( mask_xpm );
}

void load_default_keysym_array( void )
{
	XChangeKeyboardMapping( dpy, min_keycodes, alang->keysyms_per_keycode,
			(KeySym *) alang->keysym_array, num_of_keycodes );
}

void setup_grab_keys( void )
{
#define grab_key( keysym, basemask ) \
	XGrabKey( dpy, XKeysymToKeycode( dpy, keysym ), basemask, root, False, \
			GrabModeAsync, GrabModeAsync ); \
	XGrabKey( dpy, XKeysymToKeycode( dpy, keysym ), basemask | LockMask, root, False, \
			GrabModeAsync, GrabModeAsync ); \
	XGrabKey( dpy, XKeysymToKeycode( dpy, keysym ), basemask | Mod2Mask, root, False, \
			GrabModeAsync, GrabModeAsync ); \
	XGrabKey( dpy, XKeysymToKeycode( dpy, keysym ), basemask | Mod2Mask | LockMask, \
			root, False, GrabModeAsync, GrabModeAsync );
	
	switch( SwitchMethod )	
	{
		case 1:
			grab_key( XK_Shift_L, Mod1Mask );
			grab_key( XK_Shift_R, Mod1Mask );
			grab_key( XK_Alt_L, ShiftMask );			
			grab_key( XK_Alt_R, ShiftMask );
			break;
		case 2:
			grab_key( XK_Shift_L, ControlMask );
			grab_key( XK_Shift_R, ControlMask );
			grab_key( XK_Control_L, ShiftMask );
			grab_key( XK_Control_R, ShiftMask );
			break;
		case 3:
			grab_key( XK_Shift_L, ShiftMask );
			grab_key( XK_Shift_R, ShiftMask );
			break;
		default:
			grab_key( XK_Shift_L, Mod1Mask );
			grab_key( XK_Shift_R, Mod1Mask );
			grab_key( XK_Alt_L, ShiftMask );
			grab_key( XK_Alt_R, ShiftMask );
			break;
	}
#undef grab_key
}

int mouse_checkifswitch( XEvent *event )
{
	if( event->xkey.keycode==XKeysymToKeycode( dpy, XK_Pointer_Button3 ))
		return 1;
	
	return 0;
#undef check_key
}

int checkifswitch( XEvent *event )
{
#define check_key( keysym, mask ) ((( event->xkey.state & mask ) == mask && event->xkey.keycode == XKeysymToKeycode( dpy, keysym )))
	
	if ( check_key( XK_Shift_L, Mod1Mask ) || check_key( XK_Shift_R, Mod1Mask ) || 
		check_key( XK_Alt_L, ShiftMask ) || 
		check_key( XK_Alt_R, ShiftMask ) ||
		check_key( XK_Shift_L, ControlMask ) ||
		check_key( XK_Shift_R, ControlMask ) ||
		check_key( XK_Control_L, ShiftMask ) ||
		check_key( XK_Control_R, ShiftMask ) ||
		check_key( XK_Shift_L, ShiftMask ) ||
		check_key( XK_Shift_R, ShiftMask ))
		return 1;
	
	return 0;	
#undef check_key
}

void save_keymaps( void )
{
	FILE *keymap_file;
	char Filename[200];
	
	for( i=0; i<num_of_keymaps; i++ )
	{
		keysym_array[i].keysym_array = keymaps[i].keysym_array;
	}
	
	sprintf( Filename, "%s/.wmkbd_keymaps", getenv( "HOME" ));
	
	if( ( keymap_file = fopen( Filename, "wb" )) == NULL )
	{
		fprintf( stderr, "Error opening %s\n", Filename );
		exit(1);
	}
	
	if(( fwrite( keysym_array, sizeof( KeymapBak ), num_of_keymaps, keymap_file )) != num_of_keymaps )
	{
		fprintf( stderr, "Error writing to file: %s\n", Filename );
		exit(1);
	}
	
	fclose( keymap_file );

	CloseWindow( window, NULL );
}

void save_options( void )
{
	FILE *config_file;
	int i;
	
	if( ( config_file = fopen( config_filename, "w+" )) == NULL )
	{
		fprintf( stderr, "Error opening %s\n", config_filename );
		exit(1);
	}
	
	fprintf( config_file, "SwitchMethod %d\n", SwitchMethod );	

	sprintf( DefaultKeymap, "%s", gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( combo_default )->entry)));
	fprintf( config_file, "DefaultKeymap %s\n", DefaultKeymap );
	
	sprintf( AlternateKeymap, "%s", gtk_entry_get_text( GTK_ENTRY( GTK_COMBO( combo_alternate )->entry)));
	fprintf( config_file, "AlternateKeymap %s\n\n", AlternateKeymap );
	
	for( i=0; i<num_of_keymaps; i++ )
	{
		fprintf( config_file, "Keymap %s\n", keymaps[i].name );
		fprintf( config_file, "   FlagIcon %s\n", keymaps[i].FlagIcon_filename );
		fprintf( config_file, "   Initials %s\n", keymaps[i].Initials_filename );
		fprintf( config_file, "   AltIcon %s\n", keymaps[i].Alternate_filename );
	}
	
	fclose( config_file );
	
	save_keymaps();
}

void SaveCurrentKeymap( char *name )
{
	KeySym *keysyms;
	int i, j;
	
	sprintf( keymaps[num_of_keymaps].name, "%s", name );
	keysyms =	XGetKeyboardMapping( dpy, first_keycode, num_of_keycodes, 
			&keymaps[0].keysyms_per_keycode );
	printf( "Keysyms per keycode = %d\n", keymaps[num_of_keymaps].keysyms_per_keycode );
	
	for( i=0; i<134; i++ )
	{
		for( j=0; j<4; j++ )
		{
			keymaps[num_of_keymaps].keysym_array[i][j] = (char *) keysyms[((i*4)+j)];
		}	
	}	
	
	num_of_keymaps++;
}

void version( void )
{
	printf( "WMKeyboard v/%s %s By Dimitris Economou <trackman@mfa.gr>\n", VERSION, DATE );
	exit(0);
}

void help( void )
{
	printf( "WMKeyboard v/%s By Dimitris Economou <trackman@mfa.gr>\n", VERSION );
	printf( "Options:\n" );
	printf( "\t-g [string] : Grab current keyboard mapping and add to keymap list\n\t\t with the name [string]\n" );
	printf( "\t-h,-help : Display help menu\n" );
	printf( "\t-v,-version : Display version information\n" );
	exit(0);
}

int main ( int argc, char *argv[] )
{
	load_saved_options();
	load_keymaps();
	
	if (!(dpy = XOpenDisplay("")))
	{
		fprintf( stderr, "Can't open display.\n" );
		exit(1);
	}
	
	scr 	= DefaultScreen( dpy );
	root 	= RootWindow( dpy, scr );
	d_depth = DefaultDepth( dpy, scr );
	x_fd 	= XConnectionNumber( dpy );
	
	back_pix = GetColor( "white" );
	fore_pix = GetColor( "black" );
	
	load_xpms();
	
	// Initialize Keyboard Variables
	XDisplayKeycodes( dpy, &min_keycodes, &max_keycodes );
	first_keycode=min_keycodes;
	num_of_keycodes=max_keycodes-min_keycodes;
	
	for( i=1; i<argc; i++ )
	{
		if( strcmp( argv[i], "-h" )==0 )
			help();
		
		if( strcmp( argv[i], "-help" )==0 )
			help();
		
		if( strcmp( argv[i], "--help" )==0 )
			help();
		
		if( strcmp( argv[i], "--version" )==0 )
			version();
			
		if( strcmp( argv[i], "-version" )==0 )
			version();
			
		if( strcmp( argv[i], "-v" )==0 )
			version();
			
		if( strcmp( argv[i], "-g" )==0 )
			SaveCurrentKeymap( argv[i+1] );
	}
	
	load_default_keysym_array();
	
	mysizehints.flags = USSize | USPosition;
	mysizehints.x = 0;
	mysizehints.y = 0;
	
	XWMGeometry( dpy, scr, Geometry, NULL, borderwidth, &mysizehints,
		&mysizehints.x, &mysizehints.y, &mysizehints.width,
		&mysizehints.height, &i );
	
	mysizehints.width = mask.attributes.width;
	mysizehints.height = mask.attributes.height;
	
	win = XCreateSimpleWindow( dpy, root, mysizehints.x, mysizehints.y,
			mysizehints.width, mysizehints.height, borderwidth,
			fore_pix, back_pix );
	
	iconwin = XCreateSimpleWindow( dpy, win, mysizehints.x, mysizehints.y,
			mysizehints.width, mysizehints.height, borderwidth,
			fore_pix, back_pix );
	
	XSetWMNormalHints( dpy, win, &mysizehints );
	classHint.res_name = "wmkbd";
	classHint.res_class = "WMKeyboard";
	XSetClassHint( dpy, win, &classHint );
	
	XSelectInput( dpy, win, ExposureMask | ButtonPressMask | StructureNotifyMask );
	XSelectInput( dpy, iconwin, ExposureMask | ButtonPressMask | StructureNotifyMask );
	
	if ( XStringListToTextProperty( &wname, 1, &name ) ==0 )
	{
		fprintf( stderr, "%s: can't allocate window name\n", wname );
		exit(1);
	}
	
	XSetWMName( dpy, win, &name );
	
	// Create a Graphics Context
	gcm = GCForeground | GCBackground | GCGraphicsExposures;
	gcv.foreground = fore_pix;
	gcv.background = back_pix;
	gcv.graphics_exposures = 0;
	NormalGC = XCreateGC( dpy, root, gcm, &gcv );
	
	if ( 1 )
	{
		XShapeCombineMask( dpy, win, ShapeBounding, 0, 0, mask.mask,
			ShapeSet );
		XShapeCombineMask( dpy, iconwin, ShapeBounding, 0, 0, mask.mask,
			ShapeSet );
	}
	
	mywmhints.initial_state = WithdrawnState;
	mywmhints.icon_window = iconwin;
	mywmhints.icon_x = mysizehints.x;
	mywmhints.icon_y = mysizehints.y;
	mywmhints.window_group = win;
	mywmhints.flags = StateHint | IconWindowHint | IconPositionHint | WindowGroupHint;
	XSetWMHints( dpy, win, &mywmhints );
	
	XSetCommand( dpy, win, argv, (int) argc );
	XMapWindow( dpy, win );
	
	RedrawWindow();
	
	setup_grab_keys();
	
	while (1) {
		XNextEvent( dpy, &event );
		
		switch ( event.type )
		{
			case Expose:
				RedrawWindow();
				break;
			case KeyPress:
				if( checkifswitch( &event ))
				{
					templang=alang;
					alang=blang;
					blang=templang;
					load_default_keysym_array();
					RedrawWindow();
				}
				else
					break;
				break;
			case ButtonPress:
				if( mouse_checkifswitch( &event ))
				{
					templang=alang;
					alang=blang;
					blang=templang;
					load_default_keysym_array();
					RedrawWindow();
				}
				else
					OptionsWindow();
				break;
			case DestroyNotify:
				XFreeGC( dpy, NormalGC );
				XDestroyWindow( dpy, win );
				XDestroyWindow( dpy, iconwin );
				break;
			default:
				break;
		}
		XFlush( dpy );
	}
	return 0;
}

void icon::load( char** xpm_array )
{
	attributes.valuemask |= ( XpmReturnPixels | XpmReturnExtensions );
	int ret = XpmCreatePixmapFromData( dpy, root, xpm_array, &pixmap, 
			&mask, &attributes );
	
	if( ret != XpmSuccess )
	{
		fprintf( stderr, "Error loading pixmap.\n" );
		exit(1);
	}
}

void icon::draw( int x, int y )
{
	XCopyArea( dpy, pixmap, ::mask.pixmap, NormalGC, 0, 0, attributes.width,
		attributes.height, x, y );
}

Pixel GetColor( char *name )
{
	XColor color;
	XWindowAttributes attributes;
	
	XGetWindowAttributes( dpy, root, &attributes );
	color.pixel = 0;
	if (!(XParseColor( dpy, attributes.colormap, name, &color )))
	{
		nocolor( "parse", name );
	}
	else if(!(XAllocColor( dpy, attributes.colormap, &color )))
	{
		nocolor( "alloc", name );
	}
	
	return color.pixel;
}

int flush_expose( Window w )
{
	XEvent dummy;
	int i=0;
	
	while( XCheckTypedWindowEvent( dpy, w, Expose, &dummy ))
	{
		i++;
	}
	
	return i;
}
