/*
 * (C)opyright MMIV-MMV Anselm R. Garbe <garbeam at gmail dot com>
 * See LICENSE file for license details.
 */

/** \addtogroup liblitz 
 * This is the non-WIMP GUI-Toolkit
 * @{ */

#include <X11/Xlib.h>

#define MAX_ID			  20
#define MAX_BUF			 128

#define DEFAULT_FT_ALIGN	"center"
#define DEFAULT_FT_FAM	  "fixed"
#define DEFAULT_FT_SIZE	 "10"
#define DEFAULT_F_TEXT	  "#FFFFFF"
#define DEFAULT_N_TEXT	  "#FFFFFF"
#define DEFAULT_F_BG		"#666699"
#define DEFAULT_N_BG		"#888888"
#define DEFAULT_F_BORDER	"#9999CC"
#define DEFAULT_N_BORDER	"#BBBBBB"

typedef enum { WEST, NWEST, NORTH, NEAST, EAST,
    SEAST, SOUTH, SWEST, CENTER
} Align;

typedef struct Color Color;
typedef struct Fnt Fnt;
typedef struct Meter Meter;
typedef struct Draw Draw;
typedef struct Action Action;

struct Color {
    double r, g, b;
    char colstr[8];
};

struct Fnt {
    Align align;                /* EAST and WEST are valid, CENTER otherwise */
    char *font;
    double scale;               /* 10pt is like scale 10 */
};

struct Draw {
    int screen_num;
    Drawable drawable;
    GC gc;
    Color bg;
    Color fg;
    Color border[4];
    XRectangle rect;            /* relative rect */
    XRectangle *notch;          /* relative notch rect */
    Fnt fnt;
    char *text;
    int val;
    Color fill;
    void (*draw) (Display *, Draw *);
};

struct Action {
    char *name;
    void (*func) (void *obj, char *);
};

/* array.c */
void **attach_item_end(void **old, void *item, size_t size_item);
void **attach_item_begin(void **old, void *item, size_t size_item);
void **detach_item(void **old, void *item, size_t size_item);
int index_item(void **items, void *item);
int index_next_item(void **items, void *item);
int index_prev_item(void **items, void *item);
int count_items(void **items);

/* draw.c */
void draw_label(Display * dpy, Draw * r);
void draw_label_noborder(Display * dpy, Draw * r);
void draw_meter(Display * dpy, Draw * r);
int text_width(Display * dpy, char *font,
               double size, unsigned char *utf8txt);

/* util.c */
void str_to_align(Align * result, char *val);
char *button_to_str(unsigned int button);
unsigned int str_to_button(char *val);
char *mod_to_str(unsigned long mod);
void str_to_color(Color * c, char *val);
/* convenience function for border color quadrupels */
void str_to_color4(Color c[4], char *val);
void str_to_rect(Display * dpy, XRectangle * root, XRectangle * r,
                 char *val);
unsigned long str_to_mod(char *val);
char *chomp(char *val);
int is_point_in_rect(int x, int y, XRectangle * r);
int count_toks(char *str, char delim);
void tokenize(char **result, const char *str, char delim);
void free_toks(char **toks, int num_toks);
int rect_touches_rect(XRectangle * first, XRectangle * second);
int distance(XRectangle * origin, XRectangle * target);
void spawn(void *dpy, char *cmd);
/* returns after spawned process exits by itself */
void spawn_wait(void *dpy, char *cmd);
void swap(void **p1, void **p2);
int int_val(void *file_content);

/* wm.c */
int property(Display * dpy, Window w, Atom a, Atom t, long l,
             unsigned char **prop);
void win_prop(Display * dpy, Window w, Atom a, char *res, int len);
void send_message(Display * dpy, Window w, Atom a, long value);
void init_lock_modifiers(Display * dpy, unsigned int *valid_mask,
                         unsigned int *num_lock_mask);

/* @} */
